<?php
class Kkm_model extends CI_Model {
	function __construct() {
		parent::__construct ();
	}
	function get_isactive_modules (){//визначення стану активності модуля(ів)\повертає масив: "назва модуля" => "стан"
		//аргументи - назви модулів, при відсутністі повертає всі з таблиці modules
		$rez_arr = array();
		$args_count = func_num_args();
		if($args_count > 0){
			$modules_names_str = implode("', '", func_get_args());
			$modules_names_str = "'".$modules_names_str."'";
			$query = $this->db->query ( "SELECT name, is_active FROM modules WHERE name IN ($modules_names_str)" );
		}else{
			$query = $this->db->query ( "SELECT name, is_active FROM modules");
		}
		if ($query->num_rows() > 0){
			foreach ( $query->result () as $row ) {
				$rez_arr [$row->name] = $row->is_active;
			}
		}
		return $rez_arr;
	}
	function save_kkm_device($data){
		$kkm_device['NumDevice'] = $data['NumDevice'];
		$kkm_device['IdDevice'] = $data['IdDevice'];
		$kkm_device['OnOff'] = $data['OnOff'];
		$kkm_device['Active'] = $data['Active'];
		$kkm_device['TypeDevice'] = $data['TypeDevice'];
		$kkm_device['IdTypeDevice'] = $data['IdTypeDevice'];
		$kkm_device['IP'] = $data['IP'];
		$kkm_device['NameDevice'] = $data['NameDevice'];
		$kkm_device['UnitName'] = $data['UnitName'];
		$kkm_device['KktNumber'] = $data['KktNumber'];
		$kkm_device['INN'] = $data['INN'];
		$kkm_device['RegNumber'] = $data['RegNumber'];
		$kkm_device['FnNumber'] = $data['FnNumber'];
		$kkm_device['InnOfd'] = $data['InnOfd'];
		$kkm_device['NameOrganization'] = $data['NameOrganization'];
		$kkm_device['AddressSettle'] = $data['AddressSettle'];
		$kkm_device['TaxVariant'] = $data['TaxVariant'];
		$kkm_device['AddDate'] = $data['AddDate'];
		$kkm_device['OFD_Error'] = $data['OFD_Error'];
		$kkm_device['OFD_NumErrorDoc'] = $data['OFD_NumErrorDoc'];
		$kkm_device['OFD_DateErrorDoc'] = $data['OFD_DateErrorDoc'];
		$kkm_device['FN_DateEnd'] = $data['FN_DateEnd'];
		$kkm_device['FN_MemOverflowl'] = $data['FN_MemOverflowl'];
		$kkm_device['FN_IsFiscal'] = $data['FN_IsFiscal'];
		$kkm_device['PaperOver'] = $data['PaperOver'];
		$kkm_devices_tbl_name = "kkm_devices";
		$sql_str = $this->db->insert_string($kkm_devices_tbl_name, $kkm_device);
		$sql_str .= " ON DUPLICATE KEY ";
		unset($kkm_device['IdDevice']);
		$sql_str .= $this->db->update_string($kkm_devices_tbl_name, $kkm_device, "1");
		$sql_str = str_replace( " `". $kkm_devices_tbl_name ."` SET", "", $sql_str );
		$sql_str = str_replace( " WHERE 1", "", $sql_str );
		$this->db->query ( $sql_str );
	}
	function update_kkm_device($data){
		$kkm_devices_tbl_name = "kkm_devices";
		if ($data['is_default'] == 1){
			$this->db->set('is_default', 0);
			$this->db->where('partner_id', $data['partner_id']);
			$this->db->update($kkm_devices_tbl_name);
		}
		$sql_str = "INSERT INTO ".$kkm_devices_tbl_name." (id, NameDevice, is_default, partner_id)
					VALUES (".$data['edit_kkm_id'].",'".$data['NameDevice']."', ".$data['is_default'].", ".$data['partner_id'].")
					ON DUPLICATE KEY UPDATE NameDevice='".$data['NameDevice']."', is_default=".$data['is_default'].", partner_id=".$data['partner_id'];
		$this->db->query ( $sql_str );
		if (isset($data['selected_TaxVariant'])) {
		    $row = $this->db->select('TaxVariant')->get_where($kkm_devices_tbl_name, array('id'=>$data['edit_kkm_id']))->row();
		    if ($row) {
		        $all_TaxVariants = explode( ',', $row->TaxVariant);
		        $all_TaxVariants = array_flip($all_TaxVariants);
		        unset($all_TaxVariants[$data['selected_TaxVariant']]);
		        $all_TaxVariants = array_flip($all_TaxVariants);
		        array_unshift($all_TaxVariants, $data['selected_TaxVariant']);
		        $all_TaxVariants = implode(',', $all_TaxVariants);
		        $this->db->update($kkm_devices_tbl_name, array('TaxVariant'=>$all_TaxVariants), array('id'=>$data['edit_kkm_id']));
		    }
		}
	}
	function get_kkm_devices_list($params = array()){
	    $where_arr = array();
	    if (isset($params['partner_id'])){
	        $where_arr['partner_id'] = $params['partner_id'];
	    }
	    $deviceslist = $this->db->get_where('kkm_devices', $where_arr)->result_array();
		return $deviceslist;
	}
	function get_kkm_device_by_id($id){
		$device = array();
		$query = $this->db->query ( "SELECT * FROM kkm_devices WHERE id=".$id);
		if ($query->num_rows() > 0){
			return $query->row_array();
		}
		return 0;
	}
	function delete_kkm_device ( $kkm_id){
		$kkm_devices_tbl_name = "kkm_devices";
		$this->db->delete($kkm_devices_tbl_name, array('id' => $kkm_id));
	}
	function get_RegisterCheck_strings ($check_data){
		$data = array();
		$data["NumDevice"] = 0;
		$data["IdDevice"] = "";
		if ($this->kkm_model->get_device_policy() == 1 && isset($check_data ['selected_kkmdevice'])) {
			$data["IdDevice"] = $check_data ['selected_kkmdevice'];
		}
		$data["Command"] = "RegisterCheck";
		$data["InnKkm"] = "";
		$data["KktNumber"] = "";
		$data["Timeout"] = 30;
		$data["IdCommand"] = "";
		$data["IsFiscalCheck"] = true;
		$data["TypeCheck"] = $check_data["TypeCheck"];
		$data["NotPrint"] = false;
		$data["NumberCopies"] = 0;
		$data["CashierName"] = $check_data["CashierName"];
		$data["CashierVATIN"] = $check_data["CashierVATIN"];;
		$data["ClientAddress"] = $check_data ['send_check_by']; //$this->get_ClientEmailAddress($check_data['reservation_id']);
		$data["SenderEmail"] = $this->get_SenderEmailAddress($check_data['id_partner']);;
		$data["TaxVariant"] = $check_data["TaxVariant"];
		$data["KPP"] = "782543005";
		$data["KPP"] = "";
			// "CheckProps"=> array ( array ( "Print"=>true, "PrintInHeader"=>true, "Teg"=> 1005, "Prop"=>"Москва, ул. Трехгорка д.13"),
			// array ( "Print"=>true, "PrintInHeader"=>true, "Teg"=>1073, "Prop"=>"8(985)775-44-61"),
			// array ( "Print"=>true, "PrintInHeader"=>true, "Teg"=>1117, "Prop"=>"garbuzd@gmail.com")
			// ),
		$data ["AdditionalProps"] = array (
				array (
						"Print" => true,
						"PrintInHeader" => true,
						"NameProp" => "Служебный номер чека",
						"Prop" => ""
				)
		);
// 		"ClientId"=>"e1e0c5dbb395acecda9e3ed86a798755b21a53de",
		$data["CheckStrings"] = array();
		if (isset($check_data["items_to_register"])) {
		foreach ( $check_data["items_to_register"] as $item_to_register ) {
			$tmp = array ();
			$tmp ["PrintText"] ["Text"] = "";
			$tmp ["Register"] ["Name"] = $item_to_register ["Name"];
			$tmp ["Register"] ["Quantity"] = $item_to_register ["Quantity"];
			$tmp ["Register"] ["Price"] = $item_to_register ["Price"];
			$tmp ["Register"] ["Amount"] = $item_to_register ["Amount"];
			$tmp ["Register"] ["Department"] = 0;
			$tmp ["Register"] ["Tax"] = $item_to_register ["Tax"];;
			$tmp ["Register"] ["SignMethodCalculation"] = $item_to_register ["MethodCalculation"];
			$tmp ["Register"] ["SignCalculationObject"] = $item_to_register["SignCalculationObject"];
			array_push ( $data ["CheckStrings"], $tmp );
			// $data["CheckStrings"][]["Register"]["MeasurementUnit"]= "";
			// $data["CheckStrings"][]["Register"]["NomenclatureCode"]= "";
		}
		}
		$data["Cash"]= $check_data["Cash"];
		$data["ElectronicPayment"]= $check_data["ElectronicPayment"];
		$data["AdvancePayment"]= $check_data["AdvancePayment"];
		return $data;
	}

	public function get_RegisterCheck_strings_data($post) {
	    // Признак способа расчета. тег ОФД 1214. Для ФФД.1.05 и выше обязательное поле
	    // 1: "ПРЕДОПЛАТА 100% (Полная предварительная оплата до момента передачи предмета расчета)"
	    // 2: "ПРЕДОПЛАТА (Частичная предварительная оплата до момента передачи предмета расчета)"
	    // 3: "АВАНС"
	    define('ADVANCE_METHOD', 3);
	    // 4: "ПОЛНЫЙ РАСЧЕТ (Полная оплата, в том числе с учетом аванса в момент передачи предмета расчета)"
	    define('FULLPAY_METHOD', 4);
	    // 5: "ЧАСТИЧНЫЙ РАСЧЕТ И КРЕДИТ (Частичная оплата предмета расчета в момент его передачи с последующей оплатой в кредит )"
	    // 6: "ПЕРЕДАЧА В КРЕДИТ (Передача предмета расчета без его оплаты в момент его передачи с последующей оплатой в кредит)"
	    // 7: "ОПЛАТА КРЕДИТА (Оплата предмета расчета после его передачи с оплатой в кредит )"

	    // Признак предмета расчета. тег ОФД 1212. Для ФФД.1.1 и выше обязательное поле
	    // 1: "ТОВАР (наименование и иные сведения, описывающие товар)"
	    define('GOODS_OBJECT', 1);
	    // 2: "ПОДАКЦИЗНЫЙ ТОВАР (наименование и иные сведения, описывающие товар)"
	    // 3: "РАБОТА (наименование и иные сведения, описывающие работу)"
	    // 4: "УСЛУГА (наименование и иные сведения, описывающие услугу)"
	    define('SERVICE_OBJECT', 4);
	    // 5: "СТАВКА АЗАРТНОЙ ИГРЫ (при осуществлении деятельности по проведению азартных игр)"
	    // 6: "ВЫИГРЫШ АЗАРТНОЙ ИГРЫ (при осуществлении деятельности по проведению азартных игр)"
	    // 7: "ЛОТЕРЕЙНЫЙ БИЛЕТ (при осуществлении деятельности по проведению лотерей)"
	    // 8: "ВЫИГРЫШ ЛОТЕРЕИ (при осуществлении деятельности по проведению лотерей)"
	    // 9: "ПРЕДОСТАВЛЕНИЕ РИД (предоставлении прав на использование результатов интеллектуальной деятельности или средств индивидуализации)"
	    // 10: "ПЛАТЕЖ (аванс, задаток, предоплата, кредит, взнос в счет оплаты, пени, штраф, вознаграждение, бонус и иной аналогичный предмет расчета)"
	    define('PAYMENT_OBJECT', 10);
	    // 11: "АГЕНТСКОЕ ВОЗНАГРАЖДЕНИЕ (вознаграждение (банковского)платежного агента/субагента, комиссионера, поверенного или иным агентом)"
	    // 12: "СОСТАВНОЙ ПРЕДМЕТ РАСЧЕТА (предмет расчета, состоящем из предметов, каждому из которых может быть присвоено вышестоящее значение"
	    // 13: "ИНОЙ ПРЕДМЕТ РАСЧЕТА (предмет расчета, не относящемуся к предметам расчета, которым может быть присвоено вышестоящее значение"

	    $reservation_id = $post['reservation_id'];
	    $pay_method = $post['pay_method'];
	    $id_partner = $post['id_partner'];
	    $amount = number_format($post['amount'], 2, ".", "");
	    $MethodCalculation = $post['MethodCalculation'];
	    $pay_id = $post['pay_id'];

	    $payment_form = $this->get_payment_form($pay_method);
	    $partner_nds = $this->get_partner_nds_for_check(array('id_partner' => $id_partner, 'MethodCalculation' => $MethodCalculation));
	    $cashier = $this->get_cashier_data();

	    $check = $errors = array();
	    $check["NumDevice"] = 0;
	    $check["IdDevice"] = isset($post ['selected_kkmdevice']) ? $post ['selected_kkmdevice'] : "";
	    $check["Command"] = "RegisterCheck";
	    $check["InnKkm"] = "";
	    $check["KktNumber"] = "";
	    $check["Timeout"] = 30;
	    $check["IdCommand"] = isset($post ['IdCommand']) ? isset($post ['IdCommand']) : "";// або тут формувати унікальну ІД команди, наразі формує скріпт Data.IdCommand = guid(); і норм.
	    $check["IsFiscalCheck"] = true;
	    $check["TypeCheck"] = $post['TypeCheck'];
	    $check["NotPrint"] = false;
	    $check["NumberCopies"] = 0;
	    $check["CashierName"] = $cashier['name'];
	    $check["CashierVATIN"] = $cashier['vatin'];
	    $check["ClientAddress"] = $post['send_check_by'];
	    $check["SenderEmail"] = $this->get_SenderEmailAddress($id_partner);
	    $check["TaxVariant"] = isset($post["TaxVariant"]) ? $post["TaxVariant"] : '';
	    $check["Cash"] = $payment_form == 1 ? $amount : 0;
	    $check["ElectronicPayment"] = $payment_form != 1 ? $amount : 0;
	    $check ["AdvancePayment"] = 0;
	    $check["CheckStrings"] = array();

	    $strings_to_register = array();
	    switch ($MethodCalculation) {
	        case ADVANCE_METHOD :
	            $this->pay_c2->correct_old_advanced_payment($reservation_id, $id_partner); // вияснити чи це ще актуально!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                array_push($strings_to_register, array(
                    'Name' => 'Авансовый платеж', // Зачисление на счет
                    'Quantity' => 1,
                    'Price' => $amount,
                    'Amount' => $amount,
                    'Tax' => $partner_nds,
                    'SignCalculationObject' => PAYMENT_OBJECT,
                    'SignMethodCalculation' => ADVANCE_METHOD
                ));
	            break;
	        case FULLPAY_METHOD :
                $where_str = "";
                $AdvancePaymentsSum = 0;
                $query_advances = $this->db->select('payment.id as payment_id, payment.amount as payment_amount')
                    ->get_where('payment', "payment.parent_id = $pay_id AND payment.refund_id = 0")->result();
                foreach ($query_advances as $advance){
                    $AdvancePaymentsSum += $advance->payment_amount;
                    $where_str .= " check_payment_id = $advance->payment_id OR ";
                }
                $where_str .=" check_payment_id = $pay_id";
                $check ["AdvancePayment"] = number_format($AdvancePaymentsSum, 2, ".", "");
                $items = array();
                $query_result = $this->db->query("SELECT item_id as service_id, SUM(check_payment_items.amount) as service_amount, item_service_table_id as tbl_id,
                    									services_types.name as name_s, services_types.kind_id, services.count,
                                                        services_types_main.name as name_sm, services_types_main.id as type_sm,
                    									taxes_fees2property.name as name_tf, services_tf.taxes_fees_id
                									FROM check_payment_items
                									LEFT JOIN services_main ON services_main.id = check_payment_items.item_id
                									LEFT JOIN services_types_main ON  services_types_main.id = services_main.type
                									LEFT JOIN services ON services.id = check_payment_items.item_id
                									LEFT JOIN services_types ON  services_types.id = services.type
                									LEFT JOIN services_tf ON services_tf.id = check_payment_items.item_id
                									LEFT JOIN taxes_fees2property ON taxes_fees2property.id = services_tf.taxes_fees_id
                								    WHERE $where_str GROUP BY service_id")->result();
                foreach ($query_result as $row){
                    switch ($row->tbl_id) {
                        case 1: // services
                            array_push($items, array(
                                'services_id' => $row->service_id,
                                'count' => $row->count,
                                'amount' => $row->service_amount,
                                'name' => $row->name_s,
                                'kind_id' => $row->kind_id
                            ));
                            break;
                        case 2://main services
                            switch ($row->type_sm) {
                                case 1: // main service projivanie
                                    if ($this->releases->kkm_check_main_service1_nomenclatura()){
                                        $for_nomenclatura = array(
                                            'reservation_id' => $reservation_id,
                                            'pay_id' => $pay_id,
                                            'service_amount' => $row->service_amount
                                        );
                                        $main_service1_items = $this->kkm_model->get_main_service1_nomenclatura_items($for_nomenclatura);
                                        if (!empty($main_service1_items)){
                                            $include_fullname = $this->releases->nomenclatura_include_fullname_state();
                                            foreach ($main_service1_items as $main_service1_item) {
                                                array_push ( $items, array (
                                                    'services_id' => $row->service_id,
                                                    'count' => $main_service1_item->count,
                                                    'price' => number_format($main_service1_item->price, 2, ".", ""),
                                                    'amount' => number_format($main_service1_item->amount, 2, ".", ""),
                                                    'name' => $row->name_sm . (($include_fullname) ? ", $main_service1_item->name" : ''),
                                                    'kind_id' => SERVICE_OBJECT,// всегда услуга
                                                ) );
                                            }
                                            break;
                                        }
                                    }
                                default:
                                    array_push($items, array(
                                        'services_id' => $row->service_id,
                                        'count' => 1,
                                        'amount' => $row->service_amount,
                                        'name' => $row->name_sm,
                                        'kind_id' => SERVICE_OBJECT // всегда услуга
                                    ));
                            }
                            break;
                        case 3: // services tax & fees
                            array_push($items, array(
                                'services_id' => $row->service_id,
                                'count' => 1,
                                'amount' => $row->service_amount,
                                'name' => $row->name_tf,
                                'kind_id' => SERVICE_OBJECT // всегда услуга
                            ));
                            break;
                    }
                }
                foreach ($items as $item){
                    array_push($strings_to_register, array(
                        'Name' => $item ["name"], // Зачисление на счет
                        'Quantity' => $item ["count"],
                        'Price' => isset($item ["price"]) ? $item ["price"] : number_format($item ["amount"] / $item ["count"], 2, ".", ""),
                        'Amount' => $item ["amount"],
                        'Tax' => $partner_nds,
                        'SignCalculationObject' => ($item ["kind_id"] == 2) ? GOODS_OBJECT : SERVICE_OBJECT,
                        'SignMethodCalculation' => FULLPAY_METHOD
                    ));
                }
                break;
	    }
	    if (empty($strings_to_register)){
	        //array_push($errors, array('msg'=>'Ошибка наполнения строк!'));
	        array_push($errors, array('msg'=>'Пустые строки чека, нет неоплаченых товаров или услуг!'));
	    }
	    if (empty($errors)){
	        foreach ($strings_to_register as $string_set) {
	            array_push($check["CheckStrings"], array('Register'=>$string_set));
	        }
	        $log_data = array(
	            'body' => json_encode($post),
	            'pay_id' => $pay_id,
	            'response' => "?",
	            'strings' => json_encode($check)
	        );
	        $this->db->insert('kkm_payment_log', $log_data);
	        $log_id = $this->db->insert_id();
	        $hms_id = $this->config->item('hotel_id');

	        $check ["AdditionalProps"] = array (
	            array (
	                "Print" => true,
	                "PrintInHeader" => true,
	                "NameProp" => "Служебный $hms_id/$reservation_id/$pay_id/$log_id",
	                "Prop" => ""
	            )
	        );
	    }
        return array(
            'check' => $check,
            'errors' => $errors,
        );
	}

	public function get_RegisterCheck_strings_data_best($post) {
	    // Признак способа расчета. тег ОФД 1214. Для ФФД.1.05 и выше обязательное поле
	    // 1: "ПРЕДОПЛАТА 100% (Полная предварительная оплата до момента передачи предмета расчета)"
	    // 2: "ПРЕДОПЛАТА (Частичная предварительная оплата до момента передачи предмета расчета)"
	    // 3: "АВАНС"
	    define('ADVANCE_METHOD', 3);
	    // 4: "ПОЛНЫЙ РАСЧЕТ (Полная оплата, в том числе с учетом аванса в момент передачи предмета расчета)"
	    define('FULLPAY_METHOD', 4);
	    // 5: "ЧАСТИЧНЫЙ РАСЧЕТ И КРЕДИТ (Частичная оплата предмета расчета в момент его передачи с последующей оплатой в кредит )"
	    // 6: "ПЕРЕДАЧА В КРЕДИТ (Передача предмета расчета без его оплаты в момент его передачи с последующей оплатой в кредит)"
	    // 7: "ОПЛАТА КРЕДИТА (Оплата предмета расчета после его передачи с оплатой в кредит )"

	    // Признак предмета расчета. тег ОФД 1212. Для ФФД.1.1 и выше обязательное поле
	    // 1: "ТОВАР (наименование и иные сведения, описывающие товар)"
	    define('GOODS_OBJECT', 1);
	    // 2: "ПОДАКЦИЗНЫЙ ТОВАР (наименование и иные сведения, описывающие товар)"
	    // 3: "РАБОТА (наименование и иные сведения, описывающие работу)"
	    // 4: "УСЛУГА (наименование и иные сведения, описывающие услугу)"
	    define('SERVICE_OBJECT', 4);
	    // 5: "СТАВКА АЗАРТНОЙ ИГРЫ (при осуществлении деятельности по проведению азартных игр)"
	    // 6: "ВЫИГРЫШ АЗАРТНОЙ ИГРЫ (при осуществлении деятельности по проведению азартных игр)"
	    // 7: "ЛОТЕРЕЙНЫЙ БИЛЕТ (при осуществлении деятельности по проведению лотерей)"
	    // 8: "ВЫИГРЫШ ЛОТЕРЕИ (при осуществлении деятельности по проведению лотерей)"
	    // 9: "ПРЕДОСТАВЛЕНИЕ РИД (предоставлении прав на использование результатов интеллектуальной деятельности или средств индивидуализации)"
	    // 10: "ПЛАТЕЖ (аванс, задаток, предоплата, кредит, взнос в счет оплаты, пени, штраф, вознаграждение, бонус и иной аналогичный предмет расчета)"
	    define('PAYMENT_OBJECT', 10);
	    // 11: "АГЕНТСКОЕ ВОЗНАГРАЖДЕНИЕ (вознаграждение (банковского)платежного агента/субагента, комиссионера, поверенного или иным агентом)"
	    // 12: "СОСТАВНОЙ ПРЕДМЕТ РАСЧЕТА (предмет расчета, состоящем из предметов, каждому из которых может быть присвоено вышестоящее значение"
	    // 13: "ИНОЙ ПРЕДМЕТ РАСЧЕТА (предмет расчета, не относящемуся к предметам расчета, которым может быть присвоено вышестоящее значение"

	    $cashier = $post['Cashier'];
	    $FiscalisingData = $post['FiscalisingData'];
	    $SelectedDevice = $post['SelectedDevice'];
	    $SessionForRecovery = $post['Session'];
	    $IdCommand = isset($post ['IdCommand']) ? $post ['IdCommand'] : "";

	    $reservation_id = $FiscalisingData['reservation_id'];
	    $pay_method = $FiscalisingData['pay_method'];
	    $id_partner = $FiscalisingData['id_partner'];
	    $amount = number_format($FiscalisingData['amount'], 2, ".", "");
	    $MethodCalculation = $FiscalisingData['MethodCalculation'];
	    $pay_id = $FiscalisingData['pay_id'];

	    $payment_form = $this->get_payment_form($pay_method);
	    $partner_nds = $this->get_partner_nds_for_check(array('id_partner' => $id_partner, 'MethodCalculation' => $MethodCalculation));
	    //$cashier = $this->get_cashier_data();

 	    $errors = array();
// 	    $sql = "SELECT t1.*, t2.id AS check_id
//                 FROM kkm_payment_log AS t1
//                 LEFT JOIN kkm_checks AS t2 ON t1.pay_id = t2.pay_or_ref_id AND t2.pay_or_ref = 0
//                 WHERE pay_id = $pay_id";
// 	    $payment_was_try_fiscalising = $this->db->query($sql)->row();
// 	    if($payment_was_try_fiscalising){
// 	        array_push($errors, array('msg'=>'Чек уже пробовали фискализировать!'));
// 	        return array(
// 	            'errors' => $errors,
// 	        );
// 	    }



	    $check = array();
	    $check["NumDevice"] = 0;
	    $check["IdDevice"] = isset($SelectedDevice ['Id']) ? $SelectedDevice ['Id'] : "";
	    $check["Command"] = "RegisterCheck";
	    $check["InnKkm"] = "";
	    $check["KktNumber"] = "";
	    $check["Timeout"] = 30;
	    $check["IdCommand"] = $IdCommand;// або тут формувати унікальну ІД команди, наразі формує скріпт Data.IdCommand = guid(); і норм.
	    $check["IsFiscalCheck"] = true;
	    $check["TypeCheck"] = $FiscalisingData['TypeCheck'];
	    $check["NotPrint"] = false;
	    $check["NumberCopies"] = 0;
	    $check["CashierName"] = $cashier['name'];
	    $check["CashierVATIN"] = $cashier['vatin'];
	    $check["ClientAddress"] = $FiscalisingData['send_check_by'];
	    $check["SenderEmail"] = $this->get_SenderEmailAddress($id_partner);
	    $check["TaxVariant"] = isset($FiscalisingData["TaxVariant"]) ? $FiscalisingData["TaxVariant"] : '';
	    $check["Cash"] = $payment_form == 1 ? $amount : 0;
	    $check["ElectronicPayment"] = $payment_form != 1 ? $amount : 0;
	    $check ["AdvancePayment"] = 0;
	    $check["CheckStrings"] = array();

	    $strings_to_register = array();
	    switch ($MethodCalculation) {
	        case ADVANCE_METHOD :
	            $this->pay_c2->correct_old_advanced_payment($reservation_id, $id_partner); // вияснити чи це ще актуально!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	            array_push($strings_to_register, array(
	                'Name' => 'Авансовый платеж', // Зачисление на счет
	                'Quantity' => 1,
	                'Price' => $amount,
	                'Amount' => $amount,
	                'Tax' => $partner_nds,
	                'SignCalculationObject' => PAYMENT_OBJECT,
	                'SignMethodCalculation' => ADVANCE_METHOD
	            ));
	            break;
	        case FULLPAY_METHOD :
	            $AdvancePaymentsSum = 0;
	            $query_advances = $this->db->select('payment.id as payment_id, payment.amount as payment_amount')
	            ->get_where('payment', "payment.parent_id = $pay_id AND payment.refund_id = 0")->result();
	            $where_str = " check_payment_id = $pay_id";
	            foreach ($query_advances as $advance){
	                $AdvancePaymentsSum += $advance->payment_amount;
	                $where_str .= " OR check_payment_id = $advance->payment_id ";
	            }
	            $check ["AdvancePayment"] = number_format($AdvancePaymentsSum, 2, ".", "");
	            $items = array();
	            $query_result = $this->db->query(
	                "SELECT item_id as service_id, SUM(check_payment_items.amount) as service_amount, item_service_table_id as tbl_id,
        	                services_types.name as name_s, services_types.kind_id, services.count,
        	                services_types_main.name as name_sm, services_types_main.id as type_sm,
        	                taxes_fees2property.name as name_tf, services_tf.taxes_fees_id
	                FROM check_payment_items
	                LEFT JOIN services_main ON services_main.id = check_payment_items.item_id
	                LEFT JOIN services_types_main ON  services_types_main.id = services_main.type
	                LEFT JOIN services ON services.id = check_payment_items.item_id
	                LEFT JOIN services_types ON  services_types.id = services.type
	                LEFT JOIN services_tf ON services_tf.id = check_payment_items.item_id
	                LEFT JOIN taxes_fees2property ON taxes_fees2property.id = services_tf.taxes_fees_id
	                WHERE $where_str
	                GROUP BY service_id"
	                )->result();
	            foreach ($query_result as $row){
	                switch ($row->tbl_id) {
	                    case 1: // services
	                        array_push($items, array(
	                        'services_id' => $row->service_id,
	                        'count' => $row->count,
	                        'amount' => $row->service_amount,
	                        'name' => $row->name_s,
	                        'kind_id' => $row->kind_id
	                        ));
	                        break;
	                    case 2://main services
	                        switch ($row->type_sm) {
	                            case 1: // main service projivanie
	                                if ($this->releases->kkm_check_main_service1_nomenclatura()){
	                                    $for_nomenclatura = array(
	                                        'reservation_id' => $reservation_id,
	                                        'pay_id' => $pay_id,
	                                        'service_amount' => $row->service_amount
	                                    );
	                                    $main_service1_items = $this->kkm_model->get_main_service1_nomenclatura_items($for_nomenclatura);
	                                    if (!empty($main_service1_items)){
	                                        $include_fullname = $this->releases->nomenclatura_include_fullname_state();
	                                        foreach ($main_service1_items as $main_service1_item) {
	                                            array_push ( $items, array (
	                                                'services_id' => $row->service_id,
	                                                'count' => $main_service1_item->count,
	                                                'price' => number_format($main_service1_item->price, 2, ".", ""),
	                                                'amount' => number_format($main_service1_item->amount, 2, ".", ""),
	                                                'name' => $row->name_sm . (($include_fullname) ? ", $main_service1_item->name" : ''),
	                                                'kind_id' => SERVICE_OBJECT,// всегда услуга
	                                            ) );
	                                        }
	                                        break;
	                                    }
	                                }
	                            default:
	                                array_push($items, array(
	                                'services_id' => $row->service_id,
	                                'count' => 1,
	                                'amount' => $row->service_amount,
	                                'name' => $row->name_sm,
	                                'kind_id' => SERVICE_OBJECT // всегда услуга
	                                ));
	                        }
	                        break;
	                    case 3: // services tax & fees
	                        array_push($items, array(
	                        'services_id' => $row->service_id,
	                        'count' => 1,
	                        'amount' => $row->service_amount,
	                        'name' => $row->name_tf,
	                        'kind_id' => SERVICE_OBJECT // всегда услуга
	                        ));
	                        break;
	                }
	            }
	            foreach ($items as $item){
	                array_push($strings_to_register, array(
	                    'Name' => $item ["name"], // Зачисление на счет
	                    'Quantity' => $item ["count"],
	                    'Price' => isset($item ["price"]) ? $item ["price"] : number_format($item ["amount"] / $item ["count"], 2, ".", ""),
	                    'Amount' => $item ["amount"],
	                    'Tax' => $partner_nds,
	                    'SignCalculationObject' => ($item ["kind_id"] == 2) ? GOODS_OBJECT : SERVICE_OBJECT,
	                    'SignMethodCalculation' => FULLPAY_METHOD
	                ));
	            }
	            break;
	    }
	    if (empty($strings_to_register)){
	        //array_push($errors, array('msg'=>'Ошибка наполнения строк!'));
	        array_push($errors, array('msg'=>'Пустые строки чека, нет неоплаченых товаров или услуг!'));
	    }
	    if (empty($errors)){
	        foreach ($strings_to_register as $string_set) {
	            array_push($check["CheckStrings"], array('Register'=>$string_set));
	        }
// 	        $log_data = array(
// 	            'body' => json_encode($post),
// 	            'pay_id' => $pay_id,
// 	            'response' => "?",
// 	            'strings' => json_encode($check)
// 	        );
// 	        $this->db->insert('kkm_payment_log', $log_data);
// 	        $log_id = $this->db->insert_id();
// 	        $hms_id = $this->config->item('hotel_id');

// 	        $check ["AdditionalProps"] = array (
// 	            array (
// 	                "Print" => true,
// 	                "PrintInHeader" => true,
// 	                "NameProp" => "Служебный $hms_id/$reservation_id/$pay_id/$log_id",
// 	                "Prop" => ""
// 	            )
// 	        );
	    }
	    return array(
	        'check' => $check,
	        'errors' => $errors,
	    );
	}


	function Insert_kkm_check ($data_kkm, $pay_or_ref){
	    $from_ajax_post_data = $data_kkm;
	    if ($this->releases->kkm_renewing()){
	        $pay_or_ref_id = $pay_or_ref == 1 ? $from_ajax_post_data ['ref_id'] : ($pay_or_ref == 0 ? $from_ajax_post_data ['pay_id'] : 0);
	        $RegisterCheckStrings = json_decode( $from_ajax_post_data ['RegisterCheckStrings']);
	        $kkm_responce = json_decode($from_ajax_post_data['KkmServerResponce']);
	        $QRCode_parsed_arr = array();
	        parse_str ( $kkm_responce->QRCode, $QRCode_parsed_arr );

	        $kkm_device_tbl_id = $this->db->select('id')->get_where('kkm_devices', array('IdDevice' => $RegisterCheckStrings->IdDevice))->row();


	        $check_data = array (
	            'pay_or_ref_id' => $pay_or_ref_id,
	            'pay_or_ref' => $pay_or_ref,
	            'fiscal_provider_id' => 1,//check is printed by KKM
	            "CheckNumber" => $kkm_responce->CheckNumber,
	            'SessionNumber' => $kkm_responce->SessionNumber,
	            'SessionCheckNumber' => $kkm_responce->SessionCheckNumber,
	            'QRCode' => $kkm_responce->QRCode,
	            'Command' => $kkm_responce->Command,
	            'IdCommand' => $kkm_responce->IdCommand,
	            'MethodCalculation' => $from_ajax_post_data['MethodCalculation'],
	            'CheckAllData' => $from_ajax_post_data ['RegisterCheckStrings'],
	            'amount' => (double)$RegisterCheckStrings->Cash+(double)$RegisterCheckStrings->ElectronicPayment,
	            'kkm_device_id' => isset($kkm_device_tbl_id->id) ? $kkm_device_tbl_id->id : 0,
	            "Cashier" => $RegisterCheckStrings->CashierName,
	            'processing_time' => date('Y-m-d H:i:s', strtotime($QRCode_parsed_arr['t'])),
	            'pay_form_id' => ($RegisterCheckStrings->Cash != 0)? 1:2,
	            'payment_type_id' => $from_ajax_post_data['payment_type_id'],
	        );
	        $this->db->insert ( 'kkm_checks', $check_data );
	        return $this->db->insert_id();
	    }else {




		if ($pay_or_ref == 0){//payment
			$pay_or_ref_id = $data_kkm ['pay_id'];
			$payment_type_query = $this->db->select('type')->get_where('payment', array('id'=>$pay_or_ref_id))->row();
			$payment_type_id = isset($payment_type_query->type)? $payment_type_query->type: 0;
		}else{//refund == 1
			$pay_or_ref_id = $data_kkm ['refund_id'];
			$payment_type_query = $this->db->select('type')->get_where('refund', array('id'=>$pay_or_ref_id))->row();
			$payment_type_id = isset($payment_type_query->type)? $payment_type_query->type: 0;
		}
		$temp_QRCode_arr = array();
 		parse_str ( $data_kkm ['QRCode'], $temp_QRCode_arr );
		$temp_CheckAllData = json_decode( $data_kkm ["RegisterCheckStrings"]);
		$kkm_device_id = $this->db->select('id')->get_where('kkm_devices', array('IdDevice' => $temp_CheckAllData->IdDevice))->row();
		$data_sql_kkm = array (
				'pay_or_ref_id' => $pay_or_ref_id,
				'pay_or_ref' => $pay_or_ref,
		        'fiscal_provider_id' => 1,//check is printed by KKM
				"CheckNumber" => $data_kkm ['CheckNumber'],
				'SessionNumber' => $data_kkm ['SessionNumber'],
				'QRCode' => $data_kkm ['QRCode'],
				'Command' => $data_kkm ['Command'],
				'IdCommand' => $data_kkm ['IdCommand'],
				'MethodCalculation' => $data_kkm ['kkm_MethodCalculation'],
				'CheckAllData' => $data_kkm ["RegisterCheckStrings"],
                'amount' => (double)$temp_CheckAllData->Cash+(double)$temp_CheckAllData->ElectronicPayment,//$temp_QRCode_arr['s'],
    		    'kkm_device_id' => isset($kkm_device_id->id)? $kkm_device_id->id : 0,
    		    "Cashier" => $temp_CheckAllData->CashierName,
    		    'processing_time' => date('Y-m-d H:i:s', strtotime($temp_QRCode_arr['t'])),
    		    'pay_form_id' => ($temp_CheckAllData->Cash != 0)? 1:2,
                'payment_type_id' => $payment_type_id,

		);
		$this->db->insert ( 'kkm_checks', $data_sql_kkm );
		return $this->db->insert_id();
	    }
	}

	function InsertAppexFiscalCheck ($data, $pay_or_ref){
	    if ($pay_or_ref == 0){//payment
	        $pay_or_ref_id = $data ['pay_id'];
	    }else{//refund == 1
	        $pay_or_ref_id = $data ['refund_id'];
	    }
		    $data_sql_kkm = array (
				'pay_or_ref_id' => $pay_or_ref_id,
				'pay_or_ref' => $pay_or_ref,//0 payment, 1 refund
	            'fiscal_provider_id' => 2,//check is printed by APPEX
		);
	    $this->db->insert ( 'kkm_checks', $data_sql_kkm );
	    return $this->db->insert_id();
	}
	function InsertOtherFiscalCheck ($data, $pay_or_ref){
		if ($pay_or_ref == 0){//payment
			$pay_or_ref_id = $data ['pay_id'];
		}else{//refund == 1
			$pay_or_ref_id = $data ['refund_id'];
		}
		$data_sql_kkm = array (
				'pay_or_ref_id' => $pay_or_ref_id,
				'pay_or_ref' => $pay_or_ref,//0 payment, 1 refund
				'fiscal_provider_id' => 99,//check is printed by Other
		);
		$this->db->insert ( 'kkm_checks', $data_sql_kkm );
		return $this->db->insert_id();
	}
	function get_MethodCalculation_arr (){
		return array('3' => "Аванс", '4' => "Полный расчет");
	}
	function get_device_policy_arr (){
		return array('0' => "{caption_first_available}", '1' => "{caption_chosen_kkm}");
	}
	function get_device_policy (){
		$sql = "SELECT value FROM hotelix_config WHERE name = 'kkm_device_policy'";
		$query = $this->db->query($sql);
		if ($query->num_rows()) {
			$row = $query->row ();
			return $row->value;
		}
		return 0;
	}
	function get_active_device (){
		return 0;
	}

	function get_kkm_server_url (){
	    $url = "";
		$sql = "SELECT str_value FROM hotelix_config WHERE name = 'kkm_server_url'";
		$query = $this->db->query($sql);
		if ($query->num_rows()) {
		    $row = $query->row ();
		    $url = $row->str_value;
		}

		return  $url;
// 		return "https://localhost:5893/";
	}
	function update_server_url ($server_url){
		$sql = "INSERT INTO hotelix_config (name, str_value) VALUES ('kkm_server_url','".$server_url."') ON DUPLICATE KEY UPDATE str_value='".$server_url."'";
		$this->db->query($sql);
		return 0;
	}
	function update_kkm_print_always($kkm_print_always){
		$sql = "INSERT INTO hotelix_config (name, value) VALUES ('kkm_print_always',".$kkm_print_always.") ON DUPLICATE KEY UPDATE value=".$kkm_print_always;
		$this->db->query($sql);
		return 0;
	}
	function get_kkm_print_always (){
		$sql = "SELECT value FROM hotelix_config WHERE name = 'kkm_print_always'";
		$query = $this->db->query($sql);
		if ($query->num_rows()) {
			$row = $query->row ();
			return $row->value;
		}
		return 0;
	}

	function update_device_policy ($device_policy){
		$sql = "INSERT INTO hotelix_config (name, value) VALUES ('kkm_device_policy',".$device_policy.") ON DUPLICATE KEY UPDATE value=".$device_policy;
		$this->db->query($sql);
		return 0;
	}
	function get_ClientEmailAddress ($reservation_id){
		$sql = "SELECT guests.email FROM deskofreservation
				LEFT JOIN guests ON deskofreservation.guest_id = guests.id
				WHERE deskofreservation.id =".$reservation_id;
		$query = $this->db->query($sql);
		$row = $query->row ();
		return $row->email;
	}
	function get_SenderEmailAddress ($id_partner){
		$sql = "SELECT email FROM partners WHERE id =".$id_partner;
		$query = $this->db->query($sql);
		$row = $query->row ();
	return $row->email;
	}
	function get_fiscal_provider ($paymenttype_id){
		$sql = "SELECT fiscal_provider_id FROM payment_types WHERE id =".$paymenttype_id;
		$query = $this->db->query($sql);
		$row = $query->row ();
		return $row->fiscal_provider_id;
	}
	function get_is_fiscalable_partner ($id_partner){
		$is_fiscalable = 0;
		$sql = "SELECT is_fiscalable FROM partners WHERE id =".$id_partner;
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0){
			$is_fiscalable = $query->row()->is_fiscalable;
		}
		return $is_fiscalable;
	}

	public function get_payment_form($payment_type_id){
		$sql = "SELECT payment_form_id FROM payment_types WHERE id =".$payment_type_id;
		$row = $this->db->query($sql)->row();
		return $row->payment_form_id;
	}

	function get_TaxVariants_arr() {
			// Система налогообложения (СНО) применяемая для чека, Тег 1055
			// Если не указанно - система СНО настроенная в ККМ по умолчанию
			// 0: Общая ОСН
			// 1: Упрощенная УСН (Доход)
			// 2: Упрощенная УСН (Доход минус Расход)
			// 3: Единый налог на вмененный доход ЕНВД
			// 4: Единый сельскохозяйственный налог ЕСН
			// 5: Патентная система налогообложения
			// Комбинация разных СНО не возможна
			// Надо указывать если ККМ настроена на несколько систем СНО
		return array (
				'Общая ОСН',
				'Упрощенная УСН (Доход)',
				'Упрощенная УСН (Доход минус Расход)',
				'Единый налог на вмененный доход ЕНВД',
				'Единый сельскохозяйственный налог ЕСН',
				'Патентная система налогообложения'
		);
	}

	public function get_main_service1_nomenclatura_items($in_data) {
	    $closed_intdates_tbl = 'kkm_payment_closed_days';
	    $res_id = $in_data['reservation_id'];
	    $pay_id = $in_data['pay_id'];
	    $service_amount_unpayed = $in_data['service_amount'];
	    $res = array();
	    $sql = "SELECT t1.intdate, t1.price, CONCAT('Категория ', categories.name, ', номер ', rooms.name) AS name
                FROM `deskofdays` AS t1
                JOIN rooms ON rooms.id = t1.room_id
                JOIN categories ON categories.id = rooms.category_id
                LEFT JOIN $closed_intdates_tbl AS closed ON closed.reservation_id =  t1.reservation_id AND t1.intdate = closed.intdate
                WHERE t1.reservation_id = $res_id AND ISNULL(closed.intdate)";
	    $query_res = $this->db->query($sql)->result();
	    if ($query_res){
	        $reservation_service_amount = 0;
	        foreach ($query_res as $set) {
	            $reservation_service_amount += $set->price;
	        }
	        if ($reservation_service_amount != $service_amount_unpayed){
	            $koef = round($service_amount_unpayed/$reservation_service_amount, 2);
	            $control_amount = 0;
	            foreach ($query_res as &$set) {
	                $set->price = round($koef * $set->price);
	                $control_amount += $set->price;
	            }
	            unset($set);
                $diff = $service_amount_unpayed - $control_amount;
                if ($diff !=0){
                    $query_res[0]->price += $diff;
                }
	        }
	        $insert_arr = array(
	            'reservation_id' => $res_id,
	            'payment_id' => $pay_id,
	        );
            foreach ($query_res as $set) {
                if (!isset($res[$set->price])){
                    $res[$set->price] = (object) array();
                    $res[$set->price]->name = $set->name;
                    $res[$set->price]->price = $set->price;
                    $res[$set->price]->count = 1;
                    $res[$set->price]->amount = $set->price;
                }else{
                    $res[$set->price]->amount += $set->price;
                    $res[$set->price]->count ++;
                }
                $insert_arr['intdate'] = $set->intdate;
                $insert_arr['price'] = $set->price;
                $this->db->insert($closed_intdates_tbl, $insert_arr);
            }
	    }
	    return $res;
	}

	public function get_countries_whith_kkm_possibilities() {
	    return array('RUS', 'ESP');
	}

	public function get_is_kkm_allowed_state() {
	    $modul_activity_row = $this->db->get_where('modules', array('name'=>'kkm'))->row();
        $modul_activity = ($modul_activity_row) ? $modul_activity_row->is_active : 0;
        $hotel_country_row = $this->db->get_where('visitka.config', array('id' => $this->config->item('hotel_id')))->row();
        $hotel_country = ($hotel_country_row) ? $hotel_country_row->id_country_3c : '';
	    $countries_whith_kkm = $this->get_countries_whith_kkm_possibilities();
        return (in_array($hotel_country, $countries_whith_kkm) && $modul_activity) ? 1 : 0;
	}

	public function get_cashier_data() {
	    $query_row = $this->db->select('signature, kasier_INN')->get_where('users', array('id' => $_SESSION['user']['id']))->row();
	    $name = $vatin = '';
	    if ($query_row){
	        $name = $query_row->signature;
	        $vatin = $query_row->kasier_INN;//'123456789012';
	    }else{
	        'Throw Error Cashier';
	    }
        return array(
            'name' => $name,
            'vatin' => $vatin
        );
	}

	public function get_partner_nds_for_check($p) {//array('id_partner' => $id_partner, 'MethodCalculation' => $MethodCalculation)
	    $p = (object) $p;
	    $query_row = $this->db->query ( "SELECT nds, nds_value FROM partners WHERE id = $p->id_partner")->row();
        if ($query_row) {
            if ($query_row->nds == 0) {
                $nds = - 1;
            } else {
                $nds = (int) $query_row->nds_value;
                if ($p->MethodCalculation == ADVANCE_METHOD){
                    $nds += 100;
                }
            }
        }
        return $nds;
	}

	public function make_kkm_str_after_ajax($p) {
	    $p = (object)$p;//kkm_check_id
	    $kkm_MethodCalculation_arr = $this->get_MethodCalculation_arr ();
	    $kkm_MethodCalculation_arr[0] = '???';
	    $check_data = $this->db->select('CheckNumber, SessionNumber, SessionCheckNumber, MethodCalculation')->get_where('kkm_checks', array('id'=>$p->kkm_check_id))->row();
	    $check_MethodCalculation_str = $kkm_MethodCalculation_arr[$check_data->MethodCalculation];
	    return "KKM С:$check_data->SessionNumber, Ч:$check_data->SessionCheckNumber($check_data->CheckNumber) ($p->kkm_check_id, $check_MethodCalculation_str)";
	}
}