<?
class hotelbeds_model extends dcm_abstract
{

    function __construct()
    {
        parent::__construct();
        
        $this->load->model('Curl_model');
        $this->load->model('hotelix_config');
        $this->dc_id = 37;

        $this->table_name_r2c = "dc_hotelbeds_rate2category_link";
        $this->table_name_dc_category2occupancy = "dc_hotelbeds_category2occupancy";
        $this->table_name_dc2hms_category_link = "dc_hotelbeds_room_categories_link";
        $this->table_name_occupancy = "dc_hotelbeds_occupancy";
        
        $this->sql_dc_rates = "select  CONCAT(dc_hotelbeds_rates.dc_hotel_id, '_', dc_rate_id) as dc_hotel_rate_id, dc_hotelbeds_rates.dc_hotel_id, dc_rate_id as dc_rate_id, name as dc_rate_name, active from dc_hotelbeds_rates";
        $this->sql_dc_category_link = "select dc_hotelbeds_room_categories.dc_hotel_id, dc_hotelbeds_room_categories.name as dc_category_name, categories.name as hms_category_name,
            dc_hotelbeds_room_categories_link.dc_category_id as dc_category_id,
            hms_category_id as hms_category_id
            from dc_hotelbeds_room_categories_link
            inner join dc_hotelbeds_room_categories on
            dc_hotelbeds_room_categories_link.dc_category_id = dc_hotelbeds_room_categories.dc_room_id
        	LEFT join categories on
            categories.id = dc_hotelbeds_room_categories_link.hms_category_id";
        $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id,
        	CONCAT(dc_hotelbeds_room_categories.dc_hotel_id, '_', dc_rate_id) as dc_hotel_rate_id
            from dc_hotelbeds_rate2category_link
        	inner join dc_hotelbeds_room_categories on
            dc_hotelbeds_rate2category_link.dc_category_id = dc_hotelbeds_room_categories.dc_room_id ";
        
        $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name, roomcategory from dc_hotelbeds_occupancy ORDER BY id ASC";
        $this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories WHERE is_active = 1";
        
        $this->sql_dc_category_list = "select dc_hotelbeds_xml_cfg.int_value as dc_hotel_id, dc_hotelbeds_room_categories.name as dc_category_name,
            dc_room_id as dc_category_id, active from dc_hotelbeds_room_categories
        	left join dc_hotelbeds_xml_cfg on
            dc_hotelbeds_room_categories.dc_hotel_id = dc_hotelbeds_xml_cfg.int_value and dc_hotelbeds_xml_cfg.name='hotel_id'";
        $this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_hotelbeds_category2occupancy";
        
        $this->form_action_c2o_post_c2 = "/dc_hotelbeds/categories_edit_post";
        $this->form_action_r2c_post_c2 = "/dc_hotelbeds/rates_edit_post";
    }

    function get_dc_room_id_by_str_value($dc_room_id){
        $query_arr = $this->db->select('id')->get_where('dc_hotelbeds_room_categories_strtoint_link', array('dc_room_id' => $dc_room_id))->row_array();
        return $query_arr['id'];
    }
    
    function get_restrictions_link()
    {
        $sql = "select * from dc_hotelbeds_restricts_link";
        $query = $this->db->query($sql);
        $return_data = array();
        foreach ($query->result() as $row) {
            $return_data[$row->dc_rate_id][$row->dc_category_id][$row->restrict_id] = 1;
        }
        return $return_data;
    }
    
    function build_rate2category ($occupancy_bool = 0, $roomstorate = 0, $price_func = 0)
    {
        //$occupancy_bool = 0;
        $sql = $this->sql_dc_rates;
        //echo $sql."<br>";
        //die();
        $query = $this->db->query($sql);
        $rate2category = array();
        $hms_rates_list = $this->build_hms_rates();
        $hms_restrictions_list = $this->build_hms_restrictions();
        $restrictions_list = $this->get_restrictions_link();
        $hms_occupancies_list = $this->get_occupancies ($occupancy_bool);
    
        $c2o = $this->get_category2occupancy();
    
        $r2c_link = $this->get_r2c_link();
        	
        foreach ($query->result() as $rate_row) {
            $sql = $this->sql_dc_category_link;
    
            //echo $sql."<br>";
            $query2 = $this->db->query($sql);
    
            $rate2category[$rate_row->dc_hotel_rate_id] = array();
            $rate2category[$rate_row->dc_hotel_rate_id]['dc_rate_name'] = $rate_row->dc_rate_name;
            $rate2category[$rate_row->dc_hotel_rate_id]['dc_rate_id'] = $rate_row->dc_rate_id;
            if(isset($rate_row->dc_hotel_id)){
                $rate2category[$rate_row->dc_hotel_rate_id]['dc_hotel_id'] = $rate_row->dc_hotel_id;
            }else{
                $rate2category[$rate_row->dc_hotel_rate_id]['dc_hotel_id'] = "";
            }
            if (isset($rate_row->dc_property_name)) {
                $rate2category[$rate_row->dc_hotel_rate_id]['dc_property_name'] = $rate_row->dc_property_name;
            } else {
                $rate2category[$rate_row->dc_hotel_rate_id]['dc_property_name'] = "";
            }
    
            if(isset($rate_row->active)){
                $rate2category[$rate_row->dc_hotel_rate_id]['active'] = $rate_row->active;
            }else{
                $rate2category[$rate_row->dc_hotel_rate_id]['active'] = "active";
            }
            // ================================================================================
            if (isset($rate_row->restrict_name)) {
                $rate2category[$rate_row->dc_hotel_rate_id]['restrict_name'] = $rate_row->restrict_name;
            } else {
                $rate2category[$rate_row->dc_hotel_rate_id]['restrict_name'] = "";
            }
            // ================================================================================
            foreach ( $query2->result () as $category_row ) {
    
                if ($category_row->dc_hotel_id == $rate_row->dc_hotel_id) {
                    $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['dc_category_name'] = $category_row->dc_category_name;
                    $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['dc_category_id'] = $category_row->dc_category_id;
                    if (isset ( $category_row->hms_category_name )) {
                        $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['hms_category_name'] = $category_row->hms_category_name;
                    } else {
                        $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['hms_category_name'] = "";
                    }
                    $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['hms_category_id'] = $category_row->hms_category_id;
                    $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['dc_rate_id'] = $rate_row->dc_rate_id;
                    //$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['hms_restrictions_list'] = $hms_restrictions_list;
                    if ($occupancy_bool == 1) {
                        if (isset ( $hms_occupancies_list [$category_row->dc_category_id] )) {
                            foreach ( $hms_occupancies_list [$category_row->dc_category_id] as $occupancy_cell ) {
                                if (isset ( $c2o [$category_row->dc_category_id] [$occupancy_cell ['hms_occupancy_id']] )) {
                                    $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_id'] = $rate_row->dc_rate_id;
                                    $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_name'] = $rate_row->dc_rate_name;
                                    $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_name'] = $category_row->dc_category_name;
                                    $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_id'] = $category_row->dc_category_id;
                                    $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_rates_list'] = $hms_rates_list;
                                    $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_price_func_list'] = $this->build_price_func ( $price_func );
                                    //$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_restrictions_list'] = $hms_restrictions_list;
    
                                    $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_id'] = $occupancy_cell ['hms_occupancy_id'];
                                    $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_name'] = $occupancy_cell ['hms_occupancy_name'];
                                }
                            }
                        }
                    } else {
                        foreach ( $hms_occupancies_list as $occupancy_cell ) {
                            if (isset ( $c2o [$category_row->dc_category_id] [$occupancy_cell ['hms_occupancy_id']] )) {
                                $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_id'] = $rate_row->dc_rate_id;
                                $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_name'] = $rate_row->dc_rate_name;
                                $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_name'] = $category_row->dc_category_name;
                                $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_id'] = $category_row->dc_category_id;
                                $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_rates_list'] = $hms_rates_list;
                                $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_price_func_list'] = $this->build_price_func ( $price_func );
                                //$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_restrictions_list'] = $hms_restrictions_list;
    
                                $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_id'] = $occupancy_cell ['hms_occupancy_id'];
                                $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_name'] = $occupancy_cell ['hms_occupancy_name'];
                            }
                        }
                    }
                    if (! isset ( $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] )) {
                        unset ( $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] );
                    }
                    //$rate2category [$rate_row->dc_hotel_rate_id] ['hms_restrictions_list'] = $hms_restrictions_list;
                    	
                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['hms_restrictions_list'] = $hms_restrictions_list;
                    	
                    if(isset($restrictions_list[$rate_row->dc_rate_id][$category_row->dc_category_id])){
                        foreach($restrictions_list[$rate_row->dc_rate_id][$category_row->dc_category_id] as $restrict_id => $val){
                            $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['hms_restrictions_list'][$restrict_id]['selected'] = 'selected';
                        }
                    }
                }
            }
        }
        //echo "<pre>";
        //print_r($rate2category);
        //die();
        //
        $sql = $this->sql_dc_r2c;
        $query = $this->db->query($sql);
        //echo $sql."<br>";
        foreach ($query->result() as $row) {
            if (isset($c2o[$row->dc_category_id][$row->hms_occupancy_id])) {
                $rate2category[$row->dc_hotel_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_rates_list'][$row->hms_rate_id]['selected'] = 'selected';
                //$rate2category[$row->dc_hotel_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
                $rate2category[$row->dc_hotel_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][0]['pf_selected'] = '';
                $rate2category[$row->dc_hotel_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][$row->hms_price_func_id]['pf_selected'] = 'selected';
            }
        }
    
        // 		if ($this->sql_dc_r2rlink !== "") {
        // 			$sql = $this->sql_dc_r2rlink;
        // 			$query = $this->db->query($sql);
        // 			// echo $sql;
        // 			foreach ($query->result() as $row) {
        // 				$rate2category[$row->dc_rate_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
        // 			}
        // 		}
        // 		echo "<pre>";
        // 		print_r($rate2category);
        // 		die();
        return $rate2category;
    }
    
    function rate2category_save_hotelbeds($r2c, $restricts)
    {
        if (sizeof($r2c)) {} else {
            return;
        }
    
        $this->db->query("delete from " . $this->table_name_r2c);
    
        foreach ($r2c as $dc_rate_id => $dc_category_list) {
            foreach ($dc_category_list as $dc_category_id => $occupancy) {
                foreach ($occupancy as $key => $cell) {
                    $sql = "insert into " . $this->table_name_r2c . "  (dc_rate_id, dc_category_id, hms_occupancy_id,  hms_rate_id, hms_price_func_id) values
                    ($dc_rate_id, $dc_category_id, " . $cell['hms_occupancy_id'] . ", " . $cell['hms_rate_id'] . ", " . $cell['hms_price_func_id'] . ") on duplicate key update
                hms_rate_id=" . $cell['hms_rate_id'] . ", hms_price_func_id=" . $cell['hms_price_func_id'] . ", hms_occupancy_id=" . $cell['hms_occupancy_id'] . "";
                    // echo $sql . "\n";
                    $this->db->query($sql);
                }
    
                // save restricts
                if (isset($restricts[$dc_rate_id][$dc_category_id])) {
                    $sql = "INSERT INTO dc_hotelbeds_restricts_link (dc_rate_id, dc_category_id, restrict_id) values ($dc_rate_id, $dc_category_id, " . $restricts[$dc_rate_id][$dc_category_id]['hms_restrict_id'] . ")
			            on duplicate key update restrict_id = " . $restricts[$dc_rate_id][$dc_category_id]['hms_restrict_id'];
                    $this->db->query($sql);
                }
            }
        }
    
    
    }
    
    function getauthparam($dc_account_id = 0)
    {
        $data = array();
        $hotel_id = 0;
        $test_mode = 1;
        $user = "";
        $password = "";
        if ($dc_account_id != 0) {
            $sql = "SELECT int_value FROM dc_hotelbeds_xml_cfg WHERE dc_account_id = " . $dc_account_id . " AND name LIKE 'hotel_id'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hotel_id = $row->int_value;
            }
            
            $sql = "SELECT int_value FROM dc_hotelbeds_xml_cfg WHERE dc_account_id = " . $dc_account_id . " AND name LIKE 'test_mode'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $test_mode = $row->int_value;
            }
            
            $sql = "SELECT str_value FROM dc_hotelbeds_xml_cfg WHERE dc_account_id = " . $dc_account_id . " AND name LIKE 'user'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $user = $row->str_value;
            }
            
            $sql = "SELECT str_value FROM dc_hotelbeds_xml_cfg WHERE dc_account_id = " . $dc_account_id . " AND name LIKE 'password'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $password = $row->str_value;
            }
        }
    
        $data["hotel_id"] = $hotel_id;
        $data["user"] = $user;
        $data["password"] = $password;
        return $data;
    }
    
    function options_save($data)
    {
        $dc_table_name = "dc_hotelbeds_xml_cfg";
    
        $data_1 = array();
        $data_1["general_update"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "general_update", "int");
        $data_1["dealer_id"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "dealer_id", "int");
        $data_1["overbooking_category_id"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "overbooking_category_id", "int");
    
        $sql = "INSERT INTO $dc_table_name (dc_account_id, name, int_value) VALUES(0, 'dealer_id', '" . $data["dealer"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data["dealer"];
        $query = $this->db->query($sql);
        $sql = "INSERT INTO $dc_table_name (dc_account_id, name, int_value) VALUES(0, 'overbooking_category_id', '" . $data["overbooking_category"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data["overbooking_category"];
        $query = $this->db->query($sql);
        $sql = "INSERT INTO $dc_table_name (dc_account_id, name, int_value) VALUES(0, 'general_update', '" . $data["general_update"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data["general_update"];
        $query = $this->db->query($sql);
         
        $data_2 = array();
        $data_2["general_update"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "general_update", "int");
        $data_2["dealer_id"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "dealer_id", "int");
        $data_2["overbooking_category_id"] = $this->dc_model->get_dc_cfg_value($dc_table_name, "overbooking_category_id", "int");
   
        $this->Loger_admin->SaveLog($data_1, $data_2, "loger_admin", 0, "dc_aanda_xml_cfg", "edit");
    }
}
?>