<?php
class dcm_booking_v2 extends dcm_abstract {
    public function __construct() {
        parent::__construct();

        $this->dc_id = 1;

        if ($this->db->database != "") {
            $this->overbooking_category_id = $this->get_dc_overbooking_category_id();
            
            if ($this->get_price_version() == 1) {
                $this->table_name_r2c = "dc_booking_rate2category_link";
            }
            if ($this->get_price_version() == 2) {
                $this->table_name_r2c = "dc_booking_rate2category_obp";
            }
            
            if($this->get_price_version() == 1){
                $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id
            from dc_booking_rate2category_link";
            }
            
            if($this->get_price_version() == 2){
                $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id
            from dc_booking_rate2category_obp";
            }
        }
        $this->table_name_dc_category2occupancy = "dc_booking_category2occupancy";
        $this->table_name_dc2hms_category_link = "dc_booking_rooms_link";


        $this->sql_dc_rates = "select  dc_booking_rates.dc_hotel_id, dc_booking_rates.dc_rate_id as dc_rate_id, dc_booking_rates.active, dc_booking_rates.name as dc_rate_name, dc_global_restrict_rate.name as restrict_name
        		from dc_booking_rates
        		LEFT JOIN dc_booking_rates_link ON dc_booking_rates_link.dc_rate_id = dc_booking_rates.dc_rate_id
        		LEFT JOIN dc_global_restrict_rate ON dc_global_restrict_rate.rate_id = dc_booking_rates_link.restrict_id";
        $this->sql_dc_category_link = "select dc_booking_rooms_link.dc_hotel_id, dc_room_name as dc_category_name,
            dc_room_id	 as dc_category_id,
            category_id as hms_category_id
            from dc_booking_rooms_link";
        $this->sql_dc_r2rlink = "select dc_rate_id as dc_rate_id, restrict_id as hms_restrict_id from dc_booking_rates_link";

        $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name from dc_booking_occupancy";
        $this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories WHERE is_active = 1";

        $this->sql_dc_category_list = "select concat('<i>', dc_booking_xml_cfg.str_value, '</i> - <b>',  dc_room_name,  '</b> - ') as dc_category_name,
            dc_room_id as dc_category_id, active from dc_booking_rooms_link left join dc_booking_xml_cfg on
            dc_booking_rooms_link.dc_hotel_id = dc_booking_xml_cfg.int_value and dc_booking_xml_cfg.name='hotel_id'
            ";

        $this->sql_dc_category_list = "select dc_booking_xml_cfg.str_value as dc_property_name,  dc_room_name as dc_category_name,
            dc_room_id as dc_category_id, active from dc_booking_rooms_link left join dc_booking_xml_cfg on
            dc_booking_rooms_link.dc_hotel_id = dc_booking_xml_cfg.int_value and dc_booking_xml_cfg.name='hotel_id'
            ";

        $this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_booking_category2occupancy";
        $this->form_action_c2o_post = "/dc_booking/categories_edit_post_v2";
        $this->form_action_r2c_post = "/dc_booking/rates_edit_post_v2";

        $this->form_action_c2o_post_c2 = "/dc_booking_c2/categories_edit_post_v2";
        $this->form_action_r2c_post_c2 = "/dc_booking_c2/rates_edit_post_v2";
    }



    function rate2category_save_booking($r2c)
    {
    	if (sizeof($r2c)) {

    	} else {
    		return;
    	}


    	$this->db->query("delete from " . $this->table_name_r2c);

//     	echo "<pre>";
//     	print_r($r2c);

    	foreach ($r2c as $dc_rate_id => $dc_category_list) {
    	    if (isset($dc_category_list['room_list'])) {
                foreach ($dc_category_list['room_list'] as $dc_category_id => $occupancy) {
                    // print_r($occupancy);
                    foreach ($occupancy as $key => $cell) {
                        $sql = "insert into " . $this->table_name_r2c . "  (dc_rate_id, dc_category_id, hms_occupancy_id,  hms_rate_id, hms_price_func_id) values
    				($dc_rate_id, $dc_category_id, " . $cell['hms_occupancy_id'] . ", " . $cell['hms_rate_id'] . ", " . $cell['hms_price_func_id'] . ") on duplicate key update
                hms_rate_id=" . $cell['hms_rate_id'] . ", hms_price_func_id=" . $cell['hms_price_func_id'] . "
                    , hms_occupancy_id=" . $cell['hms_occupancy_id'] . "";
                        //echo $sql . "<br><br>";
                        $this->db->query($sql);
                        // ===================================
                    }
                }
            }
    		$sql = "INSERT INTO dc_booking_rates_link (dc_rate_id, restrict_id) values ($dc_rate_id, ".$r2c[$dc_rate_id]['hms_restrict_id'].")
			on duplicate key update restrict_id = ".$r2c[$dc_rate_id]['hms_restrict_id'];
    		$this->db->query ( $sql );
    	}

    	//die();

    }

    function category2occupancy_save_booking($c2o)
    {
    	$this->db->query("delete from " . $this->table_name_dc_category2occupancy);
    	foreach ($c2o as $dc_category_id => $cell) {
    		$sql = "insert into " . $this->table_name_dc2hms_category_link . "  (dc_room_id, category_id) values
    		($dc_category_id, " . $cell['hms_category_id'] . ") on duplicate key update
                category_id=" . $cell['hms_category_id'] . " ";
    		// echo $sql . "\n";
    		$this->db->query($sql);
    		if (isset($cell['occupancies'])) {
    			foreach ($cell['occupancies'] as $key => $state) {
    				$sql = "insert into " . $this->table_name_dc_category2occupancy . " (dc_category_id, hms_occupancy_id)
                    values (" . $dc_category_id . ", " . $key . ") on duplicate key update
                        dc_category_id = " . $dc_category_id . ", hms_occupancy_id = " . $key . "";
    				$this->db->query($sql);
    			}
    		}
    	}
    }
    
    private function createXmlFromArray( $array, &$xml )
    {
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                if (is_numeric($key)) {
                    $key = 'item' . $key; // Change numeric key to a valid XML element name
                }
    
                if ( isset($value[0]) && is_array($value[0])) {
                    foreach ($value as $item) {
                        $subnode = $xml->addChild($key);
                        $this->createXmlFromArray($item, $subnode);
                    }
                } else {
                    $subnode = $xml->addChild($key);
                    $this->createXmlFromArray($value, $subnode);
                }
            } else {
                if (strpos($key, '@') === 0) {
                    if ($key === "@xmlns:xsi") {
                        $xml->addAttribute("xmlns:xsi", $value);
                    } else {
                        $xml->addAttribute(substr($key, 1), htmlspecialchars($value));
                    }
                } else {
                    if( is_numeric( $key) ){
                        $xml->$key = $value;
                    } else {
                        $xml->addChild($key, htmlspecialchars($value));
                    }
                }
            }
        }
    }
    
    public function get_roomrates( $hotel = 4386613, $mode = null )
    {
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        $url = 'https://supply-xml.booking.com/hotels/xml/roomrates';
    
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
            'Accept-Version: 1.1'
        );
    
        $property = array(
            "hotel_id" => $hotel
        );
    
        $xml = new SimpleXMLElement('<request></request>');
        $this->createXmlFromArray($property, $xml);
    
        // Output the formatted XML string
        $data = $xml->asXML();
    
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        $buffer = curl_exec($ch);
        curl_close($ch);
    
    
    
        $xml = new SimpleXMLElement($buffer);
        $result = $xml->xpath('rooms/room');
    
        $rooms = array(); //json_decode( json_encode($result), 1 );
    
        foreach( $result as $k => $room ){
            $rooms[$k]['room_id'] = (int)$room->attributes()->id;
            $rooms[$k]['room_name'] = (string)$room->attributes()->room_name;
            $rooms[$k]['rates'] = array();
             
            if( count($room->rates->rate) > 1 ){
                $i = 0;
                foreach(  $room->rates->rate as $rate ){
                    $rooms[$k]['rates'][$i]['id'] = (int)$rate->attributes()->id;
                    $rooms[$k]['rates'][$i]['max_persons'] = (int)$rate->attributes()->max_persons;
                    $rooms[$k]['rates'][$i]['policy'] = (string)$rate->attributes()->policy;
                    $rooms[$k]['rates'][$i]['policy_id'] = (string)$rate->attributes()->policy_id;
                    $rooms[$k]['rates'][$i]['rate_name'] = (string)$rate->attributes()->rate_name;
                    $rooms[$k]['rates'][$i]['meal_plan'] = (int)$rate->meal_plan->attributes()->meal_plan_code;
                    $rooms[$k]['rates'][$i]['cancel_policy'] = (int)$rate->policies->cancel_policy->cancel_penalty->attributes()->policy_code;
                    $rooms[$k]['rates'][$i]['guarantee_payment_policy'] = (int)$rate->policies->guarantee_payment_policy
                    ->guarantee_payment->attributes()->policy_code;
                    $rooms[$k]['rates'][$i]['guarantee_payment_due'] = (string)$rate->policies->guarantee_payment_policy
                    ->guarantee_payment->attributes()->effective_from;
                    $rooms[$k]['rates'][$i]['is_payment_required'] = (int)$rate->policies->guarantee_payment_policy
                    ->guarantee_payment->attributes()->required;
                    $rooms[$k]['rates'][$i]['pricing_type'] = (string)$rate->pricing->attributes()->type;
                     
                    if( $rooms[$k]['rates'][$i]['pricing_type'] == 'RLO' && isset($rate->pricing->occupancy) ){
                        $rooms[$k]['rates'][$i]['pricing_base'] = (int)$rate->pricing->occupancy->attributes()->persons;
                        $rooms[$k]['rates'][$i]['pricing_percent'] = (double)$rate->pricing->occupancy->attributes()->percentage;
                        $rooms[$k]['rates'][$i]['pricing_round'] = (int)$rate->pricing->occupancy->attributes()->round;
                    }
                     
                    if( $rooms[$k]['rates'][$i]['pricing_type'] == 'Standard'){
                        $rooms[$k]['rates'][$i]['price1'] = (int)$rate->pricing->attributes()->price1;
                    }
                    $i++;
                }
            } else {
                $rooms[$k]['rates'][0]['id'] = (int)$room->rates->rate->attributes()->id;
                $rooms[$k]['rates'][0]['max_persons'] = (int)$room->rates->rate->attributes()->max_persons;
                $rooms[$k]['rates'][0]['policy'] = (string)$room->rates->rate->attributes()->policy;
                $rooms[$k]['rates'][0]['policy_id'] = (string)$room->rates->rate->attributes()->policy_id;
                $rooms[$k]['rates'][0]['rate_name'] = (string)$room->rates->rate->attributes()->rate_name;
                $rooms[$k]['rates'][0]['meal_plan'] = (int)$room->rates->rate->meal_plan->attributes()->meal_plan_code;
                $rooms[$k]['rates'][0]['cancel_policy'] = (int)$room->rates->rate->policies->cancel_policy->cancel_penalty->attributes()->policy_code;
                $rooms[$k]['rates'][0]['guarantee_payment_policy'] = (int)$room->rates->rate->policies->guarantee_payment_policy
                ->guarantee_payment->attributes()->policy_code;
                $rooms[$k]['rates'][0]['guarantee_payment_due'] = (string)$room->rates->rate->policies->guarantee_payment_policy
                ->guarantee_payment->attributes()->effective_from;
                $rooms[$k]['rates'][0]['is_payment_required'] = (int)$room->rates->rate->policies->guarantee_payment_policy
                ->guarantee_payment->attributes()->required;
                $rooms[$k]['rates'][0]['pricing_type'] = (string)$room->rates->rate->pricing->attributes()->type;
    
                if( $rooms[$k]['rates'][0]['pricing_type'] == 'RLO' && isset($room->rates->rate->pricing->occupancy) ){
                    $rooms[$k]['rates'][0]['pricing_base'] = (int)$room->rates->rate->pricing->occupancy->attributes()->persons;
                    $rooms[$k]['rates'][0]['pricing_percent'] = (double)$room->rates->rate->pricing->occupancy->attributes()->percentage;
                    $rooms[$k]['rates'][0]['pricing_round'] = (int)$room->rates->rate->pricing->occupancy->attributes()->round;
                }
    
                if( $rooms[$k]['rates'][0]['pricing_type'] == 'Standard'){
                    $rooms[$k]['rates'][0]['price1'] = (int)$room->rates->rate->pricing->attributes()->price1;
                }
            }
        }
        
        return $rooms;
//         echo '<pre>';
//         echo htmlentities($data);
//         echo "<hr>";
//         echo htmlentities($buffer);
//         echo "<hr>";
//         print_r( $rooms );
    }
    
    function obp_save_roomrates ($data){
        foreach($data as $dc_hotel_id => $obp_data){
            foreach($obp_data['obp_data'] as $room_data){
                $room_id = $room_data['room_id'];
                foreach($room_data['rates'] as $rates_data){
                    $rate_id = $rates_data['id'];
                    $max_persons = $rates_data['max_persons'];
                    for($oc = 1; $oc <= $max_persons; $oc++){
                        $sql = "INSERT INTO dc_booking_rate2category_obp (dc_rate_id, dc_category_id, hms_occupancy_id) VALUES ($rate_id, $room_id, $oc)
                                ON DUPLICATE KEY UPDATE hms_rate_id = hms_rate_id, hms_restrict_id = hms_restrict_id, hms_price_func_id = hms_price_func_id";
                        $this->db->query($sql);
                    }
                }
            }
        }
        //die();
    }
    
    function get_price_version(){
        $price_version = 1;
        $sql = "SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'price_version'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $price_version = $row->int_value;
        }

        return $price_version;
    }
    
    function get_occupancies_booking_obp(){
        $sql = "SELECT * FROM dc_booking_rate2category_obp";
        $query = $this->db->query($sql);
        $occupancies = array();
        foreach ($query->result() as $row) {
            $occupancies[$row->dc_rate_id][$row->dc_category_id][$row->hms_occupancy_id]['hms_occupancy_id'] = $row->hms_occupancy_id;
        }
        return $occupancies;
    }
    function build_rate2category ($occupancy_bool = 0, $roomstorate = 0, $price_func = 0)
    {
        //$occupancy_bool = 0;
        $sql = $this->sql_dc_rates;
        //echo $sql."<br>";
        $query = $this->db->query($sql);
        $rate2category = array();
        $hms_rates_list = $this->build_hms_rates();
        $hms_restrictions_list = $this->build_hms_restrictions();
        
        $price_version = $this->get_price_version();
        if ($price_version == 1) {
            $hms_occupancies_list = $this->get_occupancies ($occupancy_bool);
        }else{
            $hms_occupancies_list = $this->get_occupancies_booking_obp ($occupancy_bool);
        }
        
        $c2o = $this->get_category2occupancy();
    
        $r2c_link = $this->get_r2c_link();
//                 echo "<pre>";
//                 print_r($r2c_link);
//                 die();
        foreach ($query->result() as $rate_row) {
            $sql = $this->sql_dc_category_link;
    
            //if($roomstorate == 1){
            //	$sql .= $this->sql_roomstorate." ".$rate_row->dc_rate_id;
             
            //}
            //echo $sql."<br><br><br>";
            $query2 = $this->db->query($sql);
    
            $rate2category[$rate_row->dc_rate_id] = array();
            $rate2category[$rate_row->dc_rate_id]['dc_rate_name'] = $rate_row->dc_rate_name;
            $rate2category[$rate_row->dc_rate_id]['dc_rate_id'] = $rate_row->dc_rate_id;
            if(isset($rate_row->dc_hotel_id)){
                $rate2category[$rate_row->dc_rate_id]['dc_hotel_id'] = $rate_row->dc_hotel_id;
            }else{
                $rate2category[$rate_row->dc_rate_id]['dc_hotel_id'] = "";
            }
            if (isset($rate_row->dc_property_name)) {
                $rate2category[$rate_row->dc_rate_id]['dc_property_name'] = $rate_row->dc_property_name;
            } else {
                $rate2category[$rate_row->dc_rate_id]['dc_property_name'] = "";
            }
    
            if(isset($rate_row->active)){
                $rate2category[$rate_row->dc_rate_id]['active'] = $rate_row->active;
            }else{
                $rate2category[$rate_row->dc_rate_id]['active'] = "active";
            }
            // ================================================================================
            if (isset($rate_row->restrict_name)) {
                $rate2category[$rate_row->dc_rate_id]['restrict_name'] = $rate_row->restrict_name;
            } else {
                $rate2category[$rate_row->dc_rate_id]['restrict_name'] = "";
            }
            // ================================================================================
            foreach ($query2->result() as $category_row) {
                if($roomstorate == 1){
                    if(isset($r2c_link[$rate_row->dc_rate_id][$category_row->dc_category_id])){
                         
                    }else{
                        //             			echo "+++"."1";
                        //             			die();
                        continue;
                    }
                }
                // echo $category_row->dc_hotel_id."|||".$rate_row->dc_hotel_id."<br>";
                if ($category_row->dc_hotel_id == $rate_row->dc_hotel_id) {
                    
                    $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_name'] = $category_row->dc_category_name;
                    $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_id'] = $category_row->dc_category_id;
                    if (isset($category_row->hms_category_name)) {
                        $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = $category_row->hms_category_name;
                    } else {
                        $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = "";
                    }
                    $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_id'] = $category_row->hms_category_id;
                    $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_rate_id'] = $rate_row->dc_rate_id;
                    // $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_restrictions_list'] = $hms_restrictions_list;
                    if ($price_version == 1) {
                        foreach ($hms_occupancies_list as $occupancy_cell) {
                            if (isset($c2o[$category_row->dc_category_id][$occupancy_cell['hms_occupancy_id']])) {
                                // echo "111111111111111111111111111111111111111";
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_id'] = $rate_row->dc_rate_id;
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_name'] = $rate_row->dc_rate_name;
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_name'] = $category_row->dc_category_name;
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_id'] = $category_row->dc_category_id;
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_rates_list'] = $hms_rates_list;
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_price_func_list'] = $this->build_price_func($price_func);
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_restrictions_list'] = $hms_restrictions_list;
                                
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_id'] = $occupancy_cell['hms_occupancy_id'];
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_name'] = $occupancy_cell['hms_occupancy_name'];
                            }
                        }
                    } else {
                        if (isset($hms_occupancies_list[$rate_row->dc_rate_id][$category_row->dc_category_id])) {
                            foreach ($hms_occupancies_list[$rate_row->dc_rate_id][$category_row->dc_category_id] as $occupancy_cell) {
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_id'] = $rate_row->dc_rate_id;
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_name'] = $rate_row->dc_rate_name;
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_name'] = $category_row->dc_category_name;
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_id'] = $category_row->dc_category_id;
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_rates_list'] = $hms_rates_list;
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_price_func_list'] = $this->build_price_func($price_func);
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_restrictions_list'] = $hms_restrictions_list;
                                
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_id'] = $occupancy_cell['hms_occupancy_id'];
                                $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_name'] = $occupancy_cell['hms_occupancy_id'];
                            }
                        }
                    }
                    
                    if (! isset($rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'])) {
                        
                        unset($rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]);
                    }
                    // print_r($rate2category);
                    $rate2category[$rate_row->dc_rate_id]['hms_restrictions_list'] = $hms_restrictions_list;
                }
               
            }
            // echo "<pre>0000";
            //print_r($rate2category);
            //die();
        }
//                 echo "<pre>0000";
//                 print_r($rate2category);
//                 die();
    
        $sql = $this->sql_dc_r2c;
        $query = $this->db->query($sql);
        // echo $sql;
        foreach ($query->result() as $row) {
            if ($price_version == 1) {
                if (isset($c2o[$row->dc_category_id][$row->hms_occupancy_id])) {
                    $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_rates_list'][$row->hms_rate_id]['selected'] = 'selected';
                    $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
                    $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][0]['pf_selected'] = '';
                    $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][$row->hms_price_func_id]['pf_selected'] = 'selected';
                }
            }
            if ($price_version == 2) {
                if (isset($rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id])) {
                    $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_rates_list'][$row->hms_rate_id]['selected'] = 'selected';
                    $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
                    $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][0]['pf_selected'] = '';
                    $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][$row->hms_price_func_id]['pf_selected'] = 'selected';
                }
            }
        }
    
        if ($this->sql_dc_r2rlink !== "") {
            $sql = $this->sql_dc_r2rlink;
            $query = $this->db->query($sql);
            // echo $sql;
            foreach ($query->result() as $row) {
                $rate2category[$row->dc_rate_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
            }
        }
//         echo "<pre>";
//         print_r($rate2category);
//         die();
        return $rate2category;
    }
}