<?php
class Gate extends CI_Controller {
    private $rooms_tbl = '`categories`';
    private $props_tbl = '`property_information`';
    private $vrbo_supported_locales = ['da','de','en','es','fi','fr','el','it','ja','nl','no','pl','pt','ru','sv','tr'];
    // * These languages are not supported by the property display page (PDP) and Vrbo dashboard, and they will note be displayed if provided.
    // da	Danish
    // de	German
    // en	English
    // es	Spanish
    // fi	Finnish
    // fr	French
    // el	Greek*
    // it	Italian
    // ja	Japanese
    // nl	Dutch
    // no	Norwegian
    // pl	Polish*
    // pt	Portuguese
    // ru	Russian*
    // sv	Swedish
    // tr	Turkish*
    // * These languages are not supported by the property display page (PDP) and Vrbo dashboard, and they will note be displayed if provided.

    public function __construct() {
        parent::__construct ();
        $this->load->model ( 'hotelix_config' );
        $this->load->model ( 'images_core' );
        $this->load->model ( 'mlanguages' );
    }

    public function rooms() {
        $single_dwelling_id = 1;
        $hms_id = $this->config->item('hotel_id');
        $host = $this->input->server('HTTP_HOST');
        $rooms = $this->db->select('t1.id as room_id, t1.web_booking as is_active')
            ->from("$this->rooms_tbl AS t1")
            ->where('t1.is_active = 1')
            ->join("$this->props_tbl AS t2", "t1.property_id = t2.id AND t2.dwelling = $single_dwelling_id")
            ->get()->result();

        if (count($rooms)) {
            foreach ($rooms as $room) {
                $room->listing_id = "$hms_id-$room->room_id";
                $room->last_updated = date('c');
                $room->listing_url = "https://$host/vrbo/gate/room/$room->room_id";
            }
            $data = [
                'listings' => $rooms,
                'hms_id' => $hms_id
            ];
            $feed = $this->parser->parse('templates/vrbo/xml_tmpts/rooms_listing.html', $data, TRUE);
            $feed = '<?xml version="1.0" encoding="UTF-8"?>'.$feed;
            echo $feed;
        }
    }

    public function rules() {
        echo 'Under consruction!';
    }

    public function rate() {
        echo 'Under consruction!';
    }

    public function availability() {
        echo 'Under consruction!';
    }

    public function room($id = null) {
        $room = new Room($id, ['options'=>['info', 'supported_locales', 'local_filds', 'amenities', 'images']]);
        $property = new Property($room->info->property_id, ['options'=>['info', 'supported_locales', 'local_filds', 'amenities', 'images']]);
        $xml = simplexml_load_file('/var/vhosts/desks-dev.otelms.com/html/application/views/templates/vrbo/xml_tmpts/content_clear.xml');
        $xml->externalId = "{$property->hms_id}-$property->id";
        $xml->lastUpdatedDate = date('c');
        $xml->active = 'Not in system';
        foreach ($property->supported_locales_namekeys as $supported_locale) {
            if (in_array($supported_locale, $this->vrbo_supported_locales)) {
                //====================================== accommodationsSummary START ========================================================
                $accommodationsSummary_textValue = isset($room->local_filds[$supported_locale]->name) ? $room->local_filds[$supported_locale]->name : "Category name in $supported_locale lang is empty";
                $accommodationsSummary_textValue .= isset($property->local_filds[$supported_locale]->name) ? ' '.$property->local_filds[$supported_locale]->name : " Property name in $supported_locale lang is empty";

                $tmp_obj = &$xml->adContent->accommodationsSummary;
                if (empty($tmp_obj->children())) {
                    $tmp_obj->addChild('texts');
                }
                $text = $tmp_obj->texts->addChild('text');
                $text->addAttribute('locale', $supported_locale);
                $text->addChild('textValue', $accommodationsSummary_textValue);
                unset($text);
                //====================================== accommodationsSummary FINAL ========================================================
                //====================================== description START ========================================================
                $description_textValue = isset($room->local_filds[$supported_locale]->comment) ? $room->local_filds[$supported_locale]->comment : "Category comment in $supported_locale lang is empty";
                $description_textValue .= isset($property->local_filds[$supported_locale]->summary) ? ' '.$property->local_filds[$supported_locale]->summary : " Property summary in $supported_locale lang is empty";
                $tmp_obj = &$xml->adContent->description;
                if (empty($tmp_obj->children())) {
                    $tmp_obj->addChild('texts');
                }
                $text = $tmp_obj->texts->addChild('text');
                $text->addAttribute('locale', $supported_locale);
                $text->addChild('textValue', $description_textValue);
                unset($text);
                //====================================== description FINAL ========================================================
                //====================================== headline START ========================================================
                $headline_textValue = isset($property->local_filds[$supported_locale]->summary) ? $property->local_filds[$supported_locale]->summary : " Property summary in $supported_locale lang is empty";
                $tmp_obj = &$xml->adContent->headline;
                if (empty($tmp_obj->children())) {
                    $tmp_obj->addChild('texts');
                }
                $text = $tmp_obj->texts->addChild('text');
                $text->addAttribute('locale', $supported_locale);
                $text->addChild('textValue', $headline_textValue);
                unset($text);
                //====================================== headline FINAL ========================================================
                //====================================== ownerListingStory START ========================================================
                $xml->adContent->ownerListingStory = 'Not in system';
                //====================================== ownerListingStory FINAL ========================================================
                //====================================== propertyName START ========================================================
                $propertyName_textValue = isset($property->local_filds[$supported_locale]->name) ? $property->local_filds[$supported_locale]->name : " Property name in $supported_locale lang is empty";
                $tmp_obj = &$xml->adContent->propertyName;
                if (empty($tmp_obj->children())) {
                    $tmp_obj->addChild('texts');
                }
                $text = $tmp_obj->texts->addChild('text');
                $text->addAttribute('locale', $supported_locale);
                $text->addChild('textValue', $propertyName_textValue);
                unset($text);
                //====================================== propertyName FINAL ========================================================
                //====================================== uniqueBenefits START ========================================================
                $uniqueBenefits_textValue = isset($property->local_filds[$supported_locale]->access) ? $property->local_filds[$supported_locale]->access : " Property access in $supported_locale lang is empty";
                $uniqueBenefits_textValue .= isset($property->local_filds[$supported_locale]->space) ? ' '.$property->local_filds[$supported_locale]->space : " Property space in $supported_locale lang is empty";
                $tmp_obj = &$xml->adContent->uniqueBenefits;
                if (empty($tmp_obj->children())) {
                    $tmp_obj->addChild('texts');
                }
                $text = $tmp_obj->texts->addChild('text');
                $text->addAttribute('locale', $supported_locale);
                $text->addChild('textValue', $uniqueBenefits_textValue);
                unset($text);
                //====================================== uniqueBenefits FINAL ========================================================
                //====================================== whyPurchased START ========================================================
                $xml->adContent->whyPurchased = 'Not in system';
                //====================================== whyPurchased FINAL ========================================================
                //====================================== yearPurchased START ========================================================
                $xml->adContent->yearPurchased = 'Not in system';
                //====================================== yearPurchased FINAL ========================================================
            }
        }
        unset($tmp_obj);
        //====================================== featureValues START ========================================================
        foreach ($property->amenities as $amenity) {
            if ($amenity->expedia) {
                $featureValue = $xml->featureValues->addChild('featureValue');
                $featureValue->addChild('count', '1');
                $featureValue->addChild('listingFeatureName', $amenity->expedia);
            }
        }
        //====================================== featureValues FINAL ========================================================
        //====================================== location START ========================================================
        $xml->location->address->addressLine1 = $property->info->street;
        $xml->location->address->addressLine2 = $property->info->additional_information;
        $xml->location->address->city = $property->info->city;
        $xml->location->address->stateOrProvince = $property->info->state;
        $xml->location->address->country = $property->info->country;
        $xml->location->address->postalCode = $property->info->post_code;
        //$xml->location->description = 'Unsupported';
        $xml->location->geoCode->latLng->latitude = explode(',', $property->info->gps_coordinates)[0];
        $xml->location->geoCode->latLng->longitude = explode(',', $property->info->gps_coordinates)[1];
        //$xml->location->nearestPlaces = 'Unsupported';
        //$xml->location->otherActivities = 'Unsupported';
        $xml->location->showExactLocation = 'Not in system';
        //====================================== location FINAL ========================================================
        //====================================== images START ========================================================images_core, mlanguages
        $literal_tegname_title = 'title_';
        foreach ($property->images as $image) {
            $image_xml = $xml->images->addChild('image');
            $image_xml->addChild('externalId', "{$property->hms_id}-{$property->id}-$image->id");
            if (!empty($image->tags)) {
                foreach ($image->tags as $tag) {
                    if (!$image_xml->$literal_tegname_title) {
                        $image_xml->addChild($literal_tegname_title)->addChild('texts');
                    }
                    foreach ($property->supported_locales_namekeys as $supported_locale) {
                        $text = $image_xml->$literal_tegname_title->texts->addChild('text');
                        $text->addAttribute('locale', $supported_locale);
                        $text->addChild('textValue',  $this->mlanguages->getdictionaryword('setup_property_c2_property_foto', $property->locales[$supported_locale]->ch3, "-{$tag}-"));
                        unset($text);
                    }
                }
            } else {
                $image_xml->addChild($literal_tegname_title, 'No tags');
            }
            $image_xml->addChild('uri', $this->images_core->get_property_img_url(['property_id'=>$property->id, 'id_position'=>$image->id_position]));
        }
        foreach ($room->images as $image) {
            $image_xml = $xml->images->addChild('image');
            $image_xml->addChild('externalId', "{$property->hms_id}-{$room->id}-$image->id");
            if (!empty($image->tags)) {
                foreach ($image->tags as $tag) {
                    if (!$image_xml->$literal_tegname_title) {
                        $image_xml->addChild($literal_tegname_title)->addChild('texts');
                    }
                    foreach ($room->supported_locales_namekeys as $supported_locale) {
                        $text = $image_xml->$literal_tegname_title->texts->addChild('text');
                        $text->addAttribute('locale', $supported_locale);
                        $text->addChild('textValue',  $this->mlanguages->getdictionaryword('setup_property_c2_property_foto', $room->locales[$supported_locale]->ch3, "-{$tag}-"));
                        unset($text);
                    }
                }
            } else {
                $image_xml->addChild($literal_tegname_title, 'No tags');
            }
            $image_xml->addChild('uri', $this->images_core->get_category_img_url(['category_id'=>$room->id, 'id_position'=>$image->id_position]));
        }
        //====================================== images FINAL ========================================================
        //echo $xml->asXML();

        $dom = new DOMDocument("1.0");
        $dom->preserveWhiteSpace = false;
        $dom->formatOutput = true;
        $dom->loadXML($xml->asXML());
        echo $dom->saveXML();
    }


    public function room_for_testing($id = null) {
        $room = new Room($id, ['options'=>['info', 'supported_locales', 'local_filds', 'amenities', 'images']]);
        $property = new Property($room->info->property_id, ['options'=>['info', 'supported_locales', 'local_filds', 'amenities', 'images']]);
        $xml = simplexml_load_file('/var/vhosts/desks-dev.otelms.com/html/application/views/templates/vrbo/xml_tmpts/content_clear.xml');
        $xml->externalId = "{$property->hms_id}-$property->id";
        $xml->lastUpdatedDate = date('c');
        $xml->active = 'Not in system';
        foreach ($property->supported_locales_namekeys as $supported_locale) {
            if (in_array($supported_locale, $this->vrbo_supported_locales)) {
                //====================================== accommodationsSummary START ========================================================
                $accommodationsSummary_textValue = isset($room->local_filds[$supported_locale]->name) ? $room->local_filds[$supported_locale]->name : "Category name in $supported_locale lang is empty";
                $accommodationsSummary_textValue .= isset($property->local_filds[$supported_locale]->name) ? ' '.$property->local_filds[$supported_locale]->name : " Property name in $supported_locale lang is empty";

                $tmp_obj = &$xml->adContent->accommodationsSummary;
                if (empty($tmp_obj->children())) {
                    $tmp_obj->addChild('texts');
                }
                $text = $tmp_obj->texts->addChild('text');
                $text->addAttribute('locale', $supported_locale);
                $text->addChild('textValue', $accommodationsSummary_textValue);
                unset($text);
                //====================================== accommodationsSummary FINAL ========================================================
                //====================================== description START ========================================================
                $description_textValue = isset($room->local_filds[$supported_locale]->comment) ? $room->local_filds[$supported_locale]->comment : "Category comment in $supported_locale lang is empty";
                $description_textValue .= isset($property->local_filds[$supported_locale]->summary) ? ' '.$property->local_filds[$supported_locale]->summary : " Property summary in $supported_locale lang is empty";
                $tmp_obj = &$xml->adContent->description;
                if (empty($tmp_obj->children())) {
                    $tmp_obj->addChild('texts');
                }
                $text = $tmp_obj->texts->addChild('text');
                $text->addAttribute('locale', $supported_locale);
                $text->addChild('textValue', $description_textValue);
                unset($text);
                //====================================== description FINAL ========================================================
                //====================================== headline START ========================================================
                $headline_textValue = isset($property->local_filds[$supported_locale]->summary) ? $property->local_filds[$supported_locale]->summary : " Property summary in $supported_locale lang is empty";
                $tmp_obj = &$xml->adContent->headline;
                if (empty($tmp_obj->children())) {
                    $tmp_obj->addChild('texts');
                }
                $text = $tmp_obj->texts->addChild('text');
                $text->addAttribute('locale', $supported_locale);
                $text->addChild('textValue', $headline_textValue);
                unset($text);
                //====================================== headline FINAL ========================================================
                //====================================== ownerListingStory START ========================================================
                $xml->adContent->ownerListingStory = 'Not in system';
                //====================================== ownerListingStory FINAL ========================================================
                //====================================== propertyName START ========================================================
                $propertyName_textValue = isset($property->local_filds[$supported_locale]->name) ? $property->local_filds[$supported_locale]->name : " Property name in $supported_locale lang is empty";
                $tmp_obj = &$xml->adContent->propertyName;
                if (empty($tmp_obj->children())) {
                    $tmp_obj->addChild('texts');
                }
                $text = $tmp_obj->texts->addChild('text');
                $text->addAttribute('locale', $supported_locale);
                $text->addChild('textValue', $propertyName_textValue);
                unset($text);
                //====================================== propertyName FINAL ========================================================
                //====================================== uniqueBenefits START ========================================================
                $uniqueBenefits_textValue = isset($property->local_filds[$supported_locale]->access) ? $property->local_filds[$supported_locale]->access : " Property access in $supported_locale lang is empty";
                $uniqueBenefits_textValue .= isset($property->local_filds[$supported_locale]->space) ? ' '.$property->local_filds[$supported_locale]->space : " Property space in $supported_locale lang is empty";
                $tmp_obj = &$xml->adContent->uniqueBenefits;
                if (empty($tmp_obj->children())) {
                    $tmp_obj->addChild('texts');
                }
                $text = $tmp_obj->texts->addChild('text');
                $text->addAttribute('locale', $supported_locale);
                $text->addChild('textValue', $uniqueBenefits_textValue);
                unset($text);
                //====================================== uniqueBenefits FINAL ========================================================
                //====================================== whyPurchased START ========================================================
                $xml->adContent->whyPurchased = 'Not in system';
                //====================================== whyPurchased FINAL ========================================================
                //====================================== yearPurchased START ========================================================
                $xml->adContent->yearPurchased = 'Not in system';
                //====================================== yearPurchased FINAL ========================================================
            }
        }
        unset($tmp_obj);
        //====================================== featureValues START ========================================================
        foreach ($property->amenities as $amenity) {
            if ($amenity->expedia) {
                $featureValue = $xml->featureValues->addChild('featureValue');
                $featureValue->addChild('count', '1');
                $featureValue->addChild('listingFeatureName', $amenity->expedia);
            }
        }
        //====================================== featureValues FINAL ========================================================
        //====================================== location START ========================================================
        $xml->location->address->addressLine1 = $property->info->street;
        $xml->location->address->addressLine2 = $property->info->additional_information;
        $xml->location->address->city = $property->info->city;
        $xml->location->address->stateOrProvince = $property->info->state;
        $xml->location->address->country = $property->info->country;
        $xml->location->address->postalCode = $property->info->post_code;
        //$xml->location->description = 'Unsupported';
        $xml->location->geoCode->latLng->latitude = explode(',', $property->info->gps_coordinates)[0];
        $xml->location->geoCode->latLng->longitude = explode(',', $property->info->gps_coordinates)[1];
        //$xml->location->nearestPlaces = 'Unsupported';
        //$xml->location->otherActivities = 'Unsupported';
        $xml->location->showExactLocation = 'Not in system';
        //====================================== location FINAL ========================================================
        //====================================== images START ========================================================images_core, mlanguages
        $literal_tegname_title = 'title_';
        foreach ($property->images as $image) {
            $image_xml = $xml->images->addChild('image');
            $image_xml->addChild('externalId', "{$property->hms_id}-{$property->id}-$image->id");
            if (!empty($image->tags)) {
                foreach ($image->tags as $tag) {
                    if (!$image_xml->$literal_tegname_title) {
                        $image_xml->addChild($literal_tegname_title)->addChild('texts');
                    }
                    foreach ($property->supported_locales_namekeys as $supported_locale) {
                        $text = $image_xml->$literal_tegname_title->texts->addChild('text');
                        $text->addAttribute('locale', $supported_locale);
                        $text->addChild('textValue',  $this->mlanguages->getdictionaryword('setup_property_c2_property_foto', $property->locales[$supported_locale]->ch3, "-{$tag}-"));
                        unset($text);
                    }
                }
            } else {
                $image_xml->addChild($literal_tegname_title, 'No tags');
            }
            $image_xml->addChild('uri', $this->images_core->get_property_img_url(['property_id'=>$property->id, 'id_position'=>$image->id_position]));
        }
        foreach ($room->images as $image) {
            $image_xml = $xml->images->addChild('image');
            $image_xml->addChild('externalId', "{$property->hms_id}-{$room->id}-$image->id");
            if (!empty($image->tags)) {
                foreach ($image->tags as $tag) {
                    if (!$image_xml->$literal_tegname_title) {
                        $image_xml->addChild($literal_tegname_title)->addChild('texts');
                    }
                    foreach ($room->supported_locales_namekeys as $supported_locale) {
                        $text = $image_xml->$literal_tegname_title->texts->addChild('text');
                        $text->addAttribute('locale', $supported_locale);
                        $text->addChild('textValue',  $this->mlanguages->getdictionaryword('setup_property_c2_property_foto', $room->locales[$supported_locale]->ch3, "-{$tag}-"));
                        unset($text);
                    }
                }
            } else {
                $image_xml->addChild($literal_tegname_title, 'No tags');
            }
            $image_xml->addChild('uri', $this->images_core->get_category_img_url(['category_id'=>$room->id, 'id_position'=>$image->id_position]));
        }
        //====================================== images FINAL ========================================================
        //echo $xml->asXML();

        $dom = new DOMDocument("1.0");
        $dom->preserveWhiteSpace = false;
        $dom->formatOutput = true;
        $dom->loadXML($xml->asXML());
        echo $dom->saveXML();
    }


    public function test() {
        $xml = simplexml_load_file('/var/vhosts/desks-dev.otelms.com/html/application/views/templates/vrbo/xml_tmpts/example_content.xml');
        $xml_clear = simplexml_load_file('/var/vhosts/desks-dev.otelms.com/html/application/views/templates/vrbo/xml_tmpts/content_clear.xml');
        $xml_clear = json_encode($xml_clear);
        $xml_clear = json_decode($xml_clear, 1);
        echo "<pre>";
        print_r($xml);
        var_export($xml);
        print_r($xml_clear);
        var_export($xml_clear);

        $xml = json_encode($xml);
        $xml = json_decode($xml, 1);
        var_export($xml);



    }

    private function make_locale_text_xml_str($p) {
        $locale = $p['locale'] ? $p['locale'] : '';
        $txt = $p['txt'] ? $p['txt'] : '';
        return "<text locale=\"$locale\">
<textValue>$txt</textValue>
</text>
";
    }
}

class HmsHotel {
    private $tbls;

    public $hms_id,
    $locales = [],
    $supported_locales = [],
    $supported_locales_namekeys = [];

    public function __construct($p = ['options' => null]) {
        $this->tbls = (object) [
            'locales' => '`global_hotelix`.`dic_languages`',
            'supported_locales' => 'descriptionlanguages'
        ];
        $this->set_hms_id();
        $this->do_setters($p['options']);
    }

    public function get_CI_Controller() {
        return CI_Controller::get_instance();
    }

    private function do_setters($options){
        if ($options) {
            foreach ($options as $method) {
                if (method_exists(__CLASS__, "set_$method")) {
                    $this->{"set_$method"}();
                };
            }
        }
    }

    protected function set_hms_id() {
        $cic = $this->get_CI_Controller();
        $this->hms_id = $cic->config->item('hotel_id');
    }

    protected function set_supported_locales() {
        $cic = $this->get_CI_Controller();
        if (!count($this->locales)) {
            $t1 = $this->tbls->locales;
            $locales  = $cic->db->select("$t1.*, $t1.2char as ch2, $t1.3char as ch3")->get($t1)->result();
            foreach ($locales as $local) {
                $this->locales[$local->ch2] = $local;
            }
        }
        if (!count($this->supported_locales)) {
            $supported_locales  = $cic->db->get($this->tbls->supported_locales)->result();
            foreach ($supported_locales as $local) {
                $this->supported_locales[$local->name] = $local;
                $this->supported_locales_namekeys[$local->code] = $local->name;
            }
        }
        unset($cic);
    }
}

class Property extends HmsHotel{

    private $tbls = [
        'props' => 'property_information',
        'local_fields' => 'internationalfields',
        'amenities' => 'property_ameneties',
        'subj2amenity' => 'property2ameneties',
        'images' => 'property_images_registry',
        'subj2img2tag' => 'property_fototags',
        'fototags' => 'fototags',
    ];
    public $id;
    public $info;
    public $local_filds = [];
    public $amenities = [];
    public $images = [];

    public function __construct($id = null, $p = ['options' => null]) {
        parent::__construct (['options' => $p['options']]);
        $this->set_id($id);
        $this->tbls = (object)$this->tbls;
        if ($this->id) {
            $this->do_setters($p['options']);
        }
    }

    private function do_setters($options){
        if ($options) {
            foreach ($options as $method) {
                if (method_exists(__CLASS__, "set_$method")) {
                    $this->{"set_$method"}();
                };
            }
        }
    }

    protected function set_id($id) {
        $this->id = $id;
    }

    protected function set_info() {
        $cic = $this->get_CI_Controller();
        $this->info = $cic->db->get_where($this->tbls->props, ['id' => $this->id])->row();
    }

    private function set_local_filds(){
        $cic = $this->get_CI_Controller();
        $type = 'property_custom';
        $where_arr = ['table_type' => $type, 'table_id' => $this->id];
        $local_filds = $cic->db->where_in('language_id', array_keys($this->supported_locales_namekeys))->get_where($this->tbls->local_fields, $where_arr)->result();
        foreach ($local_filds as $fild) {
            $lang_key = $this->supported_locales_namekeys[$fild->language_id];
            if (!isset($this->local_filds[$lang_key])) {
                $this->local_filds[$lang_key] = (object)[];
            }
            $this->local_filds[$lang_key]->{str_replace('international_', '', $fild->name)} = $fild->value;
        }
    }

    private function set_amenities(){
        $cic = $this->get_CI_Controller();
        $amenities = $cic->db->select()
        ->from($this->tbls->amenities)
        ->join($this->tbls->subj2amenity, "{$this->tbls->subj2amenity}.amenity_id = {$this->tbls->amenities}.id")
        ->where([$this->tbls->subj2amenity.'.property_id' => $this->id])
        ->get()->result();
        $this->amenities = $amenities;
    }

    private function set_images(){
        $cic = $this->get_CI_Controller();
        $t1 = $this->tbls->images;
        $t2 = $this->tbls->subj2img2tag;
        $t3 = $this->tbls->fototags;
        $images = $cic->db->select("$t1.*, $t2.*, $t3.name as tag_name")
        ->from($t1)
        ->join($t2, "{$t2}.foto_id = {$t1}.id", 'left')// AND {$t2}.property_id = {$t1}.property_id
        ->join($t3, "{$t2}.tag_id = {$t3}.id", 'left')
        ->where([$t1.'.property_id' => $this->id])
        ->get()->result();
        foreach ($images as $image) {
            if (!isset($this->images[$image->id])) {
                $this->images[$image->id] = $image;
                if ($image->tag_id) {
                    $this->images[$image->id]->tags[] = $image->tag_name;
                }else {
                    $this->images[$image->id]->tags = [];
                }
                unset($this->images[$image->id]->tag_id, $this->images[$image->id]->tag_name);
            }else {
                $this->images[$image->id]->tags[] = $image->tag_name;
            }
        }
    }
}

class Room extends HmsHotel{

    private $tbls = [
        'rooms' => 'categories',
        'local_fields' => 'internationalfields',
        'amenities' => 'category_ameneties',
        'subj2amenity' => 'category2amenities',
        'images' => 'category_images_registry',
        'subj2img2tag' => 'category_fototags',
        'fototags' => 'fototags',
    ];
    public $id;
    public $info;
    public $local_filds = [];
    public $amenities = [];
    public $images = [];

    public function __construct($id = null, $p = ['options' => null]) {
        parent::__construct (['options' => $p['options']]);
        $this->tbls = (object)$this->tbls;
        $this->set_id($id);
        if ($this->id) {
            $this->do_setters($p['options']);
        }
    }

    private function do_setters($options){
        if ($options) {
            foreach ($options as $method) {
                if (method_exists(__CLASS__, "set_$method")) {
                    $this->{"set_$method"}();
                };
            }
        }
    }

    protected function set_id($id) {
        $this->id = $id;
    }

    protected function set_info() {
        $cic = $this->get_CI_Controller();
        $this->info = $cic->db->get_where($this->tbls->rooms, ['id' => $this->id])->row();;
    }

    private function set_local_filds(){
        $cic = $this->get_CI_Controller();
        $type = 'category';
        $where_arr = ['table_type' => $type, 'table_id' => $this->id];
        $local_filds = $cic->db->where_in('language_id', array_keys($this->supported_locales_namekeys))->get_where($this->tbls->local_fields, $where_arr)->result();
        foreach ($local_filds as $fild) {
            $lang_key = $this->supported_locales_namekeys[$fild->language_id];
            if (!isset($this->local_filds[$lang_key])) {
                $this->local_filds[$lang_key] = (object)[];
            }
            $this->local_filds[$lang_key]->{str_replace('international_', '', $fild->name)} = $fild->value;
        }
    }

    private function set_amenities(){
        $cic = $this->get_CI_Controller();
        $amenities = $cic->db->select()
        ->from($this->tbls->amenities)
        ->join($this->tbls->subj2amenity, "{$this->tbls->subj2amenity}.amenity_id = {$this->tbls->amenities}.id")
        ->where([$this->tbls->subj2amenity.'.category_id' => $this->id])
        ->get()->result();
        $this->amenities = $amenities;
    }

    private function set_images(){
        $cic = $this->get_CI_Controller();
        $t1 = $this->tbls->images;
        $t2 = $this->tbls->subj2img2tag;
        $t3 = $this->tbls->fototags;
        $images = $cic->db->select("$t1.*, $t2.*, $t3.name as tag_name")
        ->from($t1)
        ->join($t2, "{$t2}.foto_id = {$t1}.id", 'left')// AND {$t2}.category_id = {$t1}.category_id
        ->join($t3, "{$t2}.tag_id = {$t3}.id", 'left')
        ->where([$t1.'.category_id' => $this->id])
        ->get()->result();
        foreach ($images as $image) {
            if (!isset($this->images[$image->id])) {
                $this->images[$image->id] = $image;
                if ($image->tag_id) {
                    $this->images[$image->id]->tags[] = $image->tag_name;
                }else {
                    $this->images[$image->id]->tags = [];
                }
                unset($this->images[$image->id]->tag_id, $this->images[$image->id]->tag_name);
            }else {
                $this->images[$image->id]->tags[] = $image->tag_name;
            }
        }
    }
}