<?php
class Tables {
	var $ta_hotels = "`global_hotelix`.`dc_ta_hotels`";
	var $h_config = 'hotelix_config';
	var $prop_info = "property_information";//property_custom_information
	var $prop_ameneties = "property_ameneties";
	var $prop2amenety = "property2ameneties";
	var $currency_rates_today = "`global_hotelix`.currency_rates_today";
	var $currencies = '`global_hotelix`.`currency`';
	var $supported_langs = 'descriptionlanguages';
	var $availability = "deskofdays_availability";
	var $inter = "internationalfields";
	var $room_views = "global_hotelix_common.room_view_type";
	var $beds2rooms = "beds2rooms";
	var $room_params = "category_room_param";
	var $bed_types = "`global_hotelix_common`.`bed_types`";
	var $room_photos = "category_images_registry";
	var $category2amenities = "category2amenities";
	var $category_ameneties = "global_hotelix_common.category_ameneties";
	var $cancelations = "`global_hotelix_common`.`dc_cancelationpolicy_list`";
	var $cancelation_types = "`global_hotelix_common`.`cancellationpolicy_types`";
	var $meal_policies = "meal_policies";
	var $age_ranges = "age_ranges_acb";
	var $reservations = "deskofreservation";
	var $groups = "groupreservations";
	var $servises = "services_main";
	var $servises_tf = "services_tf";
	var $countries = "global_fms_base.dict_country";
	var $ta_reservations = "ta_reservations";
}
class Gateway_pmv3 extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		//ini_set('error_reporting', E_STRICT);
		$this->db_tables =  new Tables();
		$this->load->model ( 'Access' );
		$this->load->model ( 'dc_model' );//для якоїсь ОДНОЇ хні у фронтдеску для ОДНОГО каналу... ну ок, грузим
		$this->load->model ( 'cancel' );
		$this->load->model ( 'frontdesk' );// модель санцель грузить 2 фронта і логер
		$this->load->model ( 'frontdesk_c2' );// модель санцель грузить 2 фронта і логер
		$this->load->model ( 'taxesfees_model' );
		$this->load->model ( 'monline_module' );
		$this->load->model ( 'formsprinter_model_v2' );
		$this->load->model ( 'hotelix_config' );
	}

	public function get_freerooms(){
	    $request = file_get_contents("php://input");
	    $request = json_decode($request, true);
	    $response_data = array(
	        'request' => $request,
	        'debug' => array()
	    );
	    $response = array();
	    $date_range_exploded = explode(" - ", $request['date_range']);
	    $date_in = $response['date_in'] = $date_range_exploded[0];
	    $date_out = $response['date_out'] = $date_range_exploded[1];
	    $int_datein = round(strtotime($date_in) / 86400);
	    $int_dateout = round(strtotime($date_out) / 86400);
	    $requested_rooms_count = $response['requested_rooms_count'] = count($request['parties']);
	    $hms_guests_set = array();
	    $max_requested_persons = 1;

	    $promocode_is_valid = $promocode_needs_calculation = false;
	    $promo_data = array();
	    if ($request['promocode'] !=''){
	        $promo_version = $this->releases->online_propmocodes_veersion();
	        /*версія
	         * 1 - стара логіка з промо
	         * 2 - нова логіка
	         */
	        /*тип знижки
	         *  percent = 1;
	         *  fixed = 2;
	         */
	        switch ($promo_version) {
                case 1:
                    $tbl = 'onlinediscount';
                    $query_row = $this->db->select('percent')
                        ->from($tbl)
                        ->where(array(
                        'code' => $request['promocode']
                    ))
                        ->where("'$date_in' BETWEEN datestart AND dateend AND '$date_out' BETWEEN datestart AND dateend", NULL, false)
                        ->get()
                        ->row();
                    if ($query_row) {
                        $promocode_is_valid = true;
                        $promo_data['type_txt'] = 'percent';
                        $promo_data['type_id'] = 1;
                        $promo_data['value'] = $query_row->percent;
                    }
                    break;
                case 2:

                    $tbl = 'promocodes';
                    $query_row = $this->db->select('id, discount_value, discount_type')
                        ->from($tbl)
                        ->where(array(
                        'code' => $request['promocode'],
                        'status' => 1
                    ))
                        ->where("'$date_in' BETWEEN datestart AND dateend AND '$date_out' BETWEEN datestart AND dateend AND counter > 0", NULL, false)
                        ->get()
                        ->row();

                    $response_data['debug']['promo_sql'] = $this->db->last_query();

                    if ($query_row) {
                        $promocode_needs_calculation = true;

                        $whr_arr = array('promocode_id ' => $query_row->id);

                        $tbl = 'promocodes2categories';
                        $promoted_cats = array();
                        $query_promoted_cats = $this->db->select('category_id as id')->get_where($tbl, $whr_arr)->result();
                        foreach ($query_promoted_cats as $cat) {
                                array_push($promoted_cats, $cat->id);
                        }

                        $tbl = 'promocodes2rates';
                        $promoted_rates = array();
                        $query_promoted_rates = $this->db->select('rate_id as id')->get_where($tbl, $whr_arr)->result();
                        foreach ($query_promoted_rates as $rate) {
                            array_push($promoted_rates, $rate->id);
                        }

                        $response_data['debug']['promoted_rates'] = $promoted_rates;
                        $response_data['debug']['promoted_cats'] = $promoted_cats;


                        if (count($promoted_cats) && count($promoted_rates)) {
                            $promocode_is_valid = true;
                            $promo_data['type_txt'] = $query_row->discount_type == 1 ? 'percent' : 'fixed';
                            $promo_data['type_id'] = $query_row->discount_type == 1 ? 1 : 2;
                            $promo_data['value'] = $query_row->discount_value;
                        }
                    }
                    break;
	        }
	    }

	    foreach ($request['parties'] as $party) {
	        $hms_guests = $this->party_to_hms_guests((object)$party);
	        array_push($hms_guests_set, $hms_guests);
	        $children_count = (isset($party['children'])) ? count($party['children']) : 0;
	        $party_guests_count = $party['adults'] + $children_count;
	        if ($party_guests_count > $max_requested_persons) {
	            $max_requested_persons = $party_guests_count;
	        }
	    }
	    $response['max_requested_persons'] = $max_requested_persons;

	    $fitted_prop_id_where_str = '';
	    if (isset($request['checked_prop_id'])) {
	        $fitted_prop_id_where_str = " AND categories.property_id = ".$request['checked_prop_id'];
	    }
	    $query_fited_cats_res = $this->db->distinct()
        ->select('categories.id, property_information.check_in_time, property_information.check_out_time')
        ->from('categories')
        ->join('property_information', 'property_information.id = categories.property_id')
        ->join('rooms', 'rooms.category_id = categories.id')
        ->where("categories.web_booking = 1 $fitted_prop_id_where_str")
        ->get()
        ->result();

        $fited_cats = $fited_cats_check_in_out_times = array();
        foreach ($query_fited_cats_res as $category) {
            array_push($fited_cats, $category->id);
            $fited_cats_check_in_out_times[$category->id] = $category;
        }
        $fited_cats_str = count($fited_cats) ?  implode(',', $fited_cats) : '0';
        
	    $sql = "SELECT  t1.category_id, min(t1.count) as rooms_remaining, categories.property_id,
	    IF(ratetocategory.maxplace, ratetocategory.maxplace, categories.add_places) AS max_room_places, ratetocategory.rate_id,
	    rate.ccforce as ccforce, online_rate_data.ccamount_type as ccamount_type, online_rate_data.ccamount as ccamount,
	    MAX(IF(deskofrate.intdate != $int_dateout, deskofrate.closed, 0)) AS isclosed, MAX(IF(deskofrate.intdate != $int_dateout, deskofrate.minstaythrought, 0)) AS maxminstaythrought,
        MIN(deskofrate.maxstay) as minmaxstay,
        MAX(IF(deskofrate.intdate = $int_dateout, deskofrate.closedondeparture, 0)) AS closedondeparture,
        MAX(IF(deskofrate.intdate = $int_datein, deskofrate.closedonarrival, 0)) AS closedonarrival,
        onlinerates.timeshift as rate_specialoffer_timeshift
	    FROM deskofdays_availability AS t1
	    JOIN categories ON categories.id = t1.category_id
	    JOIN ratetocategory ON ratetocategory.category_id = t1.category_id AND ratetocategory.onlinebook = 1
	    JOIN rate ON rate.id = ratetocategory.rate_id AND rate.isactive = 1
	    LEFT JOIN online_rate_data ON online_rate_data.rate_id = rate.id
	    JOIN onlinerates ON onlinerates.rateid = ratetocategory.rate_id
	    LEFT JOIN deskofrate ON deskofrate.rate_id = onlinerates.restrictid AND deskofrate.category_id = categories.id  AND deskofrate.intdate BETWEEN $int_datein AND $int_dateout
	    WHERE t1.intdate >= $int_datein AND t1.intdate < $int_dateout AND t1.category_id IN ($fited_cats_str)
	    GROUP BY t1.category_id, rate.id
	    HAVING max_room_places >= $max_requested_persons AND rooms_remaining >= $requested_rooms_count
            AND (isclosed = 0 OR ISNULL(isclosed))
            AND (ISNULL(maxminstaythrought) OR (maxminstaythrought <= ($int_dateout-$int_datein)))
            AND (minmaxstay = 0 OR ISNULL(minmaxstay) OR (minmaxstay >= ($int_dateout-$int_datein)))
            AND closedondeparture != 1
            AND closedonarrival != 1";

	    $response_data['debug']['freerooms_sql'] = $sql;//some for debug, on request side put in session

	    $query_res = $this->db->query($sql)->result_array();
	    $free_rooms = array();
	    foreach ($query_res as $set) {
	        if ($set['rate_specialoffer_timeshift'] != 0) {//Rate has one of special offers: Early bird or Last minute
	            $timeshift = $set['rate_specialoffer_timeshift'];
	            $def_check_in_time = '14:00';
	            $def_check_out_time = '12:00';
                $check_in_time = isset($fited_cats_check_in_out_times[$set['category_id']]) && $fited_cats_check_in_out_times[$set['category_id']]->check_in_time ? $fited_cats_check_in_out_times[$set['category_id']]->check_in_time : $def_check_in_time;
                $check_out_time = isset($fited_cats_check_in_out_times[$set['category_id']]) && $fited_cats_check_in_out_times[$set['category_id']]->check_out_time ? $fited_cats_check_in_out_times[$set['category_id']]->check_out_time : $def_check_out_time;
                
                $check_in_point = strtotime("$date_in $check_in_time");
                $booking_moment_point = strtotime('now');
                $diff_hours_between_points = round(($check_in_point - $booking_moment_point)/3600);
                
                if ($timeshift > 0 && $diff_hours_between_points < $timeshift) {//Early bird
                    continue;
                }
                if($timeshift < 0 && $diff_hours_between_points > abs($timeshift)){//Last minute
                    continue;
                }
	        }
	        $hms_parties_total_amount = 0;
	        $data_for_hms_party_amount = array();
	        $data_for_hms_party_tf_amount = array();
	        $data_for_hms_party_amount['prop_id'] = $data_for_hms_party_tf_amount['property_id'] = $set['property_id'];
	        $data_for_hms_party_amount['type_id'] = $set['category_id'];
	        $data_for_hms_party_amount['price_type'] = $set['rate_id'];
	        $data_for_hms_party_amount['datein'] = $date_in;
	        $data_for_hms_party_amount['dateout'] = $date_out;
	        $hms_all_parties_amount = 0;
	        $data_for_hms_party_tf_amount['duration'] = $int_dateout-$int_datein;
	        $hms_all_parties_tf_amount = 0;
	        foreach ($request['parties'] as $party) {
	            $hms_guests = $data_for_hms_party_tf_amount['guests'] = $this->party_to_hms_guests((object) $party, $set['category_id']);
	            $data_for_hms_party_amount = array_merge($data_for_hms_party_amount, $hms_guests);
	            $hms_party_amount = $this->frontdesk->get_otelms_amount($data_for_hms_party_amount);
	            $hms_all_parties_amount += $hms_party_amount;
	            $data_for_hms_party_tf_amount['amount'] = $hms_party_amount;
	            $data_for_hms_party_tf_amount['guest_ages'] = $this->party_to_hms_guests_ages((object) $party);
	            $tfs = $this->taxesfees_model->get_services_tf_data_by_property($data_for_hms_party_tf_amount);
	            $hms_party_tf_amount = 0;
	            foreach ($tfs as $tf_data) {
	                // $hms_party_tf_amount += $tf_data['amount']; tax
	            }
	            $hms_all_parties_tf_amount += $hms_party_tf_amount;
	        }
	        $hms_parties_total_amount = $hms_all_parties_amount + $hms_all_parties_tf_amount;
	        if ($hms_parties_total_amount == 0){
	            continue;
	        }
	        if (! isset($free_rooms[$set['category_id']])) {
	            $free_rooms[$set['category_id']] = array(
	                'category_id' => $set['category_id'],
	                'rooms_remaining' => $set['rooms_remaining'],
	                'max_room_places' => $set['max_room_places']
	            );
	        }

	        $is_set_cat_rate_is_promoted = false;
	        if ($promocode_is_valid) {
	            if ($promocode_needs_calculation) {//v2
	                if (in_array($set['category_id'], $promoted_cats) && in_array($set['rate_id'], $promoted_rates)) {
	                    $is_set_cat_rate_is_promoted = true;
	                }
	            }else{//v1
	                $is_set_cat_rate_is_promoted = true;//v1 all gategories and rates are promoted
	            }
	        }

	        $free_rooms[$set['category_id']]['rates'][$set['rate_id']] = array(
	            'rate_id' => $set['rate_id'],
	            'price' => $hms_parties_total_amount,
	            'ccforce' => $set['ccforce'],
	            'ccamount_type' => $set['ccamount_type'],
	            'ccamount' => $set['ccamount'],
	            'promoted' => $is_set_cat_rate_is_promoted,
	            'promo_data' => $is_set_cat_rate_is_promoted ? $promo_data : array(),
	        );
	    }
	    if (!empty($free_rooms)){
	        $response['hms_free_rooms'] = $free_rooms;
	    }else {
	        $response['hms_nofree_variants'] = array();//get variants
	        $right_date_shift = 10;
	        $sql = "SELECT  t1.intdate, t1.category_id, IF(deskofrate.closed, 0, t1.count) as avail_rooms,  categories.property_id,
                	    IF(ratetocategory.maxplace, ratetocategory.maxplace, categories.add_places) AS max_room_places, ratetocategory.rate_id,
                	    deskofrate.closed AS isclosed, deskofrate.minstaythrought AS minstay,deskofrate.maxstay, IFNULL(yieldprice.price, seasonspricelist.price) AS price,
                        onlinerates.timeshift as rate_specialoffer_timeshift,deskofrate.closedonarrival,deskofrate.closedondeparture
    	        FROM deskofdays_availability AS t1
    	        JOIN categories ON categories.id = t1.category_id AND categories.web_booking = 1
    	        JOIN ratetocategory ON ratetocategory.category_id = t1.category_id AND ratetocategory.onlinebook = 1
    	        JOIN rate ON rate.id = ratetocategory.rate_id AND rate.isactive = 1
    	        JOIN onlinerates ON onlinerates.rateid = ratetocategory.rate_id
                JOIN deskofdaysseason ON deskofdaysseason.intdate = t1.intdate
				JOIN seasons ON seasons.id = deskofdaysseason.seasonid AND seasons.is_active = 1
				JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id AND seasonspricelist.category_id = categories.id AND seasonspricelist.season_id = seasons.id
                LEFT JOIN yieldprice ON yieldprice.id_restrict_rate	= rate.id AND yieldprice.category_id = t1.category_id AND yieldprice.intdate = t1.intdate
    	        LEFT JOIN deskofrate ON deskofrate.rate_id = onlinerates.restrictid AND deskofrate.category_id = categories.id  AND deskofrate.intdate = t1.intdate
    	        WHERE t1.intdate >= $int_datein AND t1.intdate < $int_dateout + $right_date_shift
    	        GROUP BY t1.intdate, t1.category_id, rate_id
                HAVING max_room_places >= $max_requested_persons";
	        $response_data['debug']['nofree_variants_sql'] = $sql;
	        $query_res = $this->db->query($sql)->result();
	        foreach ($query_res as $set) {
	            $response['hms_nofree_variants'][$set->category_id][$set->rate_id][$set->intdate]['property_id'] = $set->property_id;
	            $response['hms_nofree_variants'][$set->category_id][$set->rate_id][$set->intdate]['rate_specialoffer_timeshift'] = $set->rate_specialoffer_timeshift;
	            $response['hms_nofree_variants'][$set->category_id][$set->rate_id][$set->intdate]['rooms'] = $set->avail_rooms;
	            $response['hms_nofree_variants'][$set->category_id][$set->rate_id][$set->intdate]['minstay'] = $set->minstay ? $set->minstay : 0;
	            $response['hms_nofree_variants'][$set->category_id][$set->rate_id][$set->intdate]['maxstay'] = $set->maxstay ? $set->maxstay : 365;
	            $response['hms_nofree_variants'][$set->category_id][$set->rate_id][$set->intdate]['isclosed'] = $set->isclosed ? $set->isclosed : 0;
	            $response['hms_nofree_variants'][$set->category_id][$set->rate_id][$set->intdate]['price'] = $set->price ? $set->price : 0;
	            $response['hms_nofree_variants'][$set->category_id][$set->rate_id][$set->intdate]['closedonarrival'] = $set->closedonarrival ? $set->closedonarrival : 0;
	            $response['hms_nofree_variants'][$set->category_id][$set->rate_id][$set->intdate]['closedondeparture'] = $set->closedondeparture ? $set->closedondeparture : 0;
	            
	        }
	    }

	    $response_data['response'] = $response;
	    echo json_encode($response_data);
	}
	
	public function get_freeprops(){
	    $request = file_get_contents("php://input");
	    $request = json_decode($request, true);
	    $response_data = array(
	        'request' => $request,
	        'debug' => array()
	    );
	    $query_fited_props_res = $this->db->distinct()
	    ->select('categories.property_id')
	    ->select('
property_information.property_name,
property_information.property_name_english,
property_information.dwelling,
property_information.property_type,
property_information.street,
property_information.additional_information,
property_information.city,
property_information.state,
property_information.post_code,
property_information.country,
property_information.gps_coordinates,
property_information.reception_phone,
property_information.email,
property_information.web_address,
property_information.star_rating
        ')
	    ->from('categories')
	    ->join('rooms', 'rooms.category_id = categories.id')
	    ->join('property_information', 'categories.property_id = property_information.id')
	    ->where('categories.web_booking =1')
	    ->get()
	    ->result();
	    
	    $response_data['response']['properties'] = $query_fited_props_res;
	    
	    //$storage_url = 'https://media-data-storage.otelms.com/storage/property_images/hms_92/property_images_92_4_1_1.jpg';
	    $hotel_id = $this->config->item('hotel_id');
	    $storage_url = "https://media-data-storage.otelms.com/storage/property_images/hms_$hotel_id/property_images_$hotel_id";
	    foreach ($response_data['response']['properties'] as &$property) {
	        $property->street .= ", $property->city";
	        $property->images = array();
	        $query_props_images = $this->db
            ->select('*')
            ->get_where('property_images_registry', array('property_images_registry.property_id' => $property->property_id))
            ->result();
            if ($query_props_images) {
                foreach ($query_props_images as $image) {
                    array_push($property->images, array(
                        'small_image_url' => "{$storage_url}_{$image->property_id}_{$image->id_position}_1",
                        'image_url' => "{$storage_url}_{$image->property_id}_{$image->id_position}_2"
                    ));
	            }
	        }
	        $property->rooms = array();
	        $query_props_rooms = $this->db
	        ->select('id')
	        ->get_where('categories', array('categories.property_id' => $property->property_id))
	        ->result();
	        foreach ($query_props_rooms as $room) {
	            array_push($property->rooms, $room->id);
	        }
	        $property->amenities = array();
	        $query_props_amenities = $this->db
	        ->select('global_hotelix_common.property_ameneties.name')
	        ->from('global_hotelix_common.property_ameneties')
	        ->join('property2ameneties', 'property2ameneties.amenity_id = global_hotelix_common.property_ameneties.id')
	        ->where(array('property2ameneties.property_id' => $property->property_id))
	        ->limit(5, 0)
	        ->get()
	        ->result();
	        foreach ($query_props_amenities as $amenity) {
	            array_push($property->amenities, array('name' => "{-{$amenity->name}-}"));
	        }
	    }
	    unset($property);
	    
	    echo json_encode($response_data);
	}

	public function booking_request() {//curl
	    $t = &$this->db_tables;
	    $request_data = file_get_contents("php://input");
	    $request_data = json_decode($request_data, true);

	    $dcs = $this->accepted_dcs_through_pmw3();
	    if (isset($request_data['booking_data']['dc_id']) && isset($dcs[$request_data['booking_data']['dc_id']])){
	        $dc_id = $request_data['booking_data']['dc_id'];
	        $dc_name = $dcs[$dc_id]['name'];
	        $dc_config_tbl_query_str = $dcs[$dc_id]['config_tbl_query_str'];
	        $config_tbl_dealer_fild = $dcs[$dc_id]['dealer_fild'];;
	    }else{
	        $dc_id = 999;
	        $dc_name = 'Online Module';
	        $dc_config_tbl_query_str = "SELECT value FROM gatewayoforder_personal WHERE name LIKE 'dealerID'";
	        $config_tbl_dealer_fild = 'value';
	    }
	    $date_in = $request_data['booking_data']['date_in'];
	    $date_out = $request_data['booking_data']['date_out'];
	    $request_data['customer']['lastname'] = empty($request_data['customer']['lastname']) ? '---' : $request_data['customer']['lastname'];
	    $request_data['customer']['firstname'] = empty($request_data['customer']['firstname']) ? '---' : $request_data['customer']['firstname'];
	    $customer_id = $this->frontdesk->Guest_insert ( $request_data['customer'] );
	    $description = $request_data['booking_data']['description'];
	    $insert_reservation_data = array (
	        'dc_id' => $dc_id,
	        'dc_uuid' => '',
	        'dc_source' => $dc_name,
	        'dc_currencycode' => '',
	        'dc_customerremarks' => '',
	        'dc_guestname' => $request_data['customer']['firstname'] . ' ' . $request_data['customer']['lastname'],
	        'dc_totalprice' => '',//$request_data['booking_data']['rooms_amount'],
	        'is_guest' => 0,
	        'datein' => $date_in,
	        'dateout' => $date_out,
	        'description' => $description,
	        'isread' => 0,
	        'isNew' => 1,
	    );
	    $dealer_query_row = $this->db->query($dc_config_tbl_query_str)->row();
	    $dealer = ($dealer_query_row) ? $dealer_query_row->$config_tbl_dealer_fild : false;
	    if ($dealer){
	        $insert_reservation_data['dealer'] = $dealer;
	    }
	    $hms_resevation_ids = array();
	    $complex_hms_reservation_ids_str = "";
	    $total_amount = 0;
	    foreach ($request_data['booking_data']['parties'] as $master_key => $party_set) {
	        $room_number = $master_key+1;
	        $request_data['guests'][$room_number]['hms_ids'] = array();
            foreach ($request_data['guests'][$room_number]['adults'] as $adult_numder => &$adult) {
                $adult['dob'] = date('Y-m-d', strtotime("$date_in - 35 year"));
                $adult['lastname'] = empty($adult['lastname']) ? '---' : $adult['lastname'];
                $adult['firstname'] = empty($adult['firstname']) ? '---' : $adult['firstname'];
                array_push( $request_data['guests'][$room_number]['hms_ids'], $this->frontdesk->Guest_insert($adult));
            }
            if (isset($request_data['guests'][$room_number]['children'])){
                foreach ($request_data['guests'][$room_number]['children'] as $child_numder => &$child) {
                    $child['dob'] = date('Y-m-d', strtotime("$date_in - ".$child['age']." year"));
                    $child['lastname'] = empty($child['lastname']) ? '---' : $child['lastname'];
                    $child['firstname'] = empty($child['firstname']) ? '---' : $child['firstname'];
                    array_push( $request_data['guests'][$room_number]['hms_ids'], $this->frontdesk->Guest_insert($child));
                }
            }
            $category_id = $party_set['selected_category'];
            $insert_reservation_data['price_type'] = $party_set['selected_rate'];
            $insert_reservation_data['type_id'] = $category_id;
	        $insert_reservation_data['room_id'] = $this->frontdesk->getfreeroomlist($date_in, $date_out, $category_id);

	        if ($insert_reservation_data['room_id'] == 0) {
	            $query_overbooking_category_id = $this->db->select('value')->like('name', 'overbooking_category_id', 'none')->get('hotelix_config')->row();
	            $overbooking_category_id = $query_overbooking_category_id ? $query_overbooking_category_id->value : 0;
	            $overbooking_room_id = 0;
	            if ($overbooking_category_id) {
	                $overbooking_room_id = $this->frontdesk->getfreeroomlist($date_in, $date_out, $overbooking_category_id);
	                if (!$overbooking_room_id) {
	                    $overbooking_room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
	                }
	            }
	            if ($overbooking_category_id && $overbooking_room_id) {
	                $insert_reservation_data['room_id'] = $overbooking_room_id;
	                $insert_reservation_data['origin_categoryid'] = $category_id;
	            }else {
	                echo json_encode(array(
	                    'rezult' => 'fail',
	                    'text' => "no free rooms"
	                ));
	                return;
	            }
	        }
	        if ($party_set['promoted']){
	            switch ($party_set['promo_data']['type_txt']) {
	                case 'percent':
	                    $insert_reservation_data['percent_discount'] = $party_set['promo_data']['value'];
	                break;
	                case 'fixed':
	                    $insert_reservation_data['discount'] = $party_set['promo_data']['value'];
	                    break;
	            }
	        }
	        $acb_set = $this->party_to_hms_guests((object)$party_set, $category_id);
	        $insert_reservation_data = array_merge($insert_reservation_data, $party_set, $acb_set);
	        $hms_reservation_id = $this->frontdesk->Reservation_insert ( $insert_reservation_data, $customer_id, 0, 1 );
	        $this->frontdesk->save_taxesfees($hms_reservation_id);
	        $this->frontdesk->SetReservationBalance ( $hms_reservation_id );
	        $this->frontdesk_c2->needpay(array('reservation_id' => $hms_reservation_id));

	        if ($party_set['promoted'] && $hms_reservation_id){
	            $promo_version = $this->releases->online_propmocodes_veersion();
	            if ($promo_version == 2) {
	                $this->monline_module->update_promocode_count($request_data['booking_data']['promo']['code'],$hms_reservation_id);
	                //$this->db->set('counter', 'counter-1', FALSE)->where(array('code' => $request_data['booking_data']['promo']['code']))->update('promocodes');
	            }
	        }

	        $id_template_bookconfirmation = $this->monline_module->get_id_template_bookconfirmation();
	        $id_template_bookconfirmation_isglobal = $this->monline_module->get_id_template_bookconfirmation_isglobal();
	        $mail_customer_arr = array();
	        $mail_customer_arr ["reservation_id"] = $hms_reservation_id;
	        $mail_customer_arr ["guest_id"] = $customer_id;
	        $mail_customer_arr ["send_id_template"] = $id_template_bookconfirmation;
	        $mail_customer_arr ["location_type"] = "local";
	        if($id_template_bookconfirmation_isglobal == 1){
	            $mail_customer_arr ["location_type"] = "global";
	        }
	        $mail_customer_arr ["send_email"] = $request_data['customer']["email"];
	        $this->formsprinter_model_v2->send_template_toemail_curl($mail_customer_arr, false, 1);
	        // ========= log reservation notify ==========
	        $customer_notification_log_data = array();
	        $customer_notification_log_data ["s_id"] = $hms_reservation_id;
	        $customer_notification_log_data ["description"] = "sent";
	        $this->loger->SaveLog ( $customer_notification_log_data, "reservation", "customer notified(order notify)" );


	        $hotel_name = '';
	        $query = $this->db->query ( "SELECT * FROM logo" );
	        if ($query->num_rows () > 0) {
	            $row = $query->row ();
	            $hotel_name = stripslashes ( $row->logo_title );
	        }
	        
	        $complex_hms_reservation_ids_str .= $hms_reservation_id."_";
	        
	        foreach ($request_data['guests'][$room_number]['hms_ids'] as $guest_id) {
	            $this->frontdesk->guests_reservation_insert($guest_id, $hms_reservation_id);
	        }

	         $inserted_reservation_data = $this->frontdesk->GetReservation($hms_reservation_id);
	         array_push($hms_resevation_ids, array(
	             'hms_res_id' => $hms_reservation_id,
	             'dc_reservation_id' => $party_set['dc_reservationid'],
	             'dc_roomreservation_id' => $party_set['dc_roomreservation_id'],
	             'amount' => $inserted_reservation_data['amount']
	         ));
	         $total_amount += $inserted_reservation_data['amount'];
	         $last_inserted_time = $inserted_reservation_data['date'];
	    }
	    $complex_hms_reservation_ids_str = substr($complex_hms_reservation_ids_str, 0, -1);
	    $complex_reservation_ids = explode("_", $complex_hms_reservation_ids_str);

	    $group_id = '';
	    if (count($complex_reservation_ids)>1){
            $this->db->insert($t->groups, array('name'=>'PM_'.$complex_hms_reservation_ids_str));
	        $group_id = $this->db->insert_id();
	    }

	    foreach ($hms_resevation_ids as $reservation) {
	        $this->db->update($t->reservations, array('intgroupid'=>$group_id), array('id'=>$reservation['hms_res_id']));
	        
	        $data_for_msg = array();
	        $data_for_msg["hms_reservation_id"] = $reservation['hms_res_id'];
	        $data_for_msg["resid"] = $reservation['hms_res_id'];//$reservation['dc_reservation_id'];
	        $data_for_msg['dcname'] = $dc_name;
	        $data_for_msg['status'] = 'new';
	        
	        $msg_txt = $this->dc_model->msg_txt($data_for_msg, false);
			$msg_txt_db=$this->dc_model->msg_txt($data_for_msg, false,'',true);
	        $this->dc_model->send_notifyarray_dc($msg_txt, $dc_name, $group_id, false, "new", $reservation['hms_res_id'],$msg_txt_db);
	    }

	    if (isset($request_data['booking_data']['services'])){
	        $srvcs = $request_data['booking_data']['services'];
	        $first_reservation_id = $hms_resevation_ids[0]['hms_res_id'];
	        $checkintime = $this->hotelix_config->get_record("checkintime");
	        //$checkouttime = $this->hotelix_config->get_record("checkouttime");
            $insert_srvc_arr = array(
                'res_id' => $first_reservation_id,
                'dealer' => 0,
                'partner' => 0,
                'description' => '',
                'addons_date' => "$date_in $checkintime",

            );
            foreach ($srvcs['list'] as $service_id => $srvc_data) {
                $insert_srvc_arr["type"] = $service_id;
	            $insert_srvc_arr["count"] = $srvc_data['service_qty'];
	            $insert_srvc_arr["price"] = $srvc_data['service_price'];
	            $insert_srvc_arr["amount"] = $srvc_data['service_price'];
	            $this->service_model->Insert_Service($insert_srvc_arr, 1);
	            $total_amount += $srvc_data['service_price'];
	        }
	    }
        echo json_encode(array(
            'rezult' => 'ok',
            'hms_resevation_ids' => $hms_resevation_ids,
            'created_time' => $last_inserted_time,
            'total_amount' => $total_amount,
            'guests' => $request_data['guests'],
            'request_data' => $request_data
        ));
	}

	function party_to_hms_guests($party, $cat_id=0) {
	    $t = &$this->db_tables;
	    $babies_count = 0;
	    $over_children_count = 0;
	    $ta_children = (isset($party->children)) ? $party->children : array();
	    if (!empty($ta_children) && $cat_id){
	        $sql = "SELECT t1.baby_places, t3.to AS max_baby_age, t4.to AS max_child_age
	        FROM categories AS t1
	        JOIN $t->prop_info AS t2 ON t1.property_id = t2.id
	        LEFT JOIN $t->age_ranges AS t3 ON t2.range_id = t3.range_id AND t3.id = 1
	        LEFT JOIN $t->age_ranges AS t4 ON t2.range_id = t4.range_id AND t4.id = 2
	        WHERE t1.id = $cat_id";
	        $row_rezult = $this->db->query($sql)->row();
	        if (!empty($row_rezult)){
	            $max_babies_and_children_places = $row_rezult->baby_places;
	            $max_baby_age = isset($row_rezult->max_baby_age) ? (int)$row_rezult->max_baby_age : 0;
	            $max_child_age = isset($row_rezult->max_child_age) ? (int)$row_rezult->max_child_age : 0;
	            foreach ($ta_children as $k => $ta_child_age) {
	                if($ta_child_age <= $max_baby_age){
	                    $babies_count ++;
	                }elseif (($ta_child_age <= $max_child_age) && $max_babies_and_children_places > 0){
	                    $max_babies_and_children_places--;
	                }else{
	                    $over_children_count++;
	                }
	            }
	        }
	    }
	    $guests = array();
	    $guests['adults'] = $party->adults + $over_children_count;
	    $guests['baby_places'] = count($ta_children) - $over_children_count - $babies_count;
	    $guests['babyplace2'] = $babies_count;
	    return $guests;
	}

	function party_to_hms_guests_ages($party) {
	    //$t = &$this->db_tables;
	    $ages = array();
	    $adults_min_age = 35;
	    $adults = $party->adults;
	    while ($adults > 0) {
	        array_push($ages, $adults_min_age);
	        $adults--;
	    }
	    if (isset($party->children)){
	        foreach ($party->children as $k => $child_age) {
	            array_push($ages, $child_age);
	        }
	    }
	    return $ages;
	}

	function reservation_info() {
	    $reservation_ids = json_decode(file_get_contents("php://input"));
	    $reservation_ids_str = "";
	    foreach ($reservation_ids as $res_data) {
	        $reservation_ids_str .= $res_data->hms_res_id.', ';
        }
        $reservation_ids_str = substr($reservation_ids_str, 0, -2);
	    $sql = "SELECT t1.id as res_id, t1.datein as date_in, t1.dateout as date_out, t1.checkintime, t1.checkouttime, t1.cancel, t1.date as created_time, t1.amount,
                        	    t2.lastname, t2.firstname, t2.email, t2.phone,
                        	    t3.id as category_id,
                                COUNT(t4.guest_id) as room_guests_count
        	    FROM deskofreservation as t1
        	    JOIN guests as t2 ON t2.id  = t1.guest_id
                JOIN rooms ON rooms.id  = t1.room_id
        	    JOIN categories as t3 ON  t3.id  = rooms.category_id
                LEFT JOIN guests_deskofreservation as t4 ON t4.reservation_id = t1.id
                WHERE t1.id IN ($reservation_ids_str)
                GROUP BY t1.id";
	    $query_rooms = $this->db->query ($sql)->result();

	    $sql = "SELECT t1.type as servise_type_id, t1.count as qty, t1.price, t1.amount,
	                   t2.name
        	    FROM services as t1
        	    JOIN services_types as t2 ON t2.id  = t1.type
        	    WHERE t1.reservation_id IN ($reservation_ids_str)";
	    $query_services = $this->db->query ($sql)->result();

	    echo json_encode(array('reservation_info'=>array('rooms'=>$query_rooms, 'services'=>$query_services)));
	}

	public function accepted_dcs_through_pmw3() {
        return array(
            999 => array(
                'name' => 'Online Module',
                'config_tbl_query_str' => "SELECT value FROM gatewayoforder_personal WHERE name LIKE 'dealerID'",
                'dealer_fild' => 'value',
            ),
            31 => array(
                'name' => 'Google',
                'config_tbl_query_str' => "SELECT int_value FROM dc_google_xml_cfg WHERE name LIKE 'dealer_id'",
                'dealer_fild' => 'int_value',
            ),
            16 => array(
                'name' => 'Tripadvisor',
                'config_tbl_query_str' => "SELECT int_value FROM dc_tripadvisor_xml_cfg name LIKE 'dealer_id'",
                'dealer_fild' => 'int_value',
            )
        );
	}

	public function canceling_request() {
	    $data = file_get_contents("php://input");
	    $data = json_decode($data, true);

	    $guest_id = 0;
	    $email = "";
	    $cancellation_policy_id = 0;
	    $dc_totalprice = 0;
	    $sql = "SELECT deskofreservation.guest_id, guests.email, deskofreservation.datein,
		deskofreservation.checkintime, rate.cancellation_policy_id as cancellation_policy_id, deskofreservation.dc_totalprice
		FROM deskofreservation
		INNER JOIN guests ON deskofreservation.guest_id = guests.id
		INNER JOIN rate ON rate.id = deskofreservation.price_type
		WHERE deskofreservation.id = " . $data ["res_id"];
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $guest_id = $row->guest_id;
	        $email = $row->email;
	        $datein = $row->datein;
	        $checkintime = $row->checkintime;
	        $dc_totalprice = $row->dc_totalprice;
	        $cancellation_policy_id = $row->cancellation_policy_id;
	    }

	    // get fine
	    $reservation_day_prices = $this->frontdesk->getpricecalculation(array(), $data ["res_id"]);

	    $data_charge = array();
	    $data_charge["amount"] = $dc_totalprice;
	    $data_charge["reservation_day_prices"] = $reservation_day_prices;
	    $data_charge["datein"] = $datein;
	    $data_charge["checkintime"] = $checkintime;
	    $data_charge["cancel_date"] = date("Y-m-d H:i:s");
	    $data_charge["cancellation_policy_id"] = $cancellation_policy_id;

	    $data["charge"] = $this->frontdesk_c2->get_fine_value($data_charge);

	    $this->cancel->Insert ( $data );

	    $data_notify = array ();
	    $data_notify ["hms_reservation_id"] = $data ["res_id"];
	    $data_notify ['resid'] = $data ["res_id"];
	    $data_notify ['dcname'] = $data ["dcname"];
	    $data_notify ['status'] = "cancel";
	    $data_notify ['response'] = ""; // what is this?)))
	    $this->dc_model->send_notifyarray ( $data_notify, false );

	    // send email to client

	    $id_template_bookcancel = $this->monline_module->get_id_template_bookcancel();
	    $id_template_bookcancel_isglobal = $this->monline_module->get_id_template_bookcancel_isglobal();

	    $client_data_email = array();
	    $client_data_email ["reservation_id"] = $data ["res_id"];
	    $client_data_email ["guest_id"] = $guest_id;
	    $client_data_email ["send_id_template"] = $id_template_bookcancel;
	    $client_data_email ["local_type"] = "local";
	    if($id_template_bookcancel_isglobal == 1){
	        $client_data_email ["local_type"] = "global";
	    }
	    $client_data_email ["send_email"] = $email;

	    $this->formsprinter_model_v2->send_template_toemail_curl($client_data_email, false, 1);

	    echo json_encode(array('cancelation_info'=>'OK))'));
	}

}