<?php 
class Hotels extends CI_Controller {
	public $model_name = "dcm_ta_gate";
	public  $test_av_req = '{
  "api_version": 8,
  "start_date": "2019-11-26",
  "end_date": "2019-11-27",
  "party": [
    {
      "adults": 1
    }
  ],
  "language": "en_US",
  "query_key": "6167a22d1f87d2028bf60a8e5e27afa7_191_1360299600000_2_2",
  "currency": "USD",
  "user_country": "US",
  "device_type": "Desktop",
  "availability_id": "a2fd740a-ad02-476d-b314-925a125509be",
  "requested_payload": {
    "categories": {
      "room_type_details": true,
      "rate_plan_details": true,
      "room_rate_details": true,
      "hotel_details": false
    },
    "category_modifiers": {
      "partner_booking_data": false,
      "real_time_pricing": false,
      "multiple_room_rates": true,
      "photos": true,
      "text": true
    }
  },
  "hotels": [{
      "ta_hotel_id": 258705,
      "partner_hotel_code": "92_1"
    },
    {
      "ta_hotel_id": 730099,
      "partner_hotel_code": "92_2"
    },
    {
      "ta_hotel_id": 555555,
      "partner_hotel_code": "92_3"
    }]

}';
	public $test_booking_request = '{
    "api_version": 8,
    "start_date":"2016-10-28",
    "end_date":"2016-10-29",
    "partner_hotel_code":"sfssc1",
    "reference_id":"766588a634734cc8b60dd6a66b2561c4",
    "ip_address":"192.168.1.1",
    "customer":{
        "first_name":"Paul",
        "last_name":"Revere",
        "phone_number":"5555555555",
        "email":"paul.revere@tripadvisor.com",
        "country":"US"
    },
    "rooms":[{
            "party":{"adults":1,"children":[]},
        "traveler_first_name":"Paul",
        "traveler_last_name":"Revere"
    }],
    "special_requests":"A pre-made pillow fort and Vanilla coke on arrival please.",
    "payment_method":{
        "card_type":"Visa",
        "card_number":"5454545454545454",
        "cardholder_name":"Paul Revere",
        "expiration_month":"01",
        "expiration_year":"2015",
        "cvv":"999",
        "billing_address":{
            "address1":"141 Needham Street",
            "city":"newton",
            "state":"MA",
            "postal_code":"77777",
            "country":"US"
        }
    },
    "final_price_at_booking":{
        "amount":100,
        "currency":"USD"
    },
    "final_price_at_checkout":{
        "amount":200,
        "currency":"USD"
    },
    "partner_data":{
        "hms_id":"92",
		"prop_id":"1",
		"rate_id":"85",
		"category_id":"3",
    }
}';
    public function __construct() {
        parent::__construct();
        $this->load->model ( 'Curl_model' );
        $this->load->model ( "dcm_ta_gate/$this->model_name" );
    }
	
    function test (){
    	$t = new AvailabilityResponse($this->test_av_req);
    	echo "<pre>";
    	print_r($t);//->get_requested_guests_count()
    }
	function config() {//There are no request parameters on this GET request
		header ( 'Content-Type: application/json' );
    	$response = new ConfigResponse;
    	$response->configuration->add_emergency_contact('emr_fullname1','emr_email1@gmail.com', 'emr_phone1');
    	$response->configuration->add_emergency_contact('emr_fullname2','emr_email2@gmail.com', 'emr_phone2');
    	$response->configuration->add_info_contact('info_fullname1','info_email1@gmail.com', 'info_phone1');

    	echo json_encode($response, true);
    }
    
    function hotel_inventory () {//sending the parameters in a GET request
    	$request = $_GET;
    	$response = new InventoryResponse($request);
    	$model_name = $this->model_name;
    	$hotels_list = $this->$model_name->get_ta_hotels();
    	foreach ($hotels_list as $hotel_inventory_data) {
//     		$hotel_inventory_data = $this->dcm_ta_gate->get_hotel_inventory_data($hotel);
//     		print_r($hotel_inventory_data);
    		$response->add_hotel($hotel_inventory_data);
    	}
    	$response->send();
    }
    
    function availability() {//sending the parameters in a POST request
    	$model_name = $this->model_name;
    	$response = new AvailabilityResponse($this->test_av_req);//$_POST
    	$flags = $response->get_requested_flags();
		$requested_data = array (
				'start_intday' => $response->get_start_intday(),
				'end_intday'  => $response->get_end_intday(),
				'currency' => $response->availability_request->currency,
				'language' => $response->availability_request->language,
				'rooms' => $response->get_requested_rooms_count(),
				'persons' => $response->get_requested_guests_count(),
				'requested_flags' => $flags
		);
    	foreach ($response->hotels as $partner_hotel_code => $single_hotel_response) {
    		$requested_data['partner_hotel_code'] = $partner_hotel_code;
    		$availability_data = $this->$model_name->get_hotel_availability_data ($requested_data);
    		if (!empty($availability_data)){
    			$single_hotel_response->response_type = 'available';
    			$single_hotel_response->available = $availability_data;
    		} else {
    			$single_hotel_response->response_type = 'unavailable';
    		}
    	}
     	$response->send();
    }
    
    function booking_submit () {//sending the parameters in a POST request
    	$model_name = $this->model_name;
    	$response = new BookingSubmitResponse($this->test_booking_request);//$_POST
    	echo "<pre>";
    	print_r($response);
    	die("DIED by A Department on Hotels.php booking_submit() at 19.11.2019 16:27:24");
    }
    
    function booking_verify () {//sending the parameters in a GET request
    }
    
    function booking_cancel () {//sending the parameters in a POST request
    }
    
    function booking_sync () {//sending the parameters in a POST request
    }

}