<?php 
class Bookings extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->model ( 'Curl_model' );
        $this->load->model ( 'dcm_ta_gate/dcm_ta_gate' );
    }
    
	function booking_submit() {
		header ( 'Content-Type: application/json' );
		$array = array();
    	$array["api_version"] = 8;
    	$array["lang"] = "en_US";
    	echo json_encode($array, true);
	}
	
	function booking_verify() {
		header ( 'Content-Type: application/json' );
		$test_str = '{
  "api_version": 8,
  "problems": [],
  "reference_id": "766588a634734cc8b60dd6a66b2561c4",
  "status": "Success",
  "reservation": {
    "reservation_id": "AB0005",
    "status": "Booked",
    "confirmation_url": "http://www.tripadvisor.com",
    "start_date": "2016-10-28",
    "end_date": "2016-10-29",
    "partner_hotel_code": "sfssc1",
    "hotel": {
      "name": "Hotel Commonwealth",
      "address1": "500 Commonwealth Avenue",
      "address2": "",
      "city": "Boston",
      "state": "Massachusetts",
      "postal_code": "02492",
      "phone": "8001234567",
      "checkin_checkout_policy": "For early check in, please contact hotel.",
      "checkin_time": "12:00",
      "checkout_time": "14:00",
      "hotel_smoking_policy": {
        "standard": [
          47
        ],
        "custom": [
          "Strict non smoking policy"
        ]
      },
      "pet_policy": {
        "standard": [
          6
        ],
        "custom": [
          "My own pet policy if applicable"
        ]
      },
      "child_policy": "All children are welcome",
      "parking_shuttle": {
        "standard": [
          185
        ],
        "custom": [
          "You can park on curbside in a metered spot"
        ]
      },
      "hotel_amenities": {
        "standard": [
          5,
          15
        ],
        "custom": [
          "Bean bag chairs"
        ]
      },
      "photos": [
        {
          "url": "https://www.example.com/hotel_lobby.png",
          "width": 480,
          "height": 270,
          "caption": "Hotel Lobby"
        },
        {
          "url": "https://www.example.com/hotel_cafe.png",
          "width": 480,
          "height": 270,
          "caption": "Hotel Cafe"
        }
      ]
    },
    "customer": {
      "first_name": "Paul",
      "last_name": "Rever",
      "phone_number": 5555555555,
      "email": "paul.revere@tripadvisor.com",
      "country": "US"
    },
    "rooms": [
      {
        "party": {
          "adults": 2,
          "children": [
            9,
            5
          ]
        },
        "traveler_first_name": "Paul",
        "traveler_last_name": "Revere"
      }
    ],
    "legal_text": "Hotel Commonwealth is committed to privacy for everyone who accesses our website. This site, Hotel Commonwealth.com, only collects personal data about you as needed to provide you with outstanding service, and to help process your request or provide you with information.",
    "comments": "But only if you are of age.",
    "line_items": [
      {
        "price": {
          "currency_of_charge_price": {
            "amount": 100,
            "currency": "USD"
          }
        },
        "type": "rate",
        "paid_at_checkout": false
      },
      {
        "price": {
          "requested_currency_price": {
            "amount": 50,
            "currency": "USD"
          },
          "currency_of_charge_price": {
            "amount": 40,
            "currency": "GBP"
          }
        },
        "type": "tax",
        "sub_type": "tax_vat",
        "paid_at_checkout": true
      }
    ]
  },
  "customer_support": {
    "phone_numbers": {
      "standard": ["description":"n1", "country_code":"049","number":"4784239689"],
      "custom": []
    },
    "emails": [],
    "urls": []
  }
}';
		echo json_encode(json_decode($test_str));
	}
	
	function booking_cancel() {
		header ( 'Content-Type: application/json' );
		$test_str = 'Copy Expand all Collapse all
{
"api_version": 8,
"booking_cancel_request": {
"api_version": 8,
"partner_hotel_code": "sfssc1",
"reservation_id": "AB0005"
},
"status": "Success",
"cancellation_number": 12345678,
"customer_support": {
"phone_numbers": {
"standard": [ ],
"custom": [ ]
},
"emails": [ ],
"urls": [ ]
}
}';
		echo json_encode(json_decode($test_str));
	}
	
	function booking_sync() {
		header ( 'Content-Type: application/json' );
		$test_str = '[
  {
    "partner_hotel_code": "sfssc1",
    "reservation_id": "AB0005",
    "status": "CheckedOut",
    "checkin_date": "2014-10-28",
    "checkout_date": "2014-10-29",
    "total_rate":
    {
      "amount":100,
      "currency":"USD"
    },
    "total_taxes":
    {
      "amount":20,
      "currency":"USD"
    },
    "total_fees":
    {
      "amount":10,
      "currency":"USD"
    }
  }
]';
		echo json_encode(json_decode($test_str));
	}
}