<?php
class dc_booking_c2 extends CI_Controller {
    public $debug = FALSE;
	public function __construct() {
		parent::__construct ();
		$this->load->model ( 'dcm_abstract' );
		$this->load->model ( 'dcm_booking' );
		$this->load->model ( 'dcm_booking_v2' );
 		$this->load->model ( 'dcm_booking_promotions' );
 		$this->load->model ( 'dcm_booking_messages' );
 		$this->load->model ( 'dcm_booking_fsi' );
 		$this->load->model ( 'messages_model' );
		$this->load->model ( 'dc_model' );
		$this->load->model ( 'htmltpl' );
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'Authorization' );
		$this->load->model ( 'Loger_admin' );
		$this->load->model ( 'Access' );
		$newdata = array (
				'REQUEST_URI' => $_SERVER ["REQUEST_URI"]
		);
		$this->session->set_userdata ( $newdata );
		$this->Authorization->IsLogined ( "admin_access" );
		
		// ==== billing plan access start ==========
		$data_access = array('module_name' => 'channel_manager');
		$billing_plan_access = $this->Access->get_billing_plan_access($data_access);
		if($billing_plan_access == 0){
		    die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>" );;
		}
		
		// ==== billing plan access end ==========
		$this->debug = (bool) $this->session->userdata('global_debug');
		$this->print_post_mode = (bool) $this->session->userdata('print_post_mode');
	}	

	private function stdToArray($obj) {
		$rc = ( array ) $obj;
		foreach ( $rc as $key => &$field ) {
			if (is_object ( $field ))
				$field = $this->stdToArray ( $field );
		}
		return $rc;
	}

	function ra_params_edit() {
		$access = $this->Access->get_page_access ( "granddcsync", "view" );
		if ($access <> 2) {
			$data = array ();
			$this->load->library ( 'parser' );
			$this->load->view ( 'dc_booking_c2_ra_params_edit_view.php', $data );
		} else {
			die ( "<meta http-equiv='refresh' content='0;url=/errors/FreeError/30'>" );
		}
	}
	function ra_params_edit_post() {
		// echo "<pre>";
		// print_r($_POST);
		$ra_params = $this->input->post ( 'ra' );
		$rooms = $this->input->post ( 'rooms' );
		foreach ( $rooms as $dc_room_id => $cell ) {
			$this->db->update ( 'dc_booking_rooms_link', array (
					'min' => $cell ['min'],
					'max' => $cell ['max']
			), array (
					'dc_room_id' => $dc_room_id
			) );
		}
		if (false) {
			foreach ( $ra_params as $dc_room_id => $value ) {
				foreach ( $value ['rates'] as $dc_rate_id => $cell ) {
					// print_r($cell);
					$sql = "INSERT INTO dc_booking_ra_param (dc_room_id, dc_rate_id, minstay, maxstay, closed) values
				($dc_room_id, $dc_rate_id, " . $cell ['minstay'] . ", " . $cell ['maxstay'] . ", " . $cell ['closed'] . ")
				on duplicate key update minstay=" . $cell ['minstay'] . ", maxstay=" . $cell ['maxstay'] . ",
				closed=" . $cell ['closed'];
					$this->db->query ( $sql );
					// echo $sql . "<br>";
				}
			}
		}
		die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/ra_params_edit'>" );
	}
	function catgories_edit() {
		$access = $this->Access->get_page_access("granddcsync", "view");
		if($access <> 2){
			$data = array ();
			$this->load->library ( 'parser' );
			$this->load->view ( 'dc_booking_c2_catgories_edit_view.php', $data );
		}else{
			die ( "<meta http-equiv='refresh' content='0;url=/errors/FreeError/30'>" );
		}
	}

	function categories_edit_post_v2() {
		$categories_link = $this->input->post ( 'categories', true );
		$data_1 = $this->Loger_admin->get_dccategories_multivalues ( "dc_booking_rooms_link" );
		$data_category2occupancy_1 = $this->Loger_admin->get_dccategories_multivalues ( "dc_booking_category2occupancy", 1 );
		$c2o = $_POST['c2o'];
		$this->dcm_booking_v2->category2occupancy_save_booking($c2o);

		$data_2 = $this->Loger_admin->get_dccategories_multivalues ( "dc_booking_rooms_link" );
		$data_category2occupancy_2 = $this->Loger_admin->get_dccategories_multivalues ( "dc_booking_category2occupancy", 1 );

		//echo "<pre>";
		//print_r($data_category2occupancy_1);
		//print_r($data_category2occupancy_2);
		//die();

		$this->Loger_admin->SaveLog_dc_multicol ( $data_1, $data_2, "loger_admin", "dc_booking_rooms_link", "edit" );
		$this->Loger_admin->SaveLog_dc_multicol ( $data_category2occupancy_1, $data_category2occupancy_2, "loger_admin", "dc_booking_category2occupancy", "edit", 2 );
		// exit();
		die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/catgories_edit'>" );
	}

	function rates_edit() {
	    $price_version = 0;
	    $sql = "SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'price_version'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $price_version = $row->int_value;
	    }
	    if ($price_version == 2) {
            $obp_save_data = array();
            $sql = "SELECT dc_account_id, int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id' GROUP BY dc_account_id";
            $query = $this->db->query($sql);
            foreach ($query->result() as $row) {
                $hotel_id = $row->int_value;
                $obp_data = $this->dcm_booking_v2->get_roomrates($hotel_id);
                $obp_save_data[$hotel_id]['obp_data'] = $obp_data;
            }
            $this->dcm_booking_v2->obp_save_roomrates($obp_save_data);
        }
// 	    echo "<pre>";
// 	    print_r($obp_save_data);
// 	    die();
		$data = array ();
		$this->load->library ( 'parser' );
		$this->load->view ( 'dc_booking_c2_rates_edit_view.php', $data );
	}
	function rates_edit_post_v2() {
// 	    	    echo "<pre>";
// 	    	    print_r($_POST);
	   
		$r2c = $_POST['r2c'];
		$data_1 = $this->Loger_admin->get_dcrate_multivalues ( "dc_booking_rates_link", 2 );
		$data_rate2category_link_1 = $this->Loger_admin->get_dcrate_multivalues ( "dc_booking_rate2category_link", 1 );

		$this->dcm_booking_v2->rate2category_save_booking($r2c);
        //die();
		$sql = "SELECT dc_account_id, int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id' GROUP BY dc_account_id";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row){
            $hotel_id = $row->int_value;
            // видалення зайвих звязок
            $this->dcm_booking->booking_import_room_rates($hotel_id);
        }

		$data_2 = $this->Loger_admin->get_dcrate_multivalues ( "dc_booking_rates_link", 2 );
		$data_rate2category_link_2 = $this->Loger_admin->get_dcrate_multivalues ( "dc_booking_rate2category_link", 1 );

		$this->Loger_admin->SaveLog_dc_multicol ( $data_1, $data_2, "loger_admin", "dc_booking_rates_link", "edit" );
		//echo "<pre>";
		//print_r($data_rate2category_link_1);
		//die();
		$this->Loger_admin->SaveLog_dc_multicol ( $data_rate2category_link_1, $data_rate2category_link_2, "loger_admin", "dc_booking_rate2category_link", "edit", 1 );
        //die();
		die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rates_edit'>" );
	}

	function get_room_categories($die_option = 0) {
		$output = array ();
		$url = $this->config->item('dc_booking_xml_host') . "hotels/xml/rooms";
		$hotelid = $this->dcm_booking->gethotelid ();
		// 53960702 std 1
		// half lux 53960703
		$dc_user = $this->config->item ( 'dc_booking_xml_user' );
		$dc_password = $this->config->item ( 'dc_booking_xml_pwd' );
		$array_rooms = array ();
		$sql = "SELECT dc_account_id, int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id' GROUP BY dc_account_id";
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			$hotel_id = $row->int_value;
			if($row->dc_account_id == 0){
			    continue;
			}
			if($hotel_id == 0 || $hotel_id == ""){
			    continue;
			}
			$txt = <<<EOT
<request>
<username>$dc_user</username>
<password>$dc_password</password>
<hotel_id>$hotel_id</hotel_id>
<version>1.0</version>
</request>
EOT;
			$data_result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 1, array (
					"returntype" => "array"
			));
			$result = $data_result["result"];

			$rooms = new SimpleXMLElement ( $result );
			foreach ( $rooms->room as $room ) {
				array_push ( $array_rooms, array (
				"room_id" => ( int ) $room ["id"],
				"hotel_id" => ( int ) $room ["hotel_id"],
				"max_children" => ( int ) $room ["max_children"],
				"hotel_name" => ( string ) $room ["hotel_name"],
				"room_name" => ( string ) $room
				) );
			}

			if(count($rooms->room) > 0){
			    $this->Loger_admin->Save_SyncData ( "", "", $data_result['result'], 1, 13, $data_result ["dc_log_id"] );
			}
		}


		$array_rooms = $this->stdToArray ( $array_rooms );
		if($die_option == 0){
			echo $result;
			echo "<pre>";
			print_r ( $array_rooms );
			die();
		}

		$array_count = count ( $array_rooms );

		if($array_count > 0){
			$sql = "UPDATE dc_booking_rooms_link SET active = 0 WHERE 1";
			$query = $this->db->query ( $sql );
		}
		// die();
		for($i = 0; $i < count ( $array_rooms ); $i ++) {

			$sql = "INSERT INTO dc_booking_rooms_link(dc_hotel_id, dc_room_name, dc_room_id, active)
					VALUES('" . $array_rooms [$i] ["hotel_id"] . "', '" . addslashes($array_rooms [$i] ["room_name"]) . "', '" . $array_rooms [$i] ["room_id"] . "', 1)
					ON DUPLICATE KEY UPDATE dc_hotel_id ='" . $array_rooms [$i] ["hotel_id"] . "', dc_room_name = '" . addslashes($array_rooms [$i] ["room_name"]) . "', active = 1";
			// echo $sql;
			$query = $this->db->query ( $sql );
		}



		if($die_option == 1){
			$_SESSION["dc_msg"]["text"] = print_r($array_rooms, true);
			die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/catgories_edit'>" );
		}
	}
	function truncate_categories(){
		$sql = "DELETE FROM dc_booking_rooms_link WHERE 1";
		$query = $this->db->query ( $sql );
		$sql = "DELETE FROM dc_booking_category2occupancy WHERE 1";
		$query = $this->db->query ( $sql );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/catgories_edit'>" );
	}

	function truncate_rates(){
	    $sql = "DELETE FROM dc_booking_rates WHERE 1";
	    $query = $this->db->query ( $sql );
	    $sql = "DELETE FROM dc_booking_rates_link WHERE 1";
	    $query = $this->db->query ( $sql );
	    $sql = "DELETE FROM dc_booking_rate2category_link WHERE 1";
	    $query = $this->db->query ( $sql );
	    die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rates_edit'>" );
	}

	function get_roomrates($insert = 0, $die_option = 0) {
	    $output = array ();
	    $url = $this->config->item('dc_booking_xml_host') . "hotels/xml/roomrates";
	    //$hotelid = $this->dcm_booking->gethotelid ();
	    $dc_user = $this->config->item ( 'dc_booking_xml_user' );
	    $dc_password = $this->config->item ( 'dc_booking_xml_pwd' );
	    $array_rates = array ();
	    $sql = "SELECT dc_account_id, int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id' GROUP BY dc_account_id";
	    echo $sql;
	    $query = $this->db->query ( $sql );
	    foreach ( $query->result () as $row ) {
	        $hotel_id = $row->int_value;
	        if($row->dc_account_id == 0){
	            continue;;
	        }
	        if($hotel_id == 0 || $hotel_id == ""){
	            continue;
	        }
	        $txt = <<<EOT
<request>
<username>$dc_user</username>
<password>$dc_password</password>
<hotel_id>$hotel_id</hotel_id>
<version>1.0</version>
</request>
EOT;
	        $data_result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 1, array (
	            "returntype" => "array"
	        ));

	        $result = $data_result["result"];
	        echo $result;
	        //die();

	        $responce_data = new SimpleXMLElement ( $result );
	        echo "<pre>";
	        print_r($responce_data);

	        $responce_data_array = json_decode(json_encode($responce_data, true), true);
	        print_r($responce_data_array);
	        die();
	        foreach ( $rates->rate as $rate ) {
	            array_push ( $array_rates, array (
	                "rate_id" => ( int ) $rate ["id"],
	                "hotel_id" => ( int ) $rate ["hotel_id"],
	                "hotel_name" => ( string ) $rate ["hotel_name"],
	                "rate_name" => ( string ) $rate
	            ) );
	        }
	    }

	}

	function get_rates_plans($insert = 0, $die_option = 0) {
		$output = array ();
		$url = $this->config->item('dc_booking_xml_host') . "hotels/xml/rates";
		//$hotelid = $this->dcm_booking->gethotelid ();
		$dc_user = $this->config->item ( 'dc_booking_xml_user' );
		$dc_password = $this->config->item ( 'dc_booking_xml_pwd' );
		$array_rates = array ();
		$sql = "SELECT dc_account_id, int_value FROM dc_booking_xml_cfg WHERE name LIKE 'hotel_id' GROUP BY dc_account_id";
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			$hotel_id = $row->int_value;
			if($row->dc_account_id == 0){
			    continue;;
			}
			if($hotel_id == 0 || $hotel_id == ""){
			    continue;
			}
			$txt = <<<EOT
<request>
<username>$dc_user</username>
<password>$dc_password</password>
<hotel_id>$hotel_id</hotel_id>
<version>1.0</version>
</request>
EOT;
			$data_result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 1, array (
					"returntype" => "array"
			));
			$result = $data_result["result"];
// 			echo $result;
// 			die();

			// видалення зайвих звязок
			$this->dcm_booking->booking_import_room_rates($hotel_id);

			$rates = new SimpleXMLElement ( $result );

			foreach ( $rates->rate as $rate ) {
				array_push ( $array_rates, array (
				"rate_id" => ( int ) $rate ["id"],
				"hotel_id" => ( int ) $rate ["hotel_id"],
				"hotel_name" => ( string ) $rate ["hotel_name"],
				"rate_name" => ( string ) $rate
				) );
			}

			if(count($rates->rate) > 0){
			    $this->Loger_admin->Save_SyncData ( "", "", $data_result['result'], 1, 13, $data_result ["dc_log_id"] );
			}
		}

		$array_rates = $this->stdToArray ( $array_rates );
		if($die_option == 0){
			echo "<pre>";
			echo $result;

			print_r ( $array_rates );
			echo "</pre>";
		}
		if($insert == 1){
			die();
		}

		$array_count = count ( $array_rates );

		if($array_count > 0){
			$sql = "UPDATE dc_booking_rates SET active = 0 WHERE 1";
			$query = $this->db->query ( $sql );
		}
		for($i = 0; $i < count ( $array_rates ); $i ++) {

			$sql = "INSERT INTO dc_booking_rates(dc_hotel_id, dc_rate_id, name, active)
					VALUES('" . $array_rates [$i] ["hotel_id"] . "', " . $array_rates [$i] ["rate_id"] . ", '" . $array_rates [$i] ["rate_name"] . "', 1)
					ON DUPLICATE KEY UPDATE dc_hotel_id = '" . $array_rates [$i] ["hotel_id"] . "', name = '" . $array_rates [$i] ["rate_name"] . "', active = '1'";
			// echo $sql;
			$query = $this->db->query ( $sql );

			// CFG

			$sql = "UPDATE dc_booking_xml_cfg SET str_value = '".addslashes($array_rates [$i] ["hotel_name"])."' WHERE int_value = ".$array_rates [$i] ["hotel_id"];
			$query = $this->db->query ( $sql );
		}


        //die();
		if($die_option == 1){
			$_SESSION["dc_msg"]["text"] = print_r($array_rates, true);
			//print_r($_SESSION["dc_msg"]["text"]);
			//die();
			die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rates_edit'>" );
		}

	}

	function rate_delete_v2($dc_rate_id, $dc_category_id){
		$sql = "DELETE FROM  dc_booking_rate2category_link WHERE dc_rate_id = " . $dc_rate_id . " AND dc_category_id = " . $dc_category_id;
		$query = $this->db->query ( $sql );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rates_edit'>" );
	}

	function category_delete_v2($dc_category_id){
		$sql = "DELETE FROM dc_booking_rooms_link WHERE dc_room_id = ".$dc_category_id;
		$query = $this->db->query ( $sql );
		$sql = "DELETE FROM dc_booking_category2occupancy WHERE dc_category_id = ".$dc_category_id;
		$query = $this->db->query ( $sql );
		$sql = "DELETE FROM dc_booking_rate2category_link WHERE dc_category_id = ".$dc_category_id;
		$query = $this->db->query ( $sql );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/catgories_edit'>" );
	}

	function rate_full_delete($dc_rate_id) {
		$sql = "DELETE FROM  dc_booking_rate2category_link WHERE dc_rate_id = " . $dc_rate_id;
		$query = $this->db->query ( $sql );
		$sql = "DELETE FROM dc_booking_rates_link WHERE dc_rate_id = " . $dc_rate_id;
		$query = $this->db->query ( $sql );
		$sql = "DELETE FROM  dc_booking_rates WHERE dc_rate_id = " . $dc_rate_id;
		$query = $this->db->query ( $sql );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rates_edit'>" );
	}

	function reservations_form() {
		$data = array ();
		$this->load->library ( 'parser' );
		$this->load->view ( 'dc_booking_c2_reservations_form_view.php', $data );
	}

	function reservations_post() {
		$dc_hotel_id = $_POST ["dc_hotel_id"];
		$date = $_POST ["date"];
		$output = array ();
		$url = $this->config->item('dc_booking_xml_secure_host') . "hotels/xml/reservations";
		$xml = "<request>";
		$xml .= "<username>" . $this->config->item ( 'dc_booking_xml_user' ) . "</username>";
		$xml .= "<password>" . $this->config->item ( 'dc_booking_xml_pwd' ) . "</password>";
		$xml .= "<hotel_id>" . $dc_hotel_id . "</hotel_id>";
		$xml .= "<last_change>" . $date . "</last_change>";
		$xml .= "</request>";

		$request = $this->Curl_model->CurlPlugRAW ( $xml, $url );

		// $data = array();
		// $request = $this->parser->parse ( 'templates/1_xml_test.html', $data,
		// true );
		// echo $request;
		// die();
		$this->dcm_booking->bokking_xml_parse ( $request );
	}

	function get_bookings_withID() {
		$dc_reservation_id = $this->input->post ( 'dc_reservation_id' );
		if ($dc_reservation_id != "") {
			$dc_hotel_id = $_POST ["dc_hotel_id"];
			//$hotel_id = "4956";
			$output = array ();
			$url = $this->config->item('dc_booking_xml_secure_host') . "hotels/xml/reservations";
			$xml = "<request>";
			$xml .= "<username>" . $this->config->item ( 'dc_booking_xml_user' ) . "</username>";
			$xml .= "<password>" . $this->config->item ( 'dc_booking_xml_pwd' ) . "</password>";
			$xml .= "<hotel_id>" . $dc_hotel_id . "</hotel_id>";
			$xml .= "<id>" . $dc_reservation_id . "</id>";
			$xml .= "</request>";

			$headers = array();
			$headers[]= "Features: include_price_details";
			$headers[]= "Cache-Control: no-cache";
			$data_result = $this->Curl_model->CurlPlugRAW ( $xml, $url, 1 , array (
					"returntype" => "array" ,
					"headers" =>$headers
			) );
			$result = $data_result ["result"];

			$send_notification = 0;
			if($this->input->post ( 'send_notification' ) == 1){
				$send_notification = 1;
			}
			$reservation_result = $this->dcm_booking->bokking_xml_parse ( $result, 0, 0, $send_notification);
			$this->Loger_admin->Save_SyncData ( "", "", $reservation_result, 1, 10, $data_result ["dc_log_id"] );
		}
	}
	
	function get_dc_data_withID($dc_reservation_id = ""){
	    //echo $dc_reservation_id;
	    //die();
	    if ($this->session->userdata('global_debug') == 1) {
            if ($dc_reservation_id != "") {
                $dc_hotel_id = 0;
                $sql = "SELECT dc_booking_rooms_link.dc_hotel_id FROM deskofreservation as t_1
                        INNER JOIN rooms ON rooms.id = t_1.room_id
                        INNER JOIN categories ON categories.id = rooms.category_id
                        INNER JOIN dc_booking_rooms_link ON dc_booking_rooms_link.category_id = categories.id
                        WHERE t_1.dc_reservationid = $dc_reservation_id";
                $query = $this->db->query( $sql );
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $dc_hotel_id = $row->dc_hotel_id;
                }
                if ($dc_hotel_id > 0) {
                    // $hotel_id = "4956";
                    $output = array();
                    $url = $this->config->item('dc_booking_xml_secure_host') . "hotels/xml/reservations";
                    $xml = "<request>";
                    $xml .= "<username>" . $this->config->item('dc_booking_xml_user') . "</username>";
                    $xml .= "<password>" . $this->config->item('dc_booking_xml_pwd') . "</password>";
                    $xml .= "<hotel_id>" . $dc_hotel_id . "</hotel_id>";
                    $xml .= "<id>" . $dc_reservation_id . "</id>";
                    $xml .= "</request>";
                    
                    $headers = array();
                    $headers[] = "Features: include_price_details";
                    $headers[] = "Cache-Control: no-cache";
                    $data_result = $this->Curl_model->CurlPlugRAW($xml, $url, 1, array(
                        "returntype" => "array",
                        "headers" => $headers
                    ));
                    $result = $data_result["result"];
                    
                    $send_notification = 0;
                    if ($this->input->post('send_notification') == 1) {
                        $send_notification = 1;
                    }
                    $reservation_result = $this->dcm_booking->bokking_xml_parse($result, 0, 0, $send_notification);
                    $this->Loger_admin->Save_SyncData("", "", $reservation_result, 1, 10, $data_result["dc_log_id"]);
                }else{
                    echo "WRONG DC_HOTEL_ID";
                }
            }
        }
	}

	
	
	function get_bookings_formfile() {
		// @header ("Content-Type: text/html; charset=UTF-8");
		$str_data = file_get_contents ( $_FILES ['file_data'] ['tmp_name'] );
		// $str_data = utf8_encode($str_data);
		$encoding = $this->input->post ( 'encoding' );
		switch ($encoding) {
			case "windows1251" :
				$str_data = iconv ( "windows-1251", "utf-8", $str_data );
				break;
			case "utf8" :
				break;
			default :
				//$str_data = iconv ( "windows-1251", "utf-8", $str_data );
				break;
		}

		$this->dcm_booking->bokking_xml_parse ( $str_data );
	}

	function options() {
		$data = array ();
		$this->load->library ( 'parser' );
		$this->load->view ( 'dc_booking_c2_options_view.php', $data );
	}
	function options_post() {
		$post = $_POST;
		$this->dcm_booking->options_save ( $post );
		die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/options'>" );
	}
	function opportunities() {
		$data = array ();
		$this->load->library ( 'parser' );
		$this->load->view ( 'dc_booking_c2_opportunities_view.php', $data );
	}
	function opportunity_action($property_id = null, $opportunity_id = null, $action = null){
		if( $property_id == null || $opportunity_id == null || $action == null ){exit('Please provide a property');}

		$dc_user = $this->config->item ( 'dc_booking_xml_user' );
		$dc_password = html_entity_decode ($this->config->item ( 'dc_booking_xml_pwd' ));
		$auth = $dc_user . ":" . $dc_password;

		$data['actions'][0]['opportunity_id'] = $opportunity_id;
		$data['actions'][0]['action'] = strtoupper($action);

		$data_string = json_encode($data);

		$headers = array(
		'Authorization: Basic ' . base64_encode($auth),
		'Content-Type: application/json',
		'Content-Length: ' . strlen($data_string),
		);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://supply-xml.booking.com/opportunity-api/properties/' . $property_id . '/opportunities');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
		$buffer = curl_exec($ch);
		curl_close($ch);
		$res = json_decode($buffer, true);
		if(!empty($res['errors'])){
			echo "<pre>";
			print_r($res);
			die ('<br>DIED by A Development Department of HMS IT TEAM<br>27.05.2019  15:03:13 <br>dc_booking_c2.php');
		}
		die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/opportunities'>" );
	}

	function promotions() {
		$this->load->model ( 'dcm_booking_promotions' );
		$data = array ();
		$this->load->library ( 'parser' );
		$this->load->view ( 'dc_booking/promotions_view.php', $data );
	}

	function promotions_list($dc_hotel_id = "", $status = 0) {
		$this->load->model ( 'dcm_booking_promotions' );
		$data = array();
		if ($dc_hotel_id != "") {
			$newdata = array (
					'booking_promotions_hotel_id' => $dc_hotel_id
			);
			$this->session->set_userdata ( $newdata );
			$data = array ('dc_hotel_id' => $dc_hotel_id);
		}
		$this->session->set_userdata ( array('booking_promotions_selected_status' => $status));
		$this->load->library ( 'parser' );
		$this->load->view ( 'dc_booking/promotions_list_view.php', $data );
	}

	function edit_promotion( $dc_hotel_id = null, $id = null ){
		if( $dc_hotel_id == null ){exit('Please provide a property');}
		$this->load->model ( 'dcm_booking_promotions' );
		$data = array('dc_hotel_id'=>$dc_hotel_id, 'id'=>$id);
		if( $id == null ){
			$this->load->view ( 'dc_booking/create_promotion_view.php', $data );
		} else {
			$this->load->view ( 'dc_booking/edit_promotion_view.php', $data );
		}
	}

	function save_promotion(){
		$this->load->model ( 'dcm_booking_promotions' );
		$prom_post = $this->input->post();
		$dc_hotel_id = $prom_post['dc_hotel_id'];
		$this->dcm_booking_promotions->save_promotion($prom_post);
		die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/promotions_list/$dc_hotel_id'>" );
	}

	function delete_promotion($dc_hotel_id = null, $promotion_id = null){
		$this->load->model ( 'dcm_booking_promotions' );
		if( $dc_hotel_id == null || $promotion_id == null ){ exit('Not sufficient data'); }
		$this->dcm_booking_promotions->delete_promotion($dc_hotel_id, $promotion_id);
		die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/promotions_list/$dc_hotel_id'>" );
    }

    function activate_promotion($dc_hotel_id = null, $promotion_id = null) {
        if( $dc_hotel_id == null || $promotion_id == null ){
            $this->session->set_userdata ( array('header_msg_text' =>  'No hotel ID or promotion ID'));
        }else{
            $this->dcm_booking_promotions->activate_promotion($dc_hotel_id, $promotion_id);
        }
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/promotions_list'>" );
    }

    function reviews($property_id){
        $data = array("property_id" => $property_id);

        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_booking_c2_reviews_list_view.php', $data );
    }

    function review_view($property_id, $review_id){
        $data = array(
            "property_id" => $property_id,
            "review_id" => $review_id
        );

        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_booking_c2_review_view.php', $data );
    }
    
    function ajax_get_booking_cc_balance(){
    
        $reservation_id = $_POST["reservation_id"];
        $dc_reservation_id = $_POST["dc_reservationid"];
        $dc_roomreservation_id = $_POST["dc_roomreservation_id"];
    
        $dc_hotel_id = 0;
        $overbooking_category_id = $this->db->select('int_value')->get_where('dc_booking_xml_cfg', array('name' => 'overbooking_category_id'))->row()->int_value;
        $valid_category_id = 0;
        $query = $this->db->query("SELECT categories.id as category_id, deskofreservation.origin_categoryid FROM deskofreservation
	                               INNER JOIN rooms ON deskofreservation.room_id = rooms.id
	                               INNER JOIN categories ON categories.id = rooms.category_id
	                               WHERE deskofreservation.dc_id = 1 AND deskofreservation.dc_reservationid = " . $dc_reservation_id);
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $res_category_id = $row->category_id;
            $res_origin_categoryid = $row->origin_categoryid;
             
            if($overbooking_category_id != $res_category_id){
                $valid_category_id = $res_category_id;
            }else{
                $valid_category_id = $res_origin_categoryid;
            }
        }
         
        if($valid_category_id > 0){
            $dc_hotel_id = $this->db->select('dc_hotel_id')->get_where('dc_booking_rooms_link', array('category_id' => $valid_category_id))->row()->dc_hotel_id;
        }
         
        // якщо звязка категорії бронювання та звязної категорії каналу booking вернула 0
        if($dc_hotel_id == 0){
            $query = $this->db->query("SELECT dc_hotel_id FROM dc_booking.dc_booking_orders_get
	        	                               WHERE dc_reservation_id = " . $dc_reservation_id);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $dc_hotel_id = $row->dc_hotel_id;
            }
        }
        // 	    $dc_hotel_id = 497927;
        // 	    $dc_reservation_id = 3946231299;
        if ($dc_reservation_id != "" && $dc_hotel_id != 0) {
            $output = array ();
            $url = $this->config->item('dc_booking_xml_secure_host') . "hotels/xml/reservations";
            $xml = "<request>";
            $xml .= "<username>" . $this->config->item ( 'dc_booking_xml_user' ) . "</username>";
            $xml .= "<password>" . $this->config->item ( 'dc_booking_xml_pwd' ) . "</password>";
            $xml .= "<hotel_id>" . $dc_hotel_id . "</hotel_id>";
            $xml .= "<id>" . $dc_reservation_id . "</id>";
            $xml .= "</request>";
    
            $headers = array();
            $headers[]= "Features: include_price_details";
            $headers[]= "Cache-Control: no-cache";
            $data_result = $this->Curl_model->CurlPlugRAW ( $xml, $url, 1 , array (
                "returntype" => "array" ,
                "headers" =>$headers
            ) );
            $result = $data_result ["result"];
            //echo $result."++++";
            
            $reservations = new SimpleXMLElement($result);
    
            foreach ($reservations->reservation as $reservation) {
                $cc_current_balance = (int) $reservation->customer->cc_current_balance;
                $sql = "UPDATE tbl_CreditCards SET cc_current_balance = $cc_current_balance WHERE reservation_id = $reservation_id";
                $this->db->query( $sql );
                
                $tbl_cc_id = $this->db->select('id')->get_where('tbl_CreditCards', array('reservation_id' => $reservation_id))->row()->id;
                $sql = "UPDATE payment_deffered SET amount = $cc_current_balance WHERE tcc_id = $tbl_cc_id";
                $this->db->query( $sql );
                
                $data_return = array();
                $data_return ['cc_current_balance'] = $reservation->customer->cc_current_balance;
                echo json_encode($data_return);
                //echo $reservation->customer->cc_current_balance;
                //die();
                break;
            }
            $this->Loger_admin->Save_SyncData ( "", "", "cc_current_balance: " . $reservation->customer->cc_current_balance . $reservation->customer->currencycode, 1, 10, $data_result ["dc_log_id"] );
        } else {
            echo "fail";
        }
    }
    
    /*
     * 
     * get data from dc_booking_orders_get_pull and dc_booking_orders_get_pull_sync 
     * tables by dc_reservation_id
     * 
     */
    function get_dc_reservation_id_push_info(){
        if(isset($_POST['dc_reservation_id'])){
            $dc_reservation_id = $_POST['dc_reservation_id'];
        }
        
        if(isset($_GET['dc_reservation_id'])){
            $dc_reservation_id = $_GET['dc_reservation_id'];
        }
        
        //echo "FROM dc_booking_orders_get_pull:<br>";
        //echo "<pre>";
        $pull_mass = $this->db->get_where('dc_booking.dc_booking_orders_get_pull', array('dc_reservation_id' => $dc_reservation_id))->result_array();
        
       // echo "FROM dc_booking_orders_get_pull_sync:<br>";
        $sync_mass = $this->db->get_where('dc_booking.dc_booking_orders_get_pull_sync', array('dc_reservation_id' => $dc_reservation_id))->result_array();
        
        $sql = "SELECT pull.dc_reservation_id, pull.id as pull_id, pull.dc_status, pull.status, pull.timestamp as create_date,
                sync.id as sync_id, sync.time as response_date
                FROM dc_booking.dc_booking_orders_get_pull as pull
                LEFT JOIN dc_booking.dc_booking_orders_get_pull_sync as sync ON pull.id = sync.pull_id
                WHERE pull.dc_reservation_id = $dc_reservation_id";
        $list = $this->db->query($sql)->result_array();
        foreach($list as &$cell){
            $cell['booking_xml_link'] = "";
        }
        $data = array('list' => $list);
        echo $this->parser->parse('templates/dc_booking/push_info.html', $data, TRUE);
    }
    
    function get_push_data($push_id){
        $result = $this->db->select('xml')->get_where('dc_booking.dc_booking_orders_get_pull', array('id' => $push_id))->row_array();
        header("Content-Type: application/xhtml+xml; charset=utf-8");
        echo $result['xml'];
    }
    
    function get_response_data($sync_id){
        echo "<pre>";
        print_r($this->db->select('response')->get_where('dc_booking.dc_booking_orders_get_pull_sync', array('id' => $sync_id))->result_array());
    }
    
    function property_score() {
        $dc_hotel_id = 0;
        if(isset($_POST['dc_hotel_id'])){
            $dc_hotel_id = $_POST['dc_hotel_id'];
        }
        $data = array ('post_dc_hotel_id' => $dc_hotel_id);
        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_booking/property_score_view.php', $data );
    }
    
    function messages_list($id_p = 1) {
        if (isset ( $_POST ["lines_per_page"] )) {
            $lines_per_page = $_POST ["lines_per_page"];
            $newdata = array ('booking_conversations_list_lines_per_page' => $lines_per_page);
            $this->session->set_userdata ( $newdata );
        }
        
        if (isset ( $_GET ["status"] )) {
            $status = $_GET ["status"];
            $newdata = array (
                'conversations_list_status' => $status
            );
            $this->session->set_userdata ( $newdata );
        }
        
        $data = array ('cur_page' => $id_p);
        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_booking/messages_list_view.php', $data );
    }

    function conversation($conversation_id_int, $notification_id = 0)
    {
        if ($notification_id > 0) {
            
            $this->frontdesk_c2->remove_hms_notifications($notification_id);
        }
        $update_data = array('is_new' => 0);
        $this->messages_model->update_conversation($update_data, $conversation_id_int);
        
        // ==== SAVE IN MC ======
        $update_data = array('is_new' => 0);
        $update_keys = array('thread_id' => $conversation_id_int, 'dc_id' => 1);
        $this->messages_model->update_mc($update_data, $update_keys);
        
        $data = array ('conversation_id_int' => $conversation_id_int);
        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_booking/conversation_view.php', $data );
    }
    
    function mc_get_attachment(){
        //echo "<pre>";
        //print_r($_POST);
        //die();
        $property_id = $_POST['property_id'];
        $attachment_id = $_POST['attachment_id'];
        $conversation_id = $_POST['conversation_id'];
        
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        //$auth = html_entity_decode('otelmsxml3:1-L^&#43;!bOE31e&gt;BZbXBM=Z2AUx8M(wF');
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
        );
         
        $url = "https://supply-xml.booking.com/messaging/properties/$property_id/conversations/$conversation_id/attachments/$attachment_id";
         
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        $buffer = curl_exec($ch);
        curl_close($ch);
        
        $result = json_decode($buffer, true);
        
        //print_r($result);
        
        if (! empty($result['data'])) {
             //echo '<img src="data:image;base64,' . $result['data']['file_content'] . '" />';
             echo "data:image;base64," . $result['data']['file_content'];
//             header('Content-Description: File Transfer');
//             header('Content-Type: application/octet-stream');
//             header('Content-Disposition: attachment; filename=' . basename($filepath));
//             header('Expires: 0');
//             header('Cache-Control: must-revalidate');
//             header('Pragma: public');
//             header('Content-Length: ' . filesize($filepath));
//             readfile($filepath);
           
        }
        
    }
    
    public function send_message()
    {
//         echo "<pre>";
//         print_r($_POST);
//         print_r($_FILES);
//         die();
        $conversation_id_int = $_POST['conversation_id_int'];
        $property_id = $_POST['property_id'];
        
        $conversation = $this->messages_model->get_booking_conversation_id($conversation_id_int);
        
        $attachment = null;
        if (0 == ($_FILES['img']['error'])) {
            $uploaddir = $_SERVER['DOCUMENT_ROOT'] . 'assets/www';
            $uploadfile = $uploaddir . DIRECTORY_SEPARATOR . $_FILES['img']['name'];
            move_uploaded_file($_FILES['img']['tmp_name'], $uploadfile);
            if (filesize($uploadfile) > 800000) {
                $attachment = $this->messages_model->upload_large_file($property_id, $conversation, $uploadfile);
            } else {
                $attachment = $this->messages_model->upload_small_file($property_id, $conversation, $uploadfile);
            }
        }
        $send_data = array();
        $send_data['attachment'] = $attachment;
        $send_data['property_id'] = $property_id;
        $send_data['conversation'] = $conversation;
        $send_data['text'] = $_POST['text'];
        
        $request = json_encode($send_data);
        
        $response = $this->messages_model->booking_send_messages($send_data);
        
        // = LOG =======
        $description_data = array();
        $description_data['request'] = $send_data;
        $description_data['response'] = json_decode($response, true);
        
        $dc_type = 18;
        
        $log_data = array();
        $log_data['reservation_id'] = 0;
        $log_data['type'] = "dcmessage";
        $log_data['dc_type'] = $dc_type; // dc_message
        $log_data['description'] = "json: ".json_encode($description_data);
        $this->Loger_admin->save_dcmessage_data($log_data);
        
        // ===== NO REPLY ============
        if(isset($_POST['no_reply'])){
            $this->dcm_booking_messages->set_conversation_noreply($property_id, $conversation);
        }
        
        //die();
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/conversation/$conversation_id_int'>" );
    }
    
    function get_messages_by_conversation($conversation_id_int){
        $conversation = $this->messages_model->get_booking_conversation_id($conversation_id_int);
        $property_id = $this->messages_model->get_booking_conversation_property_id($conversation_id_int);
        
        $conversation_data = array();
        $conversation_data['hotel_id'] = $property_id;
        $conversation_data['conversation_id'] = $conversation;

        $this->messages_model->get_save_booking_msg($conversation_data);
        
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/conversation/$conversation_id_int'>" );
    }
    
    function get_hotel_messages($confirm = 0){
        $conversations_data = $this->dcm_booking_messages->get_booking_latest_messages();
        //echo "<pre>";
        //print_r($conversations_data);
        
        $number_of_messages = 0;
        if($conversations_data['data']['ok'] == 1){
            if(isset($conversations_data['data']['number_of_messages'])){
                $number_of_messages = $conversations_data['data']['number_of_messages'];
            }
        }
        
        $retun_format = 1;
        $local_dc_hotel_ids = $this->dcm_booking->get_dc_hotel_ids($retun_format);
        
        $success_counter = 0;
        $conversation_keys = array();
        if(isset($conversations_data['data']['messages'])){
            foreach($conversations_data['data']['messages'] as $msg_data){
                if(isset($msg_data['conversation']['property_id'])){
                    $property_id = $msg_data['conversation']['property_id'];
                    $conversation_id = $msg_data['conversation']['conversation_id'];
                    //$conversation_reference = $msg_data['conversation']['conversation_reference'];
                    //$conversation_type = $msg_data['conversation']['conversation_type'];
                    //$sender_name = $msg_data['sender']['metadata']['name'];
                    //$participant_type = $msg_data['sender']['metadata']['participant_type'];
                    //$participant_id = $msg_data['sender']['participant_id'];
                     
                    if(isset($conversation_keys[$property_id] [$conversation_id])){
                        continue;
                    }
                    $conversation_keys [$property_id] [$conversation_id] = 1;
                    
                    if (isset($local_dc_hotel_ids[$property_id])) { 
                        if ($property_id > 0 && $conversation_id != "") {
                            $conversation_data = array();
                            $conversation_data['hotel_id'] = $property_id;
                            $conversation_data['conversation_id'] = $conversation_id;
                            //$conversation_data['conversation_reference'] = $conversation_reference;
                            //$conversation_data['conversation_type'] = $conversation_type;
                            //$conversation_data['sender_name'] = $sender_name;
                            //$conversation_data['participant_type'] = $participant_type;
                            //$conversation_data['participant_id'] = $participant_id;
                            // echo "<pre>";
                            // print_r($output_curl_data);
                            $this->messages_model->get_save_booking_msg($conversation_data);
                        }
                    }
                }
                
                $success_counter++;
            }
            
            // ========= CONFIRM =========
            if($confirm == 1){
                if(($success_counter == $number_of_messages) && ($number_of_messages > 0)){
                    $this->dcm_booking_messages->confirm_messages ($number_of_messages);
                }
            }
        }
        
//         $local_log_data = array();
//         $local_log_data ['log_id'] = $log_id;
//         $local_log_data ['type'] = "dcmessage";
//         $local_log_data ['result'] = "number_of_messages: $number_of_messages";
//         $this->Loger_admin->save_dcmessage_data ( $local_log_data );
        
        //die();
        die ( "<meta http-equiv='refresh' content='0;url=/messages_c2/channel_mc'>" );
    }
    
    function create_conversation(){
        //echo "<pre>";
        //print_r($_POST);
        $reservation_id = $_POST['reservation_id'];
        $dc_reservationid = $_POST['dc_reservationid'];
        
        $dc_hotel_id = 0;
        $sql = "SELECT dc_booking_rooms_link.dc_hotel_id as dc_hotel_id
		FROM deskofreservation
		INNER JOIN rooms ON deskofreservation.room_id = rooms.id
		INNER JOIN categories ON categories.id = rooms.category_id
        INNER JOIN dc_booking_rooms_link ON dc_booking_rooms_link.category_id = categories.id
		WHERE deskofreservation.id = " . $reservation_id;
        // echo $sql."<br>";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0)
        {
            $row = $query->row();
            $dc_hotel_id = $row->dc_hotel_id;
        }
        
        //echo $dc_hotel_id." ".$dc_reservationid;
        if($dc_hotel_id > 0){
            $data_conversation = $this->messages_model->get_booking_message_by_res($dc_hotel_id, $dc_reservationid);
            //print_r($data_conversation);
            if(isset($data_conversation ['data'] ['conversation'] ['conversation_id'])){
                $conversation_id = $data_conversation ['data'] ['conversation'] ['conversation_id'];
                
                $send_data = array();
                $send_data ['property_id'] = $dc_hotel_id;
                $send_data ['conversation'] = $conversation_id;
                $send_data ['text'] = $_POST['message'];
                
                $request = json_encode($send_data);
                
                $response = $this->messages_model->booking_send_messages($send_data);
                
                // = LOG =======
                $description_data = array();
                $description_data ['request'] = $send_data;
                $description_data ['response'] = json_decode($response, true);
                
                $dc_type = 18;

                $log_data = array();
                $log_data ['reservation_id'] = $reservation_id;
                $log_data ['type'] = "dcmessage";
                $log_data ['dc_type'] = $dc_type; // dc_message
                $log_data ['description'] = "json: ".json_encode($description_data);
                $this->Loger_admin->save_dcmessage_data ( $log_data );
            }
            
        }
        
        die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/$reservation_id/1'>" );
    }
    
    function create_misconduct(){
        echo "<pre>";
        print_r($_POST);
        //die();
        $reservation_id = $_POST['reservation_id'];
        $dc_reservationid = $_POST['dc_reservationid'];
        
        $this->dcm_booking_fsi->report_misconduct($_POST);
        die();
        die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/$reservation_id/1'>" );
    }
    
    function set_message_read($message_id_int){
        $message_data = $this->messages_model->get_booking_message_data($message_id_int);
        
        $data = array();
        $data ['property_id'] = $message_data['hotel_id'];
        $data ['conversation_id'] = $message_data['conversation_id'];
        $data ['participant_id'] = $message_data['participant_id'];
        $data ['message_id'] = $message_data['message_id'];
        $result = $this->dcm_booking_messages->set_messages_read($data);
        echo "<pre>".$result;
        print_r($result);
        //die();
        
        if(isset($result["data"]["ok"])){
            if($result["data"]["ok"] == 1){
                $update_data = array();
                $update_data ['is_read'] = 1;
                
                $update_keys = array();
                $update_keys ['message_id'] = $message_data['message_id'];
                $update_keys ['conversation_id'] = $message_data['conversation_id'];
                $this->db->update('dc_booking_messages', $update_data, $update_keys);
            }
        }
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/conversation/".$message_data['conversation_id_int']."'>" );
    }
    
    public function contracts_list() {
        $this->load->model ( 'booking_api_mdl' );
        $data = array ();
        $this->load->view ( 'dc_booking/contracts_list_view.php', $data );
    }
    
    public function contract($partner_id = 0) {
        if (!$partner_id) {
            die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/contracts_list'>" );
        }
        
        $this->load->model ( 'booking_api_mdl' );
        
        $data = array ('partner_id' => $partner_id);
        $load_view_filename = 'contract_create_view.php';
        
        $partner_data = $this->booking_api_mdl->get_partner_data_by_id($partner_id);
        $contract_data = $this->booking_api_mdl->get_contracts_by_email(array('email' => $partner_data->email));
        
        if (!count($contract_data->errors) && isset($contract_data->data->contract_signed)) {
            $data['contract_data'] = $contract_data;
            $load_view_filename = 'contract_view.php';
        }
        
        $this->load->view ( "dc_booking/$load_view_filename", $data );
    }
    
    public function properties_list() {
        $this->load->model ( 'booking_api_mdl' );
        $data = array ();
        $this->load->view ( 'dc_booking/properties_list_view.php', $data );
    }
    
    public function property_update($booking_prop_id = NULL) {
        $this->load->model ( 'booking_api_mdl' );
        
        $data = array ('booking_property_id' => $booking_prop_id);
        $this->load->view ( 'dc_booking/property_update_view.php', $data );
    }
    
    public function property_update_clear($booking_prop_id = NULL) {
        $this->load->model ( 'booking_api_mdl' );
        
        $data = array(
            'booking_property_id' => $booking_prop_id,
            'clear' => true 
        );
        $this->load->view ( 'dc_booking/property_update_view.php', $data );
    }
    
    public function property_update_post() {
        $this->load->model ( 'booking_api_mdl' );
        $post = $this->input->post();
        
        if($this->debug && $this->print_post_mode){
            echo('<pre>');
            print_r($post);
            die('DEBUG POST file: dc_booking_c2.php, function: property_update_post, Andrew, 21 лист. 2023 р.');
        }
        
        $booking_property_id = $post['booking_prop_id'];
        $data = array(
            'booking_property_id' => $booking_property_id,
            'action' => 'update',
            'data' => $post
        );
        $upd_result = $this->booking_api_mdl->update_property($data);
        $upd_result = print_r($upd_result, 1);
        $this->session->set_userdata(array('fsi_prop_upd_last_res' => $upd_result));
        
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/property_update/$booking_property_id'>" );
    }
    
    public function property_create($hms_prop_id) {
        $this->load->model ( 'booking_api_mdl' );
        echo '<pre>';
        print_r($hms_prop_id);
        echo "<br>To create a property, you must specify the following minimum details:

A legal entity ID - An identifier for the legal entity that owns or manages a property (such as a property management company or a hotel chain). For more information on how to retrieve your legal entity ID using Contracting API, see Retrieving the legal entity ID or partners can find it in their contract.
Provide the property name with only Latin characters.
Provide Physical location (PhysicalLocation) contact type with the following details:
Address line 1 - only latin characters are allowed.
City.
Postcode.
Provide General (general) and Invoice (invoices) contact types with the following details:
Contact person name (Given name and surname).
Email address, and
Phone number.
Provide the latitude and longitude details of the property's physical location.
Specify the checkin and checkout timing.
Specify the number of sellable units.
Specify the property's accommodation type.
Specify at least one language code for the property.";
        die("Died by Andrew at dc_booking_c2.php on 30 жовт. 2023 р.  18:15:07");
    }
    
    public function property_bind($hms_prop_id, $booking_prop_id) {
        $this->load->model ( 'booking_api_mdl' );
        $property_validation_result = $this->booking_api_mdl->validate_booking_property_id(array('booking_property_id' => $booking_prop_id));
        if (!isset($property_validation_result->Errors)) {
            //!!!!!!!!!!!!!!!!!!! USE dc_model::dc_setup_post($data) : mixed - RemoteSystemsTempFiles AND dc_model->add_booking_account
            $this->booking_api_mdl->update_booking_properties_tbl(array('booking_property_id' => $booking_prop_id));
            if (!$this->booking_api_mdl->property_already_binded(array('booking_property_id' => $booking_prop_id))) {
                $this->booking_api_mdl->bind_properties(array('hms_property_id' => $hms_prop_id, 'booking_property_id' => $booking_prop_id));
            }else{
                if ($this->debug) {
                    echo "<pre>";
                    die("Property $booking_prop_id allready binded!<br>");
                }
            }
        }else{
            if ($this->debug) {
                echo '<pre>';
                print_r($property_validation_result->Errors);
                die("Property $booking_prop_id errored on Booking!<br> ");
            }
        }
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/properties_list'>" );
    }
    
    public function property_unbind($booking_prop_id) {
        $this->load->model ( 'booking_api_mdl' );
        $this->booking_api_mdl->unbind_properties(array('booking_property_id' => $booking_prop_id));
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/properties_list'>" );
    }
    
    public function property_recovery($booking_prop_id) {
        $this->load->model ( 'booking_api_mdl' );
        $this->booking_api_mdl->update_booking_properties_tbl(array('booking_property_id' => $booking_prop_id));
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/properties_list'>" );
    }
    
    public function property_delete($booking_prop_id) {
        $this->load->model ( 'booking_api_mdl' );
        //!!!!!!!!!! USE dc_model::delete_booking_account($dc_account_id, $simple_tab_id=0) : void - RemoteSystemsTempFiles        
        $this->booking_api_mdl->delete_properties_conections(array('booking_property_id' => $booking_prop_id));
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/properties_list'>" );
    }
    
    public function rooms_list($booking_prop_id = null) {
        $this->load->model ( 'booking_api_mdl' );
        $data = array ('booking_prop_id' => $booking_prop_id);
        $this->load->view ( 'dc_booking/rooms_list_view.php', $data );
    }
    
    public function room_bind($hms_room_id, $booking_room_id, $booking_prop_id) {
        $this->load->model ( 'booking_api_mdl' );
        $property_attributes = $this->booking_api_mdl->get_property_attributes($booking_prop_id);
        if (!isset($property_attributes->Errors)) {
            if (!$this->booking_api_mdl->room_already_binded(array('booking_room_id' => $booking_room_id))) {
                $this->booking_api_mdl->bind_rooms(array(
                    'hms_room_id' => $hms_room_id,
                    'booking_room_id' => $booking_room_id,
                    'booking_property_id' => $booking_prop_id
                ));
            }else{
                if ($this->debug) {
                    echo "<pre>";
                    die("Room $booking_room_id allready binded!<br>");
                }
            }
        }else{
            if ($this->debug) {
                echo '<pre>';
                print_r($property_attributes->Errors);
                die("Property $booking_prop_id errored on Booking!<br> ");
            }
        }
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rooms_list/$booking_prop_id'>" );
    }
    
    public function room_unbind($booking_room_id, $booking_prop_id) {
        $this->load->model ( 'booking_api_mdl' );
        $this->booking_api_mdl->unbind_rooms(array('booking_room_id' => $booking_room_id));
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rooms_list/$booking_prop_id'>" );
    }
    
    public function rates_list($booking_prop_id = null) {
        $this->load->model ( 'booking_api_mdl' );
        $data = array ('booking_prop_id' => $booking_prop_id);
        $this->load->view ( 'dc_booking/rates_list_view.php', $data );
    }
    
    public function rate_bind($hms_rate_id, $booking_rate_id, $booking_prop_id) {
        if($this->debug && $this->print_post_mode){
            echo('<pre>$hms_rate_id: ');
            print_r($hms_rate_id);
            echo('<br>$booking_rate_id :');
            print_r($booking_rate_id);
            echo('<br>$booking_prop_id :');
            print_r($booking_prop_id);
            echo('<br>');
            die('DEBUG POST file: dc_booking_c2.php, function: rate_bind, Andrew, 20 груд. 2023 р.');
        }
        $this->load->model ( 'booking_api_mdl' );
        $property_attributes = $this->booking_api_mdl->get_property_attributes($booking_prop_id);
        if (!isset($property_attributes->Errors)) {
            if (!$this->booking_api_mdl->rate_already_binded(array('booking_rate_id' => $booking_rate_id, 'booking_property_id' => $booking_prop_id))) {
                $this->booking_api_mdl->bind_rates(array(
                    'hms_rate_id' => $hms_rate_id,
                    'booking_rate_id' => $booking_rate_id,
                    'booking_property_id' => $booking_prop_id
                ));
            }else{
                if ($this->debug) {
                    echo "<pre>";
                    die("Rate $booking_rate_id allready binded!<br>");
                }
            }
        }else{
            if ($this->debug) {
                echo '<pre>';
                print_r($property_attributes->Errors);
                die("Property $booking_prop_id errored on Booking!<br> ");
            }
        }
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rates_list/$booking_prop_id'>" );
    }
    
    public function rate_unbind($booking_rate_id, $booking_prop_id) {
        $this->load->model ( 'booking_api_mdl' );
        $this->booking_api_mdl->unbind_rates(array('booking_rate_id' => $booking_rate_id, 'booking_property_id' => $booking_prop_id));
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rates_list/$booking_prop_id'>" );
    }
    
    public function change_booking_rate_activity($booking_rate_id, $booking_prop_id, $activity = 0) {
        $this->load->model ( 'booking_api_mdl' );
        if ($activity) {
            $this->booking_api_mdl->activate_booking_rate(array('booking_rate_id' => $booking_rate_id, 'booking_property_id' => $booking_prop_id));
        }else {
            $this->booking_api_mdl->deactivate_booking_rate(array('booking_rate_id' => $booking_rate_id, 'booking_property_id' => $booking_prop_id));
        }
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rates_list/$booking_prop_id'>" );
    }
    
    public function create_booking_rate($booking_prop_id, $hms_rate_id=NULL) {
        $this->load->model ( 'booking_api_mdl' );
        $post = array(
            'booking_prop_id' => $booking_prop_id,
            'hms_rate_id' => $hms_rate_id,
            'action' => 'create',
        );
        $this->load->view ( 'dc_booking/create_rate_view.php', array('post' => $post));
    }
    
    public function update_booking_rate($booking_prop_id, $booking_rate_id, $hms_rate_id=NULL) {
        $this->load->model ( 'booking_api_mdl' );
        $post = array(
            'booking_prop_id' => $booking_prop_id,
            'booking_rate_id' => $booking_rate_id,
            'hms_rate_id' => $hms_rate_id,
            'action' => 'update',
        );
        $this->load->view ( 'dc_booking/create_rate_view.php', array('post' => $post));
    }
    
    public function crup_booking_rate_post() {
        $this->load->model ( 'booking_api_mdl' );
        $post = $this->input->post();
        if($this->debug && $this->print_post_mode){
            echo('<pre>');
            print_r($post);
            die('DEBUG POST file: dc_booking_c2.php, function: crup_booking_rate_post, Andrew, 8 груд. 2023 р.');
        }
        $action = $post['RatePlans']['RatePlan']['RatePlanNotifType'] == 'Overlay' ? 'update' : 'create';
        
        $booking_prop_id = $post['RatePlans']['HotelCode'];
        $booking_rate_id = isset($post['RatePlans']['RatePlan']['RatePlanCode']) ? $post['RatePlans']['RatePlan']['RatePlanCode'] : '';
        $hms_rate_id = isset($post['RatePlans']['RatePlan']['RatePlanID']) ? $post['RatePlans']['RatePlan']['RatePlanID'] : '';
        
        $crup_result = $this->booking_api_mdl->create_or_update_booking_rate($post);
        
        switch ($action) {
            case 'create':
                if (isset($crup_result->Errors) || $this->debug) {
                    die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/create_booking_rate/$booking_prop_id/$hms_rate_id'>" );
                }else {
                    if ($hms_rate_id && !$this->debug) {
                        if (isset($crup_result->Success)) {
                            $booking_rate_id = $crup_result->RatePlanCrossRefs->RatePlanCrossRef->attributes()->ResponseRatePlanCode;
                            $this->booking_api_mdl->bind_rates(array(
                                'hms_rate_id' => $hms_rate_id,
                                'booking_rate_id' => $booking_rate_id,
                                'booking_property_id' => $booking_prop_id
                            ));
                            die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rates_list/$booking_prop_id'>" );
                        }
                    }
                }
                break;
            case 'update':
                die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/update_booking_rate/$booking_prop_id/$booking_rate_id/$hms_rate_id'>" );
                break;
                
            default:
                echo '<pre>';
                print_r('Invalid action!');
                die("Died by Andrew at dc_booking_c2.php on 8 груд. 2023 р.");
                break;
        }
        
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/update_booking_rate/$booking_prop_id/$booking_rate_id/$hms_rate_id'>" );
        
        //die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rates_list/$booking_prop_id'>" );
    }
    
    public function change_booking_room_activity($booking_room_id, $booking_prop_id, $activity = 0) {
        $this->load->model ( 'booking_api_mdl' );
        if ($activity) {
            $this->booking_api_mdl->activate_booking_room(array('booking_room_id' => $booking_room_id, 'booking_property_id' => $booking_prop_id));
        }else {
            $this->booking_api_mdl->deactivate_booking_room(array('booking_room_id' => $booking_room_id, 'booking_property_id' => $booking_prop_id));
        }
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rooms_list/$booking_prop_id'>" );
    }
    
    public function create_booking_room($booking_prop_id, $hms_room_id=null) {
        $this->load->model ( 'booking_api_mdl' );
        $data = array(
            'booking_prop_id' => $booking_prop_id,
            'hms_room_id' => $hms_room_id,
            'action' => 'create',
        );
        $this->load->view ( 'dc_booking/create_room_view.php', array('post' => $data) );
    }
    
    public function update_booking_room($booking_prop_id, $booking_room_id, $hms_room_id=null) {
        $this->load->model ( 'booking_api_mdl' );
        $post = array(
            'booking_prop_id' => $booking_prop_id,
            'booking_room_id' => $booking_room_id,
            'hms_room_id' => $hms_room_id,
            'action' => 'update',
        );
        $this->load->view ( 'dc_booking/create_room_view.php', array('post' => $post));
    }
    
    public function crup_booking_room_post() {
        $this->load->model ( 'booking_api_mdl' );
        $post = $this->input->post();
        $action = $post['InvNotifType'] == 'Overlay' ? 'update' : 'create';

        $booking_prop_id = $post['HotelCode'];
        $booking_room_id = isset($post['InvCode']) ? $post['InvCode'] : '';
        $hms_room_id = isset($post['hms_room_id']) ? $post['hms_room_id'] : '';
        
        if($this->debug && $this->print_post_mode){
            echo('<pre>');
            print_r($post);
            die('DEBUG POST file: dc_booking_c2.php, function: crup_booking_room_post, Andrew, 7 груд. 2023 р.');
        }
        
        $crup_result = $this->booking_api_mdl->create_or_update_booking_room($post);
        
        switch ($action) {
            case 'create':
                if (isset($crup_result->Errors) || $this->debug) {
                    die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/create_booking_room/$booking_prop_id/$hms_room_id'>" );
                }else {
                    if ($hms_room_id) {
                        if (isset($crup_result->Success) && !$this->debug) {
                            $booking_room_id = $crup_result->InventoryCrossRefs->InventoryCrossRef->attributes()->ResponseInvCode;
                            $this->booking_api_mdl->bind_rooms(array(
                                'hms_room_id' => $hms_room_id,
                                'booking_room_id' => $booking_room_id,
                                'booking_property_id' => $booking_prop_id,
                            ));
                            die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rooms_list/$booking_prop_id'>" );
                        }
                    }
                }
                break;
            case 'update':
                die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/update_booking_room/$booking_prop_id/$booking_room_id/$hms_room_id'>" );
                break;
            
            default:
                echo '<pre>';
                print_r('Invalid action!');
                die("Died by Andrew at dc_booking_c2.php on 8 груд. 2023 р.");
                break;
        }
        
        die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/update_booking_room/$booking_prop_id/$booking_room_id/$hms_room_id'>" );
        
        //die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/rooms_list/$booking_prop_id'>" );
    }
    
    public function get_booking_roomname_ajax($room_type_code = 1){
        $this->load->model ( 'booking_api_mdl' );
        $result = $this->booking_api_mdl->get_booking_roomname($room_type_code);
        echo json_encode($result);
    }
    
    public function obp_upload( $property_id = 4386613 )
        {
    
            $rooms = $this->dcm_booking_v2->get_roomrates( $property_id );
        
            $price = array();
            for( $i=1; $i <= $rooms[0]['rates'][0]['max_persons']; $i++ ){
                array_push($price, array(
                    "@numberofguests" => $i,
                    rand($i*100,$i*200)
                ));
            }
        
            $update = array();
			$update["room"] = array();
            array_push($update["room"], array(
            '@id' => $rooms[0]['room_id'],
            'date' => array(
                '@from' => date('Y-m-d'),
                '@to' => date('Y-m-d', strtotime("+2 weeks")),
                'rate' => array(
                    "@id" => $rooms[0]['rates'][0]['id']
                ),
                'price' => $price
            )
            ));
            echo "<pre>";
            print_r($update);
            die();
        }
        
        public function restaurant($restaurant_id = null) {
            $this->load->model ( 'booking_api_mdl' );
            $hms_property_id = 5;
            $data = array(
                'booking_property_id' => '4386613',
                'hms_property_id' => $hms_property_id,
                'restaurant_id' => (int)$restaurant_id,
            );
            $this->load->view ( 'dc_booking/restaurant_view.php', $data );
        }
        
        public function crup_restaurant_post() {
            $post = $this->input->post();
            if($this->debug && $this->print_post_mode){
                echo('<pre>');
                
                print_r($post);
                
                print_r(json_encode($post));
                die('DEBUG POST file: dc_booking_c2.php, function: restaurant_post, Andrew, 28 груд. 2023 р.');
            }
            
            $this->load->model ( 'booking_api_mdl' );
            $crup_result = $this->booking_api_mdl->create_or_update_restaurant($post);
            
            $restaurant_id = $crup_result['hms_restaurant_id'] ? $crup_result['hms_restaurant_id'] : null;
            
            die ( "<meta http-equiv='refresh' content='0;url=/dc_booking_c2/restaurant/$restaurant_id'>" );
        }

}