<?php
class Contacts extends CI_Controller
{
    public $debug;
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Authorization');
        $this->Authorization->IsLogined();
        $this->load->model('contacts_mdl');
        $this->load->model('htmltpl');
        
        $this->debug = (bool) $this->session->userdata('global_debug');
    }

    public function index() {
        die("<meta http-equiv='refresh' content='0;url=/contacts/list_all'>");
    }
    public function list_all($page=1)
    {
        $data = array();
        $this->load->view ( "contacts/list_view.php", $data );
    }
    
    public function add()
    {
        $data = array();
        $this->load->view ( "contacts/crup_view.php", $data );
    }
    
    public function update($contact_id = null)
    {
        $data = array('contact_id' => $contact_id);
        $this->load->view ( "contacts/crup_view.php", $data );
    }
    
    public function save()
    {
        $post = $this->input->post();
        if (isset($post['id']) && $post['id']) {
            $this->contacts_mdl->update($post);
        }else {
            $this->contacts_mdl->create($post);
        }
        
        die("<meta http-equiv='refresh' content='0;url=/contacts/list_all'>");
    }
    
    public function delete()
    {
        $post = $this->input->post();
        $this->contacts_mdl->delete($post);
        
        die("<meta http-equiv='refresh' content='0;url=/contacts/list_all'>");
    }

}