<?php
class Fms_core extends CI_Model {
	function __construct() {
		parent::__construct ();

		$this->load->model ( 'frontdesk' );
	}
	function legalsystem_save($data) {
		$sql = "INSERT INTO hotelix_config (name, str_value) VALUES('legalsystem', '" . $data ["legalsystem"] . "') ON DUPLICATE KEY UPDATE str_value = '" . $data ["legalsystem"] . "'";
		$query = $this->db->query ( $sql );
	}
	function options_save($data) {
		$sql = "INSERT INTO modules (name, is_active) VALUES('fms', '" . $data ["fms_active"] . "') ON DUPLICATE KEY UPDATE is_active = '" . $data ["fms_active"] . "'";
		$query = $this->db->query ( $sql );
		/*
		$sql = "INSERT INTO hotelix_config (name, str_value) VALUES('fms_hi_region', '" . $data ["fms_hi_region"] . "') ON DUPLICATE KEY UPDATE str_value = '" . $data ["fms_hi_region"] . "'";
		$query = $this->db->query ( $sql );
		$sql = "INSERT INTO hotelix_config (name, str_value) VALUES('fms_hi_state', '" . $data ["fms_hi_state"] . "') ON DUPLICATE KEY UPDATE str_value = '" . $data ["fms_hi_state"] . "'";
		$query = $this->db->query ( $sql );
		$sql = "INSERT INTO hotelix_config (name, str_value) VALUES('fms_hi_city', '" . $data ["fms_hi_city"] . "') ON DUPLICATE KEY UPDATE str_value = '" . $data ["fms_hi_city"] . "'";
		$query = $this->db->query ( $sql );
		$sql = "INSERT INTO hotelix_config (name, str_value) VALUES('fms_hi_subcity', '" . $data ["fms_hi_subcity"] . "') ON DUPLICATE KEY UPDATE str_value = '" . $data ["fms_hi_subcity"] . "'";
		$query = $this->db->query ( $sql );
		$sql = "INSERT INTO hotelix_config (name, str_value) VALUES('fms_hi_cityregion', '" . $data ["fms_hi_cityregion"] . "') ON DUPLICATE KEY UPDATE str_value = '" . $data ["fms_hi_cityregion"] . "'";
		$query = $this->db->query ( $sql );
		$sql = "INSERT INTO hotelix_config (name, str_value) VALUES('fms_hi_street', '" . $data ["fms_hi_street"] . "') ON DUPLICATE KEY UPDATE str_value = '" . $data ["fms_hi_street"] . "'";
		$query = $this->db->query ( $sql );
		$sql = "INSERT INTO hotelix_config (name, str_value) VALUES('fms_hi_objectnuber', '" . $data ["fms_hi_objectnuber"] . "') ON DUPLICATE KEY UPDATE str_value = '" . $data ["fms_hi_objectnuber"] . "'";
		$query = $this->db->query ( $sql );

		$sql = "INSERT INTO hotelix_config (name, str_value) VALUES('fms_hotel_uid', '" . $data ["fms_hotel_uid"] . "') ON DUPLICATE KEY UPDATE str_value = '" . $data ["fms_hotel_uid"] . "'";
		$query = $this->db->query ( $sql );
		$sql = "INSERT INTO hotelix_config (name, str_value) VALUES('fms_hotel_inn', '" . $data ["fms_hotel_inn"] . "') ON DUPLICATE KEY UPDATE str_value = '" . $data ["fms_hotel_inn"] . "'";
		$query = $this->db->query ( $sql );
		$sql = "INSERT INTO hotelix_config (name, str_value) VALUES('fms_supplierinfo', '" . $data ["fms_supplierinfo"] . "') ON DUPLICATE KEY UPDATE str_value = '" . $data ["fms_supplierinfo"] . "'";
		$query = $this->db->query ( $sql );
		$sql = "INSERT INTO hotelix_config (name, value) VALUES('fms_subdivision', '" . $data ["fms_subdivision"] . "') ON DUPLICATE KEY UPDATE value = '" . $data ["fms_subdivision"] . "'";
		$query = $this->db->query ( $sql );
		*/
	}

	function fms_print_save($reservation_id, $guest_id) {
		$sql = "INSERT INTO fms_records (reservation_id, guest_id, state) VALUES('" . $reservation_id . "', '" . $guest_id . "', 1) ON DUPLICATE KEY UPDATE state = 1";
		$query = $this->db->query ( $sql );
	}
	function get_fms_data($partner_id = 0){
		$return_data = array ();
		$sql =  "SELECT fms_account.*, partners.name as hname FROM fms_account inner join partners
		    on partners.id = fms_account.partner_id WHERE partner_id = " . $partner_id;
		//echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();

			$return_data ["fms_hi_region"] = $row->fms_hi_region;
			$return_data ["fms_hi_state"] = $row->fms_hi_state;
			$return_data ["fms_hi_city"] = $row->fms_hi_city;
			$return_data ["fms_hi_subcity"] = $row->fms_hi_subcity;
			$return_data ["fms_hi_cityregion"] = $row->fms_hi_cityregion;
			$return_data ["fms_hi_street"] = $row->fms_hi_street;
			$return_data ["fms_hi_objectnumber"] = $row->fms_hi_objectnumber;
			$return_data ["fms_hi_fias_object"] = $row->fms_hi_fias_object;
			$return_data ["fms_hi_fias_object_active"] = $row->fms_hi_fias_object_active;

			$return_data ["fms_hiloc_region"] = $row->fms_hiloc_region;
			$return_data ["fms_hiloc_state"] = $row->fms_hiloc_state;
			$return_data ["fms_hiloc_city"] = $row->fms_hiloc_city;
			$return_data ["fms_hiloc_subcity"] = $row->fms_hiloc_subcity;
			$return_data ["fms_hiloc_cityregion"] = $row->fms_hiloc_cityregion;
			$return_data ["fms_hiloc_street"] = $row->fms_hiloc_street;
			$return_data ["fms_hiloc_objectnumber"] = $row->fms_hiloc_objectnumber;
			$return_data ["fms_hiloc_fias_object"] = $row->fms_hiloc_fias_object;
			$return_data ["fms_hiloc_fias_object_active"] = $row->	fms_hiloc_fias_object_active;

			$return_data ["fms_ummsId"] = $row->fms_hotel_uid;
			$return_data ["fms_uid"] = $row->fms_uid;
			$return_data ["fms_hotel_inn"] = $row->fms_hotel_inn;
			$return_data ["fms_hotel_name"] = $row->hname;
			$return_data ["fms_supplierinfo"] = $row->fms_supplierinfo;
			$return_data ["fms_subdivision"] = $row->fms_subdivision;
		}

		return $return_data;
	}
	function converttime2ru ($date) {
	    $arr = explode('-', $date);
	    if (sizeof($arr) == 3) {
	        list($year, $month, $day) = $arr;
	        return ($day . "." .$month ."." . $year);
	    }
	    return "";
	}
	function getuser($userid) {
		$user_data = array();
		$user_data ["fullname"] = "";
		$user_data ["lastname"] = "";
		$user_data ["middlename"] = "";
		$user_data ["dob"] = "";

		$user_data ["citizenship"] = "";
		$user_data ["bith_country"] = "";
		$user_data ["bitch_city"] = "";
		$user_data ["doc_documenttype"] = "";


		$user_data ["passportid"] = "";
		$user_data ["doc_precode"] = "";
		$user_data ["doc_date_open"] = "";
		$user_data ["doc_officialorgan"] = "";

		$user_data ["region"] = "";
		$user_data ["state"] = "";
		$user_data ["city"] = "";
		$user_data ["address"] = "";
		$user_data ["building"] = "";
		$user_data ["apartment"] = "";

		$user_data ["fias_addr_object"] = "9be836d9-3292-467f-937c-473688eaedec";
		$sql = "select * FROM fms_users";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$user_data ["fullname"] = $row->fullname;
			$user_data ["lastname"] = $row->lastname;
			$user_data ["middlename"] = $row->middlename;
			$user_data ["dob"] = $row->dob;

			$user_data ["citizenship"] = $row->citizenship;
			$user_data ["bith_country"] = $row->bith_country;
			$user_data ["bitch_city"] = $row->bitch_city;
			$user_data ["doc_documenttype"] = $row->doc_documenttype;


			$user_data ["passportid"] = $row->passportid;
			$user_data ["doc_precode"] = $row->doc_precode;
			$user_data ["doc_date_open"] = $row->doc_date_open;
			$user_data ["doc_officialorgan"] = $row->doc_officialorgan;

			$user_data ["region"] = $row->region;
			$user_data ["state"] = $row->state;
			$user_data ["city"] = $row->city;
			$user_data ["address"] = $row->address;
			$user_data ["building"] = $row->building;
			$user_data ["apartment"] = $row->apartment;
			$user_data ["fias_addr_object"] = $row->fias_addr_object;
		}
	    return $user_data;
	}
	function get_unotifynumber($partner_id){
		$unotifynumber = 0;
		$sql = "select notifynumber FROM fms_account WHERE partner_id = ".$partner_id;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$unotifynumber = $row->notifynumber;
			$unotifynumber += 1;
		}
		$sql = "UPDATE fms_account SET notifynumber = " . $unotifynumber . " WHERE partner_id = ".$partner_id;
		$query = $this->db->query ( $sql );
		$unotifynumber = sprintf("%'.06d\n", $unotifynumber);
		return $unotifynumber;
	}
	function get_xml_data($resID, $guestID) {
		$userID = $_SESSION ['user']['id'];
		$user_data = $this->GetUser($userID);
		$guest_data = $this->frontdesk->GetGuest($guestID);
		$reservation_details_data = $this->frontdesk->GetGuest_reservation_details($guestID, $resID);
		$reservation_data = $this->frontdesk->GetReservation($resID);

		//echo "<pre>";
		//print_r($reservation_details_data);
		//print_r($reservation_data);


		$legalsystem = $this->frontdesk->getlegalsystem();
		$legalsystem_db = $this->frontdesk->getlegalsystem_db($legalsystem);
		$dict_visitpurpose_mass = $this->fms_core->get_dict_visitpurpose($legalsystem_db, 1);
		$dict_entrygoal_mass = $this->fms_core->get_dict_entrygoal($legalsystem_db, 1);
		$dict_visamultiplicity_mass = $this->fms_core->get_dict_visamultiplicity($legalsystem_db, 1);
		$dict_visacategory_mass = $this->fms_core->get_dict_visacategory($legalsystem_db, 1);

		$fms_data = $this->get_fms_data($reservation_data["partner"]);
		$hotel_id = $this->config->item('hotel_id');
		$hotel_name = "";
		$query = $this->db->query("SELECT * FROM logo");
		if ($query->num_rows() > 0) {
			$row = $query->row();
			$hotel_name = stripslashes($row->logo_title);
		}

		$mig_case_unotifynumber = $this->get_unotifynumber($reservation_data["partner"]);

	    $response = array();

	    $uniqtime = time() . "-" . rand(1000, 9999);

	    $someuniq = $hotel_id."-".$reservation_data["reservation_id"]."-".$guest_data["id"] . "-" . $uniqtime;

	    $response["mig_case_unotifynumber"] = $mig_case_unotifynumber;

	    $response["root_uid"] = $someuniq . "-1";
	    if(isset($fms_data["fms_ummsId"])){
	    	$response["fms_ummsId"] = $fms_data["fms_ummsId"];
	    	$response["fms_uid"] = $fms_data["fms_uid"];
	    	$response["fms_supplierinfo"] = $fms_data["fms_supplierinfo"];
	    }else{
	    	$response["fms_ummsId"] = "";
	    	$response["fms_uid"] = "";
	    	$response["fms_supplierinfo"] = "";
	    }
	    $response["hms_global_requestnumber"] = $someuniq . "-2";

	    $response["hms_userid"] = $reservation_data["id_user"];
	    $response["hms_make_date_time"] = gmdate ( "Y-m-d\TH:i:s");
	    $response["hms_make_date_time"] = date("c", time());
	    $response["root_number"] = $someuniq . "-0";
	    $response["person_uid"] = $someuniq . "-3";
	    $response["personid"] = $someuniq . "-4";
	    $response["document_uid"] = $someuniq . "-5";
	    $response["organization_uid"] = $someuniq . "-6";

	    $response["hms_partner_id"] = $reservation_data["partner"];


	    $response["lastname_lat"] = $guest_data["lastname_lat"];
	    $response["firstname_lat"] = $guest_data["firstname_lat"];
	    $response["lastname"] = mb_strtoupper ( $guest_data["lastname"] , "UTF-8");
	    $response["firstname"] = mb_strtoupper ( $guest_data["firstname"], "UTF-8");
	    $response["middlename"] = mb_strtoupper ( $guest_data["middlename"], "UTF-8");
	    $response["hms_guest_gender"] = "";
		switch ($guest_data ["gender"]) {
			case 1 :
				$response ["hms_guest_gender"] = "M";
				break;
			case 2 :
				$response ["hms_guest_gender"] = "F";
				break;
		}
		$isba = false;
		if (trim($guest_data['addrbuilding']) !== "") {
		    $response['xml_housing_building'] = "\n<housing>
				<type>
					<type>addressObjectType</type>
					<element>1202</element>
				</type>
				<value>" . addslashes($guest_data['addrbuilding']) ."</value>
				</housing>";
		    $isba = true;
		} else {
		    $response['xml_housing_building'] = "";
		}
		if (trim($guest_data['addrapt']) !== "") {
		    if ($isba) {
		         $response['xml_housing_apt'] = "\n<housing>";
		    } else {
		        $response['xml_housing_apt'] = "\n<housing>";
		    }
		    $response['xml_housing_apt'] .= "
				<type>
					<type>addressObjectType</type>
					<element>1303</element>
				</type>
				<value>" . $guest_data['addrapt'] ."</value>
			</housing>";
		} else {
		    if ($isba) {
		    $response['xml_housing_apt'] = "";
		    } else  {
		        $response['xml_housing_apt'] = "\n</housing>";
		        $response['xml_housing_apt'] = "";
		    }
		}

	    $response["hms_guest_dob"] = $this->converttime2ru($guest_data["dob"]);
	    $response["hms_citizenship_countrycode"] = $guest_data["citizenship_code"];
	    $response["hms_bithplace_countrycode"] = $guest_data["country_code"];
	    $response["hms_bithplace_city"] = "";
	    $response["hms_dul_documenttypeID"] = $guest_data["doc_type"];
	    $response["hms_dul_series"] = preg_replace('/\s+/', '', $guest_data["doc_precode"]);
	    $response["hms_dul_number"] = $guest_data["passportid"];
	    $response["hms_dul_officialorgan_fmsID"] = $guest_data["dict_officialorgan_fmsCODE"];
	    $response["hms_dul_issue_date"] = $guest_data["doc_date_open"];
	    $response["hms_dul_validto_date"] = $guest_data["doc_date_till"];

	    $response["hms_docResidence"] = $guest_data["docResidence"];
	    $response["hms_docResidence_authority"] = $guest_data["docResidence_authority"];
	    $response["hms_docResidence_decisionNumber"] = $guest_data["docResidence_decisionNumber"];
	    $response["hms_docResidence_decisionDate"] = $guest_data["docResidence_decisionDate"];

	    $response["hms_mg_region"] = $guest_data["state"];
	    $response["hms_mg_state"] = $guest_data["pob_state"];
	    $response["hms_mg_city"] = $guest_data["city"];
	    $response["hms_mg_subcity"] = "";
	    $response["hms_mg_cityregion"] = "";
	    $response["hms_mg_street"] = $guest_data["address"];
	    $response["hms_mg_objectnuber"] = "";
	    $response["hms_mg_officialorgan_kpp_code"] = $reservation_details_data['officialorgan_kpp_code'];



	    $response["hms_mc_card_precode"] = $reservation_details_data["migration_card_precode"];
	    $response["hms_mc_card_num"] = $reservation_details_data["migration_card_num"];
	    $response["hms_mc_reg_date_in"] = $reservation_details_data["reg_date_in"];
	    $response["hms_mc_reg_date_out"] = $reservation_details_data["reg_date_out"];
	    $response["hms_mc_uid"] = $someuniq . "-mc";
	    $response["hms_resdoc_uid"] = $someuniq . "-resdoc";


	    if(isset($dict_visitpurpose_mass[$reservation_details_data["visitpurpose"]])){
	        $response["hms_mc_visitpurpose"] = $dict_visitpurpose_mass[$reservation_details_data["visitpurpose"]];
	        $response["hms_mc_visitpurpose"] = $reservation_details_data["visitpurpose"];
	    }else{
	        $response["hms_mc_visitpurpose"] = "";
	        $response["hms_mc_visitpurpose"] = $reservation_details_data["visitpurpose"];
	    }

// 	    $response["hms_mc_visitpurpose"] = $reservation_details_data["visitpurpose"];
	    if ($response["hms_mc_visitpurpose"] == 0) {
	        $response["hms_mc_visitpurpose"] = 139353;
	    }

	    $response["hms_visa_reg_visa_precode"] = $reservation_details_data["reg_visa_precode"];
	    $response["hms_visa_reg_visa_num"] = $guest_data["reg_visa_num"];
	    $response["hms_resdoc_identitifier"] = $reservation_details_data["resdoc_identitifier"];

	    if(isset($reservation_details_data["visamultiplicity"])){
	    	$response["hms_visa_visamultiplicity"] = $reservation_details_data["visamultiplicity"];
	    }else{
	    	$response["hms_visa_visamultiplicity"] = "";
	    }
	    if(isset($reservation_details_data["goal_id"]) ){
	    	$response["hms_visa_entrygoal"] = $reservation_details_data["goal_id"];
	    }else{
	    	$response["hms_visa_entrygoal"] = "";
	    }
	    if(isset($reservation_details_data["reg_visa_type"])){
	    	$response["hms_visa_reg_visa_type"] = $reservation_details_data["reg_visa_type"];
	    }else{
	    	$response["hms_visa_reg_visa_type"] = "";
	    }

	    $response["hms_visa_card_date_of_issue"] = $reservation_details_data["card_date_of_issue"];
	    $response["hms_visa_reg_visa_date_till"] = $guest_data["reg_visa_date_till"];

	    $response["hms_datein"] = $reservation_data["datein"];
	    $response["hms_dateout"] = $reservation_data["dateout"];
	    if(isset($fms_data["fms_hotel_inn"])){
	    	$response["hms_hotel_inn"] = $fms_data["fms_hotel_inn"];
	    	$response["hms_hotel_name"] = $fms_data["fms_hotel_name"];
	    	$response["hms_hi_region"] = $fms_data["fms_hi_region"];
	    	$response["hms_hi_state"] = $fms_data["fms_hi_state"];
	    	$response["hms_hi_city"] = $fms_data["fms_hi_city"];
	    	$response["hms_hi_subcity"] = $fms_data["fms_hi_subcity"];
	    	$response["hms_hi_cityregion"] = $fms_data["fms_hi_cityregion"];
	    	$response["hms_hi_street"] = $fms_data["fms_hi_street"];
	    	$response["hms_hi_objectnumber"] = $fms_data["fms_hi_objectnumber"];
	    	$response["fms_hi_fias_object"] = $fms_data["fms_hi_fias_object"];
	    	$response ["fms_hi_fias_object_active"] = $fms_data["fms_hi_fias_object_active"];

	    	$response["hms_hiloc_region"] = $fms_data["fms_hiloc_region"];
	    	$response["hms_hiloc_state"] = $fms_data["fms_hiloc_state"];
	    	$response["hms_hiloc_city"] = $fms_data["fms_hiloc_city"];
	    	$response["hms_hiloc_subcity"] = $fms_data["fms_hiloc_subcity"];
	    	$response["hms_hiloc_cityregion"] = $fms_data["fms_hiloc_cityregion"];
	    	$response["hms_hiloc_street"] = $fms_data["fms_hiloc_street"];
	    	$response["hms_hiloc_objectnumber"] = $fms_data["fms_hiloc_objectnumber"];
	    	$response["fms_hiloc_fias_object"] = $fms_data["fms_hiloc_fias_object"];
	    	$response ["fms_hiloc_fias_object_active"] = $fms_data["fms_hiloc_fias_object_active"];
	    	$response["fms_subdivision"] = $fms_data["fms_subdivision"];
	    }else{
	    	$response["hms_hotel_inn"] = "";
	    	$response["hms_hotel_name"] = "";
	    	$response["hms_hi_region"] = "";
	    	$response["hms_hi_state"] = "";
	    	$response["hms_hi_city"] = "";
	    	$response["hms_hi_subcity"] = "";
	    	$response["hms_hi_cityregion"] = "";
	    	$response["hms_hi_street"] = "";
	    	$response["hms_hi_objectnumber"] = "";
	    	$response["fms_hi_fias_object"] = "";
	    	$response ["fms_hi_fias_object_active"] = 0;

	    	$response["hms_hiloc_region"] = "";
	    	$response["hms_hiloc_state"] = "";
	    	$response["hms_hiloc_city"] = "";
	    	$response["hms_hiloc_subcity"] = "";
	    	$response["hms_hiloc_cityregion"] = "";
	    	$response["hms_hiloc_street"] = "";
	    	$response["hms_hiloc_objectnumber"] = "";
	    	$response["fms_hiloc_fias_object"] = "";
	    	$response ["fms_hiloc_fias_object_active"] = 0;
	    	$response["fms_subdivision"] = "";
	    }

	   	$response["authorityorgan_name"] = $this->get_authorityorgan_name($guest_data["dict_officialorgan_fmsCODE"], $guest_data["passportissuedby"]);
	   	$response["authorityorgan_id"] = $this->get_authorityorgan_id($guest_data["dict_officialorgan_fmsCODE"]);



	    $response["xxx"] = "";

	    $response["user_firstname"] = $user_data["fullname"];
	    $response["user_lastname"] = $user_data["lastname"];
	    $response["user_middlename"] = $user_data["middlename"];
	    $response["user_dob"] = $this->converttime2ru($user_data["dob"]);
	    $response["user_dob"] = $user_data["dob"];

	    $response["user_citizenship"] = $user_data["citizenship"];
	    $response["user_bith_country"] = $user_data["bith_country"];
	    $response["user_bitch_city"] = $user_data["bitch_city"];
	    $response["user_doc_documenttype"] = $user_data["doc_documenttype"];

	    $response["user_passportid"] = $user_data["passportid"];
	    $response["user_doc_precode"] = $user_data["doc_precode"];
	    $response["user_doc_date_open"] = $user_data["doc_date_open"];
	    $response["user_officialOrgan"] = $user_data["doc_officialorgan"];

	    $response["user_region"] = $user_data["region"];
	    $response["user_state"] = $user_data["state"];
	    $response["user_city"] = $user_data["city"];
	    $response["user_address"] = $user_data["address"];
	    $response["user_building"] = $user_data["building"];
	    $response["user_apartment"] = $user_data["apartment"];
	    $response["user_fias_addr_object"] = $user_data["fias_addr_object"];
	    $response["user_docuid"] = $someuniq . "-uduid";


	    return $response;
	}

	function get_authorityorgan_name($code, $oname){
		$name = $oname;
		if (trim($code) == "") {
		    return $name;
		}
		$sql = "SELECT NAME FROM global_fms.dict_officialorgan_fms WHERE CODE LIKE '".$code."'";
		$query = $this->db->query ( $sql );
		$state = 0;
		if ($query->num_rows () > 0) {
			$row = $query->row ();

			$name = $row->NAME;
		}
		return $name;
	}
	function get_authorityorgan_id($code){
	    if (trim($code) == "") {
	        return "";
	    }
	    $name = "";
	    $sql = "SELECT id FROM global_fms.dict_officialorgan_fms WHERE CODE LIKE '".$code."'";
	    $query = $this->db->query ( $sql );
	    $state = 0;
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();

	        $name = $row->id;
	    }
	    return $name;
	}
	function print_fms($reservation_id, $guest_id){
		if ($_SESSION ["user"] ["login"] == "support@otelms.com" or $_SESSION ["user"] ["login"] == "info@otelms.com") {
			$date_format = 0;
			$query = $this->db->query ( "SELECT value FROM hotelix_config WHERE name LIKE 'date_format'" );
			$state = 0;
			if ($query->num_rows () > 0) {
				$row = $query->row ();

				$date_format = $row->value;
			}

			$reservation_data = array ();
			if ($reservation_id != 0) {
				$reservation_data = $this->frontdesk->GetReservation ( $reservation_id );
				if (count ( $reservation_data ) == 0) {
					return "Error";
				}
			}

			$guest_data = array ();
			if ($guest_id != 0) {
				$guest_data = $this->frontdesk->GetGuest ( $guest_id );
				if (count ( $guest_data ) == 0) {
					return "Error";
				}
			}
			$data = array ();
			switch ($date_format) {
				case 0 :
					$data ["datein"] = $reservation_data ["datein"];
					$data ["dateout"] = $reservation_data ["dateout"];
					break;
				case 1 :
					$data ["datein"] = date_format ( date_create ( $reservation_data ["datein"] ), 'd.m.Y' );
					$data ["dateout"] = date_format ( date_create ( $reservation_data ["dateout"] ), 'd.m.Y' );

					break;
				default :
					$data ["datein"] = $reservation_data ["datein"];
					$data ["dateout"] = $reservation_data ["dateout"];
					break;
			}
			// $data ["datein"] = $reservation_data ["datein"];
			// $data ["dateout"] = $reservation_data ["dateout"];
			$data ["firstname"] = $guest_data ["firstname"];
			$data ["lastname"] = $guest_data ["lastname"];
			$data ["middlename"] = $guest_data ["middlename"];
			switch ($guest_data ["gender"]) {
				case 1 :
					$data ["gender"] = "М";
					break;
				case 2 :
					$data ["gender"] = "Ж";
					break;
				default :
					$data ["gender"] = "";
					break;
			}

			$data ["citizenship"] = $guest_data ["citizenship"];
			$data ["country"] = $guest_data ["country"];
			$data ["city"] = $guest_data ["city"];

			switch ($guest_data ["foreign"]) {
				case 0 :
					$request = $this->parser->parse ( 'templates/fms_xml/russ.xml', $data, true );
					break;
				case 1 :
					$request = $this->parser->parse ( 'templates/fms_xml/inostranec.xml', $data, true );
					break;
			}

			echo htmlspecialchars_decode($request)."<br><br><br>";

			$this->fms_print_save($reservation_id, $guest_id);
		}
	}

	function get_dict_country($db_name, $return_format = 0){
		$dict_country = array();
		$sql = "SELECT id, NAME, NAME_LAT FROM $db_name.dict_country ORDER BY NAME_LAT ASC";
		//echo $sql;
		$query = $this->db->query ( $sql );
	    foreach ($query->result() as $row)
   		{
     		if($return_format == 0){
				array_push ( $dict_country, array (
				"id" => $row->id,
				"name" => $row->NAME,
				"name_lat" => $row->NAME_LAT,
				));
     		}else{
     			$dict_country [$row->id]["id"] = $row->id;
     			$dict_country [$row->id]["name"] = $row->NAME;
     			$dict_country [$row->id]["name_lat"] = $row->NAME_LAT;
     			$dict_country [$row->id]["selected"] = "";
     		}
		}
		return $dict_country;
	}

	function get_dict_documenttype($db_name, $order = 0, $order_ru = 0){
		$dict_documenttype = array();
		$order_str = "ORDER by NAME ASC";
		if($order == 1){
			$order_str = "ORDER by order_noru ASC";
		}
		if($order_ru == 1){
			$order_str = "ORDER by order_ru ASC";
		}
		$sql = "SELECT * FROM $db_name.dict_documenttype ".$order_str;
// 		echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			$dict_documenttype[$row->﻿ID] = array (
					"id" => $row->﻿ID,
					"name" => $row->NAME
			);
		}
		return $dict_documenttype;
	}
	function get_dict_entrygoal($db_name, $return_type = 0){
		$dict_entrygoal = array();
		$sql = "SELECT id, NAME FROM $db_name.dict_entrygoal ORDER by NAME DESC";
		//echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows() > 0)
		{
   			foreach ($query->result() as $row)
   			{
				if ($return_type == 0) {
					array_push ( $dict_entrygoal, array (
							"id" => $row->id,
							"name" => $row->NAME
					) );
				} else {
					$dict_entrygoal [$row->id] = $row->NAME;
				}
			}
		}
		return $dict_entrygoal;
	}
	function get_dict_mig_programparticipanttype(){
		$dict_mig_programparticipanttype = array();
		$sql = "SELECT * FROM global_fms.dict_mig_programparticipanttype";
		//echo $sql;
		$query = $this->db->query ( $sql );
		 foreach ($query->result() as $row)
   		{

			array_push ( $dict_mig_programparticipanttype, array (
			"id" => $row->id,
			"name" => $row->NAME
			) );
		}
		return $dict_mig_programparticipanttype;
	}
	function get_dict_officialorgan_fms(){
		$dict_officialorgan_fms = array();
		$sql = "SELECT * FROM global_fms.dict_officialorgan_fms";
		//echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			array_push ( $dict_officialorgan_fms, array (
			"id" => $row->id,
			"name" => $row->NAME
			) );
		}
		return $dict_officialorgan_fms;
	}
	function get_dict_officialorgan_kpp($db_name){
		$dict_officialorgan_kpp = array();
		$sql = "SELECT * FROM $db_name.dict_officialorgan_kpp";
		//echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			array_push ( $dict_officialorgan_kpp, array (
			"id" => $row->id,
			"name" => $row->NAME
			) );
		}
		return $dict_officialorgan_kpp;
	}
	function get_dict_profession($db_name){
		$dict_profession = array();
		$sql = "SELECT * FROM $db_name.dict_profession";
		//echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			array_push ( $dict_profession, array (
			"id" => $row->id,
			"name" => $row->NAME
			) );
		}
		return $dict_profession;
	}
	function get_dict_visacategory($db_name, $return_type = 0){
		$dict_visacategory = array();
		$sql = "SELECT * FROM $db_name.dict_visacategory";
		//echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			if ($return_type == 0) {
				array_push ( $dict_visacategory, array (
						"id" => $row->id,
						"name" => $row->NAME
				) );
			} else {
				$dict_visacategory [$row->id] = $row->NAME;
			}
		}
		return $dict_visacategory;
	}
	function get_dict_visamultiplicity($db_name, $return_type = 0){
		$dict_visamultiplicity = array();
		$sql = "SELECT * FROM $db_name.dict_visamultiplicity";
			// echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			if ($return_type == 0) {
				array_push ( $dict_visamultiplicity, array (
						"id" => $row->id,
						"name" => $row->NAME
				) );
			} else {
				$dict_visamultiplicity [$row->id] = $row->NAME;
			}
		}
		return $dict_visamultiplicity;
	}
	function get_dict_visitpurpose($db_name, $return_type = 0){
		$dict_visitpurpose = array();
		$sql = "SELECT * FROM $db_name.dict_visitpurpose";
		//echo $sql;
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			if($return_type == 0){
				array_push ( $dict_visitpurpose, array (
					"id" => $row->id,
					"name" => $row->NAME
				) );
			}else{
				$dict_visitpurpose[$row->id] = $row->NAME;
			}
		}
		return $dict_visitpurpose;
	}

	function getDocCount($params = array()){
		$host = $this->config->item('temp_db_host');
		$user = $this->config->item('temp_user');
		$pass = $this->config->item('temp_password');
		@$link = mysql_connect ( $host, $user, $pass );
		if (! $link) {
			return 'Could not connect: ' . mysql_error ();
		}

		mysql_select_db ( 'global_project_fms', $link );

		mysql_query ( 'SET NAMES utf8' );
		$count = 0;
		if (isset($params['groupuid'])) {
		    $groupuid = $params['groupuid'];
		} else {
		    $groupuid = -1;
		}

		if (isset($params['test'])) {
		    $sql = "SELECT COUNT(1) as count FROM fms_records WHERE uploaded = 0 and hms_id=92 and state=1";
		} else {
		  $sql = "SELECT COUNT(1) as count FROM fms_records WHERE uploaded = 0 and state=1 and hms_id <>92";
		  $sql = "SELECT COUNT(1) as count FROM fms_records inner join hdimages
		      on hdimages.hms_id = fms_records.hms_id and hdimages.partner_id = fms_records.partner_id
		  WHERE uploaded = 0 and state=1 and fms_records.hms_id <>0 and hdimages.groupuid = " .$groupuid;
		  //$sql = "SELECT COUNT(1) as count FROM fms_records WHERE uploaded = 0 and hms_id=92 and state=1";
		}
		//echo $sql;
		$result = mysql_query ( $sql, $link );
		while ( $row = mysql_fetch_array ( $result ) ) {
			$count = $row ["count"];
		}

		mysql_close ( $link );
		$result_array = array();
		$result_array["count"] = $count;

		return $result_array;
	}

	function getDocument($params = array()){
		$host = $this->config->item('temp_db_host');
		$user = $this->config->item('temp_user');
		$pass = $this->config->item('temp_password');
		@$link = mysql_connect ( $host, $user, $pass );
		if (! $link) {
			return 'Could not connect: ' . mysql_error ();
		}

		mysql_select_db ( 'global_project_fms', $link );

		mysql_query ( 'SET NAMES utf8' );

		if (isset($params['groupuid'])) {
		    $groupuid = $params['groupuid'];
		} else {
		    $groupuid = -1;
		}

		$result_array = array();
		if (isset($params['test'])) {
		    $sql = "SELECT * FROM fms_records
		        WHERE uploaded = 0 and state=1 and hms_id=92 LIMIT 0,1";
		} else {

		    $sql = "SELECT fms_records.* FROM fms_records
		        inner join hdimages
		      on hdimages.hms_id = fms_records.hms_id and hdimages.partner_id = fms_records.partner_id
		        WHERE uploaded = 0 and state=1 and fms_records.hms_id <>0 and hdimages.groupuid = " .$groupuid;

		}

		//echo $sql . "<br>";

		$result = mysql_query ( $sql, $link );
		while ( $row = mysql_fetch_array ( $result ) ) {


		    $xsdtype = $row ["xsdtype"];
		    switch ($xsdtype) {
		        case 1:
		            $filename = "Form5-" . $row ["uid"] . "";
		            break;
		        case 2:
		            $filename = "MigCase-" . $row ["uid"] . "";
		            break;
		        case 3:
		            $filename = "unregmigcase-" . $row ["uid"] . "";
		            break;
		        default:
		            $filename = "undef-" . $row ["uid"] . "";
		            break;
		    }

			$result_array["id"] = $row ["id"];
			$result_array["uid"] = $row ["uid"];
			$result_array["filename"] = $filename . ".xml";
			$result_array["unsignedxml"] = $row ["unsignedxml"];
			$result_array["unsignedxml"] = $row ["signedxml"];
			$result_array["signedxml"] = $row ["signedxml"];


		}

		mysql_close ( $link );

		return $result_array;
	}
	function getDocumentBulk(){
		$host = $this->config->item('temp_db_host');
		$user = $this->config->item('temp_user');
		$pass = $this->config->item('temp_password');
		@$link = mysql_connect ( $host, $user, $pass );
		if (! $link) {
			return 'Could not connect: ' . mysql_error ();
		}

		mysql_select_db ( 'global_project_fms', $link );

		mysql_query ( 'SET NAMES utf8' );
		$result_array = array();
		$sql = "SELECT * FROM fms_records WHERE uploaded = 0  and state=1";
		$result = mysql_query ( $sql, $link );
		while ( $row = mysql_fetch_array ( $result ) ) {
			array_push ( $result_array, array (
			"id" => $row ["id"],
			"uid" => $row ["uid"],
			"filename" => "Form5-" . $row ["uid"] . ".xml",
			"unsignedxml" => $row ["unsignedxml"],
			"signedxml" => $row ["signedxml"]
			) );
		}

		mysql_close ( $link );

		return $result_array;
	}
	function delete_account($id) {
		$this->db->where('id', $id);
		$this->db->delete('fms_account');
	}

	function delete_user($id) {
		$this->db->where('id', $id);
		$this->db->delete('fms_users');
	}

	function update_account($data, $id) {

		$this->db->where('id', $id);
		$this->db->update('fms_account', $data);

	}

	function insert_account($data) {

		$this->db->insert('fms_account', $data);

	}

	function update_user($data, $id) {

		$this->db->where('id', $id);
		$this->db->update('fms_users', $data);

	}

	function insert_user($data) {

		$this->db->insert('fms_users', $data);

	}

	function set_state($str_data, $file_name = ""){

	    $result = array();

		//$xml_data = new SimpleXMLElement ( $str_data );

		$xml_data = new SimpleXMLElement ( $str_data, NULL, false, "http://umms.fms.gov.ru/hotel/hotel-response" );


		if (strtolower($xml_data->getName()) == "response" ) {
		    //echo "RESPONSE<br>";
		} else {
		    $result['response'] = -1;
		    $result['errormessage'] = "Response not found!";
		    return $result;
		}
		//echo "<pre>";
		//print_r($xml_data);

		//echo $str_data;
		//die();
		$answer = "";
		$success_data = array();

		$requestId = "";

		if(isset($xml_data->requestId)){
		    $requestId = $xml_data->requestId;
		} else {
		    if(isset($xml_data->error->xml->fileName)){
		        $rm = array();
		        preg_match("/-(\d+-\d+-\d+-\d+)/",$xml_data->error->xml->fileName,$rm);
		        $requestId = $rm[1] . "-2";
		    }

		}

		if($requestId != ""){
			$sql = "SELECT id, regcaseid, response_ummsid FROM fms_records WHERE request_id LIKE '".$requestId."' ORDER BY createtime DESC";
			//echo $sql;
			//echo "<br>" . $sql . "<br>";
			$query = $this->db->query($sql);



			if ($query->num_rows() > 0)
			{
				$row = $query->row();

				if(isset($xml_data->success)){
					$success_data["externalSystemId"] = $xml_data->success->externalSystemId;
					$success_data["externalCaseId"] = $xml_data->success->externalCaseId;
					$success_data["ummsId"] = $xml_data->success->ummsId;

					$sql2 = "INSERT INTO fms_records_response (requestId, filename, xml, successstate, datetime, externalSystemId, externalCaseId, ummsId)
					VALUES('".$requestId."', '".$file_name."', '".addslashes($str_data)."', '1', '".date("Y-m-d H:i:s")."', '".$success_data["externalSystemId"]."',
					'".$success_data["externalCaseId"]."', '".$success_data["ummsId"]."')";

					$query2 = $this->db->query($sql2);

					$sql2 = "UPDATE fms_records SET
					    error = '".addslashes($str_data)."',
					    issync=0, update_time=now(), state = 3, response_ummsid = '".$xml_data->success->ummsId."', response_state = 1 WHERE id = ".$row->id;
					$query2 = $this->db->query($sql2);

				    if ($row->regcaseid != '' && $xml_data->success->ummsId != '') {
					    $sql2 = "UPDATE fms_records SET
					    finished_by = '".$xml_data->success->ummsId."'
					        WHERE response_ummsid = '". $row->regcaseid ."'";
					    $query2 = $this->db->query($sql2);
					}

					//echo $sql2 . "<br>";

					$result['response'] = 1;
					$result['responsemessage'] = "Обработка успешно завершена 1.";
					return $result;

				}else{
				    $error = "";
				    if(isset($xml_data->error)){
				        $error = addslashes($xml_data->error->errorMsg);
				    }
				    $sql = "INSERT INTO fms_records_response (requestId, filename, xml, successstate, datetime)
					VALUES('".$requestId."', '".$file_name."', '".addslashes($str_data)."', '-3', '".date("Y-m-d H:i:s")."')";
				    $query = $this->db->query($sql);

				    $rummsid = "";
				    if (strpos($str_data,  "AbstractMigrationService.java:393")> 0) {
				        preg_match_all('/\): ((\d+)\-(\d+)) \(/',$str_data,$m);
				        $rummsid = $m[3][0];

				        $sql2 = "UPDATE fms_records SET
					    error = '".addslashes($str_data)."',
					    issync=0, update_time=now(), state = 3, test='restored', response_ummsid = '".$rummsid."', response_state = 1 WHERE id = ".$row->id;
				        $query2 = $this->db->query($sql2);

				        $result['response'] = 1;
				        $result['responsemessage'] = "Обработка успешно завершена 1(-3).";
				        return $result;
				    }

				    $sql2 = "UPDATE fms_records SET test='" . $rummsid . "', error = '".addslashes($error)."', issync=0, update_time=now(), state = -3, response_state = -1 WHERE id = ".$row->id;
				    $query2 = $this->db->query($sql2);



				    $result['response'] = -1;
				    $result['responsemessage'] = $requestId." ".$xml_data->error->errorMsg;
				    return $result;
				}

			}else{
				$sql = "INSERT INTO fms_records_response (requestId, filename, xml, successstate, datetime) VALUES('".$requestId."', '".$file_name."', '".addslashes($str_data)."', '-1', '".date("Y-m-d H:i:s")."')";
				//echo $sql;
				$query = $this->db->query($sql);
				$result['response'] = -1;
				$result['responsemessage'] = "Запрос не найден!";
				return $result;

			}
		}else{
				$sql = "INSERT INTO fms_records_response (filename, xml, successstate, datetime) VALUES('".$file_name."', '".addslashes($str_data)."', '-1', '".date("Y-m-d H:i:s")."')";
				//echo $sql;
				$query = $this->db->query($sql);

				$result['response'] = -1;
				$result['responsemessage'] = "Запрос не найден!";
				return $result;
		}

		$result['response'] = -1;
		$result['responsemessage'] = "undefined!";
		return $result;
	}

	function validation_doc($reservation_id, $guest_id) {

	    $xml_data = $this->get_xml_data($reservation_id, $guest_id);
	    //echo "<pre>";
	    //print_r($xml_data);
	    //die();

	    $validation_array = array();
	    $validation_array[1]["node_name"] = "root_uid";
	    $validation_array[1]["required"] = 1;
	    $validation_array[1]["node_min_str_size"] = 5;
	    $validation_array[1]["comment"] = "проверить root_uid";

	    $validation_array[2]["node_name"] = "hms_guest_gender";
	    $validation_array[2]["required"] = 1;
	    $validation_array[2]["node_min_str_size"] = 1;
	    $validation_array[2]["comment"] = "не установлен пол гостя";

	    $validation_array[3]["node_name"] = "hms_bithplace_countrycode";
	    $validation_array[3]["required"] = 1;
	    $validation_array[3]["node_min_str_size"] = 1;
	    $validation_array[3]["comment"] = "не установлен код страны места рождения";

	    $validation_array[4]["node_name"] = "hms_citizenship_countrycode";
	    $validation_array[4]["required"] = 1;
	    $validation_array[4]["node_min_str_size"] = 1;
	    $validation_array[4]["comment"] = "не установлен код страны места жительства";

// 	    $validation_array[5]["node_name"] = "hms_dul_series";
// 	    $validation_array[5]["required"] = 1;
// 	    $validation_array[5]["node_min_str_size"] = 4;
// 	    $validation_array[5]["node_max_str_size"] = 4;
// 	    $validation_array[5]["comment"] = "серия документа, ошибка формата";

	    foreach($validation_array as $key => $cell){
	        $failed = false;
	        $node_name = $cell["node_name"];
	        if(isset($xml_data[$node_name])){
	            if($cell["required"] == 1){
	                $validation_array[$key]['value'] = $xml_data[$node_name];
	                if(strlen($xml_data[$node_name]) < $cell["node_min_str_size"]){
	                    $failed = true;
	                }
	                if (isset($cell["node_max_str_size"])) {
	                    if (strlen($xml_data[$node_name]) > $cell["node_max_str_size"]) {
	                        $failed = true;
	                    }
	                }
	            }
	        }
	        if ($failed) {
	        } else {
	            unset ($validation_array[$key]);
	        }
	    }
	    $ispassed = 0;
	    $ispassed_str = "-";
	    $validation_errors = "";
	    if(sizeof($validation_array) == 0){
	        $ispassed = 1;
	        //$ispassed_str = "Проверено";
	    }else{
	        //print_r($validation_array);
	        $validation_errors = json_encode($validation_array, true);
	    }

	    $sql = "delete from fms_guests_deskofreservation where guest_id = " . $guest_id . " AND reservation_id = ".$reservation_id;
	    $query = $this->db->query($sql);
	    $sql = "INSERT INTO fms_guests_deskofreservation(guest_id, reservation_id, ispassed, errors) VALUES('".$guest_id."', '".$reservation_id."', '".$ispassed."', '".addslashes($validation_errors)."')";
	    $query = $this->db->query($sql);

	    return $validation_array;

	}

	function get_fms_active(){
		$fms = 0;
		$query = $this->db->query ( "SELECT name, is_active FROM modules WHERE name LIKE 'fms'" );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {

				$fms = $row->is_active;

			}
		}
		return $fms;
	}
	function statuscodetoname($status) {
		$status_name = "";
		switch ($status) {
			case - 1 :
				$status_name = "ошибка подписи";
				break;
			case 0 :
				    $status_name = "в обработке";
				    break;
			case 1 :
				$status_name = "в обработке";
				break;
			case 2 :
				$status_name = "в обработке";
				break;
			case 3 :
				$status_name = "сдан";
				break;
			case - 3 :
				$status_name = "ошибка";
				break;
			case 4 :
				$status_name = "в обработке";
				break;
            case 5:
                $status_name = "в обработке";
                break;
            case -5:
                $status_name = "ошибка";
                break;
            case 6 :
				$status_name = "в обработке";
				break;
			case - 6 :
				$status_name = "ошибка";
				break;
			case 7 :
				$status_name = "снят с регистрации";
				break;
			case - 7 :
				$status_name = "ошибка";
				break;
			default :
				$status_name = "неопределен";
				break;
		}
		if (is_null($status)) {
		    $status_name = "неопределен";
		}

		return $status_name;
	}
	function get_statuscodeto_icon_class($status) {
		$class_fms_state_icon = '';
		switch ($status) {
			case 0 :
				$class_fms_state_icon = 'fa fa-spinner fa-spin statusicon';
				break;
			case 1 :
				$class_fms_state_icon = 'ion ion-plus statusicon';
				break;
			case 2 :
				$class_fms_state_icon = 'ion ion-plus statusicon';
				break;
			case 3 :
				$class_fms_state_icon = 'ion ion-checkmark statusicon';
				break;
			case 4 :
				$class_fms_state_icon = 'fa fa-spinner fa-spin statusicon';
				break;
			case 5 :
				$class_fms_state_icon = 'ion ion-plus statusicon';
				break;
			case 6 :
				$class_fms_state_icon = 'ion ion-plus statusicon';
				break;
			case 7 :
				$class_fms_state_icon = 'ion ion-checkmark statusicon';
				break;
			case - 1 :
				$class_fms_state_icon = 'ion ion-minus statusicon';
				break;
			case - 3 :
				$class_fms_state_icon = 'ion ion-minus statusicon';
				break;
			case - 5 :
				$class_fms_state_icon = 'ion ion-minus statusicon';
				break;
			case - 7 :
				$class_fms_state_icon = 'ion ion-minus statusicon';
				break;
			default :
				$class_fms_state_icon = '';
				break;
		}
		if (is_null($status)) {
		    $class_fms_state_icon = '';
		}

		return $class_fms_state_icon;
	}
	function get_registration_url($status) {
		$registration_url = '';
		switch ($status) {
			case 0 :
				$registration_url = '<a class="blue" href="/wizard_fms/step1/{reservation_id}/{id}/?landing_page=fms_map"><i class="fa fa-files-o statusicon"></i> {Зарегистрировать}</a>';
				break;
			case 1 :
				$registration_url = '';
				break;
			case 2 :
				$registration_url = '';
				break;
			case 3 :
				$registration_url = '<a class="blue" href="/wizard_fms/step1/{reservation_id}/{id}/?landing_page=fms_map"><i class="fa fa-files-o statusicon"></i> {{caption_fms_unregister}}</a>';
				break;
			case 4 :
				$registration_url = '';
				break;
			case 5 :
				$registration_url = '';
				break;
			case 6 :
				$registration_url = '';
				break;
			case 7 :
				$registration_url = '';
				break;
			case - 1 :
				$registration_url = '<a class="blue" href="/wizard_fms/step1/{reservation_id}/{id}/?landing_page=fms_map"><i class="fa fa-files-o statusicon"></i> {Зарегистрировать}</a>';
				break;
			case - 3 :
				$registration_url = '<a class="blue" href="/wizard_fms/step1/{reservation_id}/{id}/?landing_page=fms_map"><i class="fa fa-files-o statusicon"></i> {Зарегистрировать}</a>';
				break;
			case - 5 :
				$registration_url = '<a class="blue" href="/wizard_fms/step1/{reservation_id}/{id}/?landing_page=fms_map"><i class="fa fa-files-o statusicon"></i> {Зарегистрировать}</a>';
				break;
			case - 7 :
				$registration_url = '<a class="blue" href="/wizard_fms/step1/{reservation_id}/{id}/?landing_page=fms_map"><i class="fa fa-files-o statusicon"></i> {Зарегистрировать}</a>';
				break;
		}
		return $registration_url;
	}
	function get_fms_account($id_partner){
		$sql = "SELECT * FROM fms_account WHERE partner_id = ".$id_partner;
		//echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows() > 0)
		{
			$row = $query->row_array();
			return $row;
		}else{
			return 0;
		}
	}

	function get_fms_user($id = 0){
		$sql = "SELECT * FROM fms_users WHERE 1";
		//echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows() > 0)
		{
			$row = $query->row_array();
			return $row;
		}else{
			return 0;
		}
	}

	function get_fms_map($data, $landing_page_action_button_links = "fms_map"){

		$datefrom = date("Y-m-d");

		$select = "";
		$select .= " WHERE ";

		if(isset($data["date"])){
			if($data["date"] != ""){
				$datefrom = $data["date"];
				$select .= " (deskofreservation.datein <= '" . $data["date"] . "' AND";
				$select .= " deskofreservation.dateout >= '" . $data["date"] . "') AND";
			}
		}

		if(isset($data["reservation_id"])){
			if($data["reservation_id"] != ""){
				$select .= " deskofreservation.id = '" . $data["reservation_id"] . "' AND";
			}
		}

		if(isset($data["guest_id"])){
			if($data["guest_id"] != ""){
				$select .= " guests.id = '" . $data["guest_id"] . "' AND";
			}
		}

		$mvd_statuses_select_arr = $this->get_mvd_statuses_select_arr();
		if(isset($data["mvd_status"]) && $data["mvd_status"] != ""){
			$select .= " 1 ".$mvd_statuses_select_arr[$data["mvd_status"]]['sql_select_str'];
		}

		$citizenship_arr = $this->get_citizenship_select_arr();
		if(isset($data["citizenship"]) && $data["citizenship"] != ""){
				$select .= $citizenship_arr[$data["citizenship"]]['sql_select_str']." AND";
		}


		$select .= " deskofreservation.deleted=0 AND deskofreservation.cancel=0";
		$date = $datefrom;

		$page_first_line = 0;
		if (isset($data["page_first_line"])){
			$page_first_line = $data["page_first_line"];
		}
		$lines_per_page = 50;
		if (isset($data["lines_per_page"])){
			$lines_per_page = $data["lines_per_page"];
		}
		$limit_str = " LIMIT ".$page_first_line.", ".$lines_per_page;

		$prefix = $this->mlanguages->get_language_prefix();
		$status_table_name = "global_hotelix_languages.".$prefix."_statusofreservation";
		$session_state = "";
		$list_data = array();
		$sql = "SELECT SQL_CALC_FOUND_ROWS * FROM (
SELECT  deskofreservation.id as reservation_id, guests.id as guest_id, guests.firstname, guests.lastname,
guests.citizenship_code, fms_guests_deskofreservation.ispassed, fms_registration_order2guest.skip_registry,
fms_guests_deskofreservation.updatetime as validation_time,
fms_records.id as fms_id, fms_records.time, fms_records.isarchive,
fms_records.state as fms_state, ".$status_table_name.".name as status_name,
deskofreservation.datein, deskofreservation.dateout, deskofreservation.duration,
fms_records.response_state as fms_response_state, fms_records.error as fms_error, fms_records.fms_dateout
FROM deskofreservation
INNER JOIN guests ON guests.id = deskofreservation.guest_id
INNER JOIN reservation_details ON (reservation_details.guest_id = guests.id AND reservation_details.reservation_id = deskofreservation.id)

LEFT JOIN ".$status_table_name." ON deskofreservation.status=".$status_table_name.".id
LEFT JOIN fms_records ON fms_records.reservation_id	= deskofreservation.id AND fms_records.guest_id = guests.id AND 5=5
LEFT JOIN fms_registration_order2guest ON fms_registration_order2guest.order_id = deskofreservation.id AND fms_registration_order2guest.guest_id = guests.id
LEFT JOIN fms_guests_deskofreservation ON fms_guests_deskofreservation.reservation_id = deskofreservation.id
AND fms_guests_deskofreservation.guest_id = guests.id AND 5=5
" . $select . "

UNION

SELECT deskofreservation.id as reservation_id, guests.id as guest_id, guests.firstname,
guests.lastname, guests.citizenship_code, fms_guests_deskofreservation.ispassed,
fms_guests_deskofreservation.updatetime as validation_time,	fms_registration_order2guest.skip_registry,
fms_records.id as fms_id, fms_records.time, fms_records.isarchive,
fms_records.state as fms_state, ".$status_table_name.".name as status_name,
deskofreservation.datein, deskofreservation.dateout, deskofreservation.duration,
fms_records.response_state as fms_response_state, fms_records.error as fms_error, fms_records.fms_dateout
FROM guests
INNER JOIN guests_deskofreservation ON guests_deskofreservation.guest_id=guests.id
INNER JOIN deskofreservation ON deskofreservation.id=guests_deskofreservation.reservation_id
INNER JOIN reservation_details ON (reservation_details.guest_id = guests.id AND reservation_details.reservation_id = deskofreservation.id)
LEFT JOIN ".$status_table_name." ON deskofreservation.status=".$status_table_name.".id
LEFT JOIN rate ON deskofreservation.price_type = rate.id
LEFT JOIN fms_records ON fms_records.reservation_id	= deskofreservation.id AND fms_records.guest_id = guests.id
LEFT JOIN fms_registration_order2guest ON fms_registration_order2guest.order_id = deskofreservation.id AND fms_registration_order2guest.guest_id = guests.id
LEFT JOIN fms_guests_deskofreservation ON fms_guests_deskofreservation.reservation_id = deskofreservation.id AND fms_guests_deskofreservation.guest_id = guests.id
" . $select . ") as t ORDER BY t.reservation_id DESC ".$limit_str;
// 		echo $sql;
// 		die();

		$query2 = $this->db->query ( $sql );

		$query_p = $this->db->query ( "SELECT FOUND_ROWS() AS all_lines_count" )->row();
		$all_lines_count = $query_p->all_lines_count;

		$lines_per_current_page = $page_first_line+1;
		$reservations_arr = array();
		foreach ( $query2->result () as $row ) {
			if ($datefrom != "") {
				$today = $datefrom;
			} else {
				$today = date ( "Y-m-d" );
			}
			list ( $year, $month, $day ) = explode ( "-", $today );
			$todate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
			list ( $year_in, $month_in, $day_in ) = explode ( "-", $row->datein );
			$indate = round ( gmmktime ( 0, 0, 0, $month_in, $day_in, $year_in ) / 86400 );
			list ( $year_out, $month_out, $day_out ) = explode ( "-", $row->dateout );
			$outdate = round ( gmmktime ( 0, 0, 0, $month_out, $day_out, $year_out ) / 86400 );
			$state = "";
			if ($todate == $indate) {
				$state = "{mlw_datein2}";
				$state_int = 0;
			}
			if ($todate == $outdate) {
				$state = "{mlw_dateout2}";
				$state_int = 1;
			}
			if ($todate > $indate and $todate < $outdate) {
				$state = "{mlw_recidense}";
				$state_int = 2;
			}



			$inostranec_str = $row->citizenship_code.", ";
			//if (strcmp ( $row->citizenship_code, "RUS" ) == 0) {
			//	$inostranec_str = "ИГ, ";
			//}
			$registration_link = '';
			$registration_link_2 = '';
			$un_registration_link = '';
			$extend_registration_link = '';

			$registration_link_w = '';
			$un_registration_link_w = '';
			$extend_registration_link_w = '';

			$registration_link_fm = '';
			$un_registration_link_fm = '';
			$extend_registration_link_fm = '';
			switch ($row->fms_state) {
				case NULL :
					$registration_link = '<a class="btn btn-primary btn-label uppnone mw-85" target="_blank" href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1">{caption_fms_registration}</a>';
					$registration_link_2 = '<a class="btn btn-primary btn-label uppnone mw-85 reg_button" href="#" reservation_id="'.$row->reservation_id.'" guest_id="'.$row->guest_id.'">{caption_fms_registration}</a>';

					$registration_link_w = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1/'.$landing_page_action_button_links.'" class="btn-success btn mw-85">{caption_fms_registration}</a>';
					$registration_link_fm = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1/'.$landing_page_action_button_links.'" class="blue">{caption_fms_registration}</a>';
					break;
				case - 1 :
				case - 3 :
					$registration_link = '<a class="btn btn-primary btn-label uppnone mw-85" target="_blank" href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1">{caption_fms_registration}</a>';
					$registration_link_2 = '<a class="btn btn-primary btn-label uppnone mw-85 reg_button" href="#" reservation_id="'.$row->reservation_id.'" guest_id="'.$row->guest_id.'">{caption_fms_registration}</a>';

					$registration_link_w = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1/'.$landing_page_action_button_links.'" class="btn-success btn mw-85">{caption_fms_registration}</a>';
					$registration_link_fm = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1/'.$landing_page_action_button_links.'" class="blue">{caption_fms_registration}</a>';
					break;
				case - 10 :
					$registration_link = '<a class="btn btn-primary btn-label uppnone mw-85" target="_blank" href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1">{caption_fms_registration}</a>';
					$registration_link_2 = '<a class="btn btn-primary btn-label uppnone mw-85 reg_button" href="#" reservation_id="'.$row->reservation_id.'" guest_id="'.$row->guest_id.'">{caption_fms_registration}</a>';

					$registration_link_w = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1/'.$landing_page_action_button_links.'" class="btn-success btn mw-85">{caption_fms_registration}</a>';
					$registration_link_fm = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1/'.$landing_page_action_button_links.'" class="blue">{caption_fms_registration}</a>';
					break;
				case 3:
				case -4:
				case -5:
				case -6:
				case -7:
					if ($row->dateout == $date && strcmp($row->citizenship_code, "RUS") != 0) {
						$un_registration_link = '<a class="btn btn-primary btn-label uppnone mw-85" target="_blank" href="/fms/make_xml_v2/' . $row->reservation_id . '/' . $row->guest_id . '/2/0/1">{caption_fms_unregister}</a>';

						$un_registration_link_w = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/2/0/1/'.$landing_page_action_button_links.'" class="btn-success btn mw-85">{caption_fms_unregister}</a>';
						$un_registration_link_fm = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/2/0/1/'.$landing_page_action_button_links.'" class="blue">{caption_fms_unregister}</a>';
						if ($row->fms_dateout != $row->dateout) {
							$extend_registration_link = '<a class="btn btn-primary btn-label uppnone mw-85" target="_blank" href="/fms/make_xml_v2/' . $row->reservation_id . '/' . $row->guest_id . '/1/0/1">{caption_fms_renew_registration}</a>';
							$extend_registration_link_w = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1/'.$landing_page_action_button_links.'" class="btn-success btn mw-85">{caption_fms_renew_registration}</a>';
							$extend_registration_link_fm = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1/'.$landing_page_action_button_links.'" class="blue">{caption_fms_renew_registration}</a>';
						}
					}

					break;
				case -5:
					if ($row->dateout == $date && strcmp($row->citizenship_code, "RUS") != 0) {
						$un_registration_link = '<a class="btn btn-primary btn-label uppnone mw-85" target="_blank" href="/fms/make_xml_v2/' . $row->reservation_id . '/' . $row->guest_id . '/2/0/1">{caption_fms_unregister}</a>';

						$un_registration_link_w = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/2/0/1/'.$landing_page_action_button_links.'" class="btn-success btn mw-85">{caption_fms_unregister}</a>';
						$un_registration_link_fm = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/2/0/1/'.$landing_page_action_button_links.'" class="blue">{caption_fms_unregister}</a>';
						if ($row->fms_dateout != $row->dateout) {
							$extend_registration_link = '<a class="btn btn-primary btn-label uppnone mw-85" target="_blank" href="/fms/make_xml_v2/' . $row->reservation_id . '/' . $row->guest_id . '/1/0/1">{caption_fms_renew_registration}</a>';

							$extend_registration_link_w = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1/'.$landing_page_action_button_links.'" class="btn-success btn mw-85">{caption_fms_renew_registration}</a>';
							$extend_registration_link_fm = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1/'.$landing_page_action_button_links.'" class="blue">{caption_fms_renew_registration}</a>';
						}
					}

					break;
			}

			$registration_link = '';

			$fms_outdate = 0;
			if($row->fms_dateout <> ""){
				list ( $fms_year_out, $fms_month_out, $fms_day_out ) = explode ( "-", $row->fms_dateout );
				$fms_outdate = round ( gmmktime ( 0, 0, 0, $fms_month_out, $fms_day_out, $fms_year_out ) / 86400 );

			}

			if ($fms_outdate < $outdate && $fms_outdate != 0) {
				$repeated_registration = "(<b alt=\"требуется продление регистрации\">?</b>)";
				$registration_link_2 = '<a class="reg_button" href="#" reservation_id="'.$row->reservation_id.'" guest_id="'.$row->guest_id.'">{caption_fms_registration}</a>';

				$registration_link_w = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1/fms_map" class="btn-success btn mw-85">{caption_fms_registration}</a>';
				$registration_link_fm = '<a href="/fms/make_xml_v2/'.$row->reservation_id.'/'.$row->guest_id.'/1/0/1/fms_map" class="blue">{caption_fms_registration}</a>';
			} else {
				$repeated_registration = "";
			}



			$insert_inarray_value = 0;
			if ($session_state != "") {
				if ($session_state == $state_int) {
					$insert_inarray_value = 1;
				}
			} else {
				$insert_inarray_value = 1;
			}

			$gist = "";
			if($indate <= $todate && $row->skip_registry != 0){
				$gist = "Поставить на регистрацию";
			}

			if($indate <= $todate && $row->skip_registry != 0 && $row->fms_state < 0){
				$gist = "Поставить на регистрацию";
			}

			if($row->citizenship_code != "RUS" && $row->skip_registry != 0 && $row->fms_state == 3 && $fms_outdate <= $todate){
				$gist = "Снять с регистрации";
			}

			if($row->citizenship_code == "RUS" && $row->skip_registry != 0 && $row->fms_state == 3 && $fms_outdate <= $todate && $outdate > $fms_outdate){
				$gist = "Продлить регистрацию";
			}

			if($row->citizenship_code != "RUS" && $row->skip_registry != 0 && $row->fms_state == 7 && $fms_outdate <= $todate && $outdate > $fms_outdate){
				$gist = "Продлить регистрацию";
			}

			if($row->fms_state == 0 || $row->fms_state == 1 || $row->fms_state == 2 || $row->fms_state == 4 || $row->fms_state == 5 || $row->fms_state == 6){
				$gist = "В процессе";
			}

			if($row->citizenship_code == "RUS" && $row->fms_state == 3 && $fms_outdate == $outdate){
				$gist = "Завершен";
			}

			if($row->citizenship_code == "RUS" && $row->fms_state == 7 && $fms_outdate == $outdate){
				$gist = "Завершен";
			}

			if($insert_inarray_value == 1){
				$list_data[$row->reservation_id][$row->guest_id]["b"] = $lines_per_current_page;
				$list_data[$row->reservation_id][$row->guest_id]["reservation_id"] = $row->reservation_id;
				$list_data[$row->reservation_id][$row->guest_id]["guest_id"] = $row->guest_id;
				$list_data[$row->reservation_id][$row->guest_id]["firstname"] = $row->firstname;
				$list_data[$row->reservation_id][$row->guest_id]["lastname"] = $row->lastname;
				$list_data[$row->reservation_id][$row->guest_id]["citizenship"] = $row->citizenship_code;
				$list_data[$row->reservation_id][$row->guest_id]["status_name"] = $row->status_name;
				$list_data[$row->reservation_id][$row->guest_id]["datein"] = $row->datein;
				$list_data[$row->reservation_id][$row->guest_id]["dateout"] = $row->dateout;
				$list_data[$row->reservation_id][$row->guest_id]["class_fms_state_icon"] = $this->fms_core->get_statuscodeto_icon_class($row->fms_state);

				$list_data[$row->reservation_id][$row->guest_id]["fms_state_name"] = $this->fms_core->statuscodetoname($row->fms_state);
				$list_data[$row->reservation_id][$row->guest_id]["registration_url"] = $this->fms_core->get_registration_url($row->fms_state);
				$list_data[$row->reservation_id][$row->guest_id]["fms_state"] = $row->fms_state;
				$list_data[$row->reservation_id][$row->guest_id]["fms_dateout"] = $row->fms_dateout;
				$list_data[$row->reservation_id][$row->guest_id]["repeated_registration"] = $repeated_registration;
				$list_data[$row->reservation_id][$row->guest_id]["registration_link"] = $registration_link;
				$list_data[$row->reservation_id][$row->guest_id]["registration_link_2"] = $registration_link_2;
				$list_data[$row->reservation_id][$row->guest_id]["un_registration_link"] = $un_registration_link;
				$list_data[$row->reservation_id][$row->guest_id]["extend_registration_link"] = $extend_registration_link;

				$list_data[$row->reservation_id][$row->guest_id]["registration_link_w"] = $registration_link_w;
				$list_data[$row->reservation_id][$row->guest_id]["un_registration_link_w"] = $un_registration_link_w;
				$list_data[$row->reservation_id][$row->guest_id]["extend_registration_link_w"] = $extend_registration_link_w;

				$list_data[$row->reservation_id][$row->guest_id]["registration_link_fm"] = $registration_link_fm;
				$list_data[$row->reservation_id][$row->guest_id]["un_registration_link_fm"] = $un_registration_link_fm;
				$list_data[$row->reservation_id][$row->guest_id]["extend_registration_link_fm"] = $extend_registration_link_fm;
				$list_data[$row->reservation_id][$row->guest_id]["gist"] = $gist;

				$lines_per_current_page ++;
			}
		}
		$result = array();
		$result['all_lines_count'] = $all_lines_count;
		$result['list_data'] = $list_data;

		return $result;
	}
	function get_mvd_statuses_select_arr() {
		$in_progress_time_delay = 72;// при зміні терміну, поміняти його теж у function get_fms_parsing_status_data_arr($data)
		$rez = array (
				'0' => array (
						'name' => "{mlw_all}",
						'sql_select_str' => ""
				),
				'1' => array (
						'name' => "{clt_need_action}",
						'sql_select_str' => " AND (((fms_records.state IS NULL) AND (datein <= CURDATE()) AND (ISNULL(skip_registry) OR skip_registry <> 1))
											OR (fms_records.state IN (3, 7) AND (fms_dateout <= CURDATE() OR dateout <= CURDATE())
												AND ((citizenship_code = 'RUS' AND fms_dateout < dateout)
													OR (citizenship_code <> 'RUS' AND (fms_records.state = 3
														OR (fms_records.state = 7 AND (fms_dateout < dateout OR opencases))))))
											OR fms_records.state IN (-1, -2, -3, -4, -5, -6, -7)
											OR (fms_records.state IN (2, 6) AND (CURRENT_TIMESTAMP > DATE_ADD( time, INTERVAL $in_progress_time_delay HOUR ))))"
				),
				'2' => array (
						'name' => "{clt_in_progress}",
						'sql_select_str' => " AND fms_records.state IN (0, 1, 2, 4, 5, 6)"
				),
				'3' => array (
						'name' => "{clt_finished}",
						'sql_select_str' => " AND ((citizenship_code = 'RUS' AND fms_records.state = 3 AND fms_dateout >= dateout)
											OR (citizenship_code <> 'RUS' AND fms_records.state = 7 AND fms_dateout >= dateout AND !opencases))"
				),
		);
		return $rez;
	}
	function get_fms_esp_statuses_select_arr() {
		$rez = array (
				'0' => array (
						'name' => "{mlw_all}",
						'sql_select_str' => ""
				),
				'1' => array (
						'name' => "{caption_error}",
						'sql_select_str' => " AND fms_records_esp.state IN (-1, -2)"
				),
				'2' => array (
						'name' => "{caption_need_submit}",
						'sql_select_str' => " AND ISNULL(fms_records_esp.state)"
				),
				'3' => array (
						'name' => "{caption_submited}",
						'sql_select_str' => " AND fms_records_esp.state IN (2)"
				),
				'4' => array (
						'name' => "{caption_in_progress}",
						'sql_select_str' => " AND fms_records_esp.state IN (0, 1)"
				),
		);
		return $rez;
	}
	function get_fms_parsing_status_data_arr($data) {
		$reservation_id = $data['reservation_id'];
		$guest_id = $data['guest_id'];
		$guest_status_code = ($data['status_code'] != '') ? $data['status_code'] : NULL;
		$citizenship_code = $data['citizenship_code'];
		$skip_registry = $data['skip_registry'];
		$datein = $data['datein'];
		$dateout = $data['dateout'];
		$fms_dateout = $data['fms_dateout'];
		$fms_createtime = $data['fms_createtime'];
		$opencases = $data['opencases'];
		$today = date('Y-m-d');
		$need_reprocessing = 0;
		$in_progress_time_delay = 72;//if 3 days delay, при зміні терміну, поміняти його теж у get_mvd_statuses_select_arr()
		if ($fms_createtime != ""){
			$in_progress_time = round(abs((strtotime("now") - strtotime($fms_createtime)))/3600);
// 			$in_progress_time = time()." - ".strtotime($fms_createtime);

			if ($in_progress_time > $in_progress_time_delay){
				$need_reprocessing = 1;
			}
		}
		$rez_arr = array();
		$rez_arr['fms_state'] = "";
		$rez_arr['fms_state_name'] = "";
		$rez_arr['fms_status_ico_class'] = "";
		$rez_arr['fms_status_ico_tooltip'] = "";
		$rez_arr['fms_gist_clt'] = "";
		$rez_arr['fms_need_datails_class'] = "";
		$rez_arr['fms_datails_url'] = "/fms_c2/history/0/$reservation_id/$guest_id";
		$rez_arr['fms_datails_tooltip'] = "{clt_additional_info}";
		$rez_arr['fms_datails_blank'] = 'target="_blank"';
		$rez_arr['fms_need_wizard'] = "d0";
		$rez_arr['fms_wizard_url'] = "/wizard_fms/step1/$reservation_id/$guest_id";
		$rez_arr['fms_wizard_tooltip'] = "{clt_fms_wizard}";
		$rez_arr['fms_wizard_blank'] = "";//target="_blank"
		$rez_arr['fms_action_btn_url'] = "";
		$rez_arr['fms_action_btn_clt'] = "";
		$rez_arr['fms_action_btn_tooltip'] = "";
		$rez_arr['fms_dateout'] = $fms_dateout;
		if($skip_registry == 1){
			$rez_arr['fms_state_name'] = "{clt_not_need_registration}";
			$rez_arr['fms_gist_clt'] = "{clt_not_need_registration}";
			$rez_arr['fms_need_datails_class'] = "d0";
			$rez_arr['fms_need_wizard'] = "";
		}else{
			if ($today >= $datein){
			switch ($guest_status_code) {
				case NULL ://NUUL mast! be first in switch!!статус гостя з яким ще нічого не робили бо нема запису у 'fms_records'
					$rez_arr['fms_state_name'] = "{caption_need_submit}";
					$rez_arr['fms_status_ico_class'] = "ion ion-help statusicon";
					$rez_arr['fms_gist_clt'] = "{clt_need_reregister}";
					$rez_arr['fms_need_datails_class'] = "d0";
					$rez_arr['fms_need_wizard'] = "";
					$rez_arr['fms_action_btn_url'] = "/fms/make_xml_v2/$reservation_id/$guest_id/1/0/1/";
					$rez_arr['fms_action_btn_clt'] = "{clt_register}";
					$rez_arr['fms_action_btn_tooltip'] = "{clt_send_to_register}";
					break;
				case -1 :
				case -2 :
				case -3 :
					$rez_arr['fms_state'] = " ($guest_status_code)";
					$rez_arr['fms_state_name'] = "{caption_error}";
					$rez_arr['fms_status_ico_class'] = "ion ion-minus statusicon";
					$rez_arr['fms_gist_clt'] = "{clt_error}";
					$rez_arr['fms_need_wizard'] = "";
					$rez_arr['fms_action_btn_url'] = "/fms/make_xml_v2/$reservation_id/$guest_id/1/0/1/";
					$rez_arr['fms_action_btn_clt'] = "{clt_register}";
					$rez_arr['fms_action_btn_tooltip'] = "{clt_send_to_register}";
					break;
				case -4 :
				case -5 :
				case -6 :
				case -7 :
					$rez_arr['fms_state'] = " ($guest_status_code)";
					$rez_arr['fms_state_name'] = "{caption_error}";
					$rez_arr['fms_status_ico_class'] = "ion ion-minus statusicon";
					$rez_arr['fms_gist_clt'] = "{clt_error}";
					$rez_arr['fms_need_wizard'] = "";
					$rez_arr['fms_action_btn_url'] = "/fms/make_xml_v2/$reservation_id/$guest_id/2/0/1/";
					$rez_arr['fms_action_btn_clt'] = "{clt_unregister}";
					$rez_arr['fms_action_btn_tooltip'] = "{clt_send_to_unregister}";
					break;
				case 0 :
				case 1 :
				case 4 :
				case 5 :
					$rez_arr['fms_state'] = " ($guest_status_code)";
					$rez_arr['fms_state_name'] = "{caption_in_progress}";
					$rez_arr['fms_status_ico_class'] = "fa fa-spinner fa-spin statusicon";
					$rez_arr['fms_gist_clt'] = "{clt_in_progress}";
					break;
				case 2 :
					$rez_arr['fms_state'] = " ($guest_status_code)";
					$rez_arr['fms_state_name'] = "{caption_in_progress}";
					$rez_arr['fms_status_ico_class'] = "fa fa-spinner fa-spin statusicon";
					$rez_arr['fms_gist_clt'] = "{clt_in_progress}";
					$rez_arr['fms_status_ico_tooltip'] = "{clt_is_processing_hours}: $in_progress_time";
					if ($need_reprocessing){
						$rez_arr['fms_need_wizard'] = "";
						$rez_arr['fms_action_btn_url'] = "/fms/make_xml_v2/$reservation_id/$guest_id/1/101/1/";
						$rez_arr['fms_action_btn_clt'] = "{clt_register}";
						$rez_arr['fms_action_btn_tooltip'] = "{clt_send_to_register}";
					}
					break;
				case 6 :
					$rez_arr['fms_state'] = " ($guest_status_code)";
					$rez_arr['fms_state_name'] = "{caption_in_progress}";
					$rez_arr['fms_status_ico_class'] = "fa fa-spinner fa-spin statusicon";
					$rez_arr['fms_gist_clt'] = "{clt_in_progress}";
					$rez_arr['fms_status_ico_tooltip'] = "{clt_is_processing_hours}:  $in_progress_time";
					if ($need_reprocessing){
						$rez_arr['fms_need_wizard'] = "";
						$rez_arr['fms_action_btn_url'] = "/fms/make_xml_v2/$reservation_id/$guest_id/2/102/1/";
						$rez_arr['fms_action_btn_clt'] = "{clt_unregister}";
						$rez_arr['fms_action_btn_tooltip'] = "{clt_send_to_unregister}";
					}
					break;
				case 3 :
					$rez_arr['fms_state'] = " ($guest_status_code)";
					$rez_arr['fms_state_name'] = "{caption_success}";
					$rez_arr['fms_status_ico_class'] = "ion ion-checkmark statusicon";
					$rez_arr['fms_gist_clt'] = "{clt_successfully_registered}";
					if ($dateout <= $fms_dateout){
						if ($fms_dateout <= $today || $dateout <= $today){
							if ($citizenship_code == "RUS"){
								$rez_arr['fms_gist_clt'] = "{clt_complited}";
							}else{//not rus
								$rez_arr['fms_gist_clt'] = "{clt_need_unregister}";
								$rez_arr['fms_need_wizard'] = "";
								$rez_arr['fms_action_btn_url'] = "/fms/make_xml_v2/$reservation_id/$guest_id/2/0/1/";
								$rez_arr['fms_action_btn_clt'] = "{clt_unregister}";
								$rez_arr['fms_action_btn_tooltip'] = "{clt_send_to_unregister}";
							}
						}
					}else{//$dateout > $fms_dateout so prolongation is needed
						$rez_arr['fms_gist_clt'] = "{clt_need_reregister}";
						$rez_arr['fms_need_wizard'] = "";
						$rez_arr['fms_action_btn_url'] = "/fms/make_xml_v2/$reservation_id/$guest_id/1/0/1/";
						$rez_arr['fms_action_btn_clt'] = "{clt_register}";
						$rez_arr['fms_action_btn_tooltip'] = "{clt_send_to_register}";
					}
					break;
				case 7 :
					$rez_arr['fms_state'] = " ($guest_status_code)";
					$rez_arr['fms_state_name'] = "{caption_success}";
					$rez_arr['fms_status_ico_class'] = "ion ion-checkmark statusicon";
					$rez_arr['fms_gist_clt'] = "{clt_successfully_unregistered}";
					if ($opencases){
						$rez_arr['fms_gist_clt'] = "{clt_need_unreregister}";//($opencases) cases is opened";
						$rez_arr['fms_need_wizard'] = "";
						$rez_arr['fms_action_btn_url'] = "/fms/make_xml_v2/$reservation_id/$guest_id/2/0/1/";
						$rez_arr['fms_action_btn_clt'] = "{clt_unregister}";
						$rez_arr['fms_action_btn_tooltip'] = "{clt_send_to_unregister}";
					}
					if ($dateout > $fms_dateout){
						$rez_arr['fms_gist_clt'] = "{clt_need_reregister}";//prolongation is needed
						$rez_arr['fms_need_wizard'] = "";
						$rez_arr['fms_action_btn_url'] = "/fms/make_xml_v2/$reservation_id/$guest_id/1/0/1/";
						$rez_arr['fms_action_btn_clt'] = "{clt_send_to_register}";
						$rez_arr['fms_action_btn_tooltip'] = "{clt_register}";
					}
					break;
			}
			}else{
				$rez_arr['fms_need_datails_class'] = "d0";
				$rez_arr['fms_need_wizard'] = "d0";
			}
		}
		//$rez_arr['fms_gist_clt'] .= $opencases . "*";
		return $rez_arr;
	}
	function get_fms_esp_parsing_status_data_arr($reservation_id, $guest_id) {
		$query_fms = $this->db->select ( 'id as fms_record_id, state, send_time as reg_time' )->get_where ( 'fms_records_esp', array (
				'reservation_id' => $reservation_id,
				'guest_id' => $guest_id
		) );
		if($query_fms->num_rows()>0){
				$guest_status_code = $query_fms->row()->state;
		}else {
			$guest_status_code = NULL;//статус гостя з яким ще нічого не робили бо нема запису у 'fms_records_esp'
		}
		$rez_arr = array();
		switch ($guest_status_code) {
			case NULL ://NUUL mast! be first in switch!!
				$rez_arr['fms_state_name'] = "{caption_need_submit}";
				$rez_arr['target_datails_url'] = "#";
				$rez_arr['target_action_url'] = "/wizard_fms_tools/esp_step1/$reservation_id/$guest_id";
				$rez_arr['target_blank'] = "";
				$rez_arr['caption_fms_litle_tooltip'] = "{caption_fms_esp_registration}";
				$rez_arr['status_ico_slass'] = "ion ion-help statusicon";
				$rez_arr['status_error_class'] = "d0";
				$rez_arr['status_need_submit_class'] = "";
				$rez_arr['status_submited_class'] = "d0";
				$rez_arr['status_in_progress'] = "d0";
				$rez_arr['submit_time'] = "";
				break;
			case -1 :
			case -2 :
			    $rez_arr['fms_state_name'] = "{caption_error}";
			    $rez_arr['target_datails_url'] = "/fms_c2/history_esp/".$query_fms->row()->fms_record_id;
			    $rez_arr['target_action_url'] = "/wizard_fms_tools/esp_step1/$reservation_id/$guest_id";
			    $rez_arr['target_blank'] = 'target="_blank"';
			    $rez_arr['caption_fms_litle_tooltip'] = "{caption_fms_esp_registration}";
			    $rez_arr['status_ico_slass'] = "ion ion-minus statusicon";
			    $rez_arr['status_error_class'] = "";
			    $rez_arr['status_need_submit_class'] = "d0";
			    $rez_arr['status_submited_class'] = "d0";
			    $rez_arr['status_in_progress'] = "d0";
			    $rez_arr['submit_time'] = "";
			    break;
			case 0 :
			case 1 :
				$rez_arr['fms_state_name'] = "{caption_in_progress}";
				$rez_arr['target_datails_url'] = "/fms_c2/history_esp/".$query_fms->row()->fms_record_id;
				$rez_arr['target_action_url'] = "#";
				$rez_arr['target_blank'] = "";
				$rez_arr['caption_fms_litle_tooltip'] = "{caption_fms_esp_registration}";
				$rez_arr['status_ico_slass'] = "fa fa-spinner fa-spin statusicon";
				$rez_arr['status_error_class'] = "d0";
				$rez_arr['status_need_submit_class'] = "d0";
				$rez_arr['status_submited_class'] = "d0";
				$rez_arr['status_in_progress'] = "";
				$rez_arr['submit_time'] = "";
				break;
			case 2 :
				$rez_arr['fms_state_name'] = "{caption_submited}";
				$rez_arr['target_datails_url'] = "/fms_c2/history_esp/".$query_fms->row()->fms_record_id;
				$rez_arr['target_action_url'] = "#";
				$rez_arr['target_blank'] = "";
				$rez_arr['caption_fms_litle_tooltip'] = "{caption_fms_esp_registration}";
				$rez_arr['status_ico_slass'] = "ion ion-checkmark statusicon";
				$rez_arr['status_error_class'] = "d0";
				$rez_arr['status_need_submit_class'] = "d0";
				$rez_arr['status_submited_class'] = "";
				$rez_arr['status_in_progress'] = "d0";
				$rez_arr['submit_time'] = $query_fms->row()->reg_time;
				break;
			default :
				$rez_arr['fms_state_name'] = "{caption_not_defined}";
				$rez_arr['target_datails_url'] = "/fms_c2/history_esp/".$query_fms->row()->fms_record_id;
				$rez_arr['target_action_url'] = "#";
				$rez_arr['target_blank'] = "";
				$rez_arr['caption_fms_litle_tooltip'] = "{caption_fms_esp_registration}";
				$rez_arr['status_ico_slass'] = "{caption_need_submit}";
				$rez_arr['status_error_class'] = "d0";
				$rez_arr['status_need_submit_class'] = "";
				$rez_arr['status_submited_class'] = "d0";
				$rez_arr['status_in_progress'] = "d0";
				$rez_arr['submit_time'] = "";
				break;
		}

		return $rez_arr;
	}
	function get_citizenship_select_arr() {
		$rez = array (
				'0' => array (
						'name' => "{mlw_all}",//Все
						'sql_select_str' => ""
				),
				'1' => array (
						'name' => "{clt_rus_citizen}",//Гражданин РФ
						'sql_select_str' => " AND guests.citizenship_code = 'RUS'"
				),
				'2' => array (
						'name' => "{clt_foreigner}",//Инностранец
						'sql_select_str' => " AND guests.citizenship_code != 'RUS' AND guests.citizenship_code != ''"
				),
				'3' => array (
						'name' => "{clt_no_citizenship}",//нет гражданства
						'sql_select_str' => " AND guests.citizenship_code = ''"
				),
		);
		return $rez;
	}
	function get_fms_esp_citizenship_select_arr() {
		$rez = array (
				'0' => array (
						'name' => "{mlw_all}",
						'sql_select_str' => ""
				),
				'1' => array (
						'name' => "{caption_spaniard}",
						'sql_select_str' => " AND citizenship_code = 'ESP'"
				),
				'2' => array (
						'name' => "{caption_foreigner}",
						'sql_select_str' => " AND citizenship_code != 'ESP'"
				),
		);
		return $rez;
	}
	function get_dict_documenttype_by_country($citizenship = "", $residency = 1){//$residency 0 загальна, 1 свій, 2 іноземець
		$dict_documenttype = array();
		if ($citizenship != "") {
			$db_name = "global_fms_base.dict_documenttype_".$citizenship;
			$sql = "SELECT * FROM $db_name WHERE residency = 0 OR residency = $residency";
			$query = $this->db->query ( $sql );
			foreach ( $query->result () as $row ) {
				$dict_documenttype [$row->id] = array (
						"id" => $row->id,
						"name" => $row->name,
						"fms_symbol" => $row->fms_symbol
				);
			}
		}
		return $dict_documenttype;
	}
	function fms_tools_registration_command_esp($reservation_id, $guest_id){

		$legalsystem_contry = "ESP";
		$guest_data = $this->frontdesk->GetGuest ( $guest_id );
		if ($guest_data['citizenship_code'] == $legalsystem_contry){$residency = 1;}else{$residency = 2;}//1 свій, 2 іноземець
		$dict_documenttype_arr = $this->fms_core->get_dict_documenttype_by_country ( $legalsystem_contry, $residency );

		$sql = "SELECT property_information.id as property_id
				FROM property_information
				JOIN categories ON categories.property_id = property_information.id
				JOIN rooms ON rooms.category_id = categories.id
				JOIN deskofreservation ON deskofreservation.room_id = rooms.id
				WHERE deskofreservation.id=".$reservation_id;
		$query = $this->db->query ( $sql );
		$property_id = $query->row()->property_id;

		$register_guest_str = "";
		$register_guest_str .= ($residency == 1) ? $guest_data['passportid'].$guest_data['doc_precode']."||" :
													"|".$guest_data['passportid'].$guest_data['doc_precode']."|";
		$register_guest_str .= $dict_documenttype_arr[$guest_data['doc_type']]['fms_symbol']."|";
		$register_guest_str .= str_replace("-", "", $guest_data['doc_date_open'])."|";
		$register_guest_str .= $guest_data['lastname']."|";
		$register_guest_str .= ($residency == 1) ? $guest_data['middlename']."|" : "|";
		$register_guest_str .= $guest_data['firstname']."|";
		$register_guest_str .= ($guest_data['gender'] == 1) ? "M|" : "F|";
		$register_guest_str .= str_replace("-", "", $guest_data['dob'])."|";
		$register_guest_str .= $guest_data['citizenship_code']."|";
		$register_guest_str .= date('Ymd')."|";

		$register_guest_str = strtoupper($register_guest_str);

		$data_insert = array (
				'reservation_id' => $reservation_id,
				'property_id' => $property_id,
				'guest_id' => $guest_id,
				'reg_guest_str' => json_encode($register_guest_str, true),
				'state' => 0,
		);
		$unique_data_keys = array('reservation_id', 'guest_id');
		$this->frontdesk->db_insert_on_duplicate_key_update('`fms_records_esp`', $data_insert, $unique_data_keys);

		$hotel_id = $this->config->item('hotel_id');
		$sql = "SELECT hotel_id, start_time
				FROM global_project_fms.queue_esp
				WHERE hotel_id=".$hotel_id;
		$query = $this->db->query ( $sql );
		if (is_null($query->row()->hotel_id) || (int)$query->row()->start_time){
			$this->db->insert('global_project_fms.queue_esp', array('hotel_id' => $hotel_id));
		}
		return 1;//$register_guest_str;
	}
	function get_country_name_by_citizenshipcode_regarding_systemlang($citizenship_code = "") {
		$tbl_name = '`global_fms_base`.`dict_country`';
		$system_lang = $_SESSION['user']['language'];
		$column = "NAME_LAT";//за замовчуванням беремо англіканські назви країн
		switch ($system_lang) {
			case "rus" :
			case "ukr" :
				$column = "NAME";
				break;
			case "spa" :
				$column = "name_spa";
				break;
		}
		return $this->db->select($column)->get_where($tbl_name, array('id' => $citizenship_code))->row()->$column;
	}

	function get_registrations($hms_id, $reservation_id, $guest_id) {
	    $sql = "SELECT t1.id as id, t1.createtime, t1.hms_id, t1.reservation_id, t1.guest_id, t1.response_ummsid, t2.state
FROM global_project_fms.fms_records AS t1
LEFT JOIN global_project_fms.fms_records AS t2
ON (t1.hms_id = t2.hms_id AND t1.reservation_id = t2.reservation_id AND t1.guest_id = t2.guest_id)
AND (t1.response_ummsid = t2.regcaseid AND t1.response_ummsid !=  '')
WHERE (t1.hms_id =" . $hms_id . " AND t1.reservation_id =" . $reservation_id . " AND t1.guest_id =" . $guest_id . ")
AND (t1.xsdtype =2 AND t1.state =3)
AND (t2.state !=3 AND t2.state !=2 AND t2.state !=1 AND t2.state !=0 OR ISNULL( t2.state ))
ORDER BY  `t1`.`reservation_id` ASC
LIMIT 0 , 30";

	    $sql = "SELECT id as id, response_ummsid
FROM global_project_fms.fms_records
WHERE (hms_id =" . $hms_id . " AND reservation_id =" . $reservation_id . " AND guest_id =" . $guest_id . ")
AND xsdtype =2 AND state =3 AND finished_by = ''";


	    $query = $this->db->query($sql);
	    $response = array();
	    if ($query->num_rows()) {
	        foreach ($query->result() as $row) {
	            $response[$row->id]['id'] = $row->id;
	            $response[$row->id]['response_ummsid'] = $row->response_ummsid;
	        }
	    }
	    return $response;
	}

	function make_xml($reservation_id, $guest_id, $regtype = 1, $response_ummsid_2unreg_row_id = 0, $option = 0 )
{

	    $landing_page = "";
	    $debug =0;
	    //echo "+++";
	    //die();
	    $res_dout = "";
	    $res_din = "";
	    $fms_dout = "";
	    $fms_dout_int = 0;
	    $sql = "SELECT datein, dateout FROM deskofreservation WHERE id = ".$reservation_id;
	    $query = $this->db->query( $sql );
	    if ($query->num_rows() > 0) {
	        $row = $query->row();
	        $res_dout = $row->dateout;
	        $res_din = $row->datein;

	        list ($year, $month, $day) = explode("-", $res_dout);
	        $res_dout_int = round(gmmktime(0, 0, 0, $month, $day , $year) / 86400);
	    }
	    $query = $this->db->query("SELECT fms_dateout FROM fms_records  WHERE  reservation_id = " . $reservation_id . " AND guest_id = " . $guest_id . "");
	    if ($query->num_rows() > 0) {
	        $row = $query->row();
	        $fms_dout = $row->fms_dateout;
	        if ($fms_dout == '') {
	            $fms_dout = $res_din;
	        } else {
	        }
	        list ($year, $month, $day) = explode("-", $fms_dout);
	        $fms_dout_int = round(gmmktime(0, 0, 0, $month, $day , $year) / 86400);
	    } else {
	        $fms_dout = $res_din;
	        list ($year, $month, $day) = explode("-", $fms_dout);
	        $fms_dout_int = round(gmmktime(0, 0, 0, $month, $day , $year) / 86400);
	    }

	    $response_text = "";

	    switch ($regtype) {
	        case 1:
	            $query = $this->db->query("SELECT  state FROM fms_records  WHERE  reservation_id = " . $reservation_id . " AND guest_id = " . $guest_id . "");
	            if ($query->num_rows() > 0) {
	                //continue;
	                $row = $query->row();
	                if (($fms_dout_int < $res_dout_int && $fms_dout_int != 0) && ($row->state == 3 || $row->state == 7)) {
	                    continue;
	                }
	                if ($option > 100) {} else {
                        if ($row->state == 1 || $row->state == 0) {
                            $json = array();
                            $json["status"] = $row->state;
                            $response_text = "request is opened!";
                            $json["response"] = $response_text;
                            $json["time"] = date("Y-m-d H:i:s");
                            echo print_r(json_encode($json), true);
                            return;
                            die("request is opened!");
                        }
                        if ($row->state == 3 || $row->state == 0) {
                            $json = array();
                            $json["status"] = $row->state;
                            $response_text = "request is processed!";
                            $json["response"] = $response_text;
                            $json["time"] = date("Y-m-d H:i:s");
                            echo print_r(json_encode($json), true);
                            return;
                            die("request is processed!");
                        }
                        if ($row->state > 0) {
                            $json = array();
                            $json["status"] = $row->state;
                            $response_text = "request is processed (?)!";
                            $json["response"] = $response_text;
                            $json["time"] = date("Y-m-d H:i:s");
                            echo print_r(json_encode($json), true);
                            return;
                            die("request is processed (?)!");
                        }
                    }

	                if ($row->state == - 1) {
	                    //echo "remade!";
	                    $response_text = "remade!";
	                }

	                //die("request is opened 2!");
	            } else {
	                //echo "+++++++++++++++++++++++++++";
	                $sql = "INSERT INTO fms_records (reservation_id, guest_id, state)
	                    VALUES('" . $reservation_id . "', '" . $guest_id . "',  '0')";
	                //$this->db->query($sql);
	            }
	            break;
	        case 2:

	            $sql = "SELECT  state as state FROM fms_records  WHERE  reservation_id = " . $reservation_id . " AND guest_id = " . $guest_id . "";
	            $query = $this->db->query($sql);
	            //echo $sql . "\n";
	            if ($query->num_rows() > 0) {
	                $row = $query->row();
	                if ($option > 100) {

	                }else {
                        if ($row->state == 1 || $row->state == 0) {
                            die("request is opened!");
                        }
                        if ($row->state == 4 || $row->state == 4) {
                            die("unreg is opened!");
                        }
	                }
	                if ($row->state == 3) {
	                    echo " Make unreg";
	                    //die("request is processed!");
	                }
	                if ($row->state == - 1) {
	                    //echo "remade!";
	                    $response_text = "remade!";
	                }
	            } else {
	                echo "unknown!";
	                die();
	                $sql = "INSERT INTO fms_records (reservation_id, guest_id, state)
	                    VALUES('" . $reservation_id . "', '" . $guest_id . "',  '0')";
	                //$this->db->query($sql);
	            }
	            break;
	        case - 10:
	            $sql = "INSERT INTO fms_records (reservation_id, guest_id, state)
	                    VALUES('" . $reservation_id . "', '" . $guest_id . "',  '-10') ON DUPLICATE KEY UPDATE state = -10";
	            // echo $sql;
	            $this->db->query($sql);
	            die();
	            break;
	        case - 11:
	            if ($debug != 0) {
	                $sql = "INSERT INTO fms_records (reservation_id, guest_id, state)
	                    VALUES('" . $reservation_id . "', '" . $guest_id . "',  $debug) ON DUPLICATE KEY UPDATE state = $debug";
	                echo $sql;
	                $this->db->query($sql);
	                echo $debug;
	                die();
	            } else {
	                echo "unknown";
	                die();
	            }
	            break;

	        default:
	            die("unknown way!");
	            break;
	    }

	    $config = array();
	    $config['hostname'] = $this->config->item('fms_project_host');
	    $config['username'] = $this->config->item('fms_project_user');
	    $config['password'] = $this->config->item('fms_project_pswd');

	    // $config ['hostname'] = $this->config->item ( 'temp_db_host' );
	    // $config ['username'] = $this->config->item ( 'temp_user' );
	    // $config ['password'] = $this->config->item ( 'temp_password' );

	    $config['database'] = "global_project_fms";
	    $config['dbdriver'] = "mysqli";
	    $config['dbprefix'] = "";
	    $config['pconnect'] = FALSE;
	    $config['db_debug'] = TRUE;
	    $config['cache_on'] = FALSE;
	    $config['cachedir'] = "";
	    $config['char_set'] = "utf8";
	    $config['dbcollat'] = "utf8_general_ci";
	    $db_fms = $this->load->database($config, TRUE);



	    $data = $this->fms_core->get_xml_data($reservation_id, $guest_id);

// 	    if (($fms_dout_int < $res_dout_int && $fms_dout_int != 0) && ($row->state == 3 || $row->state == 7)) {
// 	        $data['hms_datein'] = $fms_dout;
// 	    }

	    $data['hms_datein'] = $fms_dout;

	    $special = array();

	    $special['migcase_middlename'] = 0;
	    $special['migcase_skip_lat'] = 0;
	    $special['migcase_hms_mc_skip'] = 0;
	    $special['migcase_hms_dul_validto_date'] = 0;

	    if ($data['hms_citizenship_countrycode'] == "BLR") {
	        $special['migcase_hms_mc_skip'] = 1;
	    } else {
	        //$special['migcase_hms_mc_skip'] = 0;
	    }

	    if ($data['hms_citizenship_countrycode'] == "UKR" &&
	        ($data['hms_dul_documenttypeID'] == 103012 OR $data['hms_dul_documenttypeID'] == 103009)) {
	            $special['migcase_middlename'] = 1;
	            //$special['migcase_skip_lat'] = 1;
	        } else {
	            //$special['migcase_middlename'] = 0;
	            //$special['migcase_skip_lat'] = 0;
	        }
	        if ( $data['hms_dul_documenttypeID'] == 103009 OR $data['hms_dul_documenttypeID'] == 103007) {
	            $special['migcase_hms_dul_validto_date'] = 1;
	            $special['migcase_middlename'] = 0;
	        } else {
	            //$special['migcase_hms_dul_validto_date'] = 0;
	            //$special['migcase_middlename'] = 1;
	        }

	        if ( $data['hms_dul_documenttypeID'] == 139382) {
	            $special['migcase_hms_dul_validto_date'] = 1;
	        } else {
	        }
	        if ( $data['hms_dul_documenttypeID'] == 102977) {//потребує <validTo>2019-08-07</validTo> после <validFrom>2018-08-07</validFrom>
	            $special['migcase_hms_dul_validto_date'] = 1;
	        }
	        if ($data["hms_mc_card_num"] == '') {
	            $special ['migcase_hms_mc_skip'] = 1;
	        }

	        switch ($special ['migcase_hms_mc_skip']) {
	            case 0 :
	                $migcase = '
	<ns4:migrationCard>
		<uid>' . $data["hms_mc_uid"] . '</uid>
		<ns3:series>'.$data["hms_mc_card_precode"].'</ns3:series>
		<ns3:number>'.$data["hms_mc_card_num"].'</ns3:number>
		<ns3:stayPeriod>
			<dateFrom>'.$data["hms_mc_reg_date_in"].'</dateFrom>
			<dateTo>'.$data["hms_mc_reg_date_out"].'</dateTo>
		</ns3:stayPeriod>
		<ns3:entranceDate>'.$data["hms_mc_reg_date_in"].'</ns3:entranceDate>
		<ns3:visitPurpose>
			<type>VisitPurpose</type>
			<element>'.$data["hms_mc_visitpurpose"].'</element>
		</ns3:visitPurpose>
	</ns4:migrationCard>';
	                break;
	            case 1 :
	                $migcase = "";
	                break;
	        }

	        // 		<ns3:entranceCheckpoint>
	        // 		<type>officialOrgan</type>
	        // 		<element>'.$data["hms_mg_officialorgan_kpp_code"].'</element>
	        // 		</ns3:entranceCheckpoint>

	        if ($data['hms_citizenship_countrycode'] <> "BLR" &&
	            $data['hms_citizenship_countrycode'] <> "UKR" &&
	            $data['hms_citizenship_countrycode'] <> "UZB" &&
	            $data['hms_citizenship_countrycode'] <> "KAZ" &&
	            $data['hms_citizenship_countrycode'] <> "KOR" &&
	            $data['hms_citizenship_countrycode'] <> "AZE" &&
	            $data['hms_citizenship_countrycode'] <> "BRA" &&
	            $data['hms_citizenship_countrycode'] <> "RUS") {
	                $docResidence = '<ns4:docResidence>
 			<ns4:visa>
  				<uid>' . $data["hms_resdoc_uid"] . '</uid>
 				<type>
  					<type>DocumentType</type>
  					<element>139356</element>
  				</type>
  				<series>'.$data["hms_visa_reg_visa_precode"].'</series>
  				<number>'.$data["hms_visa_reg_visa_num"].'</number>
  				<issued>'.$data["hms_visa_card_date_of_issue"].'</issued>
  				<validFrom>'.$data["hms_visa_card_date_of_issue"].'</validFrom>
  				<validTo>'.$data["hms_visa_reg_visa_date_till"].'</validTo>
 				<status>
  					<type>DocumentStatus</type>
  					<element>102877</element>
  				</status>
				<ns3:category>
  					<type>VisaCategory</type>
  					<element>'.$data["hms_visa_reg_visa_type"].'</element>
  				</ns3:category>
				<ns3:multiplicity>
  					<type>VisaMultiplicity</type>
  					<element>'.$data["hms_visa_visamultiplicity"].'</element>
  				</ns3:multiplicity>
  				<ns3:identitifier>'.$data["hms_resdoc_identitifier"].'</ns3:identitifier>
				<ns3:visitPurpose>
  					<type>EntryGoal</type>
  					<element>'.$data["hms_visa_entrygoal"].'</element>
  				</ns3:visitPurpose>
  			</ns4:visa>
  			<ns4:entered>false</ns4:entered>
  		</ns4:docResidence>';
	            }else{
	                $docResidence = '';
	            }

	            if ($data["hms_visa_reg_visa_num"] === "") {
	                $docResidence = '';
	            }


	            if ($data['hms_citizenship_countrycode'] == "ISR" &&
	                $data['hms_visa_reg_visa_num'] == ''
	                ) {
	                    $docResidence = '';
	                }else{

	                }

	                if ($data["hms_docResidence"] == "135709") {
	                    $docResidence = '<ns4:docResidence>
 			<ns4:permResidencePermit>
  				<uid>' . $data["hms_resdoc_uid"] . '</uid>
 				<type>
  					<type>DocumentType</type>
  					<element>' . $data["hms_docResidence"] . '</element>
  				</type>
  				<series>'.$data["hms_visa_reg_visa_precode"].'</series>
  				<number>'.$data["hms_visa_reg_visa_num"].'</number>
                <authority>'.$data["hms_docResidence_authority"].'</authority>
  				<issued>'.$data["hms_visa_card_date_of_issue"].'</issued>
  				<validTo>'.$data["hms_visa_reg_visa_date_till"].'</validTo>
 				<status>
  					<type>DocumentStatus</type>
  					<element>102877</element>
  				</status>
                <ns4:decisionNumber>'.$data["hms_docResidence_decisionNumber"].'</ns4:decisionNumber>
            	<ns4:decisionDate>'.$data["hms_docResidence_decisionDate"].'</ns4:decisionDate>
  			</ns4:permResidencePermit>
  			<ns4:entered>false</ns4:entered>
  		</ns4:docResidence>';

	                } else {
	                    //echo "+++++++++++++++++++++++++++++++++++++++\n\n\n\n\n";
	                }


	                // 		<ns3:entranceCheckpoint>
	                // 		<type>officialOrgan</type>
	                // 		<element>128647</element>
	                // 		</ns3:entranceCheckpoint>


	                // 		<ns3:entranceCheckpoint>
	                // 		<type>officialOrgan</type>
	                // 		<element>128648</element>
	                // 		</ns3:entranceCheckpoint>



	                switch ($special ['migcase_skip_lat']) {
	                    case 0 :
	                        $lastname_lat = '<lastNameLat>'.$data["lastname_lat"].'</lastNameLat>';
	                        $firstname_lat = '<firstNameLat>'.$data["firstname_lat"].'</firstNameLat>';
	                        break;
	                    case 1 :
	                        $lastname_lat = "";
	                        $firstname_lat = "";
	                        break;
	                }

	                switch ($special ['migcase_hms_dul_validto_date']) {
	                    case 0 :
	                        $hms_dul_validto_date = "";
	                        break;
	                    case 1 :
	                        $hms_dul_validto_date = '<validTo>'.$data["hms_dul_validto_date"].'</validTo>';
	                        break;
	                }

	                switch ($special ['migcase_middlename']) {
	                    case 0 :
	                        $migcase_middlename = "";
	                        break;
	                    case 1 :
	                        $migcase_middlename = '<middleName>'.$data["middlename"].'</middleName>';
	                        break;
	                }

	                $data["docResidence"] = $docResidence;
	                $data["migcase_block"] = $migcase;
	                $data["firstname_lat_block"] = $firstname_lat;
	                $data["lastname_lat_block"] = $lastname_lat;
	                $data["hms_dul_validto_date_block"] = $hms_dul_validto_date;
	                $data["migcase_middlename_block"] = $migcase_middlename;

	                $data['stayPlace_address_tag'] = ($data["fms_hiloc_fias_object_active"] == 1) ?
	                "<addressObject>
				<type>addressObject</type>
				<element>".$data["fms_hiloc_fias_object"]."</element>
			</addressObject>" :
				"<addressObjectString>".$data["hms_hiloc_region"]."$".$data["hms_hiloc_state"]."$".$data["hms_hiloc_city"]
				."$".$data["hms_hiloc_subcity"]."$".$data["hms_hiloc_cityregion"]."$".$data["hms_hiloc_street"]."</addressObjectString>";

				$data['host_address_tag'] = ($data["fms_hi_fias_object_active"] == 1) ?
				"<addressObject>
				<type>addressObject</type>
				<element>".$data["fms_hi_fias_object"]."</element>
			</addressObject>" :
				"<addressObjectString>".$data["hms_hi_region"]."$".$data["hms_hi_state"]."$".$data["hms_hi_city"]
				."$".$data["hms_hi_subcity"]."$".$data["hms_hi_cityregion"]."$".$data["hms_hi_street"]."</addressObjectString>";

				if ($debug == 1) {
				    echo "<pre>";
				    $text_ = print_r($data, true);
				    echo $text_;
				    $text_ = print_r($special, true);
				    echo $text_;
				    die();
				}

				$form5tpl = 'templates/fms_xml/fms_form5.xml';
				switch ($data['hms_dul_documenttypeID']) {
				    case 103007:
				        $form5tpl = 'templates/fms_xml/fms_form5_103007.xml';
				        break;
				    case 102974:
				        $form5tpl = 'templates/fms_xml/fms_form5_103007.xml';
				        break;
				    default:
				        $form5tpl = 'templates/fms_xml/fms_form5.xml';
				        break;
				}



				if ($data['hms_citizenship_countrycode'] == "RUS") {
				    $xml = $this->parser->parse($form5tpl, $data, true);
				    $xsd = "xsd/hotel-form5.xsd";
				    $xsdtype = 1;
				} else {


				    if ($data['user_doc_documenttype'] == 103012) {
				        $user_data = $this->parser->parse('templates/fms_xml/fms_migcase_user_103012.xml', $data, true);
				    } else {
				        $user_data = $this->parser->parse('templates/fms_xml/fms_migcase_user.xml', $data, true);
				    }

				    $data['user_data'] = $user_data;

				    //$xml = $this->parser->parse('templates/fms_xml/fms_migcase.xml', $data, true);
				    $xsd = "xsd/migration-by-staying.xsd";
				    $xsdtype = 2;

				    switch ($data['hms_dul_documenttypeID']) {
				        case 135709:
				            $data["docResidence"] = '';
				            $xml = $this->parser->parse('templates/fms_xml/fms_migcase_135709.xml', $data, true);
				            break;
				        default:
				            $xml = $this->parser->parse('templates/fms_xml/fms_migcase.xml', $data, true);
				            break;
				    }
				}
				$request_id = $data["hms_global_requestnumber"];
				$saveindb = 1;

				$hotel_id = $this->config->item('hotel_id');


				$response_ummsid = "";
        if ($regtype == 2) {
            if ($response_ummsid_2unreg_row_id > 0) {
                $sql = "SELECT uid, signedxml, xsdtype, response_ummsid FROM global_project_fms.fms_records WHERE
                    id= " . $response_ummsid_2unreg_row_id . "
  				    AND hms_id= " . $hotel_id . " AND  reservation_id = " . $reservation_id . "
  				    AND guest_id = " . $guest_id ;
            } else {
                $sql = "SELECT uid, signedxml, xsdtype, response_ummsid FROM global_project_fms.fms_records WHERE regtype=1
  				    AND hms_id= " . $hotel_id . " AND  reservation_id = " . $reservation_id . "
  				    AND guest_id = " . $guest_id . " AND response_ummsid <> '' ORDER BY  `createtime` DESC ";
            }

				    //echo "<br>" . $sql . "<br>";
				    $query = $db_fms->query($sql);
				    if ($query->num_rows() > 0) {
				        $row = $query->row();
				        $response_ummsid = $row->response_ummsid;
				    } else {
				        $response_ummsid = "unknown ummsid";
				        //die(" -- no ummsid -- ");
				    }
				    if ($response_ummsid == "") {
				        //die(" -- ZERO ummsid -- ");
				    }
				    $data['response_ummsid'] = $response_ummsid;
				    $xml = $this->parser->parse('templates/fms_xml/fms_unregmigcase.xml', $data, true);
				    $xsd = "xsd/unreg-migration-by-staying.xsd";
				    $xsdtype = 3;
				}


				$hms_dateout = "";
				if(isset($data["hms_dateout"])){
				    $hms_dateout = $data["hms_dateout"];
				}
				$temp = explode("-", $data["root_uid"]);
				$uid = $temp[0] . "-" . $temp[1] . "-" . $temp[2] . "-" . $temp[3];
				if ($saveindb == 1) {


				    list ( $year, $month, $day ) = explode ( "-", $hms_dateout );
				    $dateTo_int = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

				    $sql = "INSERT INTO global_project_fms.fms_records (update_time, request_id, regcaseid, hms_id, partner_id,
				    reservation_id, guest_id, regtype, uid, state, unsignedxml, xsd, dateTo, dateTo_int,  xsdtype)
	            VALUES(now(), '" . $request_id . "', '" . $response_ummsid . "', '" . $this->config->item('hotel_id') . "','"
		                . $data['hms_partner_id'] . "','"
		                    . $reservation_id . "', '"
		                        . $guest_id . "', "
		                            . $regtype . ", '"
		                                . $uid . "', '0', '"
		                                    . $xml . "', '"//stripslashes($xml) не проходило уч 2'3    - место жительства
		                                        . $xsd . "', '"
		                                            . $hms_dateout . "', "
		                                                . $dateTo_int . ", "
		                                                    . $xsdtype . ")
			ON DUPLICATE KEY UPDATE state=0, update_time=now(), request_id = '" . $request_id . "',
		    uid = '" . $uid . "', unsignedxml = '" . $xml . "', xsd='" . $xsd . "', xsdtype=" . $xsdtype . " ";//stripslashes($xml)
		                                                    // echo $sql;
		                                                    //  die();
		                                                    $query = $db_fms->query($sql);

		                                                    //$sql = "delete from fms_records where reservation_id = " . $reservation_id . " AND guest_id = " . $guest_id. "";
		                                                    //$this->db->query($sql);

		                                                    if ($xsdtype == 3) {
		                                                        $state = 4;
		                                                    } else {
		                                                        $state = 0;
		                                                    }

		                                                    $sql = "INSERT INTO fms_records (reservation_id, guest_id, state)
	                    VALUES('" . $reservation_id . "',
		    '" . $guest_id . "',
		    '" . $state . "')
				    ON DUPLICATE KEY UPDATE state = '" . $state . "', response_state = 0, time=now()";

		                                                    $this->db->query($sql);

		                                                    $json = array();
		                                                    $json ["status"] = 0;
		                                                    $json ["response"] = $response_text;
		                                                    $json ["time"] = date("Y-m-d H:i:s");

		                                                    if ($landing_page != "") {
		                                                        switch ($landing_page) {
		                                                            case "fms_map":
		                                                                die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/fms_map/1'>" );
		                                                            case "folio":
		                                                                die ( "<meta http-equiv='refresh' content='0;url=/reservation_c2/folio/".$reservation_id."/1'>" );
		                                                                break;

		                                                            default:
		                                                                ;
		                                                                break;
		                                                        }
		                                                    }

		                                                    return $json;
		                                                    //echo print_r(json_encode($json), true);
				} else {
				    echo $xml;
				}
	}
	function get_fms_opened_cases_list($hms_id = "", $reservation_id = "", $guest_id = "", $option = 0, $days = 90) {
	    if ($days > 0) {
	        $past_days = $days;
	    } else {
	        $past_days = 90;
	    }
	    $limit = 1000;
	    $concrete_where_str = "";
		if ($hms_id != "" && $reservation_id != "" && $guest_id != ""){
			$reservation_dayout = $this->db->select('dateout')->get_where('deskofreservation', array('id'=>$reservation_id))->row()->dateout;
			$concrete_where_str = " AND t1.hms_id = $hms_id AND t1.reservation_id = $reservation_id AND t1.guest_id = $guest_id";
			$dateTo_where_str = " AND ((CURDATE() >= t1.dateTo AND t1.dateTo >= DATE_SUB(CURDATE(), INTERVAL $past_days DAY))
										OR (CURDATE() >= $reservation_dayout AND $reservation_dayout >= DATE_SUB(CURDATE(), INTERVAL $past_days DAY)))";
		}else {
			$dateTo_where_str = " AND (CURDATE() >= t1.dateTo AND t1.dateTo >= DATE_SUB(CURDATE(), INTERVAL $past_days DAY))";
		}

		if ($option == 102) {
            $sql = "SELECT t1.id as id, t1.hms_id, t1.reservation_id, t1.guest_id, t1.response_ummsid, t1.dateTo
		    FROM global_project_fms.fms_records AS t1
		    LEFT JOIN global_project_fms.fms_records AS t2
		    ON (t1.hms_id = t2.hms_id AND t1.reservation_id = t2.reservation_id AND t1.guest_id = t2.guest_id)
		    AND (t1.response_ummsid = t2.regcaseid AND t1.response_ummsid !=  '')
		    WHERE (t1.xsdtype =2 AND t1.state =3 AND t1.finished_by = '' AND (ISNULL (t2.regcaseid) OR
		    (t2.regcaseid != '' AND t2.state IN (-3, 1, 2))))
		    $dateTo_where_str $concrete_where_str LIMIT $limit";
        } else {
            $sql = "SELECT t1.id as id, t1.hms_id, t1.reservation_id, t1.guest_id, t1.response_ummsid, t1.dateTo
				FROM global_project_fms.fms_records AS t1
				LEFT JOIN global_project_fms.fms_records AS t2
				ON (t1.hms_id = t2.hms_id AND t1.reservation_id = t2.reservation_id AND t1.guest_id = t2.guest_id)
					AND (t1.response_ummsid = t2.regcaseid AND t1.response_ummsid !=  '')
				WHERE (t1.xsdtype =2 AND t1.state =3 AND t1.finished_by = '' AND (ISNULL (t2.regcaseid) OR
																				  (t2.regcaseid != '' AND t2.state IN (-3))))
						$dateTo_where_str $concrete_where_str LIMIT $limit";
        }
		$query = $this->db->query($sql);
		//echo $sql;
		$result_arr = array();
		foreach ($query->result() as $record) {
		    $result_arr[$record->id]['id'] = $record->id;
		    $result_arr[$record->id]['hms_id'] = $record->hms_id;
		    $result_arr[$record->id]['response_ummsid'] = $record->response_ummsid;
		    $result_arr[$record->id]['guest_id'] = $record->guest_id;
		    $result_arr[$record->id]['reservation_id'] = $record->reservation_id;
		    $result_arr[$record->id]['fms_dateuot'] = $record->dateTo;
// 			array_push ( $result_arr, array (
// 					'id' => $record->id,
// 					'hms_id' => $record->hms_id,
// 					'response_ummsid' => $record->response_ummsid,
// 					'reservation_id' => $record->reservation_id,
// 					'guest_id' => $record->guest_id,
// 					'fms_dateuot' => $record->dateTo
// 			) );
		}

		//print_r($result_arr);
		//die();
		return $result_arr;
	}
}
?>