<?php
$die_url = "tasks_list";
$selected_statuses = $this->session->userdata ( 'cs_list_statuses' );
$selected_categories = $this->session->userdata ( 'cs_list_categories' );
$room = $this->session->userdata ( 'cs_list_room' );
$date = $this->session->userdata ( 'cs_list_date' );
$assignedto = $this->session->userdata ( 'cs_list_assignedto' );
$urgent = $this->session->userdata ( 'cs_list_urgent' );
$type = $this->session->userdata ( 'cs_list_type' );

if ($this->session->userdata ( 'cs_list_lines_per_page' ) != ""){
    $lines_per_page = $this->session->userdata ( 'cs_list_lines_per_page' );
}else{
    $lines_per_page = 50;
}

$cur_page = $current_page;
$page_first_line = ($cur_page - 1) * $lines_per_page;
$url_for_pagination = "/tasks_c2/tasks_list/";

if ($date != "") {
    list ( $datein, $dateout ) = explode ( ' - ', $date );
} else {
    $datein = date("Y-m-d", mktime ( 0, 0, 0, date("m"), date("d") - 90, date("Y")));
    $dateout = date("Y-m-d");
    $date = date("Y-m-d") . " - " . date("Y-m-d");
}
list($year, $month, $day) = explode("-", $datein);
$intdate_from = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
list($year, $month, $day) = explode("-", $dateout);
$intdate_to = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

$all_categories = $this->htmltpl->get_all_categories_from_db ();
if ($selected_categories == "") {
    foreach ( $all_categories as $category_id => $category_data ) {
        if ($category_data ['is_active']) {
            $selected_categories [$category_id] = $category_id;
        }
    }
}

$all_task_statuses = $this->tasks_model->get_task_statuses();
if ($selected_statuses == "") {   
    foreach ( $all_task_statuses as $status_data ) {
         $selected_statuses [$status_data['id']] = $status_data['id'];
    }
}


$select = "";
if ($type != "") {
    $select .= " hk_tasks.task_type = $type AND";
}
$select .= " hk_tasks.startdate BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59' AND";

if ($selected_categories != "") {
    $selected_categories_str = implode(", ", $selected_categories);
    $select .= " (rooms.category_id IN (" . $selected_categories_str . ")) AND";
}

if ($selected_statuses != "") {
    $selected_statuses_str = implode(", ", $selected_statuses);
    $select .= " (hk_tasks.status IN (" . $selected_statuses_str . ")) AND";
}

if ($room != "") {
    $select .= " rooms.id = '" . $room . "' AND";
}

if ($assignedto != "") {
    $select .= " users.id = '" . $assignedto . "' AND";
}

if ($urgent != "") {
    $select .= " hk_tasks.is_urgent = '" . $urgent . "' AND";
}

$lines_per_current_page = $page_first_line+1;

$tasks_list = array();
$sql = "SELECT SQL_CALC_FOUND_ROWS 1 as number, categories.id AS cat_id, rooms.id AS room_id, 
CONCAT(rooms.name, ' (', categories.name, ')') as cat_room_name,
hk_tasks.id as task_id,
DATE(hk_tasks.startdate) as task_startdate, CONCAT(users.fullname, ' ', users.lastname) as user_name, hk_task_statuses.name as task_status,
hk_task_types.id as task_type_id, hk_task_types.name as task_type_name, hk_task_types.icon as task_type_icon, hk_task_types.color as task_type_color
FROM hk_tasks
INNER JOIN rooms ON rooms.id = hk_tasks.room_id
INNER JOIN categories ON categories.id = rooms.category_id
LEFT JOIN hk_task_statuses ON hk_task_statuses.id = hk_tasks.status 
LEFT JOIN users ON users.id = hk_tasks.assignedto
LEFT JOIN hk_task_types ON hk_tasks.task_type = hk_task_types.id
WHERE $select rooms.is_active = 1 AND categories.is_active = 1
LIMIT ".$page_first_line.", ".$lines_per_page;
$query = $this->db->query($sql);

$query_p = $this->db->query ( "SELECT FOUND_ROWS() AS all_lines_count" )->row();
$all_lines_count = $query_p->all_lines_count;

foreach ($query->result() as $row) {
    $task_type_name = $row->task_type_name;
    if($row->task_type_id == 1){
        $task_type_name = "{-".$row->task_type_name."-}";
    }
    
    array_push($tasks_list, array(
        'inc' => $lines_per_current_page,
        'task_id' => $row->task_id,
        'cat_room_name' => $row->cat_room_name,
        'cs_type' => $task_type_name,
        'start_date' => $row->task_startdate,
        'status' => "{-".$row->task_status."-}",
        'assignedto' => $row->user_name
    ));
    $lines_per_current_page++;
}

// echo "<pre>";
// print_r($tasks_list);
// die();

// ================= CREATE SEARCH SELECT ===================================
$select_option_categories = array();
foreach ($all_categories as $category_id => $category_data) {

    if (isset($selected_categories[$category_id])) {
        array_push($select_option_categories, array(
            'value' => $category_id,
            'name' => $category_data['name'],
            'selected_option' => 'selected="selected"'
        ));
    } else {
        array_push($select_option_categories, array(
            'value' => $category_id,
            'name' => $category_data['name'],
            'selected_option' => ""
        ));
    }
}

$rooms = array();
$rooms [0]['name'] = "{mlw_all}";
$rooms [0]['value'] = "";
$rooms [0]['selected_room'] = "";
$query = $this->db->query ( "SELECT * FROM rooms WHERE 1 ORDER BY category_id, name ASC" );
foreach ( $query->result () as $row ) {
    $selected_room = "";
    if ($row->id == $room) {
        $selected_room = "selected";
    }
    array_push($rooms, array(
        'name' => $row->name,
        'value' => $row->id,
        'selected_room' => $selected_room,
    ));
}

$select_option_statuses = array();
foreach ( $all_task_statuses as $status_data) {
    if (isset ( $selected_statuses [$status_data['id']] )) {
        array_push ( $select_option_statuses, array (
            'value' => $status_data['id'],
            'name' => "{-".$status_data['name']."-}",
            'selected_option' => 'selected="selected"'
        ) );
    } else {
        array_push ( $select_option_statuses, array (
            'value' => $status_data['id'],
            'name' => "{-".$status_data['name']."-}",
            'selected_option' => ""
        ) );
    }
}

$users = $this->musers_c2->get_users('maid');

$users_select = array();
$users_select[0]['user_id'] = "";
$users_select[0]['user_name'] = "{mlw_all}";
$users_select[0]['user_selected'] = "";
foreach($users as $cell){
    if($assignedto == $cell['id']){
        $selected = "selected";
    }else{
        $selected = "";
    }
    array_push($users_select, array(
        'user_id' => $cell['id'],
        'user_name' => $cell['fullname']." ".$cell['lastname'],
        'user_selected' => $selected,
    ));
}

$urgent_select = array();
$urgent_select [0]['name'] = "{mlw_all}";
$urgent_select [0]['value'] = "";
$urgent_select [0]['selected'] = "";
$urgent_select [1]['name'] = "{clt_urgent}";
$urgent_select [1]['value'] = "1";
$urgent_select [1]['selected'] = "";
foreach($urgent_select as $key => $cell){
    if($cell['value'] == $urgent){
        $urgent_select[$key]['selected'] = "selected";
    }
}

$tasks_types = $this->tasks_model->getTask_types();
$types_select = array();
array_push($types_select, array(
    'id' => "",
    'name' => "{mlw_all}",
    'select_type' => "",
));
foreach($tasks_types as $cell){
        $select_type = "";
        if ($type == $cell['id']) {
            $select_type = "selected";
        }
        
        $type_name = $cell['name'];
        if($cell['id'] == 1){
            $type_name = "{-".$cell['name']."-}"; 
        }
        
        array_push($types_select, array(
            'id' => $cell['id'],
            'name' => $type_name,
            'select_type' => $select_type
        ));
}
// ================ END CREATE SEARCH SELECT =================
$data = array (
		'header' => $this->htmltpl->getHeader_new (),
		'footer_html' => $this->htmltpl->getFooter_new(),
        'left_menu' => $this->htmltpl->get_left_menu (8, 3),
        'select_option_statuses' => $select_option_statuses,
        'select_option_categories' => $select_option_categories,
        'rooms' => $rooms,
        'date' => $date,
        'datein' => $datein,
        'dateout' => $dateout,
        'tasks_list' => $tasks_list,
        'users_select' => $users_select,
        'urgent_select' => $urgent_select,
        'types_select' => $types_select,
        'pagination' => $this->htmltpl->pagination ($all_lines_count, $lines_per_page, $cur_page, $url_for_pagination),
        'die_url' => $die_url
);
$this->mlanguages->getdictionary ( "tasks_c2", "", $data );
$this->mlanguages->getdictionary("reservations_rlist", "", $data);
$this->parser->parse ( 'templates/tasks_c2/tasks_list_view.html', $data );
?>
