<?php
$data = array();
$group_list = array();

if ($this->session->userdata ( 'group_list_lines_per_page' ) != ""){
	$lines_per_page = $this->session->userdata ( 'group_list_lines_per_page' );
}else{
	$lines_per_page = 50;
}
$cur_page = $current_page;
$page_first_line = ($cur_page - 1) * $lines_per_page;
$lines_per_current_page = $page_first_line+1;
$url_for_pagination = "/reservation_c2/group_list/";

$date = $this->session->userdata ( 'group_list_date_c2' );
$dealer = $this->session->userdata ( 'group_list_dealer_c2' );

if ($date != "") {
	list ( $datein, $dateout ) = explode ( ' - ', $date );
} else {
	$datein = date("Y-m-d");
	$dateout = date("Y-m-d");
	$date = date("Y-m-d") . " - " . date("Y-m-d");
}
$select = " WHERE ";
if ($dealer != "" && $dealer != "all_dealers") {
	$select .= " deskofreservation.id_dealer = " . $dealer . " AND";
}

if($date != ""){
	$select .= " groupreservations.creationtime BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59' AND";
}
$select .= " 1 ";

$query = $this->db->query ( "SELECT * FROM dealers" );
$search_dealer = '';
// $search_dealer .= "<option value=''>{mlw_all}</option>";
if ($dealer == 'all_dealers') {
	$search_dealer .= "<option selected value='all_dealers'>{mlw_all}</option>";
} else {
	$search_dealer .= "<option value='all_dealers'>{mlw_all}</option>";
}
foreach ( $query->result () as $row ) {
	if ($row->id == $dealer) {
		$search_dealer .= "<option selected value='$row->id'>$row->name</option>";
	} else {
		$search_dealer .= "<option value='$row->id'>$row->name</option>";
	}
}

$sql = "SELECT SQL_CALC_FOUND_ROWS groupreservations.id as group_id, groupreservations.name as group_name, groupreservations.creationtime,
count(deskofreservation.id) as res_count, sum(deskofreservation.amount) as amount, sum(deskofreservation.discount) as discount
FROM groupreservations
LEFT JOIN deskofreservation ON deskofreservation.intgroupid = groupreservations.id ".$select."
GROUP BY groupreservations.id ORDER BY groupreservations.id DESC LIMIT ".$page_first_line.", ".$lines_per_page;
$query = $this->db->query ( $sql );
$query_p = $this->db->query ( "SELECT FOUND_ROWS() AS all_lines_count" )->row();
$all_lines_count = $query_p->all_lines_count;

$sum_page_amount = 0;
$sum_page_discount = 0;
foreach ( $query->result() as $row ) {
	array_push($group_list, array(
		"b" => $lines_per_current_page,
		"group_id" => $row->group_id,
		"group_name" => $row->group_name,
		"creationtime" => $row->creationtime,
		"res_count" => $row->res_count,
		"amount" => (int)$row->amount,
		"discount" => (int)$row->discount
	));
	$lines_per_current_page++;
}

$data["pagination"] = $this->htmltpl->pagination ($all_lines_count, $lines_per_page, $cur_page, $url_for_pagination);
$data["search_dealer"] = $search_dealer;
$data["group_list"] = $group_list;
$data["datein"] = $datein;
$data["dateout"] = $dateout;
$data["date"] = $date;
$data["header"] = $this->htmltpl->getHeader_new ();
$data["left_menu"] = $this->htmltpl->get_left_menu (2);
$data["footer_html"] = $this->htmltpl->getFooter_new();
$this->mlanguages->getdictionary("reservations_rlist", "", $data);
$this->parser->parse ( 'templates/reservation_c2_group_list_view.html', $data );
?>