<?php
$report_number_threshold = $this->config->item('report_number_threshold');
$days_numbers = $this->report_model->get_days_numbers();
$months = $this->report_model->get_months();
$selected_year_period = $this->session->userdata ( 'report_trev_selected_year_period' );
if($selected_year_period == ""){
		$selected_year_period = date("Y");
}
$select_option_services = $this->report_model->get_select_option_services_parsing_arr();
$selected_services = $this->session->userdata ( 'report_trev_selected_services' );
if ($selected_services == ""){
	$selected_services = array();
	foreach ($select_option_services[0]['group_options_main_services'] as $main_service) {
		array_push($selected_services, $main_service['id']);
	}
	foreach ($select_option_services[0]['group_options_services'] as $service) {
		array_push($selected_services, $service['id']);
	}
}else{
	foreach ($select_option_services[0]['group_options_main_services'] as &$main_service_data) {
		if(!in_array($main_service_data['id'], $selected_services)){
			$main_service_data['selected'] = "";
		}
		unset($main_service_data);
	}
	foreach ($select_option_services[0]['group_options_services'] as &$service_data) {
		if(!in_array($service_data['id'], $selected_services)){
			$service_data['selected'] = "";
		}
		unset($service_data);
	}
}
$select_option_categories = $this->report_model->get_active_and_isactiveroom_categories();
$selected_categories = $this->session->userdata ( 'report_trev_selected_categories' );
if ($selected_categories == ""){
	$selected_categories = array();
	foreach ($select_option_categories as $cat) {
		array_push($selected_categories, $cat['id']);
	}
}else{
	foreach ($select_option_categories as &$category_data) {
		if(!in_array($category_data['id'], $selected_categories)){
			$category_data['selected'] = "";
		}
		unset($category_data);
	}
}
$selected_months = $this->session->userdata ( 'report_trev_selected_months' );
if ($selected_months == ""){
	$selected_months = array();
	foreach ($months as $month_data) {
		array_push($selected_months, $month_data['number']);
	}
}
$select_option_months = $months;
foreach ($select_option_months as &$month_data) {
	if(!in_array($month_data['number'], $selected_months)){
		$month_data['selected'] = "";
	}
	unset($month_data);
}
$prev_year_period = date("Y", strtotime("01-01-$selected_year_period - 1 year"));
$line_prev_period_data = array();
$line_curr_period_data = array();
$line_labels = array();
$month_data_pars_arr = array();
$requested_data = array (
		'selected_categories' => $selected_categories,
		'selected_services' => $selected_services,
		'start_intdate' => '',
		'end_intdate' => '',
);
foreach ($selected_months as $selected_month) {
	$month_days_pars_arr = array();
	$requested_data['start_intdate'] = $start_intdate = round(strtotime("first day of ".$months[$selected_month]['Full_name']." $selected_year_period") / 86400);
	$requested_data['end_intdate'] = $end_intdate = round(strtotime("last day of ".$months[$selected_month]['Full_name']." $selected_year_period") / 86400);
	$curr_period_data = $this->report_model->get_TREV_graphycs_data($requested_data);
	$requested_data['start_intdate'] = $start_intdate_prev = round(strtotime("first day of ".$months[$selected_month]['Full_name']." $prev_year_period") / 86400);
	$requested_data['end_intdate'] = $end_intdate_prev = round(strtotime("last day of ".$months[$selected_month]['Full_name']." $prev_year_period") / 86400);
	$prev_period_data = $this->report_model->get_TREV_graphycs_data($requested_data);;
	$delta_periods = $start_intdate - $start_intdate_prev;
	foreach ($curr_period_data['intdates'] as $intday_of_month => $day_of_month_data) {
		$rev_curr_val = $day_of_month_data['TREV'];
		$rev_prev_val = $prev_period_data['intdates'][$intday_of_month - $delta_periods]['TREV'];
		$style_formal_value_cell = $this->report_model->make_style_formal_value_cell($rev_curr_val, $rev_prev_val);
		array_push ( $month_days_pars_arr, array (
				'rev_val' => $style_formal_value_cell ['value'],
				'rev_percent' => $style_formal_value_cell ['percent'],
				'rev_day_class' => $style_formal_value_cell ['style'],
				'rev_day_arrow_class' => $style_formal_value_cell ['arrow'] 
		) );
		if (count($selected_months) != 12){
			array_push ( $line_curr_period_data, $rev_curr_val);
			array_push ( $line_prev_period_data, $rev_prev_val);
			array_push($line_labels, $day_of_month_data['date']);
		}
	}
	if (count($selected_months) == 12){
		array_push ( $line_curr_period_data, $curr_period_data['all_period']['TREV']);
		array_push ( $line_prev_period_data, $prev_period_data['all_period']['TREV']);
		array_push($line_labels, $months[$selected_month]['clt_name']);
	}
	$del = 31 - count($month_days_pars_arr);
	if ($del > 0){
		for ($i = 0; $i < $del; $i++) {
			array_push ( $month_days_pars_arr, array (
			'rev_val' => "",
			'rev_percent' => "",
			'rev_day_class' => "",
			'rev_day_arrow_class' => ""
			) );
		}
	}
	array_push ( $month_data_pars_arr, array (
			'name' => $months[$selected_month]['clt_name'],
			'month_days_pars_arr' => $month_days_pars_arr,
			'curr_period_month_TREV' => number_format (ceil($curr_period_data['all_period']['TREV']), 0, ' ', $report_number_threshold ),
			'prev_period_month_TREV' => number_format (ceil($prev_period_data['all_period']['TREV']), 0, ' ', $report_number_threshold ),
	) );
}
$data = array (
		'days_numbers' => $days_numbers,
		'month_data_pars_arr' => $month_data_pars_arr,
		'select_option_categories' => $select_option_categories,
		'select_option_services' => $select_option_services,
		'select_option_months' => $select_option_months,
		'selected_year_period' => $selected_year_period,
);
//========== graf line data START =================
$data["line_labels"] = json_encode($line_labels);
$data["prev_year_period"] = $prev_year_period;
$data["line_curr_period_data"] = json_encode($line_curr_period_data);
$data["line_prev_period_data"] = json_encode($line_prev_period_data);
//========== graf line data FINAL =================
$data["left_menu"] = $this->htmltpl->get_left_menu (4, 4);
$data["header"] = $this->htmltpl->getHeader_new ();
$data["footer_html"] = $this->htmltpl->getFooter_new();
$this->mlanguages->getdictionary("reports_c2_fraphs", "", $data);
$this->parser->parse ( 'templates/reports_c2/trev_compare_view.html', $data );

?>