<?php
$pie_slices_limit = 10;
$report_number_threshold = $this->config->item('report_number_threshold');
$system_dateformat = $this->frontdesk->get_systemdateformat();
$picker_dateformat = $this->frontdesk->get_systemdateformat('for_daterangepicker');
$date_range = $this->session->userdata('report_sources_date_range');
if (empty($date_range)) {
    $start_date = date($system_dateformat, strtotime("first day of last month"));
    $end_date = date($system_dateformat, strtotime("last day of last month"));
} else {
    list ($start_date, $end_date) = explode(' - ', $date_range);
    $start_date = date($system_dateformat, strtotime($start_date));
    $end_date = date($system_dateformat, strtotime($end_date));
}
$start_intdate = round(strtotime($start_date) / 86400);
$end_intdate = round(strtotime($end_date) / 86400);
$cur_data = $this->report_model->get_sources_graphycs_data(array(
    'start_intdate' => $start_intdate,
    'end_intdate' => $end_intdate
));
$prev_start_date = date($system_dateformat, strtotime("$start_date -1 year"));
$prev_end_date = date($system_dateformat, strtotime("$end_date -1 year"));
$prev_start_intdate = round( strtotime($prev_start_date) / 86400);
$prev_end_intdate = round( strtotime($prev_end_date) / 86400);
$prev_data = $this->report_model->get_sources_graphycs_data(array(
    'start_intdate' => $prev_start_intdate,
    'end_intdate' => $prev_end_intdate
));
// ==================== вирівнювання даних СТАРТ ================
foreach ($cur_data['sources'] as $source_id => $source_data) {
    if(!isset($prev_data['sources'][$source_id])){
        $prev_data['sources'][$source_id]['amount'] = 0;
        $prev_data['sources'][$source_id]['name'] = $source_data['name'];
    }
}
foreach ($prev_data['sources'] as $source_id => $source_data) {
    if(!isset($cur_data['sources'][$source_id])){
        $cur_data['sources'][$source_id]['amount'] = 0;
        $cur_data['sources'][$source_id]['name'] = $source_data['name'];
    }
}
// echo "<pre>";
// echo count($cur_data['sources']);
// print_r($cur_data);
// echo count($prev_data['sources']);
// print_r($prev_data);
// die("DIED by A Department at sources_view.php function_container() on 11 мая 2020 г. 19:10:23");
// ==================== вирівнювання даних ФІНІШ ================
$pies_parsing_arr = array(
    'sources_cur_labels' => array(),
    'sources_prev_labels' => array(),
    'pie_cur_data' => array(),
    'pie_prev_data' => array(),
);
$parsing_arr = array(
    'sources' => array(),
    'total' => array()
);
foreach ($cur_data['sources'] as $source_id => $source_data) {
    $parsing_arr['sources'][$source_id]['name'] = $source_data['name'];
    $parsing_arr['sources'][$source_id]['redirect_url'] = "/reports_c2/redirect_from_sources?id=$source_id&start_date=$start_date&end_date=$end_date";
    $cur_amount = $source_data['amount'];
    $parsing_arr['sources'][$source_id]['cur_amount'] = number_format($cur_amount, 2, ".", $report_number_threshold);
    $prev_amount = $prev_data['sources'][$source_id]['amount'];
    $parsing_arr['sources'][$source_id]['prev_amount'] = number_format($prev_amount, 2, ".", $report_number_threshold);
    $diff_amount = $cur_amount - $prev_amount;
    $parsing_arr['sources'][$source_id]['diff_amount'] = number_format($diff_amount, 2, ".", $report_number_threshold);
    $arrow_class = "d0";
    $diff_percent = 0;
    if ($diff_amount > 0) {
        $arrow_class = 'ion-arrow-up-c green';
        $diff_percent = round(abs($diff_amount / $cur_amount) * 100, 2);
    } elseif ($diff_amount < 0) {
        $arrow_class = 'ion-arrow-down-c red';
        $diff_percent = round(abs($diff_amount / $prev_amount) * 100, 2);
    }
    $parsing_arr['sources'][$source_id]['arrow_class'] = $arrow_class;
    $parsing_arr['sources'][$source_id]['diff_percent'] = number_format($diff_percent, 2);
    if ($cur_amount != 0){
        array_push($pies_parsing_arr['sources_cur_labels'], $source_data['name']);
        array_push($pies_parsing_arr['pie_cur_data'], $cur_amount);
    }
    if ($prev_amount != 0){
        array_push($pies_parsing_arr['sources_prev_labels'], $source_data['name']);
        array_push($pies_parsing_arr['pie_prev_data'], $prev_amount);
    }
}
$total_cur_amount = $cur_data['total'];
$total_prev_amount = $prev_data['total'];
$diff_amount = $total_cur_amount - $total_prev_amount;
$arrow_class = "d0";
$diff_percent = 0;
if ($diff_amount > 0) {
    $arrow_class = 'ion-arrow-up-c green';
    $diff_percent = round(abs($diff_amount / $total_cur_amount) * 100, 2);
} elseif ($diff_amount < 0) {
    $arrow_class = 'ion-arrow-down-c red';
    $diff_percent = round(abs($diff_amount / $total_prev_amount) * 100, 2);
}
$parsing_arr['total'] = array(
    array(
        'cur_amount' => number_format($total_cur_amount, 2, ".", $report_number_threshold),
        'prev_amount' => number_format($total_prev_amount, 2, ".", $report_number_threshold),
        'diff_amount' => number_format($diff_amount, 2, ".", $report_number_threshold),
        'diff_percent' => number_format($diff_percent, 2),
        'arrow_class' => $arrow_class
    )
);
foreach ($pies_parsing_arr['pie_cur_data'] as $key => $amount) {
    $pies_parsing_arr['pie_cur_data'][$key] = round(($amount / $total_cur_amount) * 100, 2);
}
foreach ($pies_parsing_arr['pie_prev_data'] as $key => $amount) {
    $pies_parsing_arr['pie_prev_data'][$key] = round(($amount / $total_prev_amount) * 100, 2);
}
$data = array();
foreach ($pies_parsing_arr as $label => $value) {
    $data[$label] = json_encode($value);
}
$data["picker_dateformat"] = $picker_dateformat;
$data["parsing_arr"] = array($parsing_arr);
$data["start_date"] = $start_date;
$data["end_date"] = $end_date;
$data["curr_period"] = "$start_date - $end_date";
$data["prev_period"] = "$prev_start_date - $prev_end_date";
$data["left_menu"] = $this->htmltpl->get_left_menu(1, 7);
$data["header"] = $this->htmltpl->getHeader_new();
$data["footer_html"] = $this->htmltpl->getFooter_new();
$this->mlanguages->getdictionary("reports_c2_fraphs", "", $data);
$this->parser->parse('templates/reports_c2/sources_view.html', $data);
?>