<?php
$data = array();
$prefix = $this->mlanguages->get_language_prefix();
$status_table_name = "global_hotelix_languages.".$prefix."_statusofreservation";

if ($this->session->userdata ( 'rlist_lines_per_page' ) != ""){
	$lines_per_page = $this->session->userdata ( 'rlist_lines_per_page' );
}else{
	$lines_per_page = 50;
}

$cur_page = $current_page;
$page_first_line = ($cur_page - 1) * $lines_per_page;
$url_for_pagination = "/reservation_c2/rlist/";
/*
 * SESSION DATA
 *
 */
// $time_range = $this->session->userdata ( 'rlist_time_range' );
$date_type = $this->session->userdata ( 'rlist_date_type' );
if($date_type == ""){
	$date_type = 1;
}
$date = $this->session->userdata ( 'rlist_date_c2' );
$reservation_status = $this->session->userdata ( 'rlist_status_c2' );
$intgroupid = $this->session->userdata ( 'rlist_intgroupid_c2' );
$category = $this->session->userdata ( 'rlist_category_c2' );//передавалось з одиночного селекту

$selected_categories = $this->session->userdata ( 'rlist_categories_c2' );
if ($selected_categories == "") {// робимо вибраними тільки активні категорії
	$all_categories = $this->htmltpl->get_all_categories_from_db ();
	foreach ( $all_categories as $category_id => $category_data ) {
		if ($category_data ['is_active']) {
			$selected_categories [$category_id] = $category_id;
		}
	}
}

$selected_statuses = $this->session->userdata ( 'rlist_statuses_c2' );

if ($selected_statuses == "") {// робимо вибраними тільки активні категорії
	$all_statuses = $this->htmltpl->get_all_statuses_from_db ();
	foreach ( $all_statuses as $status_id => $status_data ) {
		if ($status_data ['type'] == 1) {
			$selected_statuses [$status_id] = $status_id;
		}
	}
}

$rate = $this->session->userdata ( 'rlist_rate_c2' );
//die();
$room = $this->session->userdata ( 'rlist_room_c2' );
$dealer = $this->session->userdata ( 'rlist_dealer_c2' );
$discount = $this->session->userdata ( 'rlist_discount_c2' );
$negative_balance = $this->session->userdata ( 'rlist_negative_balance_c2' );
$not_confirmed = $this->session->userdata ( 'rlist_not_confirmed_c2' );
$bso = $this->session->userdata ( 'rlist_bso_c2' );
$fields_rlist_session = $this->session->userdata ( 'fields_rlist' );

$sort_room = $this->session->userdata ( 'sort_room' );
$sort_datein = $this->session->userdata ( 'sort_datein' );
$sort_dateout = $this->session->userdata ( 'sort_dateout' );
$sort_duration = $this->session->userdata ( 'sort_duration' );
$sort_discount = $this->session->userdata ( 'sort_discount' );
$sort_balance = $this->session->userdata ( 'sort_balance' );
$sort_reservation = $this->session->userdata ( 'sort_reservation' );

if ($date != "") {

	list ( $datein, $dateout ) = explode ( ' - ', $date );
	//$datein = gmdate("Y-m-d", strtotime ( strtr ( $datein, "/", "-" )));
	//$dateout = gmdate("Y-m-d", strtotime ( strtr ( $dateout, "/", "-" )));
} else {
	$datein = date("Y-m-d", mktime ( 0, 0, 0, date("m"), date("d") - 90, date("Y")));
	$dateout = date("Y-m-d");
	$date = date("Y-m-d") . " - " . date("Y-m-d");
}


$select = "";
$select .= " WHERE ";

$bso_checked = "";
if($bso == 1){
	$bso_checked = "checked";
	$select .= " payment.bso_id <> 0 AND";
}
$data["bso_checked"] = $bso_checked;

$discount_checked = "";
if($discount == 1){
	$discount_checked = "checked";
	$select .= " deskofreservation.discount <> 0 AND";
}
$data["discount_checked"] = $discount_checked;

$negative_balance_checked = "";
if($negative_balance == 1){
	$negative_balance_checked = "checked";
	$select .= " deskofreservation.balance < 0 AND";
}
$data["negative_balance_checked"] = $negative_balance_checked;

$not_confirmed_checked = "";
if($not_confirmed == 1){
    $not_confirmed_checked = "checked";
    $select .= " deskofreservation.avoidtime > 0 AND deskofreservation.duetime > 0 AND";
}
$data["not_confirmed_checked"] = $not_confirmed_checked;

if ($dealer != "") {
	if ($dealer == 'all_dealers') {
		$select .= " deskofreservation.id_dealer <> 0 AND";
	} else {
		$select .= " deskofreservation.id_dealer = " . $dealer . " AND";
	}
}
if ($reservation_status != "") {
	$select .= " deskofreservation.status = $reservation_status AND";
}

if ($intgroupid != "") {
	$select .= " deskofreservation.intgroupid = '".$intgroupid."' AND";
}

if ($selected_categories != "") {
	$selected_categories_str = implode(", ", $selected_categories);
	$select .= " (rooms.category_id IN (" . $selected_categories_str . ")) AND";
}

if ($selected_statuses != "") {
	$selected_statuses_str = implode(", ", $selected_statuses);
	$select .= " (deskofreservation.status IN (" . $selected_statuses_str . ")) AND";
}

if ($rate != "") {
	$select .= " deskofreservation.price_type = '" . $rate . "' AND";
}
if ($room != "") {
	$select .= " rooms.id = '" . $room . "' AND";
}

if ($date_type != "") {
	switch ($date_type) {
		case "0" :
			if ($datein != "" and $dateout == "") {

				$select .= " deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '2054-01-01 23:59:59' AND";
			}
			if ($datein == "" and $dateout != "") {
				$select .= " deskofreservation.datein BETWEEN '2009-01-01 00:00:00' AND '" . $dateout . " 23:59:59' AND";
			}

			if ($datein != "" and $dateout != "") {
				$select .= " deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59' AND";
			}
			break;
		case "1" :
			if ($datein != "" and $dateout == "") {

				$select .= " deskofreservation.date BETWEEN '" . $datein . " 00:00:00' AND '2054-01-01 23:59:59' AND";
			}
			if ($datein == "" and $dateout != "") {
				$select .= " deskofreservation.date BETWEEN '2009-01-01 00:00:00' AND '" . $dateout . " 23:59:59' AND";
			}

			if ($datein != "" and $dateout != "") {
				$select .= " deskofreservation.date BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59' AND";
			}
			break;
		case "2" :
			if ($datein != "" and $dateout == "") {

				$select .= " ((deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '2054-01-01 23:59:59') OR
				(deskofreservation.dateout BETWEEN '" . $datein . " 00:00:00' AND '2054-01-01 23:59:59') OR
				(deskofreservation.datein <= '" . $datein . " 00:00:00' AND deskofreservation.dateout >= '2054-01-01 23:59:59')) AND";
			}
			if ($datein == "" and $dateout != "") {
				$select .= " ((deskofreservation.datein BETWEEN '2009-01-01 00:00:00' AND '" . $dateout . " 23:59:59') OR
				(deskofreservation.dateout BETWEEN '2009-01-01 00:00:00' AND '" . $dateout . " 23:59:59') OR
				(deskofreservation.datein <= '2009-01-01 00:00:00' AND deskofreservation.dateout >= '" . $dateout . " 23:59:59')) AND";
			}

			if ($datein != "" and $dateout != "") {
				$select .= " ((deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59') OR
				(deskofreservation.dateout BETWEEN DATE_ADD('" . $datein . " 00:00:00', INTERVAL 1 DAY) AND '" . $dateout . " 23:59:59') OR
				(deskofreservation.datein <= '" . $datein . " 00:00:00' AND deskofreservation.dateout >= '" . $dateout . " 23:59:59')) AND";
			}
			break;
		default :
			if ($datein != "" and $dateout == "") {

				$select .= " deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '2054-01-01 23:59:59' AND";
			}
			if ($datein == "" and $dateout != "") {
				$select .= " deskofreservation.datein BETWEEN '2009-01-01 00:00:00' AND '" . $dateout . " 23:59:59' AND";
			}

			if ($datein != "" and $dateout != "") {
				$select .= " deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59' AND";
			}
			break;
	}
}else{
	if ($datein != "" and $dateout == "") {

		$select .= " deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '2054-01-01 23:59:59' AND";
	}
	if ($datein == "" and $dateout != "") {
		$select .= " deskofreservation.datein BETWEEN '2009-01-01 00:00:00' AND '" . $dateout . " 23:59:59' AND";
	}

	if ($datein != "" and $dateout != "") {
		$select .= " deskofreservation.datein BETWEEN '" . $datein . " 00:00:00' AND '" . $dateout . " 23:59:59' AND";
	}
}

$select .= " deskofreservation.deleted=0";


$select_sort = "";
if ($sort_room != "" or $sort_datein != "" or $sort_dateout != "" or $sort_discount != "" or $sort_duration != "" or $sort_balance != "" or $sort_reservation != "") {
	switch ($sort_room) {
		case "11" :
			$select_sort = "ORDER by rooms.id ASC";
			//$img_sort_room = '<span ><a href="javascript:void(0)" onclick="SortSubmit(12)" >+</a></span>';
			$img_sort_room = '<a class="" href="javascript:void(0)" onclick="SortSubmit(12)">
	<span class="fa-sorte">
	<i class="fa fa-sort-asc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		case "12" :
			$select_sort = "ORDER by rooms.id DESC";
			//$img_sort_room = '<span ><a href="javascript:void(0)" onclick="SortSubmit(11)" >-</a></span>';
			$img_sort_room = '<a class="" href="javascript:void(0)" onclick="SortSubmit(11)">
	<span class="fa-sorte">
	<i class="fa fa-sort-desc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		default :
			//$img_sort_room = '<span ><a href="javascript:void(0)" onclick="SortSubmit(11)" >+</a></span>';
			$img_sort_room = '<a class="" href="javascript:void(0)" onclick="SortSubmit(11)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
			break;
	}
	switch ($sort_datein) {

		case "21" :
			$select_sort = "ORDER by deskofreservation.datein ASC";
			//$img_sort_datein = '<span ><a href="javascript:void(0)" onclick="SortSubmit(22)" >+</a></span>';
			$img_sort_datein = '<a class="" href="javascript:void(0)" onclick="SortSubmit(22)">
	<span class="fa-sorte">
	<i class="fa fa-sort-asc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		case "22" :
			$select_sort = "ORDER by deskofreservation.datein DESC";
			//$img_sort_datein = '<span ><a href="javascript:void(0)" onclick="SortSubmit(21)" >-</a></span>';
			$img_sort_datein = '<a class="" href="javascript:void(0)" onclick="SortSubmit(21)">
	<span class="fa-sorte">
	<i class="fa fa-sort-desc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		default :
			//$img_sort_datein = '<span ><a href="javascript:void(0)" onclick="SortSubmit(21)" >+</a></span>';
			$img_sort_datein = '<a class="" href="javascript:void(0)" onclick="SortSubmit(21)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
			break;
	}
	switch ($sort_dateout) {
		case "31" :
			$select_sort = "ORDER by deskofreservation.dateout ASC";
			//$img_sort_dateout = '<span ><a href="javascript:void(0)" onclick="SortSubmit(32)" >+</a></span>';
			$img_sort_dateout = '<a class="" href="javascript:void(0)" onclick="SortSubmit(32)">
	<span class="fa-sorte">
	<i class="fa fa-sort-asc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		case "32" :
			$select_sort = "ORDER by deskofreservation.dateout DESC";
			//$img_sort_dateout = '<span ><a href="javascript:void(0)" onclick="SortSubmit(31)">-</a></span>';
			$img_sort_dateout = '<a class="" href="javascript:void(0)" onclick="SortSubmit(31)">
	<span class="fa-sorte">
	<i class="fa fa-sort-desc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		default :
			//$img_sort_dateout = '<span ><a href="javascript:void(0)" onclick="SortSubmit(31)">+</a></span>';
			$img_sort_dateout = '<a class="" href="javascript:void(0)" onclick="SortSubmit(31)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
			break;
	}
	switch ($sort_duration) {
		case "41" :
			$select_sort = "ORDER by deskofreservation.duration ASC";
			//$img_sort_duration = '<span ><a href="javascript:void(0)" onclick="SortSubmit(42)" >+</a></span>';
			$img_sort_duration = '<a class="" href="javascript:void(0)" onclick="SortSubmit(42)">
	<span class="fa-sorte">
	<i class="fa fa-sort-asc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		case "42" :
			$select_sort = "ORDER by deskofreservation.duration DESC";
			//$img_sort_duration = '<span ><a href="javascript:void(0)" onclick="SortSubmit(41)">-</a></span>';
			$img_sort_duration = '<a class="" href="javascript:void(0)" onclick="SortSubmit(41)">
	<span class="fa-sorte">
	<i class="fa fa-sort-desc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		default :
			//$img_sort_duration = '<span ><a href="javascript:void(0)" onclick="SortSubmit(41)">+</a></span>';
			$img_sort_duration = '<a class="" href="javascript:void(0)" onclick="SortSubmit(41)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
			break;
	}
	switch ($sort_discount) {
		case "51" :
			$select_sort = "ORDER by deskofreservation.discount ASC";
			//$img_sort_discount = '<span ><a href="javascript:void(0)" onclick="SortSubmit(52)" >+</a></span>';
			$img_sort_discount = '<a class="" href="javascript:void(0)" onclick="SortSubmit(52)">
	<span class="fa-sorte">
	<i class="fa fa-sort-asc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		case "52" :
			$select_sort = "ORDER by deskofreservation.discount DESC";
			//$img_sort_discount = '<span ><a href="javascript:void(0)" onclick="SortSubmit(51)">-</a></span>';
			$img_sort_discount = '<a class="" href="javascript:void(0)" onclick="SortSubmit(51)">
	<span class="fa-sorte">
	<i class="fa fa-sort-desc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		default :
			//$img_sort_discount = '<span ><a href="javascript:void(0)" onclick="SortSubmit(51)">+</a></span>';
			$img_sort_discount = '<a class="" href="javascript:void(0)" onclick="SortSubmit(61)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
			break;
	}
	switch ($sort_balance) {
		case "61" :
			// $select_sort = "ORDER by deskofreservation.duration ASC";
			$select_sort = "ORDER by deskofreservation.balance ASC";
			//$img_sort_balance = '<span ><a href="javascript:void(0)" onclick="SortSubmit(62)" >+</a></span>';
			$img_sort_balance = '<a class="" href="javascript:void(0)" onclick="SortSubmit(62)">
	<span class="fa-sorte">
	<i class="fa fa-sort-asc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		case "62" :
			// $select_sort = "ORDER by deskofreservation.duration DESC";
			$select_sort = "ORDER by deskofreservation.balance DESC";
			//$img_sort_balance = '<span ><a href="javascript:void(0)" onclick="SortSubmit(61)">-</a></span>';
			$img_sort_balance = '<a class="" href="javascript:void(0)" onclick="SortSubmit(61)">
	<span class="fa-sorte">
	<i class="fa fa-sort-desc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		default :
			//$img_sort_balance = '<span ><a href="javascript:void(0)" onclick="SortSubmit(61)">+</a></span>';
			$img_sort_balance = '<a class="" href="javascript:void(0)" onclick="SortSubmit(61)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
			break;
	}
	switch ($sort_reservation) {
		case "71" :
			$select_sort = "ORDER by deskofreservation.id ASC";
			//$img_sort_reservation = '<span ><a href="javascript:void(0)" onclick="SortSubmit(72)" >+</a></span>';
			$img_sort_reservation = '<a class="" href="javascript:void(0)" onclick="SortSubmit(72)">
	<span class="fa-sorte">
	<i class="fa fa-sort-asc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		case "72" :
			$select_sort = "ORDER by deskofreservation.id DESC";
			//$img_sort_reservation = '<span ><a href="javascript:void(0)" onclick="SortSubmit(71)">-</a></span>';
			$img_sort_reservation = '<a class="" href="javascript:void(0)" onclick="SortSubmit(71)">
	<span class="fa-sorte">
	<i class="fa fa-sort-desc fa-stack-1x"></i>
	</span>
	</a>';
			break;
		default :
			//$img_sort_reservation = '<span ><a href="javascript:void(0)" onclick="SortSubmit(71)">+</a></span>';
			$img_sort_reservation = '<a class="" href="javascript:void(0)" onclick="SortSubmit(71)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
			break;
	}
} else {
	$select_sort = "ORDER by deskofreservation.id DESC";
	$img_sort_dateout = '<a class="" href="javascript:void(0)" onclick="SortSubmit(32)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
	$img_sort_datein = '<a class="" href="javascript:void(0)" onclick="SortSubmit(21)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
	$img_sort_room = '<a class="" href="javascript:void(0)" onclick="SortSubmit(11)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
	$img_sort_duration = '<a class="" href="javascript:void(0)" onclick="SortSubmit(41)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
	$img_sort_discount = '<a class="" href="javascript:void(0)" onclick="SortSubmit(51)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
	$img_sort_balance = '<a class="" href="javascript:void(0)" onclick="SortSubmit(61)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
	$img_sort_reservation = '<a class="" href="javascript:void(0)" onclick="SortSubmit(71)">
	<span class="fa-sorte">
	<i class="fa fa-unsorted fa-stack-1x  unactiv"></i>
	</span>
	</a>';
}

/*
 *
 * fields option
 *
 */
$fields = array ();
$fields ["number"] = 1;
$fields ["reservation_id"] = 1;
$fields ["cat_room_name"] = 1;
$fields ["guest_name"] = 1;
$fields ["base_places"] = 1;
$fields ["additional_places"] = 1;
$fields ["baby_places"] = 1;
$fields ["istochnik"] = 1;
$fields ["price_type"] = 1;
$fields ["status_name"] = 1;
$fields ["datein"] = 1;
$fields ["duration"] = 1;
$fields ["dateout"] = 1;
$fields ["amount"] = 1;
$fields ["discount"] = 1;
$fields ["pay_amount"] = 1;
$fields ["balance"] = 1;
$fields ["date"] = 1;
$fields ["phone"] = 1;
$fields ["email"] = 1;

if ($fields_rlist_session == "") {
	$sql2 = "SELECT str_value FROM hotelix_interface_config WHERE name LIKE 'rlist_fields' AND userid = ".$_SESSION["user"]["id"];
	$query2 = $this->db->query($sql2);

	if ($query2->num_rows () > 0) {
		$row2 = $query2->row();
		$json_fields = $row2->str_value;
		$fields_rlist_session = json_decode($json_fields, true);
	}else{
	    $fields_rlist_session["number"] = $fields["number"];
	    $fields_rlist_session["reservation_id"] = $fields["reservation_id"];
	    $fields_rlist_session["cat_room_name"] = $fields["cat_room_name"];
	    $fields_rlist_session["balance"] = $fields["balance"];
	    $fields_rlist_session["date"] = $fields["date"];
	    $fields_rlist_session["phone"] = $fields["phone"];
	    $fields_rlist_session["email"] = $fields["email"];
	}
}

$fields_data = array();
$fields_data ["number"] ["name"] = "#";
$fields_data ["reservation_id"] ["name"] = "{caption_order}";
$fields_data ["cat_room_name"] ["name"] = "{caption_room}";
$fields_data ["guest_name"] ["name"] = "{caption_guest}";
$fields_data ["base_places"] ["name"] = "{caption_rlist_baseplaces}";
$fields_data ["additional_places"] ["name"] = "{caption_rlist_additional_places}";
$fields_data ["baby_places"] ["name"] = "{caption_rlist_baby_places}";
$fields_data ["istochnik"] ["name"] = "{caption_dealer}";
$fields_data ["price_type"] ["name"] = "{caption_rate}";
$fields_data ["status_name"] ["name"] = "{caption_status}";
$fields_data ["datein"] ["name"] = "{caption_checkin}";
$fields_data ["duration"] ["name"] = "{caption_days}";
$fields_data ["dateout"] ["name"] = "{caption_checkout}";
$fields_data ["amount"] ["name"] = "{caption_sum}";
$fields_data ["discount"] ["name"] = "{caption_discount}";
$fields_data ["pay_amount"] ["name"] = "{caption_paid}";
$fields_data ["balance"] ["name"] = "{caption_balance}";
$fields_data ["date"] ["name"] = "{caption_date}";
$fields_data ["phone"] ["name"] = "{caption_phone}";
$fields_data ["email"] ["name"] = "{caption_email}";

$fields_data ["number"] ["class_name"] = "";
$fields_data ["reservation_id"] ["class_name"] = "";
$fields_data ["cat_room_name"] ["class_name"] = "";
$fields_data ["guest_name"] ["class_name"] = "";
$fields_data ["base_places"] ["class_name"] = "";
$fields_data ["additional_places"] ["class_name"] = "";
$fields_data ["baby_places"] ["class_name"] = "";
$fields_data ["istochnik"] ["class_name"] = "";
$fields_data ["price_type"] ["class_name"] = "";
$fields_data ["status_name"] ["class_name"] = "";
$fields_data ["datein"] ["class_name"] = "";
$fields_data ["duration"] ["class_name"] = "";
$fields_data ["dateout"] ["class_name"] = "";
$fields_data ["amount"] ["class_name"] = "";
$fields_data ["discount"] ["class_name"] = "";
$fields_data ["pay_amount"] ["class_name"] = "";
$fields_data ["balance"] ["class_name"] = "";
$fields_data ["date"] ["class_name"] = "";
$fields_data ["phone"] ["class_name"] = "";
$fields_data ["email"] ["class_name"] = "";

$fields_data ["number"] ["class_name_rlist"] = "";
$fields_data ["reservation_id"] ["class_name_rlist"] = "";
$fields_data ["cat_room_name"] ["class_name_rlist"] = "";
$fields_data ["guest_name"] ["class_name_rlist"] = "";
$fields_data ["base_places"] ["class_name_rlist"] = "";
$fields_data ["additional_places"] ["class_name_rlist"] = "";
$fields_data ["baby_places"] ["class_name_rlist"] = "";
$fields_data ["istochnik"] ["class_name_rlist"] = "";
$fields_data ["price_type"] ["class_name_rlist"] = "";
$fields_data ["status_name"] ["class_name_rlist"] = "";
$fields_data ["datein"] ["class_name_rlist"] = "text_nowrap";
$fields_data ["duration"] ["class_name_rlist"] = "";
$fields_data ["dateout"] ["class_name_rlist"] = "text_nowrap";
$fields_data ["amount"] ["class_name_rlist"] = "text-right";
$fields_data ["discount"] ["class_name_rlist"] = "text-right";
$fields_data ["pay_amount"] ["class_name_rlist"] = "text-right";
$fields_data ["balance"] ["class_name_rlist"] = "text-right";
$fields_data ["date"] ["class_name_rlist"] = "text-right";
$fields_data ["phone"] ["class_name_rlist"] = "text-right";
$fields_data ["email"] ["class_name_rlist"] = "text-right";

$data["td_fieds_data"] = array();
$data["reservation_list"] = array();
$data["display_options"] = array();

foreach($fields as $field_name => $value){
	if(isset($fields_rlist_session[$field_name])){
		$checked = "checked";
	}else{
		$checked = "";
	}
	array_push ( $data["display_options"], array (
	'field_checked' => $checked,
	'fileld_option_name' => $field_name,
	'field_name' => $fields_data[$field_name]["name"]
	));

}

foreach($fields_rlist_session as $field_name => $value){
	$sort_str = "";
	switch ($field_name) {
		case "reservation_id" :
			$sort_str = "{img_sort_reservation}";
			break;
		case "cat_room_name" :
			$sort_str = "{img_sort_room}";
			break;
		case "discount" :
			$sort_str = "{img_sort_discount}";
			break;
		case "balance" :
			$sort_str = "{img_sort_balance}";
			break;
		case "datein" :
			$sort_str = "{img_sort_datein}";
			break;
		case "duration" :
			$sort_str = "{img_sort_duration}";
			break;
		case "dateout" :
			$sort_str = "{img_sort_dateout}";
			break;
	}
	array_push ( $data["td_fieds_data"], array (
		'td_class_name' => $fields_data[$field_name]["class_name_rlist"],
		'td_field_name' => $fields_data[$field_name]["name"],
		'sort_str' => $sort_str
	));
}
$sql = "SELECT deskofreservation.amount, deskofreservation.discount,
SUM(payment.amount) as pay_amount, deskofreservation.balance
FROM deskofreservation
INNER JOIN guests ON deskofreservation.guest_id=guests.id
INNER JOIN rooms ON rooms.id=deskofreservation.room_id
INNER JOIN categories ON categories.id=rooms.category_id
INNER JOIN ".$status_table_name." ON ".$status_table_name.".id = deskofreservation.status
LEFT JOIN dealers ON dealers.id = deskofreservation.id_dealer
LEFT JOIN payment ON  payment.reservation_id = deskofreservation.id
LEFT JOIN rate ON  rate.id = deskofreservation.price_type
$select
GROUP BY deskofreservation.id " . $select_sort;
// echo $sql."<br>";

$query2 = $this->db->query ( $sql );
$sum_all_amount = 0;
$sum_all_discount = 0;
$sum_all_pay_amount = 0;
$sum_all_balance = 0;
foreach ( $query2->result_array() as $row ) {
	$sum_all_amount += $row ["amount"];
	$sum_all_discount += $row ["discount"];
	$sum_all_pay_amount += $row ["pay_amount"];
	$sum_all_balance += $row ["balance"];
}
$sql = "SELECT SQL_CALC_FOUND_ROWS 1 as number, deskofreservation.guest_id, deskofreservation.intgroupid, groupreservations.name as group_name,
deskofreservation.id as reservation_id, CONCAT(rooms.name, ' (', categories.name, ')') as cat_room_name,
CONCAT(guests.lastname, ' ', guests.firstname) as guest_name, deskofreservation.adults as base_places,
deskofreservation.addbedplace as additional_places, deskofreservation.baby_places as baby_places,
dealers.name as istochnik, rate.caption as price_type, ".$status_table_name.".name as status_name,
deskofreservation.datein, deskofreservation.duration, deskofreservation.dateout, deskofreservation.amount, deskofreservation.discount,
SUM(IFNULL(payment.amount,0)) as pay_amount, deskofreservation.balance, deskofreservation.date, guests.phone, guests.email, deskofreservation.avoidtime, deskofreservation.duetime
FROM deskofreservation
INNER JOIN guests ON deskofreservation.guest_id=guests.id
INNER JOIN rooms ON rooms.id=deskofreservation.room_id
INNER JOIN categories ON categories.id=rooms.category_id
INNER JOIN ".$status_table_name." ON ".$status_table_name.".id = deskofreservation.status
LEFT JOIN dealers ON dealers.id = deskofreservation.id_dealer
LEFT JOIN payment ON  payment.reservation_id = deskofreservation.id
LEFT JOIN groupreservations ON  groupreservations.id = deskofreservation.intgroupid
LEFT JOIN rate ON  rate.id = deskofreservation.price_type
$select
GROUP BY deskofreservation.id " . $select_sort . " LIMIT ".$page_first_line.", ".$lines_per_page;
// echo $sql."<br><br>";
// die();
$_SESSION['rlist_main_sql'] = $sql;//збереження в сесію СКЛ сторінки для передачі на вивід в ехель
$query2 = $this->db->query ( $sql );
$query_p = $this->db->query ( "SELECT FOUND_ROWS() AS all_lines_count" )->row();
$all_lines_count = $query_p->all_lines_count;

$sum_page_amount = 0;
$sum_page_discount = 0;
$sum_page_pay_amount = 0;
$sum_page_balance = 0;
$lines_per_current_page = $page_first_line+1;
foreach ( $query2->result_array() as $row ) {
	$td_reservation_data = array();
	$confirm_status_str = "";
	if($row ["avoidtime"] > 0 && $row ["duetime"] > 0){
	    $confirm_status_str = "({clt_not_confirmed})";
	}
	
	$mono_status = $this->frontdesk_c2->mono_control_bydate($row ["datein"], $row ["dateout"]);
	
	foreach($fields_rlist_session as $field_name => $value){

		if (isset ( $row [$field_name] )) {
			switch ($field_name) {
                case "reservation_id":
                    $group_str = "";
                    if ($row["intgroupid"] > 0) {
                        $group_str = "<a href='/reservation_c2/foliogroup/" . $row["intgroupid"] . "'>[ GROUP " . $row["group_name"] . " ]</a>";
                    }
                    
                    $td_value = '<a href="/reservation_c2/folio/' . $row[$field_name] . '/1">' . $row[$field_name] . '</a>' . ' ' . $group_str;
                   
                    break;
                case "guest_name":
                    if ($mono_status == 1) {
                        $td_value = "---";
                    } else {
                        $td_value = '<a href="/reservation_c2/guestfolio/' . $row["guest_id"] . '">' . $row[$field_name] . '</a>';
                    }
                    break;
                case "number":
                    $td_value = $lines_per_current_page;
                    break;
                case "amount":
                    if ($mono_status == 1) {
                        $td_value = "---";
                    } else {
                        $td_value = $this->frontdesk->showcurrency($row["amount"]);
                    }
                    break;
                case "pay_amount":
                    if ($mono_status == 1) {
                        $td_value = "---";
                    } else {
                        $td_value = $this->frontdesk->showcurrency($row["pay_amount"]);
                    }
                    break;
                case "balance":
                    if ($mono_status == 1) {
                        $td_value = "---";
                    } else {
                        $td_value = $this->frontdesk->showcurrency($row["balance"]);
                    }
                    break;
                case "discount":
                    if ($mono_status == 1) {
                        $td_value = "---";
                    } else {
                        $td_value = $this->frontdesk->showcurrency($row["discount"]);
                    }
                    break;
                case "status_name":
                    if ($mono_status == 1) {
                        $td_value = "---";
                    } else {
                        $td_value = $row[$field_name] . " " . $confirm_status_str;
                    }
                    break;
                default:
                    if ($mono_status == 1) {
                        $td_value = "---";
                    } else {
                        $td_value = $row[$field_name];
                    }
                    break;
            }
            array_push($td_reservation_data, array(
                'td_class' => $fields_data[$field_name]["class_name_rlist"],
                'td_value' => $td_value
            ));
        }
	}
	array_push ( $data["reservation_list"], array (
		'td_reservation_data' => $td_reservation_data,
		'reservation_id' => $row ["reservation_id"]
	) );

	$sum_page_amount += $row ["amount"];
	$sum_page_discount += $row ["discount"];
	$sum_page_pay_amount += $row ["pay_amount"];
	$sum_page_balance += $row ["balance"];
	$lines_per_current_page++;
}

$data["tr_summ_page"] = array();
$data["tr_summ_all"] = array();
$itoho_td = 0;
//echo "<pre>";
//print_r($fields_rlist_session);
//die();
foreach($fields_rlist_session as $field_name => $value){
	$td_value = "";
	$td_class = "";
	$td_value_all = "";
	$td_class_all = "";
	switch ($field_name) {
		case "amount" :
			if($itoho_td == 0){
				$td_value = "{caption_totalsum} {caption_onpage}: ";
				$td_value_all = "{caption_totalsum}:";
				$td_class = "text-right";
				$max_key = max( array_keys( $data["tr_summ_page"] ) );

				$data["tr_summ_page"][$max_key - 1]["td_value"] = $td_value;
				$data["tr_summ_page"][$max_key - 1]["td_class"] = $td_class;

				$data["tr_summ_all"][$max_key - 1]["td_value"] = $td_value_all;
				$data["tr_summ_all"][$max_key - 1]["td_class"] = $td_class;
			}
			$itoho_td = 1;
			$td_class = "";
			$td_value = $this->frontdesk->showcurrency($sum_page_amount);
			$td_value_all = $this->frontdesk->showcurrency($sum_all_amount);
			break;
		case "discount" :
			if($itoho_td == 0){
				$td_value = "{caption_totalsum} {caption_onpage}: ";
				$td_value_all = "{caption_totalsum}:";
				$td_class = "text-right";
				$max_key = max( array_keys( $data["tr_summ_page"] ) );

				$data["tr_summ_page"][$max_key - 1]["td_value"] = $td_value;
				$data["tr_summ_page"][$max_key - 1]["td_class"] = $td_class;

				$data["tr_summ_all"][$max_key - 1]["td_value"] = $td_value_all;
				$data["tr_summ_all"][$max_key - 1]["td_class"] = $td_class;
			}
			$itoho_td = 1;
			$td_class = "";
			$td_value = $this->frontdesk->showcurrency($sum_page_discount);
			$td_value_all = $this->frontdesk->showcurrency($sum_all_discount);
			break;
		case "pay_amount" :
			if($itoho_td == 0){
				$td_value = "{caption_totalsum} {caption_onpage}: ";
				$td_value_all = "{caption_totalsum}:";
				$td_class = "text-right";
				$max_key = max( array_keys( $data["tr_summ_page"] ) );

				$data["tr_summ_page"][$max_key - 1]["td_value"] = $td_value;
				$data["tr_summ_page"][$max_key - 1]["td_class"] = $td_class;

				$data["tr_summ_all"][$max_key - 1]["td_value"] = $td_value_all;
				$data["tr_summ_all"][$max_key - 1]["td_class"] = $td_class;
			}
			$itoho_td = 1;
			$td_class = "text-right";
			$td_value = $this->frontdesk->showcurrency($sum_page_pay_amount);
			$td_value_all = $this->frontdesk->showcurrency($sum_all_pay_amount);
			break;
		case "balance" :
			if($itoho_td == 0){
				$td_value = "{caption_totalsum} {caption_onpage}: ";
				$td_value_all = "{caption_totalsum}:";
				$td_class = "text-right";
				$max_key = max( array_keys( $data["tr_summ_page"] ) );

				$data["tr_summ_page"][$max_key - 1]["td_value"] = $td_value;
				$data["tr_summ_page"][$max_key - 1]["td_class"] = $td_class;

				$data["tr_summ_all"][$max_key - 1]["td_value"] = $td_value_all;
				$data["tr_summ_all"][$max_key - 1]["td_class"] = $td_class;
			}
			$itoho_td = 1;
			$td_class = "text-right";
			$td_value = $this->frontdesk->showcurrency($sum_page_balance);
			$td_value_all = $this->frontdesk->showcurrency($sum_all_balance);
			break;
		default :
			$td_value = "";
			$td_value_all = "";
			break;
	}
	array_push ( $data["tr_summ_page"], array (
		'td_value' => $td_value,
		'td_class' => $td_class
	));
	array_push ( $data["tr_summ_all"], array (
	'td_value' => $td_value_all,
	'td_class' => $td_class
	));
}

//echo "<pre>";
//print_r($data);
//die();

$query = $this->db->query ( "SELECT * FROM dealers" );
$search_dealer = '';
$search_dealer .= "<option value=''>{mlw_all}</option>";
if ($dealer == 'all_dealers') {
	$search_dealer .= "<option selected value='all_dealers'>{mlw_all_dealers}</option>";
} else {
	$search_dealer .= "<option value='all_dealers'>{mlw_all_dealers}</option>";
}
foreach ( $query->result () as $row ) {
	if ($row->id == $dealer) {
		$search_dealer .= "<option selected value='$row->id'>$row->name</option>";
	} else {
		$search_dealer .= "<option value='$row->id'>$row->name</option>";
	}
}
$data["search_dealer"] = $search_dealer;

//формування масиву опцій селекту категорій
$all_categories = $this->htmltpl->get_all_categories_from_db();
$select_option_categories = array();
foreach ($all_categories as $category_id => $category_data) {
    
    if (isset($selected_categories[$category_id])) {
        array_push($select_option_categories, array(
            'value' => $category_id,
            'name' => $category_data['name'],
            'selected_option' => 'selected="selected"'
        ));
    } else {
        array_push($select_option_categories, array(
            'value' => $category_id,
            'name' => $category_data['name'],
            'selected_option' => ""
        ));
    }
}
$data['select_option_categories'] = $select_option_categories;
$rooms = '';
$rooms .= "<option value=''>{mlw_all}</option>";
$query = $this->db->query ( "SELECT * FROM rooms WHERE 1 ORDER BY category_id, name ASC" );
$optgroup_room_label = "";
foreach ( $query->result () as $row ) {
	if ($optgroup_room_label != $row->category_id){
		if (isset($all_categories[$row->category_id])){
			$rooms .= '<optgroup label="'.$all_categories[$row->category_id]['name'].'">';
		}else{
			$rooms .= '<optgroup label="UNKNOW CATEGORY">';
		}
	}
	if ($row->id == $room) {
		$rooms .= "<option selected value='$row->id'>$row->name</option>";
	} else {
		$rooms .= "<option value='$row->id'>$row->name</option>";
	}
	$optgroup_room_label = $row->category_id;
// 	if ($optgroup_room_label != $row->category_id){
// 		$rooms .= "</optgroup>";
// 	}
}
$data["rooms"] = $rooms;

$all_statuses = $this->htmltpl->get_all_statuses_from_db();
//echo "<pre>";
//print_r($all_statuses);
//die();
$select_option_statuses = array();
foreach ( $all_statuses as $status_id =>  $status_data) {
	if (isset ( $selected_statuses [$status_id] )) {
		array_push ( $select_option_statuses, array (
		'value' => $status_id,
		'name' => $status_data['name'],
		'selected_option' => 'selected="selected"'
				) );
	} else {
		array_push ( $select_option_statuses, array (
		'value' => $status_id,
		'name' => $status_data['name'],
		'selected_option' => ""
				) );
	}
}
$data['select_option_statuses'] = $select_option_statuses;
//============================================================

$search_rate = '';
$search_rate .= "<option value=''>{mlw_all}</option>";
$query = $this->db->query ( "SELECT id, caption FROM rate WHERE isactive = 1 ORDER BY `caption` ASC" );
foreach ( $query->result () as $row ) {

	if ($row->id == $rate) {
		$search_rate .= '<option selected value="' . $row->id . '">' . $row->caption . '</option>';
	} else {
		$search_rate .= '<option value="' . $row->id . '">' . $row->caption . '</option>';
	}

}
$data["search_rate"] = $search_rate;

$data["intgroupid"] = $intgroupid;



$date_types = array (
		"{mlw_datein}",
		"{mlw_datecreate}",
		"{mlw_days_of_stay}"
);
$search_date_type = '';
for($i = 0; $i < count ( $date_types ); $i ++) {
	if ($date_type == $i) {
		$search_date_type .= '<option selected value="' . $i . '">' . $date_types [$i] . '</option>';
	} else {
		$search_date_type .= '<option value="' . $i . '">' . $date_types [$i] . '</option>';
	}
}
$data["search_date_type"] = $search_date_type;
$data["date"] = $date;
$data["datein"] = $datein;
$data["dateout"] = $dateout;
$data["date"] = $date;

$data["img_sort_reservation"] =  $img_sort_reservation;
$data["img_sort_balance"] =  $img_sort_balance;
$data["img_sort_discount"] =  $img_sort_discount;
$data["img_sort_duration"] =  $img_sort_duration;
$data["img_sort_room"] =  $img_sort_room;
$data["img_sort_datein"] =  $img_sort_datein;
$data["img_sort_dateout"] =  $img_sort_dateout;
$data["header"] = $this->htmltpl->getHeader_new ();
$data["footer_html"] = $this->htmltpl->getFooter_new ();

$data["left_menu"] = $this->htmltpl->get_left_menu (2);
$data["pagination"] = $this->htmltpl->pagination ($all_lines_count, $lines_per_page, $cur_page, $url_for_pagination);

$this->mlanguages->getdictionary("reservations_rlist", "", $data);
$this->parser->parse ( 'templates/debug_maria_pages/page_7_view.html', $data );
?>