<?
class Tasks_model extends CI_Model {

    function __construct()
    {
        parent::__construct();
		$this->load->model ( 'Loger_admin' );
		$this->load->model ( 'frontdesk' );
	}
	function getList($start, $items_per_page, $select_sort, $select) {
		$taskList = array();
		$tasks_priority = array();
		$tasks_priority = $this->config->item("tasks_priority");
		$tasks_statuses = array();
		$tasks_statuses = $this->config->item("tasks_statuses");
		$tasks_types = $this->config->item("tasks_types");
		$i = 1;
		$sql = "SELECT tbl_tasks.*, users.fullname, users.lastname, rooms.name as room_name FROM tbl_tasks
		LEFT JOIN users ON users.id = tbl_tasks.assignedto
		LEFT JOIN rooms ON rooms.id = tbl_tasks.refersid WHERE tbl_tasks.deleted = 0 AND " . $select . $select_sort . " LIMIT $start, $items_per_page";
		//echo $sql;
		//die();
		$query = $this->db->query( $sql );
		//$query = $this->db->get('tbl_tasks', $start, $items_per_page);

		if ($query->num_rows() > 0)
		{
			foreach ($query->result() as $row)
			{
				
				if($row->referstype == 0){
					$referstype = "";
				}else{
					$referstype = $row->referstype;
				}
				array_push($taskList, array(
				'i'=>$start+$i,
				'id'=>$row->id,
				'duedate'=> substr($row->duedate, 0, 16 ),
				'assignedto'=>$row->fullname." ".$row->lastname,
				'referstype'=>$referstype,
				'refersid'=>$row->room_name,
				'priority'=>$tasks_priority[$row->priority],
				'status'=>$tasks_statuses[$row->status],
				'type'=>$tasks_types[$row->type],
				'subject'=>$row->subject,
				'description'=>substr($row->description, 0, 250 ),
				'resolution'=>$row->resolution
				));
				$i++;
			}
		}
		return $taskList;
	}
	function getTask($id) {
		$query = $this->db->get_where('hk_tasks', array('id' => $id));
		return $query->row_array();
	}

	function getTask_empty() {
	    $data = array();
	    $data ["id"] = -1;
	    $data ["room_id"] = 0;
	    $data ["createdby"] = 0;
	    $data ["deleted"] = 0;
	    $data ["startdate"] = "0000-00-00";
	    $data ["duedate"] = "0000-00-00";
	    $data ["assignedto"] = 0;
	    $data ["referstype"] = 0;
	    $data ["refersid"] = 0;
	    $data ["priority"] = 0;
	    $data ["status"] = 0;
	    $data ["type"] = 0;
	    $data ["task_type"] = 0;
	    $data ["task_subtype"] = 0;
	    $data ["subject"] = "";
	    $data ["description"] = "";
	    $data ["resolution"] = "";
	    $data ["is_urgent"] = 0;
	    $data ["status"] = 1;
	    return $data;
	}
	
	function get_current_task_cs($task_id){
	    return @$this->db->select('cs_id')->get_where('hk_tasks2cs', array('task_id' => $task_id))->row()->cs_id;
	}
	
	function getTask_types(){
	    $query = $this->db->get('hk_task_types');
	    return $query->result_array();
	}
	
	function getTask_subtypes($type_id = 0){
	    if($type_id == 0){
	       $query = $this->db->get('task_subtypes');
	    }else{
	        switch($type_id){
	            case 1:
	                $query = $this->db->select('id, name')->get_where('hk_cleaning_schedule');
	                break;
	            default:
	                $query = $this->db->get_where('task_subtypes', array('type_id'=>$type_id));
	                break;
	        }
	    }
	    return $query->result_array();
	}
	
	function getTask_subtype_name($type_id = 0, $task_id = 0){
	        switch($type_id){
	            case 1:
	                $this->db->select('cs.name');
	                $this->db->from('hk_cleaning_schedule cs');
	                $this->db->join('hk_tasks2cs tcs', 'tcs.cs_id = cs.id AND tcs.task_id = '.$task_id);
	                $name = $this->db->get()->row()->name;
	                break;
	            default:
	                $name = "";
	                break;
	        }

	    return $name;
	}
	
	function deleteTask($id) {
		$this->frontdesk->MonopolyMode();
		//$this->db->where('id', $id);
		//$this->db->delete('tbl_tasks');
		$sql = "UPDATE tbl_tasks SET deleted = 1 WHERE id = ".$id;
		$query = $this->db->query( $sql );
	}
	function updateTask($data, $items = array(), $id) {
		$this->frontdesk->MonopolyMode();
		$data_1 = $this->Loger_admin->get_values("tbl_tasks", $id);
		$this->db->where('id', $id);
		$this->db->update('tbl_tasks', $data);
		$data_2 = $this->Loger_admin->get_values("tbl_tasks", $id);
		$this->Loger_admin->SaveLog($data_1, $data_2, "loger_admin", $id, "tasks", "edit", "tasks");
		
		//=================================
		$this->db->where('task_id', $id);
		$this->db->delete('tbl_task2res');
		
		$data_tbl_task2res = array();
		$data_tbl_task2res ["task_id"] = $id;
		$data_tbl_task2res ["res_id"] = $data["referstype"];
		$this->db->insert('tbl_task2res', $data_tbl_task2res);
		
		$items_count = count($items);
		if ($items_count <> 0){
			$arr_keys = array_keys($items);
			foreach($arr_keys as $item_id){
				$this->db->delete('tbl_tasks_techbugs', array('task_id' => $id, 'placeitem_id' => $item_id));
				if ($items[$item_id]["status"] <> 0){

					$sql = "INSERT INTO  tbl_tasks_techbugs (task_id, placeitem_id,
				status, memo) VALUES('".$id."', '".$item_id."', '".$items[$item_id]["status"]."', 
				'".$items[$item_id]["memo"]."') ON DUPLICATE KEY UPDATE status = '".$items[$item_id]["status"]."', 
				memo = '".$items[$item_id]["memo"]."'";
					//echo $sql."<br>";
					$query = $this->db->query ( $sql );
				}
			}
		}
		//die();
	}

	function insertTask($data, $items = array()) {
		//echo "<pre>";
		//print_r($data);
		$this->frontdesk->MonopolyMode();
		$data_1 = array();
		$this->db->insert('tbl_tasks', $data);
		
		$task_id = $this->db->insert_id ();
		$data_2 = $this->Loger_admin->get_values("tbl_tasks", $task_id);
		$this->Loger_admin->SaveLog($data_1, $data_2, "loger_admin", $task_id, "tasks","save");
		
		//=================================
		$data_tbl_task2res = array();
		$data_tbl_task2res ["task_id"] = $task_id;
		$data_tbl_task2res ["res_id"] = $data["referstype"];
		$this->db->insert('tbl_task2res', $data_tbl_task2res);
		
		$items_count = count($items);
		if ($items_count <> 0){
			$arr_keys = array_keys($items);
			foreach($arr_keys as $item_id){
				if ($items[$item_id]["status"] <> 0){
					$items_data = array(
					"task_id"=>$task_id,
					"placeitem_id"=>$item_id,
					"status"=>$items[$item_id]["status"],
					"memo"=>$items[$item_id]["memo"],
					);
					$this->db->insert('tbl_tasks_techbugs', $items_data);
				}
			}
		}

	}
	
	function hk_tasks_insert($data){
	    $this->db->insert('hk_tasks', $data);
	    $task_id = $this->db->insert_id();
	    
	    $log_data = array();
	    $log_data ["description"] = "all fields";
	    $log_data ["s_id"] = $task_id;
	    $this->loger->SaveLog ( $log_data, "tasks", "save" );
	    
	    return $task_id;
	}
	
	function hk_tasks2cs_insert($data){
	    $this->db->insert('hk_tasks2cs', $data);
	}
	
	function hk_tasks_update($task_id, $data){
	    $temp_data_old_1 = $this->db->select('*')->get_where('hk_tasks', array('id' => $task_id))->row_array();
	    
	    $this->db->where('id', $task_id);
	    $this->db->update('hk_tasks', $data);

	    $temp_data_new_1 = $this->db->select('*')->get_where('hk_tasks', array('id' => $task_id))->row_array();
	    
	    $log_data = array();
	    $log_data ["description"] = $this->loger->StoreDescription ( $temp_data_old_1, $temp_data_new_1 );  
	    $log_data ["s_id"] = $task_id;
	    $this->loger->SaveLog ( $log_data, "tasks", "edit" );
	}
	
	function hk_tasks_delete($task_id){
	    $this->hk_tasks2cs_delete($task_id);
	    
	    $this->db->where('id', $task_id);
	    $this->db->delete('hk_tasks');
	    
	    // log
	    $log_data = "";
	    $log_data ["description"] = "task_id: $task_id";
	    $log_data ["s_id"] = $task_id;
	    $this->loger->SaveLog ( $log_data, "tasks", "delete" );
	}
	
	function hk_tasks2cs_delete($task_id){
	    $this->db->where('task_id', $task_id);
	    $this->db->delete('hk_tasks2cs');
	}

	function set_btn_zavershyt($id) {
		$this->frontdesk->MonopolyMode();
		$sql = "UPDATE tbl_tasks SET status = 3 WHERE id = ".$id;
		$query = $this->db->query( $sql );
	}

	function set_btn_prinat($id) {
		$this->frontdesk->MonopolyMode();
		$sql = "UPDATE tbl_tasks SET status = 2 WHERE id = ".$id;
		$query = $this->db->query( $sql );
	}

	function sendemail($data) {
		if ($data["assignedto"] <> ""){
			$sql = "SELECT login, fullname, lastname  FROM users WHERE id = ".$data["assignedto"];
			$query = $this->db->query( $sql );
			//$query = $this->db->get('tbl_tasks', $start, $items_per_page);

			if ($query->num_rows() > 0)
			{
				$row = $query->row();
				$email = $row->login;
				$fullname = $row->fullname;
				$lastname = $row->lastname;
			}else{
				die("Не верный емейл!");
			}
		}else{
			$fullname = "Все";
			$lastname = "";
		}

		$sql = "SELECT fullname, lastname  FROM users WHERE id = ".$_SESSION ['user']["id"];
		$query = $this->db->query( $sql );
		//$query = $this->db->get('tbl_tasks', $start, $items_per_page);

		if ($query->num_rows() > 0)
		{
			$row = $query->row();
			$createdby_fullname = $row->fullname;
			$createdby_lastname = $row->lastname;
		}
		$tasks_statuses_config = $this->config->item("tasks_statuses");
		$status_select = $tasks_statuses_config[$data["status"]];
		$data_msg = array ("duedate" => $data["duedate"], "subject" => $data["subject"],
		"description" => $data["description"],"status" => $status_select, 
		"firstname" => $fullname, "lastname" => $lastname, 
		"createdby_firstname" => $createdby_fullname, "createdby_lastname" => $createdby_lastname);
		$message = $this->parser->parse('templates/task_email.html', $data_msg, true);
		$message = iconv("utf-8", "windows-1251", $message);
		//$message = "<h1>Добро пожаловать</h1><br><b>Ваш логин: ". $data["login"]."</b><br><b>Ваш пароль: ". $new_password_1."</b>";
		//$message = iconv("utf-8", "windows-1251", $message);
		$email_name = $this->config->item('email_name');
		$email_password = $this->config->item('email_password');
		//echo $data["login"]."<br>";
		//echo $email_name."<br>";
		//echo $email_password."<br>";
		require_once('class.phpmailer.php');
		//$path_img='/var/vhosts/desks.hottour24.com.ua/html/images/';

		//include("class.smtp.php"); // optional, gets called from within class.phpmailer.php if not already loaded
		//echo $email;
		//die();
		if(isset($email)){
			$mail = new PHPMailer(true); // the true param means it will throw exceptions on errors, which we need to catch

			$mail->IsSMTP(); // telling the class to use SMTP

			try {
				//$mail->Host       = "mail.yourdomain.com"; // SMTP server
				$mail->SMTPDebug  = 2;                     // enables SMTP debug information (for testing)
				$mail->SMTPAuth   = true;                  // enable SMTP authentication
				$mail->SMTPSecure = "ssl";                 // sets the prefix to the servier
				$mail->Host       = "smtp.gmail.com";      // sets GMAIL as the SMTP server
				$mail->Port       = 465;                   // set the SMTP port for the GMAIL server
				$mail->Username   = $email_name;  // GMAIL username
				$mail->Password   = $email_password;            // GMAIL password
				$mail->AddReplyTo($email_name, '');
				//$mail->AddAddress('it@limodels.com.ua', '');
				$mail->AddAddress($email, '');
				$mail->SetFrom($email_name, '');
				$mail->AddReplyTo($email_name, '');
				$mail->Subject = iconv("utf-8", "windows-1251","Задача");
				$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!'; // optional - MsgHTML will create an alternate automatically
				$mail->MsgHTML($message);

				$mail->Send();
				$mail->ClearAllRecipients();
				//die ( "<meta http-equiv='refresh' content='0;url=/home'>" );
			} catch (phpmailerException $e) {
				echo $e->errorMessage(); //Pretty error messages from PHPMailer
			} catch (Exception $e) {
				echo $e->getMessage(); //Boring error messages from anything else!
			}
		}
	}

       function get_time_arr(){
           $return_data = array();
           $return_data[0] = '00:00';
           $return_data[1] = '00:30';
           $return_data[2] = '01:00';
           $return_data[3] = '01:30';
           $return_data[4] = '02:00';
           $return_data[5] = '02:30';
           $return_data[6] = '03:00';
           $return_data[7] = '03:30';
           $return_data[8] = '04:00';
           $return_data[9] = '04:30';
           $return_data[10] = '05:00';
           $return_data[11] = '05:30';
           $return_data[12] = '06:00';
           $return_data[13] = '06:30';
           $return_data[14] = '07:00';
           $return_data[15] = '07:30';
           $return_data[16] = '08:00';
           $return_data[17] = '08:30';
           $return_data[18] = '09:00';
           $return_data[19] = '09:30';
           $return_data[20] = '10:00';
           $return_data[21] = '10:30';
           $return_data[22] = '11:00';
           $return_data[23] = '11:30';
           $return_data[24] = '12:00';
           $return_data[25] = '12:30';
           $return_data[26] = '13:00';
           $return_data[27] = '13:30';
           $return_data[28] = '14:00';
           $return_data[29] = '14:30';
           $return_data[30] = '15:00';
           $return_data[31] = '15:30';
           $return_data[32] = '16:00';
           $return_data[33] = '16:30';
           $return_data[34] = '17:00';
           $return_data[35] = '17:30';
           $return_data[36] = '18:00';
           $return_data[37] = '18:30';
           $return_data[38] = '19:00';
           $return_data[39] = '19:30';
           $return_data[40] = '20:00';
           $return_data[41] = '20:30';
           $return_data[42] = '21:00';
           $return_data[43] = '21:30';
           $return_data[44] = '22:00';
           $return_data[45] = '22:30';
           $return_data[46] = '23:00';
           $return_data[47] = '23:30';
           
           return $return_data;
       }
       
       function get_task_statuses(){
           return $this->db->select('*')->get('hk_task_statuses')->result_array();
       }
       
       function delete_cs_tasks($data){
           list ( $year, $month, $day ) = explode ( "-", $data ['datein'] );
           $intdatein = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
           list ( $year, $month, $day ) = explode ( "-", $data ['dateout'] );
           $intdateout = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
           $room_id = $data['room_id'];
           if ($room_id === null) {
               $room_id = 0;
           }
           $sql = "SELECT hk_tasks.id as task_id FROM hk_tasks INNER JOIN hk_tasks2cs ON hk_tasks2cs.task_id = hk_tasks.id
                   WHERE hk_tasks.status = 1 AND hk_tasks2cs.intdate >= $intdatein AND hk_tasks2cs.intdate <= $intdateout AND hk_tasks2cs.room_id = ".$room_id;
           $query = $this->db->query ( $sql );
           if ($query->num_rows () > 0) {
               foreach ( $query->result () as $row ) {
                  $this->db->where('task_id', $row->task_id);
                  $this->db->delete('hk_tasks2cs');
                  
                  $this->db->where('id', $row->task_id);
                  $this->db->delete('hk_tasks');
               }
           }
           
       }
       
       function get_tasktype($type_id){
           return $this->db->select('*')->get_where('hk_task_types', array('id'=>$type_id))->row();
       }
       
       function get_tasksubtype($subtype_id){
           return $this->db->select('*')->get_where('task_subtypes', array('id'=>$subtype_id))->row();
       }
       
       function insertTaskType($data){
           $this->db->insert('hk_task_types', $data);
           $task_id = $this->db->insert_id();
       }
       
       function updateTaskType($data, $id){
           $this->db->where('id', $id);
           $this->db->update('hk_task_types', $data);
       }
       
       function deleteTaskType($type_id){
           $this->db->where('id', $type_id);
            $this->db->delete('hk_task_types');
       }
       
       function insertTaskSubType($data){
           $this->db->insert('task_subtypes', $data);
           $task_id = $this->db->insert_id();
       }
        
       function updateTaskSubType($data, $id){
           $this->db->where('id', $id);
           $this->db->update('task_subtypes', $data);
       }
        
       function deleteTaskSubType($type_id){
           $this->db->where('id', $type_id);
           $this->db->delete('task_subtypes');
       }
       
       function get_task_icons(){
           $icons_array = array();
           $icons_array[1]['value'] = 1;
           $icons_array[1]['icon_class'] = "fa fa-wrench";
           $icons_array[1]['checked'] = "";
           
           $icons_array[2]['value'] = 2;
           $icons_array[2]['icon_class'] = "fa fa-plus";
           $icons_array[2]['checked'] = "";
           
           $icons_array[3]['value'] = 3;
           $icons_array[3]['icon_class'] = "fa fa-refresh";
           $icons_array[3]['checked'] = "";
           
           $icons_array[4]['value'] = 4;
           $icons_array[4]['icon_class'] = "fa fa-magic";
           $icons_array[4]['checked'] = "";
           return $icons_array;
       }
}

?>