<?php
//https://docs.google.com/document/d/1VdkfyzGAoIMJWt9hP1g5IbON0a-TMmda6H3nsO0Y5-o/edit#
class Rro_vchasno_mdl extends CI_Model {
    const PROVIDER_ID = RROVCHASNO_ID;
    private $token;
    private $api_version = 'v3';
    private $schema_version = 6;
    private $api_urls;
    private $fiscal_tasks = array(  //Тип фискального задания:
        'open_shift'    => 0,       //0 - открытие смены,
        'payment_check' => 1,       //1 - продажный чек,
        'refund_check'  => 2,       //2 - возвратный чек,
        'cash_in'       => 3,       //3 - служебный внос денег,
        'cash_out'      => 4,       //4 - служебный вынос денег,
        'x_report'      => 10,      //10 - X-отчет,
        'close_shift'   => 11,      //11 - Z-отчет
        'get_status'    => 18,      //18 - Статус фискальника
    );
    private $default_notification_channel_id = 0;//email
    private $customer_notification_channels = array(
        'email',
        'sms',
        'viber',
        'cascade'//попробовать отправить через Viber, если у пользователя нет Viber - отправить SMS.
    );

    public  $api_error_code_descriptions = array(
        401 => 'Запит з невірними авторизаційними даними',
        500 => 'Непередбачена помилка на стороні сервісу Вчасно.Каса',
        1001 => 'Помилка валідації вхідних даних',
        1006 => 'Внутрішня помилка сервісу Вчасно.Каса, повинна бути виправлена технічною командою',
        1011 => 'Об\'єкт не знайдений в базі (може стосуватися користувача/компанії/каси)',
        1013 => 'Для вхідних даних не реалізовано функціонал (Not Implemented Error)',
        1015 => 'Каса зайнята попереднім запитом (Lock Error)',
        1016 => 'Перевищено таймаут в 70сек на обробку запиту',
        1017 => 'Дія заборонена (Action not allowed error)',
        2000 => 'Базова помилка, може бути пов\'язана з різними причинами (дивитись значення поля “errortxt”)',
        2001 => 'Помилка зв\'язку з ДФС',
        2002 => 'Запит в ДФС перевищив допустимий тайм-аут',
        2003 => 'Отримано код відповіді від ДФС, котрий вважається "випадковою помилкою"',
        2004 => 'Отримано код критичної помилки при роботі з ДФС, запит виконати не можливо (більш точний опис причини дивитись в полі “errortxt”)',
        2005 => 'Каса (ПРРО) в стані колізії',
        2006 => 'Помилка при перевірці хешів чеків',
        2007 => 'Необхідно вікрити зміну',
        2008 => 'Необхідно закрити зміну',
        2009 => 'ПРРО заблоковано',
        2010 => 'Помилка при спробі змінити режим роботи каси онлайн/офлайн',
    );

    public static $tax_groups = array(
        '1' => 'ПДВ 20%',
        '2' => 'Без ПДВ',
        '3' => 'ПДВ 20% + акциз 5%',
        '4' => 'ПДВ 7%',
        '5' => 'ПДВ 0%',
        '6' => 'Без ПДВ + акциз 5%',
        '7' => 'Не є об`єктом ПДВ',
        '8' => 'ПДВ 20% + ПФ 7.5%',
        '9' => 'ПДВ 14%'
    );

    public static $pay_types = array(
        '0' => 'Готівка',
        '1' => 'Безготівка',
        '2' => 'Картка',
        '3' => 'Передплата',
        '4' => 'Післясплата',
        '5' => 'Кредит',
        '6' => 'Сертифікат',
    );

	public function __construct() {
		parent::__construct ();

		    $this->ep = $this->get_endpoint();
		    $this->api_urls = (object) array(
		        'last_check' => "{$this->ep}/{$this->api_version}/fiscal/last-check",
		        'notify_customer' => "{$this->ep}/{$this->api_version}/notifications/checks",
		        'execute_fiscal_operation' => "{$this->ep}/{$this->api_version}/fiscal/execute",
		        'get_check_task' => "{$this->ep}/{$this->api_version}/check-task",
		    );
		    $this->token = $this->get_token();
	}

	public function get_token(){
	    $tbl = 'rro_partner2provider';
	    $token_query = $this->db->select('token_vchasno')->get_where($tbl, array('provider_id' => self::PROVIDER_ID))->row();
	    $token = isset($token_query->token_vchasno) ? $token_query->token_vchasno : '';
	    //return 'zySHS0VG_dINim4npxSotGVRW59lwSrV1Bo5rj3orkW42V1hjH_n_UaCQDFoNyVY';
	    return $token;
	}

	public function set_token($token = null){
	    $this->token = $token;
	}

	public function return_token(){
	    return $this->token;
	}

	private function get_endpoint (){
	    $endpoint = 'https://kasa.vchasno.ua/api';
	    return $endpoint;
	}

	public function get_cashier_auth_data (){
	    $tbl = 'rro_cashier2casa';
	    $user_id = $_SESSION ['user']["id"];

	    $cashier = array(
	        'login' => '',
	        'password' => ''
	    );
	    $cashier_set = $this->db->get_where($tbl, array('user_id' => $user_id))->row();
	    if ($cashier_set) {
	        $cashier = array(
	            'login' => $cashier_set->login,
	            'password' => $cashier_set->password
	        );
	    }
	    return $cashier;
	}

	public function isactive_rro_module (){
		return $this->releases->rro_activity();
	}

	private function make_base_fiscal_request_body($p)
	{
	    $task = $this->fiscal_tasks[$p['fiscal_task']];
        $body = array(
            'ver' => $this->schema_version,
            'source' => 'VCD-1876',// md5('otelms-' . time()),//Название (имя) источника задания, произвольная строка. Служит для лучшей идентификации записей в логе. Может быть пустым.
            'device' => '',// 	Идентификатор устройства (фискальный номер). Необязательное поле, можно передавать пустую строку.
            'tag' => '',//Метка задания для идентификации ответа (к какому заданию относится ответ). Может быть произвольным. При передаче пустого значения, сервером будет сгенерирована случайная строка для этого поля
            'dt' => date('YmdHi'),// 	Дата и время задания в формате строки: YYYYMMDDHHMM Используется как дата/время для фискального чека.
            'token' => $this->token,// 	Токен для подключения, генерируется в в свойствах устройства. Служит для авторизации.
            'type' => 1,// Тип задания:// 0 = поиск по tag-у уже выполненного в транзакционном режиме задания и повторный возврат результата// 1 = фискальное
            'fiscal' => array(
                'task' => $task,
                'cashier' => '',//Информация про кассира (не обязательно)
            )
        );
        if (in_array($task, array(1, 2))) {
            $body['fiscal']['receipt'] = array();//Содержимое чека (для типов заданий 1 или 2) 1 - продажный чек, 2 - возвратный чек,
        }
        if (in_array($task, array(3, 4))) {
            $body['fiscal']['cash'] = array();//Объект “cash” (описание - ниже). Внос/вынос денег (для типов заданий 3 или 4) 3 - служебный внос денег, 4 - служебный вынос денег,
        }
	    return $body;
	}

	private function register_check($data) {
	    if (isset($data['pay_or_ref']) && $data['pay_or_ref']) {//so rufund branch
	        $body = $data['check_strings'];//already prepeared from strict checkstrings
	    }else {
	        $body = $this->make_base_fiscal_request_body(array('fiscal_task' => 'payment_check'));
	        $body['fiscal']['receipt'] = $data['check_strings'];
	    }
	    $params = array(
	        'post_data' => $body,
	        'api_url' => $this->api_urls->execute_fiscal_operation
	    );
	    return $this->request_api($params);
	}

	public function get_status()
	{
	    $body = $this->make_base_fiscal_request_body(array('fiscal_task' => 'get_status'));
	    $params = array(
	        'post_data' => $body,
	        'api_url' => $this->api_urls->execute_fiscal_operation
	    );
	    $result = $this->request_api($params);
	    $response = $result->curl_response;
	    return $response;
	}

	public function open_shift()
	{
	    $body = $this->make_base_fiscal_request_body(array('fiscal_task' => 'open_shift'));
	    $params = array(
	        'post_data' => $body,
	        'api_url' => $this->api_urls->execute_fiscal_operation
	    );
	    $result = $this->request_api($params);
	    $response = $result->curl_response;
	    return $response;
	}

	public function close_shift()
	{
	    $body = $this->make_base_fiscal_request_body(array('fiscal_task' => 'close_shift'));
	    $params = array(
	        'post_data' => $body,
	        'api_url' => $this->api_urls->execute_fiscal_operation
	    );
	    $result = $this->request_api($params);
	    $response = $result->curl_response;
	    return $response;
	}

	public function x_report()
	{
	    $body = $this->make_base_fiscal_request_body(array('fiscal_task' => 'x_report'));
	    $params = array(
	        'post_data' => $body,
	        'api_url' => $this->api_urls->execute_fiscal_operation
	    );
	    $result = $this->request_api($params);
	    $response = $result->curl_response;
	    return $response;
	}

	public function cash_in()
	{
	    $sess_data = $this->session->userdata('rro_func_data_cash_in');
	    if ($sess_data) {
	        $body = $this->make_base_fiscal_request_body(array('fiscal_task' => 'cash_in'));
	        $body['fiscal']['cash']['sum'] = $sess_data['amount'];
	        $body['fiscal']['cash']['type'] = $sess_data['pay_type'];
	        $params = array(
	            'post_data' => $body,
	            'api_url' => $this->api_urls->execute_fiscal_operation
	        );
	        $result = $this->request_api($params);
	        $response = $result->curl_response;
	    }else{
	        $response = 'No session data!';
	    }

	    return $response;
	}

	public function cash_out()
	{
	    $sess_data = $this->session->userdata('rro_func_data_cash_out');
	    if ($sess_data) {
	        $body = $this->make_base_fiscal_request_body(array('fiscal_task' => 'cash_out'));
	        $body['fiscal']['cash']['sum'] = $sess_data['amount'];
	        $body['fiscal']['cash']['type'] = $sess_data['pay_type'];
	        $params = array(
	            'post_data' => $body,
	            'api_url' => $this->api_urls->execute_fiscal_operation
	        );
	        $result = $this->request_api($params);
	        $response = $result->curl_response;
	    }else{
	        $response = 'No session data!';
	    }
	    return $response;
	}

	public function last_check(){
	    $params = array(
	        'api_url' => $this->api_urls->last_check
	    );
	    $result = $this->request_api($params, 'GET');
	    $response = $result->curl_response;
	    return $response;
	}

	public function get_check_task($check_fiscal_number=null) {
	    $params = array(
	        'api_url' => "{$this->api_urls->get_check_task}/$check_fiscal_number"
	    );
	    $result = $this->request_api($params, 'GET');
	    $response = $result->curl_response;
	    return $response;
	}

	private function request_api($p, $method='POST') {

	    $headers = array("Authorization: $this->token", 'Content-Type: application/json');
	    $url = $p['api_url'];
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_URL, $url);
	    curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
	    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
	    curl_setopt($ch, CURLOPT_TIMEOUT, 0);
	    curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
	    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

	    switch (strtoupper($method)) {
	        case 'GET':
	            curl_setopt($ch, CURLOPT_HTTPGET, true);
	        break;

	        default://POST
	            curl_setopt($ch, CURLOPT_POST, true);
	            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($p['post_data']));
	        break;
	    }
	    $curl_response = curl_exec($ch);
	    $curl_info = curl_getinfo($ch);
	    curl_close($ch);

	    $log_id = $this->log_api_req_res_operations(array('req'=>json_encode($p), 'res'=>$curl_response));

	    $response = (object) array(
	        'curl_request' => $p,
	        'curl_response' => $curl_response,
	        'curl_info' => (object)$curl_info,
	        'api_operation_log_id' => $log_id,
	    );
	    return $response;
	}

// 	private function api_post($p) {
// 	    $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $p['api_url']);
//         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: $this->token", 'Content-Type: application/json'));
//         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//         curl_setopt($ch, CURLOPT_TIMEOUT, 0);
//         curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
//         curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
//         curl_setopt($ch, CURLOPT_POST, true);
//         curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($p['post_data']));
//         $curl_response = curl_exec($ch);
//         $curl_info = curl_getinfo($ch);
//         curl_close($ch);

//         $log_id = $this->log_api_req_res_operations(array('req'=>json_encode($p), 'res'=>$curl_response));

//         $response = (object) array(
//             'curl_request' => $p,
//             'curl_response' => $curl_response,
//             'curl_info' => (object)$curl_info,
//             'api_operation_log_id' => $log_id,
//         );
//         return $response;
// 	}

// 	private function api_get($p) {
// 	    $ch = curl_init();
// 	    curl_setopt($ch, CURLOPT_URL, $p['api_url']);
// 	    curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
// 	    curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: $this->token", 'Content-Type: application/json'));
// 	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
// 	    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
// 	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
// 	    curl_setopt($ch, CURLOPT_HTTPGET, true);
// 	    $curl_response = curl_exec($ch);
// 	    $curl_info = curl_getinfo($ch);
// 	    curl_close($ch);

// 	    $log_id = $this->log_api_req_res_operations(array('req'=>json_encode($p), 'res'=>$curl_response));

// 	    $response = (object) array(
// 	        'curl_response' => $curl_response,
// 	        'curl_info' => (object)$curl_info,
// 	        'api_operation_log_id' => $log_id,
// 	    );
// 	    return $response;
// 	}

	public function unicode_decode($str) {
	    return preg_replace_callback('/\\\\u([0-9a-fA-F]{4})/', function ($match) {
	        return mb_convert_encoding(pack('H*', $match[1]), 'UTF-8', 'UCS-2BE');
	    }, $str);
	}

	private function log_api_req_res_operations($p = array('req'=>null, 'res'=>null)){
	    $p['provider_id'] = self::PROVIDER_ID;
	    $p['req'] = $this->unicode_decode($p['req']);
	    $p['res'] = $this->unicode_decode($p['res']);
	    $tbl = 'rro_log_api_req_res';
	    $this->db->insert($tbl, $p);
	    return $this->db->insert_id();
	}

	private function make_check_strings($payment_data) {
	    $reservation_id = $payment_data['reservation_id'];
	    $pay_id = $payment_data['pay_id'];
	    $partner_id = $payment_data['id_partner'];
	    $partner_with_nds = (bool) $this->db->select('nds')->get_where('partners', array('id'=>$partner_id))->row()->nds;
	    $is_refund = isset($payment_data['pay_or_ref']) && $payment_data['pay_or_ref'] == 1 ? true : false;

	    $receipt = $receipt_rows = $receipt_pays = $errors = array();

        if ($is_refund) {//refund
 	        $tbl = 'rro_checks';
 	        $check_data = $this->db->get_where($tbl, array('pay_or_ref_id'=>$pay_id, 'pay_or_ref' => 0))->row();//$this->db->get_where($tbl, array('id'=>$check_id))->row();
            if ($check_data){
                if ($check_data->fiscal_provider_id == self::PROVIDER_ID) {
                    $CheckAllData = json_decode($check_data->CheckAllData);
                    $receipt = $this->get_check_task($CheckAllData->info->doccode);
                    $receipt = json_decode($receipt);
                    $receipt = $receipt->task;
                    $receipt->fiscal->task = 2;
                    $receipt->dt = date('YmdHi');
                    unset($receipt->source, $receipt->tag);
                }else {
                    array_push($errors, 'Чек продажу фіскалізовано іншою ПРРО! Відміна не можлива.');
                }
            }else {
                array_push($errors, '500 : Error HMS : refund strings retrive error!');
            }
            if(!empty($errors)){
                $receipt = array(
                    'errors' 	=> $errors,
                );
            }
        }else{//payment
            $items = array();
            $where_str = " check_payment_id = $pay_id";
            $query_result = $this->db->query(
                "SELECT item_id as service_id, SUM(check_payment_items.amount) as service_amount, item_service_table_id as tbl_id,
                services_types.name as name_s, services_types.kind_id, services.count, services_types.tax as service_tax,
                services_types_main.name as name_sm, services_types_main.id as sm_type_id, services_types_main.tax as service_main_tax,
                taxes_fees2property.name as name_tf, services_tf.taxes_fees_id
                FROM check_payment_items
                LEFT JOIN services_main ON services_main.id = check_payment_items.item_id
                LEFT JOIN services_types_main ON  services_types_main.id = services_main.type
                LEFT JOIN services ON services.id = check_payment_items.item_id
                LEFT JOIN services_types ON  services_types.id = services.type
                LEFT JOIN services_tf ON services_tf.id = check_payment_items.item_id
                LEFT JOIN taxes_fees2property ON taxes_fees2property.id = services_tf.taxes_fees_id
                WHERE $where_str
                GROUP BY service_id")->result();

            foreach ($query_result as $row){
                switch ($row->tbl_id) {
                    case 1: // services
                        array_push($items, array(
                        'services_id' => $row->service_id,
                        'count' => $row->count,
                        'amount' => $row->service_amount,
                        'name' => $row->name_s,
                        'tax' => $row->service_tax,
                        ));
                        break;
                    case 2://main services
                        array_push($items, array(
                        'services_id' => $row->service_id,
                        'count' => 1,
                        'amount' => $row->service_amount,
                        'name' => $row->sm_type_id == 1 ? $this->make_main_service1_name(array('reservation_id' => $reservation_id)) : $row->name_sm,
                        'tax' => $row->service_main_tax,
                        ));
                        break;
                    case 3: // services tax & fees
                        array_push($items, array(
                        'services_id' => $row->service_id,
                        'count' => 1,
                        'amount' => $row->service_amount,
                        'name' => $row->name_tf,
                        'tax' => null,
                        ));
                        break;
                }
            }

            $all_paied_sum = 0;
            foreach ($items as $item){
                array_push($receipt_rows, array(
                    'code' => $item ['services_id'],   // Строка, Код товара в учетной системе предприятия
                    //'code1' => '',  // Строка, Дополнительный код товара (штрихкод)
                    //'code2' => '',  // Строка, Дополнительный код товара (Код УКТВЭД) Код числовой, допустимая длина - до 10 символов
                    //'code3' => '',  // Строка, Дополнительный код товара (Код ДКПП)
                    //'code_a' => '', // Строка, Код акцизной марки товара
                    'name' => $item ['name'],   // Строка, Название товара
                    'cnt' => (float) $item ['count'],    // Дробное, Количество (не больше 3-х знаков после запятой)
                    'price' => (float) $item ["amount"] / $item ["count"],  // Дробное, Цена (2-а знака после запятой). Может быть пустым, тогда считается автоматом путем деления итога строки на количество и математическим округлением
                    'disc' => (float) 0,   // Дробное, Суммовая скидка на строку (2-а знака после запятой)
                    'cost' => (float) $item ['amount'],   // Дробное, Итог строки до скидки (2-а знака после запятой). Фактически это цена умноженная на количество и уже округленное до 2-х знаков после запятой. Может быть пустым, тогда считается автоматом путем умножения количества на цену и математическим округлением
                    'taxgrp' => $partner_with_nds ? (int) $this->make_goods_taxgrp(array('tax_val' => $item ['tax'], 'partner_id' => $partner_id)) : (int) array_search('Без ПДВ', self::$tax_groups), // Целое, Код налоговой группы. Дефолтные группы: self::$tax_groups
                    'comment' => '',// Строка, Комментарий на строку

                ));
                $all_paied_sum += $item ["amount"];
            }
//             if(!$all_paied_sum){
//                 array_push($errors, 'Cума оплати більша вартості всіх товарів та послуг.');
//             }

            $receipt_pays = array(array(
                'type' => (int) $this->get_transformed_payment_type_form_id($pay_id), //Целое, Код типа оплаты. Дефолтные коды: self::$pay_types
                'sum' => (float) $all_paied_sum, //Дробное, Сумма оплаты (2-а знака после запятой)
                'currency' => '', //Строка, Валюта платежа (коротко) если передать пустое значение - автоматически заполнится “грн”
                'comment' => '', //Строка, Комментарий на строку
                'change' => (float) 0, //Дробное, Сдача (для оплаты наличными). ВНИМАНИЕ, для корректного внесения оплаты наличными со сдачей:
                                // В поле sum нужно вносить сумму, которая ИДЕТ В ЗАЧЕТ
                                // В поле change - сдачу
                                // Общая сумма, которая получена от покупателя рассчитывается внутри как sum+change
//                 'paysys' => '', //Строка, Название платежной системы (для оплаты банковской картой)
//                 'rrn' => '', //Строка, Код транзакции (для оплаты банковской картой)
//                 'cardmask' => '', //Строка, Номер карты замаскированный (для оплаты банковской картой)
            ));
            if(empty($errors)){
                $receipt = array(
                    'sum' => (float)$all_paied_sum,    //Дробное, Сумма чека (2 знака после запятой) с учетом всех скидок
                    'round' => (float) 0,             //Дробное, Сумма округления (входит в сумму чека). На эту сумму должна отличаться сумма чека от сумм по всем видам оплат
                    'comment_up' => '',         //Строка, Комментарий, который печатается перед списком товаров (Не обязательно)
                    'comment_down' => '',       //Строка, Комментарий, который печатается в нижней части чека (Не обязательно)
                    'rows' => $receipt_rows,    //Массив объектов, Строки чека
                    'pays' => $receipt_pays,    //Массив объектов, Оплаты чека (по видам)
                );
            }else {
                $receipt = array(
                    'errors' 	=> $errors,
                );
            }
        }

        return $receipt;
	}

	private function make_main_service1_name($in_data) {
	    $result =  'Проживання.';
	    $res_id = $in_data['reservation_id'];
	    $sql = "SELECT CONCAT('Номер: ', categories.name, ', проживання: ', t1.datein, ' - ', t1.dateout) AS name
        	    FROM `deskofreservation` AS t1
        	    JOIN rooms ON rooms.id = t1.room_id
        	    JOIN categories ON categories.id = rooms.category_id
        	    WHERE t1.id = $res_id";
	    $query_res = $this->db->query($sql)->row();
	    if ($query_res && isset($query_res->name)){
	        $result .= " $query_res->name";
	    }
        return $result;
	}

	private function make_goods_taxgrp($p = array('tax_val'=>null)) {
	    $taxgrp_name = 'Без ПДВ';
	    if ($p['tax_val'] && $p['tax_val'] > 0) {
	        $taxgrp_name = 'ПДВ 20%';
	    }
	    return array_search($taxgrp_name, self::$tax_groups);
	}

	private function log_check_operation($log_data) {
	    $log_tbl = 'rro_log_checks_operation';
	    $where_arr = array(
	        'pay_or_ref_id' => $log_data['pay_or_ref_id'],
	        'pay_or_ref' => $log_data['pay_or_ref']
	    );
        $id_log_tbl = $this->db->select('id')
            ->get_where($log_tbl, $where_arr)
            ->row();
        if ($id_log_tbl) {
            $this->db->update($log_tbl, $log_data, array('id'=>$id_log_tbl->id));
        }else {
            $this->db->insert($log_tbl, $log_data);
        }
	}

	private function save_check_data($check_data) {
	    $tbl = 'rro_checks';
	    $this->db->insert($tbl, $check_data);
	}

	public function check_processing($data) {
// 	    $data = array(
// 	        'reservation_id' => $post['reservation_id'],
// 	        'id_partner' => $post['id_partner'],
// 	        'pay_id' => $pay_id,
//          'pay_or_ref' ?
//          'ref_id' ?
// 	    );
	    $header_msg_text = 'Реєстрація фіскального чеку ПРРО «Вчасно.Каса»';
	    $pay_or_ref = isset($data['pay_or_ref']) ? $data['pay_or_ref'] : 0;
	    $pay_or_ref_id = $pay_or_ref ? $data['ref_id'] : $data['pay_id'];
	    $check_already_exist_query = $this->db->select('id')->get_where('rro_checks', array('pay_or_ref_id'=>$pay_or_ref_id, 'pay_or_ref'=>$pay_or_ref))->row();
	    if ($check_already_exist_query) {
	        $result_check_processing = true;
	        $header_msg_text .= '<br>Чек уже був успішно зареєстрований.';
	    }else{
	        $check_strings = (array) $this->make_check_strings ( $data );
	        if(isset($check_strings['errors'])){
	            $result_check_processing = false;
	            $header_msg_text .= '<br>Запит на реєстрацію чека не відправлено!<br>HMS. Помилки формування чеку:';
	            foreach ($check_strings['errors'] as $error) {
	                $header_msg_text .= "<br>$error";
	            }
	        }else {
	            $api_response = $this->register_check ( array('check_strings' => $check_strings, 'pay_or_ref' => $pay_or_ref));
	            $this->log_check_operation(array(
	                'pay_or_ref_id' => $pay_or_ref_id,
	                'pay_or_ref' => $pay_or_ref,
	                'strings' => json_encode($check_strings),
	                'response' => $api_response->curl_response,
	            ));
	            if (!isset($api_response->curl_response) || !json_decode($api_response->curl_response)) {
	                $result_check_processing = false;
	                $header_msg_text .= '<br>HMS. Відсутність або неформатність відповіді провайдера послуги. Стан чеку невизначений!';
	            }else {
	                $api_res_decoded = json_decode($api_response->curl_response);
	                if (isset($api_res_decoded->res) && $api_res_decoded->res > 0){
	                    $result_check_processing = false;
	                    $header_msg_text .= '<br>Чек не зареєстровано!';

                            // [res_action] => 3

	                    $header_msg_text .= '<br>'.$this->get_api_error_description($api_res_decoded->res);
                        $header_msg_text .= '<br>' . $api_res_decoded->errortxt;
	                }else{//succesfull register check
	                    $result_check_processing = true;
	                    $header_msg_text .= '<br>Чек успішно зареєстрований.';
	                    $this->save_check_data(array(
	                        'pay_or_ref_id' => $pay_or_ref_id,
	                        'pay_or_ref' => $pay_or_ref,
	                        'fiscal_provider_id' => self::PROVIDER_ID,
	                        'CheckAllData' => $api_response->curl_response,
	                    ));
	                    $check_FN  = $api_res_decoded->info->doccode;
	                    $notification_result_txt = $this->notify_customer(array('reservation_id' => $data['reservation_id'], 'check_id' => $check_FN));
	                    $header_msg_text .= "<br>$notification_result_txt";
	                }
	            }
	        }
	    }
	    $this->session->set_userdata ( array('header_msg_text'=>$header_msg_text));
	    return $result_check_processing;
	}

	public function get_api_error_description($code=null){
	    $description = '';
	    if ($code) {
	        if (isset($this->api_error_code_descriptions[$code])) {
	            $description = $this->api_error_code_descriptions[$code];
	        }elseif ((int)($code/500) == 1) {
	            $description = $this->api_error_code_descriptions[500];
	        }else {
	            $description = "Код помилки $code відсутній в описі АРІ.";
	        }
	    }
	    return $description;
	}

	private function get_transformed_payment_type_form_id($pay_id){
	    /* HMS :
	     * id=1 cash, id=2 cashless
	     * VCHSNO:
	     * id=0 cash, id=1 cashless and more self::$pay_types
	     * so return just decrementing
	     */
	    $hms_payment_form_id = 1; // i set def form for cash
        $row = $this->db->select('payment_form_id')
            ->where("payment.id = $pay_id")
            ->from('payment')
            ->join('payment_types', 'payment_types.id = payment.type')
            ->get()
            ->row();
        if ($row) {
            $hms_payment_form_id = $row->payment_form_id;
        }
        return --$hms_payment_form_id;
	}

	private function get_payment_type_form_label($pay_id){
	    $txt_label = ' ';
	    $sql = "SELECT payment_types.name
        	    FROM payment
        	    JOIN payment_types ON payment_types.id = payment.type
        	    WHERE payment.id = $pay_id";
	    $row = $this->db->query($sql)->row();
	    if ($row && isset($row->name)) {
	        $txt_label = $row->name;
	    }
	    return $txt_label;
	}

	public function get_customer_notification_data ($reservation_id = FALSE){
	    $customer = (object)array(
	        'email' => '',//cltelexlv@gmail.com
	        'phone' => ''//+380676703424
        );
	    if ($reservation_id) {
	        $customer_row = $this->db->select('guests.email, guests.phone')
                ->join('guests', 'deskofreservation.guest_id = guests.id', 'left')
                ->get_where('deskofreservation', array('deskofreservation.id' => $reservation_id))->row();

            if ($customer_row) {
                $customer = $customer_row;
            }
	    }
	    return $customer;
	}

	public function fiscalize_Payment($pay_id) {
	    $payment_data = $this->db->select('id_partner, reservation_id')->get_where('payment', array('id'=>$pay_id))->row();
	    if ($payment_data) {
	        $data = array(
	            'reservation_id' => $payment_data->reservation_id,
	            'id_partner' => $payment_data->id_partner,
	            'pay_id' => $pay_id
	        );
	        $this->check_processing($data);
	    }
	}

	public function fiscalize_Refund($ref_id) {
	    $payment_data = $this->db->select('id as pay_id, id_partner, reservation_id')->get_where('payment', array('refund_id'=>$ref_id))->row();
	    if ($payment_data) {
	        $data = array(
	            'reservation_id' => $payment_data->reservation_id,
	            'id_partner' => $payment_data->id_partner,
	            'pay_id' => $payment_data->pay_id,
	            'ref_id' => $ref_id,
	            'pay_or_ref' => 1,
	        );
	        $this->check_processing($data);
	    }
	}

	public function notify_customer($p = array('reservation_id', 'check_id'))
    {
        $reservation_id = isset($p['reservation_id']) ? $p['reservation_id'] : FALSE;
        $check_id = isset($p['check_id']) ? $p['check_id'] : 'TEST_2nGYksDCRNljuQ';
        $rro_send_check_via_sms = $this->hotelix_config->get_record ("rro_send_check_via_sms", "int");
        $channel_id = $rro_send_check_via_sms ? 3 : $this->default_notification_channel_id;
        $channel = $this->customer_notification_channels[$channel_id];
        $customer = $this->get_customer_notification_data($reservation_id);
        switch ($this->default_notification_channel_id) {
            case 0:
                $recepient = $customer->email;
                break;
            default:
                $recepient = $customer->phone;
            break;
        }
        $body = array(
            'recipient' => $recepient,
            'channel' => $channel,
            'check' => $check_id
        );
        $params = array(
            'post_data' => $body,
            'api_url' => $this->api_urls->notify_customer
        );
        $result = $this->request_api($params);
        $response = json_decode($result->curl_response);
        if ($result->curl_info->http_code != 200) {
            $response_txt = 'Сповіщення не відправлено!<br>Причина: '.$response->reason;
            if (isset($response->errors)) {
                $response_txt .= "<br>Помилки:";
                if (is_string($response->errors)) {
                    $response_txt .= "<br>$response->errors";
                }else {
                    foreach ($response->errors as $err_key => $err_value) {
                        $response_txt .= "<br>$err_key - $err_value.";
                    }
                }
            }
        }else {
            $response_txt = "Сповіщення відправлено $response->channel на $response->recipient.";
        }
        return $response_txt;
	}

	public function print_receipt($p) {
	    $check_id = $p['check_id'];
	    $tbl = 'rro_checks';
	    $check_data = $this->db->get_where($tbl, array('id'=>$check_id))->row();
	    if ($check_data){
	        if ($check_data->fiscal_provider_id == self::PROVIDER_ID) {
	            $CheckAllData = json_decode($check_data->CheckAllData);
	            $url = "https://kasa.vchasno.ua/c/{$CheckAllData->info->doccode}";
	            header("Location: $url");
	            exit;
	        }else {
	            echo 'Чек фіскалізований іншим ППРО.';
	        }
	    }
	}
	
	public function get_logs($p = array('limit' => 50)) {
	    echo '<pre>Logs not ready!';
	    die("Died by Andrew at rro_vchasno_mdl.php on 18 груд. 2023 р.  18:08:36");
// 	    $limit = isset($p['limit']) ? $p['limit'] : 50;
// 	    $log_tbl = $this->log_tbl;
// 	    $logs = $this->db->order_by('id DESC')->limit($limit)->get($log_tbl)->result();
	    return $logs;
	}
}