<?php
class Property_model extends CI_model {
    function __construct() {
        parent::__construct ();
        
        $this->load->model ( 'fms_core' );
        $this->load->model ( 'images_core' );
    }
    
    public function get_property_cancellationpolicies_data() {
        $property_cps_tbl = 'dc_cancelationpolicy';
        $cps_list_tbl = 'global_hotelix_common.dc_cancelationpolicy_list';
        $where_arr = array();
        $query_cancellationpolicies = $this->db->select('*')
            ->join($cps_list_tbl, "$property_cps_tbl.dc_cancelation_policy_id = $cps_list_tbl.id")
            ->get_where($property_cps_tbl, $where_arr)
            ->result();
           
        return $query_cancellationpolicies;
    }
    
    public function get_property_mealtype_amenety_codes() {
        return array('173', '6000', '6001');
    }
    
    public function get_hms_properties_data($p = array()) {
        $tbl = 'property_information';
        $property_filds = array(
            'id',
            'property_name',
            'property_name_english',
            'dwelling',
            'property_type',
            'street',
            'additional_information',
            'city',
            'state',
            'post_code',
            'country',
            'gps_coordinates',
            'reception_phone',
            'email',
            'web_address',
            'star_rating',
            'check_in_time',
            'check_out_time',
            'timezone',
            'logo_small',
            'logo_original',
            'property_name_lat',
            'street_lat',
            'additional_information_lat',
            'city_lat',
            'state_lat',
            'range_id',
        );
        
        if (isset($p['property_filds_to_select']) && count($p['property_filds_to_select'])) {
            $property_filds_to_select = $p['property_filds_to_select'];
        }else{
            $property_filds_to_select = array(
                'id',
                'property_name',
                'property_name_lat',
                'dwelling',
                'property_type',
                'post_code',
                'country',
                'gps_coordinates',
                'reception_phone',
                'email',
                'web_address',
                'star_rating',
                'check_in_time',
                'check_out_time',
                'timezone',
                'property_name_lat',
                'street_lat',
                'additional_information_lat',
                'city_lat',
                'state_lat',
            );
        }
        $where_arr = isset($p['hms_prop_id']) ? array('id' => $p['hms_prop_id']) : array();
        $query_properties = $this->db->select(implode(', ', $property_filds_to_select))->get_where($tbl, $where_arr)->result();
        $properties = array();
        foreach ($query_properties as $property) {
            $properties[$property->id] = $property;
        }
        return $properties;
    }
    
    function get_property_data_echannel($property_id = 0){
        $data = array();
        $lang = 'eng';
        $countries = $this->fms_core->get_dict_country("global_fms_base", 1);
        foreach ($countries as $key => $country) {
            if (empty($country['native_name'])) unset($countries[$key]);
        }
        
//         $external_property_image = $this->images_core->get_external_property_image_value();
        
//         if($external_property_image){
//             $tbl_property_images_name = "property_images_registry";
//         }else{
//             $tbl_property_images_name = "property_images";
//         }
        
        $select = "";
        if($property_id > 0){
           $select = " WHERE property_information.id = $property_id";
        }
        
        $dwelling_array = $this->frontdesk_c2->get_property_dwelling();
        $property_types = $this->frontdesk_c2->get_property_types();
        $JobTitles = $this->booking_api_mdl->get_bk_JobTitles();
        
        $desc_languages = array();
        $sql = "SELECT * FROM descriptionlanguages WHERE is_active = 1";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ($query->result() as $row) {
                $desc_languages[$row->id]["id"] = $row->id;
		        $desc_languages[$row->id]["lang_name"] = $row->name_original;//
            }
        }
        
        $property_ameneties = array();
        $sql = "SELECT property_amenety_type.id as amenety_type_id, property_amenety_type.name as amenety_type_name,
                property_ameneties.id as amenety_id, property_ameneties.name as amenety_name, property2ameneties.amenity_id,
                property2ameneties.property_id
                FROM property_amenety_type
                LEFT JOIN property_ameneties ON property_ameneties.type_id = property_amenety_type.id
                LEFT JOIN property2ameneties ON property2ameneties.amenity_id = property_ameneties.id";
        //echo $sql;
        //die();
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            if($row->amenety_id != NULL){
                $property_ameneties[$row->property_id][$row->amenety_type_id]["amenety_type_id"] = $row->amenety_type_id;
                $property_ameneties[$row->property_id][$row->amenety_type_id]["amenety_type_name"] = $this->mlanguages->getdictionaryword("setup_property_c2_description", $lang, "{-" . $row->amenety_type_name . "-}");
                $property_ameneties[$row->property_id][$row->amenety_type_id]["ameneties"][$row->amenety_id]["amenety_id"] = $row->amenety_id;
                $property_ameneties[$row->property_id][$row->amenety_type_id]["ameneties"][$row->amenety_id]["amenety_name"] = $this->mlanguages->getdictionaryword("setup_property_c2_description", $lang, "{-" . $row->amenety_name . "-}");
            }
        }
        
        $contacts_data = array();
        $sql = "SELECT id as contact_id, property_id, GivenName, SurName, Email, Phone_Extension, PhoneNumber, AddressLine, CityName, PostalCode, CountryName,
        ContactProfileType, JobTitle
        FROM contacts";
        //echo $sql;
        //die();
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            if($row->property_id != NULL){
                if(!isset($contacts_data[$row->property_id])){
                    $contacts_data[$row->property_id] = array();
                }
                $job_title_str = '';
                foreach ($JobTitles as $JobTitle) {
                    if ($row->JobTitle == $JobTitle['id']) {
                       $job_title_str = $JobTitle['name'];
                       break;
                    }
                }
                
                array_push($contacts_data[$row->property_id], array(
                    'GivenName' => $row->GivenName,
                    'SurName' => $row->SurName,
                    'Email' => $row->Email,
                    'Phone_Extension' => $row->Phone_Extension,
                    'PhoneNumber' => $row->PhoneNumber,
                    'AddressLine' => $row->AddressLine,
                    'CityName' => $row->CityName,
                    'PostalCode' => $row->PostalCode,
                    'CountryName' => $row->CountryName,
                    'ContactProfileType' => $row->ContactProfileType,
                    'JobTitle' => $job_title_str,
                ));
//                 $contacts_data[$row->property_id]["GivenName"] = $row->GivenName;
//                 $contacts_data[$row->property_id]["SurName"] = $row->SurName;
//                 $contacts_data[$row->property_id]["Email"] = $row->Email;
//                 $contacts_data[$row->property_id]["Phone_Extension"] = $row->Phone_Extension;
//                 $contacts_data[$row->property_id]["PhoneNumber"] = $row->PhoneNumber;
//                 $contacts_data[$row->property_id]["AddressLine"] = $row->AddressLine;
//                 $contacts_data[$row->property_id]["CityName"] = $row->CityName;
//                 $contacts_data[$row->property_id]["PostalCode"] = $row->PostalCode;
//                 $contacts_data[$row->property_id]["CountryName"] = $row->CountryName;
            }
        }
        
        $sql = "SELECT property_information.* FROM property_information $select";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $country = "";
                if (isset($countries[$row->country])) {
                    $country = $countries[$row->country]['native_name'];
                }
                
                $property_type = "";
//                 if (isset($dwelling_array[$row->dwelling])) {
//                     $property_type_clt = $dwelling_array[$row->dwelling]['dwelling_name'];
//                     $property_type = $this->mlanguages->getdictionaryword("setup_property_c2_information", $lang, $property_type_clt);
//                 }
                
                if($row->dwelling > 0){
                    if($row->property_type > 0){
                        if(isset($property_types[$row->dwelling][$row->property_type]))
                            $property_type_clt = $property_types[$row->dwelling][$row->property_type]["property_type_name"];
                            $property_type = $this->mlanguages->getdictionaryword("tbl_property_types", $lang, $property_type_clt);
                    }else{
                        if($row->dwelling == 2){
                            $property_type_clt = $property_types[$row->dwelling][14]["property_type_name"];
                            $property_type = $this->mlanguages->getdictionaryword("tbl_property_types", $lang, $property_type_clt);
                        }
                    }
                }
                
                $international_name_array = $this->internationalfields->get_value("property_custom", $row->id, "international_name");
                $international_summary_array = $this->internationalfields->get_value("property_custom", $row->id, "international_summary");
                $international_space_array = $this->internationalfields->get_value("property_custom", $row->id, "international_space");
                $international_access_array = $this->internationalfields->get_value("property_custom", $row->id, "international_access");
                $international_interaction_array = $this->internationalfields->get_value("property_custom", $row->id, "international_interaction");
                $international_neighborhood_array = $this->internationalfields->get_value("property_custom", $row->id, "international_neighborhood");
                $international_transit_array = $this->internationalfields->get_value("property_custom", $row->id, "international_transit");
                $international_houseRules_array = $this->internationalfields->get_value("property_custom", $row->id, "international_houseRules");
                $international_notes_array = $this->internationalfields->get_value("property_custom", $row->id, "international_notes");
                $international_comment_array = $this->internationalfields->get_value("property_custom", $row->id, "international_comment");
                
                $descriptions  = array();
                foreach ($desc_languages as $lang_cell) {
                    array_push($descriptions, array(
                       'lang_id' => $lang_cell['id'],
                       'lang_name' => $lang_cell['lang_name'],
                       'name' => isset($international_name_array[$lang_cell['id']]) ? $international_name_array[$lang_cell['id']] : '',
                       'summary' => isset($international_summary_array[$lang_cell['id']]) ? $international_summary_array[$lang_cell['id']] : '',
                       'space' => isset($international_space_array[$lang_cell['id']]) ? $international_space_array[$lang_cell['id']] : '',
                       'access' => isset($international_access_array[$lang_cell['id']]) ? $international_access_array[$lang_cell['id']] : '',
                       'interaction' => isset($international_interaction_array[$lang_cell['id']]) ? $international_interaction_array[$lang_cell['id']] : '',
                       'neighborhood' => isset($international_neighborhood_array[$lang_cell['id']]) ? $international_neighborhood_array[$lang_cell['id']] : '',
                       'transit' => isset($international_transit_array[$lang_cell['id']]) ? $international_transit_array[$lang_cell['id']] : '',
                       'houseRules' => isset($international_houseRules_array[$lang_cell['id']]) ? $international_houseRules_array[$lang_cell['id']] : '',
                       'notes' => isset($international_notes_array[$lang_cell['id']]) ? $international_notes_array[$lang_cell['id']] : '',
                       'comment' => isset($international_comment_array[$lang_cell['id']]) ? $international_comment_array[$lang_cell['id']] : ''
                    ));
                }
                $ameneties = isset($property_ameneties[$row->id]) ? $property_ameneties[$row->id] : array();
                $foto = '<img src="/setup_property_c2/view_property_information_foto_small/' . $property_id . '/foto.jpg" alt=""/>';
                $state = $row->state;
                if($state == "{state_value}"){
                    $state = "";
                }
                
                $contact_info = array();
                if(isset($contacts_data[$row->id])){

                    $contact_info = $contacts_data[$row->id];
                }
                
                $age_ranges = array();
                $age_ranges_push = array();
                $sql = "SELECT * FROM `age_ranges_acb`";
                $query = $this->db->query ( $sql );
                if ($query->num_rows () > 0) {
                    foreach ( $query->result () as $row_ages ) {
                        $age_ranges[$row_ages->range_id][$row_ages->id]["id"] = $row_ages->id;
                        $age_ranges[$row_ages->range_id][$row_ages->id]["range_id"] = $row_ages->range_id;
                        $age_ranges[$row_ages->range_id][$row_ages->id]["from"] = $row_ages->from;
                        $age_ranges[$row_ages->range_id][$row_ages->id]["to"] = $row_ages->to;
                    }
                    
                    $age_ranges_push = array();
                    foreach($age_ranges as $range_cell){
                        foreach($range_cell as $ages_cell){
                            switch ($ages_cell['id']) {
                                case 1:
                                    $age_type = 'infant';
                                    break;
                                case 2:
                                    $age_type = 'child';
                                    break;
                                case 3:
                                    $age_type = 'adult';
                                    break;
                            }
                            
                            array_push($age_ranges_push, array(
                                'type' => $age_type,
                                'from' => $ages_cell['from'],
                                'to' => $ages_cell['to']
                            ));
                        }
                    }
                    
                }
                
                $legal_entity = array();
                if($row->id_partner > 0){
                    $partner_data = $this->mpartners->Get_partner_data($row->id_partner);
                                        
                    $legal_entity['tax_id'] = $partner_data['DOC_INN'];
                    $legal_entity['name'] = htmlentities($partner_data['name'], ENT_QUOTES, "UTF-8");
                    $legal_entity['country'] = $partner_data['country'];
                    $legal_entity['state'] = $partner_data['state'];
                    $legal_entity['city'] = $partner_data['city'];
                    $legal_entity['address_line_1'] = $partner_data['addrLine1'];
                    $legal_entity['address_line_2'] = $partner_data['addrLine2'];
                    $legal_entity['postal_code'] = $partner_data['postcode'];
                }
                
                array_push($data, array(
                    "property_id"               => (int) $row->id,
                    "property_name"             => $row->property_name,
                    "property_name_lat"         => $row->property_name_lat,
                    "property_type"             => $property_type,
                    "property_dwelling"         => $row->dwelling,
                    "star_rating"               => $row->star_rating,
                    "secruriy_deposit"          => $row->secruriy_deposit,
                    "early_checkin_available"   => (bool) $row->checkintime_available,
                    "late_checkout_available"   => (bool) $row->checkouttime_available,
                    "check_in_time"             => $row->check_in_time,
                    "check_out_time"            => $row->check_out_time,
                    //"property_name_english"   => $row->property_name_english,
                    "address_line_1"            => $row->street,
                    "address_line_1_lat"        => $row->street_lat,
                    "address_line_2"            => $row->additional_information,
                    "address_line_2_lat"        => $row->additional_information_lat,
                    "city"                      => $row->city,
                    "city_lat"                  => $row->city_lat,
                    "state"                     => $state,
                    "state_lat"                 => $row->state_lat,
                    "post_code"                 => $row->post_code,
                    "country"                   => $country,
                    "gps_coordinates"           => $row->gps_coordinates,
                    "reception_phone"           => $row->reception_phone,
                    "email"                     => $row->email,
                    "web_address"               => $row->web_address,
                    "descriptions"              => $descriptions,
                    "ameneties_types"           => $ameneties,
                    "contact_info"              => $contact_info,
                    "age_ranges"                => $age_ranges_push,
                    "legal_entity"                => $legal_entity,
                    //"logo"                    => $foto
                ));
            }
        }
        
        foreach($data as &$cell){
            $ameneties_types_new = array();
            foreach($cell['ameneties_types'] as $ameneties_types){
                $ameneties = array();
                foreach($ameneties_types["ameneties"] as $ameneties_cell){
                    array_push($ameneties, $ameneties_cell);
                }
                array_push($ameneties_types_new, array(
                    'amenety_type_id' => $ameneties_types['amenety_type_id'],
                    'amenety_type_name' => $ameneties_types['amenety_type_name'],
                    'ameneties' => $ameneties
                ));
            }
            $cell['ameneties_types'] = array();
            $cell['ameneties_types'] = $ameneties_types_new;
        }
        
        return $data;
    }
    
    public function get_property_categories($hms_property_id) {
        $where_arr = array('property_id' => $hms_property_id, 'is_active' => 1);
        $query_rooms = $this->db->select('id, is_active, name, shortname')->get_where('categories', $where_arr)->result();
        $rooms = array();
        foreach ($query_rooms as $room_data) {
            $rooms[$room_data->id] = $room_data;
        }
        return $rooms;
    }
    
    function get_property_fotos_echannel($property_id = 0, $without_foto_src = 0){
        $data = array();
    
        $external_property_image = $this->images_core->get_external_property_image_value();
    
        if($external_property_image){
            $tbl_property_images_name = "property_images_registry";
        }else{
            $tbl_property_images_name = "property_images";
        }
    
        $select = "";
        if($property_id > 0){
            $select = " WHERE property_id = $property_id";
        }
    
        $foto_array = array();
        $query = $this->db->query ( "SELECT id, id_position, is_main FROM $tbl_property_images_name $select" );
    
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $size_original = 3; // 3 це тип оригінальної картинки
                $size_small = 1; // 1 це тип малої картинки
                $url_data = array();
                $url_data ['property_id'] = $property_id;
                $url_data ['id_position'] = $row->id_position;
                $img_url_original = $this->images_core->get_property_img_url($url_data, $size_original);
                $img_url_small = $this->images_core->get_property_img_url($url_data, $size_small);
                 
                //$foto_array[$row->id_position]["foto_id"] = (int)$row->id;
                //$foto = '<img src="/setup_property_c2/view_property_foto_small/'.$property_id.'/'.$row->id_position.'/foto.jpg" alt=""/>';
                $foto = '';
                if($without_foto_src == 0){
                    $foto = '<img src="'.$img_url_small.'" alt=""/>';
                    //$foto_array [$row->id_position]["foto"] = $foto;
                }
                //$foto_array [$row->id_position]["img_url"] = $img_url_original;
                //$foto_array [$row->id_position]["id_position"] = (int)$row->id_position;
                //$foto_array [$row->id_position]["property_id"] = (int)$property_id;
    
    
                array_push($foto_array, array(
                    'foto_id' => (int)$row->id,
                    'foto' => $foto,
                    'img_url' => $img_url_original,
                    'is_main' => (bool)$row->is_main
                ));
            }
    
    
    
        }
    
    
        return $foto_array;
    }
    
    function get_property_data($property_id = 0){
        $data = array();
    
        $countries = $this->fms_core->get_dict_country("global_fms_base", 1);
        foreach ($countries as $key => $country) {
            if (empty($country['native_name'])) unset($countries[$key]);
        }
    
        $external_property_image = $this->images_core->get_external_property_image_value();
    
        if($external_property_image){
            $tbl_property_images_name = "property_images_registry";
        }else{
            $tbl_property_images_name = "property_images";
        }
        
        $select = "";
        if($property_id > 0){
            $select = " WHERE property_information.id = $property_id";
        }
    
        $sql = "SELECT property_information.* FROM property_information $select";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $country = "";
                if (isset($countries[$row->country])) {
                    $country = $countries[$row->country]['id_2ch'];
                }
                $foto = '<img src="/setup_property_c2/view_property_information_foto_small/' . $property_id . '/foto.jpg" alt=""/>';
                $state = $row->state;
                if($state == "{state_value}"){
                    $state = "";
                }
                
                array_push($data, array(
                    "property_id"               => (int) $row->id,
                    "property_name"             => $row->property_name,
                    "property_name_lat"         => $row->property_name_lat,
                    "dwelling"                  => $row->dwelling,
                    "property_type"             => $row->property_type,
                    "country"                   => $row->country,
                    "address_line_1"            => $row->street,
                    "address_line_1_lat"        => $row->street_lat,
                    "street"                    => $row->street,
                    "street_lat"                => $row->street_lat,
                    "address_line_2"            => $row->additional_information,
                    "address_line_2_lat"        => $row->additional_information_lat,
                    "city"                      => $row->city,
                    "city_lat"                  => $row->city_lat,
                    "state"                     => $state,
                    "state_lat"                 => $row->state_lat,
                    "post_code"                 => $row->post_code,
                    "country"                   => $country,
                    "gps_coordinates"           => $row->gps_coordinates,
                    "reception_phone"           => $row->reception_phone,
                    "email"                     => $row->email,
                    "web_address"               => $row->web_address,
                    "star_rating"               => $row->star_rating,
                    "range_id"                  => $row->range_id,
                    "timezone"                  => $row->timezone,
                    "check_in_time"                  => $row->check_in_time,
                    "check_out_time"                  => $row->check_out_time,
                    //"logo"                      => $foto
                ));
            }
        }
    
        return $data;
    }
    
    function get_property_ameneties($property_id, $return_type = 1){
        $property = array();
        $sql = "SELECT property_amenety_type.id as amenety_type_id, property_amenety_type.name as amenety_type_name,
                property_ameneties.id as amenety_id, property_ameneties.name as amenety_name, property2ameneties.amenity_id,
                booking as bk_amenety_code
                FROM property_amenety_type
                LEFT JOIN property_ameneties ON property_ameneties.type_id = property_amenety_type.id
                LEFT JOIN property2ameneties ON property2ameneties.amenity_id = property_ameneties.id AND property2ameneties.property_id = ".$property_id;
        //echo $sql;
        //die();
        $query = $this->db->query($sql);
        switch($return_type){
            case 1: // get with types of ameneties
                foreach ($query->result() as $row) {
                    $property [$row->amenety_type_id] ["amenety_type_id"] = $row->amenety_type_id;
                    $property [$row->amenety_type_id] ["amenety_type_name"] = "{-" . $row->amenety_type_name . "-}";
                    $property [$row->amenety_type_id] ["ameneties"] [$row->amenety_id] ["amenety_id"] = $row->amenety_id;
                    $property [$row->amenety_type_id] ["ameneties"] [$row->amenety_id] ["amenety_name"] = "{-" . $row->amenety_name . "-}";
                    if($row->amenity_id != NULL){
                        $checked = "checked";
                    }else{
                        $checked = "";
                    }
                    $property[$row->amenety_type_id]["ameneties"][$row->amenety_id]["amenety_checked"] = $checked;
                }
                break;
            case 2: // get without types of ameneties
                foreach ($query->result() as $row) {
                    if($row->amenity_id != NULL){
                        $property [$row->amenety_id] ["amenety_id"] = $row->amenety_id;
                        $property [$row->amenety_id] ["bk_amenety_code"] = $row->bk_amenety_code;
                        $property [$row->amenety_id] ["amenety_name"] = "{-" . $row->amenety_name . "-}";
                        $property [$row->amenety_id] ["amenety_type_id"] = $row->amenety_type_id;
                        $property [$row->amenety_id] ["amenety_type_name"] = "{-" . $row->amenety_type_name . "-}";
                    }
                }
                break;
        }
        
        return $property;
    }

    function get_property_fotos($property_id)
    {
        $external_property_image = $this->images_core->get_external_property_image_value();
        
        if ($external_property_image) {
            $tbl_property_images_name = "property_images_registry";
        } else {
            $tbl_property_images_name = "property_images";
        }
        
        $foto_array = array();
        $query = $this->db->query("SELECT id, id_position, is_new FROM " . $tbl_property_images_name . " WHERE property_id = $property_id");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                if ($row->is_new == 1) {
                    $img_url_original = "";
                    $img_url_small = "";
                } else {
                    $size_original = 3; // 3 це тип оригінальної картинки
                    $size_small = 1; // 1 це тип малої картинки
                    $url_data = array();
                    $url_data['property_id'] = $property_id;
                    $url_data['id_position'] = $row->id_position;
                    $img_url_original = $this->images_core->get_property_img_url($url_data, $size_original);
                    $img_url_small = $this->images_core->get_property_img_url($url_data, $size_small);
                    
                    $foto = '<img src="' . $img_url_small . '" alt=""/>';
                    array_push($foto_array, array(
                        'property_id' => $property_id,
                        'foto_id' => $row->id,
                        'foto' => $foto,
                        'img_url' => $img_url_original,
                        'id_position' => $row->id_position
                    ));
                }
            }
        }
        
        return $foto_array;
    }
}
?>