<?
class messages_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    /*
     * 
     * Return url for message center version 1 or version 2
     * 
     * input: array
     *        - url_type
     * output: url
     * 
     */
    function get_mc_urls($data){
        $url_type = $data ['url_type'];
        $urls = array();
        $message_center_version = $this->releases->check_message_center_version();
        switch ($message_center_version) {
            case 1:
                $urls ['support_mc_list'] = "/support/ticketslist_c2";
                $urls ['support_mc_create'] = "/home/feedback_c2";
                $urls ['support_mc_view'] = "/support/view_ticket_c2/";
                
                $urls ['channel_mc_list'] = "/mailbox_c2/messageslist/1/1";
                $urls ['channel_mc_view'] = "/mailbox_c2/showmessages/";
                
                $urls ['channel_mc_list_v2'] = "/dc_booking_c2/messages_list";
                $urls ['channel_mc_view_v2'] = "/dc_booking_c2/conversation/";
                break;
            case 2:
                $urls ['support_mc_list'] = "/messages_c2/support_msgs_list/1";
                $urls ['support_mc_create'] = "/messages_c2/create_support_msg";
                $urls ['support_mc_view'] = "/messages_c2/support_msg_info/";
                
                $urls ['channel_mc_list'] = "/messages_c2/channel_msg_list/1";
                $urls ['channel_mc_view'] = "/messages_c2/channel_msg_info/";
                
                $urls ['channel_mc_list_v2'] = "/dc_booking_c2/messages_list";
                $urls ['channel_mc_view_v2'] = "/dc_booking_c2/conversation/";
                break;
            default:
                $urls ['support_mc_list'] = "/support/ticketslist_c2";
                $urls ['support_mc_create'] = "/home/feedback_c2";
                $urls ['support_mc_view'] = "/support/view_ticket_c2/";
                
                $urls ['channel_mc_list'] = "/mailbox_c2/messageslist/1/1";
                $urls ['channel_mc_view'] = "/mailbox_c2/showmessages/";
                
                
                $urls ['channel_mc_list_v2'] = "/dc_booking_c2/messages_list";
                $urls ['channel_mc_view_v2'] = "/dc_booking_c2/conversation/";
                break;
        }
        
        if(isset($urls[$url_type])){
            return $urls[$url_type];
        }else{
            return "";
        }
    }
    
    function get_authparam(){
        $data = array();
        $airbnb_testmode = $this->frontdesk_c2->get_airbnb_testmode_value();
        $airbnb_message_centre_test = $this->releases->check_airbnb_message_centre_test();
        if ($airbnb_message_centre_test == 1) { // test mode
            $data['host_id'] = '388799534';
            $data['client_id'] = '358mz0fhnvyqrbh8hh6t0zuno';
            $data['secret'] = 'au6i28gjyei0gh8ruhauwce8';
            $data['refresh_token'] = '3cfvnni05rsfyjkebnfrkuwgg';
            $data['access_token'] = "";
        } else {
            $data ['host_id'] = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
            $data ['client_id'] = 'awkk3fb3oa4o67f5zbjg8eees';
            $data ['secret'] = '39qswxnwqbatb6mipl0ahktyl';
            $data ['refresh_token'] = $this->dcm_airbnb->getxmlcfgvalue('refresh_token', 'str');
            $data ['access_token'] = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        }
        
        // live
//         $data ['host_id'] = '273838284';
//         $data ['client_id'] = 'awkk3fb3oa4o67f5zbjg8eees';
//         $data ['secret'] = '39qswxnwqbatb6mipl0ahktyl';
//         $data ['refresh_token'] = '1fo6kqzypa4mif9vu2fjt0y8i';        
//         $data ['access_token'] = "";
        
        
        
        // test
        
//         $data ['host_id'] = '388799534';
//         $data ['client_id'] = '358mz0fhnvyqrbh8hh6t0zuno';
//         $data ['secret'] = 'au6i28gjyei0gh8ruhauwce8';
//         $data ['refresh_token'] = '3cfvnni05rsfyjkebnfrkuwgg';
//         $data ['access_token'] = "";
        
        
        
//         $data = array();
//         $data ['host_id'] = '388799534';
        
//         $data ['host_id'] = '273838284';
//         $data ['client_id'] = '358mz0fhnvyqrbh8hh6t0zuno';
//         $data ['secret'] = 'au6i28gjyei0gh8ruhauwce8';
        
//         $data['client_id'] = 'awkk3fb3oa4o67f5zbjg8eees';
//         $data['secret'] = '39qswxnwqbatb6mipl0ahktyl';
//         $data['refresh_token'] = '1fo6kqzypa4mif9vu2fjt0y8i';
//         echo "<pre>";
//         print_r($data);
//         die();
        return $data;
    }
    
    function get_token( $data )
    {

        $url = 'https://api.airbnb.com/v2/oauth2/authorizations/'.$data['access_token'].'?_unwrapped=true';
        //echo $url;
        $auth = $data['client_id'] . ':' . $data['secret'];
        $headers = array(
            'Content-Type:application/json',
            'Authorization: Basic ' . base64_encode($auth),
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $buffer = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($buffer, true);
        
        //echo $buffer."<hr>";
        if(! isset( $result['valid'] )) {
            $this->dcm_airbnb->refreshtoken();
            return $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
            
//             $url = 'https://api.airbnb.com/v2/oauth2/authorizations?_unwrapped=true';
//             $data = array(
//                 'refresh_token' => $data['refresh_token'], // refreshtoken
//                 'reset_refresh_token' => 0,
//             );
            	
//             $ch = curl_init();
//             curl_setopt($ch, CURLOPT_URL, $url);
//             curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//             curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
//             curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//             curl_setopt($ch, CURLOPT_POST, true);
//             curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
//             $buffer = curl_exec($ch);
//             curl_close($ch);
//             $result = json_decode($buffer, true);
//             //echo $buffer;
//             if(!isset($result['access_token'])){
//                 $result['access_token'] = "";
//                 return $result['access_token'];
//             }
//             $new_token_data = array(
//                 'token' => $result['access_token'],
//                 'validity' => date('Y-m-d H:i:s', $result['expires_at']),
//             );
            //$this->db->where('host_id', $host_id)->set($new_token_data)->update('airbnb_data');
            //return $result['access_token'];
        } else {
            //return $token_data->token;
            return $data['access_token'];
        }
    
    }
    
    function save_threads($data){
        foreach($data as $cell){
            $thread_id = $this->db->select('thread_id')->get_where('dc_mc_threads', array('thread_id' => $cell['thread_id']))->row()->thread_id;
            
            $insert_data = array(
                'thread_id' => $cell['thread_id'], 
                'listing_name' => $cell["listing_name"],
                'confirm_code' => $cell["confirm_code"],
                'update_time' => $cell["update_time"], 
                'details' => $cell['details'],
                'users_names' => $cell['users_names'],
                'hms_res_id' => $cell['hms_res_id']
            );

            if($thread_id == 0){
                $is_new = 1;
                $insert_data['is_new'] = $is_new;
            }
            
//             $keys = array('thread_id');
//             $this->frontdesk_c2->db_insert_on_duplicate_key_update('`dc_mc_threads`', $insert_data, $keys);
            
            // ======
            $query = $this->db->query("SELECT id FROM dc_mc_threads WHERE thread_id = ".$cell['thread_id']);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_thread_id = $row->id;
                $this->db->where('thread_id', $cell['thread_id']);
                $this->db->update('dc_mc_threads', $insert_data);
            }else{
                $this->db->insert('dc_mc_threads', $insert_data);
                $hms_thread_id = $this->db->insert_id();
            }
            // =======
            
            // ===== SAVE MC ============
            $message_center_data = array();
            $message_center_data ['dc_id'] = 22;
            $message_center_data ['thread_id'] = $hms_thread_id;
            $message_center_data ['dc_thread_id'] = $cell['thread_id'];
            $message_center_data ['code_id'] = $cell["confirm_code"];
            $message_center_data ['time'] = $cell["update_time"];
            $message_center_data ['hms_res_id'] = $cell['hms_res_id'];
            $message_center_data ['is_new'] = 1;
            $this->save_message_center_data($message_center_data);
        }
        
        
        //$this->db->insert_batch('dc_mc_threads', $data);
    }
    
    function save_messages($data)
    {
        foreach ($data as $cell) {
            $insert_data = array(
                'message_id' => $cell['message_id'],
                'thread_id' => $cell['thread_id'],
                'user_id' => $cell["user_id"],
                'user_role' => $cell["user_role"],
                'user_name' => $cell["user_name"],
                'created_at' => $cell["created_at"],
                'message' => $cell['message']
            );
            $keys = array(
                'message_id',
                'thread_id'
            );
            $this->frontdesk_c2->db_insert_on_duplicate_key_update('`dc_mc_messages`', $insert_data, $keys);
        }
    }
    
    function save_booking_conversations($data)
    {
//         $keys = array(
//             'property_id',
//             'conversation_id'
//         );
        
        $query = $this->db->query("SELECT id FROM dc_booking_conversations WHERE conversation_id LIKE '".$data['conversation_id']."'
                                   AND property_id =  '".$data['property_id']."'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $conversation_id = $row->id;
            $this->db->where('id', $conversation_id);
            $this->db->update('dc_booking_conversations', $data);
        }else{
            $this->db->insert('dc_booking_conversations', $data);
            $conversation_id = $this->db->insert_id();
        }
        
        $message_center_data = array();
        $message_center_data ['dc_id'] = 1;
        $message_center_data ['thread_id'] = $conversation_id;
        $message_center_data ['dc_thread_id'] = $data['conversation_id'];
        //$message_center_data ['code_id'] = $data['conversation_reference'];
        $message_center_data ['hms_res_id'] = $data['hms_res_id'];
        $message_center_data ['time'] = date('Y-m-d H:i:s');
        $message_center_data ['is_new'] = $data['is_new'];
        $this->save_message_center_data($message_center_data);
        
        return $conversation_id;
    }
    
    function save_message_center_data($data){
        $keys = array(
            'dc_id',
            'hotel_id',
            'thread_id'
        );
        $this->frontdesk_c2->db_insert_on_duplicate_key_update('`dc_messages_center`', $data, $keys);
    }
    
    function save_booking_messages($data){
//         $keys = array(
//             'message_id',
//             'hotel_id',
//             'conversation_reference'
//         );
//         $this->frontdesk_c2->db_insert_on_duplicate_key_update('`dc_booking_messages`', $data, $keys);
        $new_messages_id = 0;
        $query = $this->db->query("SELECT id FROM dc_booking_messages WHERE conversation_reference = '".$data['conversation_reference']."'
                                  AND hotel_id =  '".$data['hotel_id']."' AND message_id LIKE '".$data['message_id']."'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $id = $row->id;
            unset($data['participant_type']);
            $this->db->where('id', $id);
            $this->db->update('dc_booking_messages', $data);
        }else{
            $this->db->insert('dc_booking_messages', $data);
            $new_messages_id = $this->db->insert_id();
        }
        
        return $new_messages_id;
    }
    
    function get_save_booking_msg($data){
        $property_id = $data['hotel_id'];
        $conversation_id = $data['conversation_id'];
        $save_data_conversations = array();
        $save_data_conversations['conversation_id'] = $data['conversation_id'];
        $save_data_conversations['conversation_reference'] = 0;
        $save_data_conversations['property_id'] = $property_id;
        $save_data_conversations['conversation_type'] = "";
        $save_data_conversations['is_new'] = 0;
        $save_data_conversations['hms_res_id'] = 0;
        
        $conversation_id_int = $this->messages_model->save_booking_conversations($save_data_conversations);

        $curl_data = array();
        $curl_data['property'] = $data['hotel_id'];
        //$curl_data['res_id'] = $data['conversation_reference'];
        $curl_data['conversation_id'] = $data['conversation_id'];
        $curl_result = $this->Curl_model->get_booking_message_by_conversation($curl_data);

        if($this->session->userdata ( 'global_debug' ) == 1){
//             echo "++++++++##########".$curl_result;
//             echo "<pre>";
//             print_r($curl_result);
//             die();
        }
        
        // === LOG ======
        $description_data = array();
        $description_data ['request'] = $curl_data;
        $description_data ['response'] = $curl_result;
        $dc_type = 18;
         
        $log_data = array();
        $log_data ['reservation_id'] = 0;
        $log_data ['type'] = "dcmessage";
        $log_data ['dc_type'] = $dc_type; // dc_message
        $log_data ['description'] = "json: ".json_encode($description_data);
        $this->Loger_admin->save_dcmessage_data ( $log_data );
        // ==== END LOG =====
        
        $sender_data = array();
        if(isset($curl_result['data']['ok'])){
            $conversation_reference = $curl_result['data']['conversation']['conversation_reference'];
            $conversation_type = $curl_result['data']['conversation']['conversation_type'];
            
            $hms_res_id = 0;
            $query = $this->db->query("SELECT id FROM deskofreservation
            	        	                               WHERE dc_id = 1 AND dc_reservationid = " . $conversation_reference);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_res_id = $row->id;
            }

            
            foreach($curl_result['data']['conversation']['participants'] as $participants_data){
                $participant_id = $participants_data['participant_id'];
                $sender_data [$participant_id] ['participant_type'] = $participants_data['metadata']['type'];
                $sender_data [$participant_id] ['participant_id'] = $participant_id;
                
            }
            $update_data = array();
            $update_data ['conversation_reference'] = $conversation_reference;
            $update_data ['conversation_type'] = $conversation_type;
            $update_data ['hms_res_id'] = $hms_res_id;
            
            $update_keys = array();
            $update_keys ['property_id'] = $property_id;
            $update_keys ['conversation_id'] = $conversation_id;
            $this->db->update('dc_booking_conversations', $update_data, $update_keys);
            
            $update_data = array();
            $update_data ['hms_res_id'] = $hms_res_id;
            
            $update_mc_keys = array();
            $update_mc_keys ['dc_id'] = 1;
            $update_mc_keys ['dc_thread_id'] = $conversation_id;
            $this->db->update('dc_messages_center', $update_data, $update_mc_keys);
            
            $is_new = 0;
            foreach($curl_result['data']['conversation']['messages'] as $msg_data){
                if(!isset($msg_data ['content'])){
                    $message = "";
                }else{
                    if($msg_data ['content'] == 'Attachment'){
                        $message = "";
                    }else{
                        $message = $msg_data ['content'];
                    }
                }
                $sender_id = $msg_data ['sender_id'];
                
                $participant_type = "";
                if (isset($sender_data [$sender_id] ['participant_type'])) {
                    $participant_type = $sender_data [$sender_id] ['participant_type'];
                }
                
                $save_data = array();
                $save_data ['message_id'] = $msg_data ['message_id'];
                if(isset($msg_data ['attachment_ids'][0])){
                    $save_data ['attachment_id'] = $msg_data ['attachment_ids'][0];
                }
                $save_data ['conversation_id_int'] = $conversation_id_int;
                $save_data ['hotel_id'] = $data['hotel_id'];
                $save_data ['conversation_id'] = $data['conversation_id'];
                $save_data ['conversation_reference'] = $conversation_reference;
                $save_data ['sender_id'] = $msg_data ['sender_id'];
                $save_data ['created_at'] = $msg_data ['timestamp'];
                $save_data ['message'] = $message;
                $save_data ['participant_type'] = $participant_type;
                $save_data ['sender_name'] = "";
                $save_data ['participant_id'] = $sender_id;
                
                $new_msg = $this->messages_model->save_booking_messages($save_data);
                
                if ($new_msg > 0) {
                    switch ($sender_data [$sender_id] ['participant_type']) {
                        case "property":
                            break;
                        case "GUEST":
                            $is_new = 1;
                            break;
                        case "guest":
                            $is_new = 1;
                            break;
                    }
                    
                    if ($is_new == 1){
                        $update_data = array();
                        $update_data ['is_new'] = $is_new;
                        $this->db->update('dc_booking_conversations', $update_data, $update_keys);

                        $this->db->update('dc_messages_center', $update_data, $update_mc_keys);
                    }
                    
                    // ==== NITIFICATION =====
                    if ($participant_type == "guest") {
                        $hms_notifications_data = array();
                        $hms_notifications_data['message'] = "{clt_dc_booking_message}: " . $message;
                        $hms_notifications_data['state'] = 1;
                        $hms_notifications_data['type'] = 1;
                        $hms_notifications_data['notify_type'] = 4; // channel msg
                        $hms_notifications_data['item_id'] = $conversation_id_int;
                        $hms_notifications_data['create_time'] = date('Y-m-d H:i:s');
                        $this->frontdesk_c2->insert_hms_notifications($hms_notifications_data);
                    }
                }
            }
        }
    }
    
    public function get_booking_message_by_res( $property, $res_id )
    {
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
    
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
        );
    
        $url = 'https://supply-xml.booking.com/messaging/properties/' . $property . '/conversations/type/reservation?conversation_reference=' . $res_id;
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        $buffer = curl_exec($ch);
        curl_close($ch);
        
        $result = json_decode($buffer, true);
        return $result;
    }
    
    function send_messages($data){
        $auth_data = $this->get_authparam();
        
        $token_url = 'https://api.airbnb.com/v2/oauth2/authorizations/dmp9negrrr2uxxpyju5hib1xm?_unwrapped=true';
        $token = $this->messages_model->get_token( $auth_data, $token_url );
        $auth_data ['token'] = $token;
        
        $url = "https://api.airbnb.com/v2/messages";
        
        if( 4 == ( $_FILES['upload_file']['error']) ) {
            $post_data = array(
                'thread_id' => $data['thread_id'],
                'message'	=> $data['message']
            );
            
            $result_data = $this->curl_model->curl_airbnb_messages($auth_data, $url, $post_data);
//             echo "<pre>";
//             print_r($result_data);
//             die();
        } else {
            $image = base64_encode(file_get_contents($_FILES['upload_file']['tmp_name']));
            $content_type = $_FILES['upload_file']['type'];
            	
            $image = base64_encode(file_get_contents($_FILES['upload_file']['tmp_name']));
            $content_type = $_FILES['upload_file']['type'];
            	
            $post_data = array(
                'thread_id' => $data['thread_id'],
                'image'	=> $image,
                'content_type' => $content_type
            );
            
            $result_data = $this->curl_model->curl_airbnb_messages($auth_data, $url, $post_data);
//             echo "<pre>";
//             print_r($result_data);
//             die();
        }
    }
    
    function booking_send_messages($data){
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
            "Content-Type: application/json"
        );
        
        $url = 'https://supply-xml.booking.com/messaging/properties/' . $data['property_id'] . '/conversations/' . $data['conversation'];
        
        $curl_data = array(
            'message' => array(
                'content' => $data['text']
            )
        );
        
        if (isset($data['attachment'])) {
            if ($data['attachment'] !== null) {
                $curl_data['message']['attachment_ids'][0] = $data['attachment'];
            }
        }
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($curl_data));
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);
        curl_close($ch);
        
        return $buffer;
    }
    
    function get_threads($data){
        $status = $this->session->userdata ( 'threads_msg_status' );
        $select = "WHERE ";
        switch($status){
            case 1:
                $select .= " is_new = 1 ";
                break;
            case 2:
                $select .= " important = 1 ";
                break;
            case 3:
                $select .= " archive = 1 ";
                break;
            default:
                $select .= " archive <> 1 ";
                break;
        }
        
        $sql = "SELECT SQL_CALC_FOUND_ROWS 1 as number, dc_mc_threads.* 
            FROM dc_mc_threads $select ORDER BY is_new DESC, update_time DESC LIMIT ".$data['first_line'].", ".$data['last_line'];
//         echo $sql;
//         die();
        return $this->db->query( $sql )->result_array();
        //->order_by(array('is_new', 'update_time'), 'DESC')
        //return $this->db->select('')->get('dc_mc_threads', $data['first_line'], $data['last_line'])->result_array();
    }
    
    function get_mc_threads($data){
        $status = $this->session->userdata ( 'mc_list_status' );
        $select = "WHERE ";
        switch($status){
            case 1:
                $select .= " is_new = 1 ";
                break;
            case 2:
                $select .= " important = 1 ";
                break;
            case 3:
                $select .= " archive = 1 ";
                break;
            default:
                $select .= " archive <> 1 ";
                break;
        }
        
        $sql = "SELECT SQL_CALC_FOUND_ROWS 1 as number, dc_messages_center.* 
            FROM dc_messages_center $select ORDER BY is_new DESC, time DESC LIMIT ".$data['first_line'].", ".$data['last_line'];
        //echo $sql;
        return $this->db->query( $sql )->result_array();
    }
    
    function get_theards_users(){
        $user_names = array();
        $sql = "SELECT thread_id, user_name FROM dc_mc_messages GROUP BY thread_id, user_name";
        $query = $this->db->query($sql);
        
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                array_push($user_names, array(
                   'thread_id' => $row->thread_id,
                   'user_name' => $row->user_name,
                ));
            }
        }
        
        return $user_names;
    }
    
    function get_messages($thread_id){
        return $this->db->select('')->order_by('created_at', 'ASC')->get_where('dc_mc_messages', array('thread_id' => $thread_id))->result_array();
    }
    
    function update_thread($data, $thread_id){
        $this->db->where('thread_id', $thread_id);
        $this->db->update('dc_mc_threads', $data);
        // === update in MC ====
        $update_keys = array('dc_thread_id' =>  $thread_id, 'dc_id' => 22);
        $this->update_mc($data, $update_keys);
    }
    
    function update_conversation($data, $conversation_id_int){
        $this->db->where('id', $conversation_id_int);
        $this->db->update('dc_booking_conversations', $data);
        // === update in MC ====
        $update_keys = array('thread_id' =>  $conversation_id_int, 'dc_id' => 1);      
        $this->update_mc($data, $update_keys);
    }
    
    function update_mc($data, $keys){
        $this->db->where($keys);
        $this->db->update('dc_messages_center', $data);
    }

    function get_airbnb_messages($thread_id, $debug = 0){
        $auth_data = $this->messages_model->get_authparam();
        
        $token_url = 'https://api.airbnb.com/v2/oauth2/authorizations/dmp9negrrr2uxxpyju5hib1xm?_unwrapped=true';
        $token = $this->messages_model->get_token( $auth_data, $token_url );
        $auth_data ['token'] = $token;
        
        $url = "https://api.airbnb.com/v2/threads/" . $thread_id . "?use_thread_id_migration=true";
        $result_data = $this->curl_model->curl_airbnb_messages($auth_data, $url);
        
        if ($debug == 1) {
            echo "<pre>";
            print_r($result_data);
            die();
        }
        
        if ($result_data['response_int'] == 1) {
            $result = $result_data['response_data'];
            $roles = array();
            $user_names = array();
            if (isset($result['thread']['attachment']['roles'])) {
                foreach ($result['thread']['attachment']['roles'] as $role_cell) {
                    if(isset($role_cell['user_ids'][0])){
                        $user_id = $role_cell['user_ids'][0];
                        $role = $role_cell['role'];
                        $roles[$user_id] = $role;
                    }
                }
            }
            
            if (isset($result['thread']['users'])) {
                foreach ($result['thread']['users'] as $udata_cell) {
                    $user_names[$udata_cell['id']] = $udata_cell['first_name'];
                }
            }
            
            if (isset($result['thread']['messages'])) {
                $messages = $result['thread']['messages'];
                $save_data = array();
                foreach ($messages as $cell) {
                    $db_message_id = @$this->db->select('message_id')
                    ->get_where('dc_mc_messages', array('message_id' => $cell['id'], 'thread_id' => $result['thread']['id']))
                    ->row()
                    ->message_id;
                    if($db_message_id == 0){ 
                        // set is_new state = 1
                        $update_data = array('is_new' => 1);
                        $this->messages_model->update_thread($update_data, $result['thread']['id'] );
                    }
                    
                    
                    if(count($cell['attachment_images']) > 0){
                        if(isset($cell['attachment_images'][0])){
                            $file_url = $cell['attachment_images'][0]['url'];
                            $message_text = '<a target="_blank" href="'.$file_url.'"><img class="svgicon10 blue" src="/assets/img/fms_icons.png" alt=""></a>';
                        }
                    }else{
                        $message_text = $cell['message'];
                    }
                    
                    $user_role = isset($roles[$cell['user_id']]) ? $roles[$cell['user_id']] : "";
                    $user_name = isset($user_names[$cell['user_id']]) ? $user_names[$cell['user_id']] : "";
                    
                    array_push($save_data, array(
                        'message_id' => $cell['id'],
                        'thread_id' => $result['thread']['id'],
                        'user_id' => $cell['user_id'],
                        'user_role' => $user_role,
                        'user_name' => $user_name,
                        'created_at' => $cell['created_at'],
                        'message' => $message_text
                    ));
                }
                
                $this->messages_model->save_messages($save_data);
            }
        }

//                 echo '<pre>'.$result;
//                 print_r( $result );
//                 print_r( $save_data );
//                 die();
    }
    
    function get_threads_count(){
        return $this->db->query( "SELECT COUNT(1) as threads_count FROM dc_mc_threads WHERE is_new = 1" )->row()->threads_count;
    }
    
    function get_mc_threads_count(){
        return $this->db->query( "SELECT COUNT(1) as threads_count FROM dc_messages_center WHERE is_new = 1" )->row()->threads_count;
    }
    
    function get_system_msg_count(){
        return $this->db->query( "SELECT COUNT(1) as msg_count FROM hms_notifications WHERE state <> 2" )->row()->msg_count;
    }
    
    
    
    function delete_system_msg($id){
        $this->db->where('id', $id);
        $this->db->delete('hms_notifications');
    }
    
    function get_all_airbnb_threads($debug = 0){
        $next_cursor = null;
        $threads = array();
        
        $auth_data = $this->messages_model->get_authparam();

        $token = $this->messages_model->get_token( $auth_data );
        
        if($token == ""){
            return 0;
        }
        $auth_data ['token'] = $token;
        
        //print_r($auth_data);
        do{
            $url = 'https://api.airbnb.com/v2/threads?_format=for_api_partners&selected_inbox_type=host&_limit=25';
             
            if( $next_cursor != null ){
                $url .= '&_cursor=' . $next_cursor;
            }
        
            $result_data = $this->curl_model->curl_airbnb_messages($auth_data, $url);
            if ($result_data['response_int'] == 0) {
               // echo "cURL Error #:" . $result_data['error'];
            } else {
                $thread_data = $result_data['response_data'];
                if(isset($thread_data['threads'])){
                    $next_cursor = $thread_data['paging']['next_cursor'];
                    $threads = array_merge($threads, $thread_data['threads']);
                } else {
                    $threads = $thread_data;
                }
        
            }
        } while( $next_cursor != null );
        
        $save_data = array();
        foreach($threads as $thread_data){
            $details = isset($thread_data['attachment']['booking_details']) ? json_encode($thread_data['attachment']['booking_details']) : "";
            $confirm_code = isset($thread_data['attachment']['booking_details']['reservation_confirmation_code']) ? $thread_data['attachment']['booking_details']['reservation_confirmation_code'] : "";
            $listing_name = isset($thread_data['attachment']['booking_details']['listing_name']) ? $thread_data['attachment']['booking_details']['listing_name'] : "";
            $users_names = "";
            if (isset($thread_data['users'])) {
                foreach ($thread_data['users'] as $udata_cell) {
                    $users_names .= $udata_cell['first_name'].", ";
                }
            }
            $hms_res_id = "";
            if($confirm_code != ""){
                $hms_res_id = @$this->db->select('id')->get_where('deskofreservation', array('dc_uuid' => $confirm_code))->row()->id;
            }
            if($hms_res_id == null){
                $hms_res_id = "";
            }
            array_push($save_data, array(
                'thread_id' => $thread_data['id'],
                'listing_name' => $listing_name,
                'confirm_code' => $confirm_code,
                'update_time' => $thread_data['updated_at'],
                'details' => $details,
                'users_names' => $users_names,
                'hms_res_id' => $hms_res_id
            ));
        }
        
        $this->messages_model->save_threads($save_data);
        
        if($debug == 1){
            echo '<pre>';
            print_r( $threads );
            die();
        }
        
        return $threads;
    }
    
    function get_support_left_menu(){
        $search_statuses = array();
        $search_statuses[0]["status_caption"] = "{mlw_all}";
        $search_statuses[0]["status_value"] = 0;
        $search_statuses[0]["active_class"] = "";
        $search_statuses[0]["active_class_left_m"] = "";
        $search_statuses[0]["color_class"] = "mail_t_green";
        $search_statuses[0]["menu_icon"] = "icon_m_mail";
        
        $search_statuses[2]["status_caption"] = "{clt_open}";
        $search_statuses[2]["status_value"] = 2;
        $search_statuses[2]["active_class"] = "";
        $search_statuses[2]["active_class_left_m"] = "";
        $search_statuses[2]["color_class"] = "mail_t_purple";
        $search_statuses[2]["menu_icon"] = "icon_m_open";
        
        $search_statuses[5]["status_caption"] = "{clt_close}";
        $search_statuses[5]["status_value"] = 5;
        $search_statuses[5]["active_class"] = "";
        $search_statuses[5]["active_class_left_m"] = "";
        $search_statuses[5]["color_class"] = "mail_t_purple";
        $search_statuses[5]["menu_icon"] = "icon_m_closed";
        
        return $search_statuses;
    }
    
    function get_system_left_menu(){
        $search_statuses = array();
        $search_statuses[0]["status_caption"] = "{mlw_all}";
        $search_statuses[0]["status_value"] = 0;
        $search_statuses[0]["active_class"] = "";
        $search_statuses[0]["menu_icon"] = "icon_m_mail";
    
        $search_statuses[1]["status_caption"] = "{clt_deleted}";
        $search_statuses[1]["status_value"] = 1;
        $search_statuses[1]["active_class"] = "";
        $search_statuses[1]["menu_icon"] = "icon_m_trash";
    
        return $search_statuses;
    }
    
    function get_channel_left_menu(){
        $search_statuses = array();
        $search_statuses[0]["status_caption"] = "{mlw_all}";
        $search_statuses[0]["status_value"] = 0;
        $search_statuses[0]["active_class"] = "";
        $search_statuses[0]["menu_icon"] = "icon_m_mail";
    
        $search_statuses[1]["status_caption"] = "{clt_new}";
        $search_statuses[1]["status_value"] = 1;
        $search_statuses[1]["active_class"] = "";
        $search_statuses[1]["menu_icon"] = "icon_m_new_mail";
    
        $search_statuses[2]["status_caption"] = "{clt_isread}";
        $search_statuses[2]["status_value"] = 2;
        $search_statuses[2]["active_class"] = "";
        $search_statuses[2]["menu_icon"] = "icon_m_isread";
        
        $search_statuses[3]["status_caption"] = "{clt_important}";
        $search_statuses[3]["status_value"] = 3;
        $search_statuses[3]["active_class"] = "";
        $search_statuses[3]["menu_icon"] = "icon_m_star";
    
        return $search_statuses;
    }
    
    function get_threads_left_menu(){
        $search_statuses = array();
        $search_statuses[0]["status_caption"] = "{mlw_all}";
        $search_statuses[0]["status_value"] = 0;
        $search_statuses[0]["active_class"] = "";
        $search_statuses[0]["menu_icon"] = "icon_m_mail";
        
        $search_statuses[1]["status_caption"] = "{clt_new}";
        $search_statuses[1]["status_value"] = 1;
        $search_statuses[1]["active_class"] = "";
        $search_statuses[1]["menu_icon"] = "icon_m_new_mail";
    
        
    
        $search_statuses[2]["status_caption"] = "{clt_selected}";
        $search_statuses[2]["status_value"] = 2;
        $search_statuses[2]["active_class"] = "";
        $search_statuses[2]["menu_icon"] = "icon_m_star";
    
        $search_statuses[3]["status_caption"] = "{clt_archive}";
        $search_statuses[3]["status_value"] = 3;
        $search_statuses[3]["active_class"] = "";
        $search_statuses[3]["menu_icon"] = "icon_m_archive";
    
        return $search_statuses;
    }
    
    function save_hms_notifications($data){        
        $this->db->insert('hms_notifications', $data);
    }
    
    function get_booking_messages_from_db($conversation_id){    
        $sql = "SELECT SQL_CALC_FOUND_ROWS 1 as number, dc_booking_messages.*
        FROM dc_booking_messages WHERE conversation_id_int = $conversation_id ORDER BY created_at DESC";
        return $this->db->query( $sql )->result_array();
    }
    
    function get_booking_conversations($data){    
        $status = $this->session->userdata ( 'conversations_list_status' );
        $select = "WHERE ";
        switch($status){
            case 1:
                $select .= " is_new = 1 ";
                break;
            case 2:
                $select .= " important = 1 ";
                break;
            case 3:
                $select .= " 1 ";
                break;
            default:
                $select .= " 1 ";
                break;
        }
        
        $sql = "SELECT SQL_CALC_FOUND_ROWS 1 as number, dc_booking_conversations.*
        FROM dc_booking_conversations $select ORDER BY id DESC LIMIT ".$data['first_line'].", ".$data['last_line'];
        return $this->db->query( $sql )->result_array();
    }
    
    function get_booking_conversation_id($id)
    {
        $conversation_id = 0;
        $query = $this->db->query("SELECT conversation_id FROM dc_booking_conversations WHERE id = '$id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $conversation_id = $row->conversation_id;
        }
        return $conversation_id;
    }
    
    function get_booking_conversation_property_id($id)
    {
        $property_id = 0;
        $query = $this->db->query("SELECT property_id FROM dc_booking_conversations WHERE id = '$id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $property_id = $row->property_id;
        }
        return $property_id;
    }
    
    function upload_booking_large_file($property, $conversation, $filepath)
    {
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        $uploadId = null;
    
        $splitedArray = $this->fpslit($filepath, 800000);
    
        $responseArray = array();
        $dataArray = array();
    
        foreach ($splitedArray as $index => $encodedFilePart){
            if ($index === 0) {
                $action = 'start';
            } elseif ($index === (count($splitedArray) - 1)) {
                $action = 'finish';
            } else {
                $action = 'resume';
            }
    
            if (substr($encodedFilePart, -2) === '==') {
                $y = 2;
            } else {
                $y = 1;
            }
    
            $sizeOfEncodedPart = (strlen($encodedFilePart) * (3/4)) - $y;
    
            $data = array(
                'attachment' => array(
                    'action' => $action,
                    'chunk' => array(
                        'chunk_number' => $index,
                        'chunk_content' => $encodedFilePart,
                        'chunk_size' => $sizeOfEncodedPart
                    ),
                    'file_type' => mime_content_type($filepath),
                    'file_size' => filesize($filepath),
                    'file_name' => basename($filepath),
                )
            );
    
            if ($action === 'resume' || $action === 'finish') {
                $data['attachment']['upload_id'] = $uploadId;
                if ($action === 'finish') {
                    $data['attachment']['chunk']['chunk_size'] += 1;
                }
            }
    
            $dataArray[] = $data;
    
            $curl = curl_init();
    
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://supply-xml.booking.com/messaging/properties/' . $property . '/conversations/' . $conversation . '/attachment_chunks',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLINFO_HEADER_OUT => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Basic ' . base64_encode($auth),
                    'Content-Type: application/json'
                ),
            ));
    
            $response = curl_exec($curl);
            curl_close($curl);
    
            $response = json_decode($response, true);
    
            if ($action === 'start') {
                $uploadId = $response['data']['upload_id'];
            }
    
            if ($action === 'finish') {
                $attachment_id = $response['data']['attachment_id'];
            }
        }
    
        return $attachment_id;
    }
    
    function upload_small_file($property, $conversation, $filepath)
    {
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        $file = $filepath;
    
        $data = array(
            "attachment" => array(
                "file_name" => "image.jpeg",
                "file_content" => base64_encode(file_get_contents($file)),
                "file_type" => "image/jpeg",
                "file_size" => filesize($file)
            )
        );
    
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://supply-xml.booking.com/messaging/properties/' . $property . '/conversations/' . $conversation . '/attachments',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLINFO_HEADER_OUT => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic ' . base64_encode($auth),
                'Content-Type: application/json'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
    
        $response = json_decode($response, true);
        $attachment_id = $response['data']['attachment_id'];
    
        return $attachment_id;
    }
    
    function get_booking_message_data($msg_id_int){
        $sql = "SELECT dc_booking_messages.*
        FROM dc_booking_messages WHERE id = $msg_id_int";
        return $this->db->query( $sql )->row_array();
    }
}
?>