<?php 
class dcm_dorms extends dcm_abstract {
    public function __construct() {
        parent::__construct();
        
        $this->dc_id = 20;
        $this->table_name_r2c = "dc_dorms_rate2category_link";
        $this->table_name_dc_category2occupancy = "dc_dorms_category2occupancy";
        $this->table_name_dc2hms_category_link = "dc_dorms_room_categories_link";
        
        
        $this->sql_dc_rates = "select  dc_rate_id as dc_rate_id, name as dc_rate_name, active from dc_dorms_rates";
        $this->sql_dc_category_link = "select dc_dorms_room_categories.name as dc_category_name, categories.name as hms_category_name,
            dc_dorms_room_categories_link.dc_category_id as dc_category_id,
            hms_category_id as hms_category_id
            from dc_dorms_room_categories_link 
            inner join dc_dorms_room_categories on 
            dc_dorms_room_categories_link.dc_category_id = dc_dorms_room_categories.dc_room_id 
        	LEFT join categories on 
            categories.id = dc_dorms_room_categories_link.hms_category_id";
        $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id
            from dc_dorms_rate2category_link";
        
       /* $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name, roomcategory from dc_dorms_occupancy ORDER BY id ASC";
          */
        $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name from dc_dorms_occupancy ORDER BY id ASC";
        $this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories";
        
        $this->sql_dc_category_list = "select name as dc_category_name,
            dc_room_id as dc_category_id, active from dc_dorms_room_categories";
        $this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_dorms_category2occupancy";
        $this->form_action_c2o_post = "/dc_dorms/categories_edit_post";
        $this->form_action_r2c_post = "/dc_dorms/rates_edit_post";
        
        $this->form_action_c2o_post_c2 = "/dc_dorms_c2/categories_edit_post";
        $this->form_action_r2c_post_c2 = "/dc_dorms_c2/rates_edit_post";
    }
    
    function gethotelid() {
    	$query = $this->db->query ( "SELECT int_value FROM dc_dorms_xml_cfg WHERE name='hotel_id'" );
    	if($query->num_rows() > 0){
    		$row = $query->row ();
    		return $row->int_value;
    	}else{
    		return 0;
    	}
    }
    
    function getauthparam()
    {
    	$data = array();
    	$dc_hotel_id = 0;
    	$property_secret = "";
    	$channel_key = "";
    	$currency = "USD";
    	$sql = "SELECT int_value FROM dc_dorms_xml_cfg WHERE name LIKE 'hotel_id'";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		if($row->int_value <> 0)
    			$dc_hotel_id = $row->int_value;
    	}
    	$data['dc_hotel_id'] = $dc_hotel_id;
    	
    	$sql = "SELECT str_value FROM dc_dorms_xml_cfg WHERE name LIKE 'property_secret'";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		if($row->str_value <> "")
    			$property_secret = $row->str_value;
    	}
    	$data['property_secret'] = $property_secret;
    	
//     	$sql = "SELECT str_value FROM dc_dorms_xml_cfg WHERE name LIKE 'channel_key'";
//     	$query = $this->db->query($sql);
//     	if ($query->num_rows() > 0) {
//     		$row = $query->row();
//     		if($row->str_value <> "")
//     			$channel_key = $row->str_value;
//     	}
//     	$data['channel_key'] = $channel_key;

    	$data['channel_key'] = "+etrusPu74pefru";
    	
    	$sql = "SELECT str_value FROM dc_dorms_xml_cfg WHERE name LIKE 'currency'";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		if($row->str_value <> "")
    			$currency = $row->str_value;
    	}
    	$data['currency'] = $currency;
    	
    	return $data;
    }
    function options_save($data) {
    	$data_1 = $this->Loger_admin->get_values_col("dc_dorms_xml_cfg");
    
    	$sql = "INSERT INTO dc_dorms_xml_cfg (name, int_value) VALUES('dealer_id', '" . $data ["dealer"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["dealer"];
    	$query = $this->db->query ( $sql );
    	$sql = "INSERT INTO dc_dorms_xml_cfg (name, int_value) VALUES('overbooking_category_id', '" . $data ["overbooking_category"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["overbooking_category"];
    	$query = $this->db->query ( $sql );
    	$sql = "INSERT INTO dc_dorms_xml_cfg (name, int_value) VALUES('general_update', '" . $data ["general_update"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["general_update"];
    	$query = $this->db->query ( $sql );
    
    	$data_2 = $this->Loger_admin->get_values_col("dc_dorms_xml_cfg");
    	$this->Loger_admin->SaveLog_col($data_1, $data_2, "loger_admin", "dc_dorms_xml_cfg", "edit");
    }
    
    function get_bookings($data, $send_notification = 1, $db_name = "") {
    	$rates = array ();
    	
    	$query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id, dc_category_id FROM   dc_dorms_rate2category_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates [$row->dc_rate_id] [$row->dc_category_id] = $row->hms_rate_id;
    		}
    	}
    
    	$rates_names = array ();
    
    	$query = $this->db->query ( "SELECT name, dc_rate_id FROM  dc_dorms_rates" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates_names [$row->dc_rate_id] ["dc_rate_name"] = $row->name;
    		}
    	}
    
    	$categories = array ();
    	$dc_categories_types = array ();
    	$query = $this->db->query ( "SELECT dc_dorms_room_categories_link.dc_category_id, dc_dorms_room_categories_link.hms_category_id, 
    	dc_dorms_room_categories.room_type
    	FROM  dc_dorms_room_categories_link 
    	INNER JOIN  dc_dorms_room_categories ON  dc_dorms_room_categories.dc_room_id = dc_dorms_room_categories_link.dc_category_id" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories [$row->dc_category_id] = $row->hms_category_id;
    			$dc_categories_types [$row->dc_category_id] = $row->room_type;
    		}
    	}
    
    	$categories_names = array ();
    
    	$query = $this->db->query ( "SELECT id, name FROM categories" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories_names [$row->id] = $row->name;
    		}
    	}
    
    	$query = $this->db->query ( "SELECT id FROM rate WHERE isdefault = 1" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$price_type = $row->id;
    	}
    
    		
    	$query = $this->db->query ( "SELECT int_value FROM dc_dorms_xml_cfg WHERE name LIKE 'dealer_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$dealer = $row->int_value;
    	}
    
    	$query = $this->db->query ( "SELECT int_value FROM dc_dorms_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$overbooking_category_id = $row->int_value;
    	}
    
    
    	
    	$result_array = array ();
    
    	if (isset ( $data ["data"] )) {
			if (isset ( $data ["data"] ["bookings"] )) {
			} else {
				if (isset ( $data ["data"] ["booking"] )) {
					$data ["data"] ["bookings"] [0] = $data ["data"] ["booking"];
				}
			}
			$reservations = array ();
			if (isset ( $data ["data"] ["bookings"] [0] )) {
				$reservations = $data ["data"] ["bookings"];
			} else {
				$reservations [0] = $data ["data"] ["bookings"];
			}
			if (! isset ( $reservations [0] ["booking_id"] )) {
				echo "no bookings";
				return;
			}
			$counter = 0;
			// echo "<pre>";
			// print_r($reservations);
			$otelms_rooms = array ();
			foreach ( $reservations as $reservation ) {
				$create_intgroup_bool = 0;
				$reservation ["booking_id"] = str_replace ( "DORMS-", "", $reservation ["booking_id"] );
				$sql = "SELECT id, dc_uuid FROM deskofreservation WHERE deleted = 0 AND cancel = 0 AND dc_id = 20 AND dc_reservationid = " . $reservation ["booking_id"];
				// echo $sql."<pre>";
				$query = $this->db->query ( $sql );
				
				if ($query->num_rows () > 0) {
					foreach ( $query->result () as $row ) {
						$otelms_rooms [$reservation ["booking_id"]] [$row->dc_uuid] ["otelms_reservation_id"] = $row->id;
						$otelms_rooms [$reservation ["booking_id"]] [$row->dc_uuid] ["dc_uuid"] = $row->dc_uuid;
						$otelms_rooms [$reservation ["booking_id"]] [$row->dc_uuid] ["status"] = 0;
					}
				}
				 print_r($otelms_rooms);
				$rooms_data = array ();
				if (! isset ( $reservation ["rooms"] [0] )) {
					
					$rooms_data [0] = $reservation ["rooms"];
				} else {
					$rooms_data = $reservation ["rooms"];
				}
				
				
				
				$qty = count ( $rooms_data );
				$rooms_inc = 0;
				for($j = 0; $j < $qty; $j ++) {
					$dc_room_id = $rooms_data [$j] ["room_id"];
					$rooms_dc_uuid_inc = 0;
					$room_count = 1;
					if(isset($dc_categories_types[$dc_room_id])){
						if($dc_categories_types[$dc_room_id] == "dorm"){
							$room_count = $rooms_data [$j] ["adults_number"];
						}
					}
					for($adults_inc = 1; $adults_inc <= $room_count; $adults_inc++) {
						$dc_total_price = 0;
						$k = 0;
						foreach ( $rooms_data [$j] ["daily_prices"] as $date => $daily_price ) {
							$date = str_replace ( " ", "", $date );
							$dc_rate_id = $daily_price ["rate_id"];
							$result_array ["reservations"] [$counter] [$rooms_inc] ["per_day"] [$k] ["dc_currencycode"] = $reservation ["currency"];
							$result_array ["reservations"] [$counter] [$rooms_inc] ["per_day"] [$k] ["dc_reservation_id"] = $reservation ["booking_id"] . "_" . $dc_room_id . "_" . $rooms_inc;
							$result_array ["reservations"] [$counter] [$rooms_inc] ["per_day"] [$k] ["price"] = $daily_price ["price"]/$rooms_data [$j] ["adults_number"];
							$result_array ["reservations"] [$counter] [$rooms_inc] ["per_day"] [$k] ["dc_rate_id"] = $dc_rate_id;
							if (isset ( $rates_names [$dc_rate_id] ["dc_rate_name"] )) {
								$result_array ["reservations"] [$counter] [$rooms_inc] ["per_day"] [$k] ["dc_rate_name"] = $rates_names [$dc_rate_id] ["dc_rate_name"];
							} else {
								$result_array ["reservations"] [$counter] [$rooms_inc] ["per_day"] [$k] ["dc_rate_name"] = "";
							}
							if (trim ( $date ) != "") {
								list ( $year, $month, $day ) = explode ( "-", $date );
								$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
							} else {
								$intdate = "";
							}
							$result_array ["reservations"] [$counter] [$rooms_inc] ["per_day"] [$k] ["intdate"] = $intdate;
							$result_array ["reservations"] [$counter] [$rooms_inc] ["per_day"] [$k] ["date_rate"] = $date;
							if (isset ( $rates [$dc_rate_id] [$dc_room_id] )) {
								$price_type = $rates [$dc_rate_id] [$dc_room_id];
							}
							$dc_total_price += $daily_price ["price"]/$rooms_data [$j] ["adults_number"];
							$k ++;
						}
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["dc_rate_id"] = $dc_rate_id;
						$result_array ["reservations"] [$counter] [$rooms_inc] ["currencycode"] = $reservation ["currency"];
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["card"] ["cc_cvc"] = "";
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["card"] ["ExpMonth"] = "";
						$result_array ["reservations"] [$counter] [$rooms_inc] ["card"] ["ExpYear"] = "";
						$result_array ["reservations"] [$counter] [$rooms_inc] ["card"] ["CardHolder"] = "";
						$result_array ["reservations"] [$counter] [$rooms_inc] ["card"] ["CardNumber"] = $reservation ["credit_card"] ["number"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["card"] ["cc_type"] = $reservation ["credit_card"] ["type"];
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["guest"] ["address"] = $reservation ["customer"] ["address"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["guest"] ["city"] = $reservation ["customer"] ["city"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["guest"] ["email"] = $reservation ["customer"] ["email"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["guest"] ["firstname"] = $reservation ["customer"] ["first_name"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["guest"] ["lastname"] = $reservation ["customer"] ["last_name"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["guest"] ["phone"] = $reservation ["customer"] ["phone"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["guest"] ["country"] = $reservation ["customer"] ["country"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["guest"] ["passportid"] = "";
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["status"] = $reservation ["status"];
						// $result_array ["reservations"] [$i] ["status"] = "cancelled";
						$result_array ["reservations"] [$counter] [$rooms_inc] ["dc_reservationid"] = $reservation ["booking_id"];
						
						$created_date = str_replace ( " ", "", substr ( $reservation ["created"], 0, 12 ) );
						$created_time = substr ( $reservation ["created"], 13, 8 );
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_id"] = 20;
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["commissionamount"] = 0;
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["date"] = $created_date;
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_reservationid"] = $reservation ["booking_id"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["time"] = $created_time;
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_date"] = $created_date;
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_time"] = $created_time;
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_updatetime"] = $reservation ["modified"];
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["isNew"] = 1;
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["datein"] = str_replace ( " ", "", $reservation ["arrival_date"] );
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dateout"] = str_replace ( " ", "", $reservation ["departure_date"] );
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["checkintime"] = $reservation ["arrival_hour"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["checkouttime"] = "";
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_roomreservation_id"] = "";
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_uuid"] = $reservation ["booking_id"] . "_" . $dc_room_id . "_" . $rooms_dc_uuid_inc;
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["category_id"] = $dc_room_id;
						if (isset ( $categories_names [$categories [$dc_room_id]] )) {
							$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["reservation_type_name"] = $categories_names [$categories [$dc_room_id]];
						} else {
							$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["reservation_type_name"] = "";
						}
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["placement_id"] = "";
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["add_places"] = 0;
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["baby_places"] = 0;
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["amount"] = $dc_total_price;
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["price_type"] = $price_type;
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["description"] = "";
						if (isset ( $_SESSION ["user"] ["id"] )) {
							$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["user"] = $_SESSION ["user"] ["id"];
						} else {
							$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["user"] = - 1;
						}
						
						if (isset ( $categories [$dc_room_id] )) {
							$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["type_id"] = $categories [$dc_room_id];
							$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_type_id"] = $dc_room_id;
						} else {
							$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["type_id"] = 0;
							$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_type_id"] = 0;
						}
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dealer"] = $dealer;
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_guestname"] = $reservation ["customer"] ["first_name"] . " " . $reservation ["customer"] ["last_name"];
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_numberofguest"] = $rooms_data [$j] ["adults_number"];
						if(isset($dc_categories_types[$dc_room_id])){
							if($dc_categories_types[$dc_room_id] == "dorm"){
								$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_numberofguest"] = 1;
							}
						}
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_countrycode"] = "";
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_currencycode"] = $reservation ["currency"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_city"] = "";
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_customerremarks"] = $reservation ["notes"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_roomremarks"] = $reservation ["notes"];
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["description"] = $reservation ["notes"];
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["dc_totalprice"] = $dc_total_price;
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["smoking"] = "";
						
						$result_array ["reservations"] [$counter] [$rooms_inc] ["roomreservation_id"] = "";
						
						if ($qty > 1 || $room_count > 1) {
							$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["groupid"] = $reservation ["booking_id"];
							/*
							 * ============ DORMS SET INT GROUP ======================
							 * 
							 */
							if($create_intgroup_bool == 0){
								$group_name = "DORMS-".$reservation ["booking_id"];
								$intgroupid = $this->group_res_model->makenewid($group_name);
								$create_intgroup_bool = 1;
							}
							$result_array ["reservations"] [$counter] [$rooms_inc] ["reservation"] ["intgroupid"] = $intgroupid;
						}
						$rooms_inc++;
						$rooms_dc_uuid_inc++;
					}
					
				}
				
				$counter ++;
			}
		}
    	echo "<pre>";
    	print_r ( $result_array );
    	//die ();
    
    	$host = "";
    	if($db_name <> ""){
    		$query = $this->db->query ( "SELECT host FROM visitka.config WHERE db_name LIKE '".$db_name."'" );
    		
    		if ($query->num_rows () > 0) {
    			$row = $query->row ();
    			$host = $row->host;
    		}
    	}else{
    		if ($_SERVER ["HTTP_HOST"]) {
    			$host = $_SERVER ["HTTP_HOST"];
    		}
    	}
    
    	$reservationpush = array ();
    
    	if (isset ( $result_array ["reservations"] )) {
    		$k = 0;
    
    		$bool_cancel = 0;
    		$guest_array = array ();
    		$guest_counter = 1;
    		foreach ( $result_array ["reservations"] as $key => $reservations ) {
    			$dc_reservationid = $reservations [0] ["reservation"] ["dc_reservationid"];
    			$res_count = count ( $reservations );
    			$bool_guest = 0;
    			for($i = 0; $i < $res_count; $i ++) {
    				$sql = "SELECT id, room_id FROM deskofreservation WHERE dc_updatetime = '".$reservations [$i] ["reservation"] ["dc_updatetime"]."' AND dc_id = 20 AND cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations [$i] ["reservation"] ["dc_uuid"] . "' AND dc_reservationid = ".$reservations [$i] ["reservation"] ["dc_reservationid"]." ORDER BY id DESC ";
    
    				$query = $this->db->query ( $sql );
    				$hms_reservation_id = 0;
    				$otelms_room_id = 0;
    				if ($query->num_rows () > 0) {
    					$row = $query->row ();
    						
    					if(isset($otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]])){
    						$otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    					}
    					
    				}
    				
    				$sql = "SELECT id, room_id FROM deskofreservation WHERE dc_updatetime = '".$reservations [$i] ["reservation"] ["dc_updatetime"]."' AND dc_id = 20 AND dc_uuid LIKE '" . $reservations [$i] ["reservation"] ["dc_uuid"] . "' AND dc_reservationid = ".$reservations [$i] ["reservation"] ["dc_reservationid"]." ORDER BY id DESC ";
    				
    				$query = $this->db->query ( $sql );
    				$hms_reservation_id = 0;
    				$otelms_room_id = 0;
    				if ($query->num_rows () > 0) {
    					$row = $query->row ();
    					
    					$reservationpush [$k] ["status"] = "skip";
    					$reservationpush [$k] ["hms_reservation_id"] = $row->id;
    					$result_array ["reservations"] [$key] [$i] ["status"] = "skip";
    					$k++;
    					//die();
    					continue;
    				}
    
    				//=========================================================================
    
    				$calculate_data = array ();
    				$calculate_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
    				$calculate_data ["datein"] = $reservations [$i] ["reservation"] ["datein"];
    				$calculate_data ["dateout"] = $reservations [$i] ["reservation"] ["dateout"];
    				$calculate_data ["add_places"] = $reservations [$i] ["reservation"] ["add_places"];
    				$calculate_data ["baby_places"] = $reservations [$i] ["reservation"] ["baby_places"];
    				$calculate_data ["addbedplace"] = 0;
    				$calculate_data ["babyplace2"] = 0;
    				$calculate_data ["price_type"] = $reservations [$i] ["reservation"] ["price_type"];
    
    				$temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
    				$otelms_amount = 0;
    				for($p = 0; $p < count ( $temp_amount ); $p ++) {
    					$otelms_amount += $temp_amount [$p] ["amount"];
    				}
    				$booking_amount = $reservations [$i] ["reservation"] ["amount"];
    				//$reservations [$i] ["reservation"] ["discount"] = 0;
    				if ($booking_amount != $otelms_amount) {
    					//if ($otelms_amount != 0) {
    					$reservations [$i] ["reservation"] ["discount"] = $otelms_amount - $booking_amount;
    					//}
    				}
    
    				//=====================================================
    				//=====================================================
    				//=====================================================
    
    				$datein = $reservations [$i] ["reservation"] ["datein"];
    				$dateout = $reservations [$i] ["reservation"] ["dateout"];
    				$type_id = $reservations [$i] ["reservation"] ["type_id"];
    				$sql = "SELECT id, room_id FROM deskofreservation WHERE dc_id = 20 AND cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations [$i] ["reservation"] ["dc_uuid"] . "' AND dc_reservationid = ".$reservations [$i] ["reservation"] ["dc_reservationid"]." ORDER BY id DESC ";
    				//echo $sql;
    				$query = $this->db->query ( $sql );
    				$hms_reservation_id = 0;
    				$otelms_room_id = 0;
    				if ($query->num_rows () > 0) {
    					$row = $query->row ();
    					$hms_reservation_id = $row->id;
    					$otelms_room_id = $row->room_id;
    				}
    				//$reservations [$i] ["reservation"] ["dc_totalprice"] = 0;
    				//foreach ( $reservations [$i] ["per_day"] as $cell ) {
    				//	$reservations [$i] ["reservation"] ["dc_totalprice"] += $cell ["price"];
    				//	$reservations [$i] ["reservation"] ["amount"] += $cell ["price"];
    				//}
    				if (isset ( $reservations [$i] ["per_day"] )) {
    
    					$this->dc_rate_intdate_insert ( $reservations [$i] ["per_day"] );
    				}
    
    				//if ($reservations [1] ["status"] == "modified") {
    				//	$reservations [$i] ["reservation"] ["specialstatus"] = "modified";
    				//}
    
    				if ($reservations [$i] ["status"] == "canceled") {
    					if(isset($otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]])){
    						$otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    					}
    					$query2 = $this->db->query ( "SELECT deskofreservation.datein, deskofreservation.dateout, rooms.category_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id WHERE dc_id = 20 AND deskofreservation.id = $hms_reservation_id" );
    
    					if ($query2->num_rows () > 0) {
    						$row2 = $query2->row ();
    						$datein = $row2->datein;
    						$dateout = $row2->dateout;
    						$type_id = $row2->category_id;
    					}
    
    					$time2 = date ( "Y-m-d H:i:s" );
    					$status = 5;
    					$query2 = $this->db->query ( "SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2" );
    
    					if ($query2->num_rows () > 0) {
    						$reservationpush [$k] ["response"] = "failed";
    						$reservationpush [$k] ["text"] = "есть уже отмена";
    						$reservationpush [$k] ["status"] = "cancel";
    
    						$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    						$k ++;
    
    						$dc_log_data = array ();
    						$dc_log_data ["datein"] = $datein;
    						$dc_log_data ["dateout"] = $dateout;
    						$dc_log_data ["category_id"] = $type_id;
    						$this->frontdesk->dc_log_update ( $dc_log_data );
    					} else {
    						$sql = "SELECT id FROM deskofreservation WHERE id = " . $hms_reservation_id;
    						echo $sql;
    						$query2 = $this->db->query ( $sql );
    
    						if ($query2->num_rows () > 0) {
    							$data_cancel = array ();
    
    							$data_cancel ["res_id"] = $hms_reservation_id;
    							$data_cancel ["charge"] = 0;
    							$data_cancel ["status"] = 5;
    							;
    							$data_cancel ["description"] = "cancel from 101otel";
    							$data_cancel ["guestbe_request"] = 0;
    							$data_cancel ["user"] = - 1;
    							// ====================
    							$this->Cancel->Insert ( $data_cancel );
    							// ====================
    							$query2 = $this->db->query ( "UPDATE deskofreservation SET dc_updatetime = '".$reservations [$i] ["reservation"] ["dc_updatetime"]."' WHERE id = " . $hms_reservation_id );
    							$reservationpush [$k] ["response"] = "ok";
    							$reservationpush [$k] ["text"] = "";
    							$reservationpush [$k] ["status"] = "cancel";
    							$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    							$k ++;
    						} else {
    							$reservationpush [$k] ["response"] = "failed";
    							$reservationpush [$k] ["text"] = "нет брони для отмены";
    							$reservationpush [$k] ["status"] = "skip";
    
    							$reservationpush [$k] ["hms_reservation_id"] = 0;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    							$k ++;
    						}
    					}
    				} else {
    
    					if($hms_reservation_id == 0){
    						/*
    						 * NEW RESERVATION BLOCK
    						*/
    
    						$room_id = 0;
    
    						if ($type_id == 0 or $type_id == "") {
    							$query2 = $this->db->query ( "SELECT int_value FROM dc_hotels24_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    							if ($query->num_rows () > 0) {
    								$row2 = $query2->row ();
    								$type_id = $row2->int_value;
    							}
    						}
    						if ($type_id == 0 or $type_id == "") {
    							$reservationpush [$k] ["response"] = "error";
    							$reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
    							$reservationpush [$k] ["status"] = "update";
    							$reservationpush [$k] ["hms_reservation_id"] = $row->id;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    							$result_array ["reservations"] [$key] [$i] ["status"] = "update";
    							$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    							$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$k ++;
    						} else {
    							$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
    							if ($room_id == 0) {
    								$reservations [$i] ["reservation"] ["is_overbook"] = 1;
    								if (isset ( $overbooking_category_id )) {
    									$reservations [$i] ["reservation"] ["origin_categoryid"] = $type_id;
    									$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
    
    									$insert_over_room_bool = 0;
    									if ($room_id == 0) {
    										$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
    										$insert_over_room_bool = 1;
    									}
    									
    								} else {
    									$reservationpush [$k] ["response"] = "failed";
    									$reservationpush [$k] ["text"] = "no overbooking_category_id";
    									$reservationpush [$k] ["status"] = "new";
    									$reservationpush [$k] ["hms_reservation_id"] = 0;
    									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    									$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    									$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								}
    							}
    							$reservations [$i] ["reservation"] ["room_id"] = $room_id;
    
    							if ($bool_guest == 0) {
    								$guest_id = $this->frontdesk->Guest_insert ( $reservations [$i] ["guest"] );
    								$bool_guest = 1;
    							}
    							print_r($reservations [$i] ["reservation"]);
    							$reservation_id = $this->frontdesk->Reservation_insert ( $reservations [$i] ["reservation"], $guest_id, 0, 1 );
    
    							if(isset($otelms_rooms [$dc_reservationid] [$reservations [$i] ["reservation"] ["dc_uuid"]])){
    								$otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    							}
    
    							if (isset ( $reservations [$i] ["card"] )) {
    								$this->frontdesk->insert_tbl_CreditCards ( $reservations [$i] ["card"], $guest_id, $reservation_id );
    							}
    
    							if ($reservation_id > 0) {
    								$reservationpush [$k] ["response"] = "ok";
    								$reservationpush [$k] ["text"] = "";
    								$reservationpush [$k] ["status"] = "new";
    								$reservationpush [$k] ["hms_reservation_id"] = $reservation_id;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    								$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    								$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$k ++;
    							} else {
    								$reservationpush [$k] ["response"] = "failed";
    								$reservationpush [$k] ["text"] = "undferror";
    								$reservationpush [$k] ["status"] = "new";
    								$reservationpush [$k] ["hms_reservation_id"] = 0;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    								$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    								$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$k ++;
    							}
    						}
    					}else{
    						/*
    						 * UPDATE RESERVATION BLOCK
    						*
    						*/
    
    
    						$reservation_data = $this->frontdesk->GetReservation ( $hms_reservation_id );
    
    						//$reservation_data ["user"] = $xml_array ["reservations"] [$dc_reservationid] ["room"] [$cell ["dc_roomreservation_id"]] ["reservation"] ["user"];
    						$reservation_data ["firstname"] = $reservations [$i] ["guest"] ["firstname"];
    						$reservation_data ["lastname"] = $reservations [$i] ["guest"] ["lastname"];
    						$reservation_data ["phone"] = $reservations [$i] ["guest"] ["phone"];
    						$reservation_data ["email"] = $reservations [$i] ["guest"] ["email"];
    
    						$reservation_data ["amount"] = $reservations [$i] ["reservation"] ["amount"];
    						$reservation_data ["discount"] = $reservations [$i] ["reservation"] ["discount"];
    						$reservation_data ["date"] = $reservations [$i] ["reservation"] ["date"];
    						$reservation_data ["add_places"] = $reservations [$i] ["reservation"] ["add_places"];
    						$reservation_data ["baby_places"] = $reservations [$i] ["reservation"] ["baby_places"];
    						$reservation_data ["datein"] = $reservations [$i] ["reservation"] ["datein"];
    						$reservation_data ["dateout"] = $reservations [$i] ["reservation"] ["dateout"];
    						$reservation_data ["checkintime"] = $reservations [$i] ["reservation"] ["checkintime"];
    						$reservation_data ["checkouttime"] = $reservations [$i] ["reservation"] ["checkouttime"];
    
    
    						//$reservation_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
    						$reservation_data ["price_type"] = $reservations [$i] ["reservation"] ["price_type"];
    						$reservation_data ["guest_id_new"] = 0;
    						$reservation_data ["free_places"] = 0;
    						$reservation_data ["maid_description"] = "";
    						$reservation_data ["isread"] = 0;
    						$reservation_data ["dc_guestname"] = $reservations [$i] ["reservation"] ["dc_guestname"];
    						$reservation_data ["dc_currencycode"] = $reservations [$i] ["reservation"] ["dc_currencycode"];
    						$reservation_data ["dc_countrycode"] = $reservations [$i] ["reservation"] ["dc_countrycode"];
    						$reservation_data ["dc_city"] = $reservations [$i] ["reservation"] ["dc_city"];
    						$reservation_data ["dc_customerremarks"] = $reservations [$i] ["reservation"] ["dc_customerremarks"];
    						$reservation_data ["dc_roomremarks"] = $reservations [$i] ["reservation"] ["dc_roomremarks"];
    						$reservation_data ["dc_numberofguest"] = $reservations [$i] ["reservation"] ["dc_numberofguest"];
    						$reservation_data ["dc_totalprice"] = $reservations [$i] ["reservation"] ["dc_totalprice"];
    						$reservation_data ["smoking"] = $reservations [$i] ["reservation"] ["smoking"];
    
    						$reservation_data ["description"] = $reservations [$i] ["reservation"] ["dc_customerremarks"];
    							
    						$reservation_data ["dc_date"] = $reservations [$i] ["reservation"] ["dc_date"];
    						$reservation_data ["dc_time"] = $reservations [$i] ["reservation"] ["dc_time"];
    						$reservation_data ["dc_updatetime"] = $reservations [$i] ["reservation"] ["dc_updatetime"];
    
    						// print_r($reservation_data);
    
    						if ($reservation_data ["type_id"] == $type_id) {
    							$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );
    						} else {
    							$can_resize = 0;
    							$reservation_data ["type_id"] = $type_id;
    						}
    
    						//$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );
    
    						if($can_resize == 1){
    
    							$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
    
    							if(isset($otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]])){
    								$otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    							}
    							if ($update_res == "FreeError") {
    								$reservationpush [$k] ["response"] = "error";
    								$reservationpush [$k] ["text"] = "";
    								$reservationpush [$k] ["status"] = "modified";
    								$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
    								$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
    								$k ++;
    							}else{
    								$reservationpush [$k] ["response"] = "ok";
    								$reservationpush [$k] ["text"] = "";
    								$reservationpush [$k] ["alert"] = "";
    								$reservationpush [$k] ["status"] = "modified";
    								$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
    								$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
    								$k ++;
    							}
    						}else{
    							if ($type_id == 0 or $type_id == "") {
    								$query2 = $this->db->query ( "SELECT int_value FROM dc_101otel_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    								if ($query->num_rows () > 0) {
    									$row2 = $query2->row ();
    									$type_id = $row2->int_value;
    								}
    							}
    							if ($type_id == 0 or $type_id == "") {
    								$reservationpush [$k] ["response"] = "error";
    								$reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
    								$reservationpush [$k] ["status"] = "modified";
    								$reservationpush [$k] ["hms_reservation_id"] = $row->id;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    								$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$k ++;
    							} else {
    								$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
    								if ($room_id == 0) {
    									$reservation_data ["is_overbook"] = 1;
    									if (isset ( $overbooking_category_id )) {
    										$reservations [$i] ["reservation"] ["origin_categoryid"] = $type_id;
    										$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
    
    										$insert_over_room_bool = 0;
    										if ($room_id == 0) {
    											$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
    											$insert_over_room_bool = 1;
    										}
    									} else {
    										$reservationpush [$k] ["response"] = "failed";
    										$reservationpush [$k] ["text"] = "no overbooking_category_id";
    										$reservationpush [$k] ["status"] = "new";
    										$reservationpush [$k] ["hms_reservation_id"] = 0;
    										$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    										$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    										$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    										$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    										$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    										$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    									}
    								}
    								$reservation_data ["room_id"] = $room_id;
    
    								$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
    
    								if(isset($otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]])){
    									$otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    								}
    
    								if ($update_res == "FreeError") {
    									$reservationpush [$k] ["response"] = "error";
    									$reservationpush [$k] ["text"] = "";
    									$reservationpush [$k] ["status"] = "modified";
    									$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    									$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
    									$k ++;
    								}else{
    									$reservationpush [$k] ["response"] = "ok";
    									$reservationpush [$k] ["text"] = "";
    									$reservationpush [$k] ["alert"] = "";
    									$reservationpush [$k] ["status"] = "modified";
    									$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    									$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
    									$k ++;
    								}
    							}
    						}
    					}
    				}
    				// }
    
    			}
    			 
    			//echo "=======================================";
    			print_r ( $otelms_rooms );
    			if (isset ( $otelms_rooms [$dc_reservationid] )) {
    				foreach ( $otelms_rooms [$dc_reservationid] as $cell ) {
    					if ($cell ["status"] == 0) {
    						// $this->frontdesk->DeleteReservation($cell["otelms_reservation_id"]);
    						$status = 5;
    						$data_cancel = array ();
    						$data_cancel ["res_id"] = $cell ["otelms_reservation_id"];
    						$data_cancel ["charge"] = 0;
    						$data_cancel ["status"] = $status;
    						$data_cancel ["description"] = "cancel from dorms";
    						$data_cancel ["guestbe_request"] = 0;
    						$data_cancel ["user"] = - 1;
    						// ====================
    						$this->Cancel->Insert ( $data_cancel );
    					}
    				}
    			}
    		}
    
    		//print_r ( $result_array );
    		//print_r ( $otelms_rooms );
    		//die();
    
    
    		//die();
    		$counter_r = 0;
    		$new_mass = array ();
    		foreach ( $result_array ["reservations"] as $cell ) {
    
    			//print_r($cell);
    			$res_count = count ( $cell );
    			//echo "+++++++++++++++++++++++".$res_count;
    			for($i = 0; $i < $res_count; $i ++) {
    				if ($cell [$i] ["status"] == "modified" or $cell [$i] ["status"] == "new") {
    					$new_mass ['dcname'] = "Dorms";
    					$new_mass ['status'] = $cell [$i] ["status"];
    					$new_mass ['dc_reservationid'] = $cell [$i] ["reservation"]["dc_reservationid"];
    					$new_mass ['dc_channel_name'] = "Dorms";
    					$new_mass ['hotel_name'] = "hotel_name";
    					$new_mass ['guest_firstname'] = $cell [$i] ["guest"]  ["firstname"];
    					$new_mass ['guest_lastname'] = $cell [$i] ["guest"]  ["lastname"];
    					$new_mass ['guest_phone'] = $cell [$i] ["guest"] ["phone"];
    					$new_mass ['guest_email'] = $cell [$i] ["guest"] ["email"];
    
    					$new_mass ["room"] [$counter_r]["reservation_current"] = $i;
    					$new_mass ["room"] [$counter_r]["reservation_alert"] = $cell [$i] ["reservation"] ["reservation_alert"];
    					$new_mass ["room"] [$counter_r]["hms_reservation_id"] = $cell [$i] ["reservation"] ["hms_reservation_id"];
    					$new_mass ["room"] [$counter_r]["url"] = $cell [$i] ["reservation"] ["url"];
    					$new_mass ["room"] [$counter_r]["dc_channel_name"] = "Dorms";
    
    					$new_mass ["room"] [$counter_r]["reservation_dc_reservationid"] = $cell [$i] ["reservation"] ["dc_reservationid"];
    					$new_mass ["room"] [$counter_r]["reservation_dc_roomreservation_id"] = $cell [$i] ["reservation"] ["dc_roomreservation_id"];
    					$new_mass ["room"] [$counter_r]["hotel_name"] = "hotel_name";
    					$new_mass ["room"] [$counter_r]["reservation_date"] = $cell [$i] ["reservation"]["date"];
    					$new_mass ["room"] [$counter_r]["status"] = $cell [$i] ["status"];
    					$new_mass ["room"] [$counter_r]["reservation_datein"] = $cell [$i] ["reservation"]["datein"];
    					$new_mass ["room"] [$counter_r]["reservation_dateout"] = $cell [$i] ["reservation"]["dateout"];
    					$new_mass ["room"] [$counter_r]["reservation_type_name"] = $cell [$i] ["reservation"]["reservation_type_name"];
    					$new_mass ["room"] [$counter_r]["reservation_category_id"] = $cell [$i] ["reservation"]["type_id"];
    					$new_mass ["room"] [$counter_r]["reservation_dc_totalprice"] = $cell [$i] ["reservation"]["dc_totalprice"];
    					$new_mass ["room"] [$counter_r]["reservation_dc_customerremarks"] = $cell [$i] ["reservation"]["dc_customerremarks"];
    
    					$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"] = $cell [$i] ["per_day"];
    
    					$counter_r++;
    				}
    			}
    
    		}
    		if(count($new_mass) > 0){
    			//print_r($new_mass);
    			$this->dc_model->send_notifyarray_new ( $new_mass );
    		}
    
    	}
    
    	print_r ( $reservationpush );
    	foreach ( $reservationpush as $arg ) {
    		if ($arg ['status'] == "cancel") {
    			$data = array ();
    			$data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
    			$data ['response'] = $arg ['response'];
    			$data ['resid'] = $arg ['dc_reservationid'];
    			$data ['dcname'] = "Dorms";
    			$data ['status'] = $arg ['status'];
    			$data ['text'] = $arg ['text'];
    			$this->dc_model->send_notifyarray ( $data );
    		}
    	}
    	return json_encode($reservationpush, true);
    }
    function dc_rate_intdate_insert($data) {
    	$count = count ( $data );
    	if ($count != 0) {
    		foreach ( $data as $cell ) {
    			$query = $this->db->query ( "DELETE FROM dc_dorms_rate_intdate WHERE dc_reservation_id LIKE '" . $cell ["dc_reservation_id"]."'" );
    			break;
    		}
    		foreach ( $data as $cell ) {
    			$sql = "INSERT INTO dc_dorms_rate_intdate (dc_reservation_id, dc_rate_id, intdate, price) VALUES('" . $cell ["dc_reservation_id"] . "',
		'" . $cell ["dc_rate_id"] . "', '" . $cell ["intdate"] . "', '" . $cell ["price"] . "')
		ON DUPLICATE KEY UPDATE price = '" . $cell ["price"] . "'";
    			// echo $sql;
    			$query = $this->db->query ( $sql );
    		}
    	}
    }
}