<?php 
class dcm_agoda_v2 extends dcm_abstract {
    public function __construct() {
        parent::__construct();
        
        $this->dc_id = 5;
        $this->overbooking_category_id = $this->get_dc_overbooking_category_id();
        
        $this->table_name_r2c = "dc_agoda_rate2category_link";
        $this->table_name_dc_category2occupancy = "dc_agoda_category2occupancy";
        $this->table_name_dc2hms_category_link = "dc_agoda_room_categories_link";
        
        
        $this->sql_dc_rates = "select dc_rate_id as dc_rate_id, name as dc_rate_name, active from dc_agoda_rates";
        $this->sql_dc_category_link = "select dc_agoda_room_categories.name as dc_category_name, 
categories.name as hms_category_name, 
            dc_category_id as dc_category_id,
            hms_category_id as hms_category_id
            from dc_agoda_room_categories_link 
            inner join dc_agoda_room_categories on 
            dc_agoda_room_categories_link.dc_category_id = dc_agoda_room_categories.dc_room_id
inner join categories on categories.id=dc_agoda_room_categories_link.hms_category_id";
        $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id
            from dc_agoda_rate2category_link";
        
        $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name from dc_agoda_occupancy";
        $this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories";
        
        $this->sql_dc_category_list = "select name as dc_category_name,
            dc_room_id as dc_category_id, active from dc_agoda_room_categories";
        $this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_agoda_category2occupancy";
        $this->form_action_c2o_post = "/dc_agoda/categories_edit_post";
        $this->form_action_r2c_post = "/dc_agoda/rates_edit_post";
        
        $this->form_action_c2o_post_c2 = "/dc_agoda_c2/categories_edit_post";
        $this->form_action_r2c_post_c2 = "/dc_agoda_c2/rates_edit_post";
    }
}