<?
class dcm_academservice_v2 extends dcm_abstract {
	public function __construct() {
		parent::__construct ();
		$this->load->model ( 'Curl_model' );
		$this->load->model ( 'hotelix_config' );
		$this->dc_id = 27;
		$this->table_name_r2c = "dc_academ_service_rate2category_link";
		$this->table_name_dc_category2occupancy = "dc_academ_service_category2occupancy";
		$this->table_name_dc2hms_category_link = "dc_academ_service_room_categories_link";
				
		$this->sql_dc_rates = "select  CONCAT(dc_academ_service_rates.dc_hotel_id, '_', dc_rate_id) as dc_hotel_rate_id, dc_academ_service_rates.dc_hotel_id, dc_rate_id as dc_rate_id, name as dc_rate_name, active from dc_academ_service_rates";
		$this->sql_dc_category_link = "select dc_academ_service_room_categories.dc_hotel_id, dc_academ_service_room_categories.name as dc_category_name, categories.name as hms_category_name,
            dc_academ_service_room_categories_link.dc_category_id as dc_category_id,
            hms_category_id as hms_category_id
            from dc_academ_service_room_categories_link
            inner join dc_academ_service_room_categories on
            dc_academ_service_room_categories_link.dc_category_id = dc_academ_service_room_categories.dc_room_id
        	LEFT join categories on
            categories.id = dc_academ_service_room_categories_link.hms_category_id";
		$this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id,
        	CONCAT(dc_academ_service_room_categories.dc_hotel_id, '_', dc_rate_id) as dc_hotel_rate_id
            from dc_academ_service_rate2category_link
        	inner join dc_academ_service_room_categories on
            dc_academ_service_rate2category_link.dc_category_id = dc_academ_service_room_categories.dc_room_id ";
		
		$this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name, roomcategory from dc_academ_service_occupancy ORDER BY id ASC";
		$this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories WHERE is_active = 1";
		
		$this->sql_dc_category_list = "select dc_academ_service_xml_cfg.int_value as dc_hotel_id, dc_academ_service_room_categories.name as dc_category_name,
            dc_room_id as dc_category_id, active from dc_academ_service_room_categories
        	left join dc_academ_service_xml_cfg on
            dc_academ_service_room_categories.dc_hotel_id = dc_academ_service_xml_cfg.int_value and dc_academ_service_xml_cfg.name='hotel_id'";
		$this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_academ_service_category2occupancy";
		
		$this->form_action_c2o_post_c2 = "/dc_academ_service_c2/categories_edit_post";
		$this->form_action_r2c_post_c2 = "/dc_academ_service_c2/rates_edit_post";
	}
	
	function build_rate2category ($occupancy_bool = 0, $roomstorate = 0, $price_func = 0)
	{
		//$occupancy_bool = 0;
		$sql = $this->sql_dc_rates;
		//echo $sql."<br>";
		//die();
		$query = $this->db->query($sql);
		$rate2category = array();
		$hms_rates_list = $this->build_hms_rates();
		$hms_restrictions_list = $this->build_hms_restrictions();
		$hms_occupancies_list = $this->get_occupancies ($occupancy_bool);
	
		$c2o = $this->get_category2occupancy();
	
		$r2c_link = $this->get_r2c_link();
		 
		foreach ($query->result() as $rate_row) {
			$sql = $this->sql_dc_category_link;
	
			//echo $sql."<br>";
			$query2 = $this->db->query($sql);
	
			$rate2category[$rate_row->dc_hotel_rate_id] = array();
			$rate2category[$rate_row->dc_hotel_rate_id]['dc_rate_name'] = $rate_row->dc_rate_name;
			$rate2category[$rate_row->dc_hotel_rate_id]['dc_rate_id'] = $rate_row->dc_rate_id;
			if(isset($rate_row->dc_hotel_id)){
				$rate2category[$rate_row->dc_hotel_rate_id]['dc_hotel_id'] = $rate_row->dc_hotel_id;
			}else{
				$rate2category[$rate_row->dc_hotel_rate_id]['dc_hotel_id'] = "";
			}
			if (isset($rate_row->dc_property_name)) {
				$rate2category[$rate_row->dc_hotel_rate_id]['dc_property_name'] = $rate_row->dc_property_name;
			} else {
				$rate2category[$rate_row->dc_hotel_rate_id]['dc_property_name'] = "";
			}
	
			if(isset($rate_row->active)){
				$rate2category[$rate_row->dc_hotel_rate_id]['active'] = $rate_row->active;
			}else{
				$rate2category[$rate_row->dc_hotel_rate_id]['active'] = "active";
			}
			// ================================================================================
			if (isset($rate_row->restrict_name)) {
				$rate2category[$rate_row->dc_hotel_rate_id]['restrict_name'] = $rate_row->restrict_name;
			} else {
				$rate2category[$rate_row->dc_hotel_rate_id]['restrict_name'] = "";
			}
			// ================================================================================
			foreach ( $query2->result () as $category_row ) {
	
				if ($category_row->dc_hotel_id == $rate_row->dc_hotel_id) {
					$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['dc_category_name'] = $category_row->dc_category_name;
					$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['dc_category_id'] = $category_row->dc_category_id;
					if (isset ( $category_row->hms_category_name )) {
						$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['hms_category_name'] = $category_row->hms_category_name;
					} else {
						$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['hms_category_name'] = "";
					}
					$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['hms_category_id'] = $category_row->hms_category_id;
					$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['dc_rate_id'] = $rate_row->dc_rate_id;
					// $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_restrictions_list'] = $hms_restrictions_list;
					if ($occupancy_bool == 1) {
						if (isset ( $hms_occupancies_list [$category_row->dc_category_id] )) {
							foreach ( $hms_occupancies_list [$category_row->dc_category_id] as $occupancy_cell ) {
								if (isset ( $c2o [$category_row->dc_category_id] [$occupancy_cell ['hms_occupancy_id']] )) {
									$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_id'] = $rate_row->dc_rate_id;
									$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_name'] = $rate_row->dc_rate_name;
									$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_name'] = $category_row->dc_category_name;
									$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_id'] = $category_row->dc_category_id;
									$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_rates_list'] = $hms_rates_list;
									$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_price_func_list'] = $this->build_price_func ( $price_func );
									$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_restrictions_list'] = $hms_restrictions_list;
										
									$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_id'] = $occupancy_cell ['hms_occupancy_id'];
									$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_name'] = $occupancy_cell ['hms_occupancy_name'];
								}
							}
						}
					} else {
						foreach ( $hms_occupancies_list as $occupancy_cell ) {
							if (isset ( $c2o [$category_row->dc_category_id] [$occupancy_cell ['hms_occupancy_id']] )) {
								$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_id'] = $rate_row->dc_rate_id;
								$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_name'] = $rate_row->dc_rate_name;
								$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_name'] = $category_row->dc_category_name;
								$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_id'] = $category_row->dc_category_id;
								$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_rates_list'] = $hms_rates_list;
								$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_price_func_list'] = $this->build_price_func ( $price_func );
								$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_restrictions_list'] = $hms_restrictions_list;
	
								$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_id'] = $occupancy_cell ['hms_occupancy_id'];
								$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_name'] = $occupancy_cell ['hms_occupancy_name'];
							}
						}
					}
					if (! isset ( $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] )) {
						unset ( $rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] );
					}
					$rate2category [$rate_row->dc_hotel_rate_id] ['hms_restrictions_list'] = $hms_restrictions_list;
				}
			}
		}
		//echo "<pre>";
		//print_r($rate2category);
		//die();
		//
		$sql = $this->sql_dc_r2c;
		$query = $this->db->query($sql);
		//echo $sql."<br>";
		foreach ($query->result() as $row) {
			if (isset($c2o[$row->dc_category_id][$row->hms_occupancy_id])) {
				$rate2category[$row->dc_hotel_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_rates_list'][$row->hms_rate_id]['selected'] = 'selected';
				$rate2category[$row->dc_hotel_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
				$rate2category[$row->dc_hotel_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][0]['pf_selected'] = '';
				$rate2category[$row->dc_hotel_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][$row->hms_price_func_id]['pf_selected'] = 'selected';
			}
		}
	
		if ($this->sql_dc_r2rlink !== "") {
			$sql = $this->sql_dc_r2rlink;
			$query = $this->db->query($sql);
			// echo $sql;
			foreach ($query->result() as $row) {
				$rate2category[$row->dc_rate_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
			}
		}
		// echo "<pre>";
		// print_r($rate2category);
		return $rate2category;
	}
}
?>