<?php

class dcm_abstract extends CI_Model
{

    public $form_action_c2o_post = "";

    public $form_action_r2c_post = "";

    public $table_name_r2c = "";    
    
    public $table_name_rate = "";

    public $table_name_dc_category2occupancy = "";

    public $table_name_dc2hms_category_link = "";

    public $sql_dc_rates = "";

    public $sql_dc_r2c = "";
    
    public $sql_dc_r2r = "";

    public $sql_dc_r2rlink = "";

    public $sql_get_occupancies = "";

    public $sql_build_hms_categories = "";

    public $sql_dc_category_list = "";

    public $sql_dc_category_link = "";

    public $sql_dc_category2occupancy_list = "";

    public function __construct()
    {
        parent::__construct();
    }

    function get_dc_overbooking_category_id(){
    	$dc_cfg_table = "";
    	switch ($this->dc_id) {
			case 1 :
				$dc_cfg_table = "dc_booking_xml_cfg";
				break;
			case 2 :
				$dc_cfg_table = "dc_booking_xml_cfg";
				break;
			case 3 :
				$dc_cfg_table = "dc_expedia_xml_cfg";
				break;
			case 4 :
				$dc_cfg_table = "dc_hostelsclub_xml_cfg";
				break;
			case 5 :
				$dc_cfg_table = "dc_agoda_xml_cfg";
				break;
			case 6 :
				$dc_cfg_table = "dc_hotel_inn_xml_cfg";
				break;
			case 7 :
				$dc_cfg_table = "dc_oktogo_xml_cfg";
				break;
            case 8:
                $dc_cfg_table = "dc_hostelworld_xml_cfg";
                break;
            case 13:
                $dc_cfg_table = "dc_bronevik_xml_cfg";
                break;
            case 14:
                $dc_cfg_table = "dc_hotels24_xml_cfg";
                break;
            case 16:
                $dc_cfg_table = "dc_tripadvisor_xml_cfg";
                break;
            case 17:
                $dc_cfg_table = "dc_hotelbook_xml_cfg";
                break;
            case 19:
                $dc_cfg_table = "dc_dobovo_xml_cfg";
                break;
            case 20:
                $dc_cfg_table = "dc_dorms_xml_cfg";
                break;
            case 21:
                $dc_cfg_table = "dc_cbooking_xml_cfg";
                break;
            case 24:
                $dc_cfg_table = "dc_axis_travel_xml_cfg";
                break;
            case 25:
                $dc_cfg_table = "dc_onetwotrip_xml_cfg";
                break;
            case 26:
                $dc_cfg_table = "dc_tvil_xml_cfg";
                break;
            case 27:
                $dc_cfg_table = "dc_academ_service_xml_cfg";
                break;
            case 28:
                $dc_cfg_table = "dc_aanda_xml_cfg";
                break;
            case 29:
                $dc_cfg_table = "dc_nash_travel_xml_cfg";
                break;
            case 30:
                $dc_cfg_table = "dc_sutochno_xml_cfg";
                break;
            case 33:
                $dc_cfg_table = "dc_101hotels_xml_cfg";
                break;
            case 36:
                $dc_cfg_table = "dc_yandex_xml_cfg";
                break;
            case 37:
                $dc_cfg_table = "dc_hotelbeds_xml_cfg";
                break;
            case 40:
                $dc_cfg_table = "dc_su_xml_cfg";
                break;
        }
    	
    	$overbooking_category_id = 0;
    	$query = $this->db->query ( "SELECT int_value FROM ".$dc_cfg_table." WHERE name LIKE 'overbooking_category_id'" );
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$overbooking_category_id = $row->int_value;
    	}
    	
    	return $overbooking_category_id;
    }
    
    function get_occupancies_OLD()
    {
        $sql = $this->sql_get_occupancies;
        $query = $this->db->query($sql);
        $occupancies = array();
        foreach ($query->result() as $row) {
            $occupancies[$row->hms_occupancy_id]['hms_occupancy_id'] = $row->hms_occupancy_id;
            $occupancies[$row->hms_occupancy_id]['hms_occupancy_name'] = $row->hms_occupancy_name;
        }
        return $occupancies;
    }
    
    function get_occupancies ($occupancy_bool)
    {
    	$sql = $this->sql_get_occupancies;
    	//echo $sql;
    	$query = $this->db->query($sql);
    	$occupancies = array();
    	foreach ($query->result() as $row) {
    		if($occupancy_bool == 1){
    			$occupancies [$row->roomcategory] [$row->hms_occupancy_id]['hms_occupancy_id'] = $row->hms_occupancy_id;
    			$occupancies [$row->roomcategory] [$row->hms_occupancy_id]['hms_occupancy_name'] = $row->hms_occupancy_name;
    		}else{
    			$occupancies[$row->hms_occupancy_id]['hms_occupancy_id'] = $row->hms_occupancy_id;
    			$occupancies[$row->hms_occupancy_id]['hms_occupancy_name'] = $row->hms_occupancy_name;
    		}
    	}
    	return $occupancies;
    }

    function build_hms_categories()
    {
        
        $overbooking_category_id = $this->get_dc_overbooking_category_id();
        $categories = array();
        $sql = $this->sql_build_hms_categories;
        
        $query = $this->db->query($sql);
        $categories[0]['hms_category_id'] = 0;
        $categories[0]['hms_category_name'] = '---';
        $categories[0]['selected'] = '';
        foreach ($query->result() as $row) {
        	if($row->hms_category_id != $overbooking_category_id){
            	$categories[$row->hms_category_id]['hms_category_id'] = $row->hms_category_id;
            	$categories[$row->hms_category_id]['hms_category_name'] = $row->hms_category_name;
            	$categories[$row->hms_category_id]['selected'] = "";
        	}
        }
        return $categories;
    }

    function build_category2occupancy_OLD( $occupancy_bool = 0 )
    {
        $sql = $this->sql_dc_category_list;
        
        $c2o = array();
        
        $occupancies = $this->get_occupancies();
        $hms_categories = $this->build_hms_categories();
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $c2o[$row->dc_category_id]['dc_category_id'] = $row->dc_category_id;
            $c2o[$row->dc_category_id]['dc_category_name'] = $row->dc_category_name;
            if (isset($row->dc_property_name)) {
                $c2o[$row->dc_category_id]['dc_property_name'] = $row->dc_property_name;
            } else {
                $c2o[$row->dc_category_id]['dc_property_name'] = "";
            }
            if(isset($row->active)){
            	$c2o[$row->dc_category_id]['active'] = $row->active;
            }else{
            	$c2o[$row->dc_category_id]['active'] = "";
            }
            
            $c2o[$row->dc_category_id]['occupancy_list'] = $occupancies;
            $c2o[$row->dc_category_id]['hms_categories_list'] = $hms_categories;
        }
        $sql = $this->sql_dc_category_link;
        
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $c2o[$row->dc_category_id]['hms_categories_list'][$row->hms_category_id]['selected'] = "selected";
        }
        
        $sql = $this->sql_dc_category2occupancy_list;
        // echo $sql;
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $c2o[$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['checked'] = "checked";
        }
        return $c2o;
    }
    
    function build_category2occupancy ($occupancy_bool = 0)
    {
    	$sql = $this->sql_dc_category_list;
    
    	$c2o = array();
    
    	$occupancies = $this->get_occupancies ( $occupancy_bool );
    	//echo "<pre>";
    	//print_r($occupancies);
    	//die();
    	$hms_categories = $this->build_hms_categories();
    
    	$query = $this->db->query($sql);
    	foreach ($query->result() as $row) {
    		$c2o[$row->dc_category_id]['dc_category_id'] = $row->dc_category_id;
    		$c2o[$row->dc_category_id]['dc_category_name'] = $row->dc_category_name;
    		if(isset($row->dc_hotel_id)){
    			$c2o[$row->dc_category_id]['dc_hotel_id'] = $row->dc_hotel_id;
    		}else{
    			$c2o[$row->dc_category_id]['dc_hotel_id'] = "";
    		}
    		if (isset($row->dc_property_name)) {
    			$c2o[$row->dc_category_id]['dc_property_name'] = $row->dc_property_name;
    		} else {
    			$c2o[$row->dc_category_id]['dc_property_name'] = "";
    		}
    		if(isset($row->active)){
    			$c2o[$row->dc_category_id]['active'] = $row->active;
    		}else{
    			$c2o[$row->dc_category_id]['active'] = "";
    		}
    		if(isset($occupancies[$row->dc_category_id]) && $occupancy_bool == 1){
    			$c2o[$row->dc_category_id]['occupancy_list'] = $occupancies[$row->dc_category_id];
    		}else{
    		    if(!isset($occupancies[$row->dc_category_id]) && $occupancy_bool == 1){
    		        $c2o[$row->dc_category_id]['occupancy_list'] = array();
    		    }else{
    			    $c2o[$row->dc_category_id]['occupancy_list'] = $occupancies;
    		    }
    		}
    		$c2o[$row->dc_category_id]['hms_categories_list'] = $hms_categories;
    	}
    	//echo "<pre>";
    	//print_r($c2o);
    	//die();
    	$sql = $this->sql_dc_category_link;
    
    	$query = $this->db->query($sql);
    	foreach ($query->result() as $row) {
    		$c2o[$row->dc_category_id]['hms_categories_list'][$row->hms_category_id]['selected'] = "selected";
    	}
    
    	$sql = $this->sql_dc_category2occupancy_list;
    	// echo $sql;
    	$query = $this->db->query($sql);
    	foreach ($query->result() as $row) {
    		$c2o[$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['checked'] = "checked";
    	}
    	return $c2o;
    }
    
    

    function get_category2occupancy()
    {
        $sql = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id, state from " . $this->table_name_dc_category2occupancy;
        $query = $this->db->query($sql);
        $c2o = array();
        foreach ($query->result() as $row) {
            $c2o[$row->dc_category_id][$row->hms_occupancy_id] = $row->state;
        }
        return $c2o;
    }

    function build_hms_rates()
    {
        $sql = "select id as hms_rate_id, caption as hms_rate_name from rate WHERE isactive = 1 ORDER BY caption";
        $query = $this->db->query($sql);
        $rates = array();
        $rates[0]['hms_rate_id'] = 0;
        $rates[0]['hms_rate_name'] = "---";
        foreach ($query->result() as $hms_rate) {
            $rates[$hms_rate->hms_rate_id] = array();
            $rates[$hms_rate->hms_rate_id]['hms_rate_id'] = $hms_rate->hms_rate_id;
            $rates[$hms_rate->hms_rate_id]['hms_rate_name'] = $hms_rate->hms_rate_name;
        }
        return $rates;
    }

    function build_hms_restrictions()
    {
        $sql = "select rate_id as hms_restrict_id, name as hms_restrict_name from dc_global_restrict_rate";
        $query = $this->db->query($sql);
        $restrictions = array();
        $restrictions[0]['hms_restrict_id'] = 0;
        $restrictions[0]['hms_restrict_name'] = "---";
        $restrictions[0]['selected'] = "";
        foreach ($query->result() as $hms_restriction) {
            $restrictions[$hms_restriction->hms_restrict_id] = array();
            $restrictions[$hms_restriction->hms_restrict_id]['hms_restrict_id'] = $hms_restriction->hms_restrict_id;
            $restrictions[$hms_restriction->hms_restrict_id]['hms_restrict_name'] = $hms_restriction->hms_restrict_name;
            $restrictions[$hms_restriction->hms_restrict_id]['selected'] = "";
        }
        return $restrictions;
    }

    function build_price_func($func_value = 0)
    {
        $price_func = array();
        
        $price_func[- 1]['pf_id'] = "-1";
        $price_func[- 1]['pf_name'] = "{caption_single_use}";
        $price_func[- 1]['pf_selected'] = "";
        
        $price_func[0]['pf_id'] = "0";
        $price_func[0]['pf_name'] = "{caption_base}";
        $price_func[0]['pf_selected'] = "selected";
        
        $price_func[1]['pf_id'] = "1";
        $price_func[1]['pf_name'] = "{caption_base}+1";
        $price_func[1]['pf_selected'] = "";
        
        $price_func[2]['pf_id'] = "2";
        $price_func[2]['pf_name'] = "{caption_base}+2";
        $price_func[2]['pf_selected'] = "";
        if($func_value > 2){
        	for($i = 3; $i <= $func_value; $i++){
        		$price_func[$i]['pf_id'] = $i;
        		$price_func[$i]['pf_name'] = "{caption_base}+".$i;
        		$price_func[$i]['pf_selected'] = "";
        	}
        }
        return $price_func;
    }

    
    function build_rate2category_OLD()
    {
    	$sql = $this->sql_dc_rates;
    	//echo $sql."<br>";
    	$query = $this->db->query($sql);
    	$rate2category = array();
    	$hms_rates_list = $this->build_hms_rates();
    	$hms_restrictions_list = $this->build_hms_restrictions();
    	$hms_occupancies_list = $this->get_occupancies();
    
    	$c2o = $this->get_category2occupancy();
    
    	foreach ($query->result() as $rate_row) {
    		$sql = $this->sql_dc_category_link;
    		//echo $sql."<br>";
    		$query2 = $this->db->query($sql);
    
    		$rate2category[$rate_row->dc_rate_id] = array();
    		$rate2category[$rate_row->dc_rate_id]['dc_rate_name'] = $rate_row->dc_rate_name;
    		$rate2category[$rate_row->dc_rate_id]['dc_rate_id'] = $rate_row->dc_rate_id;
    		if (isset($rate_row->dc_property_name)) {
    			$rate2category[$rate_row->dc_rate_id]['dc_property_name'] = $rate_row->dc_property_name;
    		} else {
    			$rate2category[$rate_row->dc_rate_id]['dc_property_name'] = "";
    		}
    
    		if(isset($rate_row->active)){
    			$rate2category[$rate_row->dc_rate_id]['active'] = $rate_row->active;
    		}else{
    			$rate2category[$rate_row->dc_rate_id]['active'] = "active";
    		}
    		// ================================================================================
    		if (isset($rate_row->restrict_name)) {
    			$rate2category[$rate_row->dc_rate_id]['restrict_name'] = $rate_row->restrict_name;
    		} else {
    			$rate2category[$rate_row->dc_rate_id]['restrict_name'] = "";
    		}
    		// ================================================================================
    		foreach ($query2->result() as $category_row) {
    			if(isset($category_row->dc_hotel_id)){
    				//echo $category_row->dc_hotel_id."|||".$rate_row->dc_hotel_id."<br>";
    				if($category_row->dc_hotel_id == $rate_row->dc_hotel_id){
    					$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_name'] = $category_row->dc_category_name;
    					$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_id'] = $category_row->dc_category_id;
    					if(isset($category_row->hms_category_name)){
    						$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = $category_row->hms_category_name;
    					}else{
    						$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = "";
    					}
    					$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_id'] = $category_row->hms_category_id;
    					$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_rate_id'] = $rate_row->dc_rate_id;
    					// $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_restrictions_list'] = $hms_restrictions_list;
    					foreach ($hms_occupancies_list as $occupancy_cell) {
    						if (isset($c2o[$category_row->dc_category_id][$occupancy_cell['hms_occupancy_id']])) {
    							$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_id'] = $rate_row->dc_rate_id;
    							$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_name'] = $rate_row->dc_rate_name;
    							$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_name'] = $category_row->dc_category_name;
    							$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_id'] = $category_row->dc_category_id;
    							$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_rates_list'] = $hms_rates_list;
    							$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_price_func_list'] = $this->build_price_func();
    							$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_restrictions_list'] = $hms_restrictions_list;
    							 
    							$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_id'] = $occupancy_cell['hms_occupancy_id'];
    							$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_name'] = $occupancy_cell['hms_occupancy_name'];
    						}
    					}
    					if (! isset($rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'])) {
    						unset($rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]);
    					}
    					$rate2category[$rate_row->dc_rate_id]['hms_restrictions_list'] = $hms_restrictions_list;
    				}
    			}else{
    				$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_name'] = $category_row->dc_category_name;
    				$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_id'] = $category_row->dc_category_id;
    				if(isset($category_row->hms_category_name)){
    					$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = $category_row->hms_category_name;
    				}else{
    					$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = "";
    				}
    				$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_id'] = $category_row->hms_category_id;
    				$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_rate_id'] = $rate_row->dc_rate_id;
    				// $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_restrictions_list'] = $hms_restrictions_list;
    				foreach ($hms_occupancies_list as $occupancy_cell) {
    					if (isset($c2o[$category_row->dc_category_id][$occupancy_cell['hms_occupancy_id']])) {
    						$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_id'] = $rate_row->dc_rate_id;
    						$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_name'] = $rate_row->dc_rate_name;
    						$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_name'] = $category_row->dc_category_name;
    						$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_id'] = $category_row->dc_category_id;
    						$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_rates_list'] = $hms_rates_list;
    						$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_price_func_list'] = $this->build_price_func();
    						$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_restrictions_list'] = $hms_restrictions_list;
    
    						$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_id'] = $occupancy_cell['hms_occupancy_id'];
    						$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_name'] = $occupancy_cell['hms_occupancy_name'];
    					}
    				}
    				if (! isset($rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'])) {
    					unset($rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]);
    				}
    				$rate2category[$rate_row->dc_rate_id]['hms_restrictions_list'] = $hms_restrictions_list;
    			}
    			/*$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_name'] = $category_row->dc_category_name;
    			 $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_id'] = $category_row->dc_category_id;
    			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_rate_id'] = $rate_row->dc_rate_id;
    			// $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_restrictions_list'] = $hms_restrictions_list;
    			foreach ($hms_occupancies_list as $occupancy_cell) {
    			if (isset($c2o[$category_row->dc_category_id][$occupancy_cell['hms_occupancy_id']])) {
    			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_id'] = $rate_row->dc_rate_id;
    			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_name'] = $rate_row->dc_rate_name;
    			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_name'] = $category_row->dc_category_name;
    			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_id'] = $category_row->dc_category_id;
    			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_rates_list'] = $hms_rates_list;
    			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_price_func_list'] = $this->build_price_func();
    			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_restrictions_list'] = $hms_restrictions_list;
    
    			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_id'] = $occupancy_cell['hms_occupancy_id'];
    			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_name'] = $occupancy_cell['hms_occupancy_name'];
    			}
    			}
    			if (! isset($rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'])) {
    			unset($rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]);
    			}
    			$rate2category[$rate_row->dc_rate_id]['hms_restrictions_list'] = $hms_restrictions_list;
    			*/
    		}
    	}
//     	echo "<pre>++++";
//     	print_r($rate2category);
//     	die();
    	
    	$sql = $this->sql_dc_r2c;
    	$query = $this->db->query($sql);
    	// echo $sql;
    	foreach ($query->result() as $row) {
    		if (isset($c2o[$row->dc_category_id][$row->hms_occupancy_id])) {
    			$rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_rates_list'][$row->hms_rate_id]['selected'] = 'selected';
    			$rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
    			$rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][0]['pf_selected'] = '';
    			$rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][$row->hms_price_func_id]['pf_selected'] = 'selected';
    		}
    	}
    
    	if ($this->sql_dc_r2rlink !== "") {
    		$sql = $this->sql_dc_r2rlink;
    		$query = $this->db->query($sql);
    		// echo $sql;
    		foreach ($query->result() as $row) {
    			$rate2category[$row->dc_rate_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
    		}
    	}
    	// echo "<pre>";
    	// print_r($rate2category);
    	return $rate2category;
    }
    function get_r2c_link(){
    	$r2c = array();
    	
    	//echo "===".$this->sql_dc_r2c."<br><br><br><br>";
    	$query = $this->db->query ( $this->sql_dc_r2c );
    	foreach ($query->result() as $row) {
    		$r2c[$row->dc_rate_id][$row->dc_category_id	] = 1;
    	}
    	return $r2c;
    }
    
    function build_category2rate(){
       	$category2rate = array();
    	$hms_rates_list = $this->build_hms_rates();
    	$hms_restrictions_list = $this->build_hms_restrictions();
    	
    	$c2o = $this->get_category2occupancy();
    	
    	$sql = $this->sql_category2rate;
    	
    	/*$sql = "SELECT dc_hostelworld_rate2category_link.*, dc_hostelworld_rates.name as dc_rate_name,
		dc_hostelworld_room_categories_link.displayname as dc_category_name, dc_hostelworld_occupancy.name as occupancy_name,
    	dc_hostelworld_rates.active, categories.name as hms_category_name, categories.id as hms_category_id 
    	FROM  dc_hostelworld_rate2category_link
    	INNER JOIN dc_hostelworld_rates ON dc_hostelworld_rate2category_link.dc_rate_id = dc_hostelworld_rates.dc_rate_id
    	INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.dc_category_id = dc_hostelworld_rate2category_link.dc_category_id
    	INNER JOIN dc_hostelworld_occupancy ON dc_hostelworld_occupancy.id = dc_hostelworld_rate2category_link.hms_occupancy_id
    	INNER JOIN categories ON categories.id = dc_hostelworld_room_categories_link.hms_category_id";
    	*/
    	//echo $sql;
    	//die();
    	
    	$query = $this->db->query($sql);
    	foreach ($query->result() as $row) {
    		$category2rate[$row->dc_category_id]["dc_category_id"] = $row->dc_category_id;
    		$category2rate[$row->dc_category_id]["dc_category_name"] = $row->dc_category_name;
    		$category2rate[$row->dc_category_id]["hms_category_id"] = $row->hms_category_id;
    		$category2rate[$row->dc_category_id]["hms_category_name"] = $row->hms_category_name;
    		
    		
    		$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["dc_rate_id"] = $row->dc_rate_id;
    		$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["dc_rate_name"] = $row->dc_rate_name;
    		if(isset($row->active)){
    			$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]['active'] = $row->active;
    		}else{
    			$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]['active'] = "active";
    		}
    		$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["hms_occupancy_id"] = $row->hms_occupancy_id;
    		$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["hms_occupancy_name"] = $row->hms_occupancy_name;
    		$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["dc_rate_id"] = $row->dc_rate_id;
    		$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["dc_rate_name"] = $row->dc_rate_name;
    		$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["dc_category_name"] = $row->dc_category_name;
    		$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["dc_category_id"] = $row->dc_category_id;
    		
    		$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["hms_rates_list"] = $hms_rates_list;
    		$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["hms_price_func_list"] = $this->build_price_func (0);
    		$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["hms_restrictions_list"] = $hms_restrictions_list;
    	}
    	
    	$sql = $this->sql_dc_r2c;
    	$query = $this->db->query($sql);
    	//echo $sql."<pre>";
    	//print_r($c2o);
    	//die();
    	foreach ($query->result() as $row) {
    		if (isset($c2o[$row->dc_category_id][$row->hms_occupancy_id])) {
    			$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]['hms_rates_list'][$row->hms_rate_id]['selected'] = 'selected';
    			$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
    			$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]['hms_price_func_list'][0]['pf_selected'] = '';
    			$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]['hms_price_func_list'][$row->hms_price_func_id]['pf_selected'] = 'selected';
    		}
    	}
    	
    	if ($this->sql_dc_r2rlink !== "") {
    		$sql = $this->sql_dc_r2rlink;
    		$query = $this->db->query($sql);
    		// echo $sql;
    		foreach ($query->result() as $row) {
    			$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
    		}
    	}
    	
    	return $category2rate;
    }
    
    
    function build_category2rate_expedia(){
        $category2rate = array();
        $hms_rates_list = $this->build_hms_rates();
        $hms_restrictions_list = $this->build_hms_restrictions();
        
        $c2o = $this->get_category2occupancy();
        
        //echo "<pre>";
        //print_r($c2o);
        //die();
        
        
        $sql = $this->sql_category2rate;
        
        //echo $sql;
        
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $category2rate[$row->dc_category_id]["dc_category_id"] = $row->dc_category_id;
            $category2rate[$row->dc_category_id]["dc_hotel_id"] = $row->dc_hotel_id;
            $category2rate[$row->dc_category_id]["dc_category_name"] = $row->dc_category_name;
            $category2rate[$row->dc_category_id]["hms_category_id"] = $row->hms_category_id;
            $category2rate[$row->dc_category_id]["hms_category_name"] = $row->hms_category_name;
            
            
            $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["dc_rate_id"] = $row->dc_rate_id;
            $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["rate_dc_hotel_id"] = $row->rate_dc_hotel_id;
            $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["dc_rate_name"] = $row->dc_rate_name;
            if(isset($row->active)){
                $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]['active'] = $row->active;
            }else{
                $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]['active'] = "active";
            }
            
            if (!(isset($category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]['hms_restrictions_list']))) {
                $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["hms_restrictions_list"] = $hms_restrictions_list;
            }
            
            $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["hms_occupancy_id"] = $row->hms_occupancy_id;
            $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["hms_occupancy_name"] = $row->hms_occupancy_name;
            $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["dc_rate_id"] = $row->dc_rate_id;
            $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["dc_rate_name"] = $row->dc_rate_name;
            $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["dc_category_name"] = $row->dc_category_name;
            $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["dc_category_id"] = $row->dc_category_id;
            
            $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["hms_rates_list"] = $hms_rates_list;
            $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["hms_price_func_list"] = $this->build_price_func ($row->cat_max_places - $row->cat_base_places);
            //$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]["hms_restrictions_list"] = $hms_restrictions_list;
            
        }
        
        $sql = $this->sql_dc_r2c;
        $query = $this->db->query($sql);
        // echo $sql;
        foreach ($query->result() as $row) {
            if (isset($c2o[$row->dc_category_id][$row->hms_occupancy_id]) && isset($category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id])) {
                $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]['hms_rates_list'][$row->hms_rate_id]['selected'] = 'selected';
                //$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
                $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]['hms_price_func_list'][0]['pf_selected'] = '';
                $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]['hms_price_func_list'][$row->hms_price_func_id]['pf_selected'] = 'selected';
            }
        }
        
        if ($this->sql_r2r !== "") {
            $sql = $this->sql_r2r;
            $query = $this->db->query($sql);
            // echo $sql;
            foreach ($query->result() as $row) {
                if (isset($category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["hms_restrictions_list"][$row->hms_restrict_id])) {
                    $category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["hms_restrictions_list"][$row->hms_restrict_id]['selected'] = 'selected';
                }
                //$category2rate[$row->dc_category_id]["rate_list"][$row->dc_rate_id]["occupancy_list"][$row->hms_occupancy_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
            }
        }
        
        return $category2rate;
    }
    
    function build_rate2category ($occupancy_bool = 0, $roomstorate = 0, $price_func = 0)
    {
    	//$occupancy_bool = 0;
        $sql = $this->sql_dc_rates;
        //echo $sql."<br>";
        $query = $this->db->query($sql);
        $rate2category = array();
        $hms_rates_list = $this->build_hms_rates();
        $hms_restrictions_list = $this->build_hms_restrictions();
        $hms_occupancies_list = $this->get_occupancies ($occupancy_bool);
        
        $c2o = $this->get_category2occupancy();
        
        $r2c_link = $this->get_r2c_link();
//         echo "<pre>";
//         print_r($r2c_link);
//         die();
        foreach ($query->result() as $rate_row) {
            $sql = $this->sql_dc_category_link;
            
            //if($roomstorate == 1){
            //	$sql .= $this->sql_roomstorate." ".$rate_row->dc_rate_id;
            	
            //}
            //echo $sql."<br><br><br>";
            $query2 = $this->db->query($sql);
            
            $rate2category[$rate_row->dc_rate_id] = array();
            $rate2category[$rate_row->dc_rate_id]['dc_rate_name'] = $rate_row->dc_rate_name;
            $rate2category[$rate_row->dc_rate_id]['dc_rate_id'] = $rate_row->dc_rate_id;
            if(isset($rate_row->dc_hotel_id)){
            	$rate2category[$rate_row->dc_rate_id]['dc_hotel_id'] = $rate_row->dc_hotel_id;
            }else{
            	$rate2category[$rate_row->dc_rate_id]['dc_hotel_id'] = "";
            }
            if (isset($rate_row->dc_property_name)) {
            	$rate2category[$rate_row->dc_rate_id]['dc_property_name'] = $rate_row->dc_property_name;
            } else {
            	$rate2category[$rate_row->dc_rate_id]['dc_property_name'] = "";
            }
            
            if(isset($rate_row->active)){
            	$rate2category[$rate_row->dc_rate_id]['active'] = $rate_row->active;
            }else{
            	$rate2category[$rate_row->dc_rate_id]['active'] = "active";
            }
            // ================================================================================
            if (isset($rate_row->restrict_name)) {
                $rate2category[$rate_row->dc_rate_id]['restrict_name'] = $rate_row->restrict_name;
            } else {
                $rate2category[$rate_row->dc_rate_id]['restrict_name'] = "";
            }
            // ================================================================================
            foreach ($query2->result() as $category_row) {
            	if($roomstorate == 1){
            		if(isset($r2c_link[$rate_row->dc_rate_id][$category_row->dc_category_id])){
            			
            		}else{
//             			echo "+++"."1";
//             			die();
            			continue;
            		}
            	}
            	if(isset($category_row->dc_hotel_id)){
            		//echo $category_row->dc_hotel_id."|||".$rate_row->dc_hotel_id."<br>";
            		if($category_row->dc_hotel_id == $rate_row->dc_hotel_id){
            		    
            			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_name'] = $category_row->dc_category_name;
            			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_id'] = $category_row->dc_category_id;
            			if(isset($category_row->hms_category_name)){
            				$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = $category_row->hms_category_name;
            			}else{
            				$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = "";
            			}
            			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_id'] = $category_row->hms_category_id;
            			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_rate_id'] = $rate_row->dc_rate_id;
            			// $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_restrictions_list'] = $hms_restrictions_list;
            			if ($occupancy_bool == 1) {
							if (isset ( $hms_occupancies_list [$category_row->dc_category_id] )) {
							    //echo "0000000000000000000000000000000";
								foreach ( $hms_occupancies_list [$category_row->dc_category_id] as $occupancy_cell ) {
									if (isset ( $c2o [$category_row->dc_category_id] [$occupancy_cell ['hms_occupancy_id']] )) {
										$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_id'] = $rate_row->dc_rate_id;
										$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_name'] = $rate_row->dc_rate_name;
										$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_name'] = $category_row->dc_category_name;
										$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_id'] = $category_row->dc_category_id;
										$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_rates_list'] = $hms_rates_list;
										$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_price_func_list'] = $this->build_price_func ($price_func);
										$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_restrictions_list'] = $hms_restrictions_list;
										
										$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_id'] = $occupancy_cell ['hms_occupancy_id'];
										$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_name'] = $occupancy_cell ['hms_occupancy_name'];
									}
								}
							}
						} else {
							foreach ( $hms_occupancies_list as $occupancy_cell ) {
								if (isset ( $c2o [$category_row->dc_category_id] [$occupancy_cell ['hms_occupancy_id']] )) {
								    //echo "111111111111111111111111111111111111111";
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_id'] = $rate_row->dc_rate_id;
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_name'] = $rate_row->dc_rate_name;
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_name'] = $category_row->dc_category_name;
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_id'] = $category_row->dc_category_id;
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_rates_list'] = $hms_rates_list;
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_price_func_list'] = $this->build_price_func ($price_func);
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_restrictions_list'] = $hms_restrictions_list;
									
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_id'] = $occupancy_cell ['hms_occupancy_id'];
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_name'] = $occupancy_cell ['hms_occupancy_name'];
								}
							}
						}
						
						if (! isset ( $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'])) {
						    
            				unset($rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]);
            			}
            			//print_r($rate2category);
            			$rate2category[$rate_row->dc_rate_id]['hms_restrictions_list'] = $hms_restrictions_list;
            		}
            	}else{
            		$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_name'] = $category_row->dc_category_name;
            		$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_id'] = $category_row->dc_category_id;
            		if(isset($category_row->hms_category_name)){
            			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = $category_row->hms_category_name;
            		}else{
            			$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = "";
            		}
            		$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_id'] = $category_row->hms_category_id;
            		$rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_rate_id'] = $rate_row->dc_rate_id;
            		// $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_restrictions_list'] = $hms_restrictions_list;
            		if ($occupancy_bool == 1) {
						if (isset ( $hms_occupancies_list [$category_row->dc_category_id] )) {
							foreach ( $hms_occupancies_list [$category_row->dc_category_id] as $occupancy_cell ) {
								if (isset ( $c2o [$category_row->dc_category_id] [$occupancy_cell ['hms_occupancy_id']] )) {
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_id'] = $rate_row->dc_rate_id;
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_name'] = $rate_row->dc_rate_name;
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_name'] = $category_row->dc_category_name;
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_id'] = $category_row->dc_category_id;
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_rates_list'] = $hms_rates_list;
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_price_func_list'] = $this->build_price_func ($price_func);
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_restrictions_list'] = $hms_restrictions_list;
									
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_id'] = $occupancy_cell ['hms_occupancy_id'];
									$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_name'] = $occupancy_cell ['hms_occupancy_name'];
								}
							}
						}
					} else {
						foreach ( $hms_occupancies_list as $occupancy_cell ) {
							if (isset ( $c2o [$category_row->dc_category_id] [$occupancy_cell ['hms_occupancy_id']] )) {
							    //echo "FIN!!!!!!!!!!!!!!!!!!!!!!!!!";
								$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_id'] = $rate_row->dc_rate_id;
								$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_rate_name'] = $rate_row->dc_rate_name;
								$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_name'] = $category_row->dc_category_name;
								$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['dc_category_id'] = $category_row->dc_category_id;
								$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_rates_list'] = $hms_rates_list;
								$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_price_func_list'] = $this->build_price_func ($price_func);
								$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_restrictions_list'] = $hms_restrictions_list;
								
								$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_id'] = $occupancy_cell ['hms_occupancy_id'];
								$rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_occupancy_name'] = $occupancy_cell ['hms_occupancy_name'];
							}
						}
					}
            		if (! isset($rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'])) {
            		   
            			unset($rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]);
            		}
            		$rate2category[$rate_row->dc_rate_id]['hms_restrictions_list'] = $hms_restrictions_list;
            	}
            }
           // echo "<pre>0000";
            //print_r($rate2category);
            //die();
        }
//         echo "<pre>0000";
//         print_r($rate2category);
//         die();
        
        $sql = $this->sql_dc_r2c;
        $query = $this->db->query($sql);
        // echo $sql;
        foreach ($query->result() as $row) {
            if (isset($c2o[$row->dc_category_id][$row->hms_occupancy_id])) {
                $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_rates_list'][$row->hms_rate_id]['selected'] = 'selected';
                $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
                $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][0]['pf_selected'] = '';
                $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][$row->hms_price_func_id]['pf_selected'] = 'selected';
            }
        }
        
        if ($this->sql_dc_r2rlink !== "") {
            $sql = $this->sql_dc_r2rlink;
            $query = $this->db->query($sql);
            // echo $sql;
            foreach ($query->result() as $row) {
                $rate2category[$row->dc_rate_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';                
            }
        }
        //echo "<pre>";
        //print_r($rate2category);
        return $rate2category;
    }

    function rate2category_save($r2c)
    {
//     	echo "<pre>";
//     	print_r($r2c);
//     	die();
    	if (sizeof($r2c)) {} else {
            return;
        }
       
        $this->db->query("delete from " . $this->table_name_r2c);
        
        foreach ($r2c as $dc_rate_id => $dc_category_list) {
            foreach ($dc_category_list as $dc_category_id => $occupancy) {
                foreach ($occupancy as $key => $cell) {
                    $sql = "insert into " . $this->table_name_r2c . "  (dc_rate_id, dc_category_id, hms_occupancy_id,  hms_rate_id, hms_price_func_id, hms_restrict_id) values
                ($dc_rate_id, $dc_category_id, " . $cell['hms_occupancy_id'] . ", " . $cell['hms_rate_id'] . ", " . $cell['hms_price_func_id'] . ", " . $cell['hms_restrict_id'] . ") on duplicate key update  
                hms_rate_id=" . $cell['hms_rate_id'] . ", hms_price_func_id=" . $cell['hms_price_func_id'] . "
                    , hms_restrict_id=" . $cell['hms_restrict_id'] . "
                    , hms_occupancy_id=" . $cell['hms_occupancy_id'] . "";
                    // echo $sql . "\n";
                    $this->db->query($sql);
                }
            }
        }
    }

    function category2occupancy_save($c2o)
    {
        
        foreach ($c2o as $dc_category_id => $cell) {
            $sql = "insert into " . $this->table_name_dc2hms_category_link . "  (dc_category_id, hms_category_id) values
                ($dc_category_id, " . $cell['hms_category_id'] . ") on duplicate key update
                hms_category_id=" . $cell['hms_category_id'] . " ";
            // echo $sql . "\n";
            $this->db->query($sql);
            if (isset($cell['occupancies'])) {
                $this->db->query("delete from " . $this->table_name_dc_category2occupancy." WHERE dc_category_id = ".$dc_category_id);
                foreach ($cell['occupancies'] as $key => $state) {
                    $sql = "insert into " . $this->table_name_dc_category2occupancy . " (dc_category_id, hms_occupancy_id) 
                    values (" . $dc_category_id . ", " . $key . ") on duplicate key update
                        dc_category_id = " . $dc_category_id . ", hms_occupancy_id = " . $key . "";
                    //echo $sql . "\n";
                    $this->db->query($sql);
                }
            }
        }
    }
}