<?php
class Feed_mdl extends CI_Model {
	const  REFERENCE_TBL = "`global_hotelix`.`dc_yandex_hotels`";
	var $countries_tbl = "global_fms_base.dict_country";
	public function __construct(){
		parent::__construct();
	}

	public function get_hotels() {
	    $hotels_tbl = self::REFERENCE_TBL;
	    $hotels = $this->db->get_where($hotels_tbl, "active = 1")->result();
	    $feed = array();
        foreach ($hotels as $hotel) {
            array_push($feed, array(
                'property' => $hotel->name,
                'partner_reference' => $hotel->partner_id,
                'street' => $hotel->street,
                'city' => $hotel->city,
                'postal_code' => $hotel->postal_code,
                'state' => $hotel->state,
                'address' => $hotel->street . ',' . $hotel->city . ',' . $hotel->state . ',' . $hotel->country,
                'gps' => $hotel->latitude . ', ' . $hotel->longitude,
                'category' => $hotel->prop_type,
                'phone' => $hotel->phone,
                'url' => $hotel->url,
                'email' => $hotel->email
            ));
        }
	    return $feed;
	}

	public function update_hotels_tbl () {
	    $hotels_tbl = self::REFERENCE_TBL;
        $fitted_hotels = $this->db->select('id, db_name, host')
            ->get_where('visitka.config', "id_country_3c = 'RUS' AND hotelstateid IN (0,1,2,4,11)")
            ->result();
	    if (count($fitted_hotels)){
	        $prop_info_tbl = "property_information";
	        $prop_type_tbl = "property_type";
	        $countries_tbl = "global_fms_base.dict_country";
	        //$this->db->truncate($hotels_tbl);???
	        foreach ($fitted_hotels as $hotel) {
	            $config = array();
	            $config ['hostname'] = $this->config->item ( 'visitka_host' );
	            $config ['username'] = $this->config->item ( 'visitka_user' );
	            $config ['password'] = $this->config->item ( 'visitka_pass' );
	            $config ['database'] = $hotel->db_name;
	            $config ['dbdriver'] = "mysqli";
	            $config ['dbprefix'] = "";
	            $config ['pconnect'] = FALSE;
	            $config ['db_debug'] = TRUE;
	            $config ['cache_on'] = FALSE;
	            $config ['cachedir'] = "";
	            $config ['char_set'] = "utf8";
	            $config ['dbcollat'] = "utf8_general_ci";
	            $this->db = $this->load->database ( $config, true );


	            $sql =    "SELECT t1.id, t1.property_name_lat AS name_lat, t1.property_name AS name, t1.street_lat, t1.street, t1.city_lat, t1.city, t1.state_lat, t1.state, t1.post_code AS postal_code,
	                           t2.NAME_LAT AS country, t1.gps_coordinates, t1.reception_phone AS phone, t1.web_address AS url, t1.email, t3.name as prop_type
	                       FROM $prop_info_tbl AS t1
	                       JOIN $countries_tbl AS t2 ON t2.id = t1.country
                           LEFT JOIN $prop_type_tbl AS t3 ON t1.property_type = t3.id
                            WHERE t1.country = 'RUS' AND t1.property_name != 'new'";

	            $properties = $this->db->query($sql)->result();

	            $ins_arr = array(
	                'hms_id' => $hotel->id,
	                'host'   => $hotel->host,
	                'dbname' => $hotel->db_name,
	            );

	            foreach ($properties as $property) {
	                $gps_coordinates = explode(',', $property->gps_coordinates);
	                if (count($gps_coordinates) == 2) {
	                    list ($latitude, $longitude) = $gps_coordinates;
	                }else{
	                    $latitude = $longitude = '';
	                }
	                $ins_arr['prop_id'] = $property->id;
	                $ins_arr['partner_id'] = $hotel->id."_".$property->id;
	                $ins_arr['prop_type'] = !is_null($property->prop_type) ? $property->prop_type : '';
	                $ins_arr['name'] = $property->name;
	                $ins_arr['street'] = $property->street;
	                $ins_arr['city'] = $property->city;
	                $ins_arr['state'] = strpos($property->state, '}') ? '' : $property->state;
	                $ins_arr['postal_code'] = $property->postal_code;
	                $ins_arr['country'] = $property->country;
	                $ins_arr['phone'] = $property->phone;
	                $ins_arr['url'] = $property->url != '' ? $property->url : 'booking-'.$hotel->host;
	                $ins_arr['email'] = $property->email;
	                $ins_arr['latitude'] = (string) $latitude;
	                $ins_arr['longitude'] = (string) $longitude;
	                $ins_arr['active'] = $this->validate_feed_filds($ins_arr);

	                $in_tbl = $this->db->select('hms_id')->get_where($hotels_tbl, array('hms_id' => $hotel->id, 'prop_id' => $property->id))->row();
	                if($in_tbl){
	                    $this->db->update($hotels_tbl, $ins_arr, array('hms_id' => $hotel->id, 'prop_id' => $property->id));
	                }else {
	                    $this->db->insert($hotels_tbl, $ins_arr);
	                }
	            }
	        }
	    }
	}

	public function validate_feed_filds($p) {
	    $filds_to_validate = array('name', 'street', 'city', 'country');
	    $validated = 1;
	    foreach ($filds_to_validate as $fild_to_validate) {
	        if (isset($p[$fild_to_validate])) {
	            if ($p[$fild_to_validate] == '') {
	                $validated = 0;
	                break;
	            }
	        }
	    }
	    return $validated;
	}
}