<?

class Dc_airbnb_rest extends CI_Model
{
    
    function __construct()
    {
        parent::__construct();
        $this->secret = 'au6i28gjyei0gh8ruhauwce8';
        $this->client_id = '358mz0fhnvyqrbh8hh6t0zuno';
        $this->host_id = 388799534;
        $this->load->model('internationalfields');
        $this->load->model('frontdesk');
        $this->load->model('dcm_airbnb');
    }
    
    public function get_listings()
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $next_cursor = null;
        $listings = array();
        
        do {
            $url = ! null == $next_cursor ? 'https://api.airbnb.com/v2/listings?user_id=' . $this->host_id . '&has_availability=false&exclude_cohosted_listings=true&_limit=50&_cursor=' . $next_cursor : 'https://api.airbnb.com/v2/listings?user_id=' . $this->host_id . '&has_availability=false&exclude_cohosted_listings=true&_limit=50';
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            $buffer = curl_exec($ch);
            curl_close($ch);
            $result = json_decode($buffer, true);
            
            foreach ($result['listings'] as $value) {
                $listings[$value['id']] = $value;
            }
            $next_cursor = $result['paging']['next_cursor'];
        } while ($next_cursor != null);
        
        return $listings;
    }
    
    function set_description($property_id)
    {
        $international_name_array = $this->internationalfields->get_value("property_custom", $property_id, "international_name");
        $international_summary_array = $this->internationalfields->get_value("property_custom", $property_id, "international_summary");
        $international_space_array = $this->internationalfields->get_value("property_custom", $property_id, "international_space");
        $international_access_array = $this->internationalfields->get_value("property_custom", $property_id, "international_access");
        $international_interaction_array = $this->internationalfields->get_value("property_custom", $property_id, "international_interaction");
        $international_neighborhood_array = $this->internationalfields->get_value("property_custom", $property_id, "international_neighborhood");
        $international_transit_array = $this->internationalfields->get_value("property_custom", $property_id, "international_transit");
        $international_houseRules_array = $this->internationalfields->get_value("property_custom", $property_id, "international_houseRules");
        $international_notes_array = $this->internationalfields->get_value("property_custom", $property_id, "international_notes");
        $international_comment_array = $this->internationalfields->get_value("property_custom", $property_id, "international_comment");
        
        $languages_array = array();
        $sql = "SELECT * FROM descriptionlanguages WHERE is_active = 1";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $value => $row) {
                
                $languages_array[$value]["locale"] = $row->name;
                $languages_array[$value]["name"] = "";
                $languages_array[$value]["summary"] = "";
                $languages_array[$value]["space"] = "";
                $languages_array[$value]["access"] = "";
                $languages_array[$value]["interaction"] = "";
                $languages_array[$value]["neighborhood_overview"] = "";
                $languages_array[$value]["transit"] = "";
                $languages_array[$value]["house_rules"] = "";
                $languages_array[$value]["notes"] = "";
                
                if (isset($international_name_array[$row->id])) {
                    $languages_array[$value]["name"] = $international_name_array[$row->id];
                    $languages_array[$value]["summary"] = $international_summary_array[$row->id];
                    $languages_array[$value]["space"] = $international_space_array[$row->id];
                    $languages_array[$value]["access"] = $international_access_array[$row->id];
                    $languages_array[$value]["interaction"] = $international_interaction_array[$row->id];
                    $languages_array[$value]["neighborhood_overview"] = $international_neighborhood_array[$row->id];
                    $languages_array[$value]["transit"] = $international_transit_array[$row->id];
                    $languages_array[$value]["house_rules"] = $international_houseRules_array[$row->id];
                    $languages_array[$value]["notes"] = $international_notes_array[$row->id];
                }
            }
        }
        $description = array(
            'listing_descriptions' => $languages_array
        );
        return $description;
    }
    
    public function update_description($listing_id, $data)
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        
        $start_hide_pos = 3;
        $hide_len = 15;
        $headers_for_log = array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($access_token, $start_hide_pos, $hide_len),
            "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth["clientid"], $start_hide_pos, $hide_len),
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $url = "https://api.airbnb.com/v2/listing_descriptions/{$listing_id}";
        $tosend = json_encode($data);
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "PUT",
            CURLOPT_POSTFIELDS => $tosend,
            CURLOPT_HTTPHEADER => $headers
        ));
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($curl);
        
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        
        $err = curl_error($curl);
        
        curl_close($curl);
        if ($err) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => $tosend,
                'response' => $err,
                'http_code' => $http_code,
                'action' => 'update description'
            ));
        }
        if (isset(json_decode($response)->error_code)) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => $tosend,
                'response' => $response,
                'http_code' => $http_code,
                'action' => 'update description'
            ));
        }
        
        return (array(
            'endpoint' => $url,
            'header' => $headers_for_log,
            'status' => 'OK',
            'request' => $tosend,
            'response' => $response,
            'http_code' => $http_code,
            'action' => 'update description'
        ));
    }
    
    function set_listing_basic_data($category_id)
    {
        $category_full_data = $this->frontdesk->get_category_full_data($category_id);
        $room_types = $this->frontdesk->get_room_types();
        $property_types = $this->frontdesk->get_property_types();
        $propertyType = "";
        
        if (isset($room_types[$category_full_data["room_type_id"]])) {
            if ($room_types[$category_full_data["room_type_id"]]["airbnb"] != 'other' && $room_types[$category_full_data["room_type_id"]]["airbnb"] != '') {
                $propertyType = $room_types[$category_full_data["room_type_id"]]["airbnb"];
            } else {
                if (isset($property_types[$category_full_data["property_type"]])) {
                    $propertyType = $property_types[$category_full_data["property_type"]]["airbnb"];
                }
            }
        } else {
            if (isset($property_types[$category_full_data["property_type"]])) {
                $propertyType = $property_types[$category_full_data["property_type"]]["airbnb"];
            }
        }
        
        $listing_types = $this->frontdesk->get_listing_types();
        $listing_type_id = 0;
        $cancelation_policy_id = 0;
        $cleaningfee = 0;
        $securedeposit = 0;
        $extraperson = 0;
        $hours = 0;
        $bookconfirm = 0;
        $monthly_price_factor = 1;
        $weekly_price_factor = 1;
        $display_location = 0;
        $sql = "SELECT monthly_price_factor, weekly_price_factor, listing_type_id, cancelation_policy, cleaningfee, securedeposit, extraperson, hours,
		bookconfirm, display_location
		FROM dc_airbnb_room_param
		WHERE category_id = " . $category_id;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $listing_type_id = $row->listing_type_id;
            $cancelation_policy_id = $row->cancelation_policy;
            $cleaningfee = $row->cleaningfee;
            $securedeposit = $row->securedeposit;
            $extraperson = $row->extraperson;
            $hours = $row->hours;
            $bookconfirm = $row->bookconfirm;
            $display_location = $row->display_location;
            $monthly_price_factor = number_format((float) (100 - $row->monthly_price_factor) / 100, 2, '.', '');
            $weekly_price_factor = number_format((float) (100 - $row->weekly_price_factor) / 100, 2, '.', '');
        }
        $listingType = "private_room";
        if (isset($listing_types[$listing_type_id])) {
            $listingType = $listing_types[$listing_type_id]["airbnb"];
        }
        
        if ($display_location == 1) {
            $data["display_location"] = "true";
        } else {
            $data["display_location"] = "false";
        }
        
        $gps_coordinates = explode(",", $category_full_data['gps_coordinates']);
        
        if (isset($gps_coordinates[0])) {
            $data["location_lat"] = $gps_coordinates[0];
        } else {
            $data["location_lat"] = "";
        }
        
        if (isset($gps_coordinates[1])) {
            $data["location_lng"] = $gps_coordinates[1];
        } else {
            $data["location_lng"] = "";
        }
        
        $upload_deep = $this->getxmlcfgvalue("upload_deep", "int");
        $response = $this->dcm_airbnb->get_availability_v3($category_id, 0, $upload_deep);
        
        $category_amenity_types_db = $this->frontdesk->get_category_amenity_types($category_id);
        $property_amenity_types_db = $this->frontdesk->get_property_amenity_types($category_full_data["property_id"]);
        $all_unique_amenities = array();
        
        foreach ($property_amenity_types_db as $value) {
            $type = $value['amenity'];
            if (! isset($all_unique_amenities[$type])) {
                $all_unique_amenities[$type] = array(
                    'is_present' => true
                );
            }
        }
        foreach ($category_amenity_types_db as $value) {
            $type = $value['amenity'];
            
            if (! isset($all_unique_amenities[$type])) {
                $all_unique_amenities[$type] = array(
                    'is_present' => true
                );
            }
        }
        
        // $sql = "SELECT * from category_room_param WHERE catID = ".$category_id;
        
        $view_sql = $this->db->select('*')
        ->from('category_room_param')
        ->join('global_hotelix_common.room_view_type', 'global_hotelix_common.room_view_type.id =  category_room_param.view', 'LEFT')
        ->where('category_room_param.catID', $category_id)
        ->get()
        ->result();
        $views = array();
        foreach ($view_sql as $value) {
            if (! in_array($value->airbnb, $views)) {
                if($value->airbnb !=''){
                    $views[] = $value->airbnb;}
            }
        }
        
        $cat_name = $this->db->select('shortname')
        ->from('categories')
        ->where('id', $category_id)
        ->get()
        ->row();
        
        $property_type_gr = $this->db->select('type_group')
        ->from('global_hotelix_common.airbnb_category_to_group')
        ->where('type', $propertyType)
        ->get()
        ->row();
        
        $data = array(
            'synchronization_category' => 'sync_all',
            'name' => $this->dcm_airbnb->get_category_name($category_id),
            'property_type_group' => $property_type_gr->type_group, // https://developer.airbnb.com/reference/enumeration-values#property-type-groups
            'property_type_category' => $propertyType, // <basicDetails> <propertyType>
            'room_type_category' => $listingType, // <basicDetails> <listingType>
            'bedrooms' => $category_full_data['bedrooms'], // <basicDetails> <bedrooms>
            'bathrooms' => $category_full_data['bathrooms'], // <basicDetails> <bathrooms>
            'beds' => $this->get_beds2rooms($category_id), // <basicDetails> <beds>
            'amenities' => $all_unique_amenities,
            
            'listing_views' => $views, //
            // а також такі: BAY_VIEW, BEACH_VIEW, CANAL_VIEW, CITY_VIEW, DESERT_VIEW, GARDEN_VIEW,
            // GOLF_VIEW, HARBOR_VIEW, LAKE_VIEW, MARINA_VIEW, OCEAN_VIEW, POOL_VIEW, RESORT_VIEW,
            // RIVER_VIEW, SEA_VIEW, VINEYARD_VIEW
            /* !! */
            /* 'check_in_option' => array( // doorman_entry, lockbox, smartlock, keypad, host_checkin, other_checkin
             'category' => 'host_checkin',
             'instruction' => 'Рецепція'
             ), */
            /* !!	 */	'permit_or_tax_id' => $this->get_partner_inn(), // з юрособи, треба промапувати юрособу
            'street' => $category_full_data["street"], // <location> <streetAddress>
            'city' => $category_full_data["city"], // <location> <city>
            'state' => $category_full_data["state"], // <location> <administrativeDivision>
            'zipcode' => $category_full_data["post_code"], // <location> <postalCode>
            'country_code' => $this->get_country_2chr_v2($category_full_data["country"]), // <location> <countryCode>
            'lat' => $data["location_lat"], // <location> <lat>
            'lng' => $data["location_lng"], // <location> <lng>
            /* !! */
            //'directions' => '', // Інструкція по заселенню для гостя (однією мовою)
            'person_capacity' => intval($category_full_data["add_places"]), // <basicDetails> <personCapacity>
            /* !! */
            //'bathroom_shared' => false, // Ignore for entire_home listings.
            // 'bathroom_shared_with_category' => [], - only if shared - host, family_friends_roommates, other_guests
            /* !! */
            //'common_spaces_shared' => true,
            /* 'common_spaces_shared_with_category' => array(
             'other_guests'
             ), */ // only if shared - host, family_friends_roommates, other_guests
            'total_inventory_count' => $response['totalInventoryCount'], // <availability> <totalInventoryCount>
            'property_external_id' => $this->config->item('hotel_id'), // <propertyExternalId>
            'has_availability' => true, // 'has_availability' => true, //<published>
            'display_exact_location_to_guest' => (bool) $display_location, // <location> <displayExactLocation>
            /* !! */
            //'house_manual' => '', // Notes for guest on enjoying their visit and the property
            /* !! */
            //'wifi_network' => $this->hotelix_config->get_record("wifi_hotspot_name"),
            /* !! */
            // 'wifi_password' => '',
            'listing_nickname' => $cat_name->shortname,
            'requested_approval_status_category' => 'ready for review',
        ); // назва категорії мовою системи
        // 'listing_fields_to_clear' => false, // перетирає всю іншу інфу, що є в екстранеті
        /* */
        
        ;
        if ($data['permit_or_tax_id'] == '') {
            unset($data['permit_or_tax_id']);
        }
        
        return $data;
    }
    
    public function update_listing_basic_data($listing_id, $data)
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        $start_hide_pos = 3;
        $hide_len = 15;
        $headers_for_log = array(
            'Content-Type:application/json',
            "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($access_token, $start_hide_pos, $hide_len),
            "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth["clientid"], $start_hide_pos, $hide_len),
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $url = "https://api.airbnb.com/v2/listings/$listing_id";
        $tosend = json_encode($data);
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "PUT",
            CURLOPT_POSTFIELDS => $tosend,
            CURLOPT_HTTPHEADER => $headers
        ));
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($curl);
        
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        
        $err = curl_error($curl);
        
        curl_close($curl);
        if ($err) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => $tosend,
                'response' => $err,
                'http_code' => $http_code,
                'action' => 'update listing basic data'
            ));
        }
        if (isset(json_decode($response)->error_code)) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => $tosend,
                'response' => $response,
                'http_code' => $http_code,
                'action' => 'update listing basic data'
            ));
        }
        
        return (array(
            'endpoint' => $url,
            'header' => $headers_for_log,
            'status' => 'OK',
            'request' => $tosend,
            'response' => $response,
            'http_code' => $http_code,
            'action' => 'update listing basic data'
        ));
    }
    
    public function get_listing_photos($listing_id)
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        $start_hide_pos = 3;
        $hide_len = 15;
        $headers_for_log = array(
            'Content-Type:application/json',
            "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($access_token, $start_hide_pos, $hide_len),
            "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth["clientid"], $start_hide_pos, $hide_len),
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $url = "https://api.airbnb.com/v2/listing_photos?listing_id={$listing_id}";
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_SSL_VERIFYPEER => false
        ));
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'response' => $err,
                'http_code' => $http_code
            ));
        }
        if (isset(json_decode($response)->error_code)) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'response' => $response,
                'http_code' => $http_code
            ));
        }
        return (array(
            'endpoint' => $url,
            'header' => $headers_for_log,
            'status' => 'OK',
            'response' => $response,
            'http_code' => $http_code
        ));
    }
    
    public function get_system_photo($listing_id, $id = null)
    {
        if ($id != 0) {
            $query = $this->db->query('SELECT id, shortname, name FROM categories WHERE id = ' . $id);
            $record = $query->row();
        }
        
        $foto_array = array();
        
        /*
         * $count_position = 8;
         * for($i = 1; $i <= $count_position; $i++){
         * $foto_array[$i]["foto"] = "";
         * $foto_array[$i]["category_id"] = $id;
         * $foto_array[$i]["id_position"] = $i;
         * $foto_array[$i]["foto_class"] = "fileinput-new";
         * }
         */
        
        $external_category_image = $this->images_core->get_external_category_image_value();
        
        if ($external_category_image) {
            $tbl_category_images_name = "category_images_registry";
        } else {
            $tbl_category_images_name = "categories_images";
        }
        
        if ($id != 0) {
            $query = $this->db->query("SELECT id, id_position FROM " . $tbl_category_images_name . " WHERE category_id = $id");
            
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    $size_original = 2; // 3 це тип оригінальної картинки
                    $size_small = 1; // 1 це тип малої картинки
                    $url_data = array();
                    $url_data['category_id'] = $record->id;
                    $url_data['id_position'] = $row->id_position;
                    $img_url_original = $this->images_core->get_category_img_url($url_data, $size_original);
                    $img_url_small = $this->images_core->get_category_img_url($url_data, $size_small);
                    
                    $foto_array[$row->id_position]["foto_id"] = $row->id;
                    // $foto = '<img src="/reservations/view_categoryfoto_small/'.$id.'/'.$row->id_position.'/foto.jpg" alt=""/>';
                    $foto = '<img src="' . $img_url_small . '" alt=""/>';
                    $foto_array[$row->id_position]["foto"] = $foto;
                    $foto_array[$row->id_position]["img_url"] = $img_url_original;
                    $foto_array[$row->id_position]["id_position"] = $row->id_position;
                    $foto_array[$row->id_position]["category_id"] = $record->id;
                    $foto_array[$row->id_position]["foto_class"] = "fileinput-exists";
                    $foto_array[$row->id_position]["listing"] = $listing_id;
                }
            }
        }
        
        return $foto_array;
    }
    
    public function get_photo1($listing_id, $category_id, $id_position)
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $url = "https://api.airbnb.com/v2/listing_photos";
        $url_data = array();
        $url_data['category_id'] = $category_id;
        $url_data['id_position'] = $id_position;
        $img_url_original = $this->images_core->get_category_img_url($url_data, '3');
        
        $data = array(
            'listing_id' => $listing_id,
            'image' => base64_encode(file_get_contents($img_url_original)),
            'caption' => 'Living space',
            'sort_order' => 1,
            'category' => 'LISTING', // ROOM, LISTING_AMENITY, ROOM_AMENITY, LISTING
            // 'room_id' => $room_id,// Associates a room from the Rooms API to the room or room amenity picture. Note: at the moment only accessiblity amenities support picture uploads.
            //'amenity' => null
        );
        // ceiling_hoist, disabled_parking_spot, flat_smooth_pathway_to_front_door, grab_rails_in_shower, grab_rails_in_toilet, home_step_free_access
        // home_wide_doorway, path_to_entrance_lit_at_night, pool_hoist, rollin_shower, shower_chair, step_free_access, wide_doorway
        
        $tosend = json_encode($data);
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $tosend,
            CURLOPT_HTTPHEADER => $headers
        ));
        
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        $err = curl_error($curl);
        
        if ($err) {
            return (array(
                'status' => 'FAIL',
                'response' => $err,
                'http_code' => $http_code
            ));
        }
        if (isset(json_decode($response)->error_code)) {
            return (array(
                'status' => 'FAIL',
                'response' => $response,
                'http_code' => $http_code
            ));
        }
        return (array(
            'status' => 'OK',
            'response' => $response,
            'http_code' => $http_code
        ));
    }
    
    public function get_photo($listing_id, $foto_url)
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        $start_hide_pos = 3;
        $hide_len = 15;
        $headers_for_log = array(
            'Content-Type:application/json',
            "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($access_token, $start_hide_pos, $hide_len),
            "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth["clientid"], $start_hide_pos, $hide_len),
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $url = "https://api.airbnb.com/v2/listing_photos";
        
        $data = array(
            'listing_id' => $listing_id,
            'image' => base64_encode(file_get_contents($foto_url)),
            'caption' => '',
            'sort_order' => 1,
            'category' => 'LISTING', // ROOM, LISTING_AMENITY, ROOM_AMENITY, LISTING
            // 'room_id' => $room_id,// Associates a room from the Rooms API to the room or room amenity picture. Note: at the moment only accessiblity amenities support picture uploads.
            //'amenity' => null
        );
        // ceiling_hoist, disabled_parking_spot, flat_smooth_pathway_to_front_door, grab_rails_in_shower, grab_rails_in_toilet, home_step_free_access
        // home_wide_doorway, path_to_entrance_lit_at_night, pool_hoist, rollin_shower, shower_chair, step_free_access, wide_doorway
        
        $tosend = json_encode($data);
        $data['image'] = $foto_url;
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $tosend,
            CURLOPT_HTTPHEADER => $headers
        ));
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        $err = curl_error($curl);
        
        if ($err) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => json_encode($data),
                'response' => $err,
                'http_code' => $http_code,
                'action' => 'add foto'
            ));
        }
        if (isset(json_decode($response)->error_code)) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => json_encode($data),
                'response' => $response,
                'http_code' => $http_code,
                'action' => 'add foto'
            ));
        }
        return (array(
            'endpoint' => $url,
            'header' => $headers_for_log,
            'status' => 'OK',
            'request' => json_encode($data),
            'response' => $response,
            'http_code' => $http_code,
            'action' => 'add foto'
        ));
    }
    
    public function delete_photo($photo_id)
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        $start_hide_pos = 3;
        $hide_len = 15;
        $headers_for_log = array(
            'Content-Type:application/json',
            "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($access_token, $start_hide_pos, $hide_len),
            "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth["clientid"], $start_hide_pos, $hide_len),
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $url = "https://api.airbnb.com/v2/listing_photos/{$photo_id}";
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "DELETE",
            CURLOPT_HTTPHEADER => $headers
        ));
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        $err = curl_error($curl);
        
        curl_close($curl);
        if ($err) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => json_encode(array(
                    'photo_id' => $photo_id
                )),
                'response' => $err,
                'http_code' => $http_code,
                'action' => 'delete foto'
            ));
        }
        if (isset(json_decode($response)->error_code)) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => json_encode(array(
                    'photo_id' => $photo_id
                )),
                'response' => $response,
                'http_code' => $http_code,
                'action' => 'delete foto'
            ));
        }
        return (array(
            'endpoint' => $url,
            'header' => $headers_for_log,
            'status' => 'OK',
            'request' => json_encode(array(
                'photo_id' => $photo_id
            )),
            'response' => $response,
            'http_code' => $http_code,
            'action' => 'delete foto'
        ));
    }
    
    public function update_all_photo($listing_id, $category_id)
    {
        $res = array();
        
        $rt = $this->get_listing_photos($listing_id);
        $r = json_decode($rt['response']);
        if(isset($r->listing_photos)) {
            $air_foto = $r->listing_photos;
            foreach ($air_foto as $value) {
                
                $res[] = $this->delete_photo($value->id);
            }
            $system_photo = $this->get_system_photo($listing_id, $category_id);
            foreach ($system_photo as $value1) {
                if (@file_get_contents($value1['img_url']) !== false) {
                    $res[] = $this->get_photo($listing_id, $value1['img_url']);
                }
            }
        }
        return ($res);
    }
    
    public function get_room_configuration($category_id)
    {
        $rooms = $this->dcm_airbnb->get_roomConfigurations($category_id);
        $rooms_config = array();
        foreach ($rooms['roomConfigurations'] as $value) {
            $rooms_config[] = array(
                'roomNumber' => $value['roomConfiguration']['0']['roomNumber'],
                'beds' => $value['roomConfiguration']['0']['rc_beds']
            );
        }
        return ($rooms_config);
    }
    
    public function set_subrooms($listing_id, $rooms_configuration)
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        $start_hide_pos = 3;
        $hide_len = 15;
        $headers_for_log = array(
            'Content-Type:application/json',
            "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($access_token, $start_hide_pos, $hide_len),
            "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth["clientid"], $start_hide_pos, $hide_len),
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        $url = "https://api.airbnb.com/v2/listing_rooms";
        $result = array();
        foreach ($rooms_configuration as $value) {
            
            $data = array(
                'listing_id' => $listing_id,
                'room_number' => $value['roomNumber'],
                'beds' => array()
            );
            /*
             * 'beds' => [
             * [
             * 'type' => 'sofa_bed',
             * 'quantity' => 21
             * ],
             * ],
             * 'room_type' => 'living_room',
             * // backyard, basement, bedroom, common_space, common_spaces, dining_room, entrance_to_home, entry, exterior, front_yard, family_room
             * // full_bathroom, half_bathroom, hot_tub, garage, gym, kitchen, kitchenette, laundry_room, living_room, office, outdoor_common_area
             * // outdoor_space, patio, pool, recreation_area, study, studio
             * ];
             */
            if ($value['roomNumber'] == '0') {
                $data['room_type'] = "living_room";
            } else {
                $data['room_type'] = "bedroom";
            }
            foreach ($value['beds'] as $bed) {
                $data['beds'][] = $bed;
            }
            
            // BEDROOM BELOW
            
            /*
             * $data = [
             * 'listing_id' => $listing_id,
             * 'room_number' => 1,
             * 'beds' => [
             * [
             * 'type' => 'queen_bed',
             * 'quantity' => 1
             * ],
             * ],
             * 'room_type' => 'bedroom',
             * ];
             */
            
            $tosend = json_encode($data);
            
            $curl = curl_init();
            
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => $tosend,
                CURLOPT_HTTPHEADER => $headers
            ));
            
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            
            $response = curl_exec($curl);
            
            $http_code = - 1;
            if (! curl_errno($curl)) {
                $info = curl_getinfo($curl);
                $http_code = $info['http_code'];
            }
            
            $err = curl_error($curl);
            
            curl_close($curl);
            
            if ($err) {
                $result[] = (array(
                    'endpoint' => $url,
                    'header' => $headers_for_log,
                    'status' => 'FAIL',
                    'request' => $tosend,
                    'response' => $err,
                    'http_code' => $http_code,
                    'action' => 'update subroom'
                ));
            }
            elseif (isset(json_decode($response)->error_code)) {
                $result[] = (array(
                    'endpoint' => $url,
                    'header' => $headers_for_log,
                    'status' => 'FAIL',
                    'request' => $tosend,
                    'response' => $response,
                    'http_code' => $http_code,
                    'action' => 'update subroom'
                ));
            }
            else{$result[] = (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'OK',
                'request' => $tosend,
                'response' => $response,
                'http_code' => $http_code,
                'action' => 'update subroom'
            ));}
        }
        
        return ($result);
    }
    
    public function set_booking_settings($listing_id, $category_id)
    {
        $cancelation = $this->db->select('cancelation_policy')
        ->from('dc_airbnb_room_param')
        ->where('category_id', $category_id)
        ->get()
        ->row();
        $dc_airbnb_cancelation_policy = $this->frontdesk->get_dc_airbnb_cancelation_policy();
        $cancelation_policy = "";
        if (! empty($cancelation)) {
            if (isset($dc_airbnb_cancelation_policy[$cancelation->cancelation_policy])) {
                $cancelation_policy = $dc_airbnb_cancelation_policy[$cancelation->cancelation_policy]["cancelation_policy_name"];
                //$this->mlanguages->getdictionary("dc_airbnb_c2", "", $data); якщо потрібен переклад, {-$cancelation_policy-}
            }
        }
        $time = $this->db->select('check_in_time,check_out_time')
        ->from('categories')
        ->join('property_information', 'categories.property_id = property_information.id', 'left')
        ->where('categories.id', $category_id)
        ->get()
        ->row();
        $amenities = $this->db->select('amenity_id')
        ->from('property2ameneties')
        ->join('categories', 'categories.property_id = property2ameneties.property_id', 'left')
        ->where('categories.id', $category_id)
        ->where_in('amenity_id', array(
            '73',
            '74',
            '78'
        ))
        ->get()
        ->result();
        $allows = array(
            'pets' => false,
            'smoking' => false,
            'events' => false
        );
        foreach ($amenities as $amenity) {
            if ($amenity->amenity_id == '73') {
                $allows['pets'] = true;
            }
            if ($amenity->amenity_id == '74') {
                $allows['smoking'] = true;
            }
            if ($amenity->amenity_id == '78') {
                $allows['events'] = true;
            }
        }
        $data = array(
            'cancellation_policy_settings' => array(
                'cancellation_policy_category' => $cancelation_policy,//'strict_14_with_grace_period', // https://developer.airbnb.com/reference/enumeration-values#cancellation-policies
                //'non_refundable_price_factor' => 0.9
            ), // You can not set Non-refundable discounts on Lux listings and listings located in Italy.
            'check_in_time_start' => substr($time->check_in_time, 0, 2),
            //'check_in_time_end' => substr($time->check_in_time, 0, 2) + 3, // максимальне значення - 2 ночі наступного дня
            'check_out_time' => substr($time->check_out_time, 0, 2), // 0-23
            //'instant_booking_allowed_category' => 'off', // experienced, government_id, experienced_guest_with_government_id
            //'instant_book_welcome_message' => 'Повідомлення для гостя при миттєвому бронюванні',
            /* 'listing_expectations_for_guests' => array( // potential_noise, has_pets, limited_parking, shared_spaces, limited_amenities, surveillance, animals
             array(
             'type' => 'requires_stairs',
             'added_details' => 'There are 3 flights of stairs to get to the listing.'
             ),
             array(
             'type' => 'potential_noise',
             'added_details' => 'The building is being renovated.'
             )
             ), */
            'guest_controls' => array( // all options required
                'allows_children_as_host' => true,
                'allows_infants_as_host' => true,
                // 'children_not_allowed_details' => 'string' If you selected false for any of the above,
                // this field is required to provide details about why the place is not suitable for children.
                'allows_smoking_as_host' => $allows['smoking'],
                'allows_pets_as_host' => $allows['pets'],
                'allows_events_as_host' => $allows['events']
            )
        );
        // 'foreigner_eligible_status_as_host' => This field is only applicable to some listings within China.
        // Are you eligible to host foreigner (non-citizen) guests? The default is yes (0). Specify 1 only if you can not.
        
        return $data;
    }
    
    public function update_booking_settings($listing_id, $data)
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        $start_hide_pos = 3;
        $hide_len = 15;
        $headers_for_log = array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($access_token, $start_hide_pos, $hide_len),
            "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth["clientid"], $start_hide_pos, $hide_len),
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $url = "https://api.airbnb.com/v2/booking_settings/{$listing_id}";
        $tosend = json_encode($data);
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "PUT",
            CURLOPT_POSTFIELDS => $tosend,
            CURLOPT_HTTPHEADER => $headers
        ));
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        $err = curl_error($curl);
        
        curl_close($curl);
        if ($err) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => $tosend,
                'response' => $err,
                'http_code' => $http_code,
                'action' => 'update booking settings'
            ));
        }
        if (isset(json_decode($response)->error_code)) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'request' => $tosend,
                'response' => $response,
                'http_code' => $http_code,
                'action' => 'update booking settings'
            ));
        }
        
        return (array(
            'endpoint' => $url,
            'header' => $headers_for_log,
            'status' => 'OK',
            'request' => $tosend,
            'response' => $response,
            'http_code' => $http_code,
            'action' => 'update booking settings'
        ));
    }
    
    public function update_currency($listing_id)
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        $start_hide_pos = 3;
        $hide_len = 15;
        
        $rate_id = $this->dcm_airbnb->getxmlcfgvalue("rate_id", "int");
        $currency_code_from = $this->db->select('currency')->get_where('rate', array('id' => $rate_id))->row()->currency;
        
        $rate_currency = $this->db->select('name')->get_where('global_hotelix.currency', array('code' => $currency_code_from))->row()->name;
        
        
        //$global_currency = isset($cur->name) ? $cur->name : "USD";
        $pricing_model = @$this->db->select('pricing_model')->get_where('dc_airbnb_listings_details', array('listing_id' => $listing_id))->row()->pricing_model;
        $sync_type = @$this->db->select('sync_type')->get_where('dc_airbnb_listingtocategory', array('listing_id' => $listing_id))->row()->sync_type;
        
        $method = "POST";
        $header_version = 'X-AIRBNB-REQ-API-VERSION: 2022.03.31';
        $url = "https://api.airbnb.com/v2/pricing_settings/$listing_id";
        if($pricing_model == 'STANDARD' ){
            $url = "https://api.airbnb.com/v2/pricing_and_availability/standard/pricing_settings/$listing_id";
            $method = "PUT";
            $header_version = 'X-AIRBNB-REQ-API-VERSION: 2022.12.31';
        }
        
        $headers_for_log = array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($access_token, $start_hide_pos, $hide_len),
            "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth["clientid"], $start_hide_pos, $hide_len),
            $header_version
        );
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            $header_version
        );
        
        $data = array(
            'listing_currency' => $rate_currency
        );
        
        $tosend = json_encode($data);
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => $tosend,
            CURLOPT_HTTPHEADER => $headers
        ));
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        $err = curl_error($curl);
        
        curl_close($curl);
        if ($err) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => $tosend,
                'response' => $err,
                'http_code' => $http_code,
                'action' => 'update currency'
            ));
        }
        if (isset(json_decode($response)->error_code)) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => $tosend,
                'response' => $response,
                'http_code' => $http_code,
                'action' => 'update currency'
            ));
        }
        
        return (array(
            'endpoint' => $url,
            'header' => $headers_for_log,
            'status' => 'OK',
            'request' => $tosend,
            'response' => $response,
            'http_code' => $http_code,
            'action' => 'update currency'
        ));
    }
    
    public function set_availability_rules($listing_id, $category_id)
    {
        /*
         * $sql = "SELECT dc_airbnb_room_param.hours, dc_airbnb_room_param.bookconfirm
         * FROM categories
         * LEFT JOIN dc_airbnb_room_param ON dc_airbnb_room_param.category_id = categories.id
         *
         * WHERE categories.id = $category_id ";
         */
        $room_param = $this->db->select('dc_airbnb_room_param.hours, dc_airbnb_room_param.bookconfirm')
        ->from('categories')
        ->join('dc_airbnb_room_param', 'dc_airbnb_room_param.category_id =  categories.id', 'LEFT')
        ->where('categories.id', $category_id)
        ->get()
        ->row();
        
        $data = array(
            //'default_min_nights' => null, // нема в системі
            //'default_max_nights' => null, // нема в системі
            'booking_lead_time' => array(
                'hours' => isset($room_param->hours) ? (int)$room_param->hours : 0, // https://dev-ul2.otelms.com/dc_airbnb_c2/rooms -> ajax_edit_category -> hours
                'allow_request_to_book' => isset($room_param->bookconfirm) ? (int)$room_param->bookconfirm : 0
            ), // https://dev-ul2.otelms.com/dc_airbnb_c2/rooms -> ajax_edit_category -> bookconfirm
            /* 'max_days_notice' => array(
             //'days' => 365
             ), // нема в системі
             // The maximum number of days between the booking date and the check in date.
             // Valid values are -1, 0, 30, 60, 90, 120, 150, 180, 210, 240, 270, 300, 330, 365.
             // Pass 0 to make ALL future days unavailable. Pass -1 to reset ALL future days to available.
             // Default is all future days are available.
             'turnover_days' => array(
             //'days' => 2
             ), // нема в системі */
            //'allow_rtb_above_max_nights' => true, // нема в системі
            'day_of_week_check_in' => array( // слати в такій редакції
                array(
                    'day_of_week' => 0
                ),
                array(
                    'day_of_week' => 1
                ),
                array(
                    'day_of_week' => 2
                ),
                array(
                    'day_of_week' => 3
                ),
                array(
                    'day_of_week' => 4
                ),
                array(
                    'day_of_week' => 5
                ),
                array(
                    'day_of_week' => 6
                )
            ),
            'day_of_week_check_out' => array( // слати в такій редакції
                array(
                    'day_of_week' => 0
                ),
                array(
                    'day_of_week' => 1
                ),
                array(
                    'day_of_week' => 2
                ),
                array(
                    'day_of_week' => 3
                ),
                array(
                    'day_of_week' => 4
                ),
                array(
                    'day_of_week' => 5
                ),
                array(
                    'day_of_week' => 6
                )
            ),
            'seasonal_min_nights' => array(), // нема в системі
            // [
            // 'start_date' => '2022-06-01',
            // 'end_date' => '2022-06-30',
            // 'min_nights' => 1
            // ],
            'day_of_week_min_nights' => array(), // нема в системі
            /*
             * [
             * 'day_of_week' => 0,
             * 'min_nights' => 5
             * ],
             * [
             * 'day_of_week' => 6,
             * 'min_nights' => 5
             * ]
             */
            'availability_rules_fields_to_clear' => array(
                'default_min_nights',
                'default_max_nights'
            )
        );
        return ($data);
    }
    
    public function update_availability_rules($listing_id, $data)
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        $pricing_model = @$this->db->select('pricing_model')->get_where('dc_airbnb_listings_details', array('listing_id' => $listing_id))->row()->pricing_model;
        $sync_type = @$this->db->select('sync_type')->get_where('dc_airbnb_listingtocategory', array('listing_id' => $listing_id))->row()->sync_type;
        //echo $pricing_model;
        //die();
        $method = "POST";
        $header_version = 'X-AIRBNB-REQ-API-VERSION: 2022.03.31';
        $url = "https://api.airbnb.com/v2/availability_rules/$listing_id";
        //if($pricing_model == 'STANDARD' && $sync_type != 'sync_rates_and_availability'){
        if($pricing_model == 'STANDARD' ){
            $url = "https://api.airbnb.com/v2/pricing_and_availability/standard/availability_rules/$listing_id";
            $method = "PUT";
            $header_version = 'X-AIRBNB-REQ-API-VERSION: 2022.12.31';
        }
        //         echo $url;
        //         die();
        
        $start_hide_pos = 3;
        $hide_len = 15;
        $headers_for_log = array(
            'Content-Type:application/json',
            "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($access_token, $start_hide_pos, $hide_len),
            "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth["clientid"], $start_hide_pos, $hide_len),
            $header_version
        );
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            $header_version
        );
        
        $tosend = json_encode($data);
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => $tosend,
            CURLOPT_HTTPHEADER => $headers
        ));
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        $err = curl_error($curl);
        
        curl_close($curl);
        if ($err) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => $tosend,
                'response' => $err,
                'http_code' => $http_code,
                'action' => 'update availability rules'
            ));
        }
        if (isset(json_decode($response)->error_code)) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => $tosend,
                'response' => $response,
                'http_code' => $http_code,
                'action' => 'update availability rules'
            ));
        }
        
        return (array(
            'endpoint' => $url,
            'header' => $headers_for_log,
            'status' => 'OK',
            'request' => $tosend,
            'response' => $response,
            'http_code' => $http_code,
            'action' => 'update availability rules'
        ));
    }
    public function set_price_settings( $listing_id ,$category_id)
    {
        $room_param = $this->db->select('categories.*,dc_airbnb_room_param.*')
        ->from('categories')
        ->join('dc_airbnb_room_param', 'dc_airbnb_room_param.category_id =  categories.id', 'LEFT')
        ->where('categories.id', $category_id)
        ->get()
        ->row();
        
        
        $data =  array(
            'default_daily_price'		=>	intval($room_param->base_price), // https://dev-ul2.otelms.com/setup_categories_c2/edit/6 - базова ціна
            'weekend_price'			=>	intval($room_param->base_price), // https://dev-ul2.otelms.com/setup_categories_c2/edit/6 - як і базова ціна
            'guests_included'			=>	intval($room_param->places), // https://dev-ul2.otelms.com/setup_categories_c2/edit/6 - places
            'price_per_extra_person'	=>	intval($room_param->extraperson), // https://dev-ul2.otelms.com/dc_airbnb_c2/rooms -> ajax_edit_category -> extraperson
            'monthly_price_factor'		=> 1-intval($room_param->monthly_price_factor)/100, // https://dev-ul2.otelms.com/dc_airbnb_c2/rooms -> ajax_edit_category -> monthly_price_factor
            'weekly_price_factor'		=> 1-intval($room_param->weekly_price_factor)/100, // https://dev-ul2.otelms.com/dc_airbnb_c2/rooms -> ajax_edit_category -> weekly_price_factor
            'standard_fees'			=>  array( // Наразі відправляти тільки збір за прибирання (https://dev-ul2.otelms.com/dc_airbnb_c2/rooms -> ajax_edit_category -> cleaningfee )
                // PASS_THROUGH_RESORT_FEE, PASS_THROUGH_MANAGEMENT_FEE, PASS_THROUGH_COMMUNITY_FEE, PASS_THROUGH_LINEN_FEE, PASS_THROUGH_ELECTRICITY_FEE
                // PASS_THROUGH_WATER_FEE, PASS_THROUGH_HEATING_FEE, PASS_THROUGH_AIR_CONDITIONING_FEE, PASS_THROUGH_UTILITY_FEE, PASS_THROUGH_PET_FEE
                // PASS_THROUGH_CLEANING_FEE, PASS_THROUGH_SHORT_TERM_CLEANING_FEE, PASS_THROUGH_SECURITY_DEPOSIT
                array(
                    'fee_type'				=> 'PASS_THROUGH_CLEANING_FEE',
                    'offline'				=> false,
                    'amount_type'			=> 'flat',
                    'amount'				=> intval($room_param->cleaningfee)*1000000 , // https://dev-ul2.otelms.com/dc_airbnb_c2/rooms -> ajax_edit_category -> cleaningfee
                    //1000000 If amount_type is percent, this is a float between 0 and 100 (inclusive).
                    //If amount_type is flat, this is an integer in micros of the listing currency.
                    //'fee_unit_type',
                    //This field only applies to fees charged each time a measured unit is consumed: electricity, water, heat, air conditioning, or other utilities.
                    //This field defines the unit being measured. For these fee types, the amount_type must be flat.
                    'charge_type'			=> 'PER_GROUP',
                    // This field defines the basis on which the fee will be charged.
                    //The default value is PER_GROUP, but a value of PER_PERSON is available exclusively for PASS_THROUGH_LINEN_FEE type fees.
                ),
            ),
            /* 'pass_through_taxes'			=> [
             [
             // pass_through_hotel_tax, pass_through_lodging_tax, pass_through_room_tax, pass_through_tourist_tax, pass_through_transient_occupancy_tax
             // pass_through_sales_tax, pass_through_vat_gst, pass_through_tourism_assessment_fee
             'tax_type'							=> 'pass_through_tourist_tax',
             'amount'							=> 1,
             'amount_type'						=> 'percent_per_reservation', // flat_per_guest, flat_per_guest_per_night, flat_per_night
             'taxable_base'						=> [
             // pass_through_resort_fee, pass_through_community_fee, pass_through_management_fee, pass_through_linen_fee,
             // pass_through_cleaning_fee, pass_through_pet_fee, pass_through_security_deposit
             'base_price',
             ],
             'business_tax_id'					=> null,
             'no_business_tax_id_declaration'	=> true,
             'tot_registration_id'				=> null,
             'no_tot_registration_id_declaration'=> true,
             'attestation'						=> true, // A confirmation that the tax information is true and the host accepts responsibility to remit the tax given to them as a business.
             'long_term_stay_exemption'			=> null,
             //A length of stay (in number of days). Pass through taxes do not apply to stays longer than this value.
             //The minimum value for this field is 13 days. If set to null or omitted, no exemption applies and taxes are applied to all bookings regardless of length.
             //This field and only_first_nights_exemption cannot be both set.
             //NOTE: for backward compatibility, 0 is automatically converted to null.
             'only_first_nights_exemption'		=> null,
             //Conditional long term exemption where the set number of nights are taxable.
             //Must be greater than 0. If set to null or omitted, no exemption applies and taxes are applied to all bookings regardless of length.
             //This field and long_term_stay_exemption cannot be both set.
             //NOTE: this field is currently not available for Luxe listings.
             'max_cap_per_person_per_night'		=> null,
             //Maximum amount of tax to be applied to a booking per person and per night. Applicable for tax when amount_type is percent_per_reservation.
             //NOTE: this field is currently not available for Luxe listings.
             ]
             ],*/
            //'eligible_for_pass_through_taxes'	=> true,
            //'pass_through_taxes_collection_type'=> 'OVERRIDE_AIRBNB_COLLECTED_TAX',
            //'NO_AIRBNB_COLLECTED_TAX', INELIGIBLE, OVERRIDE_AIRBNB_COLLECTED_TAX, STACKED_AIRBNB_COLLECTED_TAX
            // https://developer.airbnb.com/docs/occupancy-taxes#section-tax-collection-scenarios
            /*'default_pricing_rules'			=> [
             [
             'rule_type' 					=> 'BOOKED_BEYOND_AT_LEAST_X_DAYS',
             // STAYED_AT_LEAST_X_DAYS: Long-term stay adjustment;
             // BOOKED_WITHIN_AT_MOST_X_DAYS: Last-minute discount;
             // BOOKED_BEYOND_AT_LEAST_X_DAYS: Booking ahead discount.
             // SEASONAL_ADJUSTMENT is not applicable to listings as default pricing rules, it can only be used in seasonal rule sets.
             'price_change'					=> -5,
             'price_change_type'				=> 'PERCENT',
             'threshold_one'					=> 60,
             //Specifies the X value in the X_DAYS rules.
             // Must be a multiple of 28 or 30 for "BOOKED_BEYOND_AT_LEAST_X_DAYS".
             // Must be equal to or less than 28 for "BOOKED_WITHIN_AT_MOST_X_DAYS".
             // Cannot be negative.
             ],
             ],*/
            
        );
        return ($data);
    }
    public function update_price_settings( $listing_id,$data )
    {
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        
        
        $pricing_model = @$this->db->select('pricing_model')->get_where('dc_airbnb_listings_details', array('listing_id' => $listing_id))->row()->pricing_model;
        $sync_type = @$this->db->select('sync_type')->get_where('dc_airbnb_listingtocategory', array('listing_id' => $listing_id))->row()->sync_type;
        
        $method = "POST";
        $header_version = 'X-AIRBNB-REQ-API-VERSION: 2022.03.31';
        $url = "https://api.airbnb.com/v2/pricing_settings/$listing_id";
        
        //if($pricing_model == 'STANDARD' && $sync_type != 'sync_rates_and_availability'){
        if($pricing_model == 'STANDARD'){
            $url = "https://api.airbnb.com/v2/pricing_and_availability/standard/pricing_settings/$listing_id";
            $method = "PUT";
            $header_version = 'X-AIRBNB-REQ-API-VERSION: 2022.12.31';
        }
        
        $start_hide_pos = 3;
        $hide_len = 15;
        $headers_for_log = array(
            'Content-Type:application/json',
            "X-Airbnb-Oauth-Token: " . $this->frontdesk_c2->hide_data($access_token, $start_hide_pos, $hide_len),
            "X-Airbnb-API-Key: " . $this->frontdesk_c2->hide_data($auth["clientid"], $start_hide_pos, $hide_len),
            $header_version
        );
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            $header_version
        );
        
        $tosend = json_encode($data);
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => $tosend,
            CURLOPT_HTTPHEADER =>  $headers,
        ));
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($curl);
        $http_code = - 1;
        if (! curl_errno($curl)) {
            $info = curl_getinfo($curl);
            $http_code = $info['http_code'];
        }
        $err = curl_error($curl);
        
        curl_close($curl);
        if ($err) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => $tosend,
                'response' => $err,
                'http_code' => $http_code,
                'action' => 'update price settings'
            ));
        }
        if (isset(json_decode($response)->error_code)) {
            return (array(
                'endpoint' => $url,
                'header' => $headers_for_log,
                'status' => 'FAIL',
                'request' => $tosend,
                'response' => $response,
                'http_code' => $http_code,
                'action' => 'update price settings'
            ));
        }
        
        return (array(
            'endpoint' => $url,
            'header' => $headers_for_log,
            'status' => 'OK',
            'request' => $tosend,
            'response' => $response,
            'http_code' => $http_code,
            'action' => 'update price settings'
        ));
    }
    
    function update_airbnb($listing_id, $category_id, $syncall = 1)
    {
        
        $res = array();
        $property_id = $cat_name = $this->db->select('property_id')
        ->from('categories')
        ->where('id', $category_id)
        ->get()
        ->row()->property_id;
        
        if ($syncall) {
            $description = $this->set_description($property_id);
            $res[] = $this->update_description($listing_id, $description);
            
            $rooms_configuration = $this->get_room_configuration($category_id);
            foreach ($this->set_subrooms($listing_id, $rooms_configuration) as $room) {
                $res[] = $room;
            }
            
            $booking_settings = $this->set_booking_settings($listing_id, $category_id);
            $res[] = $this->update_booking_settings($listing_id, $booking_settings);
            
            foreach ($this->update_all_photo($listing_id, $category_id) as $photo) {
                $res[] = $photo;
            }
        }
        
        //
        $rules = $this->set_availability_rules($listing_id, $category_id);
        $res[] = $this->update_availability_rules($listing_id, $rules);
        
        if ($syncall) {
            $basic_data = $this->set_listing_basic_data($category_id);
            $res[] = $this->update_listing_basic_data($listing_id, $basic_data);
        }
        
        $res[] = $this->update_currency($listing_id);
        
        //
        $price_settings = $this->dc_airbnb_rest->set_price_settings($listing_id,$category_id);
        $res[] = $this->dc_airbnb_rest->update_price_settings($listing_id,$price_settings);
        
        $this->db->update('dc_airbnb_listingtocategory', array('response'=>json_encode($res, true)), array('category_id'=>$category_id));
        
        return ($res);
    }
    
    public function get_listing_description( $listing_id )
    {
        
        $this->dcm_airbnb->validate_token();
        $access_token = $this->getxmlcfgvalue('access_token', 'str');
        $auth = $this->dcm_airbnb->authparam();
        
        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:' . $access_token,
            'X-Airbnb-API-Key:' . $auth["clientid"],
            "X-AIRBNB-REQ-API-VERSION: 2022.03.31"
        );
        
        $url = "https://api.airbnb.com/v2/listing_descriptions?listing_id={$listing_id}";
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER =>  $headers,
        ));
        
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        echo '<pre>';
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            print_r(json_decode($response, 1));
        }
    }
    function get_country_2chr_v2($chr3)
    {
        $chr2 = $chr3;
        $sql = "SELECT 2char as str_2char FROM global_fms.dict_country WHERE id LIKE '" . $chr3 . "'";
        
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $chr2 = strtoupper($row->str_2char);
        }
        
        switch (strtolower($chr3)) {
            case "ukr":
                $chr2 = strtoupper("ua");
                break;
            case "rus":
                $chr2 = strtoupper("ru");
                break;
        }
        return $chr2;
    }
    
    function get_beds2rooms($category_id)
    {
        $beds2rooms = array();
        $count = 0;
        $sql = "SELECT * FROM beds2rooms WHERE catID = " . $category_id;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $beds2rooms[$row->roomID][$row->bedID] = $row->value;
                $count += $row->value;
            }
        }
        return $count;
    }
    
    function getxmlcfgvalue($name, $type)
    {
        if ($type == 'str') {
            $query = $this->db->query("select str_value as value from dc_airbnb_xml_cfg where name = '$name'");
            if ($query->num_rows()) {
                $row = $query->row();
                return $row->value;
            } else {
                return 0;
            }
        }
        
        if ($type == 'int') {
            $query = $this->db->query("select int_value as value from dc_airbnb_xml_cfg where name = '$name'");
            if ($query->num_rows()) {
                $row = $query->row();
                return $row->value;
            } else {
                return 0;
            }
        }
    }
    
    public function get_partner_inn() {
        $inn = '';
        $query_row = $this->db->select('DOC_INN')->get_where('partners', array('isdefault'=>1))->row();
        if ($query_row) {
            $inn = $query_row->DOC_INN;
        }
        return $inn;
    }
}
