<?php
class Contacts_mdl extends CI_model {
	public $contacts_tbl = 'contacts';
	public $props_tbl = 'property_information';
	public $pure_contact = array(
	    'id' => '',
	    'property_id' => '',
	    'ContactProfileType' => '',
	    'GivenName' => '',
	    'SurName' => '',
	    'Language' => '',
	    'Gender' => '',
	    'JobTitle' => '',
	    'Email' => '',
	    'Phone_Extension' => '',
	    'PhoneNumber' => '',
	    'PhoneTechType' => '',
	    'Address_Language' => '',
	    'AddressLine' => '',
	    'CityName' => '',
	    'PostalCode' => '',
	    'CountryName' => '',
	);
	
	public function __construct() {
		parent::__construct();
		$this->load->model('booking_api_mdl');
	}
	
	public function get_list($p = array()) {
	    $contacts = $this->db->get($this->contacts_tbl)->result();
	    return $contacts;
	}
	
	public function delete($p = array('selected_contacts')) {
	    if (isset($p['selected_contacts']) && is_array($p['selected_contacts'])) {
	        foreach ($p['selected_contacts'] as $selected_contact_id) {
	            $this->db->delete($this->contacts_tbl, array('id' => $selected_contact_id));
	        }
	    }
	    return;
	}
	
	public function create ($p = array()) {
	    $this->db->insert($this->contacts_tbl, $p);
	    return ;
	}
	
	public function update ($p = array()) {
	    $this->db->update($this->contacts_tbl, $p, array('id' => $p['id']));
	    return ;
	}
	
	public function get_contact($p = array()) {
	    $contact = $this->db->get_where($this->contacts_tbl, array('id' => $p['id']))->row();
	    return $contact;
	}
}