<?php

//namespace MaxGraphQL;

class MutationBuilder
{
    public static function convert($array)
    {
        $str = '';

        foreach ($array as $index => $value) {
            $str .= $index . ':';

            if (is_array($value)) {
                $str .= self::disArray($value);
            } else {
                if (is_int($value) || is_float($value)) {
                    
                    $str .= $value . ',';
                } elseif (is_bool($value)) {
                    $str .= '' . $value ? 'true' : 'false' . ',';
                } elseif (ctype_upper($value)) {
					$str .= $value . ',';
				} else {
                    $str .= '"' . $value .'",';
                }
            }
           
        }

        return substr_replace($str ,'', -1);
    }

    private static function disArray($array)
    {
        $str = '';

        if (self::arrayAssociative($array)) {
            $str .= '{';
        } else {
            $str .= '[';
        }

        foreach ($array as $index => $value) {
            if (is_string($index)) {
                $str .= $index . ':';
            }

            if (is_array($value)) {
                $str .= self::disArray($value);
            } else {
               
                if (is_int($value) || is_float($value)) {
                    $str .= $value . ',';
                } elseif (is_bool($value)) {
                    
                    $str .=  $value ? 'true' : 'false';
                    $str .= ",";
                } elseif (ctype_upper($value)) {
					$str .= $value . ',';
				} else { 
                    $str .= '"' . $value .'",';
                }
            }
        }
        
        $str = substr_replace($str ,'', -1);

        if (self::arrayAssociative($array)) {
            $str .= '},';
        } else {
            $str .= '],';
        }

        return $str;
    }

    private static function arrayAssociative($array) {
        if (array_keys($array) !== range(0, count($array) - 1)) {
            return true;
        } else {
            return false;
        }
    }
}