<?php
class Advertisers extends CI_Controller {
    private $advertisers_tbl = '`global_hotelix_common`.`vrbo_advertisers`';
    private $hotels_config_tbl = '`visitka`.`config`';
    private $hotel_properties_tbl = '`property_information`';
    public function __construct() {
        parent::__construct ();
        $this->load->model ( 'hotelix_config' );
    }

    public function listing($hotel_id = ''){//feed
        $advertisers = $this->get_advertisers($hotel_id);
        foreach ($advertisers as $hotel) {
            $url = "https://{$hotel->base_url}/vrbo/gate";
            $hotel->listing_index_content = "$url/rooms";
            $hotel->rules_index_content = "$url/rules";
            $hotel->rate_index_content = "$url/rate";
            $hotel->availability_index_content = "$url/availability";
            ;
        }
        if (count($advertisers)) {
            $feed = $this->parser->parse('templates/vrbo/xml_tmpts/feed.html', ['advertisers' => $advertisers], TRUE);
            $feed = '<?xml version="1.0" encoding="UTF-8"?>'.$feed;
            echo $feed;
        }elseif ($hotel_id != '') {
            echo "Hotel $hotel_id not in listing feed.";
        }else {
            echo "Listing feed is empty.";;
        }
    }

    public function update_advertisers_tbl($truncate_flag = '') {//'truncate'
        $truncate_flag = ($truncate_flag === 'truncate') ? true : false;
        $allowed_hotel_states = [0, 1, 4, 11];
        $advertisers = $this->db->select('id AS hms_id, base_url, db_name')
            ->where_in('hotelstateid', $allowed_hotel_states)
            ->where_not_in('id_country_3c', ['BLR', 'ABH', 'RUS',''])
            ->get($this->hotels_config_tbl)
            ->result();

        if ($truncate_flag) {
            $this->db->truncate($this->advertisers_tbl);
        }
        foreach ($advertisers as $key => $hotel) {
            $single_dwelling_id = 1;
            $tbl = "{$hotel->db_name}.$this->hotel_properties_tbl";
            $exist_single_dwelling = $this->db->get_where($tbl, ['dwelling' => $single_dwelling_id])->row();
            if ($exist_single_dwelling) {
                $hotel->active = 1;
                $hotel->name = $hotel->hms_id;
                if ($truncate_flag) {
                    $this->db->insert($this->advertisers_tbl, $hotel);
                }else {
                    $where_arr = ['hms_id' => $hotel->hms_id];
                    $hotel_in_tbl = $this->db->get_where($this->advertisers_tbl, $where_arr)->row();
                    if ($hotel_in_tbl) {
                        $this->db->update($this->advertisers_tbl, $hotel, $where_arr);
                    }else {
                        $this->db->insert($this->advertisers_tbl, $hotel);
                    }
                }
            }else{
                unset($advertisers[$key]);
            }
        }
    }

    private function get_advertisers($hotel_id) {
        $where_arr = ['active' => 1];
        if ($hotel_id != '') {
            $where_arr['hms_id'] = $hotel_id;
        }
        $advertisers = $this->db->get_where($this->advertisers_tbl, $where_arr)->result();
        return $advertisers;
    }
}