<?php

class Registration_c2 extends CI_Controller
{
    
    public function __construct()
    {
        parent::__construct();
        
        $this->load->model('hms_mail');
        $this->load->model('mlanguages');
        $this->load->model('releases');
    }
    
    function send_registration_verify_mail()
    {
        $this->load->library('email');
        $email_cfg_way = 3;
        
        $tpl_data = array();
        $tpl_data["current_year"] = date("Y");
        $mail_msg = $this->parser->parse('templates/registration_c2_verify.html', $tpl_data, true);
        
        $config = array();
        $config = $this->hms_mail->getparam($email_cfg_way);
        $this->email->initialize($config);
        
        $subj = 'HMS Otelms, TEST REGISTRATION VERIFY';
        
        $email_to = "ferents.yurij@gmail.com";
        
        $this->email->to($email_to);
        $this->email->subject($subj);
        $this->email->message($mail_msg);
        
        $this->email->from($config['from'], 'TEST REGISTRATION VERIFY (HMS OtelMS)');
        
        if (! $this->email->send()) {
            
            show_error($this->email->print_debugger());
            echo 'E-mail error!\n';
            
            $email_cfg_way = 1;
            
            $config = $this->hms_mail->getparam($email_cfg_way);
            $this->email->initialize($config);
            $this->email->from($config['from'], 'TEST REGISTRATION VERIFY (HMS OtelMS)');
            // $this->email->send ();
            if (! $this->email->send()) {
                show_error($this->email->print_debugger());
                echo 'E-mail error!\n';
            } else {
                echo 'Your e-mail has been sent!';
            }
        } else {
            echo 'Your e-mail has been sent!\n';
        }
    }
    
    function localization_initialization($hms_id)
    {
        $query = $this->db->query("SELECT db_name, id FROM `visitka`.config WHERE id = " . $hms_id . ";");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $db_name = $row->db_name;
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            
            $this->db = $this->load->database($config, true);
            $this->mlanguages->localization_initialization();
            echo "done!";
        }
    }
    
    function send_registration_confitmation_mail_OLD($userid)
    {
        $this->db->query("SET NAMES 'utf8'");
        
        $this->load->library('email');
        
        $data_mail = array();
        $sql = "SELECT * FROM visitka.users WHERE id = " . $userid;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $data_mail = $query->row_array();
        }
        
        $email = $data_mail["useremail"];
        
        $origin = $data_mail["origin"];
        
        $email_cfg_way = 3;
        if ($origin == "agast") {
            $email_cfg_way = 5;
        } else {}
        
        $domain = explode(".", $data_mail["site_address"]);
        $sufix = $domain[0];
        
        $lang_char_array = array();
        $query = $this->db->query("SELECT 2char as char_2_lang, 3char as char_3_lang FROM global_hotelix.dic_languages");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $lang_char_array[$row->char_2_lang] = $row->char_3_lang;
            }
        }
        
        $locale = $data_mail["locale"];
        
        switch ($locale) {
            case "ua":
                $locale = "uk";
                break;
            case "ge":
                $locale = "ka";
                break;
        }
        
        $char_3_lang = "eng";
        if (isset($lang_char_array[$locale])) {
            $char_3_lang = $lang_char_array[$locale];
        }
        
        $subj = $this->mlanguages->getdictionaryword("confirm_user_email", $char_3_lang, "{clt_domain_accepted}");
        $data_mail["current_year"] = date("Y");
        $this->mlanguages->getdictionary("footer", $char_3_lang, $data_mail);
        $this->mlanguages->getdictionary("confirm_user_email", $char_3_lang, $data_mail);
        
        if ($origin == "agast") {
            $data_mail["site_address"] = $sufix . ".agast.ru";
            $mail_msg = $this->parser->parse('templates/registration_c2_confitmation_agast.html', $data_mail, true);
        } else {
            $mail_msg = $this->parser->parse('templates/registration_c2_confitmation.html', $data_mail, true);
        }
        
        // echo $char_3_lang."<pre>";
        // print_r($data_mail);
        // die();
        
        $config = array();
        $config = $this->hms_mail->getparam($email_cfg_way);
        $this->email->initialize($config);
        
        // $email_to = "ferents.yurij@gmail.com";
        
        $this->email->to($email);
        $this->email->subject($subj);
        $this->email->message($mail_msg);
        
        $this->email->from($config['from']);
        
        if (! $this->email->send()) {
            
            show_error($this->email->print_debugger());
            echo 'E-mail error!\n';
            
            $email_cfg_way = 1;
            
            $config = $this->hms_mail->getparam($email_cfg_way);
            $this->email->initialize($config);
            $this->email->from($config['from']);
            // $this->email->send ();
            if (! $this->email->send()) {
                show_error($this->email->print_debugger());
                echo 'E-mail error!\n';
            } else {
                echo 'Your e-mail has been sent!';
            }
        } else {
            echo 'Your e-mail has been sent!\n';
        }
    }
    
    function send_registration_confitmation_mail($userid)
    {
        $this->db->query("SET NAMES 'utf8'");
    
        $this->load->library('email');
    

        $hms_id = 0;
        $query = $this->db->query("SELECT `visitka`.config.id as hms_id, `visitka`.config.host FROM visitka.users INNER JOIN `visitka`.config ON visitka.users.site_address = `visitka`.config.host WHERE visitka.users.id = $userid");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hms_id = $row->hms_id;
        }
        
        $data_mail = array();
        $sql = "SELECT * FROM visitka.users WHERE id = " . $userid;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $data_mail = $query->row_array();
        }
    
        $email = $data_mail["useremail"];
    
        $origin = $data_mail["origin"];
    
        $email_cfg_way = 3;
        if ($origin == "agast") {
            $email_cfg_way = 5;
        } else {}
    
        $domain = explode(".", $data_mail["site_address"]);
        $sufix = $domain[0];
    
        $lang_char_array = array();
        $query = $this->db->query("SELECT 2char as char_2_lang, 3char as char_3_lang FROM global_hotelix.dic_languages");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $lang_char_array[$row->char_2_lang] = $row->char_3_lang;
            }
        }
    
        $locale = $data_mail["locale"];
    
        switch ($locale) {
            case "ua":
                $locale = "uk";
                break;
            case "ge":
                $locale = "ka";
                break;
        }
    
        $char_3_lang = "eng";
        if (isset($lang_char_array[$locale])) {
            $char_3_lang = $lang_char_array[$locale];
        }
    
        $subj = $this->mlanguages->getdictionaryword("confirm_user_email", $char_3_lang, "{clt_domain_accepted}");
        $data_mail["current_year"] = date("Y");
        $this->mlanguages->getdictionary("footer", $char_3_lang, $data_mail);
        $this->mlanguages->getdictionary("confirm_user_email", $char_3_lang, $data_mail);
    
        if ($origin == "agast") {
            //$data_mail["site_address"] = $sufix . ".agast.ru";
            $data_mail["site_address"] = "https://desktop.agast.ru/?hmsid=$hms_id";
            $mail_msg = $this->parser->parse('templates/registration_c2_confitmation_agast.html', $data_mail, true);
        } else {
            $data_mail["site_address"] = "https://desktop.otelms.com/?hmsid=$hms_id";
            $mail_msg = $this->parser->parse('templates/registration_c2_confitmation.html', $data_mail, true);
        }
    
        // echo $char_3_lang."<pre>";
        // print_r($data_mail);
        // die();
    
        $config = array();
        $config = $this->hms_mail->getparam($email_cfg_way);
        $this->email->initialize($config);
    
        // $email_to = "ferents.yurij@gmail.com";
    
        $this->email->to($email);
        $this->email->subject($subj);
        $this->email->message($mail_msg);
    
        $this->email->from($config['from']);
    
        if (! $this->email->send()) {
    
            show_error($this->email->print_debugger());
            echo 'E-mail error!\n';
    
            $email_cfg_way = 1;
    
            $config = $this->hms_mail->getparam($email_cfg_way);
            $this->email->initialize($config);
            $this->email->from($config['from']);
            // $this->email->send ();
            if (! $this->email->send()) {
                show_error($this->email->print_debugger());
                echo 'E-mail error!\n';
            } else {
                echo 'Your e-mail has been sent!';
            }
        } else {
            echo 'Your e-mail has been sent!\n';
        }
    }
}

