<?php class hms_sysutils extends CI_Controller {
    public function __construct()
    {
        parent::__construct();
        
        $this->load->model ( 'hotelix_config' );
    }
    
    function index() {
        echo ":-)";
    }
    
    
    function test() {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $dbname;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
    }
    
    function create_dns_bsp2() {
        $sql = "select host from visitka.config where bup=1 AND hotelstateid NOT IN (5, 7, 8, 9)";
        $query = $this->db->query($sql);
        $file = "/migration/bsp2/otelms.com.bsp2";
        foreach ($query->result() as $row) {
            $host = $row->host;
            $record = "bsp2-" . $host . ". A 45.76.88.74";
            echo $record . "<br>";
            file_put_contents($file, $record . PHP_EOL, FILE_APPEND);
        }
    }
    
    function create_dns_agast() {
        $sql = "select host from visitka.config where bup=1 AND hotelstateid NOT IN (5, 7, 8, 9)";
        $query = $this->db->query($sql);
        $file = "/migration/bsp2/otelms.com.agast";
        $file_pmv2 = "/migration/bsp2/otelms.com.agast_pmv2";
        $file_pmv3 = "/migration/bsp2/otelms.com.agast_pmv3";
        foreach ($query->result() as $row) {
            $host = $row->host;
            $pieces = explode(".", $host);
            $subdomain = $pieces[0];
            $record = $subdomain . ".agast.ru. A 109.70.24.230";
            $record_pmv2 = "book-" . $subdomain . ".agast.ru. A 109.70.24.230";
            $record_pmv3 = "booking-" . $subdomain . ".agast.ru. A 109.70.24.230";
            echo $record . "<br>";
            file_put_contents($file, $record . PHP_EOL, FILE_APPEND);
            file_put_contents($file_pmv2, $record_pmv2 . PHP_EOL, FILE_APPEND);
            file_put_contents($file_pmv3, $record_pmv3 . PHP_EOL, FILE_APPEND);
        }
    }
    
    function create_dns_old3() {
        $sql = "select host from visitka.config where bup=1 ";
        $query = $this->db->query($sql);
        $file = "/migration/dns/otelms.com.old3";
        foreach ($query->result() as $row) {
            $host = $row->host;
            $record = "old3-" . $host . ". A 85.195.107.101";
            echo $record . "<br>";
            file_put_contents($file, $record . PHP_EOL, FILE_APPEND);
        }
    }
    
    function create_ngynx_hosts(){
        
        $sql = "select host from visitka.config where bup=1 and AND hotelstateid NOT IN (5, 7, 8, 9)";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $host = $row->host;
            $data = array();
            $data['host_pass'] = $row->host;
            $data['host'] = "bsp2-" . $row->host;
            $record = $this->parser->parse ( 'hms_sysutils/hms_sysutils_ngynx_proxy.html', $data , true);
            $file = "/migration/bsp2/hosts/" . $row->host . ".bsp2.hosts";
            file_put_contents($file, $record);
        }
    }
    
    function create_ngynx_hosts_agast(){
        
        $sql = "select host from visitka.config where bup=1 AND hotelstateid NOT IN (5, 7, 8, 9)";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $host = $row->host;
            
            $pieces = explode(".", $host);
            $subdomain = $pieces[0];
            
            $data = array();
            $data['host_pass'] = $row->host;
            $data['host'] = $subdomain . ".agast.ru";
            $record = $this->parser->parse ( 'hms_sysutils/hms_sysutils_ngynx_proxy_agast.html', $data , true);
            
            $data = array();
            $data['host_pass'] = "book-" . $subdomain . ".otelms.com";
            $data['host'] = "book-" . $subdomain . ".agast.ru";
            $record_pmv2 = $this->parser->parse ( 'hms_sysutils/hms_sysutils_ngynx_proxy_agast_pmv2.html', $data , true);
            
            $data = array();
            $data['host_pass'] = "booking-" . $subdomain . ".otelms.com";
            $data['host'] = "booking-" . $subdomain . ".agast.ru";
            $record_pmv3 = $this->parser->parse ( 'hms_sysutils/hms_sysutils_ngynx_proxy_agast_pmv3.html', $data , true);
            
            $file = "/migration/bsp2/hosts_agast/" . $row->host . ".agast.hosts";
            $file_pmv2 = "/migration/bsp2/hosts_agast/" . $row->host . ".agast_pmv2.hosts";
            $file_pmv3 = "/migration/bsp2/hosts_agast/" . $row->host . ".agast_pmv3.hosts";
            file_put_contents($file, $record);
            file_put_contents($file_pmv2, $record_pmv2);
            file_put_contents($file_pmv3, $record_pmv3);
        }
    }
    
    function create_pv2_hosts(){
        
        $sql = "select host from visitka.config where (bup=1 and ((hotelstateid >= 0 and hotelstateid < 5) or hotelstateid = 11 or hotelstateid = 10)) or (id = 116) ";
        $query = $this->db->query($sql);
        $file = "/migration/pv2/otelms.com.pv2";
        $file2 = "/migration/pv2/otelms.com.pv2.vhosts";
        foreach ($query->result() as $row) {
            $host = $row->host;
            $record = "book-" . $host . ". A 45.32.185.120";
            $record2 = "book-" . $host . "";
            echo $record . "<br>";
            file_put_contents($file, $record . PHP_EOL, FILE_APPEND);
            file_put_contents($file2, $record2 . PHP_EOL, FILE_APPEND);
        }
    }
    
    function create_s5_hosts(){
        
        $sql = "select host from visitka.config where (bup=1 and ((hotelstateid >= 0 and hotelstateid < 5) or hotelstateid = 11 or hotelstateid = 10)) or (id = 116) ";
        $sql = "select host, db_name from visitka.config where hotelstateid IN ( 0, 1, 2, 4, 11 )";
        $query = $this->db->query($sql);
        $file = "/migration/hms_s5/otelms.com.hms_s5";
        $file2 = "/migration/hms_s5/otelms.com.hms_s5.vhosts";
        $file_s6 = "/migration/hms_s5/otelms.com.hms_s6";
        $file2_s6 = "/migration/hms_s5/otelms.com.hms_s6.vhosts";
        $file_db_list = "/migration/hms_s5/otelms.com.hms_db_list";
        foreach ($query->result() as $row) {
            $host = $row->host;
            
            file_put_contents($file_db_list, "" . $row->db_name . PHP_EOL, FILE_APPEND);
            
            $record = "s5-" . $host . ". A 212.78.83.240";
            $record2 = "s5-" . $host . "";
            echo $record . "<br>";
            file_put_contents($file, $record . PHP_EOL, FILE_APPEND);
            file_put_contents($file2, $record2 . PHP_EOL, FILE_APPEND);
            $record = "s6-" . $host . ". A 212.78.83.241";
            $record2 = "s6-" . $host . "";
            echo $record . "<br>";
            file_put_contents($file_s6, $record . PHP_EOL, FILE_APPEND);
            file_put_contents($file2_s6, $record2 . PHP_EOL, FILE_APPEND);
        }
    }
    
    
    function create_mobile_hosts(){
        
        $sql = "select host from visitka.config where (bup=1 and ((hotelstateid >= 0 and hotelstateid < 5) or hotelstateid = 11 or hotelstateid = 10)) or (id = 116) ";
        $query = $this->db->query($sql);
        $file = "/migration/hms_s5/otelms.com.hms_mobile";
        $file2 = "/migration/hms_s5/otelms.com.hms_mobile.vhosts";
        foreach ($query->result() as $row) {
            $host = $row->host;
            $record = "mobile-" . $host . ". A 212.78.83.240";
            $record2 = "mobile-" . $host . "";
            echo $record . "<br>";
            file_put_contents($file, $record . PHP_EOL, FILE_APPEND);
            file_put_contents($file2, $record2 . PHP_EOL, FILE_APPEND);
        }
    }
    
    function create_pv3_hosts(){
        
        $sql = "select host from visitka.config where (bup=1 and ((hotelstateid >= 0 and hotelstateid < 5) or hotelstateid = 11 or hotelstateid = 10)) or (id = 116) ";
        $query = $this->db->query($sql);
        $file = "/migration/pv2/otelms.com.pv3";
        $file2 = "/migration/pv2/otelms.com.pv3.vhosts";
        foreach ($query->result() as $row) {
            $host = $row->host;
            $record = "booking-" . $host . ". A 45.32.185.120";
            $record2 = "booking-" . $host . "";
            echo $record . "<br>";
            file_put_contents($file, $record . PHP_EOL, FILE_APPEND);
            file_put_contents($file2, $record2 . PHP_EOL, FILE_APPEND);
        }
    }
    
    function dc_simple_ids(){
        
        $sql = "SELECT id, db_name FROM visitka.config WHERE bup = 1";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $db_name = $row->db_name;
            $hms_id = $row->id;
            
            // =========== BOOKING ================
            $sql_hotel = "SELECT int_value FROM `".$db_name."`.dc_booking_xml_cfg WHERE dc_account_id > 0 AND name LIKE 'hotel_id'";
            $query_hotel = $this->db->query($sql_hotel);
            foreach ($query_hotel->result() as $row_hotel) {
                $dc_id = 1;
                $dc_hotel_id = $row_hotel->int_value;
                $sql_insert_update = "INSERT INTO global_hotelix_analitycs.dc_channels_simple_ids(hms_id, dc_id, dc_account_id)
                VALUES($hms_id, $dc_id, $dc_hotel_id)
                ON DUPLICATE KEY UPDATE dc_account_id = dc_account_id";
                $this->db->query($sql_insert_update);
            }
            
            // =========== OSTROVOK ================
            $sql_hotel = "SELECT int_value FROM `".$db_name."`.dc_ostrovok_xml_cfg WHERE dc_account_id > 0 AND name LIKE 'hotel_id'";
            $query_hotel = $this->db->query($sql_hotel);
            foreach ($query_hotel->result() as $row_hotel) {
                $dc_id = 2;
                $dc_hotel_id = $row_hotel->int_value;
                $sql_insert_update = "INSERT INTO global_hotelix_analitycs.dc_channels_simple_ids(hms_id, dc_id, dc_account_id)
                VALUES($hms_id, $dc_id, $dc_hotel_id)
                ON DUPLICATE KEY UPDATE dc_account_id = dc_account_id";
                $this->db->query($sql_insert_update);
            }
            
            // =========== EXPEDIA ================
            $sql_hotel = "SELECT int_value FROM `".$db_name."`.dc_expedia_xml_cfg WHERE dc_account_id > 0 AND name LIKE 'hotel_id'";
            $query_hotel = $this->db->query($sql_hotel);
            foreach ($query_hotel->result() as $row_hotel) {
                $dc_id = 3;
                $dc_hotel_id = $row_hotel->int_value;
                $sql_insert_update = "INSERT INTO global_hotelix_analitycs.dc_channels_simple_ids(hms_id, dc_id, dc_account_id)
                VALUES($hms_id, $dc_id, $dc_hotel_id)
                ON DUPLICATE KEY UPDATE dc_account_id = dc_account_id";
                $this->db->query($sql_insert_update);
            }
        }
        
    }
    
    function create_pool_114000() {
        
        $start = 114000;
        $count = 2000;
        
        $file1 = "/migration/pool_114000/otelms.com.114000.bind";
        $file = "/migration/pool_114000/otelms.com.114000_pv2.bind";
        $file2 = "/migration/pool_114000/otelms.com.114000_pv2.vhosts";
        $file3 = "/migration/pool_114000/otelms.com.114000_pv3.bind";
        $file4 = "/migration/pool_114000/otelms.com.114000_pv3.vhosts";
        $file5 = "/migration/pool_114000/otelms.com.114000_hms_mobile.bind";
        $file6 = "/migration/pool_114000/otelms.com.114000_hms_mobile.vhosts";
        
        $agast_file = "/migration/pool_114000/otelms.com.114000_agast.bind";
        $agast_file_pmv2 = "/migration/pool_114000/otelms.com.114000_agast_pmv2.bind";
        $agast_file_pmv3 = "/migration/pool_114000/otelms.com.114000_agast_pmv3.bind";
        
        for ($i = $start; $i<=($start+$count); $i++ ) {
            $host = $i . ".otelms.com";
            $record1 = "" . $host . ". A 46.28.55.194";
            $record = "book-" . $host . ". A 45.32.185.120";
            $record2 = "book-" . $host . "";
            $record3 = "booking-" . $host . ". A 45.32.185.120";
            $record4 = "booking-" . $host . "";
            $record5 = "mobile-" . $host . ". A 212.78.83.240";
            $record6 = "mobile-" . $host . "";
            echo $record . "<br>";
            file_put_contents($file1, $record1 . PHP_EOL, FILE_APPEND);
            file_put_contents($file, $record . PHP_EOL, FILE_APPEND);
            file_put_contents($file2, $record2 . PHP_EOL, FILE_APPEND);
            file_put_contents($file3, $record3 . PHP_EOL, FILE_APPEND);
            file_put_contents($file4, $record4 . PHP_EOL, FILE_APPEND);
            file_put_contents($file5, $record5 . PHP_EOL, FILE_APPEND);
            file_put_contents($file6, $record6 . PHP_EOL, FILE_APPEND);
            
            $subdomain = $i;
            $record = $subdomain . ".agast.ru. A 109.70.24.230";
            $record_pmv2 = "book-" . $subdomain . ".agast.ru. A 109.70.24.230";
            $record_pmv3 = "booking-" . $subdomain . ".agast.ru. A 109.70.24.230";
            echo $record . "<br>";
            file_put_contents($agast_file, $record . PHP_EOL, FILE_APPEND);
            file_put_contents($agast_file_pmv2, $record_pmv2 . PHP_EOL, FILE_APPEND);
            file_put_contents($agast_file_pmv3, $record_pmv3 . PHP_EOL, FILE_APPEND);
            
            
            
            
            
            
            $data = array();
            $data['host_pass'] = $i . ".otelms.com";
            $data['host'] = $subdomain . ".agast.ru";
            $record = $this->parser->parse ( 'hms_sysutils/hms_sysutils_ngynx_proxy_agast.html', $data , true);
            
            $data = array();
            $data['host_pass'] = "book-" . $subdomain . ".otelms.com";
            $data['host'] = "book-" . $subdomain . ".agast.ru";
            $record_pmv2 = $this->parser->parse ( 'hms_sysutils/hms_sysutils_ngynx_proxy_agast_pmv2.html', $data , true);
            
            $data = array();
            $data['host_pass'] = "booking-" . $subdomain . ".otelms.com";
            $data['host'] = "booking-" . $subdomain . ".agast.ru";
            $record_pmv3 = $this->parser->parse ( 'hms_sysutils/hms_sysutils_ngynx_proxy_agast_pmv3.html', $data , true);
            
            $file_a = "/migration/pool_114000/nginx/" . $subdomain . ".agast.hosts";
            $file_pmv2 = "/migration/pool_114000/nginx/" . $subdomain . ".agast_pmv2.hosts";
            $file_pmv3 = "/migration/pool_114000/nginx/" . $subdomain . ".agast_pmv3.hosts";
            file_put_contents($file_a, $record);
            file_put_contents($file_pmv2, $record_pmv2);
            file_put_contents($file_pmv3, $record_pmv3);
            
            
        }
        
        
        
    }
    
    function set_locktill_open($db_name, $days_from_now){
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
         
        $this->db = $this->load->database ( $config, true );

        $lock_till_open_db = $this->hotelix_config->get_record("lock_till_open");
        
        
        
        $lock_till_open = date ( "Y-m-d", gmmktime ( 0, 0, 0, date ( "m" ), date ( "d" ) + $days_from_now, date ( "Y" ) ) );   
        
        if(strtotime($lock_till_open_db) < strtotime($lock_till_open)){
            $this->hotelix_config->set_record("lock_till_open", $lock_till_open);
        }
        
        echo $lock_till_open." SET OK";
    }
}

