<?php
class Fmss extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('htmltpl');
        $this->load->model('Authorization');
        $this->Authorization->IsLogined();
        $this->load->model('fmss_mdl');

        $this->records_tbl = Fmss_mdl::$records_local_tbl;
        $this->log_tbl = Fmss_mdl::$logs_local_tbl;
        $this->global_log = Fmss_mdl::$global_logs_tbl;
    }

    public function guest_history_view($res_id = '', $guest_id = '') {
        $data = array(
            'res_id' => $res_id,
            'guest_id' => $guest_id
        );
        $this->load->view('/fms_tools/skala/guest_history_view.php', $data);
    }

    public function show_log($res_id = '', $guest_id = ''){
        $where_arr = array(
            "$this->records_tbl.guest_id" => $guest_id,
            "$this->records_tbl.reservation_id" => $res_id
        );

        $log_data = $this->db->join($this->log_tbl, "$this->log_tbl.id = $this->records_tbl.last_req_res_log_id")->get_where($this->records_tbl, $where_arr)->row();
        $log_data->request = json_decode($log_data->request);
        $log_data->response = json_decode($log_data->response);
        echo "<pre>";
        print_r($log_data);
        die("DIED by A Department at fmss.php show_log() on 2 нояб. 2022 г. 21:17:27");
    }

    public function add_person($res_id = '', $guest_id = '') {
        $sequense_result = $this->add_person_sequense($res_id, $guest_id);
        /* 	    $this->session->set_userdata(array(
         'header_msg_text' => $sequense_result->header_msg_text
         ));
         */	    header("Location: $_SERVER[HTTP_REFERER]");
        exit;
    }

    public function add_person_sequense($res_id = '', $guest_id = '') {

        $result_add_person = $this->fmss_mdl->add_person(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
        $api_response = $result_add_person->api_response;

        $inner_state = -1;
        $state_txt = 'Ошибка';
        $hash = '';

        if (isset($api_response->hash) && $api_response->hash != '') {
            $inner_state = 1;
            $state_txt = 'На постановке';
            $hash = $api_response->hash;
            $hms_id = $this->config->item('hotel_id');
            $this->db->insert($this->global_log, array('hms_id'=>$hms_id, 'hash' => $hash));
        }
        $where_arr = array(
            'guest_id' => $guest_id,
            'reservation_id' => $res_id
        );
        $upd_arr = $where_arr + array(
            'last_req_res_log_id' => $result_add_person->last_req_res_log_id,
            'state' => $inner_state,
            'state_txt' => $state_txt,
        );
        if ($hash != '') {
            $upd_arr['hash'] = $hash;
        }
        $rec_exist = $this->db->get_where($this->records_tbl, $where_arr)->row();
        if ($rec_exist) {
            $this->db->update($this->records_tbl, $upd_arr, $where_arr);
        }else {
            $this->db->insert($this->records_tbl, $upd_arr);
        }

        return (object)array('inner_state'=>$inner_state);
    }

    public function do_add_reg_refreshstatus_sequense($res_id = '', $guest_id = '') {

        $result_add_person = $this->add_person_sequense($res_id, $guest_id);
        if ($result_add_person->inner_state == 1) {
            $result_reg_person = $this->reg_person_sequense($res_id, $guest_id);
            if ($result_reg_person->inner_state != 2) {
                //$result_person_status =
                $this->fmss_mdl->refresh_person_status_by_hash('', $res_id, $guest_id);
            }
        }
        $landing_page = $_SERVER[HTTP_REFERER];
        $after_wizard_landing_page = $this->session->userdata ( 'wizard_fms_landing_page' );
        if($after_wizard_landing_page != ''){
            $this->session->set_userdata ( array('wizard_fms_landing_page' => '') );
            switch ($after_wizard_landing_page) {
                case 'fms_c2_recordslist':
                    $landing_page = '/fms_c2/recordslist';
                break;
                case 'folio':
                    $landing_page = "/reservation_c2/folio/$res_id/1";
                    break;
            }
        }
        header("Location: $landing_page");
        exit;
    }

    public function person_status($res_id = '', $guest_id = '') {
        if ($res_id != '' && $guest_id != '') {
            $result_person_status = $this->fmss_mdl->get_person_status(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
            echo "<pre>";
            print_r($result_person_status);
        }else {
            echo "ReservationID or GuestID is empty";
        }
    }

    public function edit_person($res_id = '', $guest_id = '') {
        if ($res_id != '' && $guest_id != '') {
            $result_edit_person = $this->fmss_mdl->edit_person(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
            $result_person_status = 'Before editing';
            if ($result_edit_person->systemcode == 'success') {
                if (isset($result_edit_person->message) && $result_edit_person->message == 'success') {
                    $result_person_status = $this->fmss_mdl->get_person_status(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
                }
            }
            echo "<pre>";
            print_r($result_edit_person);
            print_r($result_person_status);
        }else {
            echo "ReservationID or GuestID is empty";
        }
    }

    public function reg_person($res_id = '', $guest_id = '') {
        $sequense_result = $this->reg_person_sequense($res_id, $guest_id);
        $this->session->set_userdata(array(
            'header_msg_text' => $sequense_result->header_msg_text
        ));
        header("Location: $_SERVER[HTTP_REFERER]");
        exit;
    }

    public function reg_person_sequense($res_id = '', $guest_id = '') {
        $header_msg_text = '';
        $result_reg_person = $this->fmss_mdl->reg_person(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
        $api_response = $result_reg_person->api_response;

        $inner_state = 1;
        if ($api_response == 'sended') {
            $inner_state = 2;
        }
        if (isset($api_response->errors) && count($api_response->errors)) {
            $inner_state = -2;
        }
        $where_arr = array(
            'guest_id' => $guest_id,
            'reservation_id' => $res_id
        );
        $upd_arr = $where_arr + array(
            'last_req_res_log_id' => $result_reg_person->last_req_res_log_id,
            'state' => $inner_state,
        );
        $rec_exist = $this->db->get_where($this->records_tbl, $where_arr)->row();
        if ($rec_exist) {
            if (isset($inner_state) && $inner_state != $rec_exist->state) {
                $this->db->update($this->records_tbl, $upd_arr, $where_arr);
            }else{
                $header_msg_text = $api_response;
            }
        }else {
            $this->db->insert($this->records_tbl, $upd_arr);
        }
        return (object)array('header_msg_text'=>$header_msg_text, 'inner_state'=>$inner_state);
    }

    public function unreg_person($res_id = '', $guest_id = '') {
        if ($res_id != '' && $guest_id != '') {
            $result_unreg_person = $this->fmss_mdl->unreg_person(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
            echo "<pre>";
            print_r($result_unreg_person);
        }else {
            echo "ReservationID or GuestID is empty";
        }
    }

    public function extension_person($res_id = '', $guest_id = '') {
        if ($res_id != '' && $guest_id != '') {
            $result_extension_person = $this->fmss_mdl->extension_person(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
            echo "<pre>";
            print_r($result_extension_person);
        }else {
            echo "ReservationID or GuestID is empty";
        }
    }

    public function edit_stay_to($res_id = '', $guest_id = '') {
        if ($res_id != '' && $guest_id != '') {
            $result = $this->fmss_mdl->edit_stay_to(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
            echo "<pre>";
            print_r($result);
        }else {
            echo "ReservationID or GuestID is empty";
        }
    }

    public function add_document_scan($res_id = '', $guest_id = '') {
        if ($res_id != '' && $guest_id != '') {
            $result_add_document_scan = $this->fmss_mdl->add_document_scan(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
            echo "<pre>";
            print_r($result_add_document_scan);
        }else {
            echo "ReservationID or GuestID is empty";
        }
    }

    public function GetPersonID($res_id = '', $guest_id = '') {
        if ($res_id != '' && $guest_id != '') {
            $result_GetPersonID = $this->fmss_mdl->GetPersonID(array('guest_id'=>$guest_id, 'res_id'=>$res_id));
            echo "<pre>";
            var_dump($result_GetPersonID);
        }else {
            echo "ReservationID or GuestID is empty";
        }
    }

    public function Show_Skala_Functions() {
        echo '<pre>';
        echo '<h2>Functions:</h2>';
        print_r($this->fmss_mdl->GetSoapFunctions());
        echo '</pre>';
    }

    public function Show_Skala_Types() {
        echo '<pre>';
        echo '<h2>Functions:</h2>';
        print_r($this->fmss_mdl->GetSoapTypes());
        echo '</pre>';
    }

    public function GetUID() {//for conect token test
        echo "<pre>";
        print_r($this->fmss_mdl->GetUID());
        die("DIED by A Department at fmss.php test_GetPersonsStatus() on 9 июн. 2022 г. 17:54:54");
    }

    public function GetPersonsStatus($date = '') {
        $date = $date != '' ? $date : date('Y-m-d');
        $result = $this->fmss_mdl->get_persons_status($date);
        echo "<pre>";
        print_r($result);
        die("DIED by A Department at fmss.php test_GetPersonsStatus() on 9 июн. 2022 г. 17:54:54");
    }

    public function skala_settings()
    {
        $this->load->view ( 'fms_tools/skala/settings_view.php');
    }

    public function skala_settings_post()
    {
        $post = $this->input->post();
        $credens_filds = array('skala_login', 'skala_password', 'skala_systemkey');
        foreach ($post as $post_fild => $post_val) {
            if (in_array($post_fild, $credens_filds)) {
                $this->hotelix_config->set_record($post_fild, $post_val);
            };
        }
        $this->load->view ( 'fms_tools/skala/settings_view.php');
    }

    public function testing_settings_connect()
    {
        $this->fmss_mdl->testing_settings_connect();
    }

    public function get_push() {
        $tbl = 'dc_booking.skala_http_push';
        $res = $this->db->order_by('id', 'DESC')->get($tbl)->result();
        echo "<pre>";
        foreach ($res as $row) {
            $arr = array();
            $get = rawurldecode($row->get);
            $get = parse_str($get, $arr);
            print_r($row->time);
            print_r($arr);
            echo '<br>';
        }
    }

    public function view_logs($res_id = '', $guest_id = '') {
        $logs = $this->fmss_mdl->get_logs(array('guest_id'=>$guest_id, 'reservation_id'=>$res_id));
        foreach ($logs as &$log) {
            $log->response = "<pre>". print_r(json_decode($log->response), true) . "</pre>";
            $log->request = "<pre>". print_r(json_decode($log->request), true) . "</pre>";
        }
        unset($log);
        $data = array();
        $data['logs'] = $logs;
        $this->parser->parse ( 'templates/fms_tools/skala/logs_req_res_view.html', $data );
    }

    public function worklogic_discription() {
        /*  show page with discriptions
         *  work logic skala processing
         *  dreamed by Arnyboy 01.10.2022
         * */
        $data = array();
        $this->parser->parse ( 'templates/fms_tools/skala/guides/fmss_arny_worklogic_description.html', $data);
    }

    public function refresh_person_status($hash = '') {
        $this->fmss_mdl->refresh_person_status_by_hash ($hash);
        header("Location: $_SERVER[HTTP_REFERER]");
        exit;
    }
}

// Для работы системы нотификаций требуется  создать WebServer способный прини-
// мать Get-запрос.
// Параметры для запроса.
// 1:  uid - Уникальный идентификатор гражданина, который возвращается в результате успешного
// добавления гражданина, через систему импорта.
// 2:   id - уникальный идентификатор гостиницы, его можно получиь для каждой гостиницы через Api.
// 3:   status - текущий статус гражданина.
// 4:
// 1:  Возможные статусы:
// 2:     10 - гражданин не отправлен на учет;
// 3:     11 - гражданин отправлен на учёт;
// 4:     12 - гражданин поставлен на учёт;
// 5:     13 - ошибка при постановке на учёт(допущена ошибка в данных);
// 6:     21 - гражданин отправлен на снятие с учёта;
// 7:     22 - гражданин снят с учёта;
// 8:     23 - гражданин вернулся с ошибкой при снятии с учёта;
// 9:
// 10:   messsage - сообщение об изменении статуса(по сути описание).