<?php
function objectToArray($object) {
	if (! is_object ( $object ) && ! is_array ( $object )) {
		return $object;
	}
	if (is_object ( $object )) {
		$object = get_object_vars ( $object );
	}
	return array_map ( 'objectToArray', $object );
}
class dc_wubook_gate extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'dcm_wubook' );
		$this->load->model ( 'Curl_model' );
	}
	
	function fetch_new_reservation() {
		echo "<pre>";
		$wubook_conf = $this->dcm_wubook->GetWubookParameters();
		$rpc = $wubook_conf["wubook_url"];
		$wubook_user = $wubook_conf["wubook_user"];
		$wubook_pass = $wubook_conf["wubook_pass"];
		$wubook_lcode = $wubook_conf["wubook_lcode"];
		
		$params = array('url' => $rpc, 'autoload' => !true);
		$this->load->library('xmlrpc_client', $params, 'wubookclient'); 
		
		$response = $this->wubookclient->call('get_token', array($wubook_user, $wubook_pass), false);
		$token = $response[1];
		$lcode = $wubook_lcode;
		
		$resp = $this->wubookclient->call('fetch_new_bookings', array($token, $lcode, false, 1));
		$data = array (
				'request' => json_encode(array($token, $lcode, 'fetch_new_bookings')),
				'response' => json_encode($resp)
		);
		$this->db->insert ( 'dc_wubook_log', $data );
		
		if ($resp[0] == 0) {
			$response = $this->dcm_wubook->get_bookings_test2($resp[1]);
			print_r($response);
			$this->wubookclient->call('mark_bookings', array($token, $lcode, $response['fetched_bookings']), true);
		}
		
		$response = $this->wubookclient->call('release_token', array($token), true);
		
		//print_r($resp);
		
	}
}
?>