<?php
class Gate_tvg extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		//ini_set('error_reporting', E_ALL);
		$this->db_tables =  new Tables();
		$this->load->model ( 'dc_model' );//для якоїсь ОДНОЇ хні у фронтдеску для ОДНОГО каналу... ну ок, грузим
		$this->load->model ( 'cancel' );// модель санцель грузить 2 фронта і логер
		$this->load->model ( 'taxesfees_model' );
	}

	public function get_responce_ability_hotel_language($requested_lang) {
	    $t = &$this->db_tables;
	    $requested_lang = (!empty($requested_lang)) ? substr ( $requested_lang, 0, 2 ) : "";
	    $lang_code = $this->db->select('code')->get_where($t->supported_langs, ['name'=>$requested_lang, 'is_active'=>1])->row();
	    if (!empty($lang_code)){
	        $lang_code = $lang_code->code;
	    }else {
	        $lang_code = 45; //english by default? ili kak?
	    }
	    return $lang_code;
	}

	public function get_hotel_currency() {
	    $t = &$this->db_tables;
	    $row = $this->db->select('t1.name AS currency_name')
            ->from("$t->currencies AS t1")
            ->join("$t->h_config AS t2", 't1.id = t2.value')
            ->where(['t2.name' => 'global_currency'])
            ->get()
            ->row();
	    if($row){
	        return $row->currency_name;
	    }else{
	        return null;
	    }
	}

	public function get_category_descriptions($inc_d=[]) {
	    $cat_id = $inc_d['category_id'];
	    $lang_code = $inc_d['lang_code'];
	    $t = &$this->db_tables;
	    $res = [
	        "name" => "!! Category $cat_id name NOT synchronized in $lang_code language !!",
	        "description" => "!! Category $cat_id description NOT synchronized in $lang_code language !!"
	    ];
	    $sql = "SELECT  t1.name, t1.value
                FROM $t->inter AS t1
                WHERE t1.table_type = 'category' AND t1.table_id = $cat_id AND t1.language_id = $lang_code";
	    $query_result = $this->db->query($sql)->result();
	    foreach ($query_result as $query_row) {
	        switch ($query_row->name) {
	            case "international_name" :
	                $res["name"] = ($query_row->value != "") ? $query_row->value : "!! Category $cat_id name is empty in $lang_code language !!";
	                break;
	            case "international_comment" :
	                $res["description"] = ($query_row->value != "") ? $query_row->value : "!! Category $cat_id description is empty in $lang_code language !!";
	                break;
	        }
	    }
	    return $res;
	}

	public function get_prop_max_children_age($inc_d=[]) {
	    //array('prop_id'=>$r_d->prop_id)
	    return 13;
	}

	public function get_category_photos($inc_d=[]) {
	return [];
	}

	public function get_category_amenities($inc_d=[]) {
	return [];
	}

	public function get_category_value_adds($inc_d=[]) {
	    return [
	        "FREE_BREAKFAST",
	        "FREE_INTERNET",
	        "FREE_PARKING"
	    ];
	}

	public function get_price_at_booking($inc_d = []) {
// 	    'amount' => $hms_parties_total_amount,
// 	    'ccamount_type' => $set->ccamount_type,
// 	    'ccamount' => $set->ccamount,
	    return $inc_d['amount'] * 0.4;
	}

	public function get_rate_cancellation_policy($inc_d=[]) {
	    return ['type' => 'unknown', 'penalties' => []];
	}

    public function get_payment_methods($inc_d = []) {
        $currency = isset($inc_d['currency']) ? $inc_d['currency'] : 'USD';
        return [
            [
                "code" => "PaymentCard",
                "options" => [
                    [
                        "code" => "MasterCard",
                        "fee" => [
                            "amount" => 0.0,
                            "currency" => $currency
                        ]
                    ],
                    [
                        "code" => "Visa",
                        "fee" => [
                            "amount" => 0.0,
                            "currency" => $currency
                        ]
                    ]
                ]
            ]
        ];
    }

    public function get_line_items($data = []) {
        $summary_amount = 0;
        $taxes_fees_all_parties_arr = array();
        foreach ($data['parties'] as $party) {
            $hms_guests = $this->party_to_hms_guests($party, $data['type_id']);
            $hms_guests_ages = $this->party_to_hms_guests_ages($party);
            // 				$hms_guests_count = $hms_guests['adults']+$hms_guests['baby_places']+$hms_guests['babyplace2'];

            $data_for_party = array_merge($data, $hms_guests);
            $hms_amount_for_single_rarty = $this->frontdesk->get_otelms_amount ( $data_for_party );
            $summary_amount += $hms_amount_for_single_rarty;
            $data_for_tf = array (
                'prop_id' => $data ['prop_id'],
                'guests' => $hms_guests,//$hms_guests_count,
                'guest_ages' => $hms_guests_ages,
                'amount' => $hms_amount_for_single_rarty,
                'duration' => round((strtotime( $data['dateout'])-strtotime( $data['datein']))/ (3600 * 24))
            );
            $taxes_fees_party_arr = $this->get_taxes_fees_arr($data_for_tf);
            foreach ($taxes_fees_party_arr as $name_code => $tax_or_fee) {
                if (isset($taxes_fees_all_parties_arr[$name_code])){
                    $taxes_fees_all_parties_arr[$name_code]['amount'] += $tax_or_fee['amount'];
                }else{
                    $taxes_fees_all_parties_arr[$name_code]['amount'] = $tax_or_fee['amount'];
                    $taxes_fees_all_parties_arr[$name_code]['type'] = $tax_or_fee['type'];
                }
            }
        }
        $summary_amount = (double)round($summary_amount, 2);
        $converted_amount = $summary_amount;
        $need_convertation = false;
        if ($data['hotel_currency'] != $data['requested_currency']){
            $converted_amount = $this->convert_currency_from_amount_to ( $data['hotel_currency'], $summary_amount, $data['requested_currency'] );
            $need_convertation = true;
        }
        $result = array (
            array (
                'price' => array (
                    'requested_currency_price' => array (
                        'amount' => $converted_amount,
                        'currency' => $data ['requested_currency']
                    ),
                    'currency_of_charge_price' => array (
                        'amount' => $summary_amount,
                        'currency' => $data ['hotel_currency']
                    )
                ),
                'type' => 'rate',
                'paid_at_checkout' => true
            )
        );
        if (!empty($taxes_fees_all_parties_arr)){
            foreach ($taxes_fees_all_parties_arr as $name_code => $tax_or_fee){
                array_push ( $result, array (
                    'price' => array (
                        'requested_currency_price' => array (
                            'amount' => ($need_convertation)? $this->convert_currency_from_amount_to ( $data['hotel_currency'], $tax_or_fee['amount'], $data['requested_currency'] ) : (double)$tax_or_fee['amount'],
                            'currency' => $data ['requested_currency']
                        ),
                        'currency_of_charge_price' => array (
                            'amount' => (double)$tax_or_fee['amount'],
                            'currency' => $data ['hotel_currency']
                        )
                    ),
                    'type' => $tax_or_fee['type'],
                    'sub_type'=> $name_code,
                    'paid_at_checkout' => true
                ) );
            }
        }
//         $av_cat['line_items'] = [
//             [
//                 'price' => [
//                     'amount' => $hms_parties_total_amount,
//                     'currency' => $r_d->currency
//                 ],
//                 'type' => 'net_rate',
//                 'paid_at_checkout' => ($set->ccforce) ? 0 : 1,
//                 'description' => 'Base rate value'
//             ]
//         ];
        return $result;
    }

	public function booking_availability() {//curl
	    $r_d = file_get_contents("php://input");//request_data
	    $r_d = json_decode($r_d);
	    $t = &$this->db_tables;
	    $lang_code = $this->get_responce_ability_hotel_language($r_d->lang);
	    $hotel_currency = $this->get_hotel_currency();
	    $need_convertation = $r_d->currency != $hotel_currency ? true : false;
	    $sql = "SELECT  t1.category_id, MIN(t1.count) as rooms_available, COUNT(1) AS duration,
                        categories.property_id, IF(ratetocategory.maxplace, ratetocategory.maxplace, categories.add_places) AS max_room_places,
                        IF(ratetocategory.baseplace, ratetocategory.baseplace, categories.places) AS min_room_places,
                        ratetocategory.rate_id, categories.baby_places as max_children,
                        rate.ccforce as ccforce, online_rate_data.ccamount_type as ccamount_type, online_rate_data.ccamount as ccamount,
                        MAX(IF(deskofrate.intdate != $r_d->int_dateout, deskofrate.closed, 0)) AS isclosed, MAX(deskofrate.minstaythrought) AS maxminstaythrought
	           FROM $t->availability AS t1
	           JOIN categories ON categories.id = t1.category_id AND categories.web_booking = 1
	           JOIN ratetocategory ON ratetocategory.category_id = t1.category_id AND ratetocategory.onlinebook = 1
	           JOIN rate ON rate.id = ratetocategory.rate_id AND rate.isactive = 1
	           JOIN online_rate_data ON online_rate_data.rate_id = rate.id
	           JOIN onlinerates ON onlinerates.rateid = ratetocategory.rate_id
	           LEFT JOIN deskofrate ON deskofrate.rate_id = onlinerates.restrictid AND deskofrate.category_id = categories.id  AND deskofrate.intdate BETWEEN $r_d->int_datein AND $r_d->int_dateout
               WHERE t1.intdate >= $r_d->int_datein AND t1.intdate < $r_d->int_dateout AND t1.count >= $r_d->rooms AND categories.property_id = $r_d->prop_id
	           GROUP BY t1.category_id, rate.id
	           HAVING duration >= ($r_d->int_dateout-$r_d->int_datein) AND max_room_places >= $r_d->persons AND min_room_places <= $r_d->persons
	                   AND (isclosed = 0 OR ISNULL(isclosed)) AND (maxminstaythrought <= ($r_d->int_dateout-$r_d->int_datein) OR ISNULL(maxminstaythrought))";
	    $base_result = $this->db->query($sql)->result();
	    /* if (empty ( $base_result )) {
	        return NULL;
	    } */
	    $room_types_array = $avail_categories = $avail_rates = [];
	    foreach ($base_result as $set) {
	        if (!isset($avail_categories[$set->category_id])){
	            $avail_categories[$set->category_id] = $this->get_category_descriptions(['category_id'=>$set->category_id, 'lang_code'=>$lang_code]);
	            $av_cat = &$avail_categories[$set->category_id];
	            $av_cat['occupancy'] = [
                    'standard_persons' => (int)$set->min_room_places,
	                'max_persons'      => (int)$set->max_room_places,
	                'max_adults'       => (int)$set->max_room_places - $set->max_children,
	                'max_children'     => (int)$set->max_children,
	                'max_children_age' => (int)$this->get_prop_max_children_age(['prop_id'=>$r_d->prop_id]),
                ];
	            $av_cat['rooms_available'] = (int)$set->rooms_available;
	            $av_cat['photos']          = $this->get_category_photos(['category_id'=>$set->category_id]);
	            $av_cat['amenities']       = $this->get_category_amenities(['category_id'=>$set->category_id]);
	            $av_cat['value_adds']      = $this->get_category_value_adds(['category_id'=>$set->category_id]);
	            $av_cat['payment_methods'] = $this->get_payment_methods(['currency'=>$r_d->currency]);
	        }else{
	            $av_cat = &$avail_categories[$set->category_id];
	        }
	        if (!isset($avail_rates[$set->rate_id])){
	            $avail_rates[$set->rate_id] = ['rate_key' => $set->rate_id];
	            $av_rate = &$avail_rates[$set->rate_id];
	            $av_rate['cancellation'] = $this->get_rate_cancellation_policy(['rate_id' => $set->rate_id]);
	        }else{
	            $av_rate = &$avail_rates[$set->rate_id];
	        }
	        $av_cat += $av_rate;

	        $hms_parties_total_amount = $hms_all_parties_amount = 0;
	        $data_for_hms_amount = [
	            'prop_id'      => $r_d->prop_id,
	            'type_id'      => $set->category_id,
	            'price_type'   => $set->rate_id,
	            'datein'       => $r_d->start_date,
	            'dateout'      => $r_d->end_date
	        ];
	        foreach ($r_d->party as $party) {
	            $hms_guests = $this->party_to_hms_guests((object) $party, $set->category_id);
	            $data_for_hms_amount = array_merge($data_for_hms_amount, $hms_guests);
	            $hms_party_amount = $this->frontdesk->get_otelms_amount($data_for_hms_amount);
	            $hms_all_parties_amount += $hms_party_amount;
	        }
	        if ($hms_all_parties_amount == 0){
	            continue;
	        }
	        if ($need_convertation){
	            $hms_all_parties_amount = $this->convert_currency_from_amount_to($hotel_currency, $hms_all_parties_amount, $r_d->currency);
	        }
	        $hms_parties_total_amount = $hms_all_parties_amount;// + $hms_all_parties_tf_amount;

	        $final_price_at_booking = $final_price_at_checkout = 0;
	        if ($set->ccforce){
                $final_price_at_booking = $this->get_price_at_booking([
                    'amount'        => $hms_parties_total_amount,
                    'ccamount_type' => $set->ccamount_type,
                    'ccamount'      => $set->ccamount,
                ]);
	            $final_price_at_checkout = $hms_parties_total_amount - $final_price_at_booking;
	        }else{
	            $final_price_at_checkout = $hms_parties_total_amount;
	        }
            $av_cat['final_price_at_booking'] = [
                'amount' => $final_price_at_booking,
                'currency' => $r_d->currency
            ];
            $av_cat['final_price_at_checkout'] = [
                'amount' => $final_price_at_checkout,
                'currency' => $r_d->currency
            ];
            $av_cat['line_items'] = [
                [
                    'price' => [
                        'amount' => $hms_parties_total_amount,
                        'currency' => $r_d->currency
                    ],
                    'type' => 'net_rate',
                    'paid_at_checkout' => ($set->ccforce) ? false : true,
                    'description' => 'Base rate value'
                ]
            ];
            $av_cat['partner_data'] = [
                'category_id' => $set->category_id,
                'rate_id' => $set->rate_id,
                'receipt' => [
                    'line_items'                => $av_cat['line_items'],
                    'final_price_at_booking'    => $av_cat['final_price_at_booking'],
                    'final_price_at_checkout'   => $av_cat['final_price_at_checkout']
                ]
            ];
            array_push($room_types_array, $av_cat);
	        //$room_types_array[$set->category_id.'_'.$set->rate_id] = $av_cat;
	    }

	    $responce = new stdClass();
	    $responce->api_version = (int)$r_d->api_version;
	    $responce->hotel_id = $r_d->hotel->item_id;
	    $responce->start_date = $r_d->start_date;
	    $responce->end_date = $r_d->end_date;
	    $responce->party = $r_d->party;
	    $responce->user_country = $r_d->user_country;
	    $responce->lang = "en_US";
	    $responce->customer_support = $this->get_hotel_customer_support();
	    if (!empty($room_types_array)) {
	        $responce->room_types_array = $room_types_array;
	        $responce->hotel_details = $this->get_hotel_details($r_d->prop_id, $lang_code);
	    }
 	    echo json_encode($responce);
	}

	public function get_hotel_customer_support() {
	    $customer_support = new stdClass();
        $customer_support->phone_numbers = [
            [
                "contact" => "1-153-072-9237 x6907",
                "description" => "Tempora iure sit accusamus et cupiditate autem reiciendis iusto."
            ]
        ];
        $customer_support->emails = [
            [
                "contact" => "Roxane.McKenzie@gmail.com",
                "description" => "Aspernatur reiciendis quis at qui asperiores."
            ]
        ];
        return $customer_support;
	}

	public function booking_submit() {//curl

// 	    $room_types_array['errors'] = [];
// 	    array_push($room_types_array['errors'], json_encode($data_for_hms_amount));

	    $t = &$this->db_tables;
	    $r_d = file_get_contents("php://input");
	    $r_d = json_decode($r_d);
	    $date_in = $r_d->checkin_date;
	    $date_out = $r_d->checkout_date;
	    $category_id = $r_d->partner_data->category_id;
	    $rate_id = $r_d->partner_data->rate_id;
        $customer = [
            'firstname' => $r_d->customer->first_name,
            'lastname'  => $r_d->customer->last_name,
            'phone'     => $r_d->customer->phone_number,
            'email'     => $r_d->customer->email,
            'country'   => $r_d->customer->country
        ];
	    $customer_id = $this->frontdesk->Guest_insert ( $customer );

	    $insert_reservation_data = [
	        'dc_id'                => 32,
	        'dc_uuid'              => $r_d->reference_id,
	        'dc_source'            => 'Trivago',
	        'dc_currencycode'      => $r_d->final_price_at_booking->currency,
	        'dc_customerremarks'   => '',
	        'dc_totalprice'        => round(($r_d->final_price_at_booking->amount + $r_d->final_price_at_checkout->amount)/$r_d->rooms_count, 0),
	        'is_guest'             => 0,
	        'datein'               => $date_in,
	        'dateout'              => $date_out,
	        'price_type'           => $rate_id
	    ];
	    $card_data = [
	        "CardHolder"   => $r_d->payment->parameters->cardholder_name,
	        "CardNumber"   => $r_d->payment->parameters->card_number,
	        "cc_type"      => $r_d->payment->parameters->type,//????
	        "cc_cvc"       => $r_d->payment->parameters->cvv,
	        "ExpMonth"     => $r_d->payment->parameters->expiration_month,
	        "ExpYear"      => $r_d->payment->parameters->expiration_year,
	        //cc_activation_date	cc_current_balance	vcc_expiration_date  - these no needed
	    ];
	    $complex_hms_reservation_ids_for_tvg = "";
	    $tvg2hms_res_id = "";
	    $parties = [];
	    foreach ($r_d->rooms as $party_set) {
	        array_push($parties, $party_set->party);
	        $insert_reservation_data['room_id'] = $this->frontdesk->getfreeroomlist($date_in, $date_out, $category_id);
	        $insert_reservation_data = array_merge($insert_reservation_data, $this->party_to_hms_guests($party_set->party, $category_id));
	        $hms_reservation_id = $this->frontdesk->Reservation_insert ( $insert_reservation_data, $customer_id, 0, 1 );
	        $complex_hms_reservation_ids_for_tvg .= $hms_reservation_id."_";
	        try {
	            $this->frontdesk->insert_tbl_CreditCards ( $card_data, $customer_id, $hms_reservation_id );
	        } catch (Error $e) {
                echo json_encode([
                    "status" => "Failure",
                    "reference_id" => "$r_d->partner_reference",
                    "problems" => [
                        [
                            "problem" => "CreditCardDeclined",
                            "explanation" => json_encode($e),//->getMessage()
                        ]
                    ]
                ]);
	        }


// 	        try {
// 	            $this->Turn_On_myCustomErrorHandler();
// 	            $card_data = [
// 	                "CardHolder"   => 'wefew',
// 	                "CardNumber"   => '21345234656',
// 	                "cc_type"      => 'visa',
// 	                "cc_cvc"       => '222',
// 	                "ExpMonth"     => '4',
// 	                "ExpYear"      => 2023,
// 	            ];
// 	            $this->frontdesk->insert_tbl_CreditCards ( $card_data, $customer_id=0, $hms_reservation_id=0 );
// 	            echo "<pre>";
// 	            print_r($_SESSION);
// 	            die("DIED by A Department at debug3.php TEST_Errorring() on 3 июн. 2021 г. 14:38:11");
// 	        } catch (Exception $e) {
// 	            $this->Turn_Off_myCustomErrorHandler();
// 	            echo "<pre>";
// 	            echo $e->getMessage (),PHP_EOL;
// 	            echo $e->getFile (),PHP_EOL;
// 	            echo $e->getLine (),PHP_EOL;
// 	            $err_trace = $e->getTrace ();
// 	            print_r($err_trace[0], $err_trace[1], $err_trace[2]);
// 	            print_r($err_trace[1]);
// 	            print_r($err_trace[2]);
// 	            for ($i = 0; $i < 10; $i++) {
// 	                echo "<br>";
// 	                print_r($i*$i);
// 	            }
// 	        }


	        $this->db->insert($t->tvg_reservations, ['hms_res_id'=>$hms_reservation_id]);
	        $tvg2hms_res_id = $this->db->insert_id();
	        $guests_ages = $this->party_to_hms_guests_ages($party_set->party);
	        foreach ($guests_ages as $guest_age) {
                $insert_guest_data = [
                    'dob'       => date('Y-m-d', strtotime("$date_in - $guest_age year")),
                    'lastname'  => '---',
                    'firstname' => '---'
                ];
	            $guest_id = $this->frontdesk->Guest_insert($insert_guest_data);
	            $this->frontdesk->guests_reservation_insert($guest_id, $hms_reservation_id);
	        }
// 	        $this->frontdesk->save_taxesfees($hms_reservation_id);
// 	        $this->frontdesk->SetReservationBalance ( $hms_reservation_id );
	    }
	    $complex_hms_reservation_ids_for_tvg = substr($complex_hms_reservation_ids_for_tvg, 0, -1);
	    $if_complex_reservation = explode("_", $complex_hms_reservation_ids_for_tvg);
	    if (count($if_complex_reservation)>1){
	        $this->db->insert($t->groups, ['name'=>'TVG_GR_'.$complex_hms_reservation_ids_for_tvg]);
	        $group_id = $this->db->insert_id();
	        foreach ($if_complex_reservation as $reservation_id) {
	            $this->db->update($t->reservations, ['intgroupid'=>$group_id], ['id'=>$reservation_id]);
	        }
	        $this->db->insert($t->tvg_reservations, ['hms_group_id'=>$group_id]);
	        $tvg2hms_res_id = $this->db->insert_id();
	    }
//         $data_for_line_items = [
//             'prop_id'              => $r_d->prop_id,
//             'parties'              => $parties,
//             'type_id'              => $category_id,
//             'price_type'           => $rate_id,
//             'datein'               => $date_in,
//             'dateout'              => $date_out,
//             'hotel_currency'       => $this->get_hotel_currency(),
//             'requested_currency'   => $r_d->final_price_at_booking->currency
//         ];
//         $receipt = [
//             'line_items'    => $tvg2hms_res_id,
//             'final_price_at_booking'    => $tvg2hms_res_id,
//             'final_price_at_checkout'    => $tvg2hms_res_id,
//         ];
        $reservation = [
            'reservation_id'    => "$tvg2hms_res_id",
            'partner_reference' => "$r_d->partner_reference",
            'status'            => 'Booked',
            'confirmation_url'  => "https://book-".$r_d->hotel_host."/reservations/tvg_confirmation/?bid=$tvg2hms_res_id"."&lang=45&currency=".$r_d->final_price_at_booking->currency,
            'checkin_date'      => $r_d->checkin_date,
            'checkout_date'     => $r_d->checkout_date,
            'hotel'             => $this->get_hotel_details ( $r_d->prop_id ),
            'customer'          => $r_d->customer,
            'rooms'             => $r_d->rooms,
            'receipt'           => $r_d->partner_data->receipt,
        ];
	    $responce = [
	        'reference_id'     => $r_d->reference_id,
	        'status'           => 'Success',
	        'reservation'      => $reservation,
	        'customer_support' => $this->get_hotel_customer_support(),
	    ];
	    echo json_encode($responce);


	    //status
// 	    Success
// 	    Failure
// 	    PaymentPending


// 	    status	string
// 	    The status of the reservation, must be one of:
// 	    Booked
// 	    Cancelled
// 	    CheckedIn
// 	    CheckedOut
	}


	public function booking_cancel() {//curl
	    $t = &$this->db_tables;
		$r_d = json_decode( file_get_contents("php://input"));
		$status = 'Success';
		$row = $this->db->get_where($t->tvg_reservations, ['id'=>$r_d->reservation_id])->row();
		if ($row){
		    $res_ids_to_cancel = [];
		    if(is_null($row->hms_res_id) && !is_null($row->hms_group_id)){
                $query_res = $this->db->select('id')->get_where($t->reservations, ['intgroupid'=>$row->hms_group_id])->result();
                foreach ($query_res as $r) {
                    $res_ids_to_cancel[] = $r->id;
                }
		    }else{
		        $res_ids_to_cancel[] = $row->hms_res_id;
		    }
		}else{
		    $status = 'UnknownReference';//?Error
		}
		foreach ($res_ids_to_cancel as $reservation_id) {
			$data_for_cancelation = array (
				'res_id' => $reservation_id,
				'description' => 'Cancelation from Trivago',
				'charge' => 0,//cancelation policy penalty?
				'guestbe_request' => 'Once more durnia',//щоб не вмирати у ф-ції канцелювання
			);
			$this->cancel->Insert($data_for_cancelation);//нічого не вертає, завжди вважаємо що успішно кансельнули
		}
		$responce = [
		    'reservation_id'      => "$r_d->reservation_id",
		    'partner_reference'   => "$r_d->partner_reference",
		    'status'              => $status,
		    'cancellation_number' => "TVG_CA_$r_d->reservation_id",
		    'customer_support'    => $this->get_hotel_customer_support(),
		];
		echo json_encode($responce);
// 		"status": {
// 		"enum": [
// 		    "Success",
// 		    "AlreadyCancelled",
// 		    "UnknownReference",
// 		    "CannotBeCancelled",
// 		    "Error"
// 		],
	}


	function hotel_inventory(){//curl
		$requested_data = json_decode( file_get_contents("php://input"));
		$inventory_data = $this->get_hotel_details($requested_data->prop_id);
		$inventory_data->ta_id = $requested_data->ta_id;
		$inventory_data->partner_id = $requested_data->partner_id;
		$inventory_data->country = $inventory_data->country_str_name;
		echo json_encode($inventory_data);
	}


	public function convert_currency_from_amount_to($currency_from="", $amount=0, $currency_to=""){
		$t = &$this->db_tables;
		if($currency_from != "" && $currency_from != "" && $amount != 0){
			$sql = "SELECT t1.rate AS $currency_from, t2.rate AS $currency_to
			FROM $t->currency_rates_today as t1, $t->currency_rates_today as t2
			WHERE t1.name = '$currency_from' AND t2.name = '$currency_to'";
			$rate = $this->db->query($sql)->row();
			$rates_koef = $rate->$currency_to/$rate->$currency_from;
			$converted_amount = doubleval(round($amount * $rates_koef, 2));
			return $converted_amount;
		}
		return 0;
	}
	public  function get_hotel_details($prop_id, $requested_lang="") {
		$t = &$this->db_tables;
		if (!empty($requested_lang)){
			$resp_language_id = $this->get_responce_ability_hotel_language($requested_lang);
		}
		$sql = "SELECT t1.property_name_lat AS name, t1.street_lat AS street, t1.street_lat AS address1, t1.additional_information_lat AS address2, t1.city_lat AS city, t1.state_lat AS state, t1.post_code AS postal_code,
						t1.check_in_time, t1.check_out_time, t2.id AS country, t1.gps_coordinates,t1.reception_phone AS phone, t1.web_address AS url, t1.email
				FROM $t->prop_info AS t1
				JOIN $t->countries AS t2 ON t2.id = t1.country
				WHERE t1.id = $prop_id";
 		$hotel_details = $this->db->query($sql)->row();
 		list ($latitude,$longitude ) = explode(',', $hotel_details->gps_coordinates);
 		$hotel_details->latitude = (int)$latitude;
 		$hotel_details->longitude = (int)$longitude;
		$hotel_aneneties = $this->get_prop_anenties($prop_id);
		$hotel_details->amenities = $hotel_aneneties;
		$hotel_details->photos = [];
		$hotel_details->checkinout_policy = "Check-In time: $hotel_details->check_in_time, Check-Out time: $hotel_details->check_out_time";
		return $hotel_details;
	}
	public function get_prop_anenties($prop_id) {
		$t = &$this->db_tables;
		$sql = "SELECT t2.name
				FROM $t->prop2amenety AS t1
				JOIN $t->prop_ameneties AS t2 ON t1.amenity_id = t2.id
				WHERE t1.property_id = $prop_id";
		$query_res = $this->db->query($sql)->result();
		$anenties = array();
		foreach ($query_res as $amenity) {
		    array_push($anenties, $amenity->name);
		}
		return $anenties;
	}

	function get_room_type_details($requested_data) {
		$result = new stdClass();
		$t = &$this->db_tables;
		if ($requested_data->photos){
			$result->photos = array();
			$sql = "SELECT t1.id_position AS position
					FROM $t->room_photos AS t1
					WHERE t1.category_id = $requested_data->room_type_id";
			$photos = $this->db->query($sql)->result_array();
			foreach ($photos as $photo_data) {
				array_push($result->photos, array('url'=>'https://fr-online-booking.otelms.com/himages/'.$requested_data->hms_id.'_'.$requested_data->room_type_id.'_'.$photo_data['position'].'_500.jpg'));
			}
		}
		if ($requested_data->text){
			$sql = "SELECT  inter.value AS description
					FROM $t->room_params AS t1
					LEFT JOIN $t->inter AS inter ON inter.table_id = t1.catID AND inter.language_id = $requested_data->resp_language_id
					AND inter.table_type = 'category' AND inter.name = 'international_comment'
					WHERE t1.catID = $requested_data->room_type_id";
			$row = $this->db->query($sql)->row();
			if (isset($row->description)){
				$result->description = $row->description;
			}
		}
		//======================================  get category amenities
		$sql = "SELECT t2.tripadvisor AS amenity_code
				FROM $t->category2amenities AS t1
				JOIN $t->category_ameneties AS t2 ON t1.amenity_id = t2.id
				WHERE t1.category_id = $requested_data->room_type_id AND t2.tripadvisor != ''";
		$amenities_query_result = $this->db->query($sql)->result();
		$amenities = array();
		foreach ($amenities_query_result as $amenity) {
			array_push($amenities, $amenity->amenity_code);
		}
		// FREE WiFi 900126
		array_push($amenities, '900126');
		$result->room_amenities->standard = $amenities;
		$result->room_amenities->custom = array();
		//======================================  get category room size
		$sql = "SELECT  size as value, size_type as unit
        		FROM categories AS t1
        		WHERE t1.id = $requested_data->room_type_id";
		$row = $this->db->query($sql)->row();
		if (!empty($row->value)){
            switch ($row->unit) {
                case 1:
                    $unit = 'square_feet';
                    break;
                case 2:
                    $unit = 'square_feet';;
                    break;
                default:
                    $unit = 'square_feet';;
                    break;
            }
            $result->room_size->value = (int)$row->value;
		    $result->room_size->unit = $unit;
		}
		//======================================  get category bed_configurations and extra_bed_configurations
		$result->bed_configurations = array();
		$sql = "SELECT SUM(t1.value) as count, t2.ta as code
        		FROM beds2rooms AS t1
        		JOIN global_hotelix_common.bed_types as t2 ON t2.id = t1.bedID
        		WHERE t1.catID = $requested_data->room_type_id
		        GROUP BY t1.bedID";
		$query_res = $this->db->query($sql)->result();
		if (!empty($query_res)){
		    foreach ($query_res as $bed_configuration) {
		        if (is_null($bed_configuration->code)){//unspecified_bed 900303
		            $bed_configuration->code = 900303;
		        }
		        array_push($result->bed_configurations, array('standard' => array($bed_configuration)));
		    }
		}
		$result->extra_bed_configurations[0] = array('standard' => array(array('count'=>1, 'code'=>900303)));
		//======================================  get category room_view_types
		$sql = "SELECT DISTINCT t2.tripadvisor AS view_code
				FROM $t->room_params AS t1
				JOIN $t->room_views AS t2 ON t1.view = t2.id
				WHERE t1.catID = $requested_data->room_type_id AND t2.tripadvisor != ''";
		$views_query_result = $this->db->query($sql)->result();
		$views = array();
		foreach ($views_query_result as $view) {
			array_push($views, $view->view_code);
		}
		$result->room_view_types->standard = $views;
		$result->room_view_types->custom = array();
		//======================================  get category accessibility_features
		$result->accessibility_features = NULL;
		//======================================  get category room_smoking_policy, smoking, non_smoking
		$result->room_smoking_policy = in_array('74', $amenities)?'smoking':'non_smoking';//74 is OTA amenity smoking code

		return $result;
	}

	function get_rate_plan_details($requested_data) {
		$result = new stdClass();
		$t = &$this->db_tables;
		if ($requested_data->photos){
			$result->photos = NULL;
		}
		if ($requested_data->text){
			$sql = "SELECT  inter.value AS description
			FROM rate AS t1
			LEFT JOIN $t->inter AS inter ON inter.table_id = t1.id AND inter.language_id = $requested_data->resp_language_id
			AND inter.table_type = 'rate' AND inter.name = 'international_description'
			WHERE t1.id = $requested_data->rate_plan_id";
			$row = $this->db->query($sql)->row();
			if (isset($row->description)){
				$result->description = $row->description;
			}
		}
		//======================================  get rate amenities
		$result->rate_amenities->standard = array();
		$result->rate_amenities->custom = array();
		//======================================  get rate cancellation_policy
		$result->cancellation_policy  = NULL;
		$hotel_timezone = $this->db->get_where('hotelix_config', array('name'=>'timezone'))->row()->str_value;
		if (!empty($hotel_timezone)){
		    date_default_timezone_set("$hotel_timezone");
		}
		$check_in_time = $this->db->select('check_in_time')->get_where($t->prop_info, array('id'=>$requested_data->prop_id))->row()->check_in_time;
		$common_start_date = date('c', strtotime("now"));
		$common_end_date = date('c', strtotime("$requested_data->start_date $check_in_time"));
		$sql = "SELECT  t2.name AS cancelation_name_code, t3.id AS cancelation_type_id, t4.id AS meal_plan,
						t2.penalty_ar,t2.deadline_days, t2.deadline_hours, t2.penalty_ad, t2.penalty_ad_nights, t2.description
				FROM rate AS t1
				JOIN $t->cancelations AS t2 ON t2.id = t1.cancellation_policy_id
				JOIN $t->cancelation_types AS t3 ON t3.id = t2.type_id
				JOIN $t->meal_policies as t4 ON t1.meal_policy_id = t4.id
				WHERE t1.id = $requested_data->rate_plan_id";
		$row_rate_rezult = $this->db->query($sql)->row();
		$hms_cancel_policy = $row_rate_rezult->cancelation_type_id;
        switch ($hms_cancel_policy) {
            case 1:
                $ta_cancel_type = 'none';//Non-Refundable
                $result->cancellation_policy->cancellation_rules = array();
                $cancellation_rule = new stdClass();
                $cancellation_rule->start_datetime = $common_start_date;
                $cancellation_rule->end_datetime = $common_end_date;
                $cancellation_rule->percent_fee->amount = !empty($row_rate_rezult->penalty_ad)? (double)($row_rate_rezult->penalty_ad / 100) : NUll;
                $cancellation_rule->night_fee->num_nights = !empty($row_rate_rezult->penalty_ad_nights)? $row_rate_rezult->penalty_ad_nights : NUll;
                array_push($result->cancellation_policy->cancellation_rules, $cancellation_rule);
                break;
            case 2:
                $ta_cancel_type = 'full';//Free Cancellations
                $deadline_date = date('c', strtotime("$common_end_date - $row_rate_rezult->deadline_hours hours"));
                $result->cancellation_policy->cancellation_summary->cancellation_deadline = $deadline_date;
                $result->cancellation_policy->cancellation_rules = array();
                $cancellation_rule = new stdClass();
                $cancellation_rule->start_datetime = $deadline_date;
                $cancellation_rule->end_datetime = $common_end_date;
                $cancellation_rule->percent_fee->amount = !empty($row_rate_rezult->penalty_ad)? (double)($row_rate_rezult->penalty_ad / 100) : NUll;
                $cancellation_rule->night_fee->num_nights = !empty($row_rate_rezult->penalty_ad_nights)? $row_rate_rezult->penalty_ad_nights : NUll;
                array_push($result->cancellation_policy->cancellation_rules, $cancellation_rule);
                break;
            case 3:
                $ta_cancel_type = 'partial';//Non-Free Cancellations
                $result->cancellation_policy->cancellation_rules = array();
                $deadline_date = date('c', strtotime("$common_end_date - $row_rate_rezult->deadline_hours hours"));
                if ($deadline_date > $common_start_date){
                    $cancellation_rule = new stdClass();
                    $cancellation_rule->start_datetime = $common_start_date;
                    $cancellation_rule->end_datetime = $deadline_date;
                    $cancellation_rule->percent_fee->amount = !empty($row_rate_rezult->penalty_ar)? (double)($row_rate_rezult->penalty_ar / 100) : NUll;
                    $cancellation_rule->night_fee->num_nights = !empty($row_rate_rezult->penalty_ad_nights)? $row_rate_rezult->penalty_ad_nights : NUll;
                    array_push($result->cancellation_policy->cancellation_rules, $cancellation_rule);
                }
                $cancellation_rule = new stdClass();
                $cancellation_rule->start_datetime = $deadline_date;
                $cancellation_rule->end_datetime = $common_end_date;
                $cancellation_rule->percent_fee->amount = !empty($row_rate_rezult->penalty_ad)? (double)($row_rate_rezult->penalty_ad / 100) : NUll;
                $cancellation_rule->night_fee->num_nights = !empty($row_rate_rezult->penalty_ad_nights)? $row_rate_rezult->penalty_ad_nights : NUll;
                array_push($result->cancellation_policy->cancellation_rules, $cancellation_rule);
                break;
        }
		$result->cancellation_policy->cancellation_summary->refundable = $ta_cancel_type;
		if ($requested_data->text){
		    $result->cancellation_policy->cancellation_summary->unstructured_cancellation_text = $row_rate_rezult->description;
		}
		//======================================  get rate meal_plan
		$result->meal_plan->standard = array($row_rate_rezult->meal_plan);
		$result->meal_plan->custom = array();
		return $result;
	}
	public function party_to_hms_guests($party, $cat_id=0) {
		$t = &$this->db_tables;
		$babies_count = 0;
		$over_children_count = 0;
		$ta_children = (isset($party->children)) ? $party->children : array();
		if (!empty($ta_children) && $cat_id){
			$sql = "SELECT t1.baby_places, t3.to AS max_baby_age, t4.to AS max_child_age
					FROM categories AS t1
					JOIN $t->prop_info AS t2 ON t1.property_id = t2.id
					LEFT JOIN $t->age_ranges AS t3 ON t2.range_id = t3.range_id AND t3.id = 1
                    LEFT JOIN $t->age_ranges AS t4 ON t2.range_id = t4.range_id AND t4.id = 2
					WHERE t1.id = $cat_id";
			$row_rezult = $this->db->query($sql)->row();
			if (!empty($row_rezult)){
				$max_babies_and_children_places = $row_rezult->baby_places;
				$max_baby_age = isset($row_rezult->max_baby_age) ? (int)$row_rezult->max_baby_age : 0;
				$max_child_age = isset($row_rezult->max_child_age) ? (int)$row_rezult->max_child_age : 0;
				foreach ($ta_children as $ta_child_age) {
				    if($ta_child_age <= $max_baby_age){
						$babies_count ++;
				    }elseif (($ta_child_age <= $max_child_age) && $max_babies_and_children_places > 0){
						$max_babies_and_children_places--;
					}else{
						$over_children_count++;
					}
				}
			}
		}
		$guests = array();
		$guests['adults'] = $party->adults + $over_children_count;
		$guests['baby_places'] = count($ta_children) - $over_children_count - $babies_count;
		$guests['babyplace2'] = $babies_count;
		return $guests;
	}

	function party_to_hms_guests_ages($party) {
	    //$t = &$this->db_tables;
	    $ages = array();
	    $adults_min_age = 35;
	    $adults = $party->adults;
	    while ($adults > 0) {
	        array_push($ages, $adults_min_age);
	        $adults--;
	    }
	    if (isset($party->children)){
	        foreach ($party->children as $child_age) {
	            array_push($ages, $child_age);
	        }
	    }
	    return $ages;
	}

	function get_price_line_items($data) {
		//два варіанта стратегії ціни: 1) повернення для ціни для максимальної партії; 2) повернення суми цін всіх партій
		//1)
		$price_strategy = 2;//2
		if ($price_strategy == 1){
			// get max party id is parties array
			$max_party_id = 0;//first party
			$max_guests_count = 1;
			foreach ($data['parties'] as $party_id => $party) {
				$children_count = (isset($party->children)) ? count($party->children) : 0;
				$room_guests_count = $party->adults + $children_count;
				if ($room_guests_count > $max_guests_count) {
					$max_guests_count = $room_guests_count;
					$max_party_id = $party_id;
				}
			}
			$data = array_merge($data, $this->party_to_hms_guests($data['parties'][$max_party_id], $data['type_id']));
			$hms_amount = $converted_amount = $this->frontdesk->get_otelms_amount ( $data );
			if ($data['hotel_currency'] != $data['requested_currency']){
				$converted_amount = $this->convert_currency_from_amount_to ( $data['hotel_currency'], $hms_amount, $data['requested_currency'] );
			}
			$result = array (
					array (
							'price' => array (
									'requested_currency_price' => array (
											'amount'=>$converted_amount,
											'currency'=>$data['requested_currency']
									),
									'currency_of_charge_price' => array (
											'amount'=>$hms_amount,
											'currency'=>$data['hotel_currency']
									)
							),
							'type' => 'rate',
							'paid_at_checkout' => true
					)
			);
		}
		if ($price_strategy == 2){
			$summary_amount = 0;
			$taxes_fees_all_parties_arr = array();
			foreach ($data['parties'] as $party) {
				$hms_guests = $this->party_to_hms_guests($party, $data['type_id']);
				$hms_guests_ages = $this->party_to_hms_guests_ages($party);
// 				$hms_guests_count = $hms_guests['adults']+$hms_guests['baby_places']+$hms_guests['babyplace2'];

				$data_for_party = array_merge($data, $hms_guests);
				$hms_amount_for_single_rarty = $this->frontdesk->get_otelms_amount ( $data_for_party );
				$summary_amount += $hms_amount_for_single_rarty;
				$data_for_tf = array (
						'prop_id' => $data ['prop_id'],
				        'guests' => $hms_guests,//$hms_guests_count,
                        'guest_ages' => $hms_guests_ages,
						'amount' => $hms_amount_for_single_rarty,
						'duration' => round((strtotime( $data['dateout'])-strtotime( $data['datein']))/ (3600 * 24))
				);
				$taxes_fees_party_arr = $this->get_taxes_fees_arr($data_for_tf);
				foreach ($taxes_fees_party_arr as $name_code => $tax_or_fee) {
					if (isset($taxes_fees_all_parties_arr[$name_code])){
						$taxes_fees_all_parties_arr[$name_code]['amount'] += $tax_or_fee['amount'];
					}else{
						$taxes_fees_all_parties_arr[$name_code]['amount'] = $tax_or_fee['amount'];
						$taxes_fees_all_parties_arr[$name_code]['type'] = $tax_or_fee['type'];
					}
				}
			}
			$summary_amount = (double)round($summary_amount, 2);
			$converted_amount = $summary_amount;
			$need_convertation = false;
			if ($data['hotel_currency'] != $data['requested_currency']){
				$converted_amount = $this->convert_currency_from_amount_to ( $data['hotel_currency'], $summary_amount, $data['requested_currency'] );
				$need_convertation = true;
			}
			$result = array (
					array (
							'price' => array (
									'requested_currency_price' => array (
											'amount' => $converted_amount,
											'currency' => $data ['requested_currency']
									),
									'currency_of_charge_price' => array (
											'amount' => $summary_amount,
											'currency' => $data ['hotel_currency']
									)
							),
							'type' => 'rate',
							'paid_at_checkout' => true
					)
			);
			if (!empty($taxes_fees_all_parties_arr)){
				foreach ($taxes_fees_all_parties_arr as $name_code => $tax_or_fee){
					array_push ( $result, array (
							'price' => array (
									'requested_currency_price' => array (
                                            'amount' => ($need_convertation)? $this->convert_currency_from_amount_to ( $data['hotel_currency'], $tax_or_fee['amount'], $data['requested_currency'] ) : (double)$tax_or_fee['amount'],
											'currency' => $data ['requested_currency']
									),
									'currency_of_charge_price' => array (
											'amount' => (double)$tax_or_fee['amount'],
											'currency' => $data ['hotel_currency']
									)
							),
							'type' => $tax_or_fee['type'],
							'sub_type'=> $name_code,
							'paid_at_checkout' => true
					) );
				}
			}
		}
		return $result;
	}

	function sync_booking() {//curl
		$requested_data = file_get_contents("php://input");
		$requested_data = json_decode($requested_data);
		$t = &$this->db_tables;
		$complex_reservation = explode("_", $requested_data->reservation_id);
		$where_res_in_arr = "";
		foreach ($complex_reservation as $hms_reservation_id) {
			$where_res_in_arr .= $hms_reservation_id.', ';
		}
		$where_res_in_arr = substr($where_res_in_arr, 0, -2);
		$where_res_in_arr = " IN ($where_res_in_arr) ";
		$sql = "SELECT t1.datein AS checkin_date, t1.dateout AS checkout_date, SUM(t1.amount) AS total_booking_rate,
						DATE_FORMAT(t2.time, '%Y-%m-%d') AS cancelled_date
				FROM $t->reservations AS t1
				LEFT JOIN $t->servises AS t2 ON t1.id = t2.reservation_id AND t2.type = 2
				WHERE t1.id $where_res_in_arr
				GROUP BY t1.id";
		$query_result = $this->db->query($sql)->row();
		$requested_data->status = "Booked";
		if (!is_null($query_result->cancelled_date)){//booking is canceled
			$requested_data->status = "Cancelled";
			$requested_data->cancellation_number = "TA_CA_".$requested_data->reservation_id;
		}
		$hotel_currency = $this->get_hotel_currency();
		$requested_data->total_rate = array (
				'amount' => (int)$query_result->total_booking_rate,
				'currency' => $hotel_currency
		);
		$sql_tf = "SELECT LEFT(t3.name_code, 3) AS type, SUM(t1.value) AS amount
                    FROM services_tf AS t1
                    JOIN taxes_fees AS t2 ON t2.id = t1.taxes_fees_id
					JOIN ta_tax_fee_subtypes AS t3 ON t3.id = t2.ta_subtype_id
                    WHERE t1.reservation_id $where_res_in_arr
                    GROUP BY type";
		$query_result_tf = $this->db->query($sql_tf)->result();
		$total_taxes_amount = 0;
		$total_fees_amount = 0;
		if (!empty($query_result_tf)){
		    foreach ($query_result_tf as $t_or_f) {
                switch ($t_or_f->type) {
                    case 'tax':
                        $total_taxes_amount = (int)$t_or_f->amount;
                        break;
                    case 'fee':
                        $total_fees_amount = (int)$t_or_f->amount;
                        break;
                }
		    }
		}
		$requested_data->total_taxes = array (
		    'amount' => $total_taxes_amount,
		    'currency' => $hotel_currency
		);
		$requested_data->total_fees = array (
		    'amount' => $total_fees_amount,
		    'currency' => $hotel_currency
		);
 		$requested_data = (object) array_merge((array) $requested_data, (array) $query_result);
		echo json_encode($requested_data);
	}

	function get_taxes_fees_arr($data) {
		$guests = $data['guests'];
		$guests_ages = $data['guest_ages'];
        $request_data_arr = array(
            'property_id' => $data['prop_id'],
            'amount' => $data['amount'],
            'duration' => $data['duration'],
            'guests' => $guests,
            'guest_ages' => $guests_ages
        );
		$res_arr = array();
		if ($this->config->item('trip_taxes_fees_new')){// process new logig with Taxes&Fees by property
		    $tfs = $this->taxesfees_model->get_services_tf_data_by_property($request_data_arr);
		    foreach ($tfs as $tf_data) {
		        if (!isset($res_arr[$tf_data['name_code']])){
		            $res_arr[$tf_data['name_code']]['type'] = $tf_data['type'];
		            $res_arr[$tf_data['name_code']]['amount'] = $tf_data['amount'];
		        }else{
		            $res_arr[$tf_data['name_code']]['amount'] += $tf_data['amount'];
		        }
		    }
// 			$sql = "SELECT t3.name_code, LEFT(t3.name_code, 3) as type,
// 							SUM(IF(t1.object_type=2, $guests, 1)*IF(t1.period_type=1, $duration, 1)*IF(t1.calc_type=2, TRUNCATE($amount*t1.calc_value/100, 2), t1.calc_value)) as amount
// 					FROM taxes_fees2property AS t1
// 					JOIN taxes_fees AS t2 ON t2.id = t1.taxes_fees_id
// 					JOIN ta_tax_fee_subtypes AS t3 ON t3.id = t2.ta_subtype_id
// 					WHERE t1.property_id = $prop_id
// 					GROUP BY t3.id";
// 			$temp_res_arr = $this->db->query($sql)->result_array();
// 			foreach ($temp_res_arr as $tax_or_fee) {
// 				$res_arr[$tax_or_fee['name_code']] = $tax_or_fee;
// 			}
//(IF(t1.object_type=1, IF(t1.calc_type=2, TRUNCATE($amount*t4.value/100, 2), t4.value), 1)*IF(t1.period_type=1, $duration, 1)) as amount
		}else{
			$partner_texes_fees = $this->db->select('tour_fee_value, nds, nds_value')->get_where('partners', array('isdefault'=>1))->row();
			if (isset($partner_texes_fees->tour_fee_value) && $partner_texes_fees->tour_fee_value != 0){
				$res_arr['taxes']['tax_city'] = $partner_texes_fees->tour_fee_value;
			}
			if (isset($partner_texes_fees->nds) && isset($partner_texes_fees->nds_value) && $partner_texes_fees->nds_value != 0 && $partner_texes_fees->nds != 0){
				$res_arr['taxes']['tax_vat'] = $partner_texes_fees->nds_value;
			}
		}
		return $res_arr;
	}

	function modul_booking_request() {//curl
	    $t = &$this->db_tables;
	    $request_data = file_get_contents("php://input");
	    $request_data = json_decode($request_data, true);
	    $date_in = $request_data['booking_data']['date_in'];
	    $date_out = $request_data['booking_data']['date_out'];
	    $category_id = $request_data['booking_data']['selected_category'];
	    $rate_id = $request_data['booking_data']['selected_rate'];
	    $request_data['customer']['lastname'] = empty($request_data['customer']['lastname']) ? '---' : $request_data['customer']['lastname'];
	    $request_data['customer']['firstname'] = empty($request_data['customer']['firstname']) ? '---' : $request_data['customer']['firstname'];
	    $customer_id = $this->frontdesk->Guest_insert ( $request_data['customer'] );

	    $insert_reservation_data = array (
	        'dc_id' => $request_data['booking_data']['dc_id'],
	        'dc_uuid' => '',
	        'dc_source' => 'TripAdvisor',
	        'dc_currencycode' => '',
	        'dc_customerremarks' => '',
	        'dc_totalprice' => '',
	        'is_guest' => 0,
	        'datein' => $date_in,
	        'dateout' => $date_out,
	        'price_type' => $rate_id
	    );
	    $complex_hms_reservation_ids_for_tvg = "";
	    $ta_res_id_for_url = "";
	    $group_id = 'NoGroup';
	    foreach ($request_data['booking_data']['parties'] as $master_key => $party_set) {
	        $room_number = $master_key+1;
	        $request_data['guests'][$room_number]['hms_ids'] = array();
            foreach ($request_data['guests'][$room_number]['adults'] as $adult_numder => &$adult) {
                $adult['dob'] = date('Y-m-d', strtotime("$date_in - 35 year"));
                $adult['lastname'] = empty($adult['lastname']) ? '---' : $adult['lastname'];
                $adult['firstname'] = empty($adult['firstname']) ? '---' : $adult['firstname'];
                array_push( $request_data['guests'][$room_number]['hms_ids'], $this->frontdesk->Guest_insert($adult));
            }
            if (isset($request_data['guests'][$room_number]['children'])){
                foreach ($request_data['guests'][$room_number]['children'] as $age => &$child) {
                    $child['dob'] = date('Y-m-d', strtotime("$date_in - $age year"));
                    $child['lastname'] = empty($child['lastname']) ? '---' : $child['lastname'];
                    $child['firstname'] = empty($child['firstname']) ? '---' : $child['firstname'];
                    array_push( $request_data['guests'][$room_number]['hms_ids'], $this->frontdesk->Guest_insert($child));
                }
            }
	        $insert_reservation_data['room_id'] = $this->frontdesk->getfreeroomlist($date_in, $date_out, $category_id);
	        $acb_set = $this->party_to_hms_guests((object)$party_set, $category_id);
	        $insert_reservation_data = array_merge($insert_reservation_data, $acb_set);
	        $hms_reservation_id = $this->frontdesk->Reservation_insert ( $insert_reservation_data, $customer_id, 0, 1 );
	        $complex_hms_reservation_ids_for_tvg .= $hms_reservation_id."_";
            $this->db->insert($t->ta_reservations, array('hms_res_id'=>$hms_reservation_id));
	        $ta_res_id_for_url = $this->db->insert_id();
	        foreach ($request_data['guests'][$room_number]['hms_ids'] as $guest_id) {
	            $this->frontdesk->guests_reservation_insert($guest_id, $hms_reservation_id);
	        }
	         $this->frontdesk->save_taxesfees($hms_reservation_id);
	         $this->frontdesk->SetReservationBalance ( $hms_reservation_id );
	    }
	    $complex_hms_reservation_ids_for_tvg = substr($complex_hms_reservation_ids_for_tvg, 0, -1);
	    $if_complex_reservation = explode("_", $complex_hms_reservation_ids_for_tvg);
	    if (count($if_complex_reservation)>1){
            $this->db->insert($t->groups, array('name'=>'TA_GR_'.$complex_hms_reservation_ids_for_tvg));
	        $group_id = $this->db->insert_id();
	        foreach ($if_complex_reservation as $reservation_id) {
	           $this->db->update($t->reservations, array('intgroupid'=>$group_id), array('id'=>$reservation_id));
	        }
	        $this->db->insert($t->ta_reservations, array('hms_group_id'=>$group_id));
	        $ta_res_id_for_url = $this->db->insert_id();
	    }
        echo json_encode(array(
            'rezult' => 'ok',
            'bid' => $ta_res_id_for_url,
            'resevation_ids' => $complex_hms_reservation_ids_for_tvg,
            'ta_resevation_id' => $ta_res_id_for_url,
            'group_id' => $group_id,
            'guests' => $request_data['guests'],
        ));
	}


	public function Turn_On_myCustomErrorHandler() {
	    function myCustomErrorHandler($errNo, $errMsg, $file, $line) {
	        throw new Exception($errMsg);
	    }
	    set_error_handler('myCustomErrorHandler');
	}

	public function Turn_Off_myCustomErrorHandler() {
	    restore_error_handler();
	}
}

class Tables {
    var $tvg_hotels = "`global_hotelix`.`dc_tvg_hotels`";
    var $h_config = 'hotelix_config';
    var $prop_info = "property_information";//property_custom_information
    var $prop_ameneties = "property_ameneties";
    var $prop2amenety = "property2ameneties";
    var $currency_rates_today = "`global_hotelix`.currency_rates_today";
    var $currencies = '`global_hotelix`.`currency`';
    var $supported_langs = 'descriptionlanguages';
    var $availability = "deskofdays_availability";
    var $inter = "internationalfields";
    var $room_views = "global_hotelix_common.room_view_type";
    var $beds2rooms = "beds2rooms";
    var $room_params = "category_room_param";
    var $bed_types = "`global_hotelix_common`.`bed_types`";
    var $room_photos = "category_images_registry";
    var $category2amenities = "category2amenities";
    var $category_ameneties = "category_ameneties";
    var $cancelations = "`global_hotelix_common`.`dc_cancelationpolicy_list`";
    var $cancelation_types = "`global_hotelix_common`.`cancellationpolicy_types`";
    var $meal_policies = "meal_policies";
    var $age_ranges = "age_ranges_acb";
    var $reservations = "deskofreservation";
    var $groups = "groupreservations";
    var $servises = "services_main";
    var $servises_tf = "services_tf";
    var $countries = "global_fms_base.dict_country";
    var $tvg_reservations = "tvg_reservations";

}