<?php 
class Gate extends CI_Controller {
	static  $model_name = "dcm_ta_gate";
	public $test_av_req = '{
  "api_version": 8,
  "start_date": "2019-11-26",
  "end_date": "2019-11-27",
  "party": [
    {
      "adults": 1
    }
  ],
  "language": "en_US",
  "query_key": "6167a22d1f87d2028bf60a8e5e27afa7_191_1360299600000_2_2",
  "currency": "USD",
  "user_country": "US",
  "device_type": "Desktop",
  "availability_id": "a2fd740a-ad02-476d-b314-925a125509be",
  "requested_payload": {
    "categories": {
      "room_type_details": true,
      "rate_plan_details": true,
      "room_rate_details": true,
      "hotel_details": false
    },
    "category_modifiers": {
      "partner_booking_data": false,
      "real_time_pricing": false,
      "multiple_room_rates": true,
      "photos": true,
      "text": true
    }
  },
  "hotels": [{
      "ta_hotel_id": 258705,
      "partner_hotel_code": "92_1"
    },
    {
      "ta_hotel_id": 730099,
      "partner_hotel_code": "92_2"
    },
    {
      "ta_hotel_id": 555555,
      "partner_hotel_code": "92_3"
    }]

}';
	public $test_expanded_av_request = '{
  "api_version": 8,
  "start_date": "2019-12-25",
  "end_date": "2019-12-27",
  "party": [
    {
      "adults": 1
    }
  ],
  "language": "en_US",
  "currency": "USD",
  "user_country": "US",
  "device_type": "Desktop",
  "query_key": "TripAdvisorAPITest_795e8dbb-5aec-446a-94ae-71ff90ad3123",
  "availability_id": "TestAvailabilityId_32a79f78-70a2-416d-8eea-9eaa9d96de11",
  "requested_payload": {
    "categories": {
      "room_type_details": true,
      "rate_plan_details": true,
      "room_rate_details": true,
      "hotel_details": true
    },
    "category_modifiers": {
      "partner_booking_data": true,
      "real_time_pricing": true,
      "multiple_room_rates": true,
      "photos": true,
      "text": true
    }
  },
  "debug": false,
  "hotels": [
    {
      "ta_hotel_id": 1,
      "partner_hotel_code": "92_1"
    }
  ]
}';
	public $test_booking_request = '{
    "api_version": 8,
    "start_date":"2019-12-20",
    "end_date":"2019-12-25",
    "partner_hotel_code":"92_1",
    "reference_id":"766588a634734cc8b60dd6a66b2561c4",
    "ip_address":"192.168.1.1",
    "customer":{
        "first_name":"Paul",
        "last_name":"Revere",
        "phone_number":"5555555555",
        "email":"paul.revere@tripadvisor.com",
        "country":"US"
    },
    "rooms":[{
            "party":{"adults":1,"children":[]},
        "traveler_first_name":"Paul",
        "traveler_last_name":"Revere"
    }],
    "special_requests":"A pre-made pillow fort and Vanilla coke on arrival please.",
    "payment_method":{
        "card_type":"Visa",
        "card_number":"5454545454545454",
        "cardholder_name":"Paul Revere",
        "expiration_month":"01",
        "expiration_year":"2015",
        "cvv":"999",
        "billing_address":{
            "address1":"141 Needham Street",
            "city":"newton",
            "state":"MA",
            "postal_code":"77777",
            "country":"US"
        }
    },
    "final_price_at_booking":{
        "amount":100,
        "currency":"USD"
    },
    "final_price_at_checkout":{
        "amount":200,
        "currency":"USD"
    },
    "partner_data":{
        "hms_id":"92",
		"prop_id":"1",
		"rate_id":"85",
		"category_id":"3"
    }
}';
    public function __construct() {
        parent::__construct();
        $model_name = self::$model_name;
        $model_path = "dcm_ta_gate/";
        $this->load->model ( "$model_path$model_name" );
    }
	
	function config() {//There are no request parameters on this GET request
    	$response = new ConfigResponse;
    	$response->configuration->add_emergency_contact('emr_fullname1','emr_email1@gmail.com', 'emr_phone1');
    	$response->configuration->add_emergency_contact('emr_fullname2','emr_email2@gmail.com', 'emr_phone2');
    	$response->configuration->add_info_contact('info_fullname1','info_email1@gmail.com', 'info_phone1');
    	$response->send();
    }
    
    function hotel_inventory () {//sending the parameters in a GET request
    	$model_name = self::$model_name;
    	$request = $_GET;
    	$response = new InventoryResponse($request);
    	$hotels_list = $this->$model_name->get_ta_hotels();
    	foreach ($hotels_list as $hotel) {
    		$hotel['ta_id'] = (int)$hotel['ta_id'];
    		$hotel['latitude'] = (int)$hotel['partner_id'];
    		$hotel['longitude'] = (int)$hotel['partner_id'];
//     		$hotel_inventory_data = $this->$model_name->get_hotel_inventory_data($hotel);
    		$response->add_hotel($hotel);
    	}
    	$response->send();
    }
    
    function availability() { // sending the parameters in a POST request
    	$model_name = self::$model_name;
    	$this->$model_name->log_http_push();
		$postdata = file_get_contents ( "php://input" );
// 		$postdata = $this->test_expanded_av_request;//TEMP=============================================================================
    	$response = new AvailabilityResponse($postdata);//$this->test_av_req
    	$flags = $response->get_requested_flags();
		$requested_data = array (
				'start_intday' => $response->get_start_intday(),
				'end_intday'  => $response->get_end_intday(),
				'currency' => $response->availability_request->currency,
				'language' => $response->availability_request->language,
				'rooms' => $response->get_requested_rooms_count(),
				'persons' => $response->get_requested_guests_count(),
				'requested_flags' => $flags
		);
    	foreach ($response->hotels as $partner_hotel_code => $single_hotel_response) {
    		$requested_data['partner_hotel_code'] = $partner_hotel_code;
    		$availability_data = $this->$model_name->get_hotel_availability_data ($requested_data);
    		if (!empty($availability_data)){
    			$single_hotel_response->response_type = 'available';
    			$single_hotel_response->available = $availability_data;
    		} else {
    			$single_hotel_response->response_type = 'unavailable';
    		}
    	}
     	$response->send();
    }
    
    function booking_submit () {//sending the parameters in a POST request
   		$booking_request_data = file_get_contents ( "php://input" );
//     	$booking_request_data = $this->test_booking_request; // TEMP FOR TEST!!====================================
    	$curl_url = "/gate_ta/booking_request";
    	$model_name = self::$model_name;
    	$response = new BookingSubmitResponse($booking_request_data);
    	$request = $response->get_request();
    	$hotel = $this->$model_name->get_ta_hotels($request->partner_hotel_code);
    	$curl_url = $hotel['host'].$curl_url;
    	$hms_reservation_data = json_decode($this->$model_name->curl_rawpost_requested_booking_data($booking_request_data, $curl_url));
    	$response->status = "Success";
    	$response->reservation->status = "Booked";
    	$response->reservation->reservation_id = $hms_reservation_data->hms_reservation_id;
    	$response->send();
    }
    
    function booking_verify () {//sending the parameters in a GET request
    }
    
    function booking_cancel () {//sending the parameters in a POST request
    }
    
    function booking_sync () {//sending the parameters in a POST request
    }

}