<?php
class cClearHrsRate {
	var $dc_rate_id = - 1;
	var $dc_rate_name = "";
	var $group = 0;
	var $restrict_id = 0;
	var $cancelable = "true";
	var $cancellationDeadlineType = "";
	var $HRSHSVReservationMode = "";
	
}
class dc_hrs_c2 extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('dcm_hrs');
        $this->load->model('htmltpl');
        $this->load->model('frontdesk');
        $this->load->model('Authorization');
        $this->load->model('Loger_admin');
        $this->load->model('loger_dc');
        $newdata = array(
            'REQUEST_URI' => $_SERVER["REQUEST_URI"]
        );
        $this->session->set_userdata($newdata);
        $this->Authorization->IsLogined("admin_access");
        
        // ==== billing plan access start ==========
        $data_access = array('module_name' => 'channel_manager');
        $billing_plan_access = $this->Access->get_billing_plan_access($data_access);
        if($billing_plan_access == 0){
            die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>" );
        }
        // ==== billing plan access end ==========
    }
    
    function reservations_form() {
    	$data = array ();
    	$this->load->library ( 'parser' );
    	$this->load->view ( 'dc_hrs_c2_reservations_form_view.php', $data );
    }
    
	function reservations_post() {
    	$date = $_POST ["date"];
    	$date_arr = explode (" ", $date);
    	$time = "";
    	if(isset($date_arr[0])){
    		$time .= $date_arr[0];
    	}
   		if(isset($date_arr[1])){
    		$time .= "T".$date_arr[1];
    	}
    	
    	date_default_timezone_set ( "Europe/Berlin" );
    	
    	if($time == ""){
    		$time = date ( "Y-m-d\TH:i:s", mktime () - 0*  60 * 60 * 1 );
    	}
    	
    	$url = "https://iut-soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
		$url = "https://soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
		// echo "+++";
		// die();
		$param = $this->dcm_hrs->get_auth ();
		$url = $param ["url"];
		
		$client = new SoapClient ( $url );
		$header = null;
		$options = null;
		
		echo "<pre>\n\n";
		echo "\n" . $time;

		echo "\n" . $param ['hotelKey'];
		echo "\n\n";
		// $time = "2015-05-06T20:44:26";
		// $time = "2015-05-05T20:44:26";
		// die();
		echo "=================HSVReservationInformation<br>";
		try {
			$request = array (
					"hsvReservationInformationRequest" => array (
							"credentials" => array (
									"clientType" => $param ['clientType'],
									"clientKey" => $param ['clientKey'],
									"clientPassword" => $param ['clientPassword'],
									"customerKey" => $param ['customerKey'] 
							),
							"locale" => array (
									"iso3Country" => "DEU",
									"iso3Language" => "ENG",
									"isoCurrency" => "EUR" 
							),
							
							"timeoutMillis" => 6000,
							"ipAddress" => "1.1.1.1",
							"hotelKey" => $param ['hotelKey'],
							"modificationTimestamp" => $time 
					) 
			);
			$result = $client->__soapCall ( "hsvReservationInformation", $request, $options, $header );
			// "modificationTimestamp"=>"2015-04-08T18:00:57.449+01:00",
		} catch ( SoapFault $e ) {
			echo "<pre>\n";	
	        echo "*** faultstring ***\n";
	        print_r ( $e->faultstring );
	        echo "*** detail ***\n";
	        print_r ( $e->detail );
	        echo "*** message ***\n";
	        echo $e->detail->HRSException->message;
		}
		// echo "<pre>";
		//print_r ( $request );
		print_r ( $result );
		if ($this->config->item('loger_v2') == 0) {
		      $log_update_id = $this->dcm_hrs->save_hrs_log ( $url, print_r ( $request, true ), 0, 0 );
		}
		if ($this->config->item('loger_v2') == 0) {
            if (isset($result->reservationsProcesses)) { 
                $response = print_r($result, true);
                $this->dcm_hrs->save_hrs_log(0, 0, print_r($result, true), $log_update_id);
            } else {
                $response = $e->detail->HRSException->message;
                $this->dcm_hrs->save_hrs_log(0, 0, $e->detail->HRSException->message, $log_update_id);
            }
        } else {
            $dc_id = 11;
            $data = array();
            $data["request"] = print_r($request, true);
            $data["response"] = $response;
            $data["url"] = $url;
            $data["dc_id"] = $dc_id;
            $log_update_id = $this->loger_dc->SaveLog_v2($data);
        }
		
		$reservation_result = $this->dcm_hrs->reservation_xml_parse ( $result );
		$this->Loger_admin->Save_SyncData ( "", "", $reservation_result, 11, 10, $log_update_id );
    }
	function get_bookings_withID() {
	    $global_debug_log = $this->config->item('global_debug_log');
		$reservationkey = $this->input->post ( 'dc_reservation_id' );
		if ($reservationkey != "") {
			$url = "https://iut-soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
			$url = "https://soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
			// echo "+++";
			// die();
			$param = $this->dcm_hrs->get_auth ();
			$url = $param ["url"];
			
			$client = new SoapClient ( $url );
			$header = null;
			$options = null;
			
			$sql = "select str_value from dc_hrs_xml_cfg where name ='sync_time'";
			
			$result = $this->db->query ( $sql );
			if ($result->num_rows () == 1) {
				$row = $result->row ();
				$time = $row->str_value;
			} else {
				$time = gmdate ( "Y-m-d\TH:i:s", mktime () - 24 * 60 * 60 * 1 );
			}
			$time_now = gmdate ( "Y-m-d\TH:i:s", mktime () + 2 * 60 * 60 );
			$this->db->query ( "insert into dc_hrs_xml_cfg (name, str_value) values ('sync_time', '$time_now')
	        on duplicate key update str_value='$time_now'" );
			echo "<pre>\n\n";
			echo "\n" . $time;
			echo "\n" . $time_now;
			echo "\n" . $param ['hotelKey'];
			echo "\n\n";
			// $time = "2015-05-06T20:44:26";
			// $time = "2015-05-05T20:44:26";
			// die();
			
			// $param['hotelKey'] = 534701;
			// $reservationkey = 141490562;
			
			echo "=================HSVReservationInformation<br>";
			try {
				$request = array (
						"hsvReservationInformationRequest" => array (
								"credentials" => array (
										"clientType" => $param ['clientType'],
										"clientKey" => $param ['clientKey'],
										"clientPassword" => $param ['clientPassword'],
										"customerKey" => $param ['customerKey'] 
								),
								"locale" => array (
										"iso3Country" => "DEU",
										"iso3Language" => "ENG",
										"isoCurrency" => "EUR" 
								),
								
								"timeoutMillis" => 6000,
								"ipAddress" => "1.1.1.1",
								"hotelKey" => $param ['hotelKey'],
								"reservationProcessKeys" => $reservationkey 
						) 
				);
				$result = $client->__soapCall ( "hsvReservationInformation", $request, $options, $header );
				// "modificationTimestamp"=>"2015-04-08T18:00:57.449+01:00",
			} catch ( SoapFault $e ) {
				echo "<pre>\n";
				echo "*** faultstring ***\n";
				print_r ( $e->faultstring );
				echo "*** detail ***\n";
				print_r ( $e->detail );
				echo "*** message ***\n";
				echo $e->detail->HRSException->message;
			}
			 echo "<pre>";
			 if ($global_debug_log) {
			     print_r ( $result );
			 }
			if (isset ( $result->reservationsProcesses )) {
			    if ($this->config->item('loger_v2') == 0) {
                    $log_update_id = $this->dcm_hrs->save_hrs_log($url, print_r($request, true), 0, 0);
                    echo $log_update_id . "+++++++++++++++";
                    $this->dcm_hrs->update_hrs_log(print_r($result, true), $log_update_id);
                } else {
                    $dc_id = 11;
                    $data_log = array();
                    $data_log["request"] = print_r($request, true);
                    $data_log["response"] = print_r($result, true);
                    $data_log["url"] = $url;
                    $data_log["dc_id"] = $dc_id;
                    $log_update_id = $this->loger_dc->SaveLog_v2($data_log);
                }
			}
			
			$send_notification = 0;
			if($this->input->post ( 'send_notification' ) == 1){
				$send_notification = 1;
			}
			// $this->dcm_hrs->bokking_xml_parse ( $result );
			$reservation_result = $this->dcm_hrs->reservation_xml_parse ( $result, "", $send_notification );
			$this->Loger_admin->Save_SyncData ( "", "", $reservation_result, 11, 10, $log_update_id );
		}
    }

    function rate_list()
    {
    	$data = array();
    	$this->load->library('parser');
    	$this->load->view('dc_hrs_c2_rate_list_view.php', $data);
    }
    
    function options()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('dc_hrs_c2_options_view.php', $data);
    }

    function options_post()
    {
        $post = $_POST;
        $this->dcm_hrs->options_save($post);
        die("<meta http-equiv='refresh' content='0;url=/dc_hrs_c2/options'>");
    }

    function get_room_categories($die_option = 0)
    {
        
        $param = $this->dcm_hrs->get_auth();
        $url = $param["url"];
        
        
        echo $url;
        
        $client = new SoapClient($url);
        $header = null;
        $options = null;
        $result = $this->dcm_hrs->soap_login($client);
		
		$sessionId = $result['sessionid'];
        
        $request = array(
            "hsvCategories",
            array(
                "hsvCategoriesRequest" => array(
                    "credentials" => array (
									"clientType" => $param ['clientType'],
									"clientKey" => $param ['clientKey'],
									"clientPassword" => $param ['clientPassword'],
									"customerKey" => $param ['customerKey'] 
							),
							"locale" => array (
									"iso3Country" => "DEU",
									"iso3Language" => "ENG",
									"isoCurrency" => "EUR" 
							),
                    "timeoutMillis" => 6000,
                    "session" => array(
                        "sessionId" => $sessionId
                    )
                )
            )
        );
        
        if ($this->config->item('loger_v2') == 0) {
            $log_update_id = $this->dcm_hrs->save_hrs_log($url, print_r($request, true), 0, 0);
        }
        echo "=================<br>categories======<br>";
        try {
            $result = $client->__soapCall("hsvCategories", array(
                "hsvCategoriesRequest" => array(
                   "credentials" => array (
									"clientType" => $param ['clientType'],
									"clientKey" => $param ['clientKey'],
									"clientPassword" => $param ['clientPassword'],
									"customerKey" => $param ['customerKey'] 
							),
                    "locale" => array(
                        "iso3Country" => "DEU",
                        "iso3Language" => "ENG",
                        "isoCurrency" => "EUR"
                    ),
                    "timeoutMillis" => 6000,
                    "session" => array(
                        "sessionId" => $sessionId
                    )
                )
            ), 
                // "categoryType" => "balcony"
                
                $options, $header);
        } catch (SoapFault $e) {
            echo "<pre>";
            print_r($e);
        }
        if ($this->config->item('loger_v2') == 0) {
            $this->dcm_hrs->update_hrs_log(print_r($result, true), $log_update_id);
        }else{
            $dc_id = 11;
            $data["request"] = print_r($request, true);
            $data["response"] = print_r($result, true);
            $data["url"] = $url;
            $data["dc_id"] = $dc_id;
            $log_update_id = $this->loger_dc->SaveLog_v2($data);
        }
        $this->Loger_admin->Save_SyncData ( "", "", print_r($result, true), 11, 13, $log_update_id );
        echo "<pre>";
        print_r($result);
        // die ();
        
        $this->dcm_hrs->soap_logout($client, $sessionId);
        
        $rooms = $result;
        $array_rooms = array();
        if (isset($rooms->categories)) {
            if (count($rooms->categories) > 1) {
                foreach ($rooms->categories as $room) {
                    $categoryAvailabilityType = "";
                    if (isset($room->categoryDetail->categoryAvailabilityType)) {
                        $categoryAvailabilityType = $room->categoryDetail->categoryAvailabilityType;
                    } else {
                        $categoryAvailabilityType = $room->extraBedCategoryDetail->categoryAvailabilityType;
                    }
                    array_push($array_rooms, array(
                        "room_id" => (string) $room->categoryType,
                        "categoryAvailabilityType" => $categoryAvailabilityType,
                        "room_name" => (string) $room->categoryType
                    ));
                }
            } else {
                $categoryAvailabilityType = "";
                if (isset($rooms->categories->categoryDetail->categoryAvailabilityType)) {
                    $categoryAvailabilityType = $rooms->categories->categoryDetail->categoryAvailabilityType;
                } else {
                    $categoryAvailabilityType = $rooms->categories->extraBedCategoryDetail->categoryAvailabilityType;
                }
                array_push($array_rooms, array(
                    "room_id" => (string) $rooms->categories->categoryType,
                    "categoryAvailabilityType" => $categoryAvailabilityType,
                    "room_name" => (string) $rooms->categories->categoryType
                ));
            }
        }
       // if (count($array_rooms) > 0) {
            $sql = "UPDATE dc_hrs_rooms_link SET active = 0 WHERE 1";
            $query = $this->db->query($sql);
            $sql = "UPDATE dc_hrs_occupancies SET active = 0 WHERE 1";
            $query = $this->db->query($sql);
       // }
        
        $occupancies = array();
        $occupancies_types = array();
        $query = $this->db->query("SELECT * FROM dc_hrs_constant_occupancies");
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $occupancies[$row->dc_category_id][$row->id]["beds"] = $row->beds;
                
                $occupancies_types[$row->dc_category_id]["type"] = $row->type;
            }
        }
        
        for ($i = 0; $i < count($array_rooms); $i ++) {
            $dc_room_id = $array_rooms[$i]["room_id"];
            $sql = "INSERT INTO dc_hrs_rooms_link(dc_room_name, dc_room_id, categoryAvailabilityType, type, active)
					VALUES('" . $array_rooms[$i]["room_name"] . "', '" . $array_rooms[$i]["room_id"] . "', '" . $array_rooms[$i]["categoryAvailabilityType"] . "', 
					'" . $occupancies_types[$array_rooms[$i]["room_id"]]["type"] . "', 1)
					ON DUPLICATE KEY UPDATE dc_room_name = '" . $array_rooms[$i]["room_name"] . "', categoryAvailabilityType = '" . $array_rooms[$i]["categoryAvailabilityType"] . "', 
					type = '" . $occupancies_types[$array_rooms[$i]["room_id"]]["type"] . "', active = 1";
            // echo $sql;
            $query = $this->db->query($sql);
            
            /*
             * insert occupancies
             */
            
            if (isset($occupancies[$dc_room_id])) {
                foreach ($occupancies[$dc_room_id] as $occupancy_id => $cell) {
                    $sql = "INSERT INTO dc_hrs_occupancies (occupancies_id, dc_room_id, capacity)
					values ($occupancy_id, '" . $dc_room_id . "', '" . $occupancies[$dc_room_id][$occupancy_id]["beds"] . "')
					on duplicate key update capacity = '" . $occupancies[$dc_room_id][$occupancy_id]["beds"] . "', active = 1";
                    // echo $sql;
                    $this->db->query($sql);
                }
            }
        }
        
        $sql = "SELECT * FROM dc_hrs_constant_occupancies WHERE type = 1";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $sql2 = "INSERT INTO dc_hrs_rooms_link(dc_room_name, dc_room_id, type, active)
					VALUES('" . $row->dc_category_id . "', '" . $row->dc_category_id . "', 1, 1)
					ON DUPLICATE KEY UPDATE dc_room_name = '" . $row->dc_category_id . "', type=1, active = 1";
                // echo $sql;
                $query2 = $this->db->query($sql2);
                
                $sql2 = "INSERT INTO dc_hrs_occupancies(occupancies_id, dc_room_id, capacity, active)
					VALUES('" . $row->id . "', '" . $row->dc_category_id . "', " . $row->beds . ", 1)
					ON DUPLICATE KEY UPDATE capacity = '" . $row->beds . "', active = 1";                
                // echo $sql;
                $query2 = $this->db->query($sql2);
            }
        }
        
        if ($die_option == 1) {
            $_SESSION["dc_msg"]["text"] = print_r($result, true);;
            // die();
            die("<meta http-equiv='refresh' content='0;url=/dc_hrs_c2/catgories_edit'>");
        }
    }

    function catgories_edit()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('dc_hrs_c2_catgories_edit_view.php', $data);
    }

    function categories_edit_post()
    {
        $categories_link = $this->input->post('categories', true);
        $data_1 = $this->Loger_admin->get_dccategories_multivalues("dc_hrs_rooms_link");
        // echo "<pre>";
        // print_r($categories_link);
        // die();
        $array_keys = array_keys($categories_link);
        foreach ($array_keys as $key) {
            
            $sql = "INSERT INTO dc_hrs_rooms_link (dc_room_id, category_id)
			values ('$key', $categories_link[$key])
			on duplicate key update category_id = $categories_link[$key]";
            // echo $sql;
            $this->db->query($sql);
        }
        
        $data_2 = $this->Loger_admin->get_dccategories_multivalues("dc_hrs_rooms_link");
        $this->Loger_admin->SaveLog_dc_multicol($data_1, $data_2, "loger_admin", "dc_hrs_rooms_link", "edit");
        
        die("<meta http-equiv='refresh' content='0;url=/dc_hrs_c2/catgories_edit'>");
    }

    function category_delete($dc_category_id)
    {
        $sql = "DELETE FROM dc_hrs_rooms_link WHERE dc_room_id LIKE '" . $dc_category_id . "'";
        $query = $this->db->query($sql);
        $sql = "DELETE FROM dc_hrs_occupancies WHERE dc_room_id LIKE '" . $dc_category_id . "'";
        $query = $this->db->query($sql);
        die("<meta http-equiv='refresh' content='0;url=/dc_hrs_c2/catgories_edit'>");
    }
    
    function rate_delete_all()  {    	
    	$sql = "DELETE FROM dc_hrs_occupancies";
    	$query = $this->db->query($sql);
    	die("<meta http-equiv='refresh' content='0;url=/dc_hrs_c2/rates_edit'>");
    }

    function rates_edit()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('dc_hrs_c2_rates_edit_view.php', $data);
    }

    function rates_edit_post()
    {
        $sql = "select id, beds from dc_hrs_constant_occupancies";
        $result = $this->db->query($sql);
        $capacity = array();
        foreach ($result->result() as $row) {
            $capacity[$row->id] = $row->beds;
        }
        // echo "<pre>";
        // print_r($capacity);
        // die();
        $rates_link = $this->input->post('rates_link', true);
        $rates_hms_occupancy = $this->input->post ( 'rates_hms_occupancy', true );
        //echo "<pre>";
        //print_r($rates_link);
       // print_r($rates_hms_occupancy);
        //die();
        foreach ($rates_link as $key => $cell) {
            list ($dc_room_id, $dc_rate_id, $dc_occupancy) = explode('-', $key);
            $hms_rate_id = $cell['hms_rate_id'];
            $sale_prc = $cell['sale_prc'];
            $restrict = $cell['restrict'];
            $breakfasttype = $cell['breakfasttype'];
            $HRSHSVReservationMode = $cell['HRSHSVReservationMode'];
            $reservationDeadlineDays = $cell['reservation_deadline_days'];
            $cancellationDeadlineDays = $cell['cancellation_deadline_days'];
            $prepayFeePercent = $cell['prepay_fee_percent_days'];
            if(isset($rates_hms_occupancy[$key])){
            	$hms_occupancy = $rates_hms_occupancy[$key];
            }else{
            	$hms_occupancy = 0;
            }
            $sql = "INSERT INTO dc_hrs_occupancies (occupancies_id, dc_rate_id, dc_room_id, hms_rate_id, restrict_id, capacity, sale_prc, 
            breakfasttype_id, HRSHSVReservationMode, reservationDeadlineDays, cancellationDeadlineDays, prepayFeePercent, hms_occupancy)
			values ($dc_occupancy, '" . $dc_rate_id . "', '" . $dc_room_id . "', $hms_rate_id, '" . $restrict . "', 
			" . $capacity[$dc_occupancy] . ", $sale_prc, $breakfasttype, $HRSHSVReservationMode, '".$reservationDeadlineDays."', 
			'".$cancellationDeadlineDays."', '".$prepayFeePercent."', '".$hms_occupancy."')
			on duplicate key update dc_rate_id = $dc_rate_id, hms_rate_id = $hms_rate_id, capacity= " . $capacity[$dc_occupancy] . ",  sale_prc = $sale_prc,  breakfasttype_id = $breakfasttype, 
			
            HRSHSVReservationMode = $HRSHSVReservationMode, reservationDeadlineDays =  '".$reservationDeadlineDays."', 
            cancellationDeadlineDays =  '".$cancellationDeadlineDays."', prepayFeePercent =  '".$prepayFeePercent."', 
            restrict_id = '" . $restrict . "', hms_occupancy = '".$hms_occupancy."'";
            //echo $sql."<br>"; 
            //die();
            $this->db->query($sql);
        }
        //die();
        die("<meta http-equiv='refresh' content='0;url=/dc_hrs_c2/rates_edit'>");
    }

    function add_rate()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('dc_hrs_c2_add_rate_view.php', $data);
    }

   

    function add_rate_post()
    {
        //echo "<pre>";
        //print_r($_POST);
        $week = array();
        $week['monday'] = '';
        $week['tuesday'] = '';
        $week['wednesday'] = '';
        $week['thursday'] = '';
        $week['friday'] = '';
        $week['saturday'] = '';
        $week['sunday'] = '';
        
        $weekend = array();
        $weekend['thursday'] = '';
        $weekend['friday'] = '';
        $weekend['saturday'] = '';
        $weekend['sunday'] = '';
        
        $url = "https://iut-soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
        $url = "https://soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
        
        $auth_result = $this->dcm_hrs->get_auth();
        $url = $auth_result["url"];
        
        $client = new SoapClient($url);
        
        $response = $this->dcm_hrs->soap_login($client);
        $sessionid = $response['sessionid'];
        
        $data = array();
        $data['from'] = $_POST['date_from'];
        $data['to'] = $_POST['date_to'];
        
        $data['removeOtherRates'] = $_POST['removeOtherRates'];
        $data['rateType'] = $_POST['rateType'];
        $data['rateGroup'] = $_POST['rateGroup'];
        
        $data['roomType'] = $_POST['roomType'];
        $data['freeSale'] = $_POST['freeSale'];
        $data['availableRooms'] = $_POST['availableRooms'];
        $data['price'] = $_POST['price'];
        
        $data['breakfastType'] = $_POST['breakfastType'];
        $data['exclusiveRate'] = $_POST['exclusiveRate'];
        
        $data['minimumStay'] = $_POST['minimumStay'];
        $data['reservationMode'] = $_POST['reservationMode'];
        $data['cancelable'] = $_POST['cancelable'];
        $data['cancellationDeadlineType'] = $_POST['cancellationDeadlineType'];
        
        switch ($_POST['rateType']) {
            case "hrs":
                $rateextension = array();
                $rateextension['key'] = 'hrsRateExtension';
                $rateextension['value'] = array(
                    "breakfastType" => $data['breakfastType'],
                    "exclusiveRate" => (boolean) $data['exclusiveRate']
                );
                break;
            case "special":
                $rateextension = array();
                $rateextension['key'] = 'specialRateExtension';
                $arrivalDays = array();
                $reservableDays = array();
                foreach ($week as $key => $value) {
                    if (isset($_POST['arrivalDays'][$key])) {
                        if ($_POST['arrivalDays'][$key] == "on") {
                            $arrivalDays[$key] = true;
                        } else {
                            $arrivalDays[$key] = false;
                        }
                    } else {
                        $arrivalDays[$key] = false;
                    }
                    
                    if (isset($_POST['reservableDays'][$key])) {
                        if ($_POST['reservableDays'][$key] == "on") {
                            $reservableDays[$key] = true;
                        } else {
                            $reservableDays[$key] = false;
                        }
                    } else {
                        $reservableDays[$key] = false;
                    }
                }
                $rateextension['value'] = array(
                    "breakfastType" => $data['breakfastType'],
                    "exclusiveRate" => (boolean) $data['exclusiveRate'],
                    "minimumStay" => $data['minimumStay'],
                    "arrivalDays" => $arrivalDays,
                    "reservableDays" => $reservableDays
                );
                break;
            case "tradeShow":
                $rateextension = array();
                $rateextension['key'] = 'tradeShowRateExtension';
                $arrivalDays = array();
                $reservableDays = array();
                foreach ($week as $key => $value) {
                    if (isset($_POST['arrivalDays'][$key])) {
                        if ($_POST['arrivalDays'][$key] == "on") {
                            $arrivalDays[$key] = true;
                        } else {
                            $arrivalDays[$key] = false;
                        }
                    } else {
                        $arrivalDays[$key] = false;
                    }
                    
                    if (isset($_POST['reservableDays'][$key])) {
                        if ($_POST['reservableDays'][$key] == "on") {
                            $reservableDays[$key] = true;
                        } else {
                            $reservableDays[$key] = false;
                        }
                    } else {
                        $reservableDays[$key] = false;
                    }
                }
                $rateextension['value'] = array(
                    "breakfastType" => $data['breakfastType'],
                    "exclusiveRate" => (boolean) $data['exclusiveRate'],
                    "minimumStay" => $data['minimumStay'],
                    "arrivalDays" => $arrivalDays,
                    "reservableDays" => $reservableDays,
                    "reservationMode" => $data['reservationMode'],
                    "cancelable" => $data['cancelable'],
                    "cancellationDeadlineType" => $data['cancellationDeadlineType']
                );
                break;
            case "weekend":
                $rateextension = array();
                $rateextension['key'] = 'weekendRateExtension';
                $arrivalDays = array();
                $reservableDays = array();
                foreach ($weekend as $key => $value) {
                    if (isset($_POST['arrivalDays'][$key])) {
                        if ($_POST['arrivalDays'][$key] == "on") {
                            $arrivalDays[$key] = true;
                        } else {
                            $arrivalDays[$key] = false;
                        }
                    } else {
                        $arrivalDays[$key] = false;
                    }
                    
                    if (isset($_POST['reservableDays'][$key])) {
                        if ($_POST['reservableDays'][$key] == "on") {
                            $reservableDays[$key] = true;
                        } else {
                            $reservableDays[$key] = false;
                        }
                    } else {
                        $reservableDays[$key] = false;
                    }
                }
                $rateextension['value'] = array(
                    "breakfastType" => $data['breakfastType'],
                    "exclusiveRate" => (boolean) $data['exclusiveRate'],
                    "minimumStay" => $data['minimumStay'],
                    "arrivalDays" => $arrivalDays,
                    "reservableDays" => $reservableDays,
                    "reservationMode" => $data['reservationMode'],
                    "cancelable" => $data['cancelable'],
                    "cancellationDeadlineType" => $data['cancellationDeadlineType']
                );
                break;
            case "season":
                $rateextension = array();
                $rateextension['key'] = 'seasonRateExtension';
                $arrivalDays = array();
                $reservableDays = array();
                foreach ($week as $key => $value) {
                    if (isset($_POST['arrivalDays'][$key])) {
                        if ($_POST['arrivalDays'][$key] == "on") {
                            $arrivalDays[$key] = true;
                        } else {
                            $arrivalDays[$key] = false;
                        }
                    } else {
                        $arrivalDays[$key] = false;
                    }
                    
                    if (isset($_POST['reservableDays'][$key])) {
                        if ($_POST['reservableDays'][$key] == "on") {
                            $reservableDays[$key] = true;
                        } else {
                            $reservableDays[$key] = false;
                        }
                    } else {
                        $reservableDays[$key] = false;
                    }
                }
                $rateextension['value'] = array(
                    "boardType" => $data['breakfastType'],
                    "exclusiveRate" => (boolean) $data['exclusiveRate'],
                    "minimumStay" => $data['minimumStay'],
                    "arrivalDays" => $arrivalDays,
                    "reservableDays" => $reservableDays,
                    "reservationMode" => $data['reservationMode'],
                    "cancelable" => $data['cancelable'],
                    "cancellationDeadlineType" => $data['cancellationDeadlineType']
                );
                break;
            case "hotDeal":
                $rateextension = array();
                $rateextension['key'] = 'hotDealRateExtension';
                $arrivalDays = array();
                $reservableDays = array();
                foreach ($week as $key => $value) {
                    if (isset($_POST['arrivalDays'][$key])) {
                        if ($_POST['arrivalDays'][$key] == "on") {
                            $arrivalDays[$key] = true;
                        } else {
                            $arrivalDays[$key] = false;
                        }
                    } else {
                        $arrivalDays[$key] = false;
                    }
                    
                    if (isset($_POST['reservableDays'][$key])) {
                        if ($_POST['reservableDays'][$key] == "on") {
                            $reservableDays[$key] = true;
                        } else {
                            $reservableDays[$key] = false;
                        }
                    } else {
                        $reservableDays[$key] = false;
                    }
                }
                $data['reservationDeadlineDays'] = $_POST['reservationDeadlineDays'];
                $data['prepayFeePercent'] = $_POST['prepayFeePercent'];
                $data['cancellationFeePercent'] = $_POST['cancellationFeePercent'];
                $data['cancellationDeadlineDays'] = $_POST['cancellationDeadlineDays'];
                $rateextension['value'] = array(
                    "boardType" => $data['breakfastType'],
                    "minimumStay" => $data['minimumStay'],
                    "arrivalDays" => $arrivalDays,
                    "reservableDays" => $reservableDays,
                    "reservationMode" => $data['reservationMode'],
                    "reservationDeadlineDays" => $data['reservationDeadlineDays'],
                    "prepayFeePercent" => $data['prepayFeePercent'],
                    "cancelable" => $data['cancelable'],
                    "cancellationDeadlineDays" => $data['cancellationDeadlineDays'],
                    "cancellationFeePercent" => $data['cancellationFeePercent']
                );
                break;
            default:
                ;
                break;
        }
        
        $this->dcm_hrs->soap_hsvRateSave($client, $sessionid, $data, $rateextension);
        
        $this->dcm_hrs->soap_logout($client, $sessionid);
    }

    function sync()
    {
        $rate_data = $this->dcm_hrs->sync();
        echo "<pre>";
        print_r($rate_data);
        
        $url = "https://iut-soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
        $url = "https://soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
        $param = $this->dcm_hrs->get_auth();
        $url = $param["url"];
        
        $client = new SoapClient($url);
        $header = null;
        $options = null;
        $result = $this->dcm_hrs->soap_login($client);
		
		$sessionId = $result['sessionid'];
        
        foreach ($rate_data as $dc_category => $occupancies) {
            // echo "<pre>";
            // print_r($occupancies);
            // die();
            foreach ($occupancies as $occupancies_id => $intdates) {
                foreach ($intdates as $intdate => $cell) {
                    switch ($cell["beds"]) {
                        case 1:
                            $room_type = "single";
                            $surcharge_type = "surchargeSingleRoom";
                            break;
                        case 2:
                            $room_type = "double";
                            $surcharge_type = "surchargeDoubleRoom";
                            break;
                    }
                    echo "=================hsvCategoryAvailabilitySave 22 ===============<br>";
                    try {
                        $result = $client->__soapCall("hsvCategoryAvailabilitySave", array(
                            "hsvCategoryAvailabilitySaveRequest" => array(
                                 "credentials" => array(
                "clientType" => $param['clientType'],
                "clientKey" => $param['clientKey'],
                "clientPassword" => $param['clientPassword'],
                "customerKey" => $param['customerKey']
            ),
                                "locale" => array(
                                    "iso3Country" => "DEU",
                                    "iso3Language" => "ENG",
                                    "isoCurrency" => "EUR"
                                ),
                                "timeoutMillis" => 6000,
                                "session" => array(
                                    "sessionId" => $sessionId
                                ),
                                "from" => $cell["datein"],
                                "to" => $cell["dateout"],
                                "categoryAvailability" => array(
                                    "categoryType" => $dc_category,
                                    "categoryRoom" => array(
                                        "roomType" => $room_type,
                                        "freeSale" => false,
                                        "availableRooms" => $cell["free"]
                                    ),
                                    "categoryPriceDetail" => array(
                                        $surcharge_type => $cell["price"]
                                    )
                                )
                            )
                        ), $options, $header);
                    } catch (SoapFault $e) {
                        echo "<pre>";
                        print_r($e);
                    }
                    
                    echo "**********************************************<br>";
                    print_r($result);
                }
            }
        }
    }

    function sync2()
    {
        $rate_data = $this->dcm_hrs->sync2();
        echo "<pre>";
        print_r($rate_data);
        // die();
        $url = "https://iut-soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
        $url = "https://soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
       	$param = $this->dcm_hrs->get_auth();
        $url = $param["url"];
        
        $client = new SoapClient($url);
        $header = null;
        $options = null;
        $result = $this->dcm_hrs->soap_login($client);
		
		$sessionId = $result['sessionid'];
        
        foreach ($rate_data as $dc_category => $occupancies) {
            $hrs_room_type = $occupancies["hrs_room_type"];
            foreach ($occupancies["occupancies"] as $occupancies_id => $intdates) {
                foreach ($intdates as $intdate => $cell) {
                    switch ($cell["beds"]) {
                        case 1:
                            $room_type = "single";
                            $surcharge_type = "surchargeSingleRoom";
                            break;
                        case 2:
                            $room_type = "double";
                            $surcharge_type = "surchargeDoubleRoom";
                            break;
                    }
                    echo "=================hsvCategoryAvailabilitySave 22 ===============<br>";
                    switch ($hrs_room_type) {
                        case 1:
                            echo "+<br>";
                            try {
                                $result = $client->__soapCall("hsvRateSave", array(
                                    "hsvRateSaveRequest" => array(
                                        "credentials" => array(
                "clientType" => $param['clientType'],
                "clientKey" => $param['clientKey'],
                "clientPassword" => $param['clientPassword'],
                "customerKey" => $param['customerKey']
            ),
                                        "locale" => array(
                                            "iso3Country" => "DEU",
                                            "iso3Language" => "ENG",
                                            "isoCurrency" => "EUR"
                                        ),
                                        "timeoutMillis" => 6000,
                                        "session" => array(
                                            "sessionId" => $sessionId
                                        ),
                                        "from" => $cell["datein"],
                                        "to" => $cell["dateout"],
                                        "removeOtherRates" => false,
                                        "rate" => array(
                                            "rateType" => "hrs",
                                            "rateGroup" => 1,
                                            "room" => array(
                                                "roomType" => $room_type,
                                                "price" => $cell["price"],
                                                "freeSale" => false,
                                                "availableRooms" => $cell["free"]
                                            ),
                                            "hrsRateExtension" => array(
                                                "breakfastType" => "exclusive",
                                                "exclusiveRate" => false
                                            )
                                        )
                                    )
                                ), $options, $header);
                            } catch (SoapFault $e) {
                                echo "<pre>";
                                print_r($e);
                            }
                            break;
                        case 2:
                            echo "99<br>";
                            try {
                                $result = $client->__soapCall("hsvCategoryAvailabilitySave", array(
                                    "hsvCategoryAvailabilitySaveRequest" => array(
                                         "credentials" => array(
                "clientType" => $param['clientType'],
                "clientKey" => $param['clientKey'],
                "clientPassword" => $param['clientPassword'],
                "customerKey" => $param['customerKey']
            ),
                                        "locale" => array(
                                            "iso3Country" => "DEU",
                                            "iso3Language" => "ENG",
                                            "isoCurrency" => "EUR"
                                        ),
                                        "timeoutMillis" => 6000,
                                        "session" => array(
                                            "sessionId" => $sessionId
                                        ),
                                        "from" => $cell["datein"],
                                        "to" => $cell["dateout"],
                                        "categoryAvailability" => array(
                                            "categoryType" => $dc_category,
                                            "categoryRoom" => array(
                                                "roomType" => $room_type,
                                                "freeSale" => false,
                                                "availableRooms" => $cell["free"]
                                            ),
                                            "categoryPriceDetail" => array(
                                                $surcharge_type => $cell["price"]
                                            )
                                        )
                                    )
                                ), $options, $header);
                            } catch (SoapFault $e) {
                                echo "<pre>";
                                print_r($e);
                            }
                            break;
                        default:
                            echo "-<br>";
                            try {
                                $result = $client->__soapCall("hsvCategoryAvailabilitySave", array(
                                    "hsvCategoryAvailabilitySaveRequest" => array(
                                        "credentials" => array(
                "clientType" => $param['clientType'],
                "clientKey" => $param['clientKey'],
                "clientPassword" => $param['clientPassword'],
                "customerKey" => $param['customerKey']
            ),
                                        "locale" => array(
                                            "iso3Country" => "DEU",
                                            "iso3Language" => "ENG",
                                            "isoCurrency" => "EUR"
                                        ),
                                        "timeoutMillis" => 6000,
                                        "session" => array(
                                            "sessionId" => $sessionId
                                        ),
                                        "from" => $cell["datein"],
                                        "to" => $cell["dateout"],
                                        "categoryAvailability" => array(
                                            "categoryType" => $dc_category,
                                            "categoryRoom" => array(
                                                "roomType" => $room_type,
                                                "freeSale" => false,
                                                "availableRooms" => $cell["free"]
                                            ),
                                            "categoryPriceDetail" => array(
                                                $surcharge_type => $cell["price"]
                                            )
                                        )
                                    )
                                ), $options, $header);
                            } catch (SoapFault $e) {
                                echo "<pre>";
                                print_r($e);
                            }
                            break;
                    }
                    
                    echo "**********************************************<br>";
                    print_r($result);
                }
            }
        }
    }

    function sync2_new($upload_type)
    {
        $result = $this->dc_model->set_rate_lastchanged_11($upload_type);
    }

    function hrs_sync_log()
    {
        $rate_data = $this->dcm_hrs->hrs_sync_log();
        echo "<pre>";
        print_r($rate_data);
        
        $url = "https://iut-soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
      	$param = $this->dcm_hrs->get_auth();
        $url = $param["url"];
        
        $client = new SoapClient($url);
        $header = null;
        $options = null;
        $result = $this->dcm_hrs->soap_login($client);
		
		$sessionId = $result['sessionid'];
        
        foreach ($rate_data as $dc_category => $occupancies) {
            // echo "<pre>";
            // print_r($occupancies);
            // die();
            foreach ($occupancies as $occupancies_id => $intdates) {
                foreach ($intdates as $intdate => $cell) {
                    switch ($cell["beds"]) {
                        case 1:
                            $room_type = "single";
                            $surcharge_type = "surchargeSingleRoom";
                            break;
                        case 2:
                            $room_type = "double";
                            $surcharge_type = "surchargeDoubleRoom";
                            break;
                    }
                    echo "=================hsvCategoryAvailabilitySave 22 ===============<br>";
                    try {
                        $result = $client->__soapCall("hsvCategoryAvailabilitySave", array(
                            "hsvCategoryAvailabilitySaveRequest" => array(
                               "credentials" => array(
                "clientType" => $param['clientType'],
                "clientKey" => $param['clientKey'],
                "clientPassword" => $param['clientPassword'],
                "customerKey" => $param['customerKey']
            ),
                                "locale" => array(
                                    "iso3Country" => "DEU",
                                    "iso3Language" => "ENG",
                                    "isoCurrency" => "EUR"
                                ),
                                "timeoutMillis" => 6000,
                                "session" => array(
                                    "sessionId" => $sessionId
                                ),
                                "from" => $cell["datein"],
                                "to" => $cell["dateout"],
                                "categoryAvailability" => array(
                                    "categoryType" => $dc_category,
                                    "categoryRoom" => array(
                                        "roomType" => $room_type,
                                        "freeSale" => false,
                                        "availableRooms" => $cell["free"]
                                    ),
                                    "categoryPriceDetail" => array(
                                        $surcharge_type => $cell["price"]
                                    )
                                )
                            )
                        ), $options, $header);
                    } catch (SoapFault $e) {
                        echo "<pre>";
                        print_r($e);
                    }
                    
                    echo "**********************************************<br>";
                    print_r($result);
                }
            }
        }
    }

    function upload_rooms()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('dc_hrs_upload_rooms_view.php', $data);
    }

    function upload_rooms_post()
    {
        $days_cell = $this->input->post("days_cell");
        
        $datein = date("Y-m-d");
        $dateout = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d") + $days_cell, date("Y")));
        // $datein = date ( "2013-12-01" );
        // $dateout = date ( "2014-01-01" );
        $rooms = $this->dcm_hrs->get_availability_data($datein, $dateout);
        
        // echo "<pre>";
        // print_r ( $restrict );
        // print_r ( $rooms );
        // die();
        $response = $this->dc_ostrovok_model->update_rooms($rooms, $restrict);
        
        if (isset($response['error'])) {
            $this->dc_model->dc_save_error(2, $response['origin']);
        }
        echo "<pre>";
        print_r($response);
    }

    function getReservations()
    {
        $url = "https://iut-soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
        $url = "https://soap-hotelservice.hrs.com:8443/hsv3/011/HSVService?wsdl";
        
        $param = $this->dcm_hrs->get_auth();
        $url = $param["url"];
        
        $client = new SoapClient($url);
        $header = null;
        $options = null;
        
        $sql = "select str_value from dc_hrs_xml_cfg where name ='sync_time'";
        
        $result = $this->db->query($sql);
        if ($result->num_rows() == 1) {
            $row = $result->row();
            $time = $row->str_value;
        } else {
            $time = gmdate("Y-m-d\TH:i:s", mktime() - 24 * 60 * 60 * 1);
        }
        $time_now = gmdate("Y-m-d\TH:i:s", mktime() + 2 * 60 * 60);
        $this->db->query("insert into dc_hrs_xml_cfg (name, str_value) values ('sync_time', '$time_now')
		    on duplicate key update str_value='$time_now'");
        echo "<pre>\n" . $time;
        echo "<pre>\n" . $time_now;
        //$time = "2015-04-23T12:00:14.800+02:00";
        // die();
        echo "=================HSVReservationInformation<br>";
        try {
            $result = $client->__soapCall("hsvReservationInformation", array(
                "hsvReservationInformationRequest" => array(
                   "credentials" => array(
                "clientType" => $param['clientType'],
                "clientKey" => $param['clientKey'],
                "clientPassword" => $param['clientPassword'],
                "customerKey" => $param['customerKey']
            ),
                    "locale" => array(
                        "iso3Country" => "DEU",
                        "iso3Language" => "ENG",
                        "isoCurrency" => "EUR"
                    ),
                    
                    "timeoutMillis" => 6000,
                    "ipAddress" => "1.1.1.1",                    
                    "hotelKey" => $param['hotelKey'],
                    "modificationTimestamp" => $time
                )
            ), $options, $header);
            // "modificationTimestamp"=>"2015-04-08T18:00:57.449+01:00",
        } catch (SoapFault $e) {
            echo "<pre>";
            print_r($e);
        }
        // echo "<pre>";
        // print_r ( $result );
        
        // $this->dcm_hrs->bokking_xml_parse ( $result );
        $this->dcm_hrs->reservation_xml_parse($result);
    }
	function rate_delete() {
		if (isset ( $_POST ['selected_rate'] )) {
			
			foreach ( array_keys ( $_POST ['selected_rate'] ) as $id ) {
				$this->dcm_hrs->deleteRate ( $id );
			}
		}
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hrs_c2/rate_list'>" );
	}
	function rate_insert() {
		$room_record = new cClearHrsRate ();
		$data = array (
				'room_record' => $room_record
		);
		$this->load->view ( 'dc_hrs_c2_edit_rate_view', $data );
	}
	function edit_rate($id) {
		
		$result = $this->dcm_hrs->getRate ( $id );
		$data = array (
				'room_record' => $result
		);
		$this->load->view ( 'dc_hrs_c2_edit_rate_view', $data );
	}
	function rate_update() {
		//echo "<pre>";
		//print_r($_POST);
		
		$data = array (
				'dc_rate_id' => $_POST ['dc_rate_id'],
				'dc_rate_name' => $_POST ['dc_rate_name'],
				'group' => $_POST ['group'],
		        'cancelable' => $_POST ['cancelable'],
		        'cancellationDeadlineType' => $_POST ['cancellationDeadlineType'],
				'HRSHSVReservationMode' => $_POST ['HRSHSVReservationMode']
		);
		if ($_POST ['dc_rate_id'] != - 1) {
			$this->dcm_hrs->updateRate ( $data, $_POST ['dc_rate_id'] );
		} else {
			$query = $this->db->query( "SELECT max(dc_rate_id) as max_dc_rate_id FROM dc_hrs_rate_link");
			
			if ($query->num_rows() > 0)
			{
				$row = $query->row();
				$max_dc_rate_id = $row->max_dc_rate_id;
				
			}
			$data["dc_rate_id"] = $max_dc_rate_id + 1;
			$this->dcm_hrs->insertRate ( $data );
		}
		// print_r($_POST);
		die ( "<meta http-equiv='refresh' content='0;url=/dc_hrs_c2/rate_list'>" );
	}
}
?>