<?php
function objectToArray($object) {
	if (! is_object ( $object ) && ! is_array ( $object )) {
		return $object;
	}
	if (is_object ( $object )) {
		$object = get_object_vars ( $object );
	}
	return array_map ( 'objectToArray', $object );
}
class dc_hostelworld_gate extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'dcm_hostelworld' );
		$this->load->model ( 'dc_model' );
		$this->load->model ( 'Curl_model' );
	}
	function hw_get_bookings($db_name = "") {
		if ($db_name == "error") {
			echo "error";
			return;
		}
		if ($db_name == "unknown") {
			echo "unknown";
			return;
		}
		if ($db_name != "") {
			$config = array ();
			$config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config ['database'] = $db_name;
			$config ['dbdriver'] = "mysql";
			$config ['dbprefix'] = "";
			$config ['pconnect'] = FALSE;
			$config ['db_debug'] = TRUE;
			$config ['cache_on'] = FALSE;
			$config ['cachedir'] = "";
			$config ['char_set'] = "utf8";
			$config ['dbcollat'] = "utf8_general_ci";
			
			$this->db = $this->load->database ( $config, true );
		}
		$host = "";
		$query = $this->db->query ( "SELECT host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'" );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			
			$host = $row->host;
		}
		$data = array ();
		
		/*
		 * get authparam
		 */
		
		$authparam = $this->dcm_hostelworld->getauthparam ();
		
		$consumer_key = $authparam ["consumer_key"];
		$secret = $authparam ["secret"];
		$propN = $authparam ["hotel_id"];
		$prop_user = 'manager';
		$prop_pass = $authparam ["prop_pass"];
		
		$consumer_signature = sha1 ( $consumer_key . "--" . $secret . "--" . $prop_pass );
		$data ['consumer_key'] = $consumer_key;
		$data ['consumer_signature'] = $consumer_signature;
		$docheckcount = false;
		if ($docheckcount) {
			$txt = '<request></request>';
			$url = "https://property.xsapi.webresint.com/1.2/getnewbookingscount/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
			// echo $url;
			$result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 8 );
			
			// $result =
			// '{"api":{"status":"Success","callsremaining":1,"version":"1.2.22.7"},"result":{"properties":{"85991":{"cancellations":"0","bookings":"4"}},"requirecall":1,"count":1}}';
			
			// echo $result;
			
			$array = json_decode ( $result );
			$array = objectToArray ( $array );
			
			echo "<pre>";
			print_r ( $array );
			
			$totalcount = 0;
			if (isset ( $array ["result"] ["properties"] [$propN] ["bookings"] )) {
				$totalcount += $array ["result"] ["properties"] [$propN] ["bookings"];
			}
			if (isset ( $array ["result"] ["properties"] [$propN] ["bookings"] )) {
				$totalcount += $array ["result"] ["properties"] [$propN] ["cancellations"];
			}
			
			if ($totalcount > 0) {
				// echo $result;
			} else {
				echo "nothing";
				return;
			}
		}
		$url = "https://property.xsapi.webresint.com/1.2/getnewbookings/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
		$txt = '<request></request>';
		$result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 8 );
		echo $url;
		// print_r ( $result );
		// die ();
		
		$array = json_decode ( $result );
		$array = objectToArray ( $array );
		
		echo "<pre>";
		print_r ( $array );
		
		$result_arr = $this->dcm_hostelworld->get_bookings ( $array, $host );
		
		print_r ( $result_arr );
		
		$totalack = 0;
		$bookings_ack_block = "";
		$bookings_ack_cancel_block = "";
		
		if (isset ( $result_arr ["ack_bookings"] ["bookings"] )) {
			if (sizeof ( $result_arr ["ack_bookings"] ["bookings"] ) > 0) {
				$data = array ();
				$data ['ack_booking'] = $result_arr ["ack_bookings"] ["bookings"];
				$txt = $this->parser->parse ( 'templates/xml/dc_hostelsworld_ack.xml', $data, true );
				$bookings_ack_block = $txt;
				$totalack ++;
			}
		}
		if (isset ( $result_arr ["ack_bookings"] ["cancellations"] )) {
			if (sizeof ( $result_arr ["ack_bookings"] ["cancellations"] ) > 0) {
				$data = array ();
				$data ['ack_booking'] = $result_arr ["ack_bookings"] ["cancellations"];
				$txt = $this->parser->parse ( 'templates/xml/dc_hostelsworld_ack_cancel.xml', $data, true );
				$bookings_ack_cancel_block = $txt;
				$totalack ++;
			}
		}
		
		if ($totalack > 0) {
			$url = "https://property.xsapi.webresint.com/1.2/ackbookings/" . $propN . ".json?consumer_key=" . $consumer_key . "&consumer_signature=" . $consumer_signature;
			$data = array ();
			$data ['bookings'] = $bookings_ack_block;
			$data ['cancellations'] = $bookings_ack_cancel_block;
			$txt = $this->parser->parse ( 'templates/xml/dc_hostelsworld_ack_all.xml', $data, true );
			$result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 8 );
			
			print_r ( $result );
			$array = json_decode ( $result );
			$array = objectToArray ( $array );
			
			print_r ( $array );
		}
		
		$data = array (
				"result" => $result_arr ["view_data"] 
		);
	}
}
}
?>