<?php
class Dc_helper extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		
		if ($this->input->ip_address () == "77.120.43.118" || $this->input->ip_address () == "194.44.237.222") {
			// echo $this->input->ip_address();
			// $this->output->enable_profiler(TRUE);
		}
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'dcm_101otel' );
	}
	function set_calendar($db_name, $xdays) {
		if ($db_name != "") {
			$config = array ();
			$config ['hostname'] = $this->config->item ( 'visitka_host' );
			$config ['username'] = $this->config->item ( 'visitka_user' );
			$config ['password'] = $this->config->item ( 'visitka_pass' );
			$config ['database'] = $db_name;
			$config ['dbdriver'] = "mysqli";
			$config ['dbprefix'] = "";
			$config ['pconnect'] = FALSE;
			$config ['db_debug'] = TRUE;
			$config ['cache_on'] = FALSE;
			$config ['cachedir'] = "";
			$config ['char_set'] = "utf8";
			$config ['dbcollat'] = "utf8_general_ci";
			$this->db = $this->load->database ( $config, true );
			
			$dc_log_data = array ();
			$dc_log_data ["datein"] = date ( "Y-m-d" );
			$dc_log_data ["dateout"] = date ( "Y-m-d", mktime ( 0, 0, 0, date ( "m" ), date ( "d" ) + $xdays, date ( "Y" ) ) );
			$dc_log_data ["category_id"] = 0;
			$this->frontdesk->dc_log_update ( $dc_log_data );
		}
	}
	function dc_101otel_get_calendar($xdays) {
		$url = "https://101hotels.info/api2/";
		// $arr ['format'] = "json";
		$arr = $this->dcm_101otel->getauthparam ();
		$arr ['service'] = "get_calendar";
		$arr ['data'] ["start"] = date ( "Y-m-d" );
		$arr ['data'] ["end"] = date ( "Y-m-d", mktime ( 0, 0, 0, date ( "m" ), date ( "d" ) + $xdays, date ( "Y" ) ) );
		;
		
		$data ['request'] = json_encode ( $arr );
		// echo $data ['request'];
		$txt = "request=" . $data ['request'];
		
		$data_result = $this->Curl_model->CurlPlugRAW ( $txt, $url, 9, array (
				"returntype" => "array" 
		) );
		$result = json_decode ( $data_result ["result"], true );
		//echo "<pre>";
		//print_r ( $result );
		//die ();
		return $result;
	}
	function dc_101otel_compare_avalibility($db_name, $xdays) {
		$config = array ();
		$config ['hostname'] = $this->config->item ( 'visitka_host' );
		$config ['username'] = $this->config->item ( 'visitka_user' );
		$config ['password'] = $this->config->item ( 'visitka_pass' );
		$config ['database'] = $db_name;
		$config ['dbdriver'] = "mysqli";
		$config ['dbprefix'] = "";
		$config ['pconnect'] = FALSE;
		$config ['db_debug'] = TRUE;
		$config ['cache_on'] = FALSE;
		$config ['cachedir'] = "";
		$config ['char_set'] = "utf8";
		$config ['dbcollat'] = "utf8_general_ci";
		
		$this->db = $this->load->database ( $config, true );
		/*
		 * GET 101otel DATA
		 */
		$data_101otel = $this->dc_101otel_get_calendar ( $xdays );
		//print_r($data_101otel);
		/*
		 * Get otelms DATA
		 */
		
		$now_date = date ( "Y-m-d" );
		list ( $year, $month, $day ) = explode ( "-", $now_date );
		$now_date = date ( "Y-m-d", gmmktime ( 0, 0, 0, $month, $day + $xdays, $year ) );
		
		
		list ( $year, $month, $day ) = explode ( "-", $now_date );
		$intdate_now = ceil ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		$endintdate = ceil ( gmmktime ( 0, 0, 0, $month, $day + 31, $year ) / 86400 );
		
		$query = $this->db->query ( "SELECT value FROM `" . $db_name . "`.hotelix_config WHERE name LIKE 'overbooking_category_id'" );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$overbookcatid = $row->value;
		}
		$overbooking_reservations_array = array ();
		$sql = "SELECT deskofreservation.origin_categoryid,  deskofdays.intdate, count(1) as obc  FROM `" . $db_name . "`.deskofdays
INNER JOIN `" . $db_name . "`.deskofreservation ON deskofreservation.id=deskofdays.reservation_id
INNER JOIN `" . $db_name . "`.rooms ON rooms.id=deskofdays.room_id
INNER JOIN `" . $db_name . "`.guests ON guests.id=deskofreservation.guest_id
WHERE origin_categoryid <> 0  AND intdate >=" . $intdate_now . " AND intdate <" . $endintdate . "
		AND rooms.category_id = $overbookcatid AND deskofreservation.cancel <> 1 AND deskofreservation.deleted <> 1 group by origin_categoryid, deskofdays.intdate";
		// echo $sql . "<br>";
		// die();
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			$overbooking_reservations_array [$row->origin_categoryid] [$row->intdate] = $row->obc;
		}
		
		$free_rooms_arr = $this->frontdesk->GetFreeRooms ( date ( "Y-m-d", $intdate_now * 86400 ), date ( "Y-m-d", $endintdate * 86400 ), $db_name );
		$free_rooms_arr_keys = array_keys ( $free_rooms_arr );
		
		$otelms_rooms = array ();
		foreach ( $free_rooms_arr_keys as $category_id ) {
			for($i = 0; $i < 31; $i ++) {
				if (isset ( $overbooking_reservations_array [$category_id] [$intdate_now + $i] )) {
					$sum_rooms = $free_rooms_arr [$category_id] [$intdate_now + $i] - ($overbooking_reservations_array [$category_id] [$intdate_now + $i]);
				} else {
					$sum_rooms = $free_rooms_arr [$category_id] [$intdate_now + $i];
				}
				$otelms_rooms [$category_id] [$intdate_now + $i] ["rooms_to_sell"] = $sum_rooms;
			}
		}
		
		// print_r ( $otelms_rooms );
		
		$categories_dc = array ();
		$query = $this->db->query ( "SELECT dc_101otel_room_categories_link.hms_category_id, dc_101otel_room_categories_link.dc_category_id, categories.name 
		FROM `" . $db_name . "`.dc_101otel_room_categories_link
		INNER JOIN `" . $db_name . "`.categories ON categories.id = dc_101otel_room_categories_link.hms_category_id " );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$categories_dc [$row->dc_category_id] ["id"] = $row->hms_category_id;
				$categories_dc [$row->dc_category_id] ["name"] = $row->name;
				$categories_dc [$row->dc_category_id] ["dc_room_id"] = $row->dc_category_id;
			}
		}
		$msg = "";
		$count = 0;
		if (isset ( $data_101otel ["data"] )) {
			foreach ( $data_101otel ["data"] as $cell ) {
				list ( $year, $month, $day ) = explode ( "-", $cell ["day"] );
				$intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
				echo $intdatein;
				foreach ( $cell ["quota"] as $ds_category_id => $value ) {
					if (isset ( $categories_dc [$ds_category_id] )) {
						$msg .= "<p>" . $categories_dc [$ds_category_id] ["dc_room_id"] . "[" . $categories_dc [$ds_category_id] ["id"] . "] <br> ";
						
						$booking_rooms_to_sell = $value;
						if (isset ( $otelms_rooms [$categories_dc [$ds_category_id] ["id"]] [$intdatein] ["rooms_to_sell"] )) {
							$otelms_rooms_to_sell = $otelms_rooms [$categories_dc [$ds_category_id] ["id"]] [$intdatein] ["rooms_to_sell"];
						} else {
							$otelms_rooms_to_sell = 0;
						}
						if ($otelms_rooms_to_sell < 0)
							$otelms_rooms_to_sell = 0;
						$diff = $booking_rooms_to_sell - $otelms_rooms_to_sell;
						$diff;
						echo $diff;
						if ($diff > 0) {
							//$dc_log_data = array ();
							//$dc_log_data ["datein"] = $date ["value"];
							//$dc_log_data ["dateout"] = date ( "Y-m-d", ($intdatein + 1) * 86400 );
							//$dc_log_data ["category_id"] = $categories_dc [$ds_category_id] ["id"];
							//$this->frontdesk->dc_log_update ( $dc_log_data );
							$msg .= "Категория:" . $categories_dc [$ds_category_id] ["name"] . " datein: " . $cell ["day"] . " booking " . $booking_rooms_to_sell . " otelms " . $otelms_rooms_to_sell . "<br>";
						}
						//$msg .= $cell ["day"] . " , " . $diff;
						if ($diff > 0) {
							$count ++;
							//$msg .= " !!!<br>";
						} else {
							//$msg .= "<br>";
						}
					}
				}
			}
			 echo $msg;
		}
	}
}
?>