<?php
/* @property phpword_model $phpword_model */
include_once(APPPATH."third_party/Common/Autoloader.php");
include_once(APPPATH."third_party/PhpWord/Autoloader.php");

use PhpOffice\Common\Autoloader as Common;
use PhpOffice\PhpWord\Autoloader;
use PhpOffice\PhpWord\Settings;
Common::register();
Autoloader::register();
Settings::loadConfig();

require_once APPPATH . 'libraries/Zend/Loader/ClassMapAutoloader.php';
$loader = new Zend\Loader\ClassMapAutoloader();
$loader->registerAutoloadMap(APPPATH . 'libraries/Zend_autoload_classmap.php');
$loader->register();


class Phpword extends CI_Controller {

	function __construct(){
	  parent::__construct();


    }


	function index()
	{
		$filename='helloWorld.docx';

		// Creating the new document...
		$phpWord = new \PhpOffice\PhpWord\PhpWord();

		/* Note: any element you append to a document must reside inside of a Section. */

		// Adding an empty Section to the document...
		$section = $phpWord->addSection();
		// Adding Text element to the Section having font styled by default...
		$section->addText(
			'"Learn from yesterday, live for today, hope for tomorrow. '
				. 'The important thing is not to stop questioning." '
				. '(Albert Einstein)'
		);

		$section->addText(
			'some text ${somevar} '
		);

		/*
		 * Note: it's possible to customize font style of the Text element you add in three ways:
		 * - inline;
		 * - using named font style (new font style object will be implicitly created);
		 * - using explicitly created font style object.
		 */

		// Adding Text element with font customized inline...
		$section->addText(
			'"Great achievement is usually born of great sacrifice, '
				. 'and is never the result of selfishness." '
				. '(Napoleon Hill)',
			array('name' => 'Tahoma', 'size' => 10)
		);

		// Adding Text element with font customized using named font style...
		$fontStyleName = 'oneUserDefinedStyle';
		$phpWord->addFontStyle(
			$fontStyleName,
			array('name' => 'Tahoma', 'size' => 10, 'color' => '1B2232', 'bold' => true)
		);
		$section->addText(
			'"The greatest accomplishment is not in never falling, '
				. 'but in rising again after you fall." '
				. '(Vince Lombardi)',
			$fontStyleName
		);

		//$section->addImage($targetFile.$n['ne_img'], array('align' => 'center','width'=>200, 'height'=>200));


		// Adding Text element with font customized using explicitly created font style object...
		$fontStyle = new \PhpOffice\PhpWord\Style\Font();
		$fontStyle->setBold(true);
		$fontStyle->setName('Tahoma');
		$fontStyle->setSize(13);
		$myTextElement = $section->addText('"Believe you can and you\'re halfway there." (Theodor Roosevelt)');
		$myTextElement->setFontStyle($fontStyle);




		// Saving the document as OOXML file...
		$objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');

		$objWriter->save($filename);
		// send results to browser to download
				header('Content-Description: File Transfer');
				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename='.$filename);
				header('Content-Transfer-Encoding: binary');
				header('Expires: 0');
				header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
				header('Pragma: public');
				header('Content-Length: ' . filesize($filename));
				flush();
				readfile($filename);
				//unlink($filename); // deletes the temporary file
				exit;

	}

	function read(){

		$source='helloWorld.docx';
		echo date('H:i:s'), " Reading contents from `{$source}`", EOL;
		$phpWord = \PhpOffice\PhpWord\IOFactory::load($source);

		$filename2='helloWorld2.docx';
		$phpWord2 = new \PhpOffice\PhpWord\PhpWord();

		$sections = $phpWord->getSections();

/*	foreach($sections as $s){
			foreach($s->getElements() as $e){
				if($e instanceof PhpOffice\PhpWord\Element\Text)
				var_dump($e->getText());
			}
		}
*/
	/*			$section->addText(
			'"111111111111111111111111111111111111111',
			$fontStyleName
		);*/

		$comment = new \PhpOffice\PhpWord\Element\Comment('Authors name', new \DateTime(), 'my_initials');
$comment->addText('Test', array('bold' => true));
$phpWord->addComment($comment);

		$filename2='helloWorld2.docx';
		$objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
		$objWriter->save($filename2);





				// send results to browser to download
				header('Content-Description: File Transfer');
				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename='.$filename2);
				header('Content-Transfer-Encoding: binary');
				header('Expires: 0');
				header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
				header('Pragma: public');
				header('Content-Length: ' . filesize($filename2));
				flush();
				readfile($filename2);
				//unlink($filename); // deletes the temporary file
				exit;
	}

	function template(){
		$templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor('template1.docx');

		//в шаблоні пишем по формату   ${varname1}

		//реплейс
		//можна так
		$templateProcessor->setValue('var1', 'John Doe');

		//або так:                   arraykeys              and   arrayofvalues
		$templateProcessor->setValue(array('var2', 'var3'), array('this_is_var2', 'this_is_var33333333333'));

		$filename2 = 'out.docx';
    $templateProcessor->saveAs($filename2);

		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename='.$filename2);
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		header('Content-Length: ' . filesize($filename2));
		flush();
		readfile($filename2);
		//unlink($filename); // deletes the temporary file
		exit;

	}

}
