﻿function ExecuteCommand_on_KKM (Data, Execute_Path = 'AddIn', timeout) {
//////////////////////////////////////////////////////////////////////////////////////////
// Вызов команды на сервере KKM-----------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////////////////
	$('.kkm_overlay_text').html('<p>Запрос к серверу ККМ</p>');
	return new Promise(function(resolve, reject) {
		if (typeof(KkmServer) !== 'undefined' && Execute_Path !== 'Server') {//Проверка стоит ли расширение, и если стоит то отправка через расширение
			try {
	    		$('.kkm_overlay_text p').append(' через РАСШИРЕНИЕ браузера');
	    		window.setTimeout(function(){

		        if (typeof (Data) == "string") Data = JSON.parse(Data);// Если данные - строка JSON конвентируем в объект
	        	KkmServer.Execute(function(response, statusText, xhrObj){resolve(response)}, Data);// Выполняем команду через расширение
		        return; //Возврат - вызов по Http не нужен

	    		}, 2000);
			}catch {
	   	    	reject('ERROR IN ExecuteCommand_on_KKM');
			}
		};

		window.setTimeout(function(){

		// Если нет расширения - далее отправляем команду по http
		var UrlServer = ( typeof KKMS_Server_Url !== 'undefined') ? KKMS_Server_Url : "https://localhost:5893";
		var User = "User"; // Пользователь доступа к серверу торгового оборудования
		var Password = ""; // Пароль доступа к серверу торгового оборудования
		if (timeout == undefined) {
		    timeout = 60000; //Минута - некоторые драйверы при работе выполняют интерактивные действия с пользователем - тогда увеличте тайм-аут.
		}
		if (typeof (Data) != "string") {
			Data = JSON.stringify(Data);
		}
	   	$.support.cors = true;
	   	var request_kkm = $.ajax({
	   	    type: 'POST',
	   	    async: true,
	   	    timeout: timeout,
	   	    url: UrlServer+ '/Execute',// + ((UrlServer == "") ? window.location.protocol + "//" + window.location.host + "/" : "/") + 'Execute',
	   	    crossDomain: true,
	   	    dataType: 'json',
	   	    contentType: 'application/json; charset=UTF-8',
	   	    processData: false,
	   	    data: Data,
	   	    headers: (User !== "" || Password !== "") ? { "Authorization": "Basic " + btoa(User + ":" + Password) } : "",
	   	    success: function(response, statusText, xhrObj){
	   	    	resolve(response);
	   	    },//ExecuteSuccess,
	   	    error: function(xhrObj, textStatus, err){
	   	    	reject(xhrObj)//ErrorSuccess
	   	    }

	   	});

		}, 2000);
	});
}
// Герерация GUID
function guid() {
    function S4() {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    }
    return (S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4());
}
function Analyze_KKM_Responce(KkmServerResponce){
	return new Promise(function(resolve, reject) {
		switch (KkmServerResponce.Status) {// Статусы выполнения команды
		    case 0:
		    	$('.kkm_overlay_text').html('<p>Команда выполненa без ошибок</p>');
		    	resolve(KkmServerResponce);
				break;
		    case 1:
		    	$('.kkm_overlay_text').html('<p>Команда запущена на выполнение но еще не выполнена</p>');
		    	window.setTimeout(function(){
		    		Get_KKM_Command_Result(KkmServerResponce.IdCommand).then(
	   						function(Command_Result){
	   							Analyze_KKM_Responce(Command_Result);
	   							resolve(Command_Result);
	   						}
	   					);
				}, 2000);
		      	break;
		    case 2:
		    	$('.kkm_overlay_text').html('<p>Команда выполнена, есть ошибка</p>');
		    	if (KkmServerResponce.Error != undefined && KkmServerResponce.Error != "") {
		    		$('.kkm_overlay_text').append('Ошибка ККМ: '+ KkmServerResponce.Error);
				}
		    	resolve(KkmServerResponce);
				break;
		    case 3:
		    	$('.kkm_overlay_text').html('<p>Устройство не найдено или не найдена ранее запущенная команда</p>');
		    	resolve(KkmServerResponce);
		      	break;
		    case 4:
		    	$('.kkm_overlay_text').html('<p>Команда еще не запущена на выполнение (ожидание готовности устройства)</p>');
		    	window.setTimeout(function(){
		    		Get_KKM_Command_Result(KkmServerResponce.IdCommand).then(
	   						function(Command_Result){
	   							Analyze_KKM_Responce(Command_Result);
	   							resolve(Command_Result);
	   						}
	   					);
				}, 2000);
		      break;
		    case 5:
		    	$('.kkm_overlay_text').html('<p>Команда уже была выполнена или выполняется в текущий момент</p>');
		    	window.setTimeout(function(){
		    		Get_KKM_Command_Result(KkmServerResponce.IdCommand).then(
	   						function(Command_Result){
	   							Analyze_KKM_Responce(Command_Result);
	   							resolve(Command_Result);
	   						}
	   					);

				}, 2000);
		      break;
		    default:
		    	console.log('Undocument State: ', KkmServerResponce);
				reject(KkmServerResponce);
		};
	});
}

function Get_KKM_Command_Result(IdCommand, Times){// Вызываем запрос на получение результата с задержкой 2 секунды
	return new Promise(function(resolve, reject) {
		if (Times == undefined) Times = 3;
		console.log('Times - ', Times);
		var NotFinalStatuses = [1, 4, 5];
		var CommandData = {
	            Command: "GetRezult",// Команда серверу - запрос выполнения команды
	            IdCommand: IdCommand,// Уникальный идентификатор ранее поданной команды
	        };
		console.log('COMMAND DATA: ', CommandData);
		ExecuteCommand_on_KKM(CommandData).then(//(Data, 'Server')//// Заново запрашиваем результат выполнения команды
	    	function(KkmServerResponce){
	    		console.log('Resp after ExecuteCommand_on_KKM', KkmServerResponce);
	    		//KkmServerResponce.Status = 1;
	    		if (NotFinalStatuses.includes(KkmServerResponce.Status)){
	    			Times--;
	    			console.log('Times left - ', Times);
	    			console.log('NOT FINAL STATUS', KkmServerResponce);
	    			if (Times > 0){
	   					Get_KKM_Command_Result(IdCommand, Times).then(
	   						function(KkmServerResponce){
	   							resolve(KkmServerResponce.Rezult);
	   						}
	   					).catch();
	    			}else{
	    				reject({Error: 'Too match executing times'});
	    			}
	    		}else{
	    			console.log('FINAL STATUS', KkmServerResponce);
	    			resolve(KkmServerResponce.Rezult);
	    		}
	    	}
	    );
	});
}

function ReOpen_KKM_Session (Data){
	return new Promise(function(resolve, reject) {
	Get_Cashier_Data_With_Ajax().then(
		function(Cashier){
			console.log(Cashier);
			if (Data.SessionState === 3){
				var CloseShiftData = {
		                Command: "CloseShift",// Команда серверу - запрос выполнения команды
		                IdDevice: Data.IdDevice,
				        CashierName: Cashier.name,// Продавец, тег ОФД 1021
				        CashierVATIN: Cashier.vatin,// ИНН продавца тег ОФД 1203
				        NotPrint: true,// Не печатать чек на бумагу
				        IdCommand: guid(),
		            };
				ExecuteCommand_on_KKM (CloseShiftData).then(
						function(CloseShiftCommandResponce){
							Analyze_KKM_Responce(CloseShiftCommandResponce).then(
					    			function(Result){
					    				console.log('Result after Analyze_KKM_Responce', Result);
					    				if (Result.Error != undefined && Result.Error != ''){
											$('.kkm_overlay_text').html('<p>Устройство: '+ Result.UnitName + '</p>ОШИБКА: ' + Result.Error);
										}else{
											$('.kkm_overlay_text').html('<p>Смена закрыта</p><p>Касcир: '+Cashier.name+'</p>');
											Log_KKM_Shifts_operation({request: CloseShiftData, responce: Result}).then(function(Data){
												console.log('Log_KKM_Shifts_operation', Data);
											});
											window.setTimeout(function(){
												$('.kkm_overlay_text').html('<p>Открытие смены</p>');
											}, 3000);
										}
					    			}
					    		);
						}
				);
			}
			var OpenShiftData = {
	                Command: "OpenShift",// Команда серверу - запрос выполнения команды
	                IdDevice: Data.IdDevice,// Уникальный идентификатор ранее поданной команды
			        CashierName: Cashier.name,// Продавец, тег ОФД 1021
			        CashierVATIN: Cashier.vatin,// ИНН продавца тег ОФД 1203
			        NotPrint: true,// Не печатать чек на бумагу
			        IdCommand: guid(),
	            };
			ExecuteCommand_on_KKM (OpenShiftData).then(
					function(OpenShiftCommandResponce){
						Analyze_KKM_Responce(OpenShiftCommandResponce).then(
				    			function(Result){
				    				console.log('Result after Analyze_KKM_Responce', Result);
				    				if (Result.Error != undefined && Result.Error != ''){
										$('.kkm_overlay_text').html('<p>Устройство: '+ Result.UnitName + '</p>ОШИБКА: ' + Result.Error);
										reject(Result);
									}else{
										$('.kkm_overlay_text').html('<p>Смена открыта</p><p>Касcир: '+Cashier.name+'</p>');
										Log_KKM_Shifts_operation({request: OpenShiftData, responce: Result}).then(function(Log_Data){
											console.log('Log_KKM_Shifts_operation', Log_Data);
											$('.kkm_overlay_text').append('<p>Номер смены: '+Log_Data[1].insert_arr.SessionNumber+'</p>');
											window.setTimeout(function(){
												resolve(Result);
											}, 5000);
										});
									}
				    			}
				    		);
					}
			);
		},
		function(Error){
			alert('Fail Cashier Data: '+Error);
		}
	);
	});
}

function Explore_Kkm_Device_State(SelectedDevice){
	Explore_Kkm_Device_Promise = new Promise(function(resolve, reject) {
		var SessionStates = ['', ' Закрыта', ' Открыта', ' Открыта, но закончилась'];
	    var Data = {
	        Command: "GetDataKKT",
	        NumDevice: 0,// Номер устройства. Если 0 то первое не блокированное на сервере
	        IdDevice: SelectedDevice.Id,
	        IdCommand: guid()
	    };
	    ExecuteCommand_on_KKM (Data).then(//(Data, 'Server')
	    	function(KkmServerResponce){
	    		Analyze_KKM_Responce(KkmServerResponce).then(
	    			function(Result){
	    				console.log('Result after Analyze_KKM_Responce', Result);
	    				if (!Result.Error){
	    					$('.kkm_overlay_text').append('<p>Устройство: '+Result.UnitName+'</p>Статус смены: ' + SessionStates[Result.Info.SessionState]);
	    					window.setTimeout(function(){
	    					if (Result.Info.SessionState !== 2){// Статус сессии 1-Закрыта, 2-Открыта, 3-Открыта, но закончилась (3 статус на старых ККМ может быть не опознан)
	    					var session_btn_txt = Result.Info.SessionState == 3 ? 'Закрыть и открыть смену?' : 'Открыть смену?';
	    						$('.kkm_overlay').append("<button id='reopen_session_btn'>"+session_btn_txt+"</button>");
								$('#reopen_session_btn').on('click', function(){
									$('#reopen_session_btn').remove();
									ReOpen_KKM_Session({SessionState:Result.Info.SessionState, IdDevice:SelectedDevice.Id}).then(
											function(ReOpenResult){
												resolve({msg:'End of Explore_Kkm_Device_State, Session - Reopened, next step processing...', Result: ReOpenResult});
											}
									);
								});
	    					}else{
	    						resolve({msg:'End of Explore_Kkm_Device_State, Session - Ok, next step processing...', Result:Result});
	    					}
	    					}, 1000);
	    				};
	    			}
	    		);
	    	},
	    	function(KkmServerResponce){
	    		$('.kkm_overlay_text').text('KKM SERVER NOT CONNECTED');
	    		$('.kkm_overlay_text').append(KkmServerResponce.responseText);
	    	}
	    ).catch();
	});
    return Explore_Kkm_Device_Promise;
}
function Log_KKM_Shifts_operation (Data){
	 return new Promise(function(resolve, reject) {
		 $.ajax({
				dataType: 'json',
				url: "/kkm/ajax_log_device_operation",
				type : "POST",
				data: Data,
				success: function (Res_from_hms) {
					resolve(Res_from_hms);
				},
				error: function (){
					reject('Error Shiftoperation Saving!');
				}
			});
	 });
}