<?php

$dealer_id = 0;
if ($su_property_id != '0') {
    $hms_property_id = explode('-', $su_property_id)[2];
} else {
    $hms_property_id = '';
}
$dealer_id_query_row = $this->db->like('name', 'dealer_id')
    ->get_where('dc_su_data', [
    'su_dc_id' => $channel_code,
    'hms_property_id LIKE' => $hms_property_id,
    'name' => 'dealer_id',
])
    ->row();

$dealer_id = ($dealer_id_query_row) ? $dealer_id_query_row->int_value : 0;

$dealers = [];
$dealers[0]['dealer_id'] = 0;
$dealers[0]['dealer_name'] = '---';
$dealers[0]['selected_dealer'] = '';
$sql = 'SELECT id, name FROM dealers WHERE is_active = 1';
$query = $this->db->query($sql);
if ($query->num_rows() > 0) {
    foreach ($query->result() as $row) {
        $dealers[$row->id]['dealer_id'] = $row->id;
        $dealers[$row->id]['dealer_name'] = $row->name;
        $dealers[$row->id]['selected_dealer'] = '';
    }
}

if ($dealer_id != 0) {
    $array_keys = array_keys($dealers);
    foreach ($array_keys as $key) {
        if ($dealers[$key]['dealer_id'] == $dealer_id) {
            $dealers[$key]['selected_dealer'] = 'selected';
        }
    }
}

if ($su_property_id != '0') {
    $mapping_result = $this->dcm_su_api->mapping($su_property_id);

    $widget_data = [
        [
            'proppmsid' => $mapping_result['Data']['proppmsid'],
            'token_id' => $mapping_result['Data']['token_id'],
            'encrypted_channel_code' => $encrypted_channel_code,
        ],
    ];
    $source_hidden_class = '';
} else {
    $widget_data = [];
    $source_hidden_class = 'd0';
}

$menu_data = $this->htmltpl->get_left_settings_menu(7, 1);
$submenulist = $this->navigation->getnotelist_admin_2(33, 27);
$submenulist[8]['active'] = 'class="active"';
$su_menu = $this->navigation->get_su_menu(6);

$sq = count($subchannels);

$subchannels_show = [];
$subchannels_hidden = [];

for ($i = 0; $i < $sq; ++$i) {
    if ($i < 8) {
        $subchannels_show[] = $subchannels[$i];
        $expand_btn_class = 'd0';
    } else {
        $subchannels_hidden[] = $subchannels[$i];
        $expand_btn_class = '';
    }
}

$data = [
        'su_menu' => $su_menu,
        'submenulist' => $submenulist,
        'header' => $this->htmltpl->getHeader_new(),
        'footer_html' => $this->htmltpl->getFooter_new(),
        'settings_main_menu' => $menu_data['main_menu'],
        'settings_sub_menu' => $menu_data['sub_menu'],
        'dealers' => $dealers,
        'su_channel_id' => $channel_code,
        'ch_id' => $id,
        'hms_property_id' => $hms_property_id ?? 0,
        'connector_name' => $channel_name,
        'widget_data' => $widget_data,
        'subchannels_show' => $subchannels_show,
        'subchannels_hidden' => $subchannels_hidden,
        'expand_btn_class' => $expand_btn_class ?? '',
        'hidden' => empty($subchannels) ? 'd0' : '',
        'dc_logo_name' => 'su_logo_'.$ch_id.'.png',
        'connector_url' => $channel_url,
        'source_hidden_class' => $source_hidden_class,
];

$this->mlanguages->getdictionary('online_module_sync', '', $data);
$this->mlanguages->getdictionary('dc_cannal_all_options', '', $data);
$this->mlanguages->getdictionary('reservations_calendar', '', $data);
$this->parser->parse('templates/dc_su_api/clients_edit.html', $data);
