<?php

$channels_data = [];

$distinct_countries = $this->dcm_su_api->get_distinct_countries();
$distinct_regions = $this->dcm_su_api->get_distinct_regions();
$distinct_p_types = $this->dcm_su_api->get_distinct_property_types();

array_unshift($distinct_countries, ['country' => 'All']);
array_unshift($distinct_regions, ['region' => 'ALL']);
array_unshift($distinct_p_types, ['property_type' => 'ALL']);

$search_property_type = $this->session->userdata('su_search_property_type')
        ? $this->session->userdata('su_search_property_type')
        : 'All';

$search_country = $this->session->userdata('su_search_country')
        ? $this->session->userdata('su_search_country')
        : 'All';

$search_region = $this->session->userdata('su_search_region')
        ? $this->session->userdata('su_search_region')
        : 'ALL';

$search_ota_name = $this->session->userdata('su_search_ota_name');

foreach ($distinct_countries as $k => $v) {
    $distinct_countries[$k]['country_selected'] = $v['country'] == $search_country
        ? 'selected'
        : '';
}

foreach ($distinct_regions as $k => $v) {
    $distinct_regions[$k]['region_selected'] = $v['region'] == $search_region
        ? 'selected'
        : '';
}

foreach ($distinct_p_types as $k => $v) {
    $distinct_p_types[$k]['p_type_selected'] = $v['property_type'] == $search_property_type
        ? 'selected'
        : '';
}

foreach ($su_all_channels as $ch_id => $ch_data) {
    $is_active = 0;
    if (isset($chs_list_arr[$ch_data['channel_code']])) {
        $connection_data = $chs_list_arr[$ch_data['channel_code']];

        foreach ($connection_data as $conn_data) {
            if ($conn_data['Status'] == 'Active') {
                $is_active = 1;
                break;
            }
        }
    }

    $st_lbl = [];

    switch ($ch_data['status']) {
        case 'Online':
            $st_lbl['class'] = 'primary';
            $st_lbl['color'] = 'rgba(255, 255, 255, 1)';
            $hide = '';
            $st_name = $this->mlanguages->getdictionaryword('chmanager_chanel_list', '', 'clt_online');
            break;
        case 'Pending':
            $st_lbl['class'] = 'warning';
            $st_lbl['color'] = 'rgba(27, 34, 44, 0.75)';
            $hide = 'd0';
            $st_name = $this->mlanguages->getdictionaryword('chmanager_chanel_list', '', 'clt_soon');
            break;
        case 'Development':
        default:
            $st_lbl['class'] = 'danger';
            $st_lbl['color'] = 'rgba(255, 255, 255, 1)';
            $hide = 'd0';
            $st_name = $this->mlanguages->getdictionaryword('chmanager_chanel_list', '', 'clt_development');
            break;
    }

    $sq = $ch_data['sq'] > 0 ? '<span class="label label-success label-as-badge" 
                                        style="position: absolute;top: 0px;right: 20px; padding:5px;
                                        font-size:13px;opacity:0.65"> 
                                        +'.$ch_data['sq']
                                .' </span>' : '';
    $st = '<span class="label label-'
        .$st_lbl['class']
        .'" style="position: absolute;top: 0px;left: 2px; padding: 5px; color:'
        .$st_lbl['color']
        .';opacity:0.65">'
        .$st_name.'</span>';

    if ($ch_data['status'] == 'Online') {
        $ota_id = $su_property_id_ota ?? 0;
        $ch_url = "/dc_su_api/clients_edit/$ota_id/".$ch_data['ch_id'];
    } else {
        if (isset($ch_data['channel_url']) && strlen($ch_data['channel_url']) > 5) {
            $ch_url = 'https://'.$ch_data['channel_url'].'" target="_blank';
        } else {
            $ch_url = '#';
        }
    }

    array_push($channels_data, [
        'ch_id' => $ch_data['ch_id'],
        'st' => $st,
        'sq' => $sq,
        'short_name' => $su_all_channels[$ch_id]['channel_name'],
        'small_logo' => 'su_logo_'.$ch_data['ch_id'].'.png',
        'is_active' => $is_active,
        'ch_edit_url' => $ch_url,
        'unactive_class' => ($is_active == 1) ? '' : 'unactive',
        'is_noactive_class' => ($is_active == 1) ? 'd0' : $hide,
        'is_active_class' => ($is_active == 1) ? $hide : 'd0',
    ]);
}
//echo '<pre>';
//print_r($channels_data);
//exit();
$data = [];
$menu_data = $this->htmltpl->get_left_settings_menu(7, 1);
$su_menu = $this->navigation->get_su_menu(6);
$data['header'] = $this->htmltpl->getHeader_new();
$data['footer_html'] = $this->htmltpl->getFooter_new();
$data['settings_main_menu'] = $menu_data['main_menu'];
$data['settings_sub_menu'] = $menu_data['sub_menu'];
$data['su_menu'] = $su_menu;
$data['su_propertries'] = $properties;
$data['channels'] = $channels_data;
$data['distinct_countries'] = $distinct_countries;
$data['distinct_p_types'] = $distinct_p_types;
$data['distinct_regions'] = $distinct_regions;
$data['search_ota_name'] = $search_ota_name;
$this->mlanguages->getdictionary('chmanager_chanel_list', '', $data);
$this->parser->parse('templates/dc_su_api/clients.html', $data);
