
DROP TABLE IF EXISTS `dc_su_xml_cfg`;
CREATE TABLE `dc_su_xml_cfg` (
  `dc_account_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `str_value` varchar(255) NOT NULL,
  `int_value` bigint(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


ALTER TABLE `dc_su_xml_cfg`
  ADD UNIQUE KEY `dc_account_id` (`dc_account_id`,`name`) USING HASH;


DROP TABLE IF EXISTS `dc_su_addons`;
CREATE TABLE `dc_su_addons` (
  `id` int(11) NOT NULL,
  `dc_uuid` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `nights` int(11) NOT NULL,
  `persons` int(11) NOT NULL,
  `price_mode` int(11) NOT NULL,
  `price_per_unit` int(11) NOT NULL,
  `totalprice` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `addons_date` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `dc_su_addons`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `dc_uuid` (`dc_uuid`,`type`) USING HASH;

ALTER TABLE `dc_su_addons`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;


DROP TABLE IF EXISTS `dc_su_api_categories_active`;
CREATE TABLE `dc_su_api_categories_active` (
  `id` int(11) NOT NULL,
  `hms_category_id` int(11) NOT NULL,
  `room_limit` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `dc_su_api_categories_active`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `dc_su_api_categories_active`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;


DROP TABLE IF EXISTS `dc_su_api_contacts_active`;
CREATE TABLE `dc_su_api_contacts_active` (
  `id` int(11) NOT NULL,
  `hms_contact_id` int(11) NOT NULL,
  `is_active` tinyint(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `dc_su_api_contacts_active`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `dc_su_api_contacts_active`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;


DROP TABLE IF EXISTS `dc_su_api_log`;
CREATE TABLE `dc_su_api_log` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `details` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `dc_su_api_log`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `dc_su_api_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;


DROP TABLE IF EXISTS `dc_su_api_properties_active`;
CREATE TABLE `dc_su_api_properties_active` (
  `id` int(11) NOT NULL,
  `hms_property_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `dc_su_api_properties_active`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `dc_su_api_properties_active`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;


DROP TABLE IF EXISTS `dc_su_api_rates_active`;
CREATE TABLE `dc_su_api_rates_active` (
  `id` int(11) NOT NULL,
  `hms_rate_id` int(11) NOT NULL,
  `restrictid` int(11) NOT NULL,
  `property_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `dc_su_api_rates_active`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `hms_rate_id` (`hms_rate_id`,`property_id`) USING HASH;

ALTER TABLE `dc_su_api_rates_active`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;


DROP TABLE IF EXISTS `dc_su_categories_strtoint`;
CREATE TABLE `dc_su_categories_strtoint` (
  `id` int(11) NOT NULL,
  `dc_room_id` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `dc_su_categories_strtoint`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `dc_room_id` (`dc_room_id`) USING HASH;

ALTER TABLE `dc_su_categories_strtoint`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

DROP TABLE IF EXISTS `dc_su_category2occupancy`;
CREATE TABLE `dc_su_category2occupancy` (
  `dc_category_id` int(11) NOT NULL,
  `hms_occupancy_id` int(11) NOT NULL,
  `state` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `dc_su_category2occupancy`
  ADD UNIQUE KEY `dc_category_id` (`dc_category_id`,`hms_occupancy_id`) USING HASH;

DROP TABLE IF EXISTS `dc_su_data`;
CREATE TABLE `dc_su_data` (
  `su_dc_id` int(11) NOT NULL,
  `hms_property_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `str_value` varchar(255) NOT NULL,
  `int_value` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
 
ALTER TABLE `dc_su_data`
  ADD UNIQUE KEY `su_dc_id` (`su_dc_id`,`name`,`hms_property_id`) USING HASH;


DROP TABLE IF EXISTS `dc_su_log`;
CREATE TABLE `dc_su_log` (
  `id` int(11) NOT NULL,
  `time` timestamp NOT NULL DEFAULT current_timestamp(),
  `url` varchar(255) NOT NULL,
  `request` text NOT NULL,
  `response` longtext NOT NULL,
  `responseint` int(11) NOT NULL,
  `stime` float NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `dc_su_log`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `id` (`id`);

ALTER TABLE `dc_su_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;


DROP TABLE IF EXISTS `dc_su_occupancy`;
CREATE TABLE `dc_su_occupancy` (
  `id` int(11) NOT NULL,
  `name` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `roomcategory` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
 
ALTER TABLE `dc_su_occupancy`
  ADD UNIQUE KEY `roomcategory` (`roomcategory`,`name`) USING HASH;

DROP TABLE IF EXISTS `dc_su_properties_link`;
CREATE TABLE `dc_su_properties_link` (
  `su_property_id` varchar(255) NOT NULL,
  `hms_property_id` int(11) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


DROP TABLE IF EXISTS `dc_su_rate2category_link`;
CREATE TABLE `dc_su_rate2category_link` (
  `dc_rate_id` int(11) NOT NULL,
  `dc_category_id` int(11) NOT NULL,
  `hms_occupancy_id` int(11) NOT NULL,
  `hms_rate_id` int(11) NOT NULL,
  `hms_restrict_id` int(11) NOT NULL,
  `hms_price_func_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
 
ALTER TABLE `dc_su_rate2category_link`
  ADD UNIQUE KEY `dc_rate_id` (`dc_rate_id`,`dc_category_id`,`hms_occupancy_id`) USING HASH;

DROP TABLE IF EXISTS `dc_su_rates`;
CREATE TABLE `dc_su_rates` (
  `id` int(11) NOT NULL,
  `dc_hotel_id` int(11) NOT NULL,
  `dc_rate_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `incoming_office` int(11) NOT NULL,
  `active` int(11) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
 
ALTER TABLE `dc_su_rates`
  ADD UNIQUE KEY `dc_rate_id` (`dc_rate_id`,`dc_hotel_id`) USING HASH;


DROP TABLE IF EXISTS `dc_su_rates_strtoint`;
CREATE TABLE `dc_su_rates_strtoint` (
  `id` int(11) NOT NULL,
  `dc_rate_id` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
 
ALTER TABLE `dc_su_rates_strtoint`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `dc_rate_id` (`dc_rate_id`) USING HASH;

ALTER TABLE `dc_su_rates_strtoint`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;


DROP TABLE IF EXISTS `dc_su_rate_intdate`;
CREATE TABLE `dc_su_rate_intdate` (
  `dc_reservation_id` varchar(50) NOT NULL,
  `dc_rate_id` int(11) NOT NULL,
  `intdate` int(11) NOT NULL,
  `price` float NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
 
ALTER TABLE `dc_su_rate_intdate`
  ADD UNIQUE KEY `dc_reservation_id` (`dc_reservation_id`,`dc_rate_id`,`intdate`) USING HASH;


DROP TABLE IF EXISTS `dc_su_restricts_link`;
CREATE TABLE `dc_su_restricts_link` (
  `dc_rate_id` int(11) NOT NULL,
  `dc_category_id` int(11) NOT NULL,
  `restrict_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
 
ALTER TABLE `dc_su_restricts_link`
  ADD UNIQUE KEY `dc_rate_id` (`dc_rate_id`,`dc_category_id`) USING HASH;


DROP TABLE IF EXISTS `dc_su_room_categories`;
CREATE TABLE `dc_su_room_categories` (
  `dc_hotel_id` int(11) NOT NULL,
  `dc_room_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
 
ALTER TABLE `dc_su_room_categories`
  ADD UNIQUE KEY `dc_room_id` (`dc_room_id`,`dc_hotel_id`) USING HASH;



DROP TABLE IF EXISTS `dc_su_room_categories_link`;
CREATE TABLE `dc_su_room_categories_link` (
  `dc_category_id` int(11) NOT NULL,
  `hms_category_id` int(11) NOT NULL,
  `min` int(11) NOT NULL,
  `max` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `dc_su_room_categories_link`
  ADD UNIQUE KEY `dc_category_id` (`dc_category_id`);