<?php

class Stripe extends CI_model
{
    
    function __construct()
    {
        parent::__construct();
        
        $this->load->model('hotelix_config');
    }
    
    function get_param_vc()
    {
        $stripe = array(
            'secret_key' => "sk_test_9xWAW0g8uNN7l1jIcMQnJX4O",
            'publishable_key' => "pk_test_yfqzU5zoReQ1BJ5UkHtttD1h",
            'account_id' => "acct_1Bj5EIHScC4K9wht",
            'connected_publishable_key' => "pk_test_51Bj5EIHScC4K9whtk1vuM8GgmsgdRuDpR8smNYlakWTKA28Su0SGdAvTRHSZfjgQLrlHZwKBouFR0cGW2VN7BYFa00cRbV3rEK"
        );
        
        if (false) {
            $stripe = array(
                'secret_key' => "sk_live_DORq6PLrkilzIeNavZn7rZRG",
                'publishable_key' => "pk_live_QilOxcSVLxEak03ifosRx42P",
                'account_id' => "acct_1K74YrJnfiydvyq3",
                'connected_publishable_key' => "???"
            );
        }
        
        return $stripe;
    }
    
    function pay_request_VC($data)
    {
        require_once (APPPATH . 'third_party/stripe/init.php'); // require_once (APPPATH . 'libraries/stripe/init.php');
        $stripe = new \Stripe\Stripe();
        $payment_method = new \Stripe\PaymentMethod();
        $intent = new \Stripe\PaymentIntent();
        
        $authparam = $this->get_param_vc();
        
        $stripe->setApiKey($authparam['secret_key']);
        
        // $data['cardnumber'] = "";
        // $data['expmonth'] = "11";
        // $data['expyear'] = "23";
        // $data['cvc'] = "880";
        
        $method_new = $payment_method->create(array(
            'type' => 'card',
            'card' => array(
                'number' => $data['cardnumber'],
                'exp_month' => $data['expmonth'],
                'exp_year' => $data['expyear'],
                'cvc' => $data['cvc']
            )
        ), array(
            'stripe_account' => $authparam['account_id']
        ));
        
        $data['amount'] = (int) ($data['amount'] * 100);
        
        if (false) {
            $intent_new = $intent->create(array(
                'amount' => $data['amount'],
                'currency' => $data['currency'],
                'payment_method' => $method_new->id
            ));
        } else {
            
            // $intent_new = $intent->create(array(
            // 'amount' => $data['amount'],
            // 'currency' => $data['currency'],
            // 'payment_method' => $method_new->id,
            // 'application_fee_amount' => (int) ($data['amount'] * 0.002),
            // 'on_behalf_of' => $authparam ['account_id'],
            // 'transfer_data' => array(
            // 'destination' => $authparam ['account_id'],
            // )
            // ));
            
            $intent_new = $intent->create(array(
                'amount' => $data['amount'],
                'currency' => $data['currency'],
                'payment_method' => $method_new->id,
                'application_fee_amount' => (int) ($data['amount'] * 0.002)
            ), array(
                'stripe_account' => $authparam['account_id']
            ));
        }
        
        $host = "";
        if (isset($_SERVER["HTTP_HOST"])) {
            $host = $_SERVER["HTTP_HOST"];
        }
        
        if (isset($data['ajax_url'])) {
            $url = $host . $data['ajax_url'];
        } else {
            $url = $host . "/payments_c2/ajax_stripe_payment_vcc_update";
        }
        $html_data = array();
        $html_data['host'] = $host;
        $html_data['ajax_url'] = $url;
        $html_data['client_secret'] = $intent_new->client_secret;
        $html_data['method_id'] = $method_new->id;
        $html_data['hms_payment_id'] = $data['hms_payment_id'];
        $html_data['hms_res_id'] = $data['hms_res_id'];
        $html_data['number'] = $data['number'];
        $html_data['pk_key'] = $authparam['connected_publishable_key'];
        // echo "<pre>";
        // print_r($html_data);
        // die();
        // echo $authparam ['secret_key'] . " - " . $authparam ['account_id'] . " - " . $data['currency'] ;
        // die();
        $this->parser->parse('templates/stripe_vc.html', $html_data);
    }
    
    function pay_request_VC_api_call($data)
    {
        require (APPPATH . 'third_party/stripe/init.php'); // require_once (APPPATH . 'libraries/stripe/init.php');
        $stripe = new \Stripe\Stripe();
        $payment_method = new \Stripe\PaymentMethod();
        $intent = new \Stripe\PaymentIntent();
        
        //$authparam = $this->get_param_vc();
        
        $authparam = $this->get_standart_stripe_param();
        
        
        $stripe->setApiKey($authparam['stripe_secret']);
        
        $data['amount'] = (int) ($data['amount'] * 100);
        
        // !!!!!
        $ca_stripe_user_id = $authparam['ca_stripe_user_id'];
        
        $method_new = $payment_method->create(array(
            'type' => 'card',
            'card' => array(
                'number' => $data['cardnumber'],
                'exp_month' => $data['expmonth'],
                'exp_year' => $data['expyear'],
                'cvc' => $data['cvc']
            )
        ), array(
            'stripe_account' => $ca_stripe_user_id
        ));
        
        $intent_new = $intent->create(array(
            'amount' => $data['amount'],
            'currency' => $data['currency'],
            'payment_method' => $method_new->id,
            'application_fee_amount' => ceil($data['amount'] * 0.002)
        ), array(
            'stripe_account' => $ca_stripe_user_id
        ));
        
        $curl_data = array();
        $curl_data['url'] = "https://api.stripe.com/v1/payment_intents/" . $intent_new->id . "/confirm";
        
        //$curl_data['secret_key'] = 'sk_test_51Bj5EIHScC4K9whty6Wsm26dWXMsvg8GjgrmTpamHSJswqNh5IZsDeJZhNBy58xojFRJz1iNrjnVvloFN4JaqtKu00k5WVpMTz';
        $curl_data['secret_key'] = $authparam['ca_access_token'];
        
        $curl_data['payment_method'] = $method_new->id;
        $result = $this->curl_model->curl_stripe_api_call($curl_data);
        
        return $result;
    }
    
    function get_param_hms_billing()
    {
        // $test = 0;
        $test = $this->istestmode();
        
        if ($test) {
            
            $stripe = array(
                'secret_key' => "sk_test_d19ipvh8ROnGPZ4L6q96S4BO",
                'publishable_key' => "pk_test_0toHn3UsTJbzBwO5WIhtQNBK"
            );
        } else {
            $stripe = array(
                'secret_key' => "sk_live_ULSdkctCLcUFaOamwoEjKQIe",
                'publishable_key' => "pk_live_gNXbdh4NAgjogKhNKmXEhIV9"
            );
        }
        
        return $stripe;
    }
    
    function get_param_hms_billing_uk($test = 0)
    {
        // $test = 0;
        $test = $this->istestmode();
        
        if ($test) {
            $stripe = array(
                'secret_key' => "sk_test_D44UtbmH0yoFWIh8mj7q3Jcc",
                'publishable_key' => "pk_test_caLBCpBpAkubeVHjTb1vosaf"
            );
        } else {
            $stripe = array(
                'secret_key' => "sk_live_iE2mMoPUDp3VxXlAbEjEnXA0",
                'publishable_key' => "pk_live_Qdoy21Zg2qo4i8ONbXTL7Ga1"
            );
        }
        
        return $stripe;
    }
    
    function get_param_global($account_type = "")
    {
        $test = $this->istestmode();
        
        // $account_type = "us";
        $account_type = $this->get_account_type();
        
        switch ($account_type) {
            case "us":
                if ($test) {
                    
                    $stripe = array(
                        'secret_key' => "sk_test_d19ipvh8ROnGPZ4L6q96S4BO",
                        'publishable_key' => "pk_test_0toHn3UsTJbzBwO5WIhtQNBK"
                    );
                } else {
                    $stripe = array(
                        'secret_key' => "sk_live_ULSdkctCLcUFaOamwoEjKQIe",
                        'publishable_key' => "pk_live_gNXbdh4NAgjogKhNKmXEhIV9"
                    );
                }
                break;
            case "uk":
                if ($test) {
                    $stripe = array(
                        'secret_key' => "sk_test_D44UtbmH0yoFWIh8mj7q3Jcc",
                        'publishable_key' => "pk_test_caLBCpBpAkubeVHjTb1vosaf"
                    );
                } else {
                    $stripe = array(
                        'secret_key' => "sk_live_iE2mMoPUDp3VxXlAbEjEnXA0",
                        'publishable_key' => "pk_live_Qdoy21Zg2qo4i8ONbXTL7Ga1"
                    );
                }
                break;
            default:
                if ($test) {
                    $stripe = array(
                        'secret_key' => "sk_test_D44UtbmH0yoFWIh8mj7q3Jcc",
                        'publishable_key' => "pk_test_caLBCpBpAkubeVHjTb1vosaf"
                    );
                } else {
                    $stripe = array(
                        'secret_key' => "sk_live_iE2mMoPUDp3VxXlAbEjEnXA0",
                        'publishable_key' => "pk_live_Qdoy21Zg2qo4i8ONbXTL7Ga1"
                    );
                }
                break;
        }
        
        return $stripe;
    }
    
    function istestmode()
    {
        $stripe_test_mode = 0;
        $stripe_test_mode = $this->hotelix_config->get_record("stripe_testmode", "int");
        
        return $stripe_test_mode;
    }
    
    function get_account_type()
    {
        $stripe_account_test = "";
        $stripe_account_test = $this->hotelix_config->get_record("stripe_account_test");
        
        return $stripe_account_test;
    }
    
    function get_standart_stripe_param()
    {
        
        // sk_test_9xWAW0g8uNN7l1jIcMQnJX4O
        // pk_test_yfqzU5zoReQ1BJ5UkHtttD1h
        $test_mode = 0;
        $query = $this->db->query("SELECT int_value FROM standart_stripe_xml_cfg  WHERE name = 'test_mode'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $test_mode = $row->int_value;
        }
        
        $connected_stripeAccount = "";
        $query = $this->db->query("SELECT str_value FROM standart_stripe_xml_cfg  WHERE name = 'connected_stripeAccount'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $connected_stripeAccount = $row->str_value;
        }
        
        
        $ca_stripe_user_id = "";
        $query = $this->db->query("SELECT str_value FROM standart_stripe_xml_cfg  WHERE name = 'stripe_user_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $ca_stripe_user_id = $row->str_value;
        }
        
        $ca_access_token = "";
        $query = $this->db->query("SELECT str_value FROM standart_stripe_xml_cfg  WHERE name = 'access_token'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $ca_access_token = $row->str_value;
        }
        
        
        
        $hms_id = $this->config->item('hotel_id');
        $sql = "SELECT stripe_region_ca_id
        FROM global_fms_base.dict_country as t1
        JOIN visitka.config AS t2 ON t2.id_country_3c = t1.id
        WHERE t2.id = $hms_id";
        $query_row = $this->db->query($sql)->row();
        $stripe_region_ca_id = ! empty($query_row) ? $query_row->stripe_region_ca_id : 0;
        $param = array();
        switch ($test_mode) {
            case 1:
                switch ($stripe_region_ca_id) {
                    case 1:
                        $client_id = "ca_E1NBh7xJQaLEWSs15HqCDU9QfHCfhxrz"; // тестовый Европа
                        $param['stripe_secret'] = "sk_test_9xWAW0g8uNN7l1jIcMQnJX4O";
                        $param['stripe_publishable'] = "pk_test_yfqzU5zoReQ1BJ5UkHtttD1h";
                        break;
                    case 2:
                        $client_id = "ca_H44Fv5OlsmXfv8Gw7BTqDhIVCjrmOvlT"; // Тестовый америка
                        $param['stripe_secret'] = "sk_test_GDQsqL0X3dQkRsOd4RA0weyM00GiXdYBn8";
                        $param['stripe_publishable'] = "pk_test_d3YeKFapnOUPC67g6OxVHkZw00WM48iGZJ";
                        break;
                    default:
                        $client_id = "ca_E1NBh7xJQaLEWSs15HqCDU9QfHCfhxrz"; // тестовый Европа
                        break;
                }
                $param['client_id'] = $client_id;
                
                $param['connected_stripeAccount'] = $connected_stripeAccount;
                $param['test_mode'] = $test_mode;
                break;
                
            default:
                switch ($stripe_region_ca_id) {
                    case 1:
                        $client_id = "ca_E1NBkUE5TNhp7UFooJO8miIRcC77hTxH"; // Европа
                        $param['stripe_secret'] = "sk_live_DORq6PLrkilzIeNavZn7rZRG";
                        $param['stripe_publishable'] = "pk_live_QilOxcSVLxEak03ifosRx42P";
                        break;
                    case 2:
                        $client_id = "ca_H44FiEPLSlfJXYUloltR54e0yanUapy3"; // америка
                        $param['stripe_secret'] = "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";
                        $param['stripe_publishable'] = "pk_live_7B5LFb2wvzqnva9FcdrBy2nA00VOCZULoi";
                        break;
                    default:
                        $client_id = "ca_E1NBkUE5TNhp7UFooJO8miIRcC77hTxH"; // Европа
                        break;
                }
                $param['client_id'] = $client_id;
                $param['connected_stripeAccount'] = $connected_stripeAccount;
                break;
        }
        
        $param['stripe_region_ca_id'] = $stripe_region_ca_id;
        $param['ca_stripe_user_id'] = $ca_stripe_user_id;
        $param['ca_access_token'] = $ca_access_token;
        
        return $param;
    }
    
    function get_account_data($account_tbl_id)
    {
        $query = $this->db->query("SELECT * FROM stripe_subaccount WHERE id = " . $account_tbl_id);
        return $query->row_array();
    }
    
    function get_account_partner_id($account_id)
    {
        $partner_id = 0;
        $query = $this->db->query("SELECT partner_id FROM stripe_subaccount WHERE id = " . $account_id);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $partner_id = $row->partner_id;
        }
        return $partner_id;
    }
    
    function save_account_partner($data)
    {
        if (isset($data["account_id"])) {
            if ($data["account_id"] > 0) {
                $query = $this->db->query("INSERT INTO stripe_subaccount (id, partner_id) VALUES ('" . $data["account_id"] . "', '" . $data["partner_id"] . "')
                ON DUPLICATE KEY UPDATE partner_id = '" . $data["partner_id"] . "'");
            }
        }
    }
    
    function save_account_additional_data($data)
    {
        if (isset($data["account_id"])) {
            if ($data["account_id"] > 0) {
                $query = $this->db->query("INSERT INTO stripe_subaccount (id, weburl, currency) VALUES ('" . $data["account_id"] . "', '" . $data["weburl"] . "',
                '" . $data["currency"] . "') ON DUPLICATE KEY UPDATE weburl = '" . $data["weburl"] . "', currency = '" . $data["currency"] . "'");
            }
        }
    }
    
    function save_subaccount_data($data, $id = 0)
    {
        if ($id == 0) {
            $this->db->set($data);
            $this->db->insert('stripe_subaccount');
        } else {
            $this->db->where('id', $id);
            $this->db->update('stripe_subaccount', $data);
        }
    }
    
    function delete_subaccount_db_data($stripe_account_id)
    {
        $query = $this->db->query("UPDATE stripe_subaccount SET secret_key = '', publishable_key = '', account_id = '' WHERE account_id LIKE '" . $stripe_account_id . "'");
    }
    
    function create_subaccount($account_tbl_id = 0)
    {
        require_once (APPPATH . 'libraries/stripe/init.php');
        
        $stripe = $this->get_param_global();
        
        /*
         *
         * ======= GET PARTNER COUNTRY ===========
         *
         */
        $country = "";
        
        if ($account_tbl_id > 0) {
            $partner_id = $this->get_account_partner_id($account_tbl_id);
            
            $query = $this->db->query("SELECT country, country_2ch FROM partners WHERE id = " . $partner_id);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                
                if ($row->country_2ch != "") {
                    $country = $row->country_2ch;
                }
            }
        }
        
        /*
         *
         * ======= GET currency ===========
         *
         */
        $currency = "";
        if ($account_tbl_id > 0) {
            $account_data = $this->get_account_data($account_tbl_id);
            $currency = $account_data["currency"];
        }
        
        /*
         *
         * ======= GREATE ===========
         *
         */
        
        \Stripe\Stripe::setApiKey($stripe['secret_key']);
        
        $acct = \Stripe\Account::create(array(
            "country" => $country,
            "type" => "custom",
            "default_currency" => $currency
        ));
        $result = json_decode(json_encode($acct), 1);
        echo "CREATE SUBACCOUNT";
        echo "<pre>" . $acct->id . "<br>" . $acct->keys->secret;
        print_r($result);
        // die();
        var_dump($acct);
        
        /*
         *
         * ======= SAVE subaccount data in DB ===========
         *
         */
        
        if (isset($acct->id)) {
            $subaccount_data = array();
            $subaccount_data["account_id"] = $acct->id;
            $subaccount_data["secret_key"] = $acct->keys->secret;
            $subaccount_data["publishable_key"] = $acct->keys->publishable;
            
            $this->save_subaccount_data($subaccount_data, $account_tbl_id);
            
            return $acct->id;
        } else {
            return 0;
        }
    }
    
    function accept_subaccount($stripe_account_id)
    {
        require_once (APPPATH . 'libraries/stripe/init.php');
        
        $stripe = $this->Stripe->get_param_global();
        
        \Stripe\Stripe::setApiKey($stripe['secret_key']);
        
        $acct = \Stripe\Account::retrieve($stripe_account_id);
        $acct->tos_acceptance->date = time();
        $acct->tos_acceptance->ip = $_SERVER['REMOTE_ADDR'];
        $accept = $acct->save();
        echo "<pre>";
        echo "ACCEPT SUBACCOUNT";
        print_r($accept);
    }
    
    function update_subaccount($account_tbl_id, $account_id)
    {
        require_once (APPPATH . 'libraries/stripe/init.php');
        
        $stripe = $this->get_param_global();
        
        /*
         *
         * ======= GET currency ===========
         *
         */
        
        $account_data = $this->Stripe->get_account_data($account_tbl_id);
        $currency = $account_data["currency"];
        
        /*
         *
         * ======= UPDATE ===========
         *
         */
        
        \Stripe\Stripe::setApiKey($stripe['secret_key']);
        
        $acct = \Stripe\Account::retrieve($account_id);
        $acct->business_name = 'Test Company';
        $acct->default_currency = $currency;
        $acct->business_url = 'https://dc-booking-test-book.otelms.com/bookit/step1';
        $acct->business_primary_color = '#000000'; // dOES IT INFLUENCE ATHING?
        $acct->decline_charge_on = array(
            "avs_failure" => false,
            "cvc_failure" => true
        );
        // $acct->account_holder_type = 'individual';
        
        $acct->metadata = array(
            'hms_id' => '1918',
            'hotelix' => 'dc-booking-test'
        );
        $accept = $acct->save();
        echo "UPDATE SUBACCOUNT";
        echo "<pre>";
        print_r($accept);
    }
    
    public function delete_account($stripe_account_id)
    {
        require_once (APPPATH . 'libraries/stripe/init.php');
        
        $stripe = $this->Stripe->get_param_global();
        
        \Stripe\Stripe::setApiKey($stripe['secret_key']);
        
        $account = \Stripe\Account::retrieve($stripe_account_id);
        $delete_response = $account->delete();
        
        echo "<pre>";
        print_r($delete_response);
        
        /*
         * ===== DELETE SUBACCOUNT DATA FROM DB =====
         *
         */
        $this->delete_subaccount_db_data($stripe_account_id);
    }
    
    function updateOwner($data, $id)
    {
        $this->db->where('id', $id);
        $this->db->update('company_owners', $data);
    }
    
    function insertOwner($data)
    {
        $this->db->insert('company_owners', $data);
    }
    
    function delegation2currency($currency)
    {
        switch ($currency) {
            case "RUB":
                $way = "uk";
                break;
            case "UAH":
                $way = "uk";
                break;
            case "USD":
                $way = "us";
                break;
            case "PLN":
                $way = "us";
                break;
            case "GEL":
                $way = "us";
                break;
            default:
                $way = "uk";
                break;
        }
        
        return $way;
    }
    
    function save_stripe_logdata($data)
    {
        $sql = "INSERT INTO  stripe_log (tokken_id, opperation_type) VALUES('" . $data["tokken_id"] . "', '" . $data["opperation_type"] . "')";
        $query = $this->db->query($sql);
    }
    
    function get_stripe_acquiring_available_in_country($id_country_3c) {
        //return 1 - ok,Accept payments; 0 - NOT Accept payments
        $is_allowed = 0;
        $allowed_countries_arr = array('AUS',
            'AUT',
            'BEL',
            'CAN',
            'DNK',
            'EST',
            'FIN',
            'FRA',
            'DEU',
            'GRC',
            'HKG',
            'IRL',
            'ITA',
            'JPN',
            'LVA',
            'LTU',
            'LUX',
            'MYS',
            'NLD',
            'NZL',
            'NOR',
            'POL',
            'PRT',
            'SGP',
            'SVK',
            'SVN',
            'ESP',
            'SWE',
            'CHE',
            'GBR',
            'USA',
            'BRA',
            'IND',
            'MEX');
        if(in_array($id_country_3c, $allowed_countries_arr)) {
            $is_allowed = 1;
        }
        return $is_allowed;
    }
}
?>