<?php
class Report_model extends CI_Model {

    function __construct()
    {
        parent::__construct();
		$this->load->model('loger');
	}

	function Balance($id){

		$reservation = array();
		$paymentList = array();
		$ChargeList = array();
		$RefundList = array();
		$ServicesList = array();
		$ServicesMainList = array();
		$DiscountList = array();
		$sql = "SELECT guests.*, deskofreservation.cancel, deskofreservation.datein, deskofreservation.dateout, deskofreservation.duration, deskofreservation.cancel, deskofreservation.amount, deskofreservation.discount, deskofreservation.id as reservation_id, rooms.name as room_name, categories.name as categories_name FROM guests INNER JOIN deskofreservation ON deskofreservation.guest_id=guests.id INNER JOIN rooms ON rooms.id=deskofreservation.room_id INNER JOIN categories ON categories.id=deskofreservation.type_id WHERE deskofreservation.deleted=0  AND deskofreservation.id = $id ORDER by guests.id ASC";
		//echo $sql;

		$query = $this->db->query ( "SELECT guests.*, deskofreservation.datein, deskofreservation.dateout, deskofreservation.duration, deskofreservation.cancel, deskofreservation.amount, deskofreservation.discount, deskofreservation.id as reservation_id, rooms.name as room_name, categories.name as categories_name FROM guests INNER JOIN deskofreservation ON deskofreservation.guest_id=guests.id INNER JOIN rooms ON rooms.id=deskofreservation.room_id INNER JOIN categories ON categories.id=deskofreservation.type_id WHERE deskofreservation.deleted=0  AND deskofreservation.id = $id ORDER by guests.id ASC" );
		$payment = 0;
		foreach ( $query->result () as $row ) {
			$cancel = $row->cancel;
			$query2 = $this->db->query ( "SELECT guests.*, payment_types.name, payment.create_time, payment.amount as total, payment.id as id_payment, rooms.name as room_name, categories.name as categories_name FROM guests INNER JOIN deskofreservation ON deskofreservation.guest_id=guests.id INNER JOIN rooms ON rooms.id=deskofreservation.room_id INNER JOIN categories ON categories.id=deskofreservation.type_id INNER JOIN payment ON payment.reservation_id = deskofreservation.id  INNER JOIN payment_types ON payment_types.id = payment.type WHERE deskofreservation.deleted=0 AND deskofreservation.id = $row->reservation_id ORDER by guests.id ASC" );
			foreach ( $query2->result () as $row2 ) {
				$payment += $row2->total;
				$payment_type = "<b>оплата</b>";
			}
			$refund = 0;
			$query2 = $this->db->query ( "SELECT guests.*, deskofreservation.id as res_id,  payment_types.name as payment_name, refund.id as refund_id, refund.time as refund_time, refund.amount, rooms.name as room_name, categories.name as categories_name FROM guests INNER JOIN deskofreservation ON deskofreservation.guest_id=guests.id INNER JOIN rooms ON rooms.id=deskofreservation.room_id INNER JOIN categories ON categories.id=deskofreservation.type_id INNER JOIN refund ON refund.reservation_id = deskofreservation.id INNER JOIN  payment_types ON  payment_types.id = refund.type WHERE deskofreservation.deleted=0 AND deskofreservation.id = $row->reservation_id ORDER by guests.id ASC" );
			foreach ( $query2->result () as $row2 ) {

				$refund += $row2->amount;
				$payment_type = "<b>возврат</b>";

			}
			$service = 0;
			$query2 = $this->db->query ( "SELECT guests.*, deskofreservation.id as res_id,  services_types.name as services_name, services.id as services_id, services.description as services_description, services.time as services_time, services.amount, rooms.name as room_name, categories.name as categories_name FROM guests INNER JOIN deskofreservation ON deskofreservation.guest_id=guests.id INNER JOIN rooms ON rooms.id=deskofreservation.room_id INNER JOIN categories ON categories.id=deskofreservation.type_id INNER JOIN services ON services.reservation_id = deskofreservation.id INNER JOIN  services_types ON  services_types.id = services.type WHERE deskofreservation.deleted=0 AND deskofreservation.id = $row->reservation_id ORDER by deskofreservation.id ASC" );
			foreach ( $query2->result () as $row2 ) {

				$service += $row2->amount;


			}
			$query2 = $this->db->query ( "SELECT guests.*, deskofreservation.id as res_id,  services_types_main.name as services_name, services_main.id as services_id, services_main.description as services_main_description, services_main.time as services_time, services_main.amount FROM guests INNER JOIN deskofreservation ON deskofreservation.guest_id=guests.id INNER JOIN rooms ON rooms.id=deskofreservation.room_id INNER JOIN categories ON categories.id=deskofreservation.type_id INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id INNER JOIN  services_types_main ON  services_types_main.id = services_main.type WHERE services_main.type = 1 AND deskofreservation.deleted=0 AND deskofreservation.id = $row->reservation_id ORDER by deskofreservation.id ASC" );
			foreach ( $query2->result () as $row2 ) {
				$service += $row2->amount;

			}
			$cancelation_payment_sum = 0;
			$query2 = $this->db->query ( "SELECT guests.*, deskofreservation.id as res_id,  services_types_main.name as services_name, services_main.id as services_id, services_main.description as services_main_description, services_main.time as services_time, services_main.amount FROM guests INNER JOIN deskofreservation ON deskofreservation.guest_id=guests.id INNER JOIN rooms ON rooms.id=deskofreservation.room_id INNER JOIN categories ON categories.id=deskofreservation.type_id INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id INNER JOIN  services_types_main ON  services_types_main.id = services_main.type WHERE services_main.type = 2 AND deskofreservation.deleted=0 AND deskofreservation.id = $row->reservation_id ORDER by deskofreservation.id ASC" );
			foreach ( $query2->result () as $row2 ) {

				$cancelation_payment_sum += $row2->amount;

			}
			$discount = 0;
			$query2 = $this->db->query ( "SELECT guests.*, deskofreservation.id as res_id,  discount_types.name as discount_name, discount.id as discount_id, discount.description as discount_description, discount.time as discount_time, discount.amount FROM guests INNER JOIN deskofreservation ON deskofreservation.guest_id=guests.id INNER JOIN rooms ON rooms.id=deskofreservation.room_id INNER JOIN categories ON categories.id=deskofreservation.type_id LEFT JOIN discount ON discount.reservation_id = deskofreservation.id INNER JOIN  discount_types ON  discount_types.id = discount.type WHERE deskofreservation.deleted=0 AND deskofreservation.id = $row->reservation_id ORDER by deskofreservation.id ASC" );
			foreach ( $query2->result () as $row2 ) {

				$discount += $row2->amount;


			}

			$charge = 0;
			$query3 = $this->db->query ( "SELECT id, amount FROM services_main WHERE reservation_id=$row->reservation_id" );
			$sql = "SELECT id, amount FROM services_main WHERE reservation_id=$row->reservation_id";
			//echo $sql;
			$cancel_verification = '<a href="#" onClick="ConfirmChoice(1)">Отменить бронь</a>';

			if (($cancel == 1))
			{
				//echo "+++++++";
				$cancel_verification = '<a href="#" onClick="ConfirmChoice(3)">Востановить бронь</a>';
			}

			if ($row->cancel == 0){
				$temp = ($row->amount - $discount)*1;
				$amount = $row->amount;
			}else{
				$temp = ($row->amount - $discount)*0;
				$amount = 0;
			}

			if ($row->cancel == 0){
				$balance =($payment - $refund) - $cancelation_payment_sum - ($service - $discount);
			}else{
				//$balance = $temp - $payment + $refund + $cancelation_payment_sum+$service;
				$balance = ($payment - $refund) - $cancelation_payment_sum - ($service - $discount);
			}
			return $balance;

		}
	}

	function data_by_sources($startdate, $enddate) {
	    $result_array = array();
	    list ( $year, $month, $day ) = explode ( "-", $startdate );
	    $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	    list ( $year, $month, $day ) = explode ( "-", $enddate );
	    $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	    //echo date ( "Y-m-d", 17471 * 86400 )."<br>";
	    $sql = "SELECT  deskofreservation.id_dealer, dealers.name as dealer_name, deskofdays.intdate, COUNT(1) as count,
						SUM(deskofreservation.amount / deskofreservation.duration) as amount
	    FROM deskofreservation
	    INNER JOIN deskofdays ON deskofdays.reservation_id = deskofreservation.id
	    INNER JOIN dealers ON dealers.id = deskofreservation.id_dealer
	    WHERE deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout
	    AND deskofreservation.deleted <> 1 AND deskofreservation.cancel <> 1 GROUP BY deskofreservation.id_dealer, deskofdays.intdate";

	    $query = $this->db->query ( $sql );
	    //echo $sql;
	    //die();

	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {

	            if (!isset($result_array["count2day_total"]["data"][$row->id_dealer]["total"])) {
	                $result_array["count2day_total"]["data"][$row->id_dealer]["name"] = $row->dealer_name;
	                $result_array["count2day_total"]["data"][$row->id_dealer]["total"] = 0;
	                $result_array["count2day_total"]["Date_period"] = $startdate." - ".$enddate;
	            }

	            if (!isset($result_array["amount2day_total"]["data"][$row->id_dealer]["total"])) {
	                $result_array["amount2day_total"]["data"][$row->id_dealer]["name"] = $row->dealer_name;
	                $result_array["amount2day_total"]["data"][$row->id_dealer]["total"] = 0;
	                $result_array["amount2day_total"]["Date_period"] = $startdate." - ".$enddate;
	            }
	            $result_array["count2day"]["data"][$row->id_dealer]["name"] = $row->dealer_name;
	            $result_array["count2day"]["data"][$row->id_dealer]["itelms"][$row->intdate]["day"] = date ( "Y-m-d", $row->intdate * 86400 );
	            $result_array["count2day"]["data"][$row->id_dealer]["itelms"][$row->intdate]["value"] = (int)$row->count;
	            $result_array["count2day"]["Date_period"] = $startdate." - ".$enddate;

	            $result_array["count2day_total"]["data"][$row->id_dealer]["total"] += (int)$row->count;

	            $result_array["amount2day"]["data"][$row->id_dealer]["name"] = $row->dealer_name;
	            $result_array["amount2day"]["data"][$row->id_dealer]["itelms"][$row->intdate]["day"] = date ( "Y-m-d", $row->intdate * 86400 );
	            $result_array["amount2day"]["data"][$row->id_dealer]["itelms"][$row->intdate]["value"] = (int)$row->amount;
	            $result_array["amount2day"]["Date_period"] = $startdate." - ".$enddate;

	            $result_array["amount2day_total"]["data"][$row->id_dealer]["total"] += $row->amount;
	        }
	    }

	    for($i = $intdatein; $i <= $intdateout; $i++){
	        foreach($result_array["count2day"]["data"] as $id_dealer => $cell){
	            if(!isset($result_array["count2day"]["data"][$id_dealer]["itelms"][$i])){
	                $result_array["count2day"]["data"][$id_dealer]["itelms"][$i]["day"] = date ( "Y-m-d", $i * 86400 );
	                $result_array["count2day"]["data"][$id_dealer]["itelms"][$i]["value"] = 0;
	            }
	        }
	    }

	    for($i = $intdatein; $i <= $intdateout; $i++){
	        foreach($result_array["amount2day"]["data"] as $id_dealer => $cell){
	            if(!isset($result_array["amount2day"]["data"][$id_dealer]["itelms"][$i])){
	                $result_array["amount2day"]["data"][$id_dealer]["itelms"][$i]["day"] = date ( "Y-m-d", $i * 86400 );
	                $result_array["amount2day"]["data"][$id_dealer]["itelms"][$i]["value"] = 0;
	            }
	        }
	    }
	    return $result_array;
	}

	function get_linegraph_draw_data($data, $unique_div_id = ""){
		$graf_data = array();
		$sources_arr = array();
		array_push($sources_arr, "Date");
		foreach ($data['data'] as $source){
			array_push($sources_arr, $source['name']);
			foreach ($source['itelms'] as $date_key => $date){
				if (!isset($graf_data[$date_key])){
					$graf_data[$date_key] = array();
					array_push($graf_data[$date_key], $date['day']);
				}
				array_push($graf_data[$date_key], $date['value']);
			}
		}
		array_unshift ( $graf_data, $sources_arr );
		$graf_data = json_encode ( $graf_data, true );
		$graph_html = "";
		$graph_html .= '<p class="titlegrafic text-center fs-17">' . $data["Date_period"] . '</p><div id="'.$unique_div_id.'"></div>';
		$graph_html .="<script type='text/javascript'>
					google.charts.load('current', {packages: ['corechart']});
					google.charts.setOnLoadCallback(drawChart);
      function drawChart() {
        var data = google.visualization.arrayToDataTable(".$graf_data.");
        var options = {
          width: $(".'"#'.$unique_div_id.'"'.").width(),
          height: 330,
          curveType: 'function',
          //{graf_options}
          legend: { position: 'side' },
          focusTarget : 'category',
          tooltip: {trigger: 'selection'},
          aggregationTarget: 'none',
          vAxis : {minValue : '0'}
        };
        var chart = new google.visualization.LineChart(document.getElementById('".$unique_div_id."'));
        chart.draw(data, options);
      }
	</script>";
		return $graph_html;
	}

	function get_piegraph_draw_data($data, $div_id_name = ""){
		$graf_data = array();
 		array_push($graf_data, array('SOUCES', "COUNT PER PERIOD"));
		foreach ($data ['data'] as $node){
			array_push($graf_data, array($node['name'], $node['total']));
		}
// 		echo "<pre>";
// 		print_r($graf_data);
// 		die('report_model DIE');
		$graf_data = json_encode ( $graf_data, true );
		$graph_html = "";
		$unique_div_id = $div_id_name;
		$graph_html .= '<p class="titlegrafic text-center fs-17">' . $data["Date_period"] . '</p><div id="'.$unique_div_id.'"></div>';
		$graph_html .="<script type='text/javascript'>
						google.charts.load('current', {packages: ['corechart']});
						google.charts.setOnLoadCallback(drawChart);
      function drawChart() {
        var data = google.visualization.arrayToDataTable(".$graf_data.");
		var options = {
	          title: '',
			  width: 550,
	          height: 330,
	       		is3D: true,
        };
        var chart = new google.visualization.PieChart(document.getElementById('".$unique_div_id."'));
        chart.draw(data, options);
      }
	</script>";
		return $graph_html;
	}

	function get_columngraph_draw_data($data, $div_id_name = ""){
		$graf_data = array();
		array_push($graf_data, array('SOUCES', "Value"));
		foreach ($data ['data'] as $node){
			array_push($graf_data, array($node['name'], $node['total']));
		}
		// 		echo "<pre>";
		// 		print_r($graf_data);
		// 		die('report_model DIE');
		$graf_data = json_encode ( $graf_data, true );
		$graph_html = "";
		$unique_div_id = $div_id_name;
		$graph_html .= '<p class="titlegrafic text-center fs-17">' . $data["Date_period"] . '</p><div id="'.$unique_div_id.'"></div>';
		$graph_html .="<script type='text/javascript'>
						google.charts.load('current', {packages: ['corechart']});
						google.charts.setOnLoadCallback(drawChart);
      function drawChart() {
        var data = google.visualization.arrayToDataTable(".$graf_data.");
		var options = {
        	  legend : {position : 'none'},
	          title: '',
			  width: $(".'"#'.$unique_div_id.'"'.").width(),
	          height: 330,
        };
        var chart = new google.visualization.ColumnChart(document.getElementById('".$unique_div_id."'));
        chart.draw(data, options);
      }
	</script>";
		return $graph_html;
	}

	public function Get_Demographic_ChartsData($props) { // array('date' => $date, 'shift' => $period_shift)
        $ChartsSet = array(
            'Ages',
            'Check',
            'GenderShift',
            'Gender',
            'ChildrenShift',
            'Children',
            'Stay',
            'Citizenship',
            'Rooms'
        );
        $Charts = (object) array();
        foreach ($ChartsSet as $Chart) {
            $Charts->$Chart = (object) array();
        }

	    $date = explode(" - ", $props['date']);
	    $start_date = trim($date[0]);
	    $end_date = trim($date[1]);
	    $shift = $props['shift'];
	    $start_date_shift = date('Y-m-d', strtotime("$start_date -$shift days"));
	    $end_date_shift = date('Y-m-d', strtotime("$end_date -$shift days"));

	    $base_res = $this->Get_Demographic_Result_by_period($start_date, $end_date);
	    $shift_res = $this->Get_Demographic_Result_by_period($start_date_shift, $end_date_shift);
	    $affected_rooms = $base_res->rooms->affected_rooms + $shift_res->rooms->affected_rooms;
	    ksort($affected_rooms);

// 	    echo "<pre>";
// 	    print_r($base_res);
// 	    print_r($shift_res);
// 	    die("DIED by A Department at report_model.php Get_Demographic_ChartsData() on 1 окт. 2021 г. 21:06:52");

	    $ages_periods = $this->Get_Demographic_Ages_Periods();
	    if (isset($base_res->guests_ages['{caption_undefined}']) || isset($shift_res->guests_ages['{caption_undefined}'])){
	        $ages_periods->labels += array('{caption_undefined}' => '{caption_undefined}');
	    }
// 	    if (isset($base_res->guests_ages['{clt_out_of_ranges}']) || isset($shift_res->guests_ages['{clt_out_of_ranges}'])){
// 	        $ages_periods->labels += array('{clt_out_of_ranges}' => '{clt_out_of_ranges}');
// 	    }
	    //=============== Ages Chart &&  Stay Chart && Rooms Chart Data Prepare =================================================
	    $Charts->Ages->series_data =  (object)array('base' => array(), 'shift' => array());
	    $Charts->Stay->series_data =  (object)array('base' => array(), 'shift' => array());
	    $Charts->Rooms->series_data =  (object)array('base' => array(), 'shift' => array());
	    $Charts->Check->series_data =  (object)array('base' => array(), 'shift' => array());
	    foreach ($ages_periods->labels as $margin => $value) {
	        $Charts->Ages->series_data->base[$margin] = isset($base_res->guests_ages[$margin]) ? $base_res->guests_ages[$margin] : '';
	        $Charts->Ages->series_data->shift[$margin] = isset($shift_res->guests_ages[$margin]) ? $shift_res->guests_ages[$margin] : '';
	        $Charts->Stay->series_data->base[$margin] = isset($base_res->avg_stays[$margin]) ? $base_res->avg_stays[$margin] : '';
	        $Charts->Stay->series_data->shift[$margin] = isset($shift_res->avg_stays[$margin]) ? $shift_res->avg_stays[$margin] : '';
	        $Charts->Check->series_data->base[$margin] = isset($base_res->avg_check[$margin]) ? $base_res->avg_check[$margin]['avg_amount'] : '';
	        $Charts->Check->series_data->shift[$margin] = isset($shift_res->avg_check[$margin]) ? $shift_res->avg_check[$margin]['avg_amount'] : '';

            foreach ($affected_rooms as $cat_id => $cat_name) {
                if (!isset($Charts->Rooms->series_data->base[$cat_id])){
                    $Charts->Rooms->series_data->base[$cat_id] = (object)array('stack'=>'base','name'=>$cat_name, 'data' => array());
                }
                $push_value = isset($base_res->rooms->counts_by_margins[$margin][$cat_id]) ? $base_res->rooms->counts_by_margins[$margin][$cat_id] : '';
                array_push($Charts->Rooms->series_data->base[$cat_id]->data, $push_value);

                if (!isset($Charts->Rooms->series_data->shift[$cat_id])){
                    $Charts->Rooms->series_data->shift[$cat_id] = (object)array('stack'=>'shift','name'=>$cat_name, 'data' => array());
                }
                $push_value = isset($shift_res->rooms->counts_by_margins[$margin][$cat_id]) ? $shift_res->rooms->counts_by_margins[$margin][$cat_id] : '';
                array_push($Charts->Rooms->series_data->shift[$cat_id]->data, $push_value);
            }
	    }
	    $Charts->Ages->xData = $Charts->Stay->xData = $Charts->Rooms->xData = $Charts->Check->xData= array_values($ages_periods->labels);
	    $Charts->Ages->legend = $Charts->Stay->legend = $Charts->Check->legend = array("$start_date_shift - $end_date_shift", "$start_date - $end_date");

	    $Charts->Ages->series_data->base = array_values($Charts->Ages->series_data->base);
	    $Charts->Ages->series_data->shift = array_values($Charts->Ages->series_data->shift);

	    $Charts->Stay->series_data->base = array_values($Charts->Stay->series_data->base);
	    $Charts->Stay->series_data->shift = array_values($Charts->Stay->series_data->shift);

	    $Charts->Check->series_data->base = array_values($Charts->Check->series_data->base);
	    $Charts->Check->series_data->shift = array_values($Charts->Check->series_data->shift);

	    $Charts->Rooms->series_data->base = array_values($Charts->Rooms->series_data->base);
	    $Charts->Rooms->series_data->shift = array_values($Charts->Rooms->series_data->shift);

	    //============================ Gender Chart Data Prepare ========================================================
	    $Genders_Types = $this->Get_Guests_Genders_Types();
	    $Charts->Gender->titletext = "$start_date - $end_date";
	    $Charts->Gender->series_data = array();
	    $Charts->GenderShift->titletext = "$start_date_shift - $end_date_shift";
	    $Charts->GenderShift->series_data = array();
	    foreach ($Genders_Types as $gender_type => $gender_type_name) {
	        if (isset($base_res->guests_genders[$gender_type])){
	            array_push($Charts->Gender->series_data, array('value' => $base_res->guests_genders[$gender_type], 'name' => $gender_type_name));
	        }
	        if (isset($shift_res->guests_genders[$gender_type])){
	            array_push($Charts->GenderShift->series_data, array('value' => $shift_res->guests_genders[$gender_type], 'name' => $gender_type_name));
	        }
	    }

	    //============================ Citizenship Chart Data && Legend Prepare ========================================================
	    function sort_by_count($x, $y) {
	        return ($x['count'] < $y['count']);
	    }
	    uasort ($base_res->citizenships, 'sort_by_count');
	    $max_countries_in_legend = 10;
	    $Charts->CitizenshipLegend = array(
	        'title' => "$start_date - $end_date",
	        'total_guests' => array(),
	        'guests_by_gender' => array(),
	        'countries' => array(),
	    );
	    $Charts->Citizenship = array(array('{clt_country}', '{clt_guests_count}'));
	    $system_lang = strtoupper($_SESSION['user']['language']);
	    $legend_country_fild_lang = $system_lang == 'RUS' ? 'name_rus' : 'name_lat';
	    foreach ($base_res->citizenships as $country_2ch => $country_set) {
	        if (!$max_countries_in_legend) break;
	        if ($country_2ch != ''){
	            array_push($Charts->Citizenship, array($country_set['name_lat'], $country_set['count']));
	            $name_for_legend = $country_set[$legend_country_fild_lang];
	        }else{
	            $name_for_legend = '{caption_undefined}';
	        }

	        $res_percentaging = $this->make_difference_values_percentage_cell_style($country_set['count'], isset($shift_res->citizenships[$country_2ch]) ? $shift_res->citizenships[$country_2ch]['count'] : 0);
	        $res_percentaging['name'] = $name_for_legend;

	        array_push($Charts->CitizenshipLegend['countries'], $res_percentaging);
	        $max_countries_in_legend --;
	    }

	    $base_total_guests = $shift_total_guests = 0;
	    foreach ($Genders_Types as $gender_type => $gender_type_name) {
	        $base_gender_count = isset($base_res->genders_for_citizenship_legend[$gender_type]) ? $base_res->genders_for_citizenship_legend[$gender_type] : 0;
	        $base_total_guests += $base_gender_count;
	        $shift_gender_count = isset($shift_res->genders_for_citizenship_legend[$gender_type]) ? $shift_res->genders_for_citizenship_legend[$gender_type] : 0;
	        $shift_total_guests += $shift_gender_count;
	        $res_percentaging = $this->make_difference_values_percentage_cell_style($base_gender_count, $shift_gender_count);
	        $res_percentaging['gender_name'] = $gender_type_name;
	        array_push($Charts->CitizenshipLegend['guests_by_gender'], $res_percentaging);
	    }
	    $res_percentaging = $this->make_difference_values_percentage_cell_style($base_total_guests, $shift_total_guests);
	    array_push($Charts->CitizenshipLegend['total_guests'], $res_percentaging);

	    return $Charts;
	}

	private function Get_Demographic_Result_by_period($start_date, $end_date) {
	    $result = (object)array();
	    $sql = "
        SELECT SQL_CALC_FOUND_ROWS t2.id AS guest_id, t2.dob, t2.gender, t2.citizenship_code,
                	    t3.duration, t3.amount,
                	    t4.id AS cat_id, t4.shortname AS cat_name,
                	    t5.NAME_LAT AS name_lat, t5.NAME AS name_rus, t5.id_2ch AS country_2ch
	    FROM guests_deskofreservation AS t1
	    JOIN guests AS t2 ON t2.id = t1.guest_id
	    JOIN deskofreservation AS t3 ON t3.id = t1.reservation_id
	    JOIN rooms ON t3.room_id = rooms.id
	    JOIN categories AS t4 ON rooms.category_id = t4.id
	    LEFT JOIN global_fms_base.dict_country AS t5 ON t5.id= t2.citizenship_code
	    WHERE (t3.datein <= '$end_date 23:59:59') AND (t3.dateout >= '$start_date 00:00:00') AND t3.cancel = 0 AND t3.deleted = 0
        ";
	    $query_result = $this->db->query ( $sql )->result();
	    $query_affected = $this->db->query ( 'SELECT FOUND_ROWS() AS count_rows' )->row();// SQL_CALC_FOUND_ROWS
	    $total_guests = $query_affected->count_rows;

	    $guests_ages_counts_by_margins = array();
	    $avg_stays_counts_by_margins = array();
	    $rooms_counts_by_margins = array();
	    $guests_genders_counts = array();
	    $affected_rooms = array();
	    $citizenships = array();
	    $ages_periods = $this->Get_Demographic_Ages_Periods();
	    $now = new DateTime('now');

	    foreach ($query_result as $set) {
	        if (! isset($affected_rooms[$set->cat_id])) {
	            $affected_rooms[$set->cat_id] = $set->cat_name;
	        }
	        if (! isset($citizenships[$set->country_2ch])) {
	            $citizenships[$set->country_2ch]['count'] = 1;
	            $citizenships[$set->country_2ch]['name_lat'] = $set->name_lat;
	            $citizenships[$set->country_2ch]['name_rus'] = $set->name_rus;
	            $citizenships[$set->country_2ch]['name_native'] = $set->name_rus;

	        } else {
	            $citizenships[$set->country_2ch]['count'] ++;
	        }
        //============== Age Periods Margins Analiser ==========================================
	        $dob = new DateTime($set->dob);
	        $guest_age = $dob->diff($now)->format('%y');
	        if ($set->dob != '0000-00-00'){// && $guest_age >= $ages_periods->min_margin && $guest_age <= $ages_periods->max_margin
	            foreach ($ages_periods->margins as $key => $margin) {
	                if (!isset($ages_periods->margins[$key+1]) || $guest_age >= $margin && $guest_age < $ages_periods->margins[$key+1]){
                        if (! isset($guests_ages_counts_by_margins[$margin])) {
                            $guests_ages_counts_by_margins[$margin] = 1;
                        } else {
                            $guests_ages_counts_by_margins[$margin] ++;
                        }
                        if (! isset($avg_stays_counts_by_margins[$margin])) {
                            $avg_stays_counts_by_margins[$margin] = $set->duration;
                        } else {
                            $avg_stays_counts_by_margins[$margin] += $set->duration;
                        }
                        if (! isset($rooms_counts_by_margins[$margin])) {
                            $rooms_counts_by_margins[$margin] = array();
                        }
                        if (! isset($rooms_counts_by_margins[$margin][$set->cat_id])) {
                            $rooms_counts_by_margins[$margin][$set->cat_id] = 1;
                        } else {
                            $rooms_counts_by_margins[$margin][$set->cat_id] ++;
                        }
                        break;
	                }
	            }
	        }else{
// 	            if ($set->dob == '0000-00-00') {
	                if (! isset($guests_ages_counts_by_margins['{caption_undefined}'])) {
	                    $guests_ages_counts_by_margins['{caption_undefined}'] = 1;
	                } else {
	                    $guests_ages_counts_by_margins['{caption_undefined}'] ++;
	                }
	                if (! isset($avg_stays_counts_by_margins['{caption_undefined}'])) {
	                    $avg_stays_counts_by_margins['{caption_undefined}'] = $set->duration;
	                } else {
	                    $avg_stays_counts_by_margins['{caption_undefined}'] += $set->duration;
	                }
	                if (! isset($rooms_counts_by_margins['{caption_undefined}'])) {
	                    $rooms_counts_by_margins['{caption_undefined}'] = array();
	                }
	                if (! isset($rooms_counts_by_margins['{caption_undefined}'][$set->cat_id])) {
	                    $rooms_counts_by_margins['{caption_undefined}'][$set->cat_id] = 1;
	                } else {
	                    $rooms_counts_by_margins['{caption_undefined}'][$set->cat_id] ++;
	                }
// 	            }else {
// 	                if (! isset($guests_ages_counts_by_margins['{clt_out_of_ranges}'])) {
// 	                    $guests_ages_counts_by_margins['{clt_out_of_ranges}'] = 1;
// 	                } else {
// 	                    $guests_ages_counts_by_margins['{clt_out_of_ranges}'] ++;
// 	                }
// 	                if (! isset($avg_stays_counts_by_margins['{clt_out_of_ranges}'])) {
// 	                    $avg_stays_counts_by_margins['{clt_out_of_ranges}'] = $set->duration;
// 	                } else {
// 	                    $avg_stays_counts_by_margins['{clt_out_of_ranges}'] += $set->duration;
// 	                }
// 	                if (! isset($rooms_counts_by_margins['{clt_out_of_ranges}'])) {
// 	                    $rooms_counts_by_margins['{clt_out_of_ranges}'] = array();
// 	                }
// 	                if (! isset($rooms_counts_by_margins['{clt_out_of_ranges}'][$set->cat_id])) {
// 	                    $rooms_counts_by_margins['{clt_out_of_ranges}'][$set->cat_id] = 1;
// 	                } else {
// 	                    $rooms_counts_by_margins['{clt_out_of_ranges}'][$set->cat_id] ++;
// 	                }
// 	            }
	        }
	        //============== Gender Analiser ==========================================
	        if (!isset($guests_genders_counts[$set->gender])){
	            $guests_genders_counts[$set->gender] = 1;
	        }else{
	            $guests_genders_counts[$set->gender] ++;
	        }
	    }

	    foreach ($rooms_counts_by_margins as $period => &$rooms_set) {
	        foreach ($rooms_set as $room_id => $value) {
	            $rooms_set[$room_id] = round($value / $guests_ages_counts_by_margins[$period] * 100, 2);
	        }
	    }
	    unset($rooms_set);

	    foreach ($avg_stays_counts_by_margins as $period => &$period_value) {
	        $period_value = round($period_value / $guests_ages_counts_by_margins[$period], 0);
	    }
	    unset($period_value);

	    foreach ($guests_ages_counts_by_margins as &$period_value) {//percentaging values
	        $period_value = round($period_value  * 100/ $total_guests, 2);
	    }
	    unset($period_value);

	    $genders_for_citizenship_legend = $guests_genders_counts;
	    foreach ($guests_genders_counts as &$period_value) {//percentaging values but before fill citizenship legend!
	        $period_value = round($period_value / $total_guests * 100, 2);
	    }
	    unset($period_value);

	    //============== Avg Check Getter && Analiser ==========================================
	    $sql = "
	    SELECT t1.amount, t2.dob
	    FROM deskofreservation AS t1
	    JOIN guests AS t2 ON t2.id = t1.guest_id
	    WHERE (t1.datein <= '$end_date 23:59:59') AND (t1.dateout >= '$start_date 00:00:00') AND t1.cancel = 0 AND t1.deleted = 0
	    ";
	    $query_result = $this->db->query ( $sql )->result();
	    $query_affected = $this->db->query ( 'SELECT FOUND_ROWS() AS count_rows' )->row();// SQL_CALC_FOUND_ROWS
	    //$total_customers = $query_affected->count_rows;
	    $avg_check_amounts_by_margins = array();




	    foreach ($query_result as $set) {
	        $dob = new DateTime($set->dob);
	        $customer_age = $dob->diff($now)->format('%y');
	        if ($set->dob != '0000-00-00'){
	            foreach ($ages_periods->margins as $key => $margin) {
	                if (!isset($ages_periods->margins[$key+1]) || $customer_age >= $margin && $customer_age < $ages_periods->margins[$key+1]){
	                    if (! isset($avg_check_amounts_by_margins[$margin])) {
	                        $avg_check_amounts_by_margins[$margin] = array('sum_amount'=>$set->amount, 'customers'=>1);
	                    } else {
	                        $avg_check_amounts_by_margins[$margin]['customers'] ++;
	                        $avg_check_amounts_by_margins[$margin]['sum_amount'] += $set->amount;
	                    }
	                    break;
	                }
	            }
	        }else{
	            if (! isset($avg_check_amounts_by_margins['{caption_undefined}'])) {
	                $avg_check_amounts_by_margins['{caption_undefined}'] = array('sum_amount'=>$set->amount, 'customers'=>1);
	            } else {
	                $avg_check_amounts_by_margins['{caption_undefined}']['customers'] ++;
	                $avg_check_amounts_by_margins['{caption_undefined}']['sum_amount'] += $set->amount;
	            }
	        }
	    }

	    foreach ($avg_check_amounts_by_margins as &$check_set) {
	        $check_set['avg_amount']  = round($check_set['sum_amount'] / $check_set['customers']);
	    }
	    unset($check_set);






	    $result->guests_ages = $guests_ages_counts_by_margins;
	    $result->guests_genders = $guests_genders_counts;
	    $result->avg_stays = $avg_stays_counts_by_margins;
	    $result->rooms->counts_by_margins = $rooms_counts_by_margins;
	    $result->rooms->affected_rooms = $affected_rooms;
	    $result->citizenships = $citizenships;
	    $result->genders_for_citizenship_legend = $genders_for_citizenship_legend;
	    $result->avg_check = $avg_check_amounts_by_margins;

	    return $result;
	}

	public function Get_Demographic_Ages_Periods() {
	    $margins = array(0, 18, 25, 35, 45, 55, 65);
	    $ages_periods = (object)array();
	    $ages_periods_txts = array();
	    foreach ($margins as $key => $margin) {
	        if (isset($margins[$key+1])){
	            $ages_periods_txts[$margin] = $key == 0 ? "$margin-" . $margins[$key+1] : $margin+1 . "-" . $margins[$key+1];
	        }else{
	            $ages_periods_txts[$margin] = $margin+1 ." >";
	        }
	    }
	    $ages_periods->labels = $ages_periods_txts;
	    $ages_periods->margins = $margins;
	    $ages_periods->min_margin = $margins[0];
	    $ages_periods->max_margin = $margins[count($margins)-1];
	    return $ages_periods;
	}

	public function Get_Guests_Genders_Types() {
	    $gender_types = array('{caption_undefined}', '{caption_men}', '{caption_women}');
	    return $gender_types;
	}

	public function make_difference_values_percentage_cell_style ($base_val, $shift_val){
	    if ($shift_val == 0 && $base_val == 0 || $shift_val == $base_val) {
	        $arrow = '';
	        $style = '';
	        $diff = '';
	    }else{
	        $diff = abs($base_val) - abs($shift_val);
	        $shift_val = $shift_val == 0 ? $base_val : $shift_val;
	        if ($diff > 0){
	            $arrow = 'fa fa-arrow-up';//fa fa-arrow-down//fa fa-caret-up st-caret-up //fa-arrow-long-down
	            $style = 'green';
	            $diff = ceil(abs($diff/$shift_val)*100).'%';
	        }else{
	            $arrow = 'fa fa-arrow-down';//  fa-arrow-long-down fa-caret-down
	            $style = 'red';
	            $diff = ceil(abs($diff/$shift_val)*100).'%';
	        }
	    }
	    $res_arr = array (
	        'value' => $base_val,
	        'diff_percent' => $diff,
	        'style' => $style,
	        'arrow' => $arrow
	    );
	    return $res_arr;
	}

	function get_demographic_data($startdate, $enddate){
		$result_array = array();
		list ( $year, $month, $day ) = explode ( "-", $startdate );
		$intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $enddate );
		$intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

		$sql = "SELECT  SUM(IF(guests.gender = 1, 1, 0)) as count_mans, SUM(IF(guests.gender = 2, 1, 0)) as count_womens,
				SUM(IF((TIMESTAMPDIFF(YEAR,guests.dob,curdate())) <= 18, 1, 0)) as count_18,
				SUM(IF((TIMESTAMPDIFF(YEAR,guests.dob,curdate())) > 18 AND (TIMESTAMPDIFF(YEAR,guests.dob,curdate())) <= 21, 1, 0)) as count_21,
				SUM(IF((TIMESTAMPDIFF(YEAR,guests.dob,curdate())) > 21 AND (TIMESTAMPDIFF(YEAR,guests.dob,curdate())) <= 35, 1, 0)) as count_35,
				SUM(IF((TIMESTAMPDIFF(YEAR,guests.dob,curdate())) > 35 AND (TIMESTAMPDIFF(YEAR,guests.dob,curdate())) <= 45, 1, 0)) as count_45,
				SUM(IF((TIMESTAMPDIFF(YEAR,guests.dob,curdate())) > 45, 1, 0)) as count_under45
				FROM guests
				INNER JOIN deskofreservation ON deskofreservation.guest_id = guests.id
				WHERE ((deskofreservation.datein BETWEEN '" . $startdate . " 00:00:00' AND '" . $enddate . " 23:59:59') OR
				(deskofreservation.dateout BETWEEN DATE_ADD('" . $startdate . " 00:00:00', INTERVAL 1 DAY) AND '" . $enddate . " 23:59:59') OR
				(deskofreservation.datein <= '" . $startdate . " 00:00:00' AND deskofreservation.dateout >= '" . $enddate . " 23:59:59'))
				UNION
				SELECT  SUM(IF(guests.gender = 1, 1, 0)) as count_mans, SUM(IF(guests.gender = 2, 1, 0)) as count_womens,
				SUM(IF((TIMESTAMPDIFF(YEAR,guests.dob,curdate())) <= 18, 1, 0)) as count_18,
				SUM(IF((TIMESTAMPDIFF(YEAR,guests.dob,curdate())) > 18 AND (TIMESTAMPDIFF(YEAR,guests.dob,curdate())) <= 21, 1, 0)) as count_21,
				SUM(IF((TIMESTAMPDIFF(YEAR,guests.dob,curdate())) > 21 AND (TIMESTAMPDIFF(YEAR,guests.dob,curdate())) <= 35, 1, 0)) as count_35,
				SUM(IF((TIMESTAMPDIFF(YEAR,guests.dob,curdate())) > 35 AND (TIMESTAMPDIFF(YEAR,guests.dob,curdate())) <= 45, 1, 0)) as count_45,
				SUM(IF((TIMESTAMPDIFF(YEAR,guests.dob,curdate())) > 45, 1, 0)) as count_under45
				FROM guests
				INNER JOIN guests_deskofreservation ON guests_deskofreservation.guest_id = guests.id
				INNER JOIN deskofreservation ON deskofreservation.id = guests_deskofreservation.reservation_id
				WHERE ((deskofreservation.datein BETWEEN '" . $startdate . " 00:00:00' AND '" . $enddate . " 23:59:59') OR
				(deskofreservation.dateout BETWEEN DATE_ADD('" . $startdate . " 00:00:00', INTERVAL 1 DAY) AND '" . $enddate . " 23:59:59') OR
				(deskofreservation.datein <= '" . $startdate . " 00:00:00' AND deskofreservation.dateout >= '" . $enddate . " 23:59:59'))";
		//echo $sql;
		//die();
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$result_array ["graph_age"] ["data"] [18]["name"] = "{caption_18}";
				$result_array ["graph_age"] ["data"] [18]["total"] = (int)$row->count_18;

				$result_array ["graph_age"] ["data"] [21]["name"] = "{caption_18-21}";
				$result_array ["graph_age"] ["data"] [21]["total"] = (int)$row->count_21;

				$result_array ["graph_age"] ["data"] [35]["name"] = "{caption_21-35}";
				$result_array ["graph_age"] ["data"] [35]["total"] = (int)$row->count_35;

				$result_array ["graph_age"] ["data"] [45]["name"] = "{caption_35-45}";
				$result_array ["graph_age"] ["data"] [45]["total"] = (int)$row->count_45;

				$result_array ["graph_age"] ["data"] [46]["name"] = "{caption_over45}";
				$result_array ["graph_age"] ["data"] [46]["total"] = (int)$row->count_under45;
				$result_array ["graph_age"] ['Date_period'] = $startdate . " - " . $enddate;

				$result_array ["graph_gender"] ["data"] [1] ["name"] = "{caption_men}";
				$result_array ["graph_gender"] ["data"] [1] ["total"] = (int)$row->count_mans;
				$result_array ["graph_gender"] ["data"] [2] ["name"] = "{caption_women}";
				$result_array ["graph_gender"] ["data"] [2] ["total"] = (int)$row->count_womens;
				$result_array ["graph_gender"] ['Date_period'] = $startdate . " - " . $enddate;
			}
		}

		$legalsystem = $this->frontdesk->getlegalsystem();
		$legalsystem_db = $this->frontdesk->getlegalsystem_db($legalsystem);

		$dict_country = array();
		$sql = "SELECT id, NAME_LAT as name_lat FROM $legalsystem_db.dict_country WHERE 1";
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			$dict_country[$row->id]["NAME_LAT"] = $row->name_lat;
		}

		$sql = "SELECT  guests.citizenship_code, count(1) as count_guest
				FROM guests
				INNER JOIN deskofreservation ON deskofreservation.guest_id = guests.id
				WHERE ((deskofreservation.datein BETWEEN '" . $startdate . " 00:00:00' AND '" . $enddate . " 23:59:59') OR
				(deskofreservation.dateout BETWEEN DATE_ADD('" . $startdate . " 00:00:00', INTERVAL 1 DAY) AND '" . $enddate . " 23:59:59') OR
				(deskofreservation.datein <= '" . $startdate . " 00:00:00' AND deskofreservation.dateout >= '" . $enddate . " 23:59:59')) AND guests.country_code <> ''
				GROUP BY guests.citizenship_code
				UNION
				SELECT guests.citizenship_code, count(1) as count_guest
				FROM guests
				INNER JOIN guests_deskofreservation ON guests_deskofreservation.guest_id = guests.id
				INNER JOIN deskofreservation ON deskofreservation.id = guests_deskofreservation.reservation_id
				WHERE ((deskofreservation.datein BETWEEN '" . $startdate . " 00:00:00' AND '" . $enddate . " 23:59:59') OR
				(deskofreservation.dateout BETWEEN DATE_ADD('" . $startdate . " 00:00:00', INTERVAL 1 DAY) AND '" . $enddate . " 23:59:59') OR
				(deskofreservation.datein <= '" . $startdate . " 00:00:00' AND deskofreservation.dateout >= '" . $enddate . " 23:59:59')) AND guests.country_code <> ''
				GROUP BY guests.citizenship_code";
		//echo $sql;
		//die();
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$citizenship_code = $row->citizenship_code;
				if($citizenship_code == ""){
					$citizenship_code = "{caption_undefined}";
				}
				if(isset($dict_country[$citizenship_code])){
					$result_array ["graph_citizenship"] ["data"] [$citizenship_code]["name"] = $dict_country[$citizenship_code]["NAME_LAT"];
				}else{
					$result_array ["graph_citizenship"] ["data"] [$citizenship_code]["name"] = $citizenship_code;
				}
				$result_array ["graph_citizenship"] ["data"] [$citizenship_code]["total"] = (int)$row->count_guest;
				$result_array ["graph_citizenship"] ['Date_period'] = $startdate . " - " . $enddate;
			}
		}
		return $result_array;
	}

	function get_REVENUE_graphycs_data($incoming_data) {
		$start_intdate = $incoming_data['start_intdate'];
		$end_intdate = $incoming_data['end_intdate'];
		$source_join_str = "";
		if (!empty($incoming_data['selected_source'])){
		    $source_join_str = " JOIN dealers ON dealers.id = t2.id_dealer AND dealers.id =". $incoming_data['selected_source'];
		}
		
		$overbooking_cat_id = $this->hotelix_config->get_record('overbooking_category_id', 'int');
		$categories_join_where_str = "AND t4.is_active = 1 AND t4.id != $overbooking_cat_id";
		if (isset($incoming_data['selected_categories'])) {
		    $imploded_selected_categories = implode(', ', $incoming_data['selected_categories']);
		    $categories_join_where_str = "AND t4.id IN ($imploded_selected_categories)";
		}
		
		$where_selected_users_str = '1';
		if (isset($incoming_data['selected_users'])) {
		    $imploded_selected_users = implode(', ', $incoming_data['selected_users']);
		    $where_selected_users_str = "t2.id_user IN ($imploded_selected_users)";
		}
		
		$result_arr = array();
		$where_res_statuses_str = " t2.status IN (1, 2, 3) AND t2.cancel = 0 AND t2.deleted = 0 ";
		
		$sql = "SELECT SUM(t1.price) as amount, t4.id as category_id, t4.name as category_name
				FROM deskofdays AS t1
				JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
				JOIN rooms AS t3 ON t3.id = t1.room_id
				JOIN categories AS t4 ON t4.id = t3.category_id $categories_join_where_str
                $source_join_str
                WHERE $where_selected_users_str AND $where_res_statuses_str AND t1.intdate BETWEEN $start_intdate AND $end_intdate
				GROUP BY t4.id
				ORDER BY amount DESC";
		$subtotal = 0;
		foreach ($this->db->query($sql)->result() as $dataset) {
			$subtotal += $dataset->amount;
			$result_arr['accommodation'][$dataset->category_id]['amount'] = $dataset->amount;
			$result_arr['accommodation'][$dataset->category_id]['name'] = $dataset->category_name;
		}
		$result_arr['accommodation_subtotal'] = $subtotal;
		$sql = "SELECT SUM(t1.amount) as amount, t3.name AS service_name, t3.id AS servicetype_id
				FROM services AS t1
				JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
                $source_join_str
				JOIN services_types AS t3 ON t3.id = t1.type
				WHERE $where_res_statuses_str AND IF(t1.action_time BETWEEN t2.datein AND t2.dateout,
																					(TO_DAYS(t1.action_time) - TO_DAYS( '1970-01-01' )),
																					(TO_DAYS(t2.datein) - TO_DAYS( '1970-01-01' ))) BETWEEN $start_intdate AND $end_intdate
				GROUP BY t1.type
				ORDER BY amount DESC";
		$subtotal = 0;
		foreach ($this->db->query($sql)->result() as $dataset) {
			$subtotal += $dataset->amount;
			$result_arr['services'][$dataset->servicetype_id]['amount'] = $dataset->amount;
			$result_arr['services'][$dataset->servicetype_id]['name'] = $dataset->service_name;
		}
		$result_arr['services_subtotal'] = $subtotal;
		return $result_arr;
	}
	
	function get_REVENUE_ROOMS_graphycs_data($incoming_data) {
	    $start_intdate = $incoming_data['start_intdate'];
	    $end_intdate = $incoming_data['end_intdate'];
	    $source_join_str = "";
	    if (!empty($incoming_data['selected_source'])){
	        $source_join_str = " JOIN dealers ON dealers.id = t2.id_dealer AND dealers.id =". $incoming_data['selected_source'];
	    }
	
	    //$overbooking_cat_id = $this->hotelix_config->get_record('overbooking_category_id', 'int');
	    $rooms_join_where_str = "";
	    if (isset($incoming_data['selected_rooms'])) {
	        $imploded_selected_rooms = implode(', ', $incoming_data['selected_rooms']);
	        $rooms_join_where_str = "AND t3.id IN ($imploded_selected_rooms)";
	    }
	
	    $where_selected_users_str = '1';
	    if (isset($incoming_data['selected_users'])) {
	        $imploded_selected_users = implode(', ', $incoming_data['selected_users']);
	        $where_selected_users_str = "t2.id_user IN ($imploded_selected_users)";
	    }
	
	    $result_arr = array();
	    $where_res_statuses_str = " t2.status IN (1, 2, 3) AND t2.cancel = 0 AND t2.deleted = 0 ";
	
	    $sql = "SELECT SUM(t1.price) as amount, t3.id as room_id, t3.id as room_id, t3.name as room_name, t4.id as category_id, t4.name as category_name
	    FROM deskofdays AS t1
	    JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
	    JOIN rooms AS t3 ON t3.id = t1.room_id $rooms_join_where_str
	    JOIN categories AS t4 ON t4.id = t3.category_id
	    $source_join_str
	    WHERE $where_selected_users_str AND $where_res_statuses_str AND t1.intdate BETWEEN $start_intdate AND $end_intdate
	    GROUP BY t3.id
	    ORDER BY amount DESC";
	    $subtotal = 0;
	    foreach ($this->db->query($sql)->result() as $dataset) {
	        $subtotal += $dataset->amount;
	        $result_arr['accommodation'][$dataset->room_id]['amount'] = $dataset->amount;
	        $result_arr['accommodation'][$dataset->room_id]['name'] = $dataset->room_name;
	    }
	    $result_arr['accommodation_subtotal'] = $subtotal;
// 	    $sql = "SELECT SUM(t1.amount) as amount, t3.name AS service_name, t3.id AS servicetype_id
// 	    FROM services AS t1
// 	    JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
// 	    $source_join_str
// 	    JOIN services_types AS t3 ON t3.id = t1.type
// 	    WHERE $where_res_statuses_str AND IF(t1.action_time BETWEEN t2.datein AND t2.dateout,
// 	    (TO_DAYS(t1.action_time) - TO_DAYS( '1970-01-01' )),
// 	    (TO_DAYS(t2.datein) - TO_DAYS( '1970-01-01' ))) BETWEEN $start_intdate AND $end_intdate
// 	    GROUP BY t1.type
// 	    ORDER BY amount DESC";
// 	    $subtotal = 0;
// 	    foreach ($this->db->query($sql)->result() as $dataset) {
// 	        $subtotal += $dataset->amount;
// 	        $result_arr['services'][$dataset->servicetype_id]['amount'] = $dataset->amount;
// 	        $result_arr['services'][$dataset->servicetype_id]['name'] = $dataset->service_name;
// 	    }
// 	    $result_arr['services_subtotal'] = $subtotal;
	    return $result_arr;
	}
	
	function get_REVENUE_USER_graphycs_data_OLD($incoming_data) {
	    $start_intdate = $incoming_data['start_intdate'];
	    $end_intdate = $incoming_data['end_intdate'];
	    $source_join_str = "";
	    if (!empty($incoming_data['selected_source'])){
	        $source_join_str = " JOIN dealers ON dealers.id = t2.id_dealer AND dealers.id =". $incoming_data['selected_source'];
	    }
	
	    $overbooking_cat_id = $this->hotelix_config->get_record('overbooking_category_id', 'int');
	    $categories_join_where_str = "AND t4.is_active = 1 AND t4.id != $overbooking_cat_id";
	    if (isset($incoming_data['selected_categories'])) {
	        $imploded_selected_categories = implode(', ', $incoming_data['selected_categories']);
	        $categories_join_where_str = "AND t4.id IN ($imploded_selected_categories)";
	    }
	
	    $where_selected_users_str = '1';
	    if (isset($incoming_data['selected_users'])) {
	        $imploded_selected_users = implode(', ', $incoming_data['selected_users']);
	        $where_selected_users_str = "t2.id_user IN ($imploded_selected_users)";
	    }
	
	    $result_arr = array();
	    $where_res_statuses_str = " t2.status IN (1, 2, 3) AND t2.cancel = 0 AND t2.deleted = 0 ";
	
	    $sql = "SELECT SUM(t1.price) as amount, t5.id as user_id, t5.fullname as user_firstname, t5.lastname as user_lastname,
	    t3.id as room_id, t3.name as room_name,
	    t4.id as category_id, t4.name as category_name
	    FROM deskofdays AS t1
	    JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
	    JOIN rooms AS t3 ON t3.id = t1.room_id
	    JOIN categories AS t4 ON t4.id = t3.category_id $categories_join_where_str
	    JOIN users AS t5 ON t5.id = t2.id_user
	    $source_join_str
	    WHERE $where_selected_users_str AND $where_res_statuses_str AND t1.intdate BETWEEN $start_intdate AND $end_intdate
	    GROUP BY t2.id_user, t3.id
	    ORDER BY amount DESC";
	    //echo $sql;
	    $subtotal = 0;
	    foreach ($this->db->query($sql)->result() as $dataset) {
	        $subtotal += $dataset->amount;
	        $result_arr['accommodation'][$dataset->user_id]['user_name'] = $dataset->user_firstname.' '.$dataset->user_lastname;
	        $result_arr['accommodation'][$dataset->user_id]['user_id'] = $dataset->user_id;
	        $result_arr['accommodation'][$dataset->user_id]['rooms'][$dataset->room_id]['amount'] = $dataset->amount;
	        $result_arr['accommodation'][$dataset->user_id]['rooms'][$dataset->room_id]['amount'] = $dataset->amount;
	        $result_arr['accommodation'][$dataset->user_id]['rooms'][$dataset->room_id]['name'] = $dataset->room_name;
	    }
	    $result_arr['accommodation_subtotal'] = $subtotal;
	    // 	    $sql = "SELECT SUM(t1.amount) as amount, t3.name AS service_name, t3.id AS servicetype_id
	    // 	    FROM services AS t1
	    // 	    JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
	    // 	    $source_join_str
	    // 	    JOIN services_types AS t3 ON t3.id = t1.type
	    // 	    WHERE $where_res_statuses_str AND IF(t1.action_time BETWEEN t2.datein AND t2.dateout,
	    // 	    (TO_DAYS(t1.action_time) - TO_DAYS( '1970-01-01' )),
	    // 	    (TO_DAYS(t2.datein) - TO_DAYS( '1970-01-01' ))) BETWEEN $start_intdate AND $end_intdate
	    // 	    GROUP BY t1.type
	    // 	    ORDER BY amount DESC";
	    // 	    $subtotal = 0;
	    // 	    foreach ($this->db->query($sql)->result() as $dataset) {
	    // 	        $subtotal += $dataset->amount;
	    // 	        $result_arr['services'][$dataset->servicetype_id]['amount'] = $dataset->amount;
	    // 	        $result_arr['services'][$dataset->servicetype_id]['name'] = $dataset->service_name;
	    // 	    }
	    // 	    $result_arr['services_subtotal'] = $subtotal;
	    return $result_arr;
	}
	
	public function get_REVENUE_paid_graphycs_data($incoming_data) {
	    $start_intdate = $incoming_data['start_intdate'];
	    $end_intdate = $incoming_data['end_intdate'];
	    $source_join_str = "";
	    if (!empty($incoming_data['selected_source'])){
	        $source_join_str = " JOIN dealers ON dealers.id = t2.id_dealer AND dealers.id =". $incoming_data['selected_source'];
	    }
	    $overbooking_cat_id = $this->hotelix_config->get_record('overbooking_category_id', 'int');
	    $result_arr = array();
	    $where_res_statuses_str = " t2.status IN (1, 2, 3) AND t2.cancel = 0 AND t2.deleted = 0 ";
	    $sql = "SELECT SUM(t1.amount) as amount, t4.id as category_id, t4.name as category_name
	    FROM check_payment_items AS t1
	    JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
	    JOIN rooms AS t3 ON t3.id = t2.room_id
	    JOIN categories AS t4 ON t4.id = t3.category_id AND t4.is_active = 1
	    $source_join_str
	    WHERE t1.item_service_table_id = 2 AND $where_res_statuses_str AND t4.id != $overbooking_cat_id 
                AND (TO_DAYS(t2.datein) - TO_DAYS( '1970-01-01' )) BETWEEN $start_intdate AND $end_intdate
	    GROUP BY t4.id
	    ORDER BY amount DESC";
	    $subtotal = 0;
	    foreach ($this->db->query($sql)->result() as $dataset) {
	        $subtotal += $dataset->amount;
	        $result_arr['accommodation'][$dataset->category_id]['amount'] = $dataset->amount;
	        $result_arr['accommodation'][$dataset->category_id]['name'] = $dataset->category_name;
	    }
	    $result_arr['accommodation_subtotal'] = $subtotal;
	    $sql = "SELECT SUM(t1.amount) as amount, t3.name AS service_name, t3.id AS servicetype_id
	    FROM services AS t1
        JOIN check_payment_items ON check_payment_items.item_id = t1.id
	    JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
	    $source_join_str
	    JOIN services_types AS t3 ON t3.id = t1.type
	    WHERE $where_res_statuses_str AND IF(t1.action_time BETWEEN t2.datein AND t2.dateout,
	    (TO_DAYS(t1.action_time) - TO_DAYS( '1970-01-01' )),
	    (TO_DAYS(t2.datein) - TO_DAYS( '1970-01-01' ))) BETWEEN $start_intdate AND $end_intdate
	    GROUP BY t1.type
	    ORDER BY amount DESC";
	    $subtotal = 0;
	    foreach ($this->db->query($sql)->result() as $dataset) {
	        $subtotal += $dataset->amount;
	        $result_arr['services'][$dataset->servicetype_id]['amount'] = $dataset->amount;
	        $result_arr['services'][$dataset->servicetype_id]['name'] = $dataset->service_name;
	    }
	    $result_arr['services_subtotal'] = $subtotal;
	    return $result_arr;
	}

	function get_TREV_graphycs_data($incoming_data) {
		if (! count ( $incoming_data['selected_categories'] )) {
			return false;
		}
		//categories and rooms count
		$selected_categories_str = implode ( ", ", $incoming_data['selected_categories'] );
		$sql = "SELECT COUNT(rooms.id) as count_allrooms
				FROM rooms
				JOIN categories ON categories.id = rooms.`category_id` AND categories.id IN ($selected_categories_str)";
		$count_allrooms_selected_categories = $this->db->query ( $sql )->row()->count_allrooms;
		//services
		$selected_services_str = "";
		$selected_main_services_str = "";
		$is_main_servise_number_one = FALSE;
		foreach ($incoming_data['selected_services'] as $someservice) {
			$srv_id = explode ( "_", $someservice);
			if (count($srv_id)>1){//so this is main service
				if ($srv_id[1] != 1){//the prozhivanie
					$selected_main_services_str .= !empty($selected_main_services_str) ? ", ".$srv_id[1] : $srv_id[1];
				}else{
					$is_main_servise_number_one = TRUE;
				}
			}else {//so this is simple service
				$selected_services_str .= !empty($selected_services_str) ? ", ".$srv_id[0] : $srv_id[0];
			}
		}
		//date margins
		$where_res_statuses_str = " t2.status IN (1, 2, 3) AND t2.cancel = 0 AND t2.deleted = 0 ";
		$start_intdate = $incoming_data['start_intdate'];
		$end_intdate = $incoming_data['end_intdate'];
		$main_services_sums_rer_indate_arr = array();
		if (!empty($selected_main_services_str)){
			$sql = "SELECT SUM(t1.amount) as amount, (TO_DAYS(t2.datein) - TO_DAYS( '1970-01-01' )) AS srv_intdate
					FROM services_main AS t1
					JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
					JOIN rooms AS t3 ON t3.id = t2.room_id AND t3.category_id IN ($selected_categories_str)
					WHERE $where_res_statuses_str AND t1.type IN($selected_main_services_str)
					GROUP BY srv_intdate
					HAVING srv_intdate BETWEEN $start_intdate AND $end_intdate";
			foreach ($this->db->query($sql)->result() as $dataset) {
				$main_services_sums_rer_indate_arr[$dataset->srv_intdate] = $dataset->amount;
			}
		}
		$services_sums_rer_indate_arr = array();
		if (!empty($selected_services_str)){
			$sql = "SELECT SUM(t1.amount) as amount, IF(t1.action_time BETWEEN t2.datein AND t2.dateout,
														(TO_DAYS(t1.action_time) - TO_DAYS( '1970-01-01' )),
														(TO_DAYS(t2.datein) - TO_DAYS( '1970-01-01' ))) AS srv_intdate
					FROM services AS t1
					JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
					JOIN rooms AS t3 ON t3.id = t2.room_id AND t3.category_id IN ($selected_categories_str)
					WHERE $where_res_statuses_str AND t1.type IN($selected_services_str)
					GROUP BY srv_intdate
					HAVING srv_intdate BETWEEN $start_intdate AND $end_intdate";
			foreach ($this->db->query($sql)->result() as $dataset) {
				$services_sums_rer_indate_arr[$dataset->srv_intdate] = $dataset->amount;
			}
		}
		$main_service_N_one_arr = array();
		if ($is_main_servise_number_one){
			$sql = "SELECT SUM(t1.price) as amount, t1.intdate
					FROM deskofdays AS t1
					JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
					JOIN rooms AS t3 ON t3.id = t1.room_id AND t3.category_id IN ($selected_categories_str)
					WHERE $where_res_statuses_str AND t1.intdate BETWEEN $start_intdate AND $end_intdate
					GROUP BY t1.intdate";
			foreach ($this->db->query($sql)->result() as $dataset) {
				$main_service_N_one_arr[$dataset->intdate] = $dataset->amount;
			}
		}
		$result_arr = array('intdates'=>array(), 'all_period'=>array('TREV'=>0));
		for ($i = $start_intdate; $i <= $end_intdate; $i++) {
			$intdate_service_N_one_amount = isset($main_service_N_one_arr[$i])?$main_service_N_one_arr[$i]:0;
			$intdate_main_service_amount = isset($main_services_sums_rer_indate_arr[$i])?$main_services_sums_rer_indate_arr[$i]:0;
			$intdate_service_amount = isset($services_sums_rer_indate_arr[$i])?$services_sums_rer_indate_arr[$i]:0;
			$result_arr['intdates'][$i]['TREV'] = round(($intdate_service_amount+$intdate_main_service_amount+$intdate_service_N_one_amount)/$count_allrooms_selected_categories);
			$result_arr['intdates'][$i]['date'] = gmdate ( "d-m", $i * 86400 );//-y
			$result_arr['all_period']['TREV'] += $result_arr['intdates'][$i]['TREV'];
		}
		$result_arr['all_period']['TREV'] = round($result_arr['all_period']['TREV']/($end_intdate-$start_intdate+1));
		return $result_arr;
	}
	function get_ADRREV_graphycs_data($intdate_in = "", $intdate_out = "", $categories, $deslers = array()) {
		$where_dealers_str = "";
		if(!empty($deslers)){
			$search_deslers_str = implode ( ", ", $deslers );
			$where_dealers_str = " AND deskofreservation.id_dealer IN ($search_deslers_str) ";
		}
		if (! count ( $categories )) {
			return false;
		}
		$search_categories_str = implode ( ", ", $categories );
		$romms_count_array = array ();
		$sql = "SELECT categories.name, categories.id as category_id, COUNT(rooms.id) as count_allrooms  FROM rooms
				INNER JOIN categories ON categories.id = rooms.`category_id` AND categories.is_active = 1 AND categories.id IN ($search_categories_str)
				GROUP BY categories.id";
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			$romms_count_array [$row->category_id] ["count"] = $row->count_allrooms;
			$romms_count_array [$row->category_id] ["name"] = $row->name;
		}
		$array = array ();
		foreach ( $romms_count_array as $category_id => $cell ) {
			for($i = $intdate_in; $i <= $intdate_out; $i ++) {
				$array [$category_id] ["cat_name"] = $cell ["name"];
				$array [$category_id] ["dates"] [$i] ["date"] = gmdate ( "d-m-y", $i * 86400 );
				$array [$category_id] ["dates"] [$i] ["amount"] = 0;
				$array [$category_id] ["dates"] [$i] ["ADR"] = 0;
				$array [$category_id] ["dates"] [$i] ["REV"] = 0;
				$array [$category_id] ["dates"] [$i] ["room_reserved"] = 0;
				$array [$category_id] ["dates"] [$i] ["room_total"] = $romms_count_array [$category_id] ["count"];
				$array [$category_id] ["dates"] [$i] ["ocupancy"] = 0;
			}
		}
		//=========================================================================
		//1	Бронь, 2 Заезд,	3 Выезд
		$where_res_statuses_str = " deskofreservation.status IN (1, 2, 3) AND deskofreservation.cancel = 0 AND deskofreservation.deleted = 0 ";
		//=========================================================================
// 		$sql = "SELECT categories.id as category_id, deskofdays.intdate, categories.name as cat_name,
// 						SUM(services_main.amount/deskofreservation.duration) as amount, COUNT(rooms.id) as room_reserved
// 			FROM deskofreservation
// 			INNER JOIN deskofdays ON deskofdays.reservation_id = deskofreservation.id
// 			INNER JOIN services_main ON services_main.reservation_id = deskofdays.reservation_id
// 			INNER JOIN rooms ON rooms.id = deskofdays.`room_id`
// 			INNER JOIN categories ON categories.id = rooms.`category_id` AND categories.is_active = 1 AND categories.id IN ($search_categories_str)
// 			WHERE $where_res_statuses_str AND deskofdays.intdate >= " . $intdate_in . " AND deskofdays.intdate <= " . $intdate_out ."
// 					 AND services_main.type = 1 $where_dealers_str
// 			GROUP BY categories.id, deskofdays.intdate";
		$sql = "SELECT categories.id as category_id, deskofdays.intdate, categories.name as cat_name,
						SUM(deskofdays.price) as amount, COUNT(rooms.id) as room_reserved
				FROM deskofreservation
				JOIN deskofdays ON deskofdays.reservation_id = deskofreservation.id
				INNER JOIN rooms ON rooms.id = deskofdays.`room_id`
				INNER JOIN categories ON categories.id = rooms.`category_id` AND categories.is_active = 1 AND categories.id IN ($search_categories_str)
				WHERE $where_res_statuses_str $where_dealers_str AND deskofdays.intdate >= $intdate_in AND deskofdays.intdate <= $intdate_out
				GROUP BY categories.id, deskofdays.intdate";
		$query = $this->db->query ( $sql );
		foreach ( $query->result () as $row ) {
			$array [$row->category_id] ["cat_name"] = $row->cat_name;
			$array [$row->category_id] ["dates"] [$row->intdate] ["date"] = gmdate ( "d-m-y", $row->intdate * 86400 );
			$array [$row->category_id] ["dates"] [$row->intdate] ["amount"] = $row->amount;
			$array [$row->category_id] ["dates"] [$row->intdate] ["ADR"] = round ( $row->amount / $row->room_reserved, 2 );
			$array [$row->category_id] ["dates"] [$row->intdate] ["REV"] = round ( $row->amount / $romms_count_array [$row->category_id] ["count"], 2 );
			$array [$row->category_id] ["dates"] [$row->intdate] ["room_reserved"] = $row->room_reserved;
			$array [$row->category_id] ["dates"] [$row->intdate] ["room_total"] = $romms_count_array [$row->category_id] ["count"];
			$array [$row->category_id] ["dates"] [$row->intdate] ["ocupancy"] = round ( $row->room_reserved / $romms_count_array [$row->category_id] ["count"], 2 );
		}
		// формуємо відповідний рез_масив з масивів: categories_per_date, dates_per_all_categories, total_all_period_all_categories
		$rez_arr ['categories_per_date'] = $array;
// 		$more_than_one = false;
// 		if (count ( $rez_arr ['categories_per_date'] ) > 1) {
// 			$more_than_one = true;
// 		}
		foreach ( $rez_arr ['categories_per_date'] as $category_id => $category_data ) {
			foreach ( $category_data ['dates'] as $date_int => $date_data ) {
				// формуємо масив по всім датам в сумі по категоріям
				$rez_arr ['dates_per_all_categories'] [$date_int] ['date'] = $date_data ['date'];
				if (! isset ( $rez_arr ['dates_per_all_categories'] [$date_int] ['amount'] )) {
					$rez_arr ['dates_per_all_categories'] [$date_int] ['amount'] = 0;
				}
				$rez_arr ['dates_per_all_categories'] [$date_int] ['amount'] += $date_data ['amount'];
				if (! isset ( $rez_arr ['dates_per_all_categories'] [$date_int] ['room_reserved'] )) {
					$rez_arr ['dates_per_all_categories'] [$date_int] ['room_reserved'] = 0;
				}
				$rez_arr ['dates_per_all_categories'] [$date_int] ['room_reserved'] += $date_data ['room_reserved'];
				if (! isset ( $rez_arr ['dates_per_all_categories'] [$date_int] ['room_total'] )) {
					$rez_arr ['dates_per_all_categories'] [$date_int] ['room_total'] = 0;
				}
				$rez_arr ['dates_per_all_categories'] [$date_int] ['room_total'] += $date_data ['room_total'];
				// формуємо масив по всім категоріям за весь період і
// 				if ($more_than_one) {
					if (! isset ( $rez_arr ['total_all_period_all_categories'] ['all'] ['amount'] )) {
						$rez_arr ['total_all_period_all_categories'] ['all'] ['amount'] = 0;
					}
					$rez_arr ['total_all_period_all_categories'] ['all'] ['amount'] += $date_data ['amount'];
					if (! isset ( $rez_arr ['total_all_period_all_categories'] ['all'] ['room_reserved'] )) {
						$rez_arr ['total_all_period_all_categories'] ['all'] ['room_reserved'] = 0;
					}
					$rez_arr ['total_all_period_all_categories'] ['all'] ['room_reserved'] += $date_data ['room_reserved'];
					if (! isset ( $rez_arr ['total_all_period_all_categories'] ['all'] ['room_total'] )) {
						$rez_arr ['total_all_period_all_categories'] ['all'] ['room_total'] = 0;
					}
					$rez_arr ['total_all_period_all_categories'] ['all'] ['room_total'] += $date_data ['room_total'];
					$rez_arr ['total_all_period_all_categories'] ['all'] ['cat_name'] = "{caption_sum_selected_categories}";
// 				}
				// по кожній за весь
				if (! isset ( $rez_arr ['total_all_period_all_categories'] [$category_id] ['amount'] )) {
					$rez_arr ['total_all_period_all_categories'] [$category_id] ['amount'] = 0;
				}
				$rez_arr ['total_all_period_all_categories'] [$category_id] ['amount'] += $date_data ['amount'];
				if (! isset ( $rez_arr ['total_all_period_all_categories'] [$category_id] ['room_reserved'] )) {
					$rez_arr ['total_all_period_all_categories'] [$category_id] ['room_reserved'] = 0;
				}
				$rez_arr ['total_all_period_all_categories'] [$category_id] ['room_reserved'] += $date_data ['room_reserved'];
				if (! isset ( $rez_arr ['total_all_period_all_categories'] [$category_id] ['room_total'] )) {
					$rez_arr ['total_all_period_all_categories'] [$category_id] ['room_total'] = 0;
				}
				$rez_arr ['total_all_period_all_categories'] [$category_id] ['room_total'] += $date_data ['room_total'];
			}
			$rez_arr ['total_all_period_all_categories'] [$category_id] ['cat_name'] = $category_data ['cat_name'];
		}
		// після формування, фінішна доводка рез_масиву, вираховування АДР и РЕВ
		foreach ( $rez_arr ['dates_per_all_categories'] as $date_int => $date_data ) {
			$rez_arr ['dates_per_all_categories'] [$date_int] ['ADR'] = ($date_data ['room_reserved'] == 0) ? 0 : round ( $date_data ['amount'] / $date_data ['room_reserved'], 2 );
			$rez_arr ['dates_per_all_categories'] [$date_int] ['REV'] = round ( $date_data ['amount'] / $date_data ['room_total'], 2 );
			$rez_arr ['dates_per_all_categories'] [$date_int] ['ocupancy'] = round ( $date_data ['room_reserved'] / $date_data ['room_total'], 2 );
			$rez_arr ['dates_per_all_categories'] [$date_int] ['ocupancy_4digit'] = round ( $date_data ['room_reserved'] / $date_data ['room_total'], 4 );
		}
		foreach ( $rez_arr ['total_all_period_all_categories'] as $key => $value ) {
			if ($rez_arr ['total_all_period_all_categories'] [$key] ['room_reserved'] == 0){
				$rez_arr ['total_all_period_all_categories'] [$key] ['ADR'] = 0;
			}else{
				$rez_arr ['total_all_period_all_categories'] [$key] ['ADR'] = round ( $rez_arr ['total_all_period_all_categories'] [$key] ['amount'] / $rez_arr ['total_all_period_all_categories'] [$key] ['room_reserved'], 2 );
			}
			$rez_arr ['total_all_period_all_categories'] [$key] ['REV'] = round ( $rez_arr ['total_all_period_all_categories'] [$key] ['amount'] / $rez_arr ['total_all_period_all_categories'] [$key] ['room_total'], 2 );
			$rez_arr ['total_all_period_all_categories'] [$key] ['ocupancy'] = round ( $rez_arr ['total_all_period_all_categories'] [$key] ['room_reserved'] / $rez_arr ['total_all_period_all_categories'] [$key] ['room_total'], 2 );
			$rez_arr ['total_all_period_all_categories'] [$key] ['ocupancy_4digit'] = round ( $rez_arr ['total_all_period_all_categories'] [$key] ['room_reserved'] / $rez_arr ['total_all_period_all_categories'] [$key] ['room_total'], 4 );
		}
		// рез_масив готовий
		// echo "<pre>";
		// print_r($rez_arr);die('DIE IN report_model ADR');
		return $rez_arr;
	}
	function get_days_numbers() {
		$days_numbers = array();
		for($i = 1; $i <= 31; $i ++) {
			array_push ( $days_numbers, array (
					'day_number' => $i
			) );
		}
		return $days_numbers;
	}

	function get_months() {//mlw_month_december
		$months = array();
		for($i = 1; $i <= 12; $i ++) {
			$months [$i] = array (
					'number' => $i,
					'clt_name' => '{mlw_month_' . strtolower ( date ( "F", strtotime ( "01-" . $i . "-2019" ) ) ) . '}',
					'Full_name' => date ( "F", strtotime ( "01-" . $i . "-2019" ) ),
					'selected' => "selected",
			)
			;
		}
		return $months;
	}
	function get_active_and_isactiveroom_categories() {
		$categories = array();
		$overbooking_category_id = 0;
		$query = $this->db->query ( "SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'" );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$overbooking_category_id = $row->value;
		}
		$query = $this->db->query ( "SELECT categories.id, categories.shortname, categories.name
							FROM categories
							JOIN rooms ON rooms.category_id = categories.id
							WHERE categories.is_active=1 AND rooms.is_active=1 = 1 AND categories.id <> $overbooking_category_id
							GROUP BY rooms.category_id
							ORDER BY `order` ASC" );
		foreach ( $query->result () as $row ) {
			$name = ($row->shortname == "") ? $name = $row->name : $name = $row->shortname;
			$categories [$row->id] = array (
					'id' => $row->id,
					'name' => $name,
					'selected' => "selected"
			);
		}
		return $categories;
	}
	function get_select_option_services_parsing_arr() {
		$all_services = $main_services = $services = array();
		$sql = "SELECT t1.id, t1.name
				FROM services_types_main AS t1";
		$result = $this->db->query($sql)->result();
		foreach ($result as $service_main) {
			$main_services ["main_".$service_main->id] = array (
					'id' => "main_".$service_main->id,
					'name' => $service_main->name,
					'selected' => "selected"
			);
		}
		$sql = "SELECT t1.id, t1.name
				FROM services_types AS t1";
		$result = $this->db->query($sql)->result();
		foreach ($result as $service) {
			$services [$service->id] = array (
					'id' => $service->id,
					'name' => $service->name,
					'selected' => "selected"
			);
		}
		array_push($all_services, array('group_options_main_services'=>$main_services, 'group_options_services'=>$services));
		return $all_services;
	}

	function get_active_dealers() {
		$dealers = $this->db->select('id, name')->get_where('dealers', array('is_active' => 1))->result_array();
		foreach ($dealers as &$dealer) {
			$dealer['selected'] = "selected";
			unset($dealer);
		}
		return $dealers;
	}

	function make_style_formal_value_cell ($curr_val, $prev_val){
		$report_number_threshold = $this->config->item('report_number_threshold');
		$diff = abs($curr_val) - abs($prev_val);
		if ($diff > 0){
			$arrow = 'fa fa-caret-up st-caret-up';
			$style = 'bgbox_blue';
			$diff = ceil(abs($diff/$curr_val)*100);
		}elseif ($diff<0) {
			$arrow = 'fa fa-caret-down st-caret-down';
			$style = 'bgbox_gray';
			$diff = ceil(abs($diff/$prev_val)*100);
		}else{
			$arrow = '';
			$style = 'bgbox_gray';
			$diff = 0;
		}
		$res_arr = array (
				'value' => number_format ( ceil($curr_val), 0, ' ', $report_number_threshold ),
				'percent' => $diff.'%',
				'style' => $style.ceil($diff/10),
				'arrow' => $arrow
		);
		return $res_arr;
	}

	function get_pay_methods_graphycs_data($incoming_data) {
	    $start_date = date("Y-m-d", strtotime($incoming_data['start_date']));
	    $end_date = date("Y-m-d", strtotime($incoming_data['end_date']));
	    $result_arr = array();
	    $sql = "SELECT SUM(t1.amount) as amount, t2.id as method_id, t2.name as method_name
                FROM payment AS t1
                JOIN payment_types AS t2 ON t1.type = t2.id
                WHERE t1.operationtime BETWEEN '$start_date' AND '$end_date'
                GROUP BY t2.id
                HAVING amount > 0";//ORDER BY amount DESC
	    foreach ($this->db->query($sql)->result() as $dataset) {
	        $result_arr[$dataset->method_id]['amount'] = $dataset->amount;
	        $result_arr[$dataset->method_id]['name'] = $dataset->method_name;
	    }
	    return $result_arr;
	}

	function get_sources_graphycs_data($incoming_data) {
	    $start_intdate = $incoming_data['start_intdate'];
	    $end_intdate = $incoming_data['end_intdate'];
	    $overbooking_cat_id = $this->hotelix_config->get_record('overbooking_category_id', 'int');
	    $result_arr = array();
	    $where_res_statuses_str = " t2.status IN (1, 2, 3) AND t2.cancel = 0 AND t2.deleted = 0 ";
	    $sql = "SELECT SUM(t1.price) as amount, t5.id, t5.name
        	    FROM deskofdays AS t1
        	    JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
        	    JOIN rooms AS t3 ON t3.id = t1.room_id
        	    JOIN categories AS t4 ON t4.id = t3.category_id AND t4.is_active = 1
                JOIN dealers AS t5 ON t5.id = t2.id_dealer AND t5.is_active = 1
        	    WHERE $where_res_statuses_str AND t4.id != $overbooking_cat_id AND t1.intdate BETWEEN $start_intdate AND $end_intdate
        	    GROUP BY t5.id
                HAVING amount > 0
        	    ORDER BY amount DESC";
	    $subtotal = 0;
	    foreach ($this->db->query($sql)->result() as $dataset) {
	        $subtotal += $dataset->amount;
	        $result_arr['sources'][$dataset->id]['name'] = $dataset->name;
	        $result_arr['sources'][$dataset->id]['amount'] = $dataset->amount;
	    }
	    $result_arr['total'] = $subtotal;
	    $sql = "SELECT SUM(t1.amount) as amount, t3.id, t3.name
        	    FROM services AS t1
        	    JOIN deskofreservation AS t2 ON t1.reservation_id = t2.id
        	    JOIN dealers AS t3 ON t3.id = t1.id_dealer AND t3.is_active = 1
        	    WHERE $where_res_statuses_str AND IF(t1.action_time BETWEEN t2.datein AND t2.dateout,
                	    (TO_DAYS(t1.action_time) - TO_DAYS( '1970-01-01' )),
                	    (TO_DAYS(t2.datein) - TO_DAYS( '1970-01-01' ))) BETWEEN $start_intdate AND $end_intdate
        	    GROUP BY t3.id
                HAVING amount > 0";
	    $subtotal = 0;
	    foreach ($this->db->query($sql)->result() as $dataset) {
	        $subtotal += $dataset->amount;
	        if (!isset($result_arr['sources'][$dataset->id])){
	            $result_arr['sources'][$dataset->id]['name'] = $dataset->name;
	            $result_arr['sources'][$dataset->id]['amount'] = $dataset->amount;
	        }else{
	            $result_arr['sources'][$dataset->id]['amount'] += $dataset->amount;
	        }
	    }
	    $result_arr['total'] += $subtotal;
	    return $result_arr;
	}
}
?>