<?php

class Htmltpl extends CI_Model
{
    function __construct()
    {
	// Call the Model constructor
	parent::__construct();
	$this->load->model( 'frontdesk' );
	$this->load->model( 'frontdesk_c2' );
	$this->load->model( 'navigation' );
	$this->load->model( 'mlanguages' );
	$this->load->model( 'Wubook' );
	$this->load->model( 'dc_model' );
	$this->load->model( 'chain_model' );
	$this->load->model( 'design' );
	$this->load->model( 'fms_core' );
	$this->load->model( 'debugmodel' );
	$this->load->model( 'recommendations_model' );
	$this->load->model( 'hotelix_config' );
	$this->load->model( 'messages_model' );
	$this->load->model( 'Access' );
	//die();
    }

    public function set_rlist_options( $fields )
    {
	if( isset( $_SESSION ['user']['id'] ) ){
	    $user_id = $_SESSION ['user']['id'];
	    $json_fields = json_encode( $fields );
	    $sql = "INSERT INTO hotelix_interface_config (userid, name, str_value) VALUES('" 
		    . $user_id . "', 'rlist_fields', '" 
		    . $json_fields . "') ON DUPLICATE KEY UPDATE str_value = '" 
		    . $json_fields . "'";
	    $query = $this->db->query( $sql );
	}
    }

    public function set_guestlist_options( $fields )
    {
	if( isset( $_SESSION ['user']['id'] ) ){
	    $user_id = $_SESSION ['user']['id'];
	    $json_fields = json_encode( $fields );
	    $sql = "INSERT INTO hotelix_interface_config (userid, name, str_value) VALUES('" . $user_id . "', 'guestslist_fields', '" . $json_fields . "')
			ON DUPLICATE KEY UPDATE str_value = '" . $json_fields . "'";
	    $query = $this->db->query( $sql );
	}
    }

    public function GetStylesJs( $version = "" )
    {
	$query = $this->db->query( "SELECT * FROM logo" );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $name = stripslashes( $row->logo_title );
	} else {
	    $name = "unknown";
	}
	$data = array(
	    'name' => $name
	);
	$this->mlanguages->getdictionary( "header", "", $data );
	$header = $this->parser->parse( 'templates/header_styles_js' . $version . '.html',
		$data, TRUE );
	return $header;
    }

    public function GetStylesJs_v2()
    {
	$query = $this->db->query( "SELECT * FROM logo" );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $name = stripslashes( $row->logo_title );
	} else {
	    $name = "unknown";
	}
	$data = array(
	    'name' => $name
	);
	$header = $this->parser->parse( 'templates/header_styles_js_v2.html',
		$data, TRUE );
	return $header;
    }

    function getFooter_new()
    {
	//         echo "<pre>";
	//         print_r($_SERVER);
	//         die();
	$data = array();
	$this->mlanguages->getdictionary( "header", "", $data );
	$type = 1;
	$user = $_SESSION['user'];
	$dev_revision = $this->frontdesk_c2->get_dev_revision_value();
	$data['dev_revision'] = $dev_revision;
	$data['user_fullname'] = $user['fullname'] . $user['lastname'];
	$data['user_login'] = $user['login'];
	$data['copyright_year'] = date( 'Y' );
	$company = $this->releases->get_company();
	$data['favicon'] = $company['favicon'];
	$data['company'] = $company['name'];
	$data['main_domen'] = $company['main_domen'];
	$footer = $this->parser->parse( 'templates/footer_n.html', $data, TRUE );
	//     	$footer .= " - class ". $this->router->fetch_class();
	//     	$footer .= " - method ". $this->router->fetch_method();
	return $footer;
    }

    function get_header_meta_block_c2()
    {
	$data = array();
	$header_meta_block = $this->parser->parse( 'templates/header_meta_block_c2.html',
		$data, TRUE );
	return $header_meta_block;
    }

    function getHeader_new( $type = 0, $block_lock = 1, $wizard = 0,
	    $route_page = "" )
    {

	// if (!in_array($route_page, $allowed_pages_arr))
	// ф-я контролю моно режиму
	// $this->frontdesk_c2->mono_control($_SESSION["user"]["id"]);
	// $mono_mode = $this->frontdesk_c2->get_mono_mode();

	$query = $this->db->query( "SELECT pwdresetreq, drop_session FROM users WHERE id = " . $_SESSION["user"]["id"] );
	$row = $query->row();
	if( $this->config->item( 'change_user_password' ) == 1 ){
	    if( $row->pwdresetreq == 1 ){
		die( "<meta http-equiv='refresh' content='0;url=/login_c2/change_pwd'>" );
	    }
	}

	if( $row->drop_session == 1 ){
	    $this->Authorization->session_logout();
	    die( "<meta http-equiv='refresh' content='0;url=/login_c2'>" );
	}

	$data = array();
	$data['date'] = date( "d.m.Y" );
	// $data['time'] = date("H:i");
	$timezone = $this->hotelix_config->get_record( 'timezone' );
	if( $timezone ){
	    $now = new DateTime( "now", new DateTimeZone( $timezone ) );
	    $data['time'] = $now->format( 'H:i' );
	} else {
	    $data['time'] = date( "H:i" );
	}

	$type = 1;
	$user = $_SESSION['user'];
	// hard block start
	$sql = "SELECT * FROM visitka.config WHERE id = " . $this->config->item( 'hotel_id' );
	$query = $this->db->query( $sql );
	$row = $query->row();
	if( $row->hotelstateid == 6 ||
		$row->hotelstateid == 7 ||
		$row->hotelstateid == 5 ||
		$row->hotelstateid == 9
	){
	    die( "<meta http-equiv='refresh' content='0;url=/state/lock/state/" . $row->hotelstateid . "'>" );
	}
	// hard block end
	// 		echo "<pre>";
	// 		print_r($_SERVER);
	// 		die();
	//=================== дозволятор-маршрутизатор START =============================
	$allowed_pages_arr = array(
	    "billing_c2",
	    "stripe_rate",
	    "support_ticketslist_c2",
	    "home_feedback_c2",
	    "errors_c2",
	    "stripe_invoices",
	    "stripe_charges",
	    "stripe_cards",
	    "users_c2_currentuedit"
	);
	$lock_till_open_date = $this->hotelix_config->get_record( "lock_till_open" );
	$is_locked_till_open = ((strtotime( $lock_till_open_date ) - strtotime( date( "Y-m-d" ) )) <= 0)
		    ? true : false;
	if( $is_locked_till_open && $wizard == 0 ){
	    $hms_allowed = $this->hotelix_config->get_record( "hms_allowed",
		    "int" );
	    $hms_route = $this->hotelix_config->get_record( "hms_route" );
	    if( !$hms_allowed ){
		if( !in_array( $route_page, $allowed_pages_arr ) ){//$route_page != $hms_route
		    $hms_billing_version = $this->hotelix_config->get_record( "hms_billing_version",
			    "int" );
		    if( $hms_billing_version == 2 ){
			$controller_appendix_stripe_sca = "";
			if( $this->config->item( 'spripe_sca' ) ){
			    $controller_appendix_stripe_sca = "2";
			}
			switch( $hms_route ){
			    case "stripe_rate":
				$die_url = "/stripe_concept$controller_appendix_stripe_sca/plans";
				break;
			    case "stripe_invoices":
				$die_url = "/stripe_concept$controller_appendix_stripe_sca/summary"; //TEMP to summary was /stripe_concept/invoices
				break;
			    default:
				$die_url = "/stripe_concept$controller_appendix_stripe_sca/plans";
			}
			die( "<meta http-equiv='refresh' content='0;url=$die_url'>" );
		    }
		}
	    }
	}
	//=================== дозволятор-маршрутизатор FINISH =============================
	//if ($wizard != 1 && $hms_allowed) {
	if( $wizard != 1 && 1 ){
	    $query = $this->db->query( "SELECT value FROM hotelix_config WHERE name LIKE 'wizardsetup'" );
	    $bool = 0;
	    if( $query->num_rows() > 0 ){
		$row = $query->row();
		if( $row->value == 0 ){
		    $wizardsetup_type = $this->config->item( 'wizardsetup_type' );
		    switch( $wizardsetup_type ){
			case 0:
			    die( "<meta http-equiv='refresh' content='0;url=/wizard/step1'>" ); // old page
			    break;
			case 1:
			    die( "<meta http-equiv='refresh' content='0;url=/wizard/step1'>" ); // old page
			    break;
			case 2:
			    die( "<meta http-equiv='refresh' content='0;url=/wizard_c2/step_1'>" );
			    break;
			default:
			    die( "<meta http-equiv='refresh' content='0;url=/wizard/step1'>" ); // old page
			    break;
		    }
		    //die("<meta http-equiv='refresh' content='0;url=/wizard/step1'>"); // old page
		    //die("<meta http-equiv='refresh' content='0;url=/wizard_c2/step_1'>");
		}
	    }
	}
	$dc_data = $this->dc_model->dc_log_lc_status();
	$dc_rate_data = $this->dc_model->dc_log_rate_lc_status();
	$dc_log_days = $this->dc_model->dc_log_lc_status_byday();
	$dc_log_yield_days = $this->dc_model->dc_log_yield_lc_status_byday();
	$dc_log_rate_days = $this->dc_model->dc_log_rate_lc_status_byday();
	switch( $dc_data["status"] ){
	    case 0:
		$dc_status = "{mlw_turned_off}";
		$dc_button_name = "{mlw_turned_on_2}";
		$button_dc_url = "/dc_cron/dc_log_semafor_ON";
		break;
	    case 1:
		$dc_status = "{mlw_turned_on}";
		$dc_button_name = "{mlw_turned_off_2}";
		$button_dc_url = "/dc_cron/dc_log_semafor_OFF";
		break;
	}

	if( isset( $dc_data["dc_chenels"] ) ){
	    $dc_info_array = $dc_data["dc_chenels"];
	} else {
	    $dc_info_array = array();
	}

	if( isset( $dc_rate_data["dc_chenels"] ) ){
	    foreach( $dc_rate_data["dc_chenels"] as $dc_id => $value ){
		if( isset( $dc_info_array[$dc_id] ) ){
		    $dc_info_array[$dc_id]["rate_value"] = $dc_rate_data["dc_chenels"][$dc_id]["rate_value"] ?? 0;
		} else {
		    $dc_info_array[$dc_id]["id"] = $dc_id;
		    $dc_info_array[$dc_id]["name"] = $dc_rate_data["dc_chenels"][$dc_id]["name"] ?? 0;
		    $dc_info_array[$dc_id]["value"] = $dc_rate_data["dc_chenels"][$dc_id]["value"] ?? 0;
		    $dc_info_array[$dc_id]["rate_value"] = $dc_rate_data["dc_chenels"][$dc_id]["rate_value"] ?? 0;
		}
	    }
	}

	$last_dc_xml_updated_time = $this->dc_model->Get_last_dc_xml_updated_time();
	$last_dc_xml_yield_updated_time = $this->dc_model->Get_last_dc_xml_yield_updated_time();
	$last_dc_xml_rate_updated_time = $this->dc_model->Get_last_dc_xml_rate_updated_time();
	$max_dc_log_value = 0;
	if( $max_dc_log_value < $dc_log_days ){
	    $max_dc_log_value = $dc_log_days;
	}
	if( $max_dc_log_value < ($dc_log_rate_days + $dc_log_yield_days) ){
	    $max_dc_log_value = ($dc_log_rate_days + $dc_log_yield_days);
	}

	$dc_errors_list = $this->dc_model->get_dc_errors_list( 10 );
	$count_dc_errors = 0;
	$query = $this->db->query( "SELECT count(1) as count_dc_errors FROM dc_log_errors WHERE resolved = 0" );
	if( $query->num_rows() != 0 ){
	    $row = $query->row();
	    $count_dc_errors = $row->count_dc_errors;
	}

	if( $count_dc_errors != 0 ){
	    if( $count_dc_errors > 9 ){
		$str_count_dc_errors = '<span class="badge badge-danger" style="bottom: 4px;right: 4px;top: unset;">!</span>';
	    } else {
		$str_count_dc_errors = '<span class="badge badge-danger" style="bottom: 4px;right: 4px;top: unset;">' . $count_dc_errors . '</span>';
	    }
	    $dc_errors_link = "<a href='/chmanager_c2/dcerrors'>{caption_error} (" . $count_dc_errors . ")</a>";
	} else {
	    $str_count_dc_errors = "";
	    $dc_errors_link = "";
	}

	if( $max_dc_log_value != 0 ){

	    if( $max_dc_log_value > 9 ){
		$str_max_dc_log_value = '<span class="badge badge-deep-purple">!</span>';
	    } else {
		$str_max_dc_log_value = '<span class="badge badge-deep-purple">' . $max_dc_log_value . '</span>';
	    }
	} else {
	    $str_max_dc_log_value = "";
	}

	$sync_str = "";
	if( $dc_log_days != 0 && ($dc_log_rate_days + $dc_log_yield_days) != 0 ){
	    $sync_str = "{caption_expected} " . $dc_log_days . "/" . ($dc_log_rate_days
		    + $dc_log_yield_days) . " {caption_days} ";
	} else {

	    if( $dc_log_days != 0 ){
		$sync_str .= "{caption_expected} ";
		$sync_str .= $dc_log_days . "/";
	    } else {
		$sync_str .= "{caption_expected}  0/";
	    }

	    if( ($dc_log_rate_days + $dc_log_yield_days) != 0 ){
		$sync_str .= ($dc_log_rate_days + $dc_log_yield_days) . " {caption_days} ";
	    } else {
		$sync_str .= "0 {caption_days} ";
	    }

	    if( $dc_log_days == 0 && ($dc_log_rate_days + $dc_log_yield_days) == 0 ){
		if( $last_dc_xml_yield_updated_time > $last_dc_xml_updated_time && $last_dc_xml_rate_updated_time
			> $last_dc_xml_updated_time ){
		    if( $last_dc_xml_yield_updated_time > $last_dc_xml_rate_updated_time ){
			$sync_str = $last_dc_xml_yield_updated_time;
		    } else {
			$sync_str = $last_dc_xml_rate_updated_time;
		    }
		} else {
		    $sync_str = $last_dc_xml_updated_time;
		}
	    }
	}

	$isread_messages_count = $this->frontdesk->get_count_isread_messages();
	$threads_count = $this->messages_model->get_mc_threads_count();
	if( $threads_count > 0 ){
	    $threads_count = '<span class="badge badge-danger" style="bottom: 4px;right: 4px;top: unset;">' . $threads_count . '</span>';
	} else {
	    $threads_count = '';
	}


	if( $isread_messages_count > 0 ){
	    $show_isread_messages = '<span class="badge badge-deep-purple">' . $isread_messages_count . '</span>';
	} else {
	    $show_isread_messages = '';
	}

	$hms_version_1_class = "";
	$query = $this->db->query( "SELECT value FROM hotelix_config WHERE name LIKE 'version_1_disallow'" );
	if( $query->num_rows() != 0 ){
	    $row = $query->row();
	    if( $row->value == 1 ){
		$hms_version_1_class = "d0";
	    }
	}
	$lock_status = 0;
	$query = $this->db->query( "SELECT value FROM hotelix_config WHERE name LIKE 'lock_status'" );
	if( $query->num_rows() != 0 ){
	    $row = $query->row();
	    $lock_status = $row->value;
	}
	$lock_till_open = "";
	$query = $this->db->query( "SELECT str_value FROM hotelix_config WHERE name LIKE 'lock_till_open'" );
	if( $query->num_rows() != 0 ){
	    $row = $query->row();
	    $lock_till_open = $row->str_value;
	}

	if( $block_lock == 1 ){
	    if( $lock_status == 1 ){
		if( $lock_till_open != "" ){
		    list ( $year, $month, $day ) = explode( "-", $lock_till_open );
		    $intdatein_lock_till_open = round( gmmktime( 0, 0, 0,
				    $month, $day, $year ) / 86400 );
		    $intdatein_now = round( gmmktime( 0, 0, 0, date( "m" ),
				    date( "d" ), date( "Y" ) ) / 86400 );
		    if( $intdatein_now > $intdatein_lock_till_open ){
			die( "<meta http-equiv='refresh' content='0;url=/state/lock/new'>" );
		    } else {
			/*
			 * $data_msg = array( "id" => 19, "lock_till_open" => $lock_till_open ); $Msg .= $this->load->view('home_msg_view', $data_msg, true);
			 */
		    }
		}
	    }
	}
	// ========================= CHAT block START =========================================
	// 		Предложение, определять по выбранному для пользователя языка в системе и сопоставить с ID департамента.
	// 		Support RUS/UKR - id dept. "1"
	// 		Support PL - id dept. "6"
	// 		Support ENG - id dept. "7"
	// 		Support GEO - id dept. "8"
	// 		Support ESP - id dept. "10 "
	$user_language = strtoupper( $_SESSION['user']['language'] );
	//$chat_department = 1;
	switch( $user_language ){
	    case "RUS":
	    case "UKR":
		$chat_department = 1;
		break;
	    case "POL":
		$chat_department = 6;
		break;
	    case "GEO":
		$chat_department = 8;
		break;
	    case "SPA":
		$chat_department = 10;
		break;
	    case "ENG":
	    default:
		$chat_department = 7;
		break;
	}
	// ========================= CHAT block END   =========================================
	// ========================= CHAIN block START =========================================
	// 		$dictionary = array();
	// 		$this->mlanguages->getdictionary("header", "", $dictionary);
	// 		$chain_data = $this->chain_model->get_chainallow();
	// 		// print_r($chain_data);
	// 		if ($chain_data != 0) {
	// 		    $chain_link = '<a href="/chain">{mlw_network}</a>';
	// 		    $chain_link = '<a href="/chain">' . $dictionary['header_chain'] .'</a>';
	// 		} else {
	// 		    $chain_link = "";
	// 		}
	// 		$chain_block = "";
	// 		if ($chain_data != 0) {
	// 		    $hotels = $this->chain_model->get_hotels();
	// 		    // echo "<pre>";
	// 		    //print_r ( $hotels );
	// 		    //die();
	// 		    $data_chain_block = array(
	// 		        "hotels" => $hotels
	// 		    );
	// 		    if (isset($hdata["chain_main_url"])) {
	// 		        $data_chain_block["chain_main_url"] = $hdata["chain_main_url"];
	// 		    }
	// 		    if (isset($hdata["chain_local_url"])) {
	// 		        $data_chain_block["chain_local_url"] = $hdata["chain_local_url"];
	// 		    }
	// 		    $chain_block = $this->load->view('header_chain_block_view', $data_chain_block, true);
	// 		    //print_r($data_chain_block);
	// 		    //die();
	// 		}
	$data['chain_block_class'] = "d0";
	$data['hotels'] = array();
	$chain_allow_c2 = $this->hotelix_config->get_record( "chain_allow_c2",
		"int" );
	$chain_allow_c2 = 1;
	if( $chain_allow_c2 == 1 ){
	    $chain_data = $this->chain_model->get_chainallow();
	    if( $chain_data != 0 ){
		$hotels = $this->chain_model->get_hotels();
		if( count( $hotels ) > 1 ){

		    unset( $hotels[$this->config->item( "hotel_id" )] );
		    $data['hotels'] = $hotels;
		    $data['chain_block_class'] = "";
		}
	    }
	}
	////             echo "<pre>";
	////             print_r($hotels);
	////             die();
	// 		if ($chain_allow_c2 == 1) {
	// 		  $hotels = $this->chain_model->get_hotels();
	// 		  if(count($hotels) > 1){
	// 		      unset($hotels[$this->config->item("hotel_id")]);
	// 		      $data['hotels'] = $hotels;
	// 		      $data['chain_block_class'] = "";
	// 		  }
	// 		}
	// ========================= CHAIN block END =========================================
	$trial_days_felt_hide_class = 'd0';
	$trial_days_felt = $this->hotelix_config->get_record( "trial_days_felt",
		"int" );
	if( $trial_days_felt > 0 ){
	    $trial_days_felt_hide_class = '';
	}


	$reputation_hide_class = 'd0';
	if( $this->releases->show_newest_reviews_pages( 'reputation' ) ){
	    $reputation_hide_class = '';
	}


	// ==== billing plan access start ==========
	$data_access = array('module_name' => 'reputation');
	$billing_plan_access = $this->Access->get_billing_plan_access( $data_access );
	if( $billing_plan_access == 0 ){
	    $reputation_hide_class = 'd0';
	}
	// ==== billing plan access end ==========

	$recommendation_hide_class = 'd0';
	if( $this->releases->show_newest_recommendation_page() ){
	    $recommendation_hide_class = '';
	    $recommendations_data = $this->recommendations_model->get_recommendation_status_bar();
	    $data['rec_count'] = $recommendations_data['not_done_rec'];
	}
	$data['threads_count'] = $threads_count;
	$data['trial_days_felt_hide_class'] = $trial_days_felt_hide_class;
	$data['trial_days_felt'] = $trial_days_felt;
	$data['dc_errors_list'] = $dc_errors_list;
	$data['sync_str'] = $sync_str;
	$data['count_dc_errors'] = $count_dc_errors;
	$data['str_count_dc_errors'] = $str_count_dc_errors;
	$data['str_max_dc_log_value'] = $str_max_dc_log_value;
	$data['dc_channels'] = $dc_info_array;
	$data['dc_errors_link'] = $dc_errors_link;
	$data['dc_status'] = $dc_status;
	$data['button_dc_url'] = $button_dc_url;
	$data['dc_button_name'] = $dc_button_name;
	$data['show_isread_messages'] = $show_isread_messages;
	$data['user_fullname'] = $user['fullname'] . $user['lastname'];
	$data['user_login'] = $user['login'];
	$data['header_messages'] = $this->debugmodel->get_all_header_messages( $wizard );
	$data['hotel_id'] = $this->config->item( 'hotel_id' );
	$data['messages_list'] = $this->frontdesk_c2->get_messages_list();
	$data['session_user_id'] = $user['id'];
	$data['max_dc_log_value'] = $max_dc_log_value;
	$data['isread_messages_count'] = $isread_messages_count;
	$data['refresh_time_value'] = $this->config->item( 'refresh_time_value' );
	$data['hotel_base_url'] = $this->config->item( 'host_name' );
	$data['chat_department'] = $chat_department;
	$data['hms_version_1_class'] = $hms_version_1_class;
	$data['reputation_hide_class'] = $reputation_hide_class;
	$data['recommendation_hide_class'] = $recommendation_hide_class;
	$data['user_language'] = strtolower( $user_language );
	$data['theme_css'] = '';
	// ====== MESSAGES CENTER ==========
	//$mc_version = $this->releases->check_message_center_version();
	//$data['messages_v2_class'] = "d0";
	//$data['messages_class'] = "";
	// 		$msg_url = "/mailbox_c2/messageslist/1/1";
	// 		switch ($mc_version) {
	//             case 2:
	//                 $msg_url = "/messages_c2/channel_msg_list/1";
	// //                 $data['messages_class'] = "d0";
	// //                 $data['messages_v2_class'] = "";
	//                 break;
	//             case 3:
	//                 $msg_url = "/messages_c2/channel_msg_list/1";
	//                 //$data['messages_v2_class'] = "";
	//                 break;
	//         }
	// 		$data['channel_msg_url'] = $msg_url;

	$url_data = array('url_type' => 'support_mc_list');
	$url_support_mc_list = $this->messages_model->get_mc_urls( $url_data );
	$data['support_mc_list_url'] = $url_support_mc_list;
	$url_data = array('url_type' => 'channel_mc_list');
	$url_channel_mc_list = $this->messages_model->get_mc_urls( $url_data );
	$data['channel_msg_url'] = $url_channel_mc_list;
	$url_data = array('url_type' => 'support_mc_create');
	$url_support_mc_create = $this->messages_model->get_mc_urls( $url_data );
	$data['support_mc_create_url'] = $url_support_mc_create;
	$u_res = $this->db->select( 'theme_id' )->get_where( 'users',
			array('id' => $_SESSION['user']['id']) )->row_array();
	if( $u_res['theme_id'] > 0 ){
	    $theme_id = (string) $u_res['theme_id'];
	    if( strlen( $theme_id ) == 1 ){
		$theme_id = '0' . $theme_id;
	    }
	    $data['theme_css'] = '<link rel="stylesheet" type="text/css" href="/css/themes/styles_' . $theme_id . '.css">';
	    if( $this->config->item( 'css_agast' ) == 1 ){
		if( $theme_id == 7 ){
		    $data['theme_css'] = '<link rel="stylesheet" type="text/css" href="https://fl-hotel1-en.otelms.com/css/stambul.css">';
		}
	    }
	}

	//=============== WorkShop for support user START ==================================21.02.22
	$supportres_workshop_html = '';
	if( isset( $user['login'] ) && $user['login'] == 'support@otelms.com' ){
	    $supportres_workshop_html = '<li class="dropdown">
                                            <a class="dropdown-toggle" href="/home/adminpage_v" aria-expanded="false" target="_blank">
                                                <span class="text hidden-sm1b">WorkShop</span>
                                            </a>
                                        </li>';
	}
	$data['supportres_workshop_html'] = $supportres_workshop_html;
	$data['comands_control_block'] = $this->get_comands_control_block( array(
	    'user' => $user) );
	//=============== WorkShop for support user FINAL ==================================
	// ============= LHC SCRIPT =============
	$debug_mode_LHC = $this->session->userdata( 'global_debug' ) && $this->session->userdata( 'supportmode' );
	$data_lhc = array();
	$data_lhc['chat_department'] = $chat_department;
	$data_lhc['hotel_base_url'] = $this->config->item( 'host_name' );
	$data_lhc['user_language'] = strtolower( $user_language );
	$url_arr = explode( ".", $this->config->item( 'host_name' ) );
	$data_lhc['subdomain'] = "";
	if( isset( $url_arr[2] ) ){
	    $data_lhc['subdomain'] = $url_arr[0];
	}

	if( $debug_mode_LHC ){
	    $lhc_script = ''; //$this->parser->parse('templates/LHC_custom_test.html', $data_lhc, TRUE);
	} else {
	    if( $_SERVER['REMOTE_ADDR'] == "109.70.24.230" ){
		$lhc_script = $this->parser->parse( 'templates/LHC_agast.html',
			$data_lhc, TRUE );
	    } else {
		$lhc_script = $this->parser->parse( 'templates/LHC_otelms.html',
			$data_lhc, TRUE );
	    }
	}


	$data['lhc_script'] = $lhc_script;
	// ============= LHC SCRIPT END =============

	$company = $this->releases->get_company();
	$data['logo_img_src'] = $company['logo_header'];
	$data['company_url'] = $company['name'] . '.' . $company['main_domen'];
	$data['favicon'] = $company['favicon'];
	$this->mlanguages->getdictionary( "recommendations", "", $data );
	$this->mlanguages->getdictionary( "header", "", $data );
	$this->mlanguages->getdictionary( "mailbox_messageslist", "", $data );
//             echo $type;
//             		die();
	if( $debug_mode_LHC ){
	    $header = $this->parser->parse( 'templates/header_n_calendar_LHC_test.html',
		    $data, TRUE );
	} else {
	    if( $type == 0 ){
		$header = $this->parser->parse( 'templates/header_n.html',
			$data, TRUE );
	    } elseif( $type == 2 ){
		$header = $this->parser->parse( 'templates/header_n_calendar_light.html',
			$data, TRUE );
	    } else {
		$header = $this->parser->parse( 'templates/header_n_calendar.html',
			$data, TRUE );
	    }
	}
	//var_dump($type);
	//die("tst");
	return $header;
    }

    public function get_search_input_binary_commands()
    {
	return array(//session-value-to-init => binary-set-comand
	    'fsi_request_to_session' => 'fsi request to session',
	    'print_post_mode'	 => 'print post with debug',
	    'partners_edit_test'	 => 'partners edit test',
	    'global_stripe_test'	 => 'stripe test',
	    'global_helpsystem'	 => 'helpsystem',
	    'global_debug'		 => 'debug',
	    'global_modify'		 => 'modify',
	    'global_fms_debug'	 => 'fms',
	    'supportmode'		 => 'support',
	    'fmss_support_mode'	 => 'fmss support mode',
	);
    }

    public function get_comands_control_block( $p = array('user') )
    {
	$block = '';
	$user = isset( $p['user'] ) ? $p['user'] : null;
	if( isset( $user['login'] ) && $user['login'] == 'support@otelms.com' && $_SERVER['HTTP_HOST']
		== 'dev-ul2.otelms.com' ){
	    $binary_commands = $this->get_search_input_binary_commands();
	    $commands = array();
	    foreach( $binary_commands as $command_var => $command_name ){
		array_push( $commands,
			array(
		    'command_session_value' => $command_var,
		    'command_name'		=> $command_name
		) );
	    }
	    $block = $this->parser->parse( 'templates/debug3/header_comands_control_block.html',
		    array('commands' => $commands), TRUE );
	}
	return $block;
    }

    function GetHeader( $wizard = 0, $hdata = array(), $version = "",
	    $block_lock = 1, $route_page = "" )
    {
	// hard block start
	$sql = "SELECT * FROM visitka.config WHERE id = " . $this->config->item( 'hotel_id' );
	$query = $this->db->query( $sql );
	$row = $query->row();
	if( $row->hotelstateid == 6 ||
		$row->hotelstateid == 7 ||
		$row->hotelstateid == 5 ||
		$row->hotelstateid == 9
	){
	    die( "<meta http-equiv='refresh' content='0;url=/state/lock/state/" . $row->hotelstateid . "'>" );
	}
	// hard block end
	// ф-я контролю моно режиму
	$this->frontdesk_c2->mono_control( $_SESSION["user"]["id"] );
	//         print_r($_SESSION);
	//         die();
	// unset($_SESSION["reservations"]);
	$dictionary = array();
	$this->mlanguages->getdictionary( "header", "", $dictionary );
	$Msg = " ";
	if( $this->session->userdata( 'header_msg_text' ) != "" ){
	    $data_msg = array(
		"id" => "undefined"
	    );
	    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	    $this->session->unset_userdata( 'header_msg_text' );
	}

	if( $this->session->userdata( 'header_msg' ) != "" ){
	    $data_msg = array(
		"id" => $this->session->userdata( 'header_msg' )
	    );
	    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	    $this->session->unset_userdata( 'header_msg' );
	}
	if( $this->session->userdata( 'global_debug' ) == 1 ){
	    $data_msg = array();
	    $Msg .= $this->load->view( 'debug_msg_view', $data_msg, true );
	}

	$hms_allowed = $this->hotelix_config->get_record( "hms_allowed", "int" );
	//if ($wizard != 1 && $hms_allowed) {
	if( $wizard != 1 && 1 ){
	    $query = $this->db->query( "SELECT value FROM hotelix_config WHERE name LIKE 'wizardsetup'" );
	    $bool = 0;
	    if( $query->num_rows() > 0 ){
		$row = $query->row();
		if( $row->value == 0 ){
		    die( "<meta http-equiv='refresh' content='0;url=/wizard/step1'>" );
		}
	    }
	}
	$query = $this->db->query( "SELECT * FROM categories WHERE is_active = 1" );
	$bool = 0;
	if( $wizard == 0 ){
	    if( $query->num_rows() == 0 ){
		$data_msg = array(
		    "id" => 100
		);
		$Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
		$bool = 1;
	    }
	    $query = $this->db->query( "SELECT * FROM rooms" );
	    if( $query->num_rows() == 0 ){
		$data_msg = array(
		    "id" => 101
		);
		if( $bool != 1 ){
		    //$Msg .= $this->load->view('home_msg_view', $data_msg, true);
		}
	    }
	    $query = $this->db->query( "SELECT * FROM partners WHERE isdefault = 1" );
	    if( $query->num_rows() == 0 ){
		$data_msg = array(
		    "id" => 102
		);
		if( $bool != 1 ){
		    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
		}
	    }
	} else {
	    switch( $wizard ){
		case 8:
		    $data_msg = array(
			"id" => 8
		    );
		    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
		    break;
		case 9:
		    $data_msg = array(
			"id" => $wizard
		    );
		    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
		    break;
	    }
	}

	$query = $this->db->query( "SELECT * FROM hotelix_config WHERE name LIKE 'isMonopolymode'" );
	if( $query->num_rows() != 0 ){
	    $row = $query->row();
	    $isMonopolymode = $row->value;
	    $query = $this->db->query( "SELECT * FROM hotelix_config WHERE name LIKE 'use_actual_point'" );
	    if( $query->num_rows() != 0 ){
		$row = $query->row();
		$use_actual_point = $row->value;
		if( $use_actual_point == 1 ){
		    if( $isMonopolymode == 1 ){
			$query2 = $this->db->query( "SELECT * FROM hotelix_config WHERE name LIKE 'monopolyownerid'" );
			if( $query2->num_rows() != 0 ){
			    $row2 = $query2->row();
			    $monopolyownerid = $row2->value;
			    // if ($monopolyownerid <> $_SESSION
			    // ['user']['id']){
			    $query3 = $this->db->query( "SELECT fullname, lastname FROM users WHERE id = " . $monopolyownerid );
			    if( $query3->num_rows() != 0 ){
				$row3 = $query3->row();
				$user_name = $row3->fullname . " " . $row3->lastname;
				$data_msg = array(
				    "id"	    => 6,
				    "user_name" => $user_name
				);
				$Msg .= $this->load->view( 'home_msg_view',
					$data_msg, true );
			    }

			    // }
			}
		    }
		}
	    }
	}


	$hms_billing_version = $this->hotelix_config->get_record( "hms_billing_version",
		"int" );
	if( $hms_billing_version == 2 ){
	    // =================== дозволятор-маршрутизатор START =============================
	    $allowed_pages_arr = array("stripe_rate", "support_ticketslist_c2", "home_feedback_c2",
		"errors_c2", "stripe_invoices", "stripe_cards");
	    $lock_till_open_date = $this->hotelix_config->get_record( "lock_till_open" );
	    $is_locked_till_open = ((strtotime( $lock_till_open_date ) - strtotime( date( "Y-m-d" ) )) <= 0)
			? true : false;
	    if( $is_locked_till_open ){
		$hms_allowed = $this->hotelix_config->get_record( "hms_allowed",
			"int" );
		$hms_route = $this->hotelix_config->get_record( "hms_route" );
		if( !$hms_allowed ){
		    if( !in_array( $route_page, $allowed_pages_arr ) ){
			switch( $hms_route ){
			    case "stripe_rate":
				$die_url = "/stripe_concept/plans";
				break;
			    case "stripe_invoices":
				$die_url = "/stripe_concept/summary"; //TEMP to summary was /stripe_concept/invoices
				break;
			    default:
				$die_url = "/stripe_concept/plans";
			}
			die( "<meta http-equiv='refresh' content='0;url=$die_url'>" );
		    }
		}
	    }
	    // =================== дозволятор-маршрутизатор FINISH =============================
	    //========== hms_allowed = 0, billing =2 якщо в тебе немає підписки виводити повідомлення, з кнопкою отложить (30хв) START ===========
	    $hms_allowed = $this->hotelix_config->get_record( "hms_allowed",
		    "int" );
	    $stripe_plan_id = $this->hotelix_config->get_record( "stripe_plan_id" );
	    $stripe_subscription_id = $this->hotelix_config->get_record( "stripe_subscription_id" );
	    if( $hms_allowed == 0 && $stripe_plan_id == "" ){
		if( $is_locked_till_open ){//hms_notification_id_8 {clt_hm_no_stripe_plan}
		    $hms_notification_id = 8;
		    $access_be_closed_date = "";
		} else {//hms_notification_id_9 {clt_hm_no_stripe_plan} {clt_hm_access_be_closed}
		    $hms_notification_id = 9;
		    $access_be_closed_date = $lock_till_open_date;
		}
		$need_show_msg = false;
		$user_id = $_SESSION ["user"] ["id"];
		$sql = "SELECT remind_date FROM hms_system_alarm WHERE user_id = $user_id AND hms_notification_id = $hms_notification_id";
		$query = $this->db->query( $sql );
		if( $query->num_rows() > 0 ){
		    $remind_date = $query->row()->remind_date;
		    if( $remind_date < time() ){
			$need_show_msg = true;
		    }
		} else {
		    $need_show_msg = true;
		}
		if( $need_show_msg ){
		    $data_msg = array(
			"id"			=> 112,
			"hms_notification_id"	=> $hms_notification_id,
			"access_be_closed_date" => $access_be_closed_date,
		    );
		    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
		}
	    }
	    //========== hms_allowed = 0, billing =2 якщо в тебе немає підписки виводити повідомлення, з кнопкою отложить (30хв) FINISH ===========
	}
	//===============!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! TUT здається дубль START 26.04.19
	if( $block_lock == 1 ){
	    $lock_status = 0;
	    $query = $this->db->query( "SELECT value FROM hotelix_config WHERE name LIKE 'lock_status'" );
	    if( $query->num_rows() != 0 ){
		$row = $query->row();
		$lock_status = $row->value;
	    }
	    $lock_till_open = "";
	    $query = $this->db->query( "SELECT str_value FROM hotelix_config WHERE name LIKE 'lock_till_open'" );
	    if( $query->num_rows() != 0 ){
		$row = $query->row();
		$lock_till_open = $row->str_value;
	    }
	    if( $lock_status == 1 ){
		if( $lock_till_open != "" ){
		    list ( $year, $month, $day ) = explode( "-", $lock_till_open );
		    $intdatein_lock_till_open = round( gmmktime( 0, 0, 0,
				    $month, $day, $year ) / 86400 );
		    $intdatein_now = round( gmmktime( 0, 0, 0, date( "m" ),
				    date( "d" ), date( "Y" ) ) / 86400 );
		    if( $intdatein_now > $intdatein_lock_till_open ){
			die( "<meta http-equiv='refresh' content='0;url=/state/lock'>" );
		    } else {
			$data_msg = array(
			    "id"		 => 19,
			    "lock_till_open" => $lock_till_open
			);
			$Msg .= $this->load->view( 'home_msg_view', $data_msg,
				true );
		    }
		}
	    }
	}
	//===============!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! TUT здається дубль FINISH 26.04.19
	$notify_array = array();
	$sql = "SELECT * FROM notification WHERE status = 0 AND user_id = " . $_SESSION["user"]["id"];
	$query = $this->db->query( $sql );
	if( $query->num_rows() > 0 ){
	    $i = 0;
	    foreach( $query->result() as $row ){
		$notify_array[$i] = $row->notify_id;
		$i++;
	    }
	}
	$remind_date = time();
	$notify_array = array();
	$sql = "SELECT * FROM global_hotelix.hms_erp WHERE hms_id = " . $this->config->item( 'hotel_id' );
	$query = $this->db->query( $sql );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $current_balance = $row->current_balance;
	    $hms_billing_version = $this->hotelix_config->get_record( "hms_billing_version",
		    "int" );
	    //if ($current_balance < 0) {
	    if( $current_balance < 0 && $hms_billing_version != 2 ){
		if( $current_balance + $row->rate < 0 ){
		    $notify_msg = "";
		    $sql2 = "SELECT remind_date, user_id FROM hms_system_alarm WHERE hms_notification_id = 3 AND user_id = " . $_SESSION["user"]["id"];
		    $query2 = $this->db->query( $sql2 );
		    if( $query2->num_rows() > 0 ){
			$row2 = $query2->row();
			if( $row2->remind_date == 0 || $row2->remind_date <= $remind_date ){
			    $sql3 = "SELECT text FROM global_hotelix.hms_notification WHERE id = 3";
			    $query3 = $this->db->query( $sql3 );
			    if( $query3->num_rows() > 0 ){
				$row3 = $query3->row();
				$notify_msg = $row3->text;
			    }
			}
		    } else {
			$sql3 = "SELECT text FROM global_hotelix.hms_notification WHERE id = 3";
			$query3 = $this->db->query( $sql3 );
			if( $query3->num_rows() > 0 ){
			    $row3 = $query3->row();
			    $notify_msg = $row3->text;
			}
		    }
		} else {
		    $notify_msg = "";
		    $sql2 = "SELECT remind_date, user_id FROM hms_system_alarm WHERE hms_notification_id = 1 AND user_id = " . $_SESSION["user"]["id"];
		    $query2 = $this->db->query( $sql2 );
		    if( $query2->num_rows() > 0 ){
			$row2 = $query2->row();
			if( $row2->remind_date == 0 || $row2->remind_date <= $remind_date ){
			    $sql3 = "SELECT text FROM global_hotelix.hms_notification WHERE id = 1";
			    $query3 = $this->db->query( $sql3 );
			    if( $query3->num_rows() > 0 ){
				$row3 = $query3->row();
				$notify_msg = $row3->text;
			    }
			}
		    } else {
			$sql3 = "SELECT text FROM global_hotelix.hms_notification WHERE id = 1";
			$query3 = $this->db->query( $sql3 );
			if( $query3->num_rows() > 0 ){
			    $row3 = $query3->row();
			    $notify_msg = $row3->text;
			}
		    }
		}

		if( trim( $notify_msg ) <> "" ){
		    $data_msg = array(
			"id"	     => 18,
			"notify_msg" => $notify_msg
		    );
		    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
		}
	    }
	}
	if( count( $notify_array ) > 0 ){
	    $data_msg = array(
		"id"	       => 10,
		"notify_array" => $notify_array
	    );
	    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	}

	$IsPeriodDelay = $this->frontdesk->IsPeriodDelay();
	if( $IsPeriodDelay == 1 ){
	    $data_msg = array(
		"id" => 7
	    );
	    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	}
	$query = $this->db->query( "SELECT * FROM logo" );
	$logo_title = "";
	$logo_img = "";
	$img_path_templates = $this->config->item( 'img_path_templates' );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $logo_title = stripslashes( $row->logo_title );
	    $logo_img = stripslashes( $row->logo_img );
	}
	$url = $img_path_templates . $logo_img;
	$admin_link = $this->config->item( 'admin_link' );
	$search = "искать здесь...";
	$search = stripslashes( $this->session->userdata( 'search_main' ) );
	$query = $this->db->query( "SELECT * FROM `hotelix_config` WHERE name LIKE 'actual_point_int_date'" );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    // $close_day_status = $row->status;
	    $close = $row->value;
	    $unix_time = $close * 86400;
	    $date = date( "d-m-Y", $unix_time );
	    // list ( $year_out, $month_out, $day_out ) = split ( "-", $date);
	    // $date = date("d m Y", mktime(0, 0, 0, $month_out, $day_out,
	    // $year_out));
	    $date_mass = explode( "-", $date );
	    // print_r ($date);
	    switch( $date_mass[1] ){
		case 1:
		    $m = '{mlw_month_january_3}';
		    break;
		case 2:
		    $m = '{mlw_month_fabruary_3}';
		    break;
		case 3:
		    $m = '{mlw_month_march_3}';
		    break;
		case 4:
		    $m = '{mlw_month_april_3}';
		    break;
		case 5:
		    $m = '{mlw_month_may_3}';
		    break;
		case 6:
		    $m = '{mlw_month_june_3}';
		    break;
		case 7:
		    $m = '{mlw_month_july_3}';
		    break;
		case 8:
		    $m = '{mlw_month_august_3}';
		    break;
		case 9:
		    $m = '{mlw_month_september_3}';
		    break;
		case 10:
		    $m = '{mlw_month_october_3}';
		    break;
		case 11:
		    $m = '{mlw_month_november_3}';
		    break;
		case 12:
		    $m = '{mlw_month_december_3}';
		    break;
	    }
	    $date = $date_mass[0] . " " . $m . " " . $date_mass[2] . "г.";
	}

	$dc_data = $this->dc_model->dc_log_lc_status();
	$dc_rate_data = $this->dc_model->dc_log_rate_lc_status();
	$dc_log_days = $this->dc_model->dc_log_lc_status_byday();
	$dc_log_yield_days = $this->dc_model->dc_log_yield_lc_status_byday();
	$dc_log_rate_days = $this->dc_model->dc_log_rate_lc_status_byday();
	switch( $dc_data["status"] ){
	    case 0:
		$dc_status = "{mlw_turned_off}";
		$dc_button_name = "{mlw_turned_on_2}";
		$dc_button = "<button onClick=\"dc_switch ();\">" . $dc_button_name . "</button>";
		$button_dc_url = "/dc_cron/dc_log_semafor_ON";
		break;
	    case 1:
		$dc_status = "{mlw_turned_on}";
		$dc_button_name = "{mlw_turned_off_2}";
		$dc_button = "<a href=\"#dialog_offsync\" name=\"modal\" ><button >" . $dc_button_name . "</button></a>";
		$button_dc_url = "/dc_cron/dc_log_semafor_OFF";
		break;
	}

	if( isset( $dc_data["dc_chenels"] ) ){
	    $dc_info_array = $dc_data["dc_chenels"];
	} else {
	    $dc_info_array = array();
	}

	// $dc_info_array
	if( isset( $dc_rate_data["dc_chenels"] ) ){
	    foreach( $dc_rate_data["dc_chenels"] as $dc_id => $value ){
		if( isset( $dc_info_array[$dc_id] ) ){
		    $dc_info_array[$dc_id]["rate_value"] = $dc_rate_data["dc_chenels"][$dc_id]["rate_value"];
		} else {
		    $dc_info_array[$dc_id]["id"] = $dc_id;
		    $dc_info_array[$dc_id]["name"] = $dc_rate_data["dc_chenels"][$dc_id]["name"];
		    $dc_info_array[$dc_id]["value"] = $dc_rate_data["dc_chenels"][$dc_id]["value"];
		    $dc_info_array[$dc_id]["rate_value"] = $dc_rate_data["dc_chenels"][$dc_id]["rate_value"];
		}
	    }
	}
	// echo "<pre>";
	// print_r($dc_info_array);
	// die();
	$last_dc_xml_updated_time = $this->dc_model->Get_last_dc_xml_updated_time();
	$last_dc_xml_yield_updated_time = $this->dc_model->Get_last_dc_xml_yield_updated_time();
	$last_dc_xml_rate_updated_time = $this->dc_model->Get_last_dc_xml_rate_updated_time();
	/*
	 * if ($dc_log_days != 0 && $dc_log_rate_days != 0) {
	 * $dc_log_days = "ожидается " . $dc_log_days . " дней";
	 * } else {
	 * $dc_log_days = $last_dc_xml_updated_time;
	 * }
	 * echo $dc_log_days." !!".$dc_log_rate_days."!!";
	 * if ($dc_log_rate_days != 0) {
	 * $dc_log_rate_days = " / " . $dc_log_rate_days . " дней";
	 * } else {
	 * $dc_log_rate_days = $last_dc_xml_rate_updated_time;
	 * }
	 */
	$sync_str = "";
	if( $dc_log_days != 0 && ($dc_log_rate_days + $dc_log_yield_days) != 0 ){
	    $sync_str = "{caption_expected} " . $dc_log_days . "/" . ($dc_log_rate_days
		    + $dc_log_yield_days) . " {caption_days} ";
	} else {

	    if( $dc_log_days != 0 ){
		$sync_str .= "{caption_expected} ";
		$sync_str .= $dc_log_days . "/";
	    } else {
		$sync_str .= "{caption_expected}  0/";
	    }

	    if( ($dc_log_rate_days + $dc_log_yield_days) != 0 ){
		$sync_str .= ($dc_log_rate_days + $dc_log_yield_days) . " {caption_days} ";
	    } else {
		$sync_str .= "0 {caption_days} ";
	    }

	    if( $dc_log_days == 0 && ($dc_log_rate_days + $dc_log_yield_days) == 0 ){
		if( $last_dc_xml_yield_updated_time > $last_dc_xml_updated_time && $last_dc_xml_rate_updated_time
			> $last_dc_xml_updated_time ){
		    if( $last_dc_xml_yield_updated_time > $last_dc_xml_rate_updated_time ){
			$sync_str = $last_dc_xml_yield_updated_time;
		    } else {
			$sync_str = $last_dc_xml_rate_updated_time;
		    }
		} else {
		    $sync_str = $last_dc_xml_updated_time;
		}
	    }
	}

	$time = date( "d.m.Y H:i" );
	$hotel_id = 0;
	$host = $_SERVER["HTTP_HOST"];
	/*
	 * $sql = "SELECT * FROM visitka.config WHERE host LIKE '$host'"; $query = $this->db->query ( $sql ); if ($query->num_rows () != 0) { $row = $query->row (); $hotel_id = $row->id; }
	 */
	$hotel_id = $this->config->item( 'hotel_id' );
	$chain_data = $this->chain_model->get_chainallow();
	// print_r($chain_data);
	if( $chain_data != 0 ){
	    $chain_link = '<a href="/chain">{mlw_network}</a>';
	    $chain_link = '<a href="/chain">' . $dictionary['header_chain'] . '</a>';
	} else {
	    $chain_link = "";
	}

	$count_dc_errors = 0;
	$query = $this->db->query( "SELECT count(1) as count_dc_errors FROM dc_log_errors WHERE resolved = 0" );
	if( $query->num_rows() != 0 ){
	    $row = $query->row();
	    $count_dc_errors = $row->count_dc_errors;
	}

	if( $count_dc_errors != 0 ){
	    $dc_errors = "<a href='/chmanager/dcerrors'>( {caption_error}: " . $count_dc_errors . " )</a>";
	} else {
	    $dc_errors = "";
	}

	if( isset( $_SESSION["dc_msg"]["text"] ) ){
	    $data_msg = array(
		"id" => 11
	    );
	    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	}

	$query2 = $this->db->query( "SELECT * FROM hotelix_config WHERE name LIKE 'overbooking_category_id'" );
	if( $query2->num_rows() != 0 ){
	    $row2 = $query2->row();
	    if( $row2->value == 0 or $row2->value == "" ){
		$data_msg = array(
		    "id" => 12
		);
		$Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	    }
	} else {
	    $data_msg = array(
		"id" => 12
	    );
	    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	}
	if( isset( $_SESSION["isrestrict"] ) ){
	    $data_msg = array(
		"id" => 17
	    );
	    //$Msg .= $this->load->view('home_msg_view', $data_msg, true);
	}
	$chain_block = "";
	if( $chain_data != 0 ){
	    $hotels = $this->chain_model->get_hotels();
	    // echo "<pre>";
	    //print_r ( $hotels );
	    //die();

	    $data_chain_block = array(
		"hotels" => $hotels
	    );
	    if( isset( $hdata["chain_main_url"] ) ){
		$data_chain_block["chain_main_url"] = $hdata["chain_main_url"];
	    }
	    if( isset( $hdata["chain_local_url"] ) ){
		$data_chain_block["chain_local_url"] = $hdata["chain_local_url"];
	    }
	    $chain_block = $this->load->view( 'header_chain_block_view',
		    $data_chain_block, true );
	    //print_r($data_chain_block);
	    //die();
	}
	$count_group = 0;
	if( isset( $_SESSION['reservations'] ) ){
	    $count_group = count( $_SESSION['reservations'] );
	}

	//print_r($chain_block);
	//die();

	$notify = $this->frontdesk->get_notify();
	if( $notify == 1 ){
	    $helpnotifycss = "_active";
	} else {
	    $helpnotifycss = "";
	}

	$notify_array = array();
	$remind_date = time();
	$sql = "SELECT * FROM hms_alarm WHERE state = 0 AND user_id = " . $_SESSION["user"]["id"] . " AND (remind_date=0 OR remind_date <= " . $remind_date . " )";
	$query = $this->db->query( $sql );
	if( $query->num_rows() > 0 ){
	    $i = 0;
	    foreach( $query->result() as $row ){
		//$notify_array[$i]["message"] = $row->message;
		//$notify_array[$i]["remind_date"] = $row->remind_date;
		$i++;
		$data_msg = array(
		    "id"			=> 21,
		    //"alarm_id" => $row->id,
		    "hms_alarm_template_id" => $row->hms_alarm_template_id
			//,
			//"alarm_remind_date" => $row->remind_date
		);
		$Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	    }
	}

	$sql = "SELECT * FROM cases_crm WHERE state = 1";
	$query = $this->db->query( $sql );
	if( $query->num_rows() > 0 ){
	    foreach( $query->result() as $row ){
		$data_msg = array(
		    "id"	     => 22,
		    "uid"	     => $row->id,
		    "notify_msg" => $row->message
			//"alarm_remind_date" => $row->remind_date
		);
		$Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	    }
	}


	if( count( $notify_array ) > 0 && 1 == 0 ){
	    $data_msg = array(
		"id"	       => 20,
		"notify_array" => $notify_array
	    );
	    //$Msg .= $this->load->view('home_msg_view', $data_msg, true);
	}

	if( isset( $_SESSION ['user']['language'] ) ){
	    $lang = $_SESSION ['user']['language'];
	} else {
	    $sql = "select language from visitka.config where id = " . $this->config->item( 'hotel_id' );
	    $query = $this->db->query( $sql );
	    if( $query->num_rows() ){
		$row = $query->row();
		$lang = $row->language;
	    }
	}

	switch( $lang ){
	    case "eng" :
		$calendar_lang = '<script src="/src/js/lang/en.js"></script>';
		break;
	    case "pol" :
		$calendar_lang = '<script src="/src/js/lang/pl.js"></script>';
		break;
	    case "rus" :
		$calendar_lang = '<script src="/src/js/lang/ru.js"></script>';
		break;
	    case "ukr" :
		$calendar_lang = '<script src="/src/js/lang/ua.js"></script>';
		break;
	    case "ukr" :
		$calendar_lang = '<script src="/src/js/lang/ua.js"></script>';
	    case "geo" :
		$calendar_lang = '<script src="/src/js/lang/en.js"></script>';
		break;
	    default :
		$calendar_lang = '<script src="/src/js/lang/ru.js"></script>';
		break;
	}

	$Msg .= $this->debugmodel->get_biiling_messages_v1();
	$data = array(
	    'calendar_lang'	   => $calendar_lang,
	    'sync_str'	   => $sync_str,
	    'dc_button'	   => $dc_button,
	    'count_group'	   => $count_group,
	    'chain_block'	   => $chain_block,
	    'dc_errors'	   => $dc_errors,
	    'chain_link'	   => $chain_link,
	    'hotel_id'	   => $hotel_id,
	    'dc_log_rate_days' => $dc_log_rate_days,
	    'dc_log_days'	   => $dc_log_days,
	    'dc_data'	   => $dc_info_array,
	    'dc_status'	   => $dc_status,
	    'dc_button_name'   => $dc_button_name,
	    'button_dc_url'	   => $button_dc_url,
	    'time'		   => $time,
	    'closedate'	   => $date,
	    'msg'		   => $Msg,
	    'mainmenulist'	   => $this->navigation->getrootlist(),
	    'hotel_name'	   => $logo_title,
	    'url'		   => $url,
	    'admin_link'	   => $admin_link,
	    'fullname'	   => $_SESSION['user']['fullname'],
	    'lastname'	   => $_SESSION['user']['lastname'],
	    'user_id'	   => $_SESSION['user']['id'],
	    "search"	   => $search,
	    "helpnotifycss"	   => $helpnotifycss,
	    "user_email"	   => $_SESSION ['user'] ['login']
	);
	//          echo "<pre>".$version;
	//          die();
	// print_r( $_SESSION ['reservations'] );
	$data['refresh_time_value'] = $this->config->item( 'refresh_time_value' );
	$this->mlanguages->getdictionary( "mlw", "", $data );
	$this->mlanguages->getdictionary( "header", "", $data );
	$this->mlanguages->getdictionary( "home_msg_hms_massages", "", $data );
	// echo($version);die();
	$header = $this->parser->parse( 'templates/header' . $version . '.html',
		$data, TRUE );
	return $header;
    }

    function GetHeader_v2( $wizard = 0, $hdata = array() )
    {
	// print_r($_SESSION);
	// unset($_SESSION["reservations"]);
	$Msg = " ";
	if( $this->session->userdata( 'header_msg' ) != "" ){
	    $data_msg = array(
		"id" => $this->session->userdata( 'header_msg' )
	    );
	    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	    $this->session->unset_userdata( 'header_msg' );
	}
	if( $this->session->userdata( 'global_debug' ) == 1 ){
	    $data_msg = array();
	    $Msg .= $this->load->view( 'debug_msg_view', $data_msg, true );
	}
	if( $wizard != 1 ){
	    $query = $this->db->query( "SELECT value FROM hotelix_config WHERE name LIKE 'wizardsetup'" );
	    $bool = 0;
	    if( $query->num_rows() > 0 ){
		$row = $query->row();
		if( $row->value == 0 ){
		    die( "<meta http-equiv='refresh' content='0;url=/wizard/step1'>" );
		}
	    }
	}
	$query = $this->db->query( "SELECT * FROM categories WHERE is_active = 1" );
	$bool = 0;
	if( $wizard == 0 ){
	    if( $query->num_rows() == 0 ){
		$data_msg = array(
		    "id" => 100
		);
		$Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
		$bool = 1;
	    }
	    $query = $this->db->query( "SELECT * FROM rooms" );
	    if( $query->num_rows() == 0 ){
		$data_msg = array(
		    "id" => 101
		);
		if( $bool != 1 ){
		    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
		}
	    }
	    $query = $this->db->query( "SELECT * FROM partners WHERE isdefault = 1" );
	    if( $query->num_rows() == 0 ){
		$data_msg = array(
		    "id" => 102
		);
		if( $bool != 1 ){
		    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
		}
	    }
	} else {
	    switch( $wizard ){
		case 8:
		    $data_msg = array(
			"id" => 8
		    );
		    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
		    break;
		case 9:
		    $data_msg = array(
			"id" => $wizard
		    );
		    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
		    break;
	    }
	}

	$query = $this->db->query( "SELECT * FROM hotelix_config WHERE name LIKE 'isMonopolymode'" );
	if( $query->num_rows() != 0 ){
	    $row = $query->row();
	    $isMonopolymode = $row->value;
	    $query = $this->db->query( "SELECT * FROM hotelix_config WHERE name LIKE 'use_actual_point'" );
	    if( $query->num_rows() != 0 ){
		$row = $query->row();
		$use_actual_point = $row->value;
		if( $use_actual_point == 1 ){
		    if( $isMonopolymode == 1 ){
			$query2 = $this->db->query( "SELECT * FROM hotelix_config WHERE name LIKE 'monopolyownerid'" );
			if( $query2->num_rows() != 0 ){
			    $row2 = $query2->row();
			    $monopolyownerid = $row2->value;
			    // if ($monopolyownerid <> $_SESSION
			    // ['user']['id']){
			    $query3 = $this->db->query( "SELECT fullname, lastname FROM users WHERE id = " . $monopolyownerid );
			    if( $query3->num_rows() != 0 ){
				$row3 = $query3->row();
				$user_name = $row3->fullname . " " . $row3->lastname;
				$data_msg = array(
				    "id"	    => 6,
				    "user_name" => $user_name
				);
				$Msg .= $this->load->view( 'home_msg_view',
					$data_msg, true );
			    }

			    // }
			}
		    }
		}
	    }
	}
	$lock_status = 0;
	$query = $this->db->query( "SELECT value FROM hotelix_config WHERE name LIKE 'lock_status'" );
	if( $query->num_rows() != 0 ){
	    $row = $query->row();
	    $lock_status = $row->value;
	}
	$lock_till_open = "";
	$query = $this->db->query( "SELECT str_value FROM hotelix_config WHERE name LIKE 'lock_till_open'" );
	if( $query->num_rows() != 0 ){
	    $row = $query->row();
	    $lock_till_open = $row->str_value;
	}
	if( $lock_status == 1 ){
	    if( $lock_till_open != "" ){
		list ($year, $month, $day) = explode( "-", $lock_till_open );
		$intdatein_lock_till_open = round( gmmktime( 0, 0, 0, $month,
				$day, $year ) / 86400 );
		$intdatein_now = round( gmmktime( 0, 0, 0, date( "m" ),
				date( "d" ), date( "Y" ) ) / 86400 );
		if( $intdatein_now > $intdatein_lock_till_open ){
		    die( "<meta http-equiv='refresh' content='0;url=/state/lock/v2'>" );
		} else {
		    $data_msg = array(
			"id"		 => 19,
			"lock_till_open" => $lock_till_open
		    );
		    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
		}
	    }
	}
	$notify_array = array();
	$sql = "SELECT * FROM notification WHERE status = 0 AND user_id = " . $_SESSION["user"]["id"];
	$query = $this->db->query( $sql );
	if( $query->num_rows() > 0 ){
	    $i = 0;
	    foreach( $query->result() as $row ){
		$notify_array[$i] = $row->notify_id;
		$i++;
	    }
	}

	$notify_array = array();
	$sql = "SELECT * FROM global_hotelix.hms_erp WHERE hms_id = " . $this->config->item( 'hotel_id' );
	$query = $this->db->query( $sql );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $current_balance = $row->current_balance;
	    if( $current_balance < 0 ){
		if( $current_balance + $row->rate < 0 ){
		    $sql2 = "SELECT text FROM global_hotelix.hms_notification WHERE id = 3";
		    $query2 = $this->db->query( $sql2 );
		    $notify_msg = "";
		    if( $query2->num_rows() > 0 ){
			$row2 = $query2->row();
			$notify_msg = $row2->text;
		    }
		} else {
		    $sql2 = "SELECT text FROM global_hotelix.hms_notification WHERE id = 1";
		    $query2 = $this->db->query( $sql2 );
		    $notify_msg = "";
		    if( $query2->num_rows() > 0 ){
			$row2 = $query2->row();
			$notify_msg = $row2->text;
		    }
		}

		$data_msg = array(
		    "id"	     => 18,
		    "notify_msg" => $notify_msg
		);
		$Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	    }
	}
	if( count( $notify_array ) > 0 ){
	    $data_msg = array(
		"id"	       => 10,
		"notify_array" => $notify_array
	    );
	    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	}

	$IsPeriodDelay = $this->frontdesk->IsPeriodDelay();
	if( $IsPeriodDelay == 1 ){
	    $data_msg = array(
		"id" => 7
	    );
	    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	}
	$query = $this->db->query( "SELECT * FROM logo" );
	$logo_title = "";
	$logo_img = "";
	$img_path_templates = $this->config->item( 'img_path_templates' );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $logo_title = stripslashes( $row->logo_title );
	    $logo_img = stripslashes( $row->logo_img );
	}
	$url = $img_path_templates . $logo_img;
	$admin_link = $this->config->item( 'admin_link' );
	$search = "искать здесь...";
	$search = stripslashes( $this->session->userdata( 'search_main' ) );
	$query = $this->db->query( "SELECT * FROM `hotelix_config` WHERE name LIKE 'actual_point_int_date'" );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    // $close_day_status = $row->status;
	    $close = $row->value;
	    $unix_time = $close * 86400;
	    $date = date( "d-m-Y", $unix_time );
	    // list ( $year_out, $month_out, $day_out ) = split ( "-", $date);
	    // $date = date("d m Y", mktime(0, 0, 0, $month_out, $day_out,
	    // $year_out));
	    $date_mass = explode( "-", $date );
	    // print_r ($date);
	    switch( $date_mass[1] ){
		case 1:
		    $m = 'января';
		    break;
		case 2:
		    $m = 'февраля';
		    break;
		case 3:
		    $m = 'марта';
		    break;
		case 4:
		    $m = 'апреля';
		    break;
		case 5:
		    $m = 'мая';
		    break;
		case 6:
		    $m = 'июня';
		    break;
		case 7:
		    $m = 'июля';
		    break;
		case 8:
		    $m = 'августа';
		    break;
		case 9:
		    $m = 'сентября';
		    break;
		case 10:
		    $m = 'октября';
		    break;
		case 11:
		    $m = 'ноября';
		    break;
		case 12:
		    $m = 'декабря';
		    break;
	    }
	    $date = $date_mass[0] . " " . $m . " " . $date_mass[2] . "г.";
	}

	$dc_data = $this->dc_model->dc_log_lc_status();
	$dc_rate_data = $this->dc_model->dc_log_rate_lc_status();
	$dc_log_days = $this->dc_model->dc_log_lc_status_byday();
	$dc_log_yield_days = $this->dc_model->dc_log_yield_lc_status_byday();
	$dc_log_rate_days = $this->dc_model->dc_log_rate_lc_status_byday();
	switch( $dc_data["status"] ){
	    case 0:
		$dc_status = "Выключено";
		$dc_button_name = "Включить";
		$dc_button = "<button onClick=\"dc_switch ();\">" . $dc_button_name . "</button>";
		$button_dc_url = "/dc_cron/dc_log_semafor_ON";
		break;
	    case 1:
		$dc_status = "Включено";
		$dc_button_name = "Выключить";
		$dc_button = "<a href=\"#dialog_offsync\" name=\"modal\" ><button >" . $dc_button_name . "</button></a>";
		$button_dc_url = "/dc_cron/dc_log_semafor_OFF";
		break;
	}

	if( isset( $dc_data["dc_chenels"] ) ){
	    $dc_info_array = $dc_data["dc_chenels"];
	} else {
	    $dc_info_array = array();
	}

	// $dc_info_array
	if( isset( $dc_rate_data["dc_chenels"] ) ){
	    foreach( $dc_rate_data["dc_chenels"] as $dc_id => $value ){
		if( isset( $dc_info_array[$dc_id] ) ){
		    $dc_info_array[$dc_id]["rate_value"] = $dc_rate_data["dc_chenels"][$dc_id]["rate_value"];
		} else {
		    $dc_info_array[$dc_id]["id"] = $dc_id;
		    $dc_info_array[$dc_id]["name"] = $dc_rate_data["dc_chenels"][$dc_id]["name"];
		    $dc_info_array[$dc_id]["value"] = $dc_rate_data["dc_chenels"][$dc_id]["value"];
		    $dc_info_array[$dc_id]["rate_value"] = $dc_rate_data["dc_chenels"][$dc_id]["rate_value"];
		}
	    }
	}
	// echo "<pre>";
	// print_r($dc_info_array);
	// die();
	$last_dc_xml_updated_time = $this->dc_model->Get_last_dc_xml_updated_time();
	$last_dc_xml_yield_updated_time = $this->dc_model->Get_last_dc_xml_yield_updated_time();
	$last_dc_xml_rate_updated_time = $this->dc_model->Get_last_dc_xml_rate_updated_time();
	/*
	 * if ($dc_log_days != 0 && $dc_log_rate_days != 0) {
	 * $dc_log_days = "ожидается " . $dc_log_days . " дней";
	 * } else {
	 * $dc_log_days = $last_dc_xml_updated_time;
	 * }
	 * echo $dc_log_days." !!".$dc_log_rate_days."!!";
	 * if ($dc_log_rate_days != 0) {
	 * $dc_log_rate_days = " / " . $dc_log_rate_days . " дней";
	 * } else {
	 * $dc_log_rate_days = $last_dc_xml_rate_updated_time;
	 * }
	 */
	$sync_str = "";
	if( $dc_log_days != 0 && ($dc_log_rate_days + $dc_log_yield_days) != 0 ){
	    $sync_str = "ожидается " . $dc_log_days . "/" . ($dc_log_rate_days + $dc_log_yield_days) . " дней ";
	} else {
	    $sync_str .= "ожидается ";
	    if( $dc_log_days != 0 ){
		$sync_str .= $dc_log_days . "/";
	    } else {
		$sync_str .= "ожидается  0/";
	    }

	    if( ($dc_log_rate_days + $dc_log_yield_days) != 0 ){
		$sync_str .= ($dc_log_rate_days + $dc_log_yield_days) . " дней ";
	    } else {
		$sync_str .= "0 дней ";
	    }

	    if( $dc_log_days == 0 && ($dc_log_rate_days + $dc_log_yield_days) == 0 ){
		if( $last_dc_xml_yield_updated_time > $last_dc_xml_updated_time && $last_dc_xml_rate_updated_time
			> $last_dc_xml_updated_time ){
		    if( $last_dc_xml_yield_updated_time > $last_dc_xml_rate_updated_time ){
			$sync_str = $last_dc_xml_yield_updated_time;
		    } else {
			$sync_str = $last_dc_xml_rate_updated_time;
		    }
		} else {
		    $sync_str = $last_dc_xml_updated_time;
		}
	    }
	}

	$time = date( "d.m.Y H:i" );
	$hotel_id = 0;
	$host = $_SERVER["HTTP_HOST"];
	/*
	 * $sql = "SELECT * FROM visitka.config WHERE host LIKE '$host'"; $query = $this->db->query ( $sql ); if ($query->num_rows () != 0) { $row = $query->row (); $hotel_id = $row->id; }
	 */
	$hotel_id = $this->config->item( 'hotel_id' );
	$chain_data = $this->chain_model->get_chainallow();
	// print_r($chain_data);
	if( $chain_data != 0 ){
	    $chain_link = '<a href="/chain">Сеть</a>';
	    $chain_link = '<a href="/chain">' . $navMenuDic['header_chain'] . '</a>';
	} else {
	    $chain_link = "";
	}

	$count_dc_errors = 0;
	$query = $this->db->query( "SELECT count(1) as count_dc_errors FROM dc_log_errors WHERE resolved = 0" );
	if( $query->num_rows() != 0 ){
	    $row = $query->row();
	    $count_dc_errors = $row->count_dc_errors;
	}

	if( $count_dc_errors != 0 ){
	    $dc_errors = "<a href='/chmanager/dcerrors'>( {caption_error}: " . $count_dc_errors . " )</a>";
	} else {
	    $dc_errors = "";
	}

	if( isset( $_SESSION["dc_msg"]["text"] ) ){
	    $data_msg = array(
		"id" => 11
	    );
	    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	}

	$query2 = $this->db->query( "SELECT * FROM hotelix_config WHERE name LIKE 'overbooking_category_id'" );
	if( $query2->num_rows() != 0 ){
	    $row2 = $query2->row();
	    if( $row2->value == 0 or $row2->value == "" ){
		$data_msg = array(
		    "id" => 12
		);
		$Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	    }
	} else {
	    $data_msg = array(
		"id" => 12
	    );
	    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	}
	if( isset( $_SESSION["isrestrict"] ) ){
	    $data_msg = array(
		"id" => 17
	    );
	    $Msg .= $this->load->view( 'home_msg_view', $data_msg, true );
	}
	$chain_block = "";
	if( $chain_data != 0 ){
	    $hotels = $this->chain_model->get_hotels();
	    // echo "<pre>";
	    // print_r ( $hotels );

	    $data_chain_block = array(
		"hotels" => $hotels
	    );
	    if( isset( $hdata["chain_main_url"] ) ){
		$data_chain_block["chain_main_url"] = $hdata["chain_main_url"];
	    }
	    if( isset( $hdata["chain_local_url"] ) ){
		$data_chain_block["chain_local_url"] = $hdata["chain_local_url"];
	    }
	    $chain_block = $this->load->view( 'header_chain_block_view',
		    $data_chain_block, true );
	}
	$count_group = 0;
	if( isset( $_SESSION['reservations'] ) ){
	    $count_group = count( $_SESSION['reservations'] );
	}

	$data = array(
	    'sync_str'	   => $sync_str,
	    'dc_button'	   => $dc_button,
	    'count_group'	   => $count_group,
	    'chain_block'	   => $chain_block,
	    'dc_errors'	   => $dc_errors,
	    'chain_link'	   => $chain_link,
	    'hotel_id'	   => $hotel_id,
	    'dc_log_rate_days' => $dc_log_rate_days,
	    'dc_log_days'	   => $dc_log_days,
	    'dc_data'	   => $dc_info_array,
	    'dc_status'	   => $dc_status,
	    'dc_button_name'   => $dc_button_name,
	    'button_dc_url'	   => $button_dc_url,
	    'time'		   => $time,
	    'closedate'	   => $date,
	    'msg'		   => $Msg,
	    'mainmenulist'	   => $this->navigation->getrootlist(),
	    'hotel_name'	   => $logo_title,
	    'url'		   => $url,
	    'admin_link'	   => $admin_link,
	    'fullname'	   => $_SESSION['user']['fullname'],
	    'lastname'	   => $_SESSION['user']['lastname'],
	    'user_id'	   => $_SESSION['user']['id'],
	    "search"	   => $search
	);
	//     	echo "<pre>";
	//     	print_r( $_SESSION ['reservations'] );
	//     	die();
	$header = $this->parser->parse( 'templates/header_v2.html', $data, TRUE );
	return $header;
    }

    function GetHeaderChain( $hdata = array() )
    {
	$search = "искать здесь...";
	$search = $this->session->userdata( 'search_main_chain' );
	$chain_block = "";
	$hotels = $this->chain_model->get_hotels();
	// echo "<pre>";
	// print_r ( $hotels );

	$data_chain_block = array(
	    "hotels" => $hotels
	);
	if( isset( $hdata["chain_main_url"] ) ){
	    $data_chain_block["chain_main_url"] = $hdata["chain_main_url"];
	}
	if( isset( $hdata["chain_local_url"] ) ){
	    $data_chain_block["chain_local_url"] = $hdata["chain_local_url"];
	}
	$chain_block = $this->load->view( 'header_chain_block_view',
		$data_chain_block, true );
	$data = array(
	    'chain_block' => $chain_block,
	    'fullname'    => $_SESSION['user']['fullname'],
	    'lastname'    => $_SESSION['user']['lastname'],
	    'user_id'     => $_SESSION['user']['id'],
	    "search"      => $search
	);
	$header = $this->parser->parse( 'templates/header_chain.html', $data,
		TRUE );
	return $header;
    }

    function GetFooterChain()
    {
	$data = array();
	$footer = $this->parser->parse( 'templates/footer_chain.html', $data,
		TRUE );
	return $footer;
    }

    function GetFooter( $version = "" )
    {
	//echo $this->session->userdata ( 'design_version' );
	$loader = $this->config->item( 'preloader' );
	if( $loader == 'true' ){
	    $preload = "<script type='text/javascript'>QueryLoader.init();</script>";
	} else {
	    $preload = "";
	}
	$data = array(
	    "preload" => $preload
	);
	$this->mlanguages->getdictionary( "footer", "", $data );
	$footer = $this->parser->parse( 'templates/footer' . $version . '.html',
		$data, TRUE );
	return $footer;
    }

    function GetFooter_v2()
    {
	$loader = $this->config->item( 'preloader' );
	if( $loader == 'true' ){
	    //$preload = "<script type='text/javascript'>QueryLoader.init();</script>";
	} else {
	    $preload = "";
	}
	$data = array(
	    "preload" => $preload
	);
	$footer = $this->parser->parse( 'templates/footer_v2.html', $data, TRUE );
	return $footer;
    }

    /*
     * function GetCancelForm($post) { $data = array (); $out = "<div id='dialog'>sfasfasf</div>"; return $out; }
     */
    function GetCancelForm( $post )
    {
	// print_r($post);
	$data = array(
	    'id' => $post["reservations"][0]["id"]
	);
	$this->load->library( 'parser' );
	$this->load->view( 'reservationcancel_cancel_view.php', $data );
    }

    function GetPrintForm( $post )
    {
	// print_r($post);
	$data = array(
	    'id' => $post["reservations"][0]["id"]
	);
	$this->load->library( 'parser' );
	$this->load->view( 'fprint_view.php', $data );
    }

    /*
     * function GetPaymentEditForm($post) { //print_r($post); $data = array('id'=> $post["reservations"][0]["id"], "paylist"=>1); $this->load->library('parser'); $this->load->view('payment_paymentEdit_view.php', $data); }
     */
    function GetServiceForm( $post )
    {
	// print_r($post);
	$data = array(
	    'id' => $post["reservations"][0]["id"]
	);
	$this->load->library( 'parser' );
	$this->load->view( 'services_form_view.php', $data );
    }

    function ajax_guest_edit( $post )
    {
	//print_r($post);
	//die();
	if( !isset( $post["reservations"][0]["guest_id"] ) ){
	    $guest_id = 0;
	} else {
	    $guest_id = $post["reservations"][0]["guest_id"];
	}
	$data = array(
	    'reservation_id' => $post["reservations"][0]["id"],
	    'guest_id'	 => $guest_id
	);
	$this->load->library( 'parser' );
	$this->load->view( 'ajax_guest_edit_view.php', $data );
    }

    function Getfastmodal()
    {
	//         echo "<pre>";
	//         print_r($_SESSION["reservations"]);
	//         die();
	$query = $this->db->query( "SELECT * FROM `hotelix_config` WHERE name LIKE 'actual_point_int_date'" );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    // $close_day_status = $row->status;
	    $close = $row->value;
	    $unix_time = $close * 86400;
	    $date = date( "Y-m-d", $unix_time );
	    list ($year_out, $month_out, $day_out) = explode( "-", $date );
	    $date = date( "Y-m-d",
		    mktime( 0, 0, 0, $month_out, $day_out, $year_out ) );
	}

	$query = $this->db->query( "SELECT value FROM hotelix_config WHERE name LIKE 'use_actual_point'" );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $use_actual_point = $row->value;
	}

	if( isset( $_SESSION["reservations"] ) ){
	    $array_keys = array_keys( $_SESSION["reservations"] );
	    foreach( $array_keys as $key ){
		if( ($_SESSION["reservations"][$key]["date"] <= $close) and ($use_actual_point
			== 1) ){
		    $out = "Ошибка! Период закрыт!";
		    return $out;
		}
	    }
	}



	$data = array();
	// $this->load->library ( 'parser' );
	$this->load->view( 'ModalDataCreateFast_view', $data );
	// $this->load->view ( 'reservation_ajax_fastmodal_view', $data);
	// $out = "aaaaa";
	// return $out;
    }

    function Getfastmodal_chain()
    {
	// echo "<pre>";
	// print_r($_SESSION["reservations"]);
	// die();
	$query = $this->db->query( "SELECT * FROM `hotelix_config` WHERE name LIKE 'actual_point_int_date'" );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    // $close_day_status = $row->status;
	    $close = $row->value;
	    $unix_time = $close * 86400;
	    $date = date( "Y-m-d", $unix_time );
	    list ($year_out, $month_out, $day_out) = explode( "-", $date );
	    $date = date( "Y-m-d",
		    mktime( 0, 0, 0, $month_out, $day_out, $year_out ) );
	}

	$query = $this->db->query( "SELECT value FROM hotelix_config WHERE name LIKE 'use_actual_point'" );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $use_actual_point = $row->value;
	}

	if( isset( $_SESSION["reservations"] ) ){
	    $array_keys = array_keys( $_SESSION["reservations"] );
	    foreach( $array_keys as $key ){
		if( ($_SESSION["reservations"][$key]["date"] <= $close) and ($use_actual_point
			== 1) ){
		    $out = "Ошибка! Период закрыт!";
		    return $out;
		}
	    }
	}

	$data = array();
	// $this->load->library ( 'parser' );
	$this->load->view( 'ModalDataCreateFast_chain_view', $data );
	// $this->load->view ( 'reservation_ajax_fastmodal_view', $data);
	// $out = "aaaaa";
	// return $out;
    }

    function SetRooms( $post )
    {
	// print_r($post);
	$id_category = $post["reservations"][0]["id"];
	$rooms = '';
	if( $id_category != "" ){
	    $query = $this->db->query( "SELECT * FROM rooms WHERE category_id = $id_category" );
	} else {
	    $query = $this->db->query( "SELECT * FROM rooms WHERE 1" );
	}
	$rooms .= "<option value=''>Все</option>";
	if( $query->num_rows() > 0 ){
	    foreach( $query->result() as $row ){
		$rooms .= "<option value='$row->id'>$row->name</option>";
	    }
	}
	echo $rooms;
    }

    function GetServiceFormEdit( $post )
    {
	// print_r($post);
	$paylist = "";
	if( isset( $post["reservations"][0]["paylist"] ) ){
	    $paylist = $post["reservations"][0]["paylist"];
	}
	$data = array(
	    'id'	  => $post["reservations"][0]["id"],
	    'paylist' => $paylist
	);
	$this->load->library( 'parser' );
	$this->load->view( 'services_editservice_view.php', $data );
    }

    function GetMainServiceFormEdit( $post )
    {
	$paylist = "";
	if( isset( $post["reservations"][0]["paylist"] ) ){
	    $paylist = $post["reservations"][0]["paylist"];
	}
	$data = array(
	    'id'	  => $post["reservations"][0]["id"],
	    'paylist' => $paylist
	);
	$this->load->library( 'parser' );
	$this->load->view( 'services_editmainservice_view.php', $data );
    }

    function GetRefundFormEdit( $post )
    {
	$paylist = "";
	if( isset( $post["reservations"][0]["paylist"] ) ){
	    $paylist = $post["reservations"][0]["paylist"];
	}
	$data = array(
	    'id'	  => $post["reservations"][0]["id"],
	    'paylist' => $paylist
	);
	$this->load->library( 'parser' );
	$this->load->view( 'reservations_refund_edit_view.php', $data );
    }

    function GetRefundForm( $post )
    {
	// print_r($post);
	$data = array(
	    'id' => $post["reservations"][0]["id"]
	);
	$this->load->library( 'parser' );
	$this->load->view( 'reservations_refund_view.php', $data );
    }

    function GetPaymentForm( $post )
    {
	// print_r($post);
	// die();
	$data = array(
	    'id'	  => $post["reservations"][0]["id"],
	    'balance' => $post["reservations"][0]["balance"]
	);
	$this->load->library( 'parser' );
	$this->load->view( 'payment_view.php', $data );
    }

    function GetClearPaymentForm( $post )
    {
	// print_r($post);
	$data = array(
	    'id' => $post["reservations"][0]["id"]
	);
	$this->load->library( 'parser' );
	$this->load->view( 'payment_clear_view.php', $data );
    }

    function GetInfoForm( $post )
    {
	// print_r($post);
	$data = array(
	    'id' => $post["reservations"][0]["id"]
	);
	$this->load->library( 'parser' );
	$this->load->view( 'info_view.php', $data );
    }

    function GetPaymentFormEdit( $post )
    {
	// print_r($post);
	$paylist = "";
	if( isset( $post["reservations"][0]["paylist"] ) ){
	    $paylist = $post["reservations"][0]["paylist"];
	}
	$data = array(
	    'id'	  => $post["reservations"][0]["id"],
	    'paylist' => $paylist
	);
	$this->load->library( 'parser' );
	$this->load->view( 'payment_paymentEdit_view.php', $data );
    }

    function GetPaymentFormEdit_c2( $post )
    {
	// print_r($post);
	$paylist = "";
	if( isset( $post["reservations"][0]["paylist"] ) ){
	    $paylist = $post["reservations"][0]["paylist"];
	}
	$landing_page = "";
	if( isset( $post["reservations"][0]["landing_page"] ) ){
	    $landing_page = $post["reservations"][0]["landing_page"];
	}
	$data = array(
	    'id'	       => $post["reservations"][0]["id"],
	    'paylist'      => $paylist,
	    'landing_page' => $landing_page,
	);
	$this->load->library( 'parser' );
	$this->load->view( 'payments_c2_paymentEdit_view.php', $data );
    }

    function ajax_search_guests()
    {
	$data = array();
	$this->load->library( 'parser' );
	$this->load->view( 'reservations_ajax_search_view.php', $data );
    }

    function search_guests_html( $post )
    {
	$data = array(
	    'search' => $post["reservations"][0]["search"]
	);
	$this->load->library( 'parser' );
	$this->load->view( 'reservations_search_guests_html_view.php', $data );
    }

    function guests_ajax( $post )
    {
	$data = array(
	    'search' => $post["term"]
	);
	$this->load->library( 'parser' );
	$this->load->view( 'reservations_search_guests_ajax.php', $data );
    }

    function insert_guest( $post )
    {
	//         require_once ('JSON.php');
	//         $json = new Services_JSON();
	$db_name = "";
	$hotel_id = 0;
	if( isset( $post["hotel_id"] ) ){
	    if( $post["hotel_id"] <> 0 ){
		$hotel_id = $post["hotel_id"];
		$sql = "SELECT db_name FROM visitka.config WHERE id = " . $post["hotel_id"];
		$query = $this->db->query( $sql );
		if( $query->num_rows() != 0 ){
		    $row = $query->row();
		    $db_name = "`" . $row->db_name . "`.";
		}
	    }
	}
	$sql = "SELECT * FROM " . $db_name . "guests WHERE id=" . $post["ajax_id"];
	$query = $this->db->query( $sql );
	$row = $query->row();
	$foreign = "";
	if( isset( $row->foreign ) )
	    if( $row->foreign == 1 ){
		$foreign = "checked";
	    }
	$natiomality_mass = array();
	$query2 = $this->db->query( "SELECT * FROM " . $db_name . "language WHERE is_active = 1" );
	foreach( $query2->result() as $row2 ){
	    array_push( $natiomality_mass,
		    array(
		"id"   => $row2->id,
		"name" => $row2->name
	    ) );
	}

	$legalsystem = $this->frontdesk->getlegalsystem();
	$legalsystem_db = $this->frontdesk->getlegalsystem_db( $legalsystem );
	$dict_documenttype_mass = $this->fms_core->get_dict_documenttype( $legalsystem_db );
	$dict_visitpurpose_mass = $this->fms_core->get_dict_visitpurpose( $legalsystem_db );
	$dict_entrygoal_mass = $this->fms_core->get_dict_entrygoal( $legalsystem_db );
	$dict_visamultiplicity_mass = $this->fms_core->get_dict_visamultiplicity( $legalsystem_db );
	$dict_visacategory_mass = $this->fms_core->get_dict_visacategory( $legalsystem_db );
	$visa_types = array();
	$query = $this->db->query( "SELECT * FROM " . $db_name . "visa_types" );
	foreach( $query->result() as $row2 ){
	    array_push( $visa_types,
		    array(
		"id"   => $row2->id,
		"name" => $row2->name
	    ) );
	}

	/* $doc_types = array ();
	  $query = $this->db->query ( "SELECT * FROM doc_types" );
	  foreach ( $query->result () as $row2 ) {
	  array_push ( $doc_types, array (
	  "id" => $row2->id,
	  "name" => $row2->name
	  ) );
	  } */

	$select_nationality = "";
	if( isset( $row->nationality ) )
	    if( $row->nationality == 0 ){
		$select_nationality .= "<option value=''>не определен</option>";
		$temp_keys = array_keys( $natiomality_mass );
		foreach( $temp_keys as $key ){
		    $select_nationality .= "<option value='" . $natiomality_mass[$temp_keys[$key]]["id"] . "'>" . $natiomality_mass[$temp_keys[$key]]["name"] . "</option>";
		}
	    } else {

		$select_nationality .= "<option value='0'>не определен</option>";
		$temp_keys = array_keys( $natiomality_mass );
		foreach( $temp_keys as $key ){
		    if( $natiomality_mass[$temp_keys[$key]]["id"] == $row->nationality ){
			$select_nationality .= "<option selected value='" . $natiomality_mass[$temp_keys[$key]]["id"] . "'>" . $natiomality_mass[$temp_keys[$key]]["name"] . "</option>";
		    } else {
			$select_nationality .= "<option value='" . $natiomality_mass[$temp_keys[$key]]["id"] . "'>" . $natiomality_mass[$temp_keys[$key]]["name"] . "</option>";
		    }
		}
	    }

	$select_doc_type = "";
	if( isset( $row->doc_type ) )
	    if( $row->doc_type == 0 ){
		$select_doc_type .= "<option value=''>---</option>";
		$temp_keys = array_keys( $dict_documenttype_mass );
		foreach( $temp_keys as $key ){
		    $select_doc_type .= "<option value='" . $dict_documenttype_mass[$key]["id"] . "'>" . $dict_documenttype_mass[$key]["name"] . "</option>";
		}
	    } else {
		$select_doc_type .= "<option value='0'>---</option>";
		$temp_keys = array_keys( $dict_documenttype_mass );
		foreach( $temp_keys as $key ){
		    if( $dict_documenttype_mass[$key]["id"] == $row->doc_type ){
			$select_doc_type .= "<option selected value='" . $dict_documenttype_mass[$key]["id"] . "'>" . $dict_documenttype_mass[$key]["name"] . "</option>";
		    } else {
			$select_doc_type .= "<option value='" . $dict_documenttype_mass[$key]["id"] . "'>" . $dict_documenttype_mass[$key]["name"] . "</option>";
		    }
		}
	    }




	// echo $row->firstname;
	if( isset( $row->firstname ) ){
	    $parametres = array(
		"guest_id"	=> $post["ajax_id"],
		"firstname"	=> $row->firstname,
		"lastname"	=> $row->lastname,
		"middlename"	=> $row->middlename,
		"firstname_lat" => $row->firstname_lat,
		"lastname_lat"	=> $row->lastname_lat,
		"dob"		=> $row->dob,
		"passportid"	=> $row->passportid,
		"address"	=> $row->address,
		"citizenship"	=> $row->citizenship,
		"email"		=> $row->email,
		"country"	=> $row->country,
		"state"		=> $row->state,
		"city"		=> $row->city,
		"postcode"	=> $row->postcode,
		"phone"		=> $row->phone,
		"addrbuilding"	=> $row->addrbuilding,
		"addrapt"	=> $row->addrapt,
		"addrhousing"	=> $row->addrhousing,
		"foreign"	=> $foreign,
		"gender"	=> $row->gender,
		"nationality"	=> $select_nationality,
		'doc_precode'	=> $row->doc_precode,
		'doc_date_open' => $row->doc_date_open,
		'doc_date_till' => $row->doc_date_till,
		'pob_state'	=> $row->pob_state,
		'pob_district'	=> $row->pob_district,
		'pob_city'	=> $row->pob_city,
		//'reg_visa_num' => $row->reg_visa_num,
		'select_doc_type'	     => $select_doc_type,
		'reg_visa_date_till'	     => $row->reg_visa_date_till,
		'reg_date_in'		     => $row->reg_date_in,
		'passportissuedby'	     => $row->passportissuedby,
		'dict_officialorgan_fmsCODE' => $row->dict_officialorgan_fmsCODE,
		'pob_registration_date'	     => $row->pob_registration_date,
		"decision_number"	     => $row->decision_number,
		"decision_date"		     => $row->decision_date,
	    );
	    $sql2 = "SELECT * FROM " . $db_name . "reservation_details WHERE guest_id = " . $post ["ajax_id"] . " ORDER BY reservation_id DESC LIMIT 0, 1";
	    $query2 = $this->db->query( $sql2 );
	    if( $query2->num_rows() > 0 ){
		$row2 = $query2->row();
		$select_visitpurpose = "";
		if( $row2->visitpurpose == 0 ){//цель не определена
		    foreach( $dict_visitpurpose_mass as $visitpurpose ){
			$selected = "";
			if( $visitpurpose['id'] == 139353 ){//цель другая по умолчанию
			    $selected = "selected";
			}
			$select_visitpurpose .= "<option $selected value='" . $visitpurpose ["id"] . "'>" . $visitpurpose ["name"] . "</option>";
		    }
		} else {
		    foreach( $dict_visitpurpose_mass as $visitpurpose ){
			$selected = "";
			if( $visitpurpose ["id"] == $row2->visitpurpose ){
			    $selected = "selected";
			}
			$select_visitpurpose .= "<option $selected value='" . $visitpurpose ["id"] . "'>" . $visitpurpose ["name"] . "</option>";
		    }
		}
		$select_goal = "";
		if( $row2->goal_id == 0 ){
		    $select_goal .= "<option value=''>---</option>";
		    $temp_keys = array_keys( $dict_entrygoal_mass );
		    foreach( $temp_keys as $key ){
			$select_goal .= "<option value='" . $dict_entrygoal_mass [$temp_keys [$key]] ["id"] . "'>" . $dict_entrygoal_mass [$temp_keys [$key]] ["name"] . "</option>";
		    }
		} else {
		    $select_goal .= "<option value='0'>---</option>";
		    $temp_keys = array_keys( $dict_entrygoal_mass );
		    foreach( $temp_keys as $key ){
			if( $dict_entrygoal_mass [$temp_keys [$key]] ["id"] == $row2->goal_id ){
			    $select_goal .= "<option selected value='" . $dict_entrygoal_mass [$temp_keys [$key]] ["id"] . "'>" . $dict_entrygoal_mass [$temp_keys [$key]] ["name"] . "</option>";
			} else {
			    $select_goal .= "<option value='" . $dict_entrygoal_mass [$temp_keys [$key]] ["id"] . "'>" . $dict_entrygoal_mass [$temp_keys [$key]] ["name"] . "</option>";
			}
		    }
		}

		$select_dict_visamultiplicity = "";
		$select_dict_visamultiplicity .= "<option value=''>---</option>";
		foreach( $dict_visamultiplicity_mass as $key => $value ){
		    if( $row2->visamultiplicity == $value["id"] ){
			$select_dict_visamultiplicity .= "<option selected value='" . $dict_visamultiplicity_mass [$key] ["id"] . "'>" . $dict_visamultiplicity_mass [$key] ["name"] . "</option>";
		    } else {
			$select_dict_visamultiplicity .= "<option value='" . $dict_visamultiplicity_mass [$key] ["id"] . "'>" . $dict_visamultiplicity_mass [$key] ["name"] . "</option>";
		    }
		}

		$select_reg_visa_type = "";
		$select_reg_visa_type .= "<option value=''>---</option>";
		for( $i = 0; $i < count( $dict_visacategory_mass ); $i++ ){
		    if( $row2->reg_visa_type == $dict_visacategory_mass [$i] ["id"] ){
			$select_reg_visa_type .= "<option selected value='" . $dict_visacategory_mass [$i] ["id"] . "'>" . $dict_visacategory_mass [$i] ["name"] . "</option>";
		    } else {
			$select_reg_visa_type .= "<option value='" . $dict_visacategory_mass [$i] ["id"] . "'>" . $dict_visacategory_mass [$i] ["name"] . "</option>";
		    }
		}
		$parametres ["select_reg_visa_type"] = $select_reg_visa_type;
		$parametres ["migration_card_precode"] = $row2->migration_card_precode;
		$parametres ["reg_visa_precode"] = $row2->reg_visa_precode;
		$parametres ["reg_visa_num"] = $row2->card_number;
		$parametres ["migration_card_num"] = $row2->migration_card_num;
		$parametres ["visamultiplicity"] = $select_dict_visamultiplicity;
		$parametres ["reg_date_out"] = $row2->reg_date_out;
		$parametres ["card_date_of_issue"] = $row2->card_date_of_issue;
		$parametres ["resdoc_identitifier"] = $row2->resdoc_identitifier;
		$parametres ["officialorgan_kpp"] = $row2->officialorgan_kpp;
		$parametres ["select_goal"] = $select_goal;
		$parametres ["select_visitpurpose"] = $select_visitpurpose;
	    } else {
		$select_visitpurpose = "";
		$select_visitpurpose .= "<option value=''>---</option>";
		$temp_keys = array_keys( $dict_visitpurpose_mass );
		foreach( $temp_keys as $key ){
		    $select_visitpurpose .= "<option value='" . $dict_visitpurpose_mass [$temp_keys [$key]] ["id"] . "'>" . $dict_visitpurpose_mass [$temp_keys [$key]] ["name"] . "</option>";
		}

		$select_goal = "";
		$select_goal .= "<option value=''>---</option>";
		$temp_keys = array_keys( $dict_entrygoal_mass );
		foreach( $temp_keys as $key ){
		    $select_goal .= "<option value='" . $dict_entrygoal_mass [$temp_keys [$key]] ["id"] . "'>" . $dict_entrygoal_mass [$temp_keys [$key]] ["name"] . "</option>";
		}

		$select_dict_visamultiplicity = "";
		$select_dict_visamultiplicity .= "<option value=''>---</option>";
		foreach( $dict_visamultiplicity_mass as $key => $value ){
		    $select_dict_visamultiplicity .= "<option value='" . $dict_visamultiplicity_mass [$key] ["id"] . "'>" . $dict_visamultiplicity_mass [$key] ["name"] . "</option>";
		}

		$select_reg_visa_type = "";
		$select_reg_visa_type .= "<option value=''>---</option>";
		for( $i = 0; $i < count( $dict_visacategory_mass ); $i++ ){
		    $select_reg_visa_type .= "<option value='" . $dict_visacategory_mass [$i] ["id"] . "'>" . $dict_visacategory_mass [$i] ["name"] . "</option>";
		}

		$parametres ["select_reg_visa_type"] = $select_reg_visa_type;
		$parametres ["migration_card_precode"] = "";
		$parametres ["reg_visa_precode"] = "";
		$parametres ["migration_card_num"] = "";
		$parametres ["visamultiplicity"] = $select_dict_visamultiplicity;
		$parametres ["reg_date_out"] = "";
		$parametres ["card_date_of_issue"] = "";
		$parametres ["resdoc_identitifier"] = "";
		$parametres ["officialorgan_kpp"] = "";
		$parametres ["select_goal"] = $select_goal;
		$parametres ["select_visitpurpose"] = $select_visitpurpose;
	    }
	    $parametres ["hotel_id"] = $hotel_id;
	} else {
	    $parametres = array();
	}
	$output = json_encode( $parametres );
	return $output;
    }

    function GetForm( $bool, $post )
    {
	$prefix = $this->mlanguages->get_language_prefix();
	$status_table_name = "global_hotelix_languages." . $prefix . "_statusofreservation";
	// echo "2222222222222";
	// exit();
	//         echo "$bool<pre>";
	//         print_r($_POST);
	//         die();
	$hotelid = 0;
	if( isset( $_POST["reservations"][0]["hotelid"] ) ){
	    $hotelid = $_POST["reservations"][0]["hotelid"];
	}
	$chainmode = 0;
	if( isset( $_POST["reservations"][0]["chainmode"] ) ){
	    $chainmode = $_POST["reservations"][0]["chainmode"];
	}
	$chain_return_link = 0;
	if( isset( $_POST["reservations"][0]["chain_return_link"] ) ){
	    $chain_return_link = $_POST["reservations"][0]["chain_return_link"];
	}

	$die_option = 0;
	if( $_POST["reservations"][0]["room"] == - 1 ){
	    if( isset( $_POST["reservations"][0]["category"] ) ){
		$die_option = 1;
		if( isset( $_POST["reservations"][0]["die_option"] ) ){
		    switch( $_POST["reservations"][0]["die_option"] ){
			case 1:
			    $die_option = 1;
			    break;
			case 2:
			    $die_option = 2;
			    break;
		    }
		}
		$datein = $_POST["reservations"][0]["fulldate"];
		//$dateout = $_POST["reservations"][max(array_keys($_POST["reservations"]))]["fulldate"];

		list ($year_out, $month_out, $day_out) = explode( "-",
			$_POST["reservations"][max( array_keys( $_POST["reservations"] ) )]["fulldate"] );
		$dateout = date( "Y-m-d",
			mktime( 0, 0, 0, $month_out, $day_out + 1, $year_out ) );
		$room_id = $this->frontdesk->getfreeroomlist( $datein, $dateout,
			$_POST["reservations"][0]["category"] );
		if( $room_id == 0 ){
		    $bool = 1;
		    $error = 1;
		}
	    } else {
		$room_id = 0;
		$bool = 1;
		$error = 1;
	    }
	} else {


	    $room_id = $_POST["reservations"][0]["room"];
	}
	// echo $room_id;
	// die();
	$query = $this->db->query( "SELECT * FROM `hotelix_config` WHERE name LIKE 'actual_point_int_date'" );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    // $close_day_status = $row->status;
	    $close = $row->value;
	    $unix_time = $close * 86400;
	    $date = date( "Y-m-d", $unix_time );
	    list ($year_out, $month_out, $day_out) = explode( "-", $date );
	    $date = date( "Y-m-d",
		    mktime( 0, 0, 0, $month_out, $day_out, $year_out ) );
	}

	$data = array();
	/*  print_r($_POST);
	  die(); */
	$keys = array_keys( $_POST["reservations"] );
	$error = 0;
	foreach( $keys as $key ){
	    if( !ISSET( $_POST["reservations"][$key]["res_id"] ) || empty( $_POST["reservations"][$key]["res_id"] ) ){
		$error = 1;
	    }
	}
	// echo $error." ".$bool;
	if( $error == 0 ){
	    $res_id = $_POST["reservations"][0]["res_id"];
	    $query = $this->db->query( "SELECT guests.*, " . $status_table_name . ".name as status, deskofreservation.balance,  deskofreservation.marker_id,
                deskofreservation.guest_id, deskofreservation.id_dealer, deskofreservation.id_partner, deskofreservation.id_dealer, deskofreservation.price_type,
                deskofreservation.id_user, deskofreservation.datein, deskofreservation.dateout, deskofreservation.duration, deskofreservation.amount,
                deskofreservation.discount, deskofreservation.id as reservation_id, rooms.name as room_name, categories.shortname as categories_name
                FROM guests
                INNER JOIN deskofreservation ON deskofreservation.guest_id=guests.id
                INNER JOIN rooms ON rooms.id=deskofreservation.room_id INNER JOIN categories ON categories.id=rooms.category_id
                INNER JOIN $status_table_name ON " . $status_table_name . ".id=deskofreservation.status WHERE deskofreservation.id=$res_id" );
	    $query2 = $this->db->query( "SELECT amount FROM payment WHERE reservation_id=$res_id" );
	    $payment = 0;
	    foreach( $query2->result() as $row2 ){
		$payment += $row2->amount;
	    }

	    // var_dump($query_result);
	    $data["res_id"] = $res_id;
	    foreach( $query->result() as $row ){
		// $balance = $this->frontdesk->CalculateBalance ( $res_id );
		$balance = $row->balance;
		$data["hotelid"] = $hotelid;
		$data["chainmode"] = $chainmode;
		$data["chain_return_link"] = $chain_return_link;
		$data["res_id"] = $res_id;
		$data["marker_id"] = $row->marker_id;
		$data["status"] = $row->status;
		$data["id_user"] = $row->id_user;
		$data["id_dealer"] = $row->id_dealer;
		$data["id_partner"] = $row->id_partner;
		$data["guest_id"] = $row->guest_id;
		$data["balance"] = $balance;
		$data["firstname"] = $row->firstname;
		$data["type"] = $row->categories_name;
		$data["lastname"] = $row->lastname;
		$data["phone"] = $row->phone;
		$data["discount"] = $row->discount;
		$data["amount"] = $row->amount;
		$data["datein"] = $row->datein;
		$data["duration"] = $row->duration;
		$data["dateout"] = $row->dateout;
		$data["price_type"] = $row->price_type;
	    }
	}

	$out = '<script>
		////////////////////////
	$(function() {
//		$( "input[metype=datepicker]" ).datepicker( "destroy" );
/*		$( "#dialo3g" ).dialog( "destroy" );
		$( "#dialo3g" ).dialog({resizable:false,dialogClass:"cdialog",
		close: function(){
    			$("#desk .ui-selected").each(function(){
				$(this).removeClass("ui-selected");
			});
		}});
*/
		$( "input[metype=datepicker]" ).datepicker({
			dateFormat:"yy-mm-dd"
		});
            
            
            
            
		$("#dialogSubmit").click(function(){
            
return false;
			var result = $("#select-result").empty();
			var x=$("#dialogForm input").get();
//			var x=$("#frmData input").get();
            
			$.ajax({
//				url: "/reservations/submit",
				url: "/reservations/SubmitSmallForm",
                data: x,
                type:"post",
                success: function(data) {
//				$( "#dialog" ).datepicker( "destroy" );
				result.html(data);
//				$( "#dialog" ).dialog( "close" );
////				$( "#dialog" ).dialog( "destroy" );
//				$("#dialogForm").remove();
//				$("#dialogSubmit").remove();
				$( "#dialog" ).remove();
			  }
			});
		});
	});
	</script>';
	//         echo $bool;
	//         die();
	if( $bool == 1 ){

	    if( $error == 1 ){
		$out .= '<div id="dialog">
			<br>{caption_nofreeroom}<br><br>';
	    } else {
		// var_dump($data);
		$this->GetModalData( $data );
	    }
	} else {

	    $query = $this->db->query( "SELECT category_id FROM rooms WHERE id=" . $room_id );
	    $row = $query->row();
	    $type_id = $row->category_id;
	    $datein = $_POST["reservations"][0]["fulldate"];
	    $dateout = $_POST["reservations"][max( array_keys( $_POST["reservations"] ) )]["fulldate"];
	    list ($year_in, $month_in, $day_in) = explode( "-",
		    $_POST["reservations"][0]["fulldate"] );
	    $date_in_unix = round( date( "U",
			    mktime( 0, 0, 0, $month_in, $day_in, $year_in ) ) / (3600
		    * 24) );
	    list ($year_out, $month_out, $day_out) = explode( "-",
		    $_POST["reservations"][max( array_keys( $_POST["reservations"] ) )]["fulldate"] );
	    $date_out_unix = round( date( "U",
			    mktime( 0, 0, 0, $month_out, $day_out, $year_out ) )
		    / (3600 * 24) );
	    // if ($date_in_unix == $date_out_unix){

	    list ($year_out, $month_out, $day_out) = explode( "-",
		    $_POST["reservations"][max( array_keys( $_POST["reservations"] ) )]["fulldate"] );
	    $dateout = date( "Y-m-d",
		    mktime( 0, 0, 0, $month_out, $day_out + 1, $year_out ) );
	    // }
	    /*
	     * $room_id = $_POST["reservations"][0]["room"]; $result = $this->frontdesk->ReservationForDate($datein, $dateout, $room_id); echo "<pre>"; //print_r($result); list ( $year, $month, $day ) = explode ( "-", $datein ); $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 ); list ( $year, $month, $day ) = explode ( "-", $dateout ); $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 ); $result2 = $this->frontdesk->f($result, $intdatein, $intdateout-1); print_r($result2); $this->frontdesk->MultyCutQuota($result2);
	     */
	    if( $bool == 2 ){
		if( $error == 0 ){
		    $share_bool = "";
		    $share_caption = "";
		    if( $this->session->userdata( 'quota' ) != 1 ){
			if( $this->session->userdata( 'share_quota' ) != "" ){
			    $temp = explode( ",",
				    $this->session->userdata( 'share_quota' ) );
			    $share_caption = "{caption_mqd_divide}";
			    for( $i = 0; $i < count( $temp ); $i++ ){
				if( $temp[$i] == $data["res_id"] ){
				    $share_bool = "Un";
				    $share_caption = "{caption_mqd_undivide}";
				}
			    }
			} else {
			    $share_caption = "{caption_mqd_divide}";
			}
		    }
		    $data["type_id"] = $type_id;
		    $data["room"] = $room_id;
		    $data["datein"] = $datein;
		    $data["dateout"] = $dateout;
		    $data["share_caption"] = $share_caption;
		    $data["share_bool"] = $share_bool;
		    $rooms = array();
		    $query = $this->db->query( "SELECT rooms.name as room_name, deskofreservation.room_id, rooms.category_id as type_id, categories.shortname FROM deskofreservation INNER JOIN rooms ON rooms.id=deskofreservation.room_id INNER JOIN categories ON categories.id=rooms.category_id LEFT JOIN $status_table_name ON " . $status_table_name . ".id =deskofreservation.status  WHERE deskofreservation.id=" . $data["res_id"] );
		    foreach( $query->result() as $row2 ){
			$selected = '<option selected value="' . $row2->room_id . '">' . $row2->room_name . ', [' . $row2->shortname . ']</option>';
			$sql = "SELECT rooms.name, rooms.id, categories.shortname FROM rooms
	INNER JOIN categories ON categories.id = rooms.category_id
	WHERE  categories.is_active = 1 AND 1=1 GROUP BY rooms.id ORDER BY categories.name, rooms.name ASC";
			// echo $sql;
			$query = $this->db->query( $sql );
			foreach( $query->result() as $row ){

			    if( $row2->room_id != $row->id ){
				array_push( $rooms,
					array(
				    'id'	   => $row->id,
				    'name'	   => $row->name,
				    'category' => $row->shortname
				) );
			    }
			}
		    }
		    $data["selected"] = $selected;
		    $data["rooms"] = $rooms;
		    $data["reservation_id"] = $data["res_id"];
		    $this->mlanguages->getdictionary( "modaldataquota", "",
			    $data );
		    $out = $this->parser->parse( 'templates/ModalDataQuota_view.html',
			    $data, true );
		} else {
		    $out .= '<div id="dialog">
			<br>{caption_nofreeroom}<br><br>';
		}
	    } else {
		$query = $this->db->query( "SELECT value FROM hotelix_config WHERE name LIKE 'use_actual_point'" );
		if( $query->num_rows() > 0 ){
		    $row = $query->row();
		    $use_actual_point = $row->value;
		}
		if( ($_POST["reservations"][0]["date"] <= $close) and ($use_actual_point
			== 1) ){
		    $out = "{mlw_period_close}";
		    return $out;
		}

		$datein = $_POST["reservations"][0]["fulldate"];
		//$dateout = $_POST["reservations"][max(array_keys($_POST["reservations"]))]["fulldate"];

		list ($year_out, $month_out, $day_out) = explode( "-",
			$_POST["reservations"][max( array_keys( $_POST["reservations"] ) )]["fulldate"] );
		$dateout = date( "Y-m-d",
			mktime( 0, 0, 0, $month_out, $day_out + 1, $year_out ) );
		$query = $this->db->query( "SELECT category_id FROM rooms WHERE id=" . $room_id );
		$row = $query->row();
		$type_id = $row->category_id;
		$def_bool = $this->frontdesk->getfreeroomlist_overboking( $datein,
			$dateout, $type_id );
		if( $def_bool == 1 ){
		    $overbooking_isset = "!!!";
		} else {
		    $overbooking_isset = "";
		}
		$data_create = array(
		    "overbooking_isset" => $overbooking_isset,
		    "die_option"	    => $die_option,
		    "chainmode"	    => $chainmode,
		    "chain_return_link" => $chain_return_link,
		    "room_id"	    => $room_id,
		    "hotelid"	    => $hotelid,
		    "type_id"	    => $type_id,
		    "datein"	    => $datein,
		    "dateout"	    => $dateout
		);
		$this->GetModalDataCreate( $data_create );
		/*
		 * $out .= ' <script language="JavaScript" type="text/javascript"> function loc(f) { if(f == 1){ document.getElementById("sh").value = 1; document.getElementById("frmData").submit(); } if(f == 2){ document.getElementById("sh").value = 4; document.getElementById("frmData").submit(); } } </script> <div id="dialog"> '."".' <form id="frmData" name="frmData" action="/reservations/SubmitSmallForm" id="dialogForm" method="post"> <input name="room_id" type="hidden" value="' . $_POST["reservations"][0]["room"] . '" > <input name="type_id" type="hidden" value="' . $type_id . '" > <input type="hidden" name="sh" id="sh" value="" /> Имя<br> <input class="forms" name="firstname" id="firstname" type="text" > <br> Фамилия<br> <input class="forms" name="lastname" id="lastname" type="text" > <br> Заезд<br> <input class="forms" name="datein" metype="datepicker" value="' . $datein . '"><br> Выезд<br> <input class="forms" name="dateout" metype="datepicker" value="' . $dateout . '"><br><br> <input type="submit" id="dialogSubmit" onClick="loc(1)" value="Сохранить заказ"> <input type="submit" value="Редактировать заказ" onClick="loc(2)"/> </form> </div> <script> $(function() { $( "#firstname,#lastname" ).autocomplete({ source: function( request, response ) { $.ajax({ url: "/reservations/guests_ajax", dataType: "json", type:"POST", data: { term: request.term }, success: function( data ) { response( $.map( data.list, function( item ) { return { label: item.firstname + " " +item.lastname, data: item.firstname + "|" +item.lastname } })); } }); }, minLength: 2, select: function( event, ui ) { var str = ui.item.data.split("|"); $( "#firstname" ).val(str[0]); $( "#lastname" ).val(str[1]); return false; } }); }); </script>';
		 */
	    }
	}
	$data = array();
	$this->mlanguages->getdictionary( "modaldatacreate", "", $data );
	$out = $this->parser->parse_string( $out, $data, true );
	return $out;
    }

    function GetForm2( $bool, $post )
    {
	$prefix = $this->mlanguages->get_language_prefix();
	$status_table_name = "global_hotelix_languages." . $prefix . "_statusofreservation";
	$data = array();
	// print_r($_POST);
	$keys = array_keys( $_POST["reservations"] );
	$error = 0;
	foreach( $keys as $key ){
	    if( !ISSET( $_POST["reservations"][$key]["res_id"] ) ){
		$error = 1;
	    }
	}
	if( $error == 0 ){
	    $res_id = $_POST["reservations"][0]["res_id"];
	    $query = $this->db->query( "SELECT guests.*, " . $status_table_name . ".name as status, deskofreservation.balance, deskofreservation.guest_id, deskofreservation.id_dealer, deskofreservation.id_partner, deskofreservation.id_dealer, deskofreservation.price_type, deskofreservation.id_user, deskofreservation.datein, deskofreservation.dateout, deskofreservation.duration, deskofreservation.amount, deskofreservation.discount, deskofreservation.id as reservation_id, rooms.name as room_name, categories.shortname as categories_name FROM guests INNER JOIN deskofreservation ON deskofreservation.guest_id=guests.id INNER JOIN rooms ON rooms.id=deskofreservation.room_id INNER JOIN categories ON categories.id=rooms.category_id INNER JOIN $status_table_name ON " . $status_table_name . ".id=deskofreservation.status WHERE deskofreservation.id=$res_id" );
	    $query2 = $this->db->query( "SELECT amount FROM payment WHERE reservation_id=$res_id" );
	    $payment = 0;
	    foreach( $query2->result() as $row2 ){
		$payment += $row2->amount;
	    }

	    foreach( $query->result() as $row ){
		// $balance = $this->frontdesk->CalculateBalance ( $res_id );
		$balance = $row->balance;
		$data["res_id"] = $res_id;
		$data["status"] = $row->status;
		$data["id_user"] = $row->id_user;
		$data["id_dealer"] = $row->id_dealer;
		$data["id_partner"] = $row->id_partner;
		$data["guest_id"] = $row->guest_id;
		$data["balance"] = $balance;
		$data["firstname"] = $row->firstname;
		$data["type"] = $row->categories_name;
		$data["lastname"] = $row->lastname;
		$data["phone"] = $row->phone;
		$data["discount"] = $row->discount;
		$data["amount"] = $row->amount;
		$data["datein"] = $row->datein;
		$data["duration"] = $row->duration;
		$data["dateout"] = $row->dateout;
		$data["price_type"] = $row->price_type;
	    }
	}

	$out = '<script>
	$(function() {
//		$( "input[metype=datepicker]" ).datepicker( "destroy" );
//		$( "#dialog" ).dialog( "destroy" );
		$( "#dialog" ).dialog({resizable:false,dialogClass:"cdialog",
		close: function(){
            
		$("#desk .ui-selected"/*, this*/).each(function(){
				$(this).removeClass("ui-selected");
			});
		}});
            
		$( "input[metype=datepicker]" ).datepicker({
			dateFormat:"yy-mm-dd"
		});
            
            
		$("#dialogSubmit").click(function(){
            
			var result = $("#select-result").empty();
			var x=$("#dialogForm input").get();
            
			$.ajax({
//				url: "/reservations/submit",
				url: "/reservations/SubmitSmallForm",
                data: x,
                type:"post",
                success: function(data) {
//				$( "#dialog" ).datepicker( "destroy" );
				result.html(data);
//				$( "#dialog" ).dialog( "close" );
////				$( "#dialog" ).dialog( "destroy" );
//				$("#dialogForm").remove();
//				$("#dialogSubmit").remove();
				$( "#dialog" ).remove();
			  }
			});
		});
	});
	</script>';
	if( $bool == 1 ){

	    if( $error == 1 ){
		$out .= '<div id="dialog" title="Ошибка">222
			Вы не можете выбрать эту дату так как она зарезервирована!';
	    } else {
		$this->GetModalData( $data );
	    }
	} else {

	    $query = $this->db->query( "SELECT category_id FROM rooms WHERE id=" . $_POST["reservations"][0]["room"] );
	    $row = $query->row();
	    $type_id = $row->category_id;
	    $datein = $_POST["reservations"][0]["fulldate"];
	    $dateout = $_POST["reservations"][max( array_keys( $_POST["reservations"] ) )]["fulldate"];
	    list ($year_in, $month_in, $day_in) = explode( "-",
		    $_POST["reservations"][0]["fulldate"] );
	    $date_in_unix = round( date( "U",
			    mktime( 0, 0, 0, $month_in, $day_in, $year_in ) ) / (3600
		    * 24) );
	    list ($year_out, $month_out, $day_out) = explode( "-",
		    $_POST["reservations"][max( array_keys( $_POST["reservations"] ) )]["fulldate"] );
	    $date_out_unix = round( date( "U",
			    mktime( 0, 0, 0, $month_out, $day_out, $year_out ) )
		    / (3600 * 24) );
	    // if ($date_in_unix == $date_out_unix){

	    list ($year_out, $month_out, $day_out) = explode( "-",
		    $_POST["reservations"][max( array_keys( $_POST["reservations"] ) )]["fulldate"] );
	    $dateout = date( "Y-m-d",
		    mktime( 0, 0, 0, $month_out, $day_out + 1, $year_out ) );
	    // }
	    if( $bool == 2 ){
		$share_bool = "";
		$share_caption = "";
		if( $this->session->userdata( 'quota' ) != 1 ){
		    if( $this->session->userdata( 'share_quota' ) != "" ){
			$temp = explode( ",",
				$this->session->userdata( 'share_quota' ) );
			$share_caption = "Разделить груповую бронь/квоту";
			for( $i = 0; $i < count( $temp ); $i++ ){
			    if( $temp[$i] == $data["res_id"] ){
				$share_bool = "Un";
				$share_caption = "Снять разделение груповой брони/квоты";
			    }
			}
		    } else {
			$share_caption = "Разделить груповую бронь/квоту";
		    }
		}
		$out .= '
	<script language="JavaScript" type="text/javascript">
function loc(f)
{
	if(f == 1){
		document.getElementById("sh").value = 1;
		document.getElementById("frmData").submit();
	}
	if(f == 2){
		document.getElementById("sh").value = 2;
		document.getElementById("frmData").submit();
	}
}
</script>
                    
<div id="dialog" title="' . $_POST["reservations"][0]["room"] . '">
    
	' . "" . '
	<form id="frmData" name="frmData" action="/reservations/CutInsertForm" id="dialogForm" method="post">
	<input name="room_id"  type="hidden" value="' . $_POST["reservations"][0]["room"] . '" >
	<input name="type_id"  type="hidden" value="' . $type_id . '" >
	<input name="res_id"  type="hidden" value="' . $data["res_id"] . '" >
	<input name="id_user"  type="hidden" value="' . $data["id_user"] . '" >
	<input name="dealer"  type="hidden" value="' . $data["id_dealer"] . '" >
	<input name="partner"  type="hidden" value="' . $data["id_partner"] . '" >
	<input name="guest_id"  type="hidden" value="' . $data["guest_id"] . '" >
	<input name="price_type"  type="hidden" value="' . $data["price_type"] . '" >
	<input type="hidden" name="sh" id="sh" value="" />
	Имя<br>
	<input name="firstname"  type="text" >
	<br>
	Фамилия 333<br>
	<input name="lastname"  type="text" >
	<br>
	Заезд<br>
	<input name="datein"  metype="datepicker" value="' . $datein . '"><br>
	    
	Выезд<br>
	    
	<input name="dateout"  metype="datepicker" value="' . $dateout . '"><br>
	    
	<input type="submit" id="dialogSubmit" onClick="loc(1)" value="Создать бронь 2"> <input type="submit" value="Детальное создание 2" onClick="loc(2)"/>
	<br>
	<a href="/reservations/' . $share_bool . 'ShareQuota/' . $data["res_id"] . '">' . $share_caption . '</a>
	<br>
	<br>
	<a href="/reservations/ReservationViewForm/' . $data["res_id"] . '">Редактировать груповую бронь/квоту</a>
	    
	</form>
</div>';
	    } else {

		$out .= '
	<script language="JavaScript" type="text/javascript">
function loc(f)
{
	if(f == 1){
		document.getElementById("sh").value = 1;
		document.getElementById("frmData").submit();
	}
	if(f == 2){
		document.getElementById("sh").value = 2;
		document.getElementById("frmData").submit();
	}
}
</script>
                    
<div id="dialog" title="' . $_POST["reservations"][0]["room"] . '">
    
	' . "" . '
	<form id="frmData" name="frmData" action="/reservations/SubmitSmallForm" id="dialogForm" method="post">
	<input name="room_id"  type="hidden" value="' . $_POST["reservations"][0]["room"] . '" >
	<input name="type_id"  type="hidden" value="' . $type_id . '" >
	<input type="hidden" name="sh" id="sh" value="" />
	Имя<br>
	<input name="firstname"  type="text" >
	<br>
	Фамилия<br>
	<input name="lastname"  type="text" >
	<br>
	Заездrrr<br>
	<input name="datein"  metype="datepicker" value="' . $datein . '"><br>
	    
	Выезд<br>
	    
	<input name="dateout"  metype="datepicker" value="' . $dateout . '"><br>
	    
	<input type="submit" id="dialogSubmit" onClick="loc(1)" value="Создать бронь"> <input type="submit" value="Детальное создание" onClick="loc(2)"/>
	    
	</form>
</div>';
	    }
	}
	return $out;
    }

    public function NavMenu()
    {
	// $navMenu = '<ul>
	// <li><a href="/reservations/Calendar">Главная</a></li>
	// <li><a href="/reservations/ReservationList">Список брони</a></li>
	// <li><a href="/reservations/create">Новая бронь</a></li>
	// <li><a href="/payments/PaymentList">Список платежей</a></li>
	// <li><a href="/reservationcancel/CancelList">Список отмен
	// брони</a></li>
	// </ul>';
	$navMenu = '<a href="/reservations/Calendar"><img src="/img/home.png" width="16" height="16" alt="На главную" title="На главную" /></a> - <a href="/reservations/Calendar">Главная</a><br />
		<a href="/reservations/ReservationList2"><img src="/img/list.png" alt="Зарезервировано" title="Зарезервировано" width="16" height="16" /></a> - <a href="/reservations/ReservationList">Список брони</a><br />
		<a href="/reservations/create"><img src="/img/plus.png" alt="Новое резервирование" title="Новое резервирование" width="16" height="16" /></a> - <a href="/reservations/create">Новое резервирование</a><br />
		<a href="/payments/PaymentList"><img src="/img/payment.png" width="16" height="16" alt="Оплаты" title="Оплаты" /></a> - <a href="/payments/PaymentList">Оплаты</a><br />
		<a href="/reservationcancel/CancelList"><img src="/img/home.png" width="16" height="16" alt="Список отмен брони" title="Список отмен брони" /></a> - <a href="/reservationcancel/CancelList">Список отмен брони</a><br />';
	return $navMenu;
    }

    function MainCalendar()
    {
	list ($year, $month, $day) = explode( "-", gmdate( "Y-m-d" ) );
	if( $this->session->userdata( 'year' ) == "" ){
	    $now_date = date( "Y-m-d",
		    mktime( 0, 0, 0, date( "m" ), - 7, date( "Y" ) ) );
	    list ($year, $month, $day) = explode( "-", $now_date );
	    $newdata = array(
		'year'	=> $year,
		'month' => $month,
		'day'	=> $day
	    );
	    $this->session->set_userdata( $newdata );
	    $year = $this->session->userdata( 'year' );
	    $month = $this->session->userdata( 'month' );
	    $day = $this->session->userdata( 'day' );
	} else {

	    $year = $this->session->userdata( 'year' );
	    $month = $this->session->userdata( 'month' );
	    $day = $this->session->userdata( 'day' );
	}
	$menu = $this->NavMenu();
	$date = array(
	    'year'	=> $year,
	    'month' => $month,
	    'day'	=> $day
	);
	$today_year = date( "Y" );
	$today_mounth = date( "m" );
	$today_day = date( "d" );
	$prefs = array(
	    'show_next_prev' => TRUE,
	    'next_prev_url'	 => '/reservations/calendar/',
	    'template'	 => ' {table_open}<table id="caldesk">{/table_open}
            
   {heading_row_start}<tr>{/heading_row_start}
            
   {heading_previous_cell}<th><a href="{previous_url}"><img src="/img/calarl.png" alt="Предыдущий месяц" title="Предыдущий месяц" width="12" height="11" /></a></th>{/heading_previous_cell}
   {heading_title_cell}<th colspan="{colspan}" class="mnth">{heading}</th>{/heading_title_cell}
   {heading_next_cell}<th><a href="{next_url}"><img src="/img/calarr.png" alt="Следующий месяц" title="Следующий месяц" width="12" height="11" /></a></th>{/heading_next_cell}
            
   {heading_row_end}</tr>{/heading_row_end}
            
   {week_row_start}<tr  class="dayline">{/week_row_start}
   {week_day_cell}<td>{week_day}</td>{/week_day_cell}
   {week_row_end}</tr>{/week_row_end}
            
   {cal_row_start}<tr class="daynums">{/cal_row_start}
   {cal_cell_start}<td>{/cal_cell_start}
            
   {cal_cell_content}<a href="{content}">{day}</a>{/cal_cell_content}
   {cal_cell_content_today}<div class="highlight"><a href="{content}">{day}</a></div>{/cal_cell_content_today}
            
   {cal_cell_no_content}{day}{/cal_cell_no_content}
   {cal_cell_no_content_today}<div class="highlight">{day}</div>{/cal_cell_no_content_today}
            
   {cal_cell_blank}&nbsp;{/cal_cell_blank}
            
   {cal_cell_end}</td>{/cal_cell_end}
   {cal_row_end}</tr>{/cal_row_end}
	<tr><td class="spacer2" colspan="7"></td></tr>
	<tr><td colspan="7" class="deskicons"></td></tr>
   {table_close}
   <tr class="daynums"><td class="spacer2" colspan="7" class="highlight"><a href="/reservations/Calendar/' . $today_year . '/' . $today_mounth . '/' . $today_day . '">сегодня</a></td></tr>
   <tr><td class="spacer2" colspan="7"></td></tr>
	<tr><td colspan="7" class="deskicons"><a href="/reservations/Calendar"><img src="/img/home.png" width="16" height="16" alt="На главную" title="На главную" /></a> - <a href="/reservations/Calendar">Главная</a><br />
		<a href="/reservations/ReservationList2"><img src="/img/list.png" alt="Зарезервировано" title="Зарезервировано" width="16" height="16" /></a> - <a href="/reservations/ReservationList2/1/1">Список брони</a><br />
		<a href="/reservations/create"><img src="/img/plus.png" alt="Новое резервирование" title="Новое резервирование" width="16" height="16" /></a> - <a href="/reservations/create">Новая бронь</a><br />
            
		<a href="/reservations/PriceList"><img src="/img/payment.png" width="16" height="16" alt="Список цен" title="Список цен" /></a> - <a href="/reservations/PriceList">Список цен</a><br />
            
	  	</table>{/table_close}'
	);
	$this->load->library( 'calendar', $prefs );
	$monthData = array();
	$daysCount = $this->getDayCount( $date );
	for( $i = 1; $i <= $daysCount; $i++ ){
	    $monthData[$i] = '/reservations/calendar/' . $year . '/' . $month . '/' . $i;
	}
	$dayPointStr = $year . "-" . $month . "-" . $day;
	$calendar = $this->calendar->generate( $year, $month, $monthData );
	return $calendar;
    }

    function getDayCount( $date )
    {
	return date( "t", mktime( 0, 0, 0, $date['month'], 1, $date['year'] ) );
    }

    function TopCalendar()
    {
	list ($year, $month, $day) = explode( "-", gmdate( "Y-m-d" ) );
	if( $this->session->userdata( 'year' ) == "" ){
	    $now_date = date( "Y-m-d",
		    mktime( 0, 0, 0, date( "m" ), date( "d" ) - 3, date( "Y" ) ) );
	    list ($year, $month, $day) = explode( "-", $now_date );
	    $newdata = array(
		'year'	=> $year,
		'month' => $month,
		'day'	=> $day
	    );
	    $this->session->set_userdata( $newdata );
	    $year = $this->session->userdata( 'year' );
	    $month = $this->session->userdata( 'month' );
	    $day = $this->session->userdata( 'day' );
	} else {

	    $year = $this->session->userdata( 'year' );
	    $month = $this->session->userdata( 'month' );
	    $day = $this->session->userdata( 'day' );
	}
	$calendar_month = $this->config->item( 'calendar_month' );
	for( $i = 1; $i <= floor( $calendar_month / 2 ); $i++ ){
	    $prev_date[$i] = date( "Y-m", mktime( 0, 0, 0, $month - $i, 1, $year ) );
	    $days_prev[$i] = date( "t", mktime( 0, 0, 0, $month - $i, 1, $year ) );
	}
	for( $i = 1; $i <= floor( $calendar_month / 2 ); $i++ ){
	    $next_date[$i] = date( "Y-m", mktime( 0, 0, 0, $month + $i, 1, $year ) );
	    $days_next[$i] = date( "t", mktime( 0, 0, 0, $month + $i, 1, $year ) );
	}

	$now_date = date( "Y-m", mktime( 0, 0, 0, $month, 1, $year ) );
	$days_now = date( "t", mktime( 0, 0, 0, $month, 1, $year ) );
	$colspan = floor( 100 / $calendar_month );
	$to_day = date( "d" );
	$to_month = date( "m" );
	$to_year = date( "Y" );
	$calendar = "";
	$calendar .= '<div class="settings_calendar">
            
            
<table class="margin0auto">
<tbody>
<tr>
<td rowspan="2" class="settings_calendar333" >
            
<table>
<tbody>
<tr>
<td>';
	$calendar .= '<a href="/reservations/calendar/' . $to_year . '/' . $to_month . '/' . $to_day . '"><div class="width80">Сегодня</div></a>';
	$calendar .= '</td>
</tr>
</tbody>
</table>
            
</td>
<td class="settings_calendar222">
            
<table>
<tbody>
<tr>';
	for( $i = 1; $i <= $days_now; $i++ ){
	    if( $day == $i ){
		if( $i < 10 ){
		    $calendar .= "<td style='text-align:center; font-size: 9pt !important;'><a href='/reservations/calendar/$year/$month/$i'><div class='d444'>0$i</div></a></td>";
		} else {
		    $calendar .= "<td style='text-align:center; font-size: 9pt !important;'><a href='/reservations/calendar/$year/$month/$i'><div class='d444'>$i</div></a></td>";
		}
	    } else {
		if( $i < 10 ){
		    $calendar .= "<td style='text-align:center; font-size: 9pt !important;'><a href='/reservations/calendar/$year/$month/$i'><div>0$i</div></a></td>";
		} else {
		    $calendar .= "<td style='text-align:center; font-size: 9pt !important;'><a href='/reservations/calendar/$year/$month/$i'><div>$i</div></a></td>";
		}
	    }
	}
	$calendar .= '</tr>
</tbody>
</table>
            
</td>
</tr>
<tr>
<td class="settings_calendar222">
            
<table>
<tbody>
<tr>';
	for( $i = count( $days_prev ); $i >= 1; $i-- ){
	    $temp = explode( "-", $prev_date[$i] );
	    $year = $temp[0];
	    $month = $temp[1];
	    $calendar .= '<td style="text-align:center; font-size: 9pt !important;" width="' . $colspan . '%" ><a href="/reservations/calendar/' . $year . '/' . $month . '/1"><div  class="d222">' . $prev_date[$i] . '</div></a></td>';
	}
	$temp = explode( "-", $now_date );
	$year = $temp[0];
	$month = $temp[1];
	$calendar .= '<td style="text-align:center;" width="' . $colspan . '%" ><a href="/reservations/calendar/' . $year . '/' . $month . '/1"><div  class="d333">' . $now_date . '</div></a></td>';
	for( $i = 1; $i <= count( $days_next ); $i++ ){
	    $temp = explode( "-", $next_date[$i] );
	    $year = $temp[0];
	    $month = $temp[1];
	    $calendar .= '<td style="text-align:center; font-size: 9pt !important;" width="' . $colspan . '%" ><a href="/reservations/calendar/' . $year . '/' . $month . '/1"><div  class="d222">' . $next_date[$i] . '</div></a></td>';
	}
	$calendar .= '</tr>
</tbody>
</table>
            
</td>
</tr>
</tbody>
</table>
            
</div>';
	// echo $calendar;
	return $calendar;
    }

    function QuarterCalendar( $url )
    {
	// echo $url;
	// die();
	list ($year, $month, $day) = explode( "-", gmdate( "Y-m-d" ) );
	if( $this->session->userdata( 'year' ) == "" ){
	    $now_date = date( "Y-m-d",
		    mktime( 0, 0, 0, date( "m" ), - 7, date( "Y" ) ) );
	    list ($year, $month, $day) = explode( "-", $now_date );
	    $newdata = array(
		'quarter_year'	=> $year,
		'quarter_month' => $month,
		'quarter'	=> $quarter
	    );
	    $this->session->set_userdata( $newdata );
	    $quarter_year = $this->session->userdata( 'quarter_year' );
	    $quarter_month = $this->session->userdata( 'quarter_month' );
	    $quarter = $this->session->userdata( 'quarter' );
	} else {

	    $quarter_year = $this->session->userdata( 'quarter_year' );
	    $quarter_month = $this->session->userdata( 'quarter_month' );
	    $quarter = $this->session->userdata( 'quarter' );
	}
	if( $quarter_month == 0 and $quarter == 0 ){
	    $select_only_year = "class='corent1'";
	} else {
	    $select_only_year = "";
	}
	// echo $quarter_year." ".$quarter_month." ".$quarter;
	$year_1 = date( "Y", mktime( 0, 0, 0, date( "m" ), 1, $quarter_year - 1 ) );
	$year_2 = date( "Y", mktime( 0, 0, 0, date( "m" ), 1, $quarter_year + 1 ) );
	$quarter_mass[1] = array(
	    "01",
	    "02",
	    "03"
	);
	$quarter_mass[2] = array(
	    "04",
	    "05",
	    "06"
	);
	$quarter_mass[3] = array(
	    "07",
	    "08",
	    "09"
	);
	$quarter_mass[4] = array(
	    "10",
	    "11",
	    "12"
	);
	// print_r($quarter_mass);
	$str_month = "";
	$str_quarter = "";
	if( $this->session->userdata( 'datein_payments' ) != "" ){
	    $temp = "style='text-align:center;'";
	} else {
	    $temp = "class='corent1'";
	}
	for( $i = 1; $i <= 12; $i++ ){
	    if( $i < 10 ){
		$m = "0" . $i;
	    } else {
		$m = $i;
	    }
	    if( $quarter_month == 0 ){
		$bool = 0;
		if( $quarter != 0 ){
		    for( $j = 0; $j < count( $quarter_mass[$quarter] ); $j++ ){
			if( $quarter_mass[$quarter][$j] == $i ){
			    $bool = 1;
			    break;
			}
		    }
		}
		if( $bool == 1 ){
		    $str_month .= "<td nowrap class='corent1'><a href='$url$quarter_year/" . ceil( $i
				    / 3 ) . "/" . $i . "'><div >$quarter_year-" . $m . "</div></a></td>";
		} else {
		    $str_month .= "<td nowrap style='text-align:center;'><a href='$url$quarter_year/" . ceil( $i
				    / 3 ) . "/" . $i . "'><div>$quarter_year-" . $m . "</div></a></td>";
		}
	    } else {
		if( $quarter_month == $i ){
		    $str_month .= "<td nowrap class='corent1'><a href='$url$quarter_year/" . ceil( $i
				    / 3 ) . "/" . $i . "'><div >$quarter_year-" . $m . "</div></a></td>";
		} else {
		    $str_month .= "<td nowrap style='text-align:center;'><a href='$url$quarter_year/" . ceil( $i
				    / 3 ) . "/" . $i . "'><div>$quarter_year-" . $m . "</div></a></td>";
		}
	    }
	}

	switch( $quarter ){
	    case 1:
		$mas_quarter_1 = 1;
		$mas_quarter_2 = 2;
		$mas_quarter_3 = 3;
		$mas_quarter_4 = 4;
		$str_quarter .= "<td colspan='3' class='corent1'><a href='$url$quarter_year/$mas_quarter_1/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_1 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_2/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_2 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_3/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_3 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_4/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_4 . "</div></a></td>";
		break;
	    case 2:
		$mas_quarter_1 = 1;
		$mas_quarter_2 = 2;
		$mas_quarter_3 = 3;
		$mas_quarter_4 = 4;
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_1/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_1 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' class='corent1'><a href='$url$quarter_year/$mas_quarter_2/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_2 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_3/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_3 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_4/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_4 . "</div></a></td>";
		break;
	    case 3:
		$mas_quarter_1 = 1;
		$mas_quarter_2 = 2;
		$mas_quarter_3 = 3;
		$mas_quarter_4 = 4;
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_1/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_1 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_2/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_2 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' class='corent1'><a href='$url$quarter_year/$mas_quarter_3/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_3 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_4/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_4 . "</div></a></td>";
		break;
	    case 4:
		$mas_quarter_1 = 1;
		$mas_quarter_2 = 2;
		$mas_quarter_3 = 3;
		$mas_quarter_4 = 4;
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_1/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_1 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_2/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_2 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_3/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_3 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' class='corent1'><a href='$url$quarter_year/$mas_quarter_4/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_4 . "</div></a></td>";
		break;
	    default:
		$mas_quarter_1 = 1;
		$mas_quarter_2 = 2;
		$mas_quarter_3 = 3;
		$mas_quarter_4 = 4;
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_1/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_1 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_2/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_2 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_3/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_3 . "</div></a></td>";
		$str_quarter .= "<td colspan='3' style='text-align:center;'><a href='$url$quarter_year/$mas_quarter_4/0'><div  class='d222'>$quarter_year-K" . $mas_quarter_4 . "</div></a></td>";
		break;
	}
	$prev_quarter_year = date( "Y", mktime( 0, 0, 0, 1, 1, $quarter_year - 1 ) );
	$next_quarter_year = date( "Y", mktime( 0, 0, 0, 1, 1, $quarter_year + 1 ) );
	$calendar = "";
	$calendar .= '<div class="settings_calendar">
            
            
<table class="kalendar_3">
<tbody>
<tr>
<td rowspan="3" >
            
<table class="left_years_td">
<tbody>
<tr>
<td>';
	$calendar .= '<a href="' . $url . $prev_quarter_year . '/0/1"><div class="width80">' . $prev_quarter_year . '</div></a>';
	$calendar .= '</td>
</tr>
</tbody>
</table>
            
</td>
<td >
            
<table class="center_td1">
<tbody>';
	$calendar .= "<tr>";
	$calendar .= $str_month;
	$calendar .= "</tr>";
	$calendar .= '</tbody>
</table>
            
</td>
<td rowspan="3" >
            
<table class="right_years_td">
<tbody>
<tr>
<td>';
	$calendar .= '<a href="' . $url . $next_quarter_year . '/0/1"><div class="width80">' . $next_quarter_year . '</div></a>';
	$calendar .= '</td>
            
</tr>
            
</tbody>
</table>
            
</td>
<tr>
<td >
            
<table class="center_td2">
<tbody>';
	$calendar .= "<tr>";
	$calendar .= $str_quarter;
	$calendar .= "</tr>";
	$calendar .= '</tbody>
</table>
            
</td>
</tr>
<tr>
<td >
<table class="center_td3">
<tbody>
<tr>
<td colspan="12" ' . $select_only_year . '>
<a href="' . $url . $quarter_year . '/0/0"><div  >' . $quarter_year . '</div></a>
</td>
</tr>
</tbody>
</table>
</tr>
</td>
</tr>
</tbody>
</table>
    
</div>';
	return $calendar;
    }

    function QuarterCalendarj( $url )
    {
	// echo $url;
	// die();
	list ($year, $month, $day) = explode( "-", gmdate( "Y-m-d" ) );
	if( $this->session->userdata( 'year' ) == "" ){
	    $now_date = date( "Y-m-d",
		    mktime( 0, 0, 0, date( "m" ), - 7, date( "Y" ) ) );
	    list ($year, $month, $day) = explode( "-", $now_date );
	    $newdata = array(
		'quarter_year'	=> $year,
		'quarter_month' => $month,
		'quarter'	=> $quarter
	    );
	    $this->session->set_userdata( $newdata );
	    $quarter_year = $this->session->userdata( 'quarter_year' );
	    $quarter_month = $this->session->userdata( 'quarter_month' );
	    $quarter = $this->session->userdata( 'quarter' );
	} else {

	    $quarter_year = $this->session->userdata( 'quarter_year' );
	    $quarter_month = $this->session->userdata( 'quarter_month' );
	    $quarter = $this->session->userdata( 'quarter' );
	}
	// echo $quarter_year." ".$quarter_month." ".$quarter;
	$year_1 = date( "Y", mktime( 0, 0, 0, date( "m" ), 1, $quarter_year - 1 ) );
	$year_2 = date( "Y", mktime( 0, 0, 0, date( "m" ), 1, $quarter_year + 1 ) );
	$quarter_mass[1] = array(
	    "01",
	    "02",
	    "03"
	);
	$quarter_mass[2] = array(
	    "04",
	    "05",
	    "06"
	);
	$quarter_mass[3] = array(
	    "07",
	    "08",
	    "09"
	);
	$quarter_mass[4] = array(
	    "10",
	    "11",
	    "12"
	);
	// print_r($quarter_mass);
	$str_month = "";
	$str_quarter = "";
	for( $i = 1; $i <= 12; $i++ ){
	    if( $i < 10 ){
		$m = "0" . $i;
	    } else {
		$m = $i;
	    }
	    if( $quarter_month == 0 ){
		$bool = 0;
		for( $j = 0; $j < count( $quarter_mass[$quarter] ); $j++ ){
		    if( $quarter_mass[$quarter][$j] == $i ){
			$bool = 1;
			break;
		    }
		}
		if( $bool == 1 ){
		    $str_month .= "<td nowrap style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='#' onClick='submitform($quarter_year," . ceil( $i
				    / 3 ) . ",$i)'>$quarter_year-" . $m . "</a></td>";
		} else {
		    $str_month .= "<td nowrap style='text-align:center; font-size: 9pt !important;'><a href='#' onClick='submitform($quarter_year," . ceil( $i
				    / 3 ) . ",$i)'>$quarter_year-" . $m . "</a></td>";
		}
	    } else {
		if( $quarter_month == $i ){
		    $str_month .= "<td nowrap style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='#' onClick='submitform($quarter_year," . ceil( $i
				    / 3 ) . ",$i)'>$quarter_year-" . $m . "</a></td>";
		} else {
		    $str_month .= "<td nowrap style='text-align:center; font-size: 9pt !important;'><a href='#' onClick='submitform($quarter_year," . ceil( $i
				    / 3 ) . ",$i)'>$quarter_year-" . $m . "</a></td>";
		}
	    }
	}

	switch( $quarter ){
	    case 1:
		$mas_quarter_1 = 4;
		$mas_quarter_2 = $quarter;
		$mas_quarter_3 = 2;
		$mas_quarter_4 = 3;
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_1,0)'>$year_1-K" . $mas_quarter_1 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='#' onClick='submitform($quarter_year,$mas_quarter_2,0)'>$quarter_year-K" . $mas_quarter_2 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_3,0)'>$quarter_year-K" . $mas_quarter_3 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_4,0)'>$quarter_year-K" . $mas_quarter_4 . "</td>";
		break;
	    case 2:
		$mas_quarter_1 = 1;
		$mas_quarter_2 = $quarter;
		$mas_quarter_3 = 3;
		$mas_quarter_4 = 4;
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_1,0)'>$quarter_year-K" . $mas_quarter_1 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important;  background-color:orange;'><a href='#' onClick='submitform($quarter_year,$mas_quarter_2,0)'>$quarter_year-K" . $mas_quarter_2 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_3,0)'>$quarter_year-K" . $mas_quarter_3 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_4,0)'>$quarter_year-K" . $mas_quarter_4 . "</td>";
		break;
	    case 3:
		$mas_quarter_1 = 2;
		$mas_quarter_2 = $quarter;
		$mas_quarter_3 = 4;
		$mas_quarter_4 = 1;
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important;'><a href='#' onClick='submitform($quarter_year,$mas_quarter_1,0)'>$quarter_year-K" . $mas_quarter_1 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important;  background-color:orange;'><a href='#' onClick='submitform($quarter_year,$mas_quarter_2,0)'>$quarter_year-K" . $mas_quarter_2 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_3,0)'>$quarter_year-K" . $mas_quarter_3 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_4,0)'>$year_2-K" . $mas_quarter_4 . "</td>";
		break;
	    case 4:
		$mas_quarter_1 = 3;
		$mas_quarter_2 = $quarter;
		$mas_quarter_3 = 1;
		$mas_quarter_4 = 2;
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_1,0)'>$quarter_year-K" . $mas_quarter_1 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important;  background-color:orange;'><a href='#' onClick='submitform($quarter_year,$mas_quarter_2,0)'>$quarter_year-K" . $mas_quarter_2 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_3,0)'>$year_2-K" . $mas_quarter_3 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_4,0)'>$year_2-K" . $mas_quarter_4 . "</td>";
		break;
	    default:
		$mas_quarter_1 = 1;
		$mas_quarter_2 = 2;
		$mas_quarter_3 = 3;
		$mas_quarter_4 = 4;
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_1,0)'>$quarter_year-K" . $mas_quarter_1 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important;  background-color:orange;'><a href='#' onClick='submitform($quarter_year,$mas_quarter_2,0)'>$quarter_year-K" . $mas_quarter_2 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_3,0)'>$quarter_year-K" . $mas_quarter_3 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; '><a href='#' onClick='submitform($quarter_year,$mas_quarter_4,0)'>$quarter_year-K" . $mas_quarter_4 . "</td>";
		break;
	}

	$calendar = "";
	$calendar .= '<table width="100%" cellspacing="0" cellpadding="3" bordercolor="#999" border="1" align="center" style=" border: solid 1px #999; border-collapse:collapse; border-style:solid; text-align:center">';
	$calendar .= "<tr>";
	$calendar .= $str_month;
	$calendar .= "</tr>";
	$calendar .= "<tr>";
	$calendar .= $str_quarter;
	$calendar .= "</tr>";
	$calendar .= "</table>";
	return $calendar;
    }

    function QuarterCalendar2()
    {
	list ($year, $month, $day) = explode( "-", gmdate( "Y-m-d" ) );
	if( $this->session->userdata( 'year' ) == "" ){
	    $now_date = date( "Y-m-d",
		    mktime( 0, 0, 0, date( "m" ), - 7, date( "Y" ) ) );
	    list ($year, $month, $day) = explode( "-", $now_date );
	    $newdata = array(
		'quarter_year'	=> $year,
		'quarter_month' => $month,
		'quarter'	=> $quarter
	    );
	    $this->session->set_userdata( $newdata );
	    $quarter_year = $this->session->userdata( 'quarter_year' );
	    $quarter_month = $this->session->userdata( 'quarter_month' );
	    $quarter = $this->session->userdata( 'quarter' );
	} else {

	    $quarter_year = $this->session->userdata( 'quarter_year' );
	    $quarter_month = $this->session->userdata( 'quarter_month' );
	    $quarter = $this->session->userdata( 'quarter' );
	}
	// echo $quarter_year." ".$quarter_month." ".$quarter;
	$year_1 = date( "Y", mktime( 0, 0, 0, date( "m" ), 1, $quarter_year - 1 ) );
	$year_2 = date( "Y", mktime( 0, 0, 0, date( "m" ), 1, $quarter_year + 1 ) );
	$quarter_mass[1] = array(
	    "01",
	    "02",
	    "03"
	);
	$quarter_mass[2] = array(
	    "04",
	    "05",
	    "06"
	);
	$quarter_mass[3] = array(
	    "07",
	    "08",
	    "09"
	);
	$quarter_mass[4] = array(
	    "10",
	    "11",
	    "12"
	);
	// print_r($quarter_mass);
	$str_month = "";
	$str_quarter = "";
	switch( $quarter ){
	    case 1:
		$mas_quarter_1 = 4;
		$mas_quarter_2 = $quarter;
		$mas_quarter_3 = 2;
		$mas_quarter_4 = 3;
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$year_1/$mas_quarter_1/" . $quarter_mass[$mas_quarter_1][$i] . "'>$year_1-" . $quarter_mass[$mas_quarter_1][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_2/" . $quarter_mass[$mas_quarter_2][$i] . "'>$quarter_year-" . $quarter_mass[$mas_quarter_2][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_3/" . $quarter_mass[$mas_quarter_3][$i] . "'>$quarter_year-" . $quarter_mass[$mas_quarter_3][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_4/" . $quarter_mass[$mas_quarter_4][$i] . "'>$quarter_year-" . $quarter_mass[$mas_quarter_4][$i] . "</a></td>";
		}
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$year_1/$mas_quarter_1/1'>$year_1-K" . $mas_quarter_1 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_2/4'>$quarter_year-K" . $mas_quarter_2 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_3/7'>$quarter_year-K" . $mas_quarter_3 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_4/10'>$quarter_year-K" . $mas_quarter_4 . "</td>";
		break;
	    case 2:
		$mas_quarter_1 = 1;
		$mas_quarter_2 = $quarter;
		$mas_quarter_3 = 3;
		$mas_quarter_4 = 4;
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_1/" . $quarter_mass[$mas_quarter_1][$i] . "'>$quarter_year-" . $quarter_mass[$mas_quarter_1][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_2/" . $quarter_mass[$mas_quarter_2][$i] . "'>$quarter_year-" . $quarter_mass[$mas_quarter_2][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_3/" . $quarter_mass[$mas_quarter_3][$i] . "'>$quarter_year-" . $quarter_mass[$mas_quarter_3][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_4/" . $quarter_mass[$mas_quarter_4][$i] . "'>$quarter_year-" . $quarter_mass[$mas_quarter_4][$i] . "</a></td>";
		}
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_1/1'>$quarter_year-K" . $mas_quarter_1 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_2/4'>$quarter_year-K" . $mas_quarter_2 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_3/7'>$quarter_year-K" . $mas_quarter_3 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_4/10'>$quarter_year-K" . $mas_quarter_4 . "</td>";
		break;
	    case 3:
		$mas_quarter_1 = 2;
		$mas_quarter_2 = $quarter;
		$mas_quarter_3 = 4;
		$mas_quarter_4 = 1;
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_1/" . $quarter_mass[$mas_quarter_1][$i] . "'>$quarter_year-" . $quarter_mass[$mas_quarter_1][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_2/" . $quarter_mass[$mas_quarter_2][$i] . "'>$quarter_year-" . $quarter_mass[$mas_quarter_2][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_3/" . $quarter_mass[$mas_quarter_3][$i] . "'>$quarter_year-" . $quarter_mass[$mas_quarter_3][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$year_2/$mas_quarter_4/" . $quarter_mass[$mas_quarter_4][$i] . "'>$year_2-" . $quarter_mass[$mas_quarter_4][$i] . "</a></td>";
		}
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_1/1'>$quarter_year-K" . $mas_quarter_1 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_2/4'>$quarter_year-K" . $mas_quarter_2 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_3/7'>$quarter_year-K" . $mas_quarter_3 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$year_2/$mas_quarter_4/10'>$year_2-K" . $mas_quarter_4 . "</td>";
		break;
	    case 4:
		$mas_quarter_1 = 3;
		$mas_quarter_2 = $quarter;
		$mas_quarter_3 = 1;
		$mas_quarter_4 = 2;
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_1/" . $quarter_mass[$mas_quarter_1][$i] . "'>$quarter_year-" . $quarter_mass[$mas_quarter_1][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_2/" . $quarter_mass[$mas_quarter_2][$i] . "'>$quarter_year-" . $quarter_mass[$mas_quarter_2][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$year_2/$mas_quarter_3/" . $quarter_mass[$mas_quarter_3][$i] . "'>$year_2-" . $quarter_mass[$mas_quarter_3][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$year_2/$mas_quarter_4/" . $quarter_mass[$mas_quarter_4][$i] . "'>$year_2-" . $quarter_mass[$mas_quarter_4][$i] . "</a></td>";
		}
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_1/1'>$quarter_year-K" . $mas_quarter_1 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_2/4'>$quarter_year-K" . $mas_quarter_2 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$year_2/$mas_quarter_3/7'>$year_2-K" . $mas_quarter_3 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$year_2/$mas_quarter_4/10'>$year_2-K" . $mas_quarter_4 . "</td>";
		break;
	    default:
		$mas_quarter_1 = 1;
		$mas_quarter_2 = 2;
		$mas_quarter_3 = 3;
		$mas_quarter_4 = 4;
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_1/" . $quarter_mass[$mas_quarter_1][$i] . "'>" . $quarter_mass[$mas_quarter_1][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_2/" . $quarter_mass[$mas_quarter_2][$i] . "'>" . $quarter_mass[$mas_quarter_2][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_3/" . $quarter_mass[$mas_quarter_3][$i] . "'>" . $quarter_mass[$mas_quarter_3][$i] . "</a></td>";
		}
		for( $i = 0; $i <= 2; $i++ ){
		    $str_month .= "<td style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_4/" . $quarter_mass[$mas_quarter_4][$i] . "'>" . $quarter_mass[$mas_quarter_4][$i] . "</a></td>";
		}
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_1/1'>$quarter_year-K" . $mas_quarter_1 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_2/4'>$quarter_year-K" . $mas_quarter_2 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_3/7'>$quarter_year-K" . $mas_quarter_3 . "</td>";
		$str_quarter .= "<td colspan='3' style='text-align:center; font-size: 9pt !important; background-color:orange;'><a href='/reservations/TotalBalance/$quarter_year/$mas_quarter_4/10'>$quarter_year-K" . $mas_quarter_4 . "</td>";
		break;
	}

	$calendar = "";
	$calendar .= "<table class='center' id='desk' border='1' width='800'>";
	$calendar .= "<tr class='topline'>";
	for( $j = 1; $j <= 5; $j++ ){
	    
	}
	$calendar .= "<td>";
	$calendar .= "<table class='center' border='1' width='100%'>";
	$calendar .= "<tr>";
	$calendar .= $str_month;
	$calendar .= "</tr>";
	$calendar .= "<tr>";
	$calendar .= $str_quarter;
	$calendar .= "</tr>";
	$calendar .= "</table>";
	$calendar .= "</td>";
	$calendar .= "</tr>";
	$calendar .= "</table>";
	echo $calendar;
	// return $calendar;
    }

    function GetModalData( $data )
    {
	$this->load->view( 'ModalData_view', $data );
    }

    function GetModalDataCreate( $data )
    {
	$this->load->view( 'ModalDataCreate_view', $data );
    }

    function GetModalDataTransfer( $postdata )
    {
	$reservation_id = $postdata["reservations"][0]["res_id"];
	$data = array(
	    "reservation_id" => $reservation_id
	);
	$this->load->view( 'ModalDataTransfer_view', $data );
    }

    function GetModalDataRoomState( $postdata )
    {
	$room = $postdata["reservations"][0]["room"];
	$data = array(
	    "room" => $room
	);
	$this->load->view( 'ModalDataRoomState_view', $data );
    }

    function Get_dc_setup_menu()
    {
	$dc_only_background_value = $this->dc_model->Get_dc_only_background();
	$data = array("dc_only_background_value" => $dc_only_background_value);
	$html = $this->parser->parse( 'templates/dc_setup_menu.html', $data,
		TRUE );
	return $html;
    }

    function Get_daily_price_calendar( $datein = "", $dateout = "",
	    $price_array = 0 )
    {
	$month_arr = array(
	    "Jan" => "{mlw_month_january_2}",
	    "Feb" => "{mlw_month_february_2}",
	    "Mar" => "{mlw_month_march_2}",
	    "Apr" => "{mlw_month_april_2}",
	    "May" => "{mlw_month_may_2}",
	    "Jun" => "{mlw_month_june_2}",
	    "Jul" => "{mlw_month_july_2}",
	    "Aug" => "{mlw_month_august_2}",
	    "Sep" => "{mlw_month_september_2}",
	    "Oct" => "{mlw_month_october_2}",
	    "Nov" => "{mlw_month_november_2}",
	    "Dec" => "{mlw_month_december_2}"
	);
	$weekdays_arr = array(
	    "Mon" => "{mlw_week_monday}",
	    "Tue" => "{mlw_week_tuesday}",
	    "Wed" => "{mlw_week_wednesday}",
	    "Thu" => "{mlw_week_thursday}",
	    "Fri" => "{mlw_week_friday}",
	    "Sat" => "{mlw_week_saturday}",
	    "Sun" => "{mlw_week_sunay}"
	);
	$td_mass = array();
	$tr_mass = array();
	list ( $year, $month, $day ) = explode( "-", $datein );
	$intdatein = round( mktime( 0, 0, 0, $month, $day, $year ) / 86400 );
	list ( $year, $month, $day ) = explode( "-", $dateout );
	$intdateout = round( mktime( 0, 0, 0, $month, $day, $year ) / 86400 );
	//$intdateout2 = round ( mktime ( 0, 0, 0, $month, $day - 1, $year ) / 86400 );

	$int_today = round( mktime( 0, 0, 0, gmdate( "m" ), gmdate( "d" ),
			gmdate( "Y" ) ) / 86400 );
	$start = strtotime( $datein );
	$end = strtotime( $dateout );
	$current_time = strtotime( $datein );
	//echo $datein." ".$current_time;
	//die();
	$time_start = $current_time - (date( 'N', $current_time ) - 1) * 86400;
	$current_time = strtotime( $dateout );
	$time_end = $current_time + (7 - (date( 'N', $current_time ))) * 86400;
	$day_sec = 24 * 3600;
	$calendar = "";
	$bool = 0;
	for( $i = $time_start; $i <= $time_end; $i += $day_sec ){
	    $td_class = "";
	    $calendar .= "<td>";
	    if( isset( $price_array [round( $i / 86400 )] ) ){
		$day_price = $price_array [round( $i / 86400 )]["amount"];
	    } else {
		$day_price = 0;
	    }
	    if( $i < $start || $i >= $end ){
		$var_differ = $i - $time_start;
		$temp_date = date( 'Y-m-d', $time_start + $var_differ );
		list ( $year, $month, $day ) = explode( "-", $temp_date );
		$month_eng = date( "M", mktime( 0, 0, 0, $month, $day, $year ) );
		$day_eng = date( "j", mktime( 0, 0, 0, $month, $day, $year ) );
		$weekday = $weekdays_arr [date( "D",
				mktime( 0, 0, 0, $month, $day, $year ) )];
		$outdate = $day_eng . " " . $month_arr [$month_eng];
		$td_class = 'class="none-day"';
		$calendar .= $outdate;
		$input_dayprice = "";
	    } else {
		$var_differ = $i - $time_start;
		$temp_date = date( 'Y-m-d', $time_start + $var_differ );
		list ( $year, $month, $day ) = explode( "-", $temp_date );
		$month_eng = date( "M", mktime( 0, 0, 0, $month, $day, $year ) );
		$day_eng = date( "j", mktime( 0, 0, 0, $month, $day, $year ) );
		$weekday = $weekdays_arr [date( "D",
				mktime( 0, 0, 0, $month, $day, $year ) )];
		$outdate = $day_eng . " " . $month_arr [$month_eng];
		list ( $year, $month, $day ) = explode( "-", $temp_date );
		$intdate = round( mktime( 0, 0, 0, $month, $day, $year ) / 86400 );
		if( $intdatein > $intdate and $bool == 0 ){
		    $input_dayprice = "<p class='c-input'><input type='text' size='5' class='day_price' name='day_price[]' value='$day_price'></p>";
		    $bool = 1;
		} else {
		    if( $int_today == $intdate ){
			$td_class = 'class="today-data"';
			$input_dayprice = "<p class='c-input'><input type='text' size='5' class='day_price' name='day_price[$intdate]' value='$day_price'> - ";
		    } else {
			$input_dayprice = "<p class='c-input'><input type='text' size='5' class='day_price' name='day_price[$intdate]' value='$day_price'></p>";
		    }
		}
	    }
	    array_push( $td_mass,
		    array(
		'td_class'	 => $td_class,
		'weekday'	 => $weekday,
		'input_dayprice' => $input_dayprice,
		'outdate'	 => $outdate
	    ) );
	    $xxx = (($i - $time_start) / $day_sec + 1) % 7;
	    if( $xxx == 0 ){
		array_push( $tr_mass,
			array(
		    'td_mass' => $td_mass
		) );
		$td_mass = array();
	    }
	}

	$dc_only_background_value = $this->dc_model->Get_dc_only_background();
	$data = array(
	    "dc_only_background_value" => $dc_only_background_value,
	    "tr_mass"		   => $tr_mass,
	);
	$this->mlanguages->getdictionary( "services_editmainservice", "", $data );
	$html = $this->parser->parse( 'templates/daily_price_calendar.html',
		$data, TRUE );
	return $html;
    }

    function show_daily_price()
    {
	$show_value = false;
	$query = $this->db->query( "SELECT value FROM hotelix_config WHERE name LIKE 'allow_per_day_price_change'" );
	$select_allow_per_day_price_change = '';
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $show_value = $row->value;
	}
	return $show_value;
    }

    function get_fastmodal_group_html( $from, $to, $type_id )
    {

	$checktime_mass = array(
	    "00:00",
	    "00:30",
	    "01:00",
	    "01:30",
	    "02:00",
	    "02:30",
	    "03:00",
	    "03:30",
	    "04:00",
	    "04:30",
	    "05:00",
	    "05:30",
	    "06:00",
	    "06:30",
	    "07:00",
	    "07:30",
	    "08:00",
	    "08:30",
	    "09:00",
	    "09:30",
	    "10:00",
	    "10:30",
	    "11:00",
	    "11:30",
	    "12:00",
	    "12:30",
	    "13:00",
	    "13:30",
	    "14:00",
	    "14:30",
	    "15:00",
	    "15:30",
	    "15:00",
	    "15:30",
	    "16:00",
	    "16:30",
	    "17:00",
	    "17:30",
	    "18:00",
	    "18:30",
	    "19:00",
	    "19:30",
	    "20:00",
	    "20:30",
	    "21:00",
	    "21:30",
	    "22:00",
	    "22:30",
	    "23:00",
	    "23:30"
	);
	$select_marker = '<option selected value="0">---</option>';
	;
	$query = $this->db->query( "SELECT * FROM reservation_markers" );
	foreach( $query->result() as $row2 ){

	    $select_marker .= '<option value="' . $row2->id . '">' . $row2->name . '</option>';
	}
	$dealers = array();
	$price_types = array();
	$query = $this->db->query( "SELECT * FROM dealers WHERE is_active = 1 ORDER BY ordervalue ASC" );
	foreach( $query->result() as $row ){
	    array_push( $dealers,
		    array(
		"id"	    => $row->id,
		"name"	    => $row->name,
		"isdefault" => $row->isdefault
	    ) );
	}
	$query = $this->db->query( "SELECT * FROM rate WHERE isactive = 1" );
	foreach( $query->result() as $row ){
	    array_push( $price_types,
		    array(
		"id"	    => $row->id,
		"name"	    => $row->caption,
		"isdefault" => $row->isdefault
	    ) );
	}

	$default_price_type = 0;
	$query = $this->db->query( "SELECT id FROM rate WHERE isdefault = 1" );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $default_price_type = $row->id;
	}

	$select_dealer = "";
	for( $i = 0; $i < count( $dealers ); $i++ ){
	    if( $dealers [$i] ["isdefault"] == 1 ){
		$select_dealer .= "<option selected value='" . $dealers [$i] ["id"] . "'>" . $dealers [$i] ["name"] . "</option>";
	    } else {
		$select_dealer .= "<option value='" . $dealers [$i] ["id"] . "'>" . $dealers [$i] ["name"] . "</option>";
	    }
	}
	$select_price_types = "";
	for( $i = 0; $i < count( $price_types ); $i++ ){
	    if( $price_types [$i] ["isdefault"] == 1 ){
		$select_price_types .= "<option selected value='" . $price_types [$i] ["id"] . "'>" . $price_types [$i] ["name"] . "</option>";
	    } else {
		$select_price_types .= "<option value='" . $price_types [$i] ["id"] . "'>" . $price_types [$i] ["name"] . "</option>";
	    }
	}
	$checkintime_default = "";
	$query = $this->db->query( "SELECT str_value FROM hotelix_config WHERE name LIKE 'checkintime'" );
	$select_colorofdesk = '';
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $checkintime_default = trim( $row->str_value );
	    $checkintime_default = substr( $checkintime_default, 0, 5 );
	}
	$checkouttime_default = "";
	$query = $this->db->query( "SELECT str_value FROM hotelix_config WHERE name LIKE 'checkouttime'" );
	$select_colorofdesk = '';
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $checkouttime_default = trim( $row->str_value );
	    $checkouttime_default = substr( $checkouttime_default, 0, 5 );
	}

	$select_checkouttime = "";
	for( $i = 0; $i < count( $checktime_mass ); $i++ ){
	    if( $checktime_mass [$i] == $checkouttime_default ){
		$select_checkouttime .= "<option selected value='" . $checktime_mass [$i] . "'>" . $checktime_mass [$i] . "</option>";
	    } else {
		$select_checkouttime .= "<option value='" . $checktime_mass [$i] . "'>" . $checktime_mass [$i] . "</option>";
	    }
	}

	$select_checkintime = "";
	for( $i = 0; $i < count( $checktime_mass ); $i++ ){
	    if( $checktime_mass [$i] == $checkintime_default ){
		$select_checkintime .= "<option selected value='" . $checktime_mass [$i] . "'>" . $checktime_mass [$i] . "</option>";
	    } else {
		$select_checkintime .= "<option value='" . $checktime_mass [$i] . "'>" . $checktime_mass [$i] . "</option>";
	    }
	}

	$datein = gmdate( "Y-m-d", $from * 86400 );
	$dateout = gmdate( "Y-m-d", $to * 86400 );
	//list ( $year, $month, $day ) = explode ( "-", $datein );
	//$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	$intdate = $from;
	//list ( $year, $month, $day ) = explode ( "-", $dateout );
	//$outdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	$outdate = $to;
	$duration = $outdate - $intdate;
	$categories = array();
	$sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places, categories.settlementtype FROM rooms
		INNER JOIN categories ON categories.id = rooms.category_id
		WHERE categories.is_active = 1
		GROUP by rooms.category_id";
	// echo "<pre>" . $sql . "\n";
	$query = $this->db->query( $sql );
	if( $query->num_rows() > 0 ){
	    foreach( $query->result_array() as $row ){
		$categories [$row ["category_id"]] ["count"] = $row ["count"];
		$categories [$row ["category_id"]] ["base_price"] = $row ["base_price"];
		$categories [$row ["category_id"]] ["name"] = $row ["c_name"];
		$categories [$row ["category_id"]] ["shortname"] = $row ["shortname"];
		$categories [$row ["category_id"]] ["category_id"] = $row ["category_id"];
	    }
	}
	//$freerooms = $this->frontdesk->getfreeroomsarraygroup ( $datein, $dateout );
	//$categories = $freerooms ['categories'];
	foreach( $categories as $key => $cell ){
	    $categories [$key] ['options'] = array();
	    for( $i = 0; $i <= $cell ['count']; $i++ ){
		$categories [$key] ['options'] [$i] ['value'] = $i;
		$categories [$key] ['options'] [$i] ['text'] = $i;
		if( $i == 1 && $key == $type_id ){
		    $categories [$key] ['options'] [$i] ['selected'] = "selected";
		} else {
		    $categories [$key] ['options'] [$i] ['selected'] = "";
		}
	    }
	}

	$price_calculation_data = array();
	$price_calculation_data ["datein"] = $datein;
	//if($from == $to){
	//	$price_calculation_data ["dateout"] = gmdate ( "Y-m-d", ($to + 1) * 86400 );
	//}else{
	$price_calculation_data ["dateout"] = $dateout;
	//}
	$price_calculation_data ["price_type"] = $default_price_type;
	$price_calculation_data ["type_id"] = $type_id;
	$price_calculation_data ["add_places"] = 0;
	$price_calculation_data ["addbedplace"] = 0;
	$price_calculation_data ["baby_places"] = 0;
	$price_calculation_data ["babyplace2"] = 0;
	$price_array = $this->frontdesk->getpricecalculation( $price_calculation_data,
		0, 0, 1 );
	// echo "<pre>";
	// print_r($price_array);
	// die();
	$service_main_amount = 0;
	foreach( $price_array as $intdate => $cell ){
	    $service_main_amount += $price_array [$intdate] ["amount"];
	}

	$select_discount = "";
	$select_discount .= "<option selected value='" . 0 . "'>---</option>";
	for( $i = 1; $i <= 100; $i++ ){

	    $select_discount .= "<option value='" . $i . "'>" . $i . "%</option>";
	}

	$data = array(
	    "select_checkintime"  => $select_checkintime,
	    "select_checkouttime" => $select_checkouttime,
	    "select_discount"     => $select_discount,
	    "fullcost"	      => $service_main_amount,
	    "select_marker"	      => $select_marker,
	    'group_name'	      => date( "Y-m-d-His" ),
	    "select_price_types"  => $select_price_types,
	    'grp_datein'	      => $datein,
	    'grp_dateout'	      => $dateout,
	    'duration'	      => $duration,
	    "select_dealer"	      => $select_dealer,
	    'categories'	      => $categories
	);
	$this->mlanguages->getdictionary( "modaldatacreate", "", $data );
	$group_html = $this->parser->parse( 'templates/reservations_build_fastorder_modal_groupblock.html',
		$data, true );
	//$group_html = $this->parser->parse('templates/reservations_build_fastorder_modal_groupblock_new.html', $data, true);
	return $group_html;
    }

    function get_fastmodal_group_html_new( $from, $to, $type_id )
    {

	$checktime_mass = array(
	    "00:00",
	    "00:30",
	    "01:00",
	    "01:30",
	    "02:00",
	    "02:30",
	    "03:00",
	    "03:30",
	    "04:00",
	    "04:30",
	    "05:00",
	    "05:30",
	    "06:00",
	    "06:30",
	    "07:00",
	    "07:30",
	    "08:00",
	    "08:30",
	    "09:00",
	    "09:30",
	    "10:00",
	    "10:30",
	    "11:00",
	    "11:30",
	    "12:00",
	    "12:30",
	    "13:00",
	    "13:30",
	    "14:00",
	    "14:30",
	    "15:00",
	    "15:30",
	    "15:00",
	    "15:30",
	    "16:00",
	    "16:30",
	    "17:00",
	    "17:30",
	    "18:00",
	    "18:30",
	    "19:00",
	    "19:30",
	    "20:00",
	    "20:30",
	    "21:00",
	    "21:30",
	    "22:00",
	    "22:30",
	    "23:00",
	    "23:30"
	);
	$select_marker = '<option selected value="0">---</option>';
	;
	$query = $this->db->query( "SELECT * FROM reservation_markers" );
	foreach( $query->result() as $row2 ){

	    $select_marker .= '<option value="' . $row2->id . '">' . $row2->name . '</option>';
	}
	$dealers = array();
	$price_types = array();
	$query = $this->db->query( "SELECT * FROM dealers WHERE is_active = 1 ORDER BY ordervalue ASC" );
	foreach( $query->result() as $row ){
	    array_push( $dealers,
		    array(
		"id"	    => $row->id,
		"name"	    => $row->name,
		"isdefault" => $row->isdefault
	    ) );
	}
	$query = $this->db->query( "SELECT * FROM rate WHERE isactive = 1" );
	foreach( $query->result() as $row ){
	    array_push( $price_types,
		    array(
		"id"	    => $row->id,
		"name"	    => $row->caption,
		"isdefault" => $row->isdefault
	    ) );
	}

	$default_price_type = 0;
	$query = $this->db->query( "SELECT id FROM rate WHERE isdefault = 1" );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $default_price_type = $row->id;
	}

	$select_dealer = "";
	for( $i = 0; $i < count( $dealers ); $i++ ){
	    if( $dealers [$i] ["isdefault"] == 1 ){
		$select_dealer .= "<option selected value='" . $dealers [$i] ["id"] . "'>" . $dealers [$i] ["name"] . "</option>";
	    } else {
		$select_dealer .= "<option value='" . $dealers [$i] ["id"] . "'>" . $dealers [$i] ["name"] . "</option>";
	    }
	}
	$select_price_types = "";
	for( $i = 0; $i < count( $price_types ); $i++ ){
	    if( $price_types [$i] ["isdefault"] == 1 ){
		$select_price_types .= "<option selected value='" . $price_types [$i] ["id"] . "'>" . $price_types [$i] ["name"] . "</option>";
	    } else {
		$select_price_types .= "<option value='" . $price_types [$i] ["id"] . "'>" . $price_types [$i] ["name"] . "</option>";
	    }
	}
	$checkintime_default = "";
	$query = $this->db->query( "SELECT str_value FROM hotelix_config WHERE name LIKE 'checkintime'" );
	$select_colorofdesk = '';
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $checkintime_default = trim( $row->str_value );
	    $checkintime_default = substr( $checkintime_default, 0, 5 );
	}
	$checkouttime_default = "";
	$query = $this->db->query( "SELECT str_value FROM hotelix_config WHERE name LIKE 'checkouttime'" );
	$select_colorofdesk = '';
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $checkouttime_default = trim( $row->str_value );
	    $checkouttime_default = substr( $checkouttime_default, 0, 5 );
	}

	$select_checkouttime = "";
	for( $i = 0; $i < count( $checktime_mass ); $i++ ){
	    if( $checktime_mass [$i] == $checkouttime_default ){
		$select_checkouttime .= "<option selected value='" . $checktime_mass [$i] . "'>" . $checktime_mass [$i] . "</option>";
	    } else {
		$select_checkouttime .= "<option value='" . $checktime_mass [$i] . "'>" . $checktime_mass [$i] . "</option>";
	    }
	}

	$select_checkintime = "";
	for( $i = 0; $i < count( $checktime_mass ); $i++ ){
	    if( $checktime_mass [$i] == $checkintime_default ){
		$select_checkintime .= "<option selected value='" . $checktime_mass [$i] . "'>" . $checktime_mass [$i] . "</option>";
	    } else {
		$select_checkintime .= "<option value='" . $checktime_mass [$i] . "'>" . $checktime_mass [$i] . "</option>";
	    }
	}

	$datein = gmdate( "Y-m-d", $from * 86400 );
	$dateout = gmdate( "Y-m-d", $to * 86400 );
	//list ( $year, $month, $day ) = explode ( "-", $datein );
	//$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	$intdate = $from;
	//list ( $year, $month, $day ) = explode ( "-", $dateout );
	//$outdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	$outdate = $to;
	$duration = $outdate - $intdate;
	$categories = array();
	$selected_room_count = 0;
	$sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places, categories.settlementtype FROM rooms
		INNER JOIN categories ON categories.id = rooms.category_id
		WHERE categories.is_active = 1
		GROUP by rooms.category_id";
	// echo "<pre>" . $sql . "\n";
	$query = $this->db->query( $sql );
	if( $query->num_rows() > 0 ){
	    foreach( $query->result_array() as $row ){
		$categories [$row ["category_id"]] ["count"] = $row ["count"];
		$categories [$row ["category_id"]] ["base_price"] = $row ["base_price"];
		$categories [$row ["category_id"]] ["name"] = $row ["c_name"];
		$categories [$row ["category_id"]] ["shortname"] = $row ["shortname"];
		$categories [$row ["category_id"]] ["category_id"] = $row ["category_id"];
		if( $row ["category_id"] == $type_id ){
		    $selected_room_count = $row ["count"];
		    $categories [$row ["category_id"]] ["selected"] = "selected";
		} else {
		    $categories [$row ["category_id"]] ["selected"] = "";
		}
	    }
	}
	//$freerooms = $this->frontdesk->getfreeroomsarraygroup ( $datein, $dateout );
	//$categories = $freerooms ['categories'];
	$opions_array = array();
	for( $i = 0; $i <= $selected_room_count; $i++ ){
	    $opions_array [$i] ['value'] = $i;
	    $opions_array [$i] ['text'] = $i;
	    $opions_array [$i] ['category_id'] = $type_id;
	    if( $i == 1 ){
		$opions_array [$i] ['selected'] = "selected";
	    } else {
		$opions_array [$i] ['selected'] = "";
	    }
	}


	$price_calculation_data = array();
	$price_calculation_data ["datein"] = $datein;
	//if($from == $to){
	//	$price_calculation_data ["dateout"] = gmdate ( "Y-m-d", ($to + 1) * 86400 );
	//}else{
	$price_calculation_data ["dateout"] = $dateout;
	//}
	$price_calculation_data ["price_type"] = $default_price_type;
	$price_calculation_data ["type_id"] = $type_id;
	$price_calculation_data ["add_places"] = 0;
	$price_calculation_data ["addbedplace"] = 0;
	$price_calculation_data ["baby_places"] = 0;
	$price_calculation_data ["babyplace2"] = 0;
	$price_array = $this->frontdesk->getpricecalculation( $price_calculation_data,
		0, 0, 1 );
	// echo "<pre>";
	// print_r($price_array);
	// die();
	$service_main_amount = 0;
	foreach( $price_array as $intdate => $cell ){
	    $service_main_amount += $price_array [$intdate] ["amount"];
	}

	$select_discount = "";
	$select_discount .= "<option selected value='" . 0 . "'>---</option>";
	for( $i = 1; $i <= 100; $i++ ){

	    $select_discount .= "<option value='" . $i . "'>" . $i . "%</option>";
	}

	$data = array(
	    "category_id_firstselected" => $type_id,
	    "select_checkintime"	    => $select_checkintime,
	    "select_checkouttime"	    => $select_checkouttime,
	    "select_discount"	    => $select_discount,
	    "fullcost"		    => $service_main_amount,
	    "select_marker"		    => $select_marker,
	    'group_name'		    => date( "Y-m-d-His" ),
	    "select_price_types"	    => $select_price_types,
	    'grp_datein'		    => $datein,
	    'grp_dateout'		    => $dateout,
	    'duration'		    => $duration,
	    "select_dealer"		    => $select_dealer,
	    'categories'		    => $categories,
	    'opions_array'		    => $opions_array
	);
	$this->mlanguages->getdictionary( "modaldatacreate", "", $data );
	$group_html = $this->parser->parse( 'templates/reservations_build_fastorder_modal_groupblock.html',
		$data, true );
	$group_html = $this->parser->parse( 'templates/reservations_build_fastorder_modal_groupblock_new.html',
		$data, true );
	return $group_html;
    }

    function get_modal_ajax_yieldprice( $data )
    {
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_yieldprice_view.php',
			$data, true );
    }

    function get_modal_ajax_edit_reservation_new( $reservation_id,
	    $landing_page = "" )
    {
	$data = array(
	    'reservation_id' => $reservation_id,
	    'landing_page'	 => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_edit_reservation_view.php',
			$data, true );
    }

    function get_modal_ajax_add_service_new( $reservation_id, $return_type = 0,
	    $landing_page = "" )
    {
	$data = array(
	    'id'	       => $reservation_id,
	    'return_type'  => $return_type,
	    'landing_page' => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_add_service_view.php',
			$data, true );
    }

    function get_modal_ajax_add_guest_new( $reservation_id, $guest_id = 0,
	    $landing_page = 0 )
    {

	$data = array(
	    'reservation_id' => $reservation_id,
	    'guest_id'	 => $guest_id,
	    'landing_page'	 => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_add_guest_view.php',
			$data, true );
    }

    function get_simple_modal( $data )
    {
	$this->mlanguages->getdictionary( "reservations_reservationedit", "",
		$data );
	return $this->parser->parse( 'templates/reservation_c2_ajax_simple_modal_view.html',
			$data, true );
    }

    function get_modal_ajax_set_settings()
    {

	$data = array(
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_set_settings_view.php',
			$data, true );
    }

    function get_modal_ajax_set_test_modal()
    {
	$data = array(
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/debug_maria_pages/reservation_c2_ajax_test_modal_view.php',
			$data, true );
    }

    function get_user_calendar_options_modal()
    {
	$data = array(
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/reservation_c2_ajax_user_calendar_options_modal.php',
			$data, true );
    }

    function get_modal_ajax_price_calendar_set_settings()
    {

	$data = array(
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_price_calendar_set_settings_view.php',
			$data, true );
    }

    function get_modal_ajax_add_auto( $reservation_id, $car_id )
    {

	$data = array(
	    'reservation_id' => $reservation_id,
	    'car_id'	 => $car_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_add_auto_view.php',
			$data, true );
    }

    function get_modal_ajax_edit_cvc( $reservation_id )
    {

	$data = array(
	    'reservation_id' => $reservation_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/ajax/reservation_c2_ajax_edit_cvc_view.php',
			$data, true );
    }

    function get_modal_ajax_booking_conversation( $data )
    {
	$this->load->library( 'parser' );
	return $this->load->view( '/ajax/reservation_c2_ajax_booking_conversation_view.php',
			$data, true );
    }

    function get_modal_ajax_foliogroup_alllprint( $data )
    {
	$reservations = $data["reservations"];
	$group_id = $data["group_id"];
	$sql_reservations = array_keys( $reservations );
	$select = implode( ',', $sql_reservations );
	$group_reservations = array();
	$sql = "SELECT deskofreservation.id, deskofreservation.datein, deskofreservation.dateout,groupreservations.name as group_name,
        rooms.category_id as category_id, guests.firstname, guests.lastname, guests.middlename,
        guests.address, guests.email, rooms.name as room_name, categories.name as category_name
        FROM deskofreservation
        INNER JOIN guests ON deskofreservation.guest_id = guests.id
        INNER JOIN rooms ON deskofreservation.room_id = rooms.id
        INNER JOIN categories ON categories.id = rooms.category_id
        LEFT JOIN groupreservations ON deskofreservation.intgroupid = groupreservations.id
        WHERE deskofreservation.id IN ($select)";
	$query = $this->db->query( $sql );
	if( $query->num_rows() > 0 ){
	    $group_reservations = $query->result_array();
	}

	$html_data = array();
	$html_data['group_id'] = $group_id;
	//$html_data['group_reservations'] = $group_reservations;
	$html_data['group_reservations'] = $reservations;
	$html_data['template_area'] = $data["template_area"];
//         echo "<pre>";
//         print_r($_POST);
//         print_r($html_data);
//         die();
//         $template_area = 3;
//         if (isset($_POST["reservations"][0]["template_area"])){
//             $template_area = $_POST["reservations"][0]["template_area"];
//         }
	$this->load->library( 'parser' );
	return $this->load->view( '/ajax/reservation_c2_ajax_foliogroup_alllprint_view.php',
			$html_data, true );
    }

    function get_modal_ajax_booking_misconduct_report( $data )
    {
	$this->load->library( 'parser' );
	return $this->load->view( '/ajax/reservation_c2_ajax_booking_misconduct_report_view.php',
			$data, true );
    }

    function get_modal_ajax_airbnb_edit_category( $category_id )
    {

	$data = array(
	    'category_id' => $category_id,
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/dc_airbnb/dc_airbnb_c2_ajax_edit_category_view.php',
			$data, true );
    }

    function get_modal_ajax_airbnb_room_connect( $data )
    {

	$data = array(
	    'room_id'  => $data["room_id"],
	    'response' => $data["response"]
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/dc_airbnb/dc_airbnb_c2_ajax_room_connect_view.php',
			$data, true );
    }

    function get_modal_ajax_airbnb_room_disconnect_OLD( $room_id, $listing_id )
    {

	$data = array(
	    'room_id'    => $room_id,
	    'listing_id' => $listing_id,
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/dc_airbnb/dc_airbnb_c2_ajax_room_disconnect_view.php',
			$data, true );
    }

    function get_modal_ajax_airbnb_room_disconnect( $data )
    {

	$data = array(
	    'room_id'    => $data["room_id"],
	    'cat_id'     => $data["cat_id"],
	    'listing_id' => $data["listing_id"],
	    'response'   => $data["response"],
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/dc_airbnb/dc_airbnb_c2_ajax_room_disconnect_view.php',
			$data, true );
    }

    function get_modal_ajax_edit_foto_tags( $category_id, $foto_id )
    {

	$data = array(
	    'category_id' => $category_id,
	    'foto_id'     => $foto_id,
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/ajax/setup_categories_c2_ajax_edit_foto_tags_view.php',
			$data, true );
    }

    function get_modal_ajax_edit_property_foto_tags( $property_id, $foto_id )
    {

	$data = array(
	    'property_id' => $property_id,
	    'foto_id'     => $foto_id,
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/ajax/setup_property_c2_ajax_edit_foto_tags_view.php',
			$data, true );
    }

    function get_modal_ajax_airbnb_get_status( $data )
    {

	$data = array(
	    'room_id'  => $data["room_id"],
	    'response' => $data["response"],
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/dc_airbnb/dc_airbnb_c2_ajax_get_status_view.php',
			$data, true );
    }

    function get_modal_ajax_airbnb_check_status( $data )
    {
	//     	$action = "";
	//     	if(isset($data["action"])){
	//     		$action = $data["action"];
	//     	}
	//     	$data = array(
	//     			//'listing_id' => $data["listing_id"],
	//     			'response' => $data["response"],
	//     			'action' => $action
	//     	);
	//     	if(isset($data["listing_id"])){
	//     	}
	$this->load->library( 'parser' );
	return $this->load->view( '/dc_airbnb/dc_airbnb_c2_ajax_check_status_view.php',
			$data, true );
    }

    function get_modal_ajax_airbnb_update( $data )
    {
	$data = array(
	    'room_id'  => $data["room_id"],
	    'response' => $data["response"],
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/dc_airbnb/dc_airbnb_c2_ajax_update_view.php',
			$data, true );
    }

    function get_modal_ajax_airbnb_error( $data )
    {
	$data = array(
	    'room_id'  => $data["room_id"],
	    'response' => $data["response"]
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/dc_airbnb/dc_airbnb_c2_ajax_error_view.php',
			$data, true );
    }

    function get_modal_ajax_helpsystem_c2_show( $type, $cell )
    {
	$data = array(
	    'type' => $type,
	    'cell' => $cell
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'helpsystem_c2_ajax_show_view.php', $data,
			true );
    }

    function get_modal_ajax_helpsystem_c2_edit( $type, $cell )
    {
	$data = array(
	    'type' => $type,
	    'cell' => $cell
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'helpsystem_c2_ajax_edit_view.php', $data,
			true );
    }

    function get_modal_ajax_edit_identifiers( $reservation_id )
    {

	$data = array(
	    'reservation_id' => $reservation_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_edit_identifiers_view.php',
			$data, true );
    }

    function get_modal_ajax_edit_fms( $reservation_id )
    {

	$data = array(
	    'reservation_id' => $reservation_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_edit_fms_view.php',
			$data, true );
    }

    function get_modal_ajax_add_comment( $reservation_id, $comment_id )
    {

	$data = array(
	    'reservation_id' => $reservation_id,
	    'comment_id'	 => $comment_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_add_comment_view.php',
			$data, true );
    }

    function get_modal_ajax_add_task( $data )
    {
	$data['task_id'] = !isset( $data['task_id'] ) ? 0 : $data['task_id'];
	$data['die_url'] = !isset( $data['die_url'] ) ? "" : $data['die_url'];
	$this->load->library( 'parser' );
	return $this->load->view( '/tasks_c2/tasks_c2_ajax_add_task.php', $data,
			true );
    }

    function get_modal_ajax_edit_wifi_user( $data )
    {
	return $this->load->view( 'reservation_c2_ajax_edit_wifi_user.php',
			$data, true );
    }

    function get_modal_ajax_edit_main_info( $reservation_id, $guest_id = 0 )
    {

	$data = array(
	    'reservation_id' => $reservation_id,
	    'guest_id'	 => $guest_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_edit_main_info_view.php',
			$data, true );
    }

    function get_modal_ajax_add_payment_new( $reservation_id, $return_type = 0,
	    $landing_page = "" )
    {
	$data = array(
	    'id'	       => $reservation_id,
	    'return_type'  => $return_type,
	    'landing_page' => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_add_payment_view.php',
			$data, true );
    }

    function get_modal_ajax_add_invoice( $data, $landing_page = "" )
    {
	$html_data = array(
	    'reservation_id' => $data['reservation_id'],
	    'factura_id'	 => $data['factura_id'],
	    'landing_page'	 => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/ajax/reservation_c2_ajax_add_invoice_view.php',
			$html_data, true );
    }

    function get_modal_ajax_fiscalise_payment( $reservation_id, $payment_id,
	    $return_type = 0, $landing_page = "" )
    {
	$data = array(
	    'id'	       => $reservation_id,
	    'payment_id'   => $payment_id,
	    'return_type'  => $return_type,
	    'landing_page' => $landing_page
	);
	$this->load->library( 'parser' );
	if( $this->releases->kkm_renewing() ){
	    return $this->load->view( 'reservation_c2_ajax_fiscalise_payment_view_renewing.php',
			    $data, true );
	} else {
	    return $this->load->view( 'reservation_c2_ajax_fiscalise_payment_view.php',
			    $data, true );
	}
    }

    function get_modal_ajax_recover_check( $reservation_id, $payment_id,
	    $return_type = 0, $landing_page = "" )
    {
	$data = array(
	    'id'	       => $reservation_id,
	    'payment_id'   => $payment_id,
	    'return_type'  => $return_type,
	    'landing_page' => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_recover_check_view.php',
			$data, true );
    }

    function get_modal_ajax_fiscalise_refund( $reservation_id, $refund_id,
	    $return_type = 0, $landing_page = "" )
    {
	$data = array(
	    'id'	       => $reservation_id,
	    'refund_id'    => $refund_id,
	    'return_type'  => $return_type,
	    'landing_page' => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_fiscalise_refund_view.php',
			$data, true );
    }

    function get_modal_ajax_add_cc_payment( $reservation_id, $guest_id,
	    $landing_page = "" )
    {
	$data = array(
	    'guest_id'	 => $guest_id,
	    'reservation_id' => $reservation_id,
	    'landing_page'	 => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'payments_c2_ajax_add_cc_payment_view.php',
			$data, true );
    }

    function get_modal_ajax_edit_cc_payment( $data )
    {

	$this->load->library( 'parser' );
	return $this->load->view( 'payments_c2_ajax_edit_cc_payment_view.php',
			$data, true );
    }

    function get_modal_ajax_modal_test_smtp( $data )
    {

	$this->load->library( 'parser' );
	return $this->load->view( '/ajax/setup_smtp_c2_ajax_modal_test_smtp_view.php',
			$data, true );
    }

    function get_modal_ajax_add_marker( $reservation_id, $return_type = 0 )
    {
	$data = array(
	    'id'	      => $reservation_id,
	    'return_type' => $return_type
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_add_marker_view.php',
			$data, true );
    }

    function get_modal_ajax_guest_map( $reservation_id, $guest_id )
    {
	$data = array(
	    'reservation_id' => $reservation_id,
	    'guest_id'	 => $guest_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_guest_map_view.php',
			$data, true );
    }

    function get_modal_ajax_guest_scan( $guest_id )
    {
	$data = array(
	    'guest_id' => $guest_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_guest_scan_view.php',
			$data, true );
    }

    function get_modal_ajax_guest_template_print( $reservation_id, $guest_id )
    {
	$data = array(
	    'reservation_id' => $reservation_id,
	    'guest_id'	 => $guest_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_guest_map_view.php',
			$data, true );
    }

    function get_modal_ajax_services_template_print( $data )
    {

	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_services_template_print_view.php',
			$data, true );
    }

    function get_modal_ajax_checkout_step_2_template_print( $data )
    {
	//print_r($data);
	$this->load->library( 'parser' );
	return $this->load->view( 'master_c2_ajax_checkout_step_2_template_print_view.php',
			$data, true );
    }

    function get_multy_guest_template_print( $data )
    {

	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_multy_guest_template_print.php',
			$data, true );
    }

    function get_modal_ajax_res_cancel( $reservation_id, $return_type = 0 )
    {
	$data = array(
	    'id'	      => $reservation_id,
	    'return_type' => $return_type
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_res_cancel_view.php',
			$data, true );
    }

    function get_modal_ajax_print_buttons( $reservation_id, $guest_id,
	    $template_id )
    {
	$data = array(
	    'reservation_id' => $reservation_id,
	    'guest_id'	 => $guest_id,
	    'template_id'	 => $template_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_print_buttons_view.php',
			$data, true );
    }

    function get_modal_ajax_add_refund_new( $reservation_id, $landing_page = "" )
    {
	$data = array(
	    'id'	       => $reservation_id,
	    'landing_page' => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_add_refund_view.php',
			$data, true );
    }

    function get_modal_ajax_edit_refund_new( $reservation_id, $refund_id,
	    $landing_page = "" )
    {
	$data = array(
	    'id'	       => $refund_id,
	    'paylist'      => "",
	    'landing_page' => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_edit_refund_view.php',
			$data, true );
    }

    function get_modal_ajax_edit_company_customer( $reservation_id,
	    $id_company_customer, $landing_page = "" )
    {
	$data = array(
	    'reservation_id'      => $reservation_id,
	    'id_company_customer' => $id_company_customer,
	    'landing_page'	      => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_edit_company_customer_view.php',
			$data, true );
    }

    function get_modal_ajax_edit_user( $user_id )
    {
	$data = array(
	    'id' => $user_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'users_c2_ajax_edit_user_view.php', $data,
			true );
    }

    function get_modal_ajax_edit_payment_new( $reservation_id, $pay_id,
	    $intgroupid = 0, $landing_page = "" )
    {
	$data = array(
	    'id'	       => $pay_id,
	    'intgroupid'   => $intgroupid,
	    'paylist'      => "",
	    'landing_page' => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_edit_payment_view.php',
			$data, true );
    }

    function get_modal_ajax_calendar_restricts( $data )
    {

	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_calendar_restricts_view.php',
			$data, true );
    }

    function get_modal_ajax_add_grouppayment( $data )
    {
//         $data = array(
//             'group_id' => $data ['group_id'],
//             'landing_page' => $data['landing_page']
//         );
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_edit_grouppayment_view.php',
			$data, true );
    }

    function get_modal_ajax_edit_group_data( $data )
    {
	if( isset( $data["action_data"] ) ){
	    $this->load->library( 'parser' );
	    return $this->load->view( 'reservation_c2_ajax_edit_group_data_view.php',
			    $data, true );
	} else {
	    $this->mlanguages->getdictionary( "", "", $data );
	    $tmpl = $this->parser->parse( 'templates/reservation_c2_ajax_edit_group_data_fail_view.html',
		    $data, true );
	    echo $tmpl;
	}
    }

    function get_modal_ajax_edit_service_new( $reservation_id, $service_id,
	    $landing_page = "" )
    {
	$data = array(
	    'id'		 => $service_id,
	    'reservation_id' => $reservation_id,
	    'landing_page'	 => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_edit_service_view.php',
			$data, true );
    }

    function get_modal_ajax_edit_mainservice_new( $reservation_id, $service_id,
	    $landing_page = "" )
    {
	$data = array(
	    'id'		 => $service_id,
	    'reservation_id' => $reservation_id,
	    'landing_page'	 => $landing_page
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_edit_mainservice_view.php',
			$data, true );
    }

    function get_modal_ajax_multyres_cancel( $data )
    {

	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_multyres_cancel_view.php',
			$data, true );
    }

    function get_modal_ajax_transfer( $reservation_id )
    {
	$data = array(
	    'res_id' => $reservation_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_transfer_view.php',
			$data, true );
    }

    function get_left_menu( $id_menu_active, $id_child_menu_active = 1 )
    {
	$data = array();
	$menu_array = $this->navigation->get_left_munu();
	$menu_array [$id_menu_active] ['class'] = "active";
	$menu_array [$id_menu_active] ['child_list'][$id_child_menu_active]['child_class'] = "active";
	$data ["left_menu"] = $menu_array;
	$this->mlanguages->getdictionary( "left_menu_c2", "", $data );
	$menu = $this->parser->parse( 'templates/left_menu_c2_view.html', $data,
		true );
	return $menu;
    }

    function get_chmanager_c2_left_menu( $id_menu_active )
    {
	$data = array();
	$menu_array = $this->navigation->get_chmanager_c2_menu();
	$menu_array [$id_menu_active] ['class'] = "active";
	$data ["left_menu"] = $menu_array;
	$this->mlanguages->getdictionary( "left_menu_c2", "", $data );
	$menu = $this->parser->parse( 'templates/left_settings_mainmenu_c2_view.html',
		$data, true );
	return $menu;
    }

    function get_left_settings_menu( $id_menu_active = 0,
	    $id_submenu_active = 0, $menu_type = "" )
    {
	$data = array();
	switch( $menu_type ){
	    case "chmanager_c2":
		$menu_array = $this->navigation->get_left_munu();
		break;
	    default:
		$menu_array = $this->navigation->get_settings_c2_menu();
		break;
	}

	$menu_array [$id_menu_active] ['class'] = "active";
	if( $id_submenu_active > 0 )
	    $menu_array [$id_menu_active] ["child_list"] [$id_submenu_active] ["child_class"] = "active";
	$data ["left_menu"] = $menu_array;
	$this->mlanguages->getdictionary( "left_menu_c2", "", $data );
	$main_menu = $this->parser->parse( 'templates/left_settings_mainmenu_c2_view.html',
		$data, true );
	$data_submenu = array();
	$data_submenu = $menu_array [$id_menu_active];
	$this->mlanguages->getdictionary( "left_menu_c2", "", $data_submenu );
	$sub_menu = $this->parser->parse( 'templates/left_settings_submenu_c2_view.html',
		$data_submenu, true );
	$return_data = array();
	$return_data ["main_menu"] = $main_menu;
	$return_data ["sub_menu"] = $sub_menu;
	return $return_data;
    }

    function get_modal_ajax_get_confirm( $reservation_id, $action, $landingpage )
    {
	//	/reservation_c2/set_checkin/{reservation_id}
	//	/reservation_c2/set_checkout/{reservation_id}
	//	/reservations/set_reservation_avoidtime/{reservation_id}/1
	switch( $action ){
	    case "checkin_res" :
		$caption_approve_action = "{caption_checkin_title}";
		$caption_approve_action_title = "{caption_checkin_msg}";
		$url = "/reservation_c2/set_checkin/" . $reservation_id . "/$landingpage";
		break;
	    case "checkout_res" :
		$caption_approve_action = "{caption_checkout_title}";
		$caption_approve_action_title = "{caption_checkout_msg}";
		$url = "/master_c2/checkout_step_1/" . $reservation_id;
		break;
	    case "accept_res" :
		$caption_approve_action = "{caption_approve_title}";
		$caption_approve_action_title = "{caption_approve_msg}";
		$url = "/reservations/set_reservation_avoidtime/" . $reservation_id . "/$landingpage";
		break;
	    case "turn_status" :
		$caption_approve_action = "{caption_turn_status_title}";
		$caption_approve_action_title = "{caption_turn_status_msg}";
		$url = "/reservation_c2/turn_status/" . $reservation_id . "/$landingpage";
		break;
	}
	$data = array(
	    'res_id'		       => $reservation_id,
	    'url'			       => $url,
	    'caption_approve_action'       => $caption_approve_action,
	    'caption_approve_action_title' => $caption_approve_action_title
	);
	$this->mlanguages->getdictionary( "confirm_modal_msg", "", $data );
	$this->load->library( 'parser' );
	echo $this->parser->parse( 'templates/ajax_get_confirm_view.html',
		$data, true );
    }

    function get_all_categories_from_db()
    {
	$rezult_arr = array();
	$overbooking_category_id = 0;
	$query = $this->db->query( "SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'" );
	if( $query->num_rows() > 0 ){
	    $row = $query->row();
	    $overbooking_category_id = $row->value;
	}

	$query = $this->db->query( "SELECT id, is_active, shortname, name FROM categories ORDER BY `order` ASC" );
	foreach( $query->result() as $row ){
	    if( $row->shortname == "" ){
		$shortname = $row->name;
	    } else {
		$shortname = $row->shortname;
	    }
	    if( $row->id != $overbooking_category_id ){
		$rezult_arr[$row->id] = array('name' => $shortname, 'is_active' => $row->is_active);
	    } else {
		$rezult_arr[$row->id] = array('name' => $shortname, 'is_active' => $row->is_active,
		    'over' => true);
	    }
	}
	return $rezult_arr;
    }

    function get_all_statuses_from_db()
    {
	$prefix = $this->mlanguages->get_language_prefix();
	$status_table_name = "global_hotelix_languages." . $prefix . "_statusofreservation";
	$rezult_arr = array();
	$query = $this->db->query( "SELECT id, type, name FROM " . $status_table_name . " ORDER BY `id` ASC" );
	foreach( $query->result() as $row ){
	    $rezult_arr[$row->id] = array('name' => $row->name, 'type' => $row->type);
	}
	return $rezult_arr;
    }

    function get_modal_ajax_check_allprint( $reservation_id, $template_area )
    {
	$data = array(
	    'reservation_id' => $reservation_id,
	    'guest_id'	 => '',
	    'template_area'	 => $template_area,
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_check_allprint_view.php',
			$data, true );
    }

    function get_modal_ajax_check_print_fms( $reservation_id )
    {
	$data = array(
	    'reservation_id' => $reservation_id,
	    'guest_id'	 => ''
	);
	$this->load->library( 'parser' );
	return $this->load->view( '/ajax/reservation_c2_ajax_check_print_fms_view.php',
			$data, true );
    }

    function get_modal_ajax_print_invoice( $reservation_id, $template_area_id )
    {
	$data = array(
	    'reservation_id'   => $reservation_id,
	    'template_area_id' => $template_area_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_print_invoice_view.php',
			$data, true );
    }

    function get_modal_ajax_print_bso( $reservation_id, $bso_id )
    {
	$data = array(
	    'reservation_id' => $reservation_id,
	    'bso_id'	 => $bso_id
	);
	$this->load->library( 'parser' );
	return $this->load->view( 'reservation_c2_ajax_print_bso_view.php',
			$data, true );
    }

    function pagination( $all_lines_count, $lines_per_page, $cur_page,
	    $url_for_pagination, $max_per_page = 500 )
    {
	$data = array();
	$data['all_lines_count'] = $all_lines_count;
	$data['lines_per_page'] = $lines_per_page;
	$data['selected_page'] = $cur_page;
	$data['url_for_pagination'] = $url_for_pagination;
	$data['max_per_page'] = $max_per_page;
	$this->load->library( 'parser' );
	return $this->load->view( 'pagination_view.php', $data, true );
    }
}
