<?
class geoip_model extends CI_model
{
    public function __construct()
    {
        parent::__construct();        
    }
    
    public function get_coordinates( $address, $country )
    {
        /** Google or 2gis switch */
        if( in_array($country, ['RUS', 'BLR', 'ABH'] ) ){
            return $this->get_2gis_coordinates( $address );
        } else {
            return $this->get_rapid_api_coordinates( $address, $country );
        }       
    }
    
    public function get_coordinates_old( $address, $lang )
    {
        $response = Unirest\Request::get('https://google-maps-geocoding.p.rapidapi.com/geocode/json?language='
            . $lang
            . '&address='
            . $address,
            array(
                "X-RapidAPI-Host" => "google-maps-geocoding.p.rapidapi.com",
                "X-RapidAPI-Key" => "44de372cb6msh9e65a3dd431c174p1a365ajsn5f82875116b3"
            )
            );
        return $response;
    }

    private function get_2gis_coordinates( $address ): ?string
    {
        $query = http_build_query(['q' => $address, 'key' => 'd27a4468-9e67-4a3e-867a-37a5bafb9b0f', 'fields' => 'items.point']);

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => "https://catalog.api.2gis.com/3.0/items/geocode?$query",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET"
        ]);
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        //echo $response;

        if ($err) {
            return "";
        }

        $geo_array = json_decode($response, true);

        if( ! isset( $geo_array['result'] ) ) return "";

        $result = $geo_array['result'];

        $lat = $result['items'][0]['point']['lat'] ?? '';
	    $lng = $result['items'][0]['point']['lon'] ?? '';
	    
	    return $lat.",".$lng;
    }

    private function get_rapid_api_coordinates( $address, $country ): ?string
    {
        $query = http_build_query(['query' => $address, 'country' => $country]);

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => "https://maps-data.p.rapidapi.com/geocoding.php?$query",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "x-rapidapi-host: maps-data.p.rapidapi.com",
                "x-rapidapi-key: 44de372cb6msh9e65a3dd431c174p1a365ajsn5f82875116b3"
            ],
        ]);
        
        $response = curl_exec($curl);
        
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            return "";
        }

        $geo_array = json_decode($response, true);
	    
	    $lat = $geo_array['data']['lat'] ?? '';
	    $lng = $geo_array['data']['lng'] ?? '';
	    
	    return $lat.",".$lng;
    }
}
