<?php

class formsprinter_model_vit extends CI_Model
{
    public string $hms_host;
    public string $implode_str;
    public array $data;
    public string $template_language;

    public function __construct()
    {
        parent::__construct();
        $this->load->model('mpartners');
        $this->load->model ( 'mcustomers' );
        $this->template_language = '';
    }

    public function get_group_template($array, $return_type = 0)
    {
        /** GET TEMPLATE */
        $template_id = $array['template_id'];

        if (isset($array['template_location_type'])) {
            switch ($array['template_location_type']) {
                case 'global':
                    $table = 'global_hotelix_common.templates';
                    break;
                case 'local':
                default:
                    $table = 'templates';
                    break;
            }
        }
        $template = $this->db->select('html, language')->where('id', $template_id)->get($table)->row();
        if ($template == null) {
            echo '<div class="alert alert-primary alert-dismissible" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button><b>{caption_no_templates}</b></div>';
            return false;
        }

        /** GET HMS DATA */
        $lang_id = $this->db->where('code', $template->language)->get('global_hotelix_languages.localization')->result_array()['code_int']
                    ?? $this->hotelix_config->get_record('global_language', 'int');
        
        $hms_hotel_id = $this->config->item('hotel_id');
       
        
        if( in_array($_SERVER['REMOTE_ADDR'], ["109.70.24.230"]) ){
	        $this->hms_host = "agast.ru";
	    } else {
	        $this->hms_host = "otelms.com";
	    }

        $this->template_language = $template->language;

        /** GET TEMPLATE DATA */
        $ids_reservations = array_keys($array['group_reservations']);
        $this->get_template_data( $ids_reservations, $lang_id, $template->language );

        /** RETURN PARSED TEMPLATE (1) OR PRINT IT (0) */
        switch ($return_type) {
            case 1:
                $this->load->library('parser');
                return $this->parser->parse_string(stripslashes($template->html), $this->data, true);

                break;
            case 0:
                if( $this->session->userdata('global_debug') ){
                    echo '<pre>'.
                    json_encode(
                        $this->data,
                        JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE
                    );
                    echo '</pre>';
                }
                $this->load->library('parser');
                echo $this->parser->parse_string(stripslashes($template->html), $this->data, true);

                return false;
                break;
        }
    }

    public function get_template_data( array $ids_reservations, int $lang_id,  string $template_language): void
    {
        $this->data = [];
        $this->data['fpl_wifi_name'] = $this->hotelix_config->get_record('wifi_hotspot_name', 'str');
        $this->data['fpl_now_date'] =  $this->frontdesk->systemdateformat(date('Y-m-d'));
        
        $this->implode_str = implode(',', $ids_reservations);

        $sql = "SELECT internationalfields.value AS fpl_services_name, services_types.name as system_name,
                    action_time AS fpl_services_action_time, 
                    count AS fpl_services_services_count,
                    price AS fpl_servicesamount_perunit, 
                    amount AS fpl_servicesamount, 
                    reservation_id as fpl_reservation_id,
                    'additional' AS service_type, measurements.name as measurement_name,
                    tax_on, tax, 
                    services.`description` as fpl_services_description
                FROM services
                INNER JOIN services_types ON services.type = services_types.id
                LEFT JOIN  measurements ON  services_types.measurement_id = measurements.id
                LEFT JOIN internationalfields ON services.type = internationalfields.table_id
                    AND internationalfields.table_type = 'service' 
                    AND internationalfields.language_id = $lang_id
                    AND internationalfields.name = 'international_name'
                LEFT JOIN internationalfields AS international_descr ON services.type = internationalfields.table_id
                    AND internationalfields.table_type = 'service' 
                    AND internationalfields.language_id = $lang_id
                    AND internationalfields.name = 'international_comment'
                WHERE reservation_id IN ($this->implode_str)
                ORDER BY fpl_services_action_time
        ";
        $services = $this->db->query($sql)->result_array();

        $sql = "SELECT internationalfields.value AS fpl_services_name, services_types_main.name as system_name,
                    international_descr.value AS fpl_services_description, amount AS fpl_servicesamount, reservation_id as fpl_reservation_id, 
                    `time` as fpl_services_action_time, measurements.name as measurement_name,
                    'main' AS service_type, `type`, 1 as tax_on, tax
                FROM services_main
                INNER JOIN services_types_main ON services_main.type = services_types_main.id
                LEFT JOIN  measurements ON  services_types_main.measurement_id = measurements.id
                LEFT JOIN internationalfields ON  services_main.type = internationalfields.table_id
                    AND internationalfields.table_type = 'service_main' 
                    AND internationalfields.language_id = $lang_id
                    AND internationalfields.name = 'international_name'
                LEFT JOIN internationalfields AS international_descr ON services_main.type = internationalfields.table_id
                    AND internationalfields.table_type = 'service_main' 
                    AND internationalfields.language_id = $lang_id
                    AND internationalfields.name = 'international_comment'
                WHERE reservation_id IN ($this->implode_str)
                ORDER BY `time`
        ";
        $main_services = $this->db->query($sql)->result_array();

        $taxes = $this->db
            ->select('taxes_fees.name AS fpl_tax_type, taxes_fees2property.name AS fpl_services_name, services_tf.value as fpl_servicesamount, 
                        type_id, vat_value as tax, period_type, reservation_id as fpl_reservation_id')
            ->where_in('reservation_id', $ids_reservations)
            ->join('taxes_fees2property', 'services_tf.taxes_fees_id=taxes_fees2property.id')
            ->join('taxes_fees', 'taxes_fees2property.type_id=taxes_fees.id')
            ->get('services_tf')
            ->result_array();
        
        $payments = $this->db
            ->select('payment_types.name, payment.operationtime, payment.description, payment.amount as total, 
                        payment.id as id_payment, reservation_id as fpl_reservation_id')
            ->where_in('reservation_id', $ids_reservations)
            ->join('payment_types', 'payment.type=payment_types.id')
            ->order_by('operationtime', 'asc')
            ->get('payment')
            ->result_array();

        $refunds = $this->db
            ->select('payment_types.name as payment_name, refund.id as refund_id, refund.operationtime as refund_time, 
                        refund.description, refund.amount, reservation_id as fpl_reservation_id')
            ->where_in('reservation_id', $ids_reservations)
            ->join('payment_types', 'refund.type=payment_types.id')
            ->get('refund')
            ->result_array();
        
        $this->data['fpl_reservations'] = [];
        
        /** POST SOVIET */
        $this->data['fpl_ServicesList'] = [];
        $this->data['fpl_ServicesMainList'] = [];
        $this->data['fpl_AllServicesList'] = [];
        $this->data['fplTaxesFeesList'] = [];
        
        /** INTERNATIONAL */
        $this->data['fpl_folio_events'] = [];
        $this->data['fpl_bank_details'] = [];
        $this->data['fpl_taxes_fees'] = [];

        $all_charges = array_merge($main_services, $services, $taxes);
        $deskofdays = $this->get_deskofdays($ids_reservations);
        $durations = [];

        $this->data['fpl_total_charges'] = 0;
        $this->data['fpl_total_credits'] = 0;
        $this->data['fpl_room_count'] = 0;
        $this->data['fpl_nights_count'] = 0;
        $guests = $this->get_guests($ids_reservations);

        foreach ($ids_reservations as $res_id) {
            $reservation = $this->get_reservation_data($res_id, $lang_id);
            $reservation['fpl_add_places'] = $reservation['fpl_add_places'] > 0 ? $reservation['fpl_add_places'] : 0;
            $reservation['date'] = $this->frontdesk->systemdateformat($reservation['date']);
            $reservation['fpl_check_in'] = $this->frontdesk->systemdateformat($reservation['fpl_check_in']);
            $reservation['fpl_check_out'] = $this->frontdesk->systemdateformat($reservation['fpl_check_out']);
            $reservation['fpl_reservation_balance'] = $this->frontdesk->showcurrency($reservation['fpl_reservation_balance']);
            $reservation['fpl_total_guest_count'] = $reservation['fpl_adults'] + $reservation['fpl_add_beds'] 
                        + $reservation['fpl_children'] + $reservation['fpl_infants'];
            $reservation['fpl_categories_name'] = $reservation['fpl_categories_name'] == null 
                        ? $reservation['system_cat_name'] : $reservation['fpl_categories_name'];

            $durations[$res_id] = $reservation['fpl_reservation_duration'];
            $this->data['fpl_reservations'][$res_id] = $reservation;

            $property_id = $property_id ?? $reservation['property_id'];
            unset($this->data['fpl_reservations'][$res_id]['property_id']);

            $partner_id = $partner_id ?? $reservation['id_partner'];
            unset($this->data['fpl_reservations'][$res_id]['id_partner']);

            if( ! isset( $company_customer_id ) || $company_customer_id == 0  ) {
                $company_customer_id = $reservation['id_company_customer'];
            }
            
            $partner_data = $partner_data ?? $this->mpartners->getPartner( $partner_id );
            
            $this->data['fpl_vat_percent'] = $partner_data->nds_value;
            $this->data['fpl_invoice_id'] = 'G-' . $reservation['fpl_group_id'];

            /** COUNT ALL ROOMS IN THE GROUP */
            if( $reservation['status'] != 5 ){
                ++$this->data['fpl_room_count'];
                $this->data['fpl_nights_count'] += $reservation['fpl_reservation_duration'];
            }
            unset( $this->data['fpl_reservations'][$res_id]['status'] );

            $reservation['fpl_meal_plan'] = $this->mlanguages->getdictionaryword("tbl_meal_policies", $template_language, 
                                                                            "-{$reservation['fpl_meal_plan']}-");
            
            $this->data['fpl_reservations'][$res_id]['fpl_per_room_main_services'] = [];
            $this->data['fpl_reservations'][$res_id]['fpl_per_room_services'] = [];
            $this->data['fpl_reservations'][$res_id]['fpl_per_room_taxes_fees'] = [];

            foreach( $guests as &$g ){
                if( $g == null ) continue;
                $g['fpl_dob'] = $this->frontdesk->systemdateformat($g['fpl_dob']);
                $g['fpl_validity'] = $this->frontdesk->systemdateformat($g['fpl_validity']);
                $g['fpl_fullname'] = "{$g['fpl_firstname']} {$g['fpl_lastname']}";         
                
                if( $g['reservation_id'] != $reservation['fpl_reservation_id'] ) continue;
                if( $reservation['guest_id'] == $g['guest_id'] ){
                    $guest_name = $guest_name ?? "{$g['fpl_firstname']} {$g['fpl_lastname']}";
                    $this->data['fpl_reservations'][$res_id]['fpl_guest_firstname'] = $g['fpl_firstname'];
                    $this->data['fpl_reservations'][$res_id]['fpl_guest_lastname'] = $g['fpl_lastname'];
                    $this->data['fpl_reservations'][$res_id]['fpl_guest_address'] = $g['fpl_address'];
                    $this->data['fpl_reservations'][$res_id]['fpl_guest_addrhousing'] = $g['fpl_addrhousing'];
                    $this->data['fpl_reservations'][$res_id]['fpl_guest_city'] = $g['fpl_city'];
                    $this->data['fpl_reservations'][$res_id]['fpl_guest_state'] = $g['fpl_state'];
                    $this->data['fpl_reservations'][$res_id]['fpl_guest_citizenship'] = $g['fpl_citizenship'];
                    $this->data['fpl_reservations'][$res_id]['fpl_guest_postcode'] = $g['fpl_postcode'];

                    if( !isset($this->data['fpl_guest_firstname']) ){
                        $this->data['fpl_guest_firstname'] = $g['fpl_firstname'];
                        $this->data['fpl_guest_lastname'] = $g['fpl_lastname'];
                        $this->data['fpl_guest_address'] = $g['fpl_address'];
                        $this->data['fpl_guest_addrhousing'] = $g['fpl_addrhousing'];
                        $this->data['fpl_guest_city'] = $g['fpl_city'];
                        $this->data['fpl_guest_state'] = $g['fpl_state'];
                        $this->data['fpl_guest_citizenship'] = $g['fpl_citizenship'];
                        $this->data['fpl_guest_postcode'] = $g['fpl_postcode'];
                    }

                }
                unset($g['reservation_id']);

                $this->data['fpl_guestsList'][$g['guest_id']] = $g;
                $this->data['fpl_reservations'][$res_id]['fpl_room_guests'][] = $g;
                unset($this->data['fpl_guestsList'][$g['guest_id']]['guest_id']);
                
                $g = null;
                
                unset( $this->data['fpl_reservations'][$res_id]['guest_id']);
            }
            $this->data['fpl_reservations'][$res_id]['fpl_coma_guests'] = implode(
                ', ', array_column($this->data['fpl_reservations'][$res_id]['fpl_room_guests'], 'fpl_fullname') );
            
            foreach( $all_charges as &$s ){
                
                if( $s == null || $s['fpl_reservation_id'] != $res_id ) continue;

                /** VAT BLOCK */
                if($partner_data->nds == 1 ){
                    if( ! isset($s['fpl_tax_type']) Xor $s['type_id'] ?? 9 == 2 ){
                        $amount_without_vat = ($s['fpl_servicesamount']/(100+$s['tax'])) * 100;
                        $amount_vat = ($amount_without_vat / 100) * $s['tax'];
                        if( isset($vat_block[$s['tax']]) ){
                            $this->data['fpl_vat_block'][$s['tax']]['fpl_net_value'] += $amount_without_vat;
                            $this->data['fpl_vat_block'][$s['tax']]['fpl_vat_value'] += $amount_vat;
                            $this->data['fpl_vat_block'][$s['tax']]['fpl_brutto_value'] += $s['fpl_servicesamount'];
                        } else {
                            $this->data['fpl_vat_block'][$s['tax']] = [
                            'fpl_vat_rate' => $s['tax'],
                            'fpl_net_value' => $amount_without_vat,
                            'fpl_vat_value' => $amount_vat,
                            'fpl_brutto_value' => $s['fpl_servicesamount']
                            ];
                        }
                    }
                } else {
                    $this->data['fpl_vat_block'] = [];
                }
               
                /** MAIN SERVICES */
                if( isset($s['service_type']) && $s['service_type'] == 'main' ){
                    $this->process_main_service(
                        $s, $deskofdays, $res_id, $reservation['fpl_room_name'], 
                        $reservation['fpl_check_in'], $reservation['fpl_check_out'], $guest_name, $reservation['fpl_categories_name']
                    );
                    
                    $this->data['fpl_ServicesMainList'][] = $s;
                  
                /** TAXES AND FEES */

                } elseif( isset($s['fpl_tax_type']) ) {
                    
                    $this->process_tax_fee(
                        $s, $deskofdays, $res_id, $reservation['fpl_room_name'], 
                        $reservation['fpl_check_in'], $guest_name
                    );

                    $this->data['fpl_taxes_fees'][] = $s;

                /** ADDITIONAL SERVICES */

                } else {
                    $this->data['fpl_folio_events'][] = [
                        'fpl_event_date' => $this->frontdesk->systemdateformat($s['fpl_services_action_time']),
                        'fpl_event_name' => strlen($s['fpl_services_name']) > 1 
                                                ? $s['fpl_services_name'] 
                                                : $s['system_name'],
                        'fpl_room_name' => "{$reservation['fpl_room_name']}",
                        'fpl_reservation_id' => $res_id,
                        'fpl_event_charge' => $this->frontdesk->showcurrency($s['fpl_servicesamount']),
                        'fpl_event_credit' => '',
                        'fpl_guest_name' => $guest_name
                    ];
                    $s['fpl_services_action_time'] = $this->frontdesk->systemdateformat( $s['fpl_services_action_time'] );
                    $s['fpl_services_name'] = strlen($s['fpl_services_name']) > 1 
                                            ? $s['fpl_services_name'] 
                                            : $s['system_name'];
                    
                    unset( $s['system_name']);
                    unset( $s['service_type']);
                    unset( $s['tax_on']);
                    unset( $s['tax']);

                    $this->data['fpl_ServicesList'][] = $s;
                    $this->data['fpl_reservations'][$res_id]['fpl_per_room_services'][] = $s;
                    $this->data['fpl_total_charges'] += $s['fpl_servicesamount'];
                    $service['fpl_measurement'] = $this->mlanguages->getdictionaryword("tbl_measurements", 
                                    $this->template_language, $s['measurement_name'] ?? '{-items-}');
                }
                
                $this->data['fpl_AllServicesList'][] = $s;
                $s = null;               
            }

            foreach( $payments as $p ){
                if( $p['fpl_reservation_id'] != $res_id) continue;
                $this->data['fpl_folio_events'][] = [
                    'fpl_event_date' => $this->frontdesk->systemdateformat( $p['operationtime'] ),
                    'fpl_event_name' => $p['name'],
                    'fpl_room_name' => "{$reservation['fpl_room_name']}",
                    'fpl_reservation_id' => $res_id,
                    'fpl_event_charge' => '',
                    'fpl_event_credit' => $this->frontdesk->showcurrency($p['total']),
                    'fpl_guest_name' => $guest_name
                ];
                $this->data['fpl_total_credits'] += $p['total'];
            }

            foreach( $refunds as $r ){
                if( $r['fpl_reservation_id'] != $res_id) continue;
                $this->data['fpl_folio_events'][] = [
                    'fpl_event_date' => $this->frontdesk->systemdateformat( $r['refund_time'] ),
                    'fpl_event_name' => $r['payment_name'],
                    'fpl_room_name' => "{$reservation['fpl_room_name']}",
                    'fpl_reservation_id' => $res_id,
                    'fpl_event_charge' => '',
                    'fpl_event_credit' => $this->frontdesk->showcurrency(-$r['amount']),
                    'fpl_guest_name' => $guest_name
                ];
                $this->data['fpl_total_credits'] -= $r['amount'];

            }

            $amenities = $this->frontdesk->get_category_amenity_types_all($reservation['category_id']);
            foreach( $amenities as $key => &$a ){
                if( $a['category_amenity_name'] == null ){
                    unset($amenities[$key]);
                    continue;
                }
                $a['category_amenity_name'] = $this->mlanguages->getdictionaryword("tbl_roomscategories_equipment",
                                                                                    $template_language, 
                                                                                    "-{$a['category_amenity_name']}-"
                                                                                );
                unset( $a['category_amenity_booking_name'] );
                unset( $a['category_amenity_airbnb_name'] );
                unset( $a['category_amenity_tripadvisor_name'] );
                unset( $a['category_amenity_expedia_name'] );
            }
            unset($this->data['fpl_reservations'][$res_id]['category_id']);
            unset($this->data['fpl_reservations'][$res_id]['date']);
            unset($this->data['fpl_reservations'][$res_id]['price_category_name']);
            unset($this->data['fpl_reservations'][$res_id]['price_system_cat_name']);
            unset($this->data['fpl_reservations'][$res_id]['ud_price_category']);
            unset($this->data['fpl_reservations'][$res_id]['system_cat_name']);
            unset($this->data['fpl_reservations'][$res_id]['id_company_customer']);
            
            
            $this->data['fpl_reservations'][$res_id]['fpl_category_amenities'] = $amenities;

            unset($reservation);
            unset($amenities);
        }
        $this->data['fpl_coma_guests'] = implode( ', ', array_column($this->data['fpl_guestsList'], 'fpl_fullname') );
        //$this->data['fpl_reservations'] = array_values($this->data['fpl_reservations']);
        //$this->data['fpl_guestsList'] = array_values($this->data['fpl_guestsList']);

        $this->data['fpl_hotel_amenities_list']  = $this->frontdesk->get_property_amenity_types_all($property_id); //amenity_name
        foreach( $this->data['fpl_hotel_amenities_list']  as &$a ){
            $a['amenity_name'] = $this->mlanguages->getdictionaryword(
                                        "setup_property_c2_description", 
                                        $template_language, 
                                        "-{$a['amenity_name']}-");

            unset($a['amenity_booking_name']);
            unset($a['amenity_airbnb_name']);
            unset($a['amenity_tripadvisor_name']);
            unset($a['amenity_expedia_name']);
        }

        $property_data = $this->get_property_data( $property_id );
        
        usort($this->data['fpl_folio_events'], function ($a, $b){return strnatcmp($a["fpl_event_date"], $b["fpl_event_date"]);});

        for( $i = 0; $i < count($this->data['fpl_folio_events']); $i++ ){
            $this->data['fpl_folio_events'][$i]['fpl_event_counter'] = $i + 1;
        }

        for( $i = 0; $i < count($this->data['fpl_ServicesList']); $i++ ){
            $this->data['fpl_ServicesList'][$i]['fpl_counter'] = $i + 1;
        }

        for( $i = 0; $i < count($this->data['fpl_ServicesMainList']); $i++ ){
            $this->data['fpl_ServicesMainList'][$i]['fpl_counter'] = $i + 1;
        }

        for( $i = 0; $i < count($this->data['fpl_AllServicesList']); $i++ ){
            $this->data['fpl_AllServicesList'][$i]['fpl_counter'] = $i + 1;
        }

        if($company_customer_id > 0){
	        $customer_data = $this->mcustomers->getCustomer($company_customer_id);
	
	        $this->data ["fpl_customer_company_name"] = $customer_data->name;
	        $this->data ["fpl_customer_company_inn"] = $customer_data->doc_inn;
	        $this->data ["fpl_customer_company_kpp"] = $customer_data->zkpo;
	        $this->data ["fpl_customer_company_address"] = $customer_data->address;
	    }else{
	        $this->data ["fpl_customer_company_name"] = "";
	        $this->data ["fpl_customer_company_inn"] = "";
	        $this->data ["fpl_customer_company_kpp"] = "";
	        $this->data ["fpl_customer_company_address"] = "";
	    }

        $this->data['fpl_hotel_name'] = $property_data['property_name'];
        $this->data['fpl_hotel_address'] = $property_data['street'];
        $this->data['fpl_hotel_city'] = $property_data['city'];
        $this->data['fpl_hotel_state'] = $property_data['state'];
        $this->data['fpl_hotel_country'] = $property_data['property_name'];
        $this->data['fpl_hotel_zip'] = $property_data['post_code'];
        $this->data['fpl_hotel_phone'] = $property_data['reception_phone'];
        $this->data['fpl_hotel_mail'] = $property_data['email'];
        $this->data['fpl_gps'] = $property_data['gps_coordinates'];
        $this->data['fpl_check_in_time'] = $property_data['check_in_time'];
        $this->data['fpl_check_out_time'] = $property_data['check_out_time'];        

        $this->data['fpl_vat_id'] = $partner_data->nds_number;
        $this->data['fpl_partner_name'] = $partner_data->name;
        $this->data['fpl_partner_legal_name'] = $partner_data->legal_name;
        $this->data['fpl_partner_tin'] = $partner_data->DOC_INN;
        $this->data['fpl_partner_sn'] = $partner_data->DOC_SN;
        $this->data['fpl_partner_reg_id'] = $partner_data->ZKPO;
        $this->data['fpl_partner_account_number'] = $partner_data->accountnumber;
        $this->data['fpl_partner_correspondent_account'] = $partner_data->correspondent_account;
        $this->data['fpl_partner_swift'] = $partner_data->swift;
        $this->data['fpl_partner_bic'] = $partner_data->bic;
        $this->data['fpl_partner_bankname'] = $partner_data->bankname;
        $this->data['fpl_partner_addrLine1'] = $partner_data->addrLine1;
        $this->data['fpl_partner_addrLine2'] = $partner_data->addrLine2;
        $this->data['fpl_partner_city'] = $partner_data->city;
        $this->data['fpl_partner_email'] = $partner_data->email;
        $this->data['fpl_partner_region'] = $partner_data->state;
        $this->data['fpl_partner_zip'] = $partner_data->postcode;

        $this->data['fpl_datein'] = $this->frontdesk->systemdateformat( $deskofdays[0]['date'] );
        $this->data['fpl_dateout'] = $this->frontdesk->systemdateformat( date( 'Y-m-d', ( $deskofdays[count($deskofdays) - 1]['intdate'] + 1 ) * 86400) );
        $this->data['fpl_balance'] = $this->frontdesk->showcurrency($this->data['fpl_total_credits'] - $this->data['fpl_total_charges']);
        $this->data['fpl_total_charges'] = $this->frontdesk->showcurrency($this->data['fpl_total_charges']);
        $this->data['fpl_total_credits'] = $this->frontdesk->showcurrency($this->data['fpl_total_credits']);

        foreach( $this->data['fpl_vat_block'] AS &$vat){
            $vat['fpl_net_value'] = $this->frontdesk->showcurrency($vat['fpl_net_value']);
            $vat['fpl_vat_value'] = $this->frontdesk->showcurrency($vat['fpl_vat_value']);
            $vat['fpl_brutto_value'] = $this->frontdesk->showcurrency($vat['fpl_brutto_value']);
        }

	    $static_bank_data = array (
	        'bank_name' => $partner_data->bankname,
	        'swift' => $partner_data->swift,
	        'account_number' => $partner_data->accountnumber,
	        'korr_account' => $partner_data->correspondent_account
	    );
	    $partners_edit_page_data = $this->mpartners->partners_edit_page_data($partner_data->country, $partner_data->type_of_company, $template_language);
	    foreach ($static_bank_data as $key => $value) {
	        if ($partners_edit_page_data['fields'][$key] != "d0") {
	            array_push ( $this->data ["fpl_bank_details"], array (
	                'fpl_caption_key' => $partners_edit_page_data ['caption_fields'] [$key],
	                'fpl_caption_value' => $value
	            ) );
	        };
	    }
    }

    private function get_reservation_data(int $res_id, int $lang_id): array
    {
        $sql = "SELECT dr.id as fpl_reservation_id, dc_reservationid as fpl_ota_reservation_id, intgroupid as fpl_group_id, 
            -- /** auxiliary */
            guest_id, `date`, dr.id_partner, categories.property_id, `status`, id_company_customer,
            -- /** pricing */
            dr.balance as fpl_reservation_balance,
            rates.value as fpl_rate_name, -- rate.id as tarif_id, 
            rate.cancellation_policy_id as rate_cancellation_policy_id,
            meal_policies.name as fpl_meal_plan, 
            -- /** arrival, depature */
            dr.duration as fpl_reservation_duration, datein as fpl_check_in, dateout as fpl_check_out, 
            checkintime as fpl_check_in_time, checkouttime as fpl_check_out_time,  
            -- /** guests */
            dr.adults as fpl_adults, dr.add_places as fpl_add_places, dr.addbedplace as fpl_add_beds, 
            dr.baby_places as fpl_children, dr.babyplace2 as fpl_infants, 
            -- /** room data */
            cat.value as fpl_categories_name, categories.name AS system_cat_name, cat_comm.value AS fpl_room_description, rooms.category_id AS category_id, 
            price_cat.value AS price_category_name, price_sys_cat.name AS price_system_cat_name, ud_price_category,
            rooms.name AS fpl_room_name
            FROM deskofreservation as dr
            JOIN rooms ON dr.room_id=rooms.id
            JOIN categories ON  rooms.category_id=categories.id
            LEFT JOIN categories price_sys_cat ON dr.ud_price_category=price_sys_cat.id
            -- /** category internationalization */
            LEFT JOIN internationalfields cat ON  rooms.category_id=cat.table_id
                AND cat.table_type = 'category' 
                AND cat.language_id = $lang_id
                AND cat.name = 'international_name'
            LEFT JOIN internationalfields price_cat ON price_cat.table_id = ud_price_category
                AND price_cat.table_type = 'category' 
                AND price_cat.language_id = $lang_id
                AND price_cat.name = 'international_name'
            LEFT JOIN internationalfields cat_comm ON cat_comm.table_id = rooms.category_id
                AND cat_comm.table_type = 'category' 
                AND cat_comm.language_id = $lang_id
                AND cat_comm.name = 'international_comment'
            -- /** rate internationalization */
            LEFT JOIN internationalfields rates ON dr.price_type = rates.table_id 
                AND rates.table_type LIKE 'rate' 
                AND rates.language_id = $lang_id 
                AND rates.name LIKE 'international_name'
            LEFT JOIN rate ON dr.price_type = rate.id
            LEFT JOIN meal_policies ON meal_policies.id = rate.meal_policy_id
            WHERE dr.id = $res_id";

        $data = $this->db->query($sql)->row_array();
        ksort($data);

        return $data;
    }

    private function get_deskofdays(array $res_ids): array
    {
        return $this->db
            ->where_in('reservation_id', $res_ids)
            ->order_by('intdate', 'ASC')
            ->order_by('reservation_id', 'DESC')
            ->get('deskofdays')
            ->result_array();
    }
    
    private function get_property_data( int $property_id ): array
    {
        $property_data = $this->db->where('id', $property_id)->get('property_information')->row_array();
        $property_data['logo'] = "https://desktop.{$this->hms_host}/gatepublic/show_property_logo/$property_id/logo.jpg";
        unset($property_data['logo_original']);
        unset($property_data['logo_small']);
        return $property_data;
    }

    private function get_guests(array $res_ids): array
    {
        $guests = $this->db->select('firstname as fpl_firstname, lastname as fpl_lastname, middlename as fpl_middlename, dob as fpl_dob, email as fpl_email, phone as fpl_phone,
                    address as fpl_address, addrapt as fpl_addrapt, addrbuilding as fpl_addrbuilding, addrhousing as fpl_addrhousing, 
                    citizenship as fpl_citizenship, postcode as fpl_postcode, city as fpl_city, guests.state as fpl_state,
                    doc_types.name as fpl_doc_type, doc_precode as fpl_doc_precode, passportid as fpl_doc_id, doc_date_open as fpl_validity, passportissuedby as fpl_passportissuedby,
                    reservation_id, guests.id as guest_id')
            ->where_in('reservation_id', $res_ids)
            ->join('guests', 'reservation_details.guest_id=guests.id')
            ->join(
                'wifi_radius_vouchers',
                'reservation_details.guest_id=wifi_radius_vouchers.guest_id AND wifi_radius_vouchers.res_id IN('. $this->implode_str . ')',
                'left'
            )
            ->join('doc_types', 'guests.doc_type=doc_types.id', 'left')
            ->get('reservation_details')
            ->result_array();

        array_walk($guests, 'ksort');
        return $guests;
    }
    
    private function process_main_service( 
        array &$service, 
        array $deskofdays, 
        int $reservation_id, 
        string $room_name,
        string $datein,
        string $dateout,
        string $guest_name,
        string $category_name
    ){
        $service['fpl_services_action_time'] = $this->frontdesk->systemdateformat( $service['fpl_services_action_time'] );
        $duration = 0;
        switch($service['type']){
            /** Accommodation */
            case 1:
                foreach( $deskofdays as $day ){
                    if( $day['reservation_id'] == $reservation_id ){
                        $this->data['fpl_folio_events'][] = [
                            'fpl_event_date' => $this->frontdesk->systemdateformat( $day['date'] ),
                            'fpl_event_name' => strlen($service['fpl_services_name']) > 1 
                                                    ? $service['fpl_services_name'] 
                                                    : $service['system_name'],
                            'fpl_room_name' => $room_name,
                            'fpl_reservation_id' => $reservation_id,
                            'fpl_event_charge' => $this->frontdesk->showcurrency($day['price']),
                            'fpl_event_tax' => '',
                            'fpl_event_credit' => '',
                            'fpl_guest_name' => $guest_name
                        ];
                        ++$duration;
                        $this->data['fpl_total_charges'] += $day['price'];
                    }
                }
                $service['fpl_services_services_count'] = $duration;
                $service['fpl_services_name'] = strlen($service['fpl_services_name']) > 1 
                                                    ? $service['fpl_services_name'] 
                                                    : $service['system_name'];
                unset($service['system_name']);
                unset($service['service_type']);
                unset($service['type']);
                unset($service['tax_on']);
                unset($service['tax']);
                $service['fpl_services_name'] .= ' ' . $this->mlanguages->getdictionaryword("ajax_check_allprint", 
                                    $this->template_language, "{clt_acc_in_room}") . ' "' . $category_name . '"';
                $service['fpl_servicesamount_perunit'] = $this->frontdesk->showcurrency($service['fpl_servicesamount']/$duration);
                
                $service['fpl_measurement'] = $this->mlanguages->getdictionaryword("tbl_measurements", 
                                    $this->template_language, "{-days-}");
                unset($service['measurement_name']);
                $this->data['fpl_reservations'][$reservation_id]['fpl_per_room_main_services'][] = $service;
            break;
            /** Cancellation fee */
            case 2:
                $this->data['fpl_folio_events'][] = [
                    'fpl_event_date' => $this->frontdesk->systemdateformat( date( 'Y-m-d', strtotime( $service['fpl_services_action_time'] ) ) ),
                    'fpl_event_name' => strlen($service['fpl_services_name']) > 1 
                                            ? $service['fpl_services_name'] 
                                            : $service['system_name'],
                    'fpl_room_name' => $room_name,
                    'fpl_reservation_id' => $reservation_id,
                    'fpl_event_charge' => $this->frontdesk->showcurrency($service['fpl_servicesamount']),
                    'fpl_event_credit' => '',
                    'fpl_guest_name' => $guest_name
                ];
                $this->data['fpl_total_charges'] += $service['fpl_servicesamount'];

                $service['fpl_services_name'] = strlen($service['fpl_services_name']) > 1 
                                                    ? $service['fpl_services_name'] 
                                                    : $service['system_name'];
                unset($service['system_name']);
                unset($service['service_type']);
                unset($service['type']);
                unset($service['tax_on']);
                unset($service['tax']);

                $service['fpl_services_services_count'] = 1;
                $service['fpl_measurement'] = '';
                unset($service['measurement_name']);
                $service['fpl_servicesamount_perunit'] = $this->frontdesk->showcurrency($service['fpl_servicesamount']);

                $this->data['fpl_reservations'][$reservation_id]['fpl_per_room_main_services'][] = $service;
            break;
            /** Tourist tax */
            case 3:
                foreach( $deskofdays as $day ){
                    if( $day['reservation_id'] == $reservation_id ){
                        $this->data['fpl_folio_events'][] = [
                            'fpl_event_date' => $this->frontdesk->systemdateformat( $day['date'] ),
                            'fpl_event_name' => strlen($service['fpl_services_name']) > 1 
                                                    ? $service['fpl_services_name'] 
                                                    : $service['system_name'],
                            'fpl_room_name' => $room_name,
                            'fpl_reservation_id' => $reservation_id,
                            'fpl_event_charge' => $this->frontdesk->showcurrency($service['fpl_servicesamount']/$duration),
                            'fpl_event_credit' => '',
                            'fpl_guest_name' => $guest_name
                        ];
                    }
                }
                $this->data['fpl_total_charges'] += $service['fpl_servicesamount'];

                $service['fpl_services_services_count'] = $duration;

                $service['fpl_services_name'] = strlen($service['fpl_services_name']) > 1 
                                            ? $service['fpl_services_name'] 
                                            : $service['system_name'];
                unset($service['system_name']);
                unset($service['service_type']);
                unset($service['type']);
                unset($service['tax_on']);
                unset($service['tax']);
                $service['fpl_servicesamount_perunit'] = $this->frontdesk->showcurrency($service['fpl_servicesamount']/$duration);
                $service['fpl_measurement'] = '';
                unset($service['measurement_name']);

                $this->data['fpl_reservations'][$reservation_id]['fpl_per_room_main_services'][] = $service;
            break;
            /** Early check-in */
            case 4:
                $this->data['fpl_folio_events'][] = [
                    'fpl_event_date' =>  $this->frontdesk->systemdateformat($datein),
                    'fpl_event_name' => strlen($service['fpl_services_name']) > 1 
                                            ? $service['fpl_services_name'] 
                                            : $service['system_name'],
                    'fpl_room_name' => $room_name,
                    'fpl_reservation_id' => $reservation_id,
                    'fpl_event_charge' => $this->frontdesk->showcurrency($service['fpl_servicesamount']),
                    'fpl_event_credit' => '',
                    'fpl_guest_name' => $guest_name
                ];
                $this->data['fpl_total_charges'] += $service['fpl_servicesamount'];
                $service['fpl_services_name'] = strlen($service['fpl_services_name']) > 1 
                                            ? $service['fpl_services_name'] 
                                            : $service['system_name'];
                unset($service['system_name']);
                unset($service['service_type']);
                unset($service['type']);
                unset($service['tax_on']);
                unset($service['tax']);
                $service['fpl_services_services_count'] = 1;
                $service['fpl_servicesamount_perunit'] = $this->frontdesk->showcurrency($service['fpl_servicesamount']);
                $service['fpl_measurement'] = '';
                unset($service['measurement_name']);

                $this->data['fpl_reservations'][$reservation_id]['fpl_per_room_main_services'][] = $service;
            break;
            /** Late Check-out */
            case 5:
                $this->data['fpl_folio_events'][] = [
                    'fpl_event_date' =>  $this->frontdesk->systemdateformat($dateout),
                    'fpl_event_name' => strlen($service['fpl_services_name']) > 1 
                                            ? $service['fpl_services_name'] 
                                            : $service['system_name'],
                    'fpl_room_name' => $room_name,
                    'fpl_reservation_id' => $reservation_id,
                    'fpl_event_charge' => $this->frontdesk->showcurrency($service['fpl_servicesamount']),
                    'fpl_event_credit' => '',
                    'fpl_guest_name' => $guest_name
                ];
                $this->data['fpl_total_charges'] += $service['fpl_servicesamount'];
                $service['fpl_services_name'] = strlen($service['fpl_services_name']) > 1 
                                            ? $service['fpl_services_name'] 
                                            : $service['system_name'];
                unset($service['system_name']);
                unset($service['service_type']);
                unset($service['type']);
                unset($service['tax_on']);
                unset($service['tax']);
                $service['fpl_services_services_count'] = 1;
                $service['fpl_servicesamount_perunit'] = $this->frontdesk->showcurrency($service['fpl_servicesamount']);
                $service['fpl_measurement'] = '';
                unset($service['measurement_name']);

                $this->data['fpl_reservations'][$reservation_id]['fpl_per_room_main_services'][] = $service;
            break;
            default:
            break;
        }
    }

    private function process_tax_fee( 
        array &$service, 
        array $deskofdays, 
        int $reservation_id, 
        string $room_name, 
        string $datein,
        string $guest_name
    ) {
        $service['fpl_services_action_time'] = $this->frontdesk->systemdateformat( $datein );
        $duration = 0;
        if( $service['period_type'] == 1 ){
            foreach( $deskofdays as $day ){
                if( $day['reservation_id'] == $reservation_id ){
                    $this->data['fpl_folio_events'][] = [
                        'fpl_event_date' =>  $this->frontdesk->systemdateformat($day['date']),
                        'fpl_event_name' => strlen($service['fpl_services_name']) > 1 
                                                ? $service['fpl_services_name'] 
                                                : $service['fpl_tax_type'],
                        'fpl_room_name' => $room_name,
                        'fpl_reservation_id' => $reservation_id,
                        'fpl_event_charge' => $this->frontdesk->showcurrency($service['fpl_servicesamount']/$duration),
                        'fpl_event_credit' => '',
                        'fpl_guest_name' => $guest_name
                    ];
                    ++$duration;
                }
            }

            $service['fpl_services_description'] = '';
            $service['fpl_services_services_count'] = $duration;
            $service['fpl_services_name'] = strlen($service['fpl_services_name']) > 1 
                                                ? $service['fpl_services_name'] 
                                                : $service['system_name'];
            unset($service['fpl_tax_type']);
            unset($service['type_id']);
            unset($service['tax']);
            unset($service['period_type']);
            $service['fpl_measurement'] = '';
            $service['fpl_servicesamount_perunit'] = $this->frontdesk->showcurrency($service['fpl_servicesamount']/$duration);
            $this->data['fplTaxesFeesList'][] = $service;
            $this->data['fpl_reservations'][$reservation_id]['fpl_per_room_taxes_fees'][] = $service;
       
        } else {
            $this->data['fpl_folio_events'][] = [
                'fpl_event_date' =>  $this->frontdesk->systemdateformat($datein),
                'fpl_event_name' => strlen($service['fpl_services_name']) > 1 
                                        ? $service['fpl_services_name'] 
                                        : $service['fpl_tax_type'],
                'fpl_room_name' => $room_name,
                'fpl_reservation_id' => $reservation_id,
                'fpl_event_charge' => $this->frontdesk->showcurrency($service['fpl_servicesamount']),
                'fpl_event_credit' => '',
                'fpl_guest_name' => $guest_name
            ];
        }
        $this->data['fpl_total_charges'] += $service['fpl_servicesamount'];

        $service['fpl_services_description'] = '';
        $service['fpl_services_services_count'] = $duration;
        $service['fpl_services_name'] = strlen($service['fpl_services_name']) > 1 
                                                ? $service['fpl_services_name'] 
                                                : $service['system_name'];
        unset($service['fpl_tax_type']);
        unset($service['type_id']);
        unset($service['tax']);
        unset($service['period_type']);
        $service['fpl_measurement'] = '';
        $service['fpl_servicesamount_perunit'] = $this->frontdesk->showcurrency($service['fpl_servicesamount']);
        $this->data['fplTaxesFeesList'][] = $service;
        $this->data['fpl_reservations'][$reservation_id]['fpl_per_room_taxes_fees'][] = $service;
    }
}
