<?php defined('BASEPATH') or exit('No direct script access allowed');

class Dcm_su_api extends dcm_abstract
{
    public $test_mode;
    public $url;
    public $auth;

    public function __construct(){
        parent::__construct();
        $this->test_mode = false;
        $this->url = $this->config->item('su_prod_url');
        $this->auth = $this->config->item('su_prod_auth');
    }

    public function get_su_properties(int $hms_id): array
    {
        $url = $this->url.'pmsproperty';
        $headers = [
            'Authorization: Basic '.$this->auth,
            'Content-Type: application/json',
            'app-id: b3RlbG1zLnN1aXNzdS5jb20='
        ];

        $useragent = 'Otelms';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_USERAGENT, $useragent);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $buffer = curl_exec($ch);
        curl_close($ch);

        $result = json_decode($buffer, true);

        if (isset($result['properties']) && !empty($result['properties'])) {
            foreach ($result['properties'] as $k => $prop) {
                $mask = 'hms-'.$hms_id;
                if (!preg_match("~$mask~", $prop['propertyid'])) {
                    $result['properties'][$k];
                }
            }
        }

        return $result;
    }

    public function get_properties_list(): array
    {
        $sql = "SELECT pi.id as property_id, internationalfields.value AS property_name, active.id as is_active, 
                    autoclose.int_value as autoclose, services.int_value as service
                FROM property_information as pi
                LEFT JOIN dc_su_api_properties_active as active ON pi.id = active.hms_property_id
                LEFT JOIN dc_su_xml_cfg AS autoclose ON pi.id = autoclose.dc_account_id AND autoclose.name = 'autoclose'
                LEFT JOIN dc_su_xml_cfg AS services ON pi.id = services.dc_account_id AND services.name = 'service_type_id'
                LEFT JOIN internationalfields ON pi.id=internationalfields.table_id 
                AND table_type = 'property_custom'
                AND language_id = 45
                AND internationalfields.`name` = 'international_name'";

        $query = $this->db->query($sql);

        return $query->result_array();
    }

    public function get_properties_short_list(): array
    {
        $sql = "SELECT hms_property_id as dc_account_id, internationalfields.value AS property_name
                FROM dc_su_api_properties_active
                LEFT JOIN internationalfields ON dc_su_api_properties_active.hms_property_id=internationalfields.table_id 
	            AND table_type = 'property_custom'
	            AND language_id = 45
	            AND internationalfields.`name` = 'international_name'";

        $su_properties = $this->db->query($sql)->result_array();

        return $su_properties;
    }

    public function get_categories_list(string $sql_join, string $set_active, int $prop_id): array
    {
        $overbooking_cat = $this->hotelix_config->get_record('overbooking_category_id', 'int');

        $sql = "SELECT count(rooms.id) as room_count,  categories.id, internationalfields.value AS name, categories.property_id, categories.places, 
            categories.add_places, categories.baby_places, categories.size, categories.size_type, categories.base_price,
            room_types.name AS type_name, su_cat.id AS active_id, prop.value AS property_name, synced.max AS room_limit, 
            su_cat.room_limit AS intent_room_limit
	    FROM categories 
	    LEFT JOIN  room_types ON room_types.id = categories.room_type_id
	    LEFT JOIN  rooms ON rooms.category_id = categories.id AND rooms.is_active = 1
		LEFT JOIN  internationalfields ON internationalfields.table_id = categories.id 
			AND internationalfields.table_type = 'category' 
			AND internationalfields.language_id = 45
			AND internationalfields.name = 'international_name'
        $sql_join dc_su_api_categories_active AS su_cat ON categories.id = su_cat.hms_category_id
		LEFT JOIN internationalfields AS prop ON categories.property_id = prop.table_id
			AND prop.table_type = 'property_custom' 
			AND prop.language_id = 45
			AND prop.name = 'international_name'
        LEFT JOIN dc_su_room_categories_link AS synced ON categories.id = synced.hms_category_id
	    WHERE categories.id <> $overbooking_cat 
		AND categories.is_active = 1 
		AND categories.property_id = $prop_id
		GROUP BY categories.id ORDER BY `order` ASC";

        $rooms = $this->db->query($sql)->result_array();

        return $rooms;
    }

    public function get_rates_list(string $onlinerates_sql): array
    {
        $sql = "SELECT `rate`.`id` AS rate_id, `dc_su_api_rates_active`.`restrictid` AS online_restrictid, 
                `internationalfields`.`value` as international_rate_name, 
                `dc_su_api_rates_active`.`property_id`, `dc_su_api_rates_active`.`id` AS active_id, `meal_policy_id`
                FROM `rate`
                $onlinerates_sql
                LEFT JOIN `internationalfields` ON rate.id = internationalfields.table_id AND internationalfields.table_type LIKE 'rate' 
                AND internationalfields.language_id = 45 AND internationalfields.name LIKE 'international_name'
                WHERE `rate`.`isactive` =  1";

        $hms_rates = $this->db->query($sql)->result_array();

        return $hms_rates;
    }

    public function get_su_rates(string $hotel_id): ?array
    {
        $url = $this->url.'ratedetails';

        $data = [
            'hotelid' => $hotel_id,
        ];

        $headers = [
            'Authorization: Basic '.$this->auth,
            'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
            'Content-Type: application/json',
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_USERAGENT, 'Otelms');

        $buffer = curl_exec($ch);
        curl_close($ch);

        $result = json_decode($buffer, true);

        return $result['rateplans'] ?? null;
    }

    public function get_contacts_list(string $sql_join): array
    {
        $sql = "SELECT contacts.id AS contact_id, PhoneNumber AS phone_number, CityName AS city, AddressLine AS address,  
            Email AS email, GivenName AS contact_name, SurName AS contact_surname, internationalfields.value AS property_name, co.is_active
            FROM contacts 
            $sql_join 
            LEFT JOIN internationalfields ON contacts.property_id=internationalfields.table_id 
            AND table_type = 'property_custom'
            AND language_id = 45
            AND internationalfields.`name` = 'international_name'";

        $contacts = $this->db->query($sql)->result_array();

        return $contacts;
    }

    public function create_update_property(array $data): array
    {
        $property_id = $data['property_id'];

        $dc_hotel_id = "hms-{$data['hms_id']}-$property_id";
        $this->load->model('property_model');

        $property_data = $this->property_model->get_property_data($property_id)[0] ?? [];

        if (empty($property_data)) {
            return [];
        }

        $gps_coordinates_data = $property_data['gps_coordinates'];
        $lat = '';
        $long = '';
        if ($gps_coordinates_data != '') {
            list($lat, $long) = explode(',', $gps_coordinates_data);
        }

        $return_type_ameneties = 2; // return only ameneties_list without types array
        $property_ameneties = $this->property_model->get_property_ameneties($property_id, $return_type_ameneties);

        $facilities = [];

        foreach ($property_ameneties as $amenity_data) {
            array_push(
                $facilities,
                [
                    'Group' => $this->mlanguages->getdictionaryword('setup_property_c2_description', 'eng', $amenity_data['amenety_type_name']),
                    'name' => $this->mlanguages->getdictionaryword('setup_property_c2_description', 'eng', $amenity_data['amenety_name']),
                ]
            );
        }

        $contacts = [];

        array_push(
            $contacts,
            [
            'ContactProfileType' => 'PhysicalLocation',
            'Addresses' => [
                'Address' => [
                    'AddressLine' => $property_data['street_lat'],
                    'CityName' => $property_data['city_lat'],
                    'PostalCode' => $property_data['post_code'],
                    'CountryName' => $property_data['country'],
                    ],
                ],
            ]
        );

        $sql = "SELECT contacts.* FROM contacts 
            INNER JOIN dc_su_api_contacts_active co ON co.hms_contact_id = contacts.id AND co.is_active = 1
            WHERE contacts.property_id = $property_id";

        $query = $this->db->query($sql);

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                array_push($contacts, [
                    'ContactProfileType' => 'availability',
                    'Names' => [
                        'Name' => [
                            'GivenName' => $row->GivenName,
                            'Surname' => $row->SurName,
                        ],
                    ],
                    'Addresses' => [
                        'Address' => [
                            'AddressLine' => $row->AddressLine,
                            'CityName' => $row->CityName,
                            'PostalCode' => $row->PostalCode,
                            'CountryName' => $row->CountryName,
                        ],
                    ],
                    'NotificationEmail' => $row->Email,
                    'Emails' => [
                        'Email' => [
                            $row->Email,
                        ],
                    ],
                    'Phones' => [
                        'Phone' => [
                            [
                                'PhoneNumber' => $row->PhoneNumber,
                                'PhoneTechType' => $row->PhoneTechType,
                            ],
                        ],
                    ],
                ]);
            }
        }

        $currency_code = $this->hotelix_config->get_record('global_currency', 'int');
        $currency_data = $this->frontdesk_c2->get_currency_data_byid($currency_code);
        $currency_str = $currency_data['currency_3char_name'];

        $international_summary_array = $this->internationalfields->get_value('property_custom', $property_id, 'international_summary');
        $description = $international_summary_array[45] ?? '';

        $international_name_array = $this->internationalfields->get_value('property_custom', $property_id, 'international_name');
        $property_name = $international_name_array[45] ?? $dc_hotel_id;

        switch ($data['status']) {
            case 'update':
                $type = 'Overlay';
                break;
            default:
            case 'create':
                $type = 'New';
                break;
        }

        $HotelType = 1;

        switch ($property_data['dwelling']) {
            case 1:
                $HotelType = 3;
                break;
            case 2:
                if ($property_data['property_type'] == 19) {
                    $HotelType = 2;
                }
                break;
            default:
                $HotelType = 1;
                break;
        }

        $global_language = $this->hotelix_config->get_record('global_language', 'int');
        $language_data = $this->frontdesk_c2->get_global_languages_str($global_language);
        $language_2char = $language_data['language_2char'];

        $hotel = [
            'HotelDescriptiveContents' => [
                'HotelDescriptiveContent' => [
                    'HotelName' => $property_name, //Required
                    'HotelType' => $HotelType ?? 1,
                    'TimeZone' => $property_data['timezone'] ?? 'UTC',
                    'hotelid' => $dc_hotel_id,
                    'ChainID' => $data['hms_id'],
                    'LanguageCode' => $language_2char ?? 'en', //Required
                    'CurrencyCode' => $currency_str ?? 'USD', //Required
                    'HotelDescriptiveContentNotifType' => $type,
                    'OfficialCheckinTime' => $property_data['check_in_time'] ?? '14:00',
                    'OfficialCheckoutTime' => $property_data['check_out_time'] ?? '12:00',
                    'ContactInfos' => [
                        'ContactInfo' => $contacts,
                    ],
                    'HotelInfo' => [
                        'Position' => [
                            'Latitude' => $lat,
                            'Longitude' => $long,
                        ],
                    ],
                    'Facilities' => [
                        'Facility' => $facilities,
                    ],
                    'HotelDescription' => $description,
                ],
            ],
        ];

        // ==== CURL REQUEST property =======
        $curl_data = [];
        $curl_data['api_url'] = $this->url.'OTA_HotelDescriptiveContentNotif';
        $curl_data['post_data'] = $hotel;
        $curl_response = $this->dcm_su->request_api($curl_data);
        $return_data = ['curl_response' => $curl_response, 'su_property_id' => $dc_hotel_id];

        return $return_data;
    }

    public function sync_rooms(int $hms_id, int $property_id, bool $is_new = false): array
    {
        $su_property_id = "hms-$hms_id-$property_id";
        $success = false;

        $hms_rooms = $this->db
                ->select('categories.id, add_places, property_id, actve.id AS active, link.dc_category_id as index_id, 
                    str.dc_room_id as str_id, su_cat.dc_room_id as su_cat_id, categories.is_active, room_limit, max')
                ->join('dc_su_api_categories_active as actve', 'categories.id=actve.hms_category_id', 'left')
                ->join('dc_su_room_categories_link as link', 'categories.id=link.hms_category_id', 'left')
                ->join('dc_su_categories_strtoint as str', 'link.dc_category_id=str.id', 'left')
                ->join('dc_su_room_categories as su_cat', 'link.dc_category_id=su_cat.dc_room_id', 'left')
                ->where('categories.property_id', $property_id)
                ->get('categories')
                ->result_array();

        $remote_hash = [];
        $su_inactive = [];
        $to_add = [];
        $to_update = [];
        $to_delete = [];

        if (!$is_new) {
            $su_rooms = $this->dcm_su->get_rooms($su_property_id)['rooms'] ?? [];

            foreach ($su_rooms as $room) {
                array_push($remote_hash, $room['roomid']);
                if ($room['status'] == 'Inactive') {
                    array_push($su_inactive, $room['roomid']);
                }
            }

            foreach ($hms_rooms as $room) {
                $su_mask = "$hms_id-$property_id-{$room['id']}";

                if (in_array($su_mask, $remote_hash)) {
                    if ($room['active'] && $room['is_active']) {
                        array_push($to_update, $su_mask);
                    } else {
                        array_push($to_delete, $su_mask);
                    }
                    $kkey = array_search($su_mask, $remote_hash);
                    unset($remote_hash[$kkey]);
                } else {
                    if ($room['active'] != null && $room['is_active']) {
                        array_push($to_add, $su_mask);
                    } else { // clean up rubish - room is not active and no property on su
                        if ($room['index_id'] != null) {
                            $this->db->where('dc_category_id', $room['index_id'])->delete('dc_su_room_categories_link');
                            $this->db->where('dc_room_id', $room['index_id'])->delete('dc_su_room_categories');
                            $this->db->where('id', $room['index_id'])->delete('dc_su_categories_strtoint');
                            $this->db->where('dc_category_id', $room['index_id'])->delete('dc_su_rate2category_link');
                            $this->db->where('dc_category_id', $room['index_id'])->delete('dc_su_restricts_link');
                            $this->db->where('dc_category_id', $room['index_id'])->delete('dc_su_category2occupancy');
                            $this->db->where('roomcategory', $room['index_id'])->delete('dc_su_occupancy');
                        }
                    }
                }
            }
        } else {
            foreach ($hms_rooms as $room) {
                $su_mask = "$hms_id-$property_id-{$room['id']}";
                if ($room['active'] != null) {
                    array_push($to_add, $su_mask);
                } else { // clean up rubish - room is not active and no property on su
                    if ($room['index_id'] != null) {
                        $this->db->where('dc_category_id', $room['index_id'])->delete('dc_su_room_categories_link');
                        $this->db->where('dc_room_id', $room['index_id'])->delete('dc_su_room_categories');
                        $this->db->where('id', $room['index_id'])->delete('dc_su_categories_strtoint');
                        $this->db->where('dc_category_id', $room['index_id'])->delete('dc_su_rate2category_link');
                        $this->db->where('dc_category_id', $room['index_id'])->delete('dc_su_restricts_link');
                        $this->db->where('dc_category_id', $room['index_id'])->delete('dc_su_category2occupancy');
                        $this->db->where('roomcategory', $room['index_id'])->delete('dc_su_occupancy');
                    }
                }
            }
        }

        if (!empty($remote_hash)) {
            foreach ($remote_hash as $to_del) {
                array_push($to_delete, $to_del);
            }
        }

        $log_data = [];

        foreach ($to_add as $room) {
            $hms_room_id = explode('-', $room)[2] ?? false;
            if (!$hms_room_id) {
                continue;
            }

            $data['su_property_id'] = $su_property_id;
            $data['hms_category_id'] = $hms_room_id;
            $data['hms_id'] = $hms_id;
            $data['room_limit'] = $this->db->where('hms_category_id', $hms_room_id)->get('dc_su_api_categories_active')->row_array()['room_limit'] ?? 0;
            $data['max'] = $this->db->where('hms_category_id', $hms_room_id)->get('dc_su_room_categories_link')->row_array()['max'] ?? 0;
            /** IF BILLING DEPENDS ON INVENTORY, UNCOMMENT THIS AND MIN IN LIMITS*/
            //$room_quantity = $this->db->where('is_active', 1)->where('category_id', $hms_room_id)->get('rooms')->num_rows();

            $su_room_result = $this->create_room($data);

            $success = (isset($su_room_result['curl_response']['Status']) && $su_room_result['curl_response']['Status'] == 'Success');

            if ($success) {
                $log_data[] = [
                    'action' => 'Create room',
                    'object' => $room,
                    'result' => 'success',
                    'error' => '',
                ];
                foreach ($hms_rooms as $hms_room) {
                    if ($hms_room_id == $hms_room['id']) {
                        if ($hms_room['str_id'] == $room) {
                            $this->db->where('dc_room_id', $hms_room['index_id'])->set('active', 1)->update('dc_su_room_categories');
                            for ($oc = 1; $oc <= $hms_room['add_places']; ++$oc) {
                                $sql = "INSERT INTO dc_su_occupancy(id, name, roomcategory)
                                            VALUES('".$oc."', '".$oc."', '".$hms_room['index_id']."')
                                            ON DUPLICATE KEY UPDATE name = '".$oc."', roomcategory = '".$hms_room['index_id']."'";
                                $this->db->query($sql);

                                $sql = "INSERT INTO dc_su_category2occupancy(dc_category_id, hms_occupancy_id, `state`)
                                            VALUES('".$hms_room['index_id']."', '".$oc."', 1)
                                            ON DUPLICATE KEY UPDATE state = state";
                                $this->db->query($sql);
                            }
                        } else {
                            $room_data = $hms_room;
                            $this->db->set('dc_room_id', $room)->insert('dc_su_categories_strtoint');
                            $dc_room_id = $this->db->insert_id();
                            //$min = $room_quantity - $data['room_limit'];
                            $min = 0;
                            $data = [
                                'dc_category_id' => $dc_room_id,
                                'hms_category_id' => $hms_room_id,
                                'min' => $min,
                                'max' => $data['room_limit'],
                            ];
                            $this->db->set($data)->insert('dc_su_room_categories_link');

                            $data = [
                                'dc_hotel_id' => $property_id,
                                'dc_room_id' => $dc_room_id,
                                'active' => 1,
                            ];

                            $this->db->set($data)->insert('dc_su_room_categories');

                            if (isset($room_data)) {
                                for ($oc = 1; $oc <= $room_data['add_places']; ++$oc) {
                                    $sql = "INSERT INTO dc_su_occupancy(id, name, roomcategory)
                                            VALUES('".$oc."', '".$oc."', '".$dc_room_id."')
                                            ON DUPLICATE KEY UPDATE name = '".$oc."', roomcategory = '".$dc_room_id."'";
                                    $this->db->query($sql);

                                    $sql = "INSERT INTO dc_su_category2occupancy(dc_category_id, hms_occupancy_id, `state`)
                                            VALUES('".$dc_room_id."', '".$oc."', 1)
                                            ON DUPLICATE KEY UPDATE state = state";
                                    $this->db->query($sql);
                                }
                            }
                        }
                    }
                }
            } else {
                $log_data[] = [
                    'action' => 'Add room',
                    'object' => $room,
                    'result' => 'fail',
                    'error' => $su_room_result['curl_response']['Errors'][0]['ShortText'],
                ];
            }
            unset($su_room_result);
        }

        foreach ($to_update as $room) {
            $hms_room_id = explode('-', $room)[2] ?? 0;
            if (!$hms_room_id) {
                continue;
            }
            $data['su_property_id'] = $su_property_id;
            $data['hms_category_id'] = $hms_room_id;
            $data['hms_id'] = $hms_id;
            $data['room_limit'] = $this->db->where('hms_category_id', $hms_room_id)->get('dc_su_api_categories_active')->row_array()['room_limit'] ?? 0;
            $data['max'] = $this->db->where('hms_category_id', $hms_room_id)->get('dc_su_room_categories_link')->row_array()['max'] ?? 0;
            /** IF BILLING DEPENDS ON INVENTORY, UNCOMMENT THIS AND MIN IN LIMITS*/
            //$room_quantity = $this->db->where('is_active', 1)->where('category_id', $hms_room_id)->get('rooms')->num_rows();

            if (in_array($room, $su_inactive)) {
                $su_room_result = $this->dcm_su->change_room_status($su_property_id, $room, 'active');
                if (isset($su_room_result['curl_response']['Status']) && $su_room_result['curl_response']['Status'] == 'Success') {
                    $log_data[] = [
                        'action' => 'Activate room',
                        'object' => $room,
                        'result' => 'success',
                        'error' => '',
                    ];
                } else {
                    $log_data[] = [
                        'action' => 'Update room',
                        'object' => $room,
                        'result' => 'fail',
                        'error' => $su_room_result['curl_response']['Errors'][0]['ShortText'],
                    ];
                }
                unset($su_room_result);
            }

            $su_room_result = $this->update_room($data);
            $success = (isset($su_room_result['curl_response']['Status']) && $su_room_result['curl_response']['Status'] == 'Success');

            if ($success) {
                $log_data[] = [
                    'action' => 'Update room',
                    'object' => $room,
                    'result' => 'success',
                    'error' => '',
                ];
                foreach ($hms_rooms as $hms_room) {
                    if ($hms_room_id == $hms_room['id']) {
                        if ($hms_room['str_id'] == $room) {
                            $this->db->where('dc_room_id', $hms_room['index_id'])->set('active', 1)->update('dc_su_room_categories');

                            for ($oc = 1; $oc <= $hms_room['add_places']; ++$oc) {
                                $sql = "INSERT INTO dc_su_occupancy(id, name, roomcategory)
                                        VALUES('".$oc."', '".$oc."', '".$hms_room['index_id']."')
                                        ON DUPLICATE KEY UPDATE name = '".$oc."', roomcategory = '".$hms_room['index_id']."'";
                                $this->db->query($sql);

                                $sql = "INSERT INTO dc_su_category2occupancy(dc_category_id, hms_occupancy_id, `state`)
                                        VALUES('".$hms_room['index_id']."', '".$oc."', 1)
                                        ON DUPLICATE KEY UPDATE state = state";
                                $this->db->query($sql);
                            }
                        } else {
                            //$min = $room_quantity - $data['room_limit'];
                            $min = 0;
                            $room_data = $hms_room;
                            $this->db->set('dc_room_id', $room)->insert('dc_su_categories_strtoint');
                            $dc_room_id = $this->db->insert_id();

                            $data = [
                                'dc_category_id' => $dc_room_id,
                                'hms_category_id' => $hms_room_id,
                                'min' => $min,
                                'max' => $data['room_limit'],
                            ];
                            $this->db->set($data)->insert('dc_su_room_categories_link');

                            $data = [
                                'dc_hotel_id' => $property_id,
                                'dc_room_id' => $dc_room_id,
                                'active' => 1,
                            ];

                            $this->db->set($data)->insert('dc_su_room_categories');

                            if (isset($room_data)) {
                                for ($oc = 1; $oc <= $room_data['add_places']; ++$oc) {
                                    $sql = "INSERT INTO dc_su_occupancy(id, name, roomcategory)
                                            VALUES('".$oc."', '".$oc."', '".$dc_room_id."')
                                            ON DUPLICATE KEY UPDATE name = '".$oc."', roomcategory = '".$dc_room_id."'";
                                    $this->db->query($sql);

                                    $sql = "INSERT INTO dc_su_category2occupancy(dc_category_id, hms_occupancy_id, `state`)
                                            VALUES('".$dc_room_id."', '".$oc."', 1)
                                            ON DUPLICATE KEY UPDATE state = state";
                                    $this->db->query($sql);
                                }
                            }
                        }
                    }
                }
            } else {
                $log_data[] = [
                    'action' => 'Update room',
                    'object' => $room,
                    'result' => 'fail',
                    'error' => $su_room_result['curl_response']['Errors'][0]['ShortText'],
                ];
            }
            unset($su_room_result);
        }

        if (!empty($to_delete)) {
            $mappings = $this->get_mappings($su_property_id);
        }

        foreach ($to_delete as $room) {
            $has_mappings = false;
            $hms_room_id = explode('-', $room)[2] ?? 0;
            if (!$hms_room_id) {
                continue;
            }
            $data['su_property_id'] = $su_property_id;
            $data['hms_category_id'] = $hms_room_id;
            $data['hms_id'] = $hms_id;

            foreach ($mappings as $connection) {
                foreach ($connection as $conn) {
                    foreach ($conn['RoomIDs'] as $map_room) {
                        if ($map_room == $room) {
                            $has_mappings = true;
                        }
                    }
                }
            }

            if ($has_mappings) {
                $status = 'inactive';
            } else {
                $status = 'delete';
            }

            $su_room_result = $this->dcm_su->change_room_status($su_property_id, $room, $status);

            if (isset($su_room_result['curl_response']['Status']) && $su_room_result['curl_response']['Status'] == 'Success') {
                $log_data[] = [
                    'action' => $status == 'inactive' ? 'Deactivate room' : 'Delete room',
                    'object' => $room,
                    'result' => $status == 'inactive' ? 'fail' : 'success',
                    'error' => $status == 'inactive' ? 'Room has mappings' : '',
                ];
                $link = $this->db->where('hms_category_id', $hms_room_id)->get('dc_su_room_categories_link')->row_array()['hms_category_id'] ?? false;
                if (!$link) {
                    continue;
                }

                $this->db->where('id', $link)->delete('dc_su_categories_strtoint');
                $this->db->where('hms_category_id', $link)->delete('dc_su_room_categories_link');
                $this->db->where('dc_room_id', $link)->delete('dc_su_room_categories');

                $this->db->where('roomcategory', $link)->delete('dc_su_occupancy');
                $this->db->where('dc_category_id', $link)->delete('dc_su_category2occupancy');

                $this->db->where('dc_category_id', $link)->delete('dc_su_rate2category_link');
                $this->db->where('dc_category_id', $link)->delete('dc_su_restricts_link');
            } else {
                $log_data[] = [
                    'action' => $status == 'inactive' ? 'Deactivate room' : 'Delete room',
                    'object' => $room,
                    'result' => $status == 'inactive' ? 'fail' : 'success',
                    'error' => $su_room_result['curl_response']['Errors'][0]['ShortText'],
                ];
            }
            unset($su_room_result);
        }

        $log['result'] = $success;
        $log['details'] = $log_data;

        return $log;
    }

    public function create_room($data)
    {
        $su_property_id = $data['su_property_id'];
        $hms_property_id = explode('-', $su_property_id)[2] ?? 0;
        $hms_category_id = $data['hms_category_id'];
        $hms_id = $data['hms_id'];

        $get_data = [];
        $get_data['category_ids'] = [$hms_category_id];
        $categories_data = $this->frontdesk_c2->get_categories_data($get_data);

        foreach ($categories_data as $category_cell) {
            $hms_category_id = $category_cell['category_id'];
            $dc_room_id = "$hms_id-$hms_property_id-$hms_category_id";

            $category_ameneties = $this->mcategory->get_category_ameneties($hms_category_id);
            $facilities = [];
            foreach ($category_ameneties as $amenity_data) {
                array_push($facilities, [
                    'Group' => $this->mlanguages->getdictionaryword('tbl_roomscategories_equipment', 'eng', $amenity_data['amenety_type_name']),
                    'name' => $this->mlanguages->getdictionaryword('tbl_roomscategories_equipment', 'eng', $amenity_data['amenety_name']),
                ]);
            }

            switch ($category_cell['category_size_type']) {
                case 1:
                    $size_type = 'sqm';
                    break;
                case 2:
                    $size_type = 'sqft';
                    break;
                default:
                    $size_type = 'sqm';
                    break;
            }

            $international_name_array = $this->internationalfields->get_value('category', $hms_category_id, 'international_name');
            $room_name = $international_name_array[45] ?? "Room $hms_category_id";

            $international_summary_array = $this->internationalfields->get_value('category', $hms_category_id, 'international_description');
            $description = $international_summary_array[45] ?? '';

            $quantity = ($data['room_limit'] > $category_cell['category_room_count'])
                ? $category_cell['category_room_count'] 
                : (
                    ($data['room_limit'] < $data['max'])
                        ? $data['max'] 
                        : $data['room_limit']
            );

            $room = [
                'SellableProducts' => [
                    'HotelCode' => $su_property_id,
                    'SellableProduct' => [
                        [
                            'InvStatusType' => 'Initial',
                            'GuestRoom' => [
                                'Occupancy' => [
                                    'MaxOccupancy' => $category_cell['category_add_places'],
                                    'MaxChildOccupancy' => $category_cell['category_baby_places'],
                                ],
                                'Room' => [
                                    'RoomID' => $dc_room_id,
                                    'RoomRate' => $category_cell['category_base_price'],
                                    'Quantity' => $quantity,
                                    'RoomType' => $this->map_room_type($category_cell['category_type_name']),
                                    'SizeMeasurement' => $category_cell['category_size'],
                                    'SizeMeasurementUnit' => $size_type,
                                ],
                                'Facilities' => [
                                    'Facility' => $facilities,
                                ],
                                'Description' => [
                                    'RoomDescription' => $description,
                                    'Text' => $room_name,
                                ],
                            ],
                        ],
                    ],
                ],
            ];

            if ($this->debug) {
                echo '<pre>';
                print_r($room);
            }

            $curl_data = [];
            $curl_data['api_url'] = $this->url.'OTA_HotelRoom';
            $curl_data['post_data'] = $room;
            $curl_response = $this->dcm_su->request_api($curl_data);
            $return_data = ['curl_response' => $curl_response, 'su_property_id' => $su_property_id];

            if ($this->debug) {
                print_r($return_data);
            }

            return $return_data;
        }
    }

    public function update_room($data)
    {
        $su_property_id = $data['su_property_id'];
        $hms_category_id = $data['hms_category_id'];
        $hms_id = $data['hms_id'];

        $get_data = [];
        $get_data['category_ids'] = [$hms_category_id];
        $categories_data = $this->frontdesk_c2->get_categories_data($get_data);
        $hms_property_id = explode('-', $su_property_id)[2] ?? 0;

        foreach ($categories_data as $category_cell) {
            $dc_room_id = "$hms_id-$hms_property_id-$hms_category_id";

            $category_ameneties = $this->mcategory->get_category_ameneties($hms_category_id);
            $facilities = [];
            foreach ($category_ameneties as $amenity_data) {
                array_push($facilities, [
                    'Group' => $this->mlanguages->getdictionaryword('tbl_roomscategories_equipment', 'eng', $amenity_data['amenety_type_name']),
                    'name' => $this->mlanguages->getdictionaryword('tbl_roomscategories_equipment', 'eng', $amenity_data['amenety_name']),
                ]);
            }

            switch ($category_cell['category_size_type']) {
                case 1:
                    $size_type = 'sqm';
                    break;
                case 2:
                    $size_type = 'sqft';
                    break;
                default:
                    $size_type = 'sqm';
                    break;
            }

            $international_name_array = $this->internationalfields->get_value('category', $hms_category_id, 'international_name');

            $room_name = $international_name_array[45] ?? "Room $hms_category_id";

            $international_summary_array = $this->internationalfields->get_value('category', $hms_category_id, 'international_description');
            $description = $international_summary_array[45] ?? '';

            $quantity = ($data['room_limit'] > $category_cell['category_room_count'])
                ? $category_cell['category_room_count'] 
                : (
                    ($data['room_limit'] < $data['max'])
                        ? $data['max'] 
                        : $data['room_limit']
            );

            $room = [
                'SellableProducts' => [
                    'HotelCode' => $su_property_id,
                    'SellableProduct' => [
                        [
                            'InvNotifType' => 'Overlay',
                            'InvStatusType' => 'Modify',
                            'roomid' => "$hms_id-$hms_property_id-$hms_category_id",
                            'GuestRoom' => [
                                'Occupancy' => [
                                    'MaxOccupancy' => $category_cell['category_add_places'],
                                    'MaxChildOccupancy' => $category_cell['category_baby_places'],
                                ],
                                'Room' => [
                                    'RoomID' => $dc_room_id,
                                    'RoomRate' => $category_cell['category_base_price'],
                                    'Quantity' => $quantity,
                                    'RoomType' => $this->map_room_type($category_cell['category_type_name']),
                                    'SizeMeasurement' => $category_cell['category_size'],
                                    'SizeMeasurementUnit' => $size_type,
                                ],
                                'Facilities' => [
                                    'Facility' => $facilities,
                                ],
                                'Description' => [
                                    'RoomDescription' => $description,
                                    'Text' => $room_name,
                                ],
                            ],
                        ],
                    ],
                ],
            ];

            if ($this->debug) {
                echo '<pre>';
                print_r($room);
            }

            $curl_data = [];
            $curl_data['api_url'] = $this->url.'OTA_HotelRoom';
            $curl_data['post_data'] = $room;
            $curl_response = $this->dcm_su->request_api($curl_data);
            $return_data = ['curl_response' => $curl_response, 'su_property_id' => $su_property_id];
            if ($this->debug) {
                print_r($return_data);
            }

            return $return_data;
        }
    }

    public function sync_rates(int $hms_id, int $property_id, bool $is_new = false): array
    {
        $su_property_id = "hms-$hms_id-$property_id";
        $success = false;

        $sql = "SELECT rate.id AS rate_id, active.hms_rate_id AS active_id, str.dc_rate_id AS su_str, 
                    str.id AS index_id, rate.isactive, active.restrictid
                FROM rate
                LEFT JOIN dc_su_api_rates_active AS active ON rate.id=active.hms_rate_id AND property_id = $property_id
                LEFT JOIN dc_su_rates_strtoint AS str ON CONCAT('$hms_id-$property_id-',rate.id) = str.dc_rate_id
        ";
        $hms_rates = $this->db->query($sql)->result_array();

        $remote_hash = [];
        $to_add = [];
        $su_inactive = [];
        $to_update = [];
        $to_delete = [];

        $sql = "SELECT oc.hms_occupancy_id, oc.dc_category_id, add_places, places
        FROM dc_su_category2occupancy AS oc
        LEFT JOIN dc_su_room_categories_link AS link ON oc.dc_category_id=link.dc_category_id
        LEFT JOIN dc_su_room_categories AS cat ON oc.dc_category_id=cat.dc_room_id
        LEFT JOIN categories ON link.hms_category_id = categories.id        
        WHERE dc_hotel_id=$property_id AND cat.`active`=1";

        $rooms = $this->db->query($sql)->result_array();

        if (!$is_new) {
            $su_rates = $this->get_su_rates($su_property_id) ?? [];

            foreach ($su_rates as $rate) {
                array_push($remote_hash, $rate['rateplanid']);
                if ($rate['status'] == 'Inactive') {
                    array_push($su_inactive, $rate['rateplanid']);
                }
            }

            foreach ($hms_rates as $rate) {
                $su_mask = "$hms_id-$property_id-{$rate['rate_id']}";

                if (in_array($su_mask, $remote_hash)) {
                    if ($rate['active_id']) {
                        array_push($to_update, $su_mask);
                    } else {
                        array_push($to_delete, $su_mask);
                    }
                    $kkey = array_search($su_mask, $remote_hash);
                    unset($remote_hash[$kkey]);
                } else {
                    if ($rate['active_id'] && $rate['isactive']) {
                        array_push($to_add, $su_mask);
                    } else { // clean up rubish - rate is not active and no property on su
                        if ($rate['index_id'] != null) {
                            $this->db->where('id', $rate['index_id'])->delete('dc_su_rates_strtoint');

                            $this->db
                                ->where('dc_rate_id', $rate['index_id'])
                                ->where('dc_hotel_id', $property_id)
                                ->delete('dc_su_rates');

                            $this->db->where('dc_rate_id', $rate['index_id'])->delete('dc_su_rate2category_link');
                            $this->db->where('dc_rate_id', 0)->delete('dc_su_rate2category_link');
                            $this->db->where('dc_rate_id', $rate['index_id'])->delete('dc_su_restricts_link');
                        }
                    }
                }
            }
        } else {
            foreach ($hms_rates as $rate) {
                $su_mask = "$hms_id-$property_id-{$rate['rate_id']}";

                if ($rate['active_id'] && $rate['isactive']) {
                    array_push($to_add, $su_mask);
                } else { // clean up rubish - rate is not active and no property on su
                    if ($rate['index_id'] != null) {
                        $this->db->where('id', $rate['index_id'])->delete('dc_su_rates_strtoint');

                        $this->db
                            ->where('dc_rate_id', $rate['index_id'])
                            ->where('dc_hotel_id', $property_id)
                            ->delete('dc_su_rates');

                        $this->db->where('dc_rate_id', $rate['index_id'])->delete('dc_su_rate2category_link');
                        $this->db->where('dc_rate_id', 0)->delete('dc_su_rate2category_link');
                        $this->db->where('dc_rate_id', $rate['index_id'])->delete('dc_su_restricts_link');
                    }
                }
            }
        }

        if (!empty($remote_hash)) {
            foreach ($remote_hash as $to_del) {
                array_push($to_delete, $to_del);
            }
        }

        $log_data = [];

        foreach ($to_add as $rate) {
            $hms_rate_id = explode('-', $rate)[2] ?? false;
            if (!$hms_rate_id) {
                continue;
            }

            $data['su_property_id'] = $su_property_id;
            $data['hms_rate_id'] = $hms_rate_id;
            $data['hms_id'] = $hms_id;

            $su_rate_result = $this->create_rate($data);
            $success = (isset($su_rate_result['curl_response']['Status']) && $su_rate_result['curl_response']['Status'] == 'Success');

            if ($success) {
                $log_data[] = [
                    'action' => 'Add rate',
                    'object' => $rate,
                    'result' => 'success',
                    'error' => '',
                ];
                foreach ($hms_rates as $hms_rate) {
                    if ($hms_rate['rate_id'] == $hms_rate_id) {
                        if ($hms_rate['su_str'] == $rate) {
                            $this->db
                                ->set('active', 1)
                                ->where('dc_rate_id', $hms_rate['index_id'])
                                ->where('dc_hotel_id', $property_id)
                                ->update('dc_su_rates');
                            $used_rooms = [];

                            foreach ($rooms as $room) {
                                $base = $room['places'];

                                if ($room['hms_occupancy_id'] == 1) {
                                    $hms_price_func_id = -1;
                                } elseif ($room['hms_occupancy_id'] <= $base) {
                                    $hms_price_func_id = 0;
                                } elseif ($room['hms_occupancy_id'] == $base + 1) {
                                    $hms_price_func_id = 1;
                                } else {
                                    $hms_price_func_id = $room['hms_occupancy_id'] - $base;
                                }

                                if (!in_array($room['dc_category_id'], $used_rooms)) {
                                    $sql = "INSERT INTO dc_su_restricts_link(dc_rate_id, dc_category_id, restrict_id)
                                    VALUES({$hms_rate['index_id']}, {$room['dc_category_id']}, {$hms_rate['restrictid']})
                                    ON DUPLICATE KEY 
                                    UPDATE dc_rate_id={$hms_rate['index_id']}, dc_category_id= {$room['dc_category_id']}";

                                    $this->db->query($sql);

                                    array_push($used_rooms, $room['dc_category_id']);
                                }

                                $sql = "INSERT INTO dc_su_rate2category_link(dc_rate_id, dc_category_id, 
                                hms_occupancy_id, hms_rate_id, hms_restrict_id, hms_price_func_id ) 
                                VALUES({$hms_rate['index_id']}, {$room['dc_category_id']}, 
                                {$room['hms_occupancy_id']}, $hms_rate_id, {$hms_rate['restrictid']}, $hms_price_func_id) 
                                ON DUPLICATE KEY 
                                UPDATE dc_rate_id = {$hms_rate['index_id']}, dc_category_id = {$room['dc_category_id']}, 
                                hms_occupancy_id = {$room['hms_occupancy_id']}, hms_price_func_id=$hms_price_func_id";

                                $this->db->query($sql);
                            }
                        } else {
                            $this->db->set('dc_rate_id', $rate)->insert('dc_su_rates_strtoint');
                            $dc_rate_id = $this->db->insert_id();

                            $data = [
                                'dc_hotel_id' => $property_id,
                                'dc_rate_id' => $dc_rate_id,
                                'active' => 1,
                            ];
                            $this->db->set($data)->insert('dc_su_rates');

                            $used_rooms = [];

                            foreach ($rooms as $room) {
                                $base = $room['places'];

                                if ($room['hms_occupancy_id'] == 1) {
                                    $hms_price_func_id = -1;
                                } elseif ($room['hms_occupancy_id'] <= $base) {
                                    $hms_price_func_id = 0;
                                } elseif ($room['hms_occupancy_id'] == $base + 1) {
                                    $hms_price_func_id = 1;
                                } else {
                                    $hms_price_func_id = $room['hms_occupancy_id'] - $base;
                                }

                                if (!in_array($room['dc_category_id'], $used_rooms)) {
                                    $sql = "INSERT INTO dc_su_restricts_link(dc_rate_id, dc_category_id, restrict_id)
                                    VALUES($dc_rate_id, {$room['dc_category_id']}, {$hms_rate['restrictid']})
                                    ON DUPLICATE KEY 
                                    UPDATE dc_rate_id=$dc_rate_id, dc_category_id= {$room['dc_category_id']}";

                                    $this->db->query($sql);

                                    array_push($used_rooms, $room['dc_category_id']);
                                }

                                $sql = "INSERT INTO dc_su_rate2category_link(dc_rate_id, dc_category_id, hms_occupancy_id, 
                                hms_rate_id, hms_restrict_id, hms_price_func_id ) 
                                VALUES($dc_rate_id, {$room['dc_category_id']}, {$room['hms_occupancy_id']}, 
                                $hms_rate_id, {$hms_rate['restrictid']}, $hms_price_func_id) 
                                ON DUPLICATE KEY 
                                UPDATE dc_rate_id = $dc_rate_id, dc_category_id = {$room['dc_category_id']}, 
                                hms_occupancy_id = {$room['hms_occupancy_id']}, hms_price_func_id=$hms_price_func_id";

                                $this->db->query($sql);
                            }
                        }
                    }
                }
            } else {
                $log_data[] = [
                    'action' => 'Add rate',
                    'object' => $rate,
                    'result' => 'fail',
                    'error' => $su_rate_result['curl_response']['Errors'][0]['ShortText'],
                ];
            }
            unset($su_rate_result);
        }

        foreach ($to_update as $rate) {
            $hms_rate_id = explode('-', $rate)[2] ?? false;
            if (!$hms_rate_id) {
                continue;
            }
            $data['su_property_id'] = $su_property_id;
            $data['hms_rate_id'] = $hms_rate_id;
            $data['hms_id'] = $hms_id;

            $su_rate_result = $this->update_rate($data);
            $success = (isset($su_rate_result['curl_response']['Status']) && $su_rate_result['curl_response']['Status'] == 'Success');

            if ($success) {
                $log_data[] = [
                    'action' => 'Update rate',
                    'object' => $rate,
                    'result' => 'success',
                    'error' => '',
                ];
                foreach ($hms_rates as $hms_rate) {
                    if ($hms_rate['rate_id'] == $hms_rate_id) {
                        if ($hms_rate['su_str'] == $rate) {
                            $this->db
                                ->set('active', 1)
                                ->where('dc_rate_id', $hms_rate['index_id'])
                                ->where('dc_hotel_id', $property_id)
                                ->update('dc_su_rates');
                            $used_rooms = [];

                            foreach ($rooms as $room) {
                                $base = $room['places'];

                                if ($room['hms_occupancy_id'] == 1) {
                                    $hms_price_func_id = -1;
                                } elseif ($room['hms_occupancy_id'] <= $base) {
                                    $hms_price_func_id = 0;
                                } elseif ($room['hms_occupancy_id'] == $base + 1) {
                                    $hms_price_func_id = 1;
                                } else {
                                    $hms_price_func_id = $room['hms_occupancy_id'] - $base;
                                }

                                if (!in_array($room['dc_category_id'], $used_rooms)) {
                                    $sql = "INSERT INTO dc_su_restricts_link(dc_rate_id, dc_category_id, restrict_id)
                                    VALUES({$hms_rate['index_id']}, {$room['dc_category_id']}, {$hms_rate['restrictid']})
                                    ON DUPLICATE KEY 
                                    UPDATE dc_rate_id={$hms_rate['index_id']}, dc_category_id= {$room['dc_category_id']}";

                                    $this->db->query($sql);

                                    array_push($used_rooms, $room['dc_category_id']);
                                }

                                $sql = "INSERT INTO dc_su_rate2category_link(dc_rate_id, dc_category_id, hms_occupancy_id, 
                                hms_rate_id, hms_restrict_id, hms_price_func_id ) 
                                VALUES({$hms_rate['index_id']}, {$room['dc_category_id']}, {$room['hms_occupancy_id']}, 
                                $hms_rate_id, {$hms_rate['restrictid']}, $hms_price_func_id) 
                                ON DUPLICATE KEY 
                                UPDATE dc_rate_id = {$hms_rate['index_id']}, dc_category_id = {$room['dc_category_id']}, 
                                hms_occupancy_id = {$room['hms_occupancy_id']}, hms_price_func_id=$hms_price_func_id";

                                $this->db->query($sql);
                            }
                        } else {
                            $this->db->set('dc_rate_id', $rate)->insert('dc_su_rates_strtoint');
                            $dc_rate_id = $this->db->insert_id();

                            $data = [
                                'dc_hotel_id' => $property_id,
                                'dc_rate_id' => $dc_rate_id,
                                'active' => 1,
                            ];
                            $this->db->set($data)->insert('dc_su_rates');

                            $used_rooms = [];

                            foreach ($rooms as $room) {
                                $base = $room['places'];

                                if ($room['hms_occupancy_id'] == 1) {
                                    $hms_price_func_id = -1;
                                } elseif ($room['hms_occupancy_id'] <= $base) {
                                    $hms_price_func_id = 0;
                                } elseif ($room['hms_occupancy_id'] == $base + 1) {
                                    $hms_price_func_id = 1;
                                } else {
                                    $hms_price_func_id = $room['hms_occupancy_id'] - $base;
                                }

                                if (!in_array($room['dc_category_id'], $used_rooms)) {
                                    $sql = "INSERT INTO dc_su_restricts_link(dc_rate_id, dc_category_id, restrict_id)
                                    VALUES($dc_rate_id, {$room['dc_category_id']}, {$hms_rate['restrictid']})
                                    ON DUPLICATE KEY 
                                    UPDATE dc_rate_id=$dc_rate_id, dc_category_id= {$room['dc_category_id']}";

                                    $this->db->query($sql);

                                    array_push($used_rooms, $room['dc_category_id']);
                                }

                                $sql = "INSERT INTO dc_su_rate2category_link(dc_rate_id, dc_category_id, 
                                hms_occupancy_id, hms_rate_id, hms_restrict_id, hms_price_func_id ) 
                                VALUES($dc_rate_id, {$room['dc_category_id']}, 
                                {$room['hms_occupancy_id']}, $hms_rate_id, {$hms_rate['restrictid']}, $hms_price_func_id) 
                                ON DUPLICATE KEY 
                                UPDATE dc_rate_id = $dc_rate_id, dc_category_id = {$room['dc_category_id']}, 
                                hms_occupancy_id = {$room['hms_occupancy_id']}, hms_price_func_id=$hms_price_func_id";

                                $this->db->query($sql);
                            }
                        }
                    }
                }
            } else {
                $log_data[] = [
                    'action' => 'Update rate',
                    'object' => $rate,
                    'result' => 'fail',
                    'error' => $su_rate_result['curl_response']['Errors'][0]['ShortText'],
                ];
            }
            unset($su_rate_result);
        }

        if (!empty($to_delete)) {
            $mappings = $this->get_mappings($su_property_id);
        }

        foreach ($to_delete as $rate) {
            $has_mappings = false;
            $hms_rate_id = explode('-', $rate)[2] ?? false;
            if (!$hms_rate_id) {
                continue;
            }

            $data['su_property_id'] = $su_property_id;
            $data['hms_rate_id'] = $hms_rate_id;
            $data['hms_id'] = $hms_id;

            foreach ($mappings as $connection) {
                foreach ($connection as $conn) {
                    foreach ($conn['Rateplans'] as $map_rate) {
                        if ($map_rate['PMSRateID'] == $rate) {
                            $has_mappings = true;
                        }
                    }
                }
            }

            if ($has_mappings) {
                $status = 'inactive';
            } else {
                $status = 'delete';
            }

            $su_rate_result = $this->change_rate_status($su_property_id, $rate, $status);

            $success = (isset($su_rate_result['curl_response']['Status']) && $su_rate_result['curl_response']['Status'] == 'Success');

            if ($success) {
                $log_data[] = [
                    'action' => $status == 'inactive' ? 'Deactivate rate' : 'Delete rate',
                    'object' => $rate,
                    'result' => $status == 'inactive' ? 'fail' : 'success',
                    'error' => $status == 'inactive' ? 'Rate has mappings' : 'success',
                ];
                $dc_rate = $this->db->where('dc_rate_id', $rate)->get('dc_su_rates_strtoint')->row_array()['id'] ?? false;
                if (!$dc_rate) {
                    continue;
                }

                $this->db->where('id', $dc_rate)->delete('dc_su_rates_strtoint');
                $this->db->where('dc_rate_id', $dc_rate)->delete('dc_su_rates');

                $this->db->where('dc_rate_id', $dc_rate)->delete('dc_su_rate2category_link');
                $this->db->where('dc_rate_id', $dc_rate)->delete('dc_su_restricts_link');
            } else {
                $log_data[] = [
                    'action' => $status == 'inactive' ? 'Deactivate rate' : 'Delete rate',
                    'object' => $rate,
                    'result' => $status == 'inactive' ? 'fail' : 'success',
                    'error' => json_encode($su_rate_result['curl_response']),
                ];
            }
            unset($su_rate_result);
        }

        $log['result'] = $success;
        $log['details'] = $log_data;

        return $log;
    }

    public function create_rate($data)
    {
        $su_property_id = $data['su_property_id'];
        $hms_rate_id = $data['hms_rate_id'];
        $hms_id = $data['hms_id'];

        $rates_data = $this->mrates->get_rates_data($hms_rate_id);

        $hms_property_id = explode('-', $su_property_id)[2];

        $international_name_array = $this->internationalfields->get_value('rate', $hms_rate_id, 'international_name');
        $rate_name = $international_name_array[45] ?? "Rate $hms_rate_id";

        $international_summary_array = $this->internationalfields->get_value('rate', $hms_rate_id, 'international_description');
        $description = $international_summary_array[45] ?? '';

        foreach ($rates_data as $rate_cell) {
            $rate = [
                'RatePlans' => [
                    'hotelid' => $su_property_id,
                    'RatePlan' => [
                       [
                            'RatePlanNotifType' => 'New',
                            'rateplanid' => "$hms_id-$hms_property_id-$hms_rate_id",
                            'MealPlanID' => $this->map_meal_plan($rate_cell['meal_policy_id'] ?? 1)['su_id'],
                            'Description' => [
                                'Name' => $rate_name,
                                'Text' => $description,
                            ],
                        ],
                    ],
                ],
            ];

            if ($this->debug) {
                print_r($rate);
            }

            $curl_data = [];
            $curl_data['api_url'] = $this->url.'OTA_HotelRatePlan';
            $curl_data['post_data'] = $rate;
            $curl_response = $this->dcm_su->request_api($curl_data);
            $return_data = ['curl_response' => $curl_response, 'su_property_id' => $su_property_id];

            if ($this->debug) {
                print_r($curl_response);
            }

            return $return_data;
        }
    }

    public function update_rate($data)
    {
        $su_property_id = $data['su_property_id'];
        $hms_rate_id = $data['hms_rate_id'];
        $hms_property_id = explode('-', $su_property_id)[2];

        $su_rate_id = "{$data['hms_id']}-$hms_property_id-$hms_rate_id";

        $rates_data = $this->mrates->get_rates_data($hms_rate_id);

        $international_name_array = $this->internationalfields->get_value('rate', $hms_rate_id, 'international_name');
        $rate_name = $international_name_array[45] ?? "Rate $hms_rate_id";

        $international_summary_array = $this->internationalfields->get_value('rate', $hms_rate_id, 'international_description');
        $description = $international_summary_array[45] ?? '';

        foreach ($rates_data as $rate_cell) {
            $rate = [
                'RatePlans' => [
                    'hotelid' => $su_property_id,
                    'RatePlan' => [
                        [
                            'RatePlanNotifType' => 'Overlay',
                            'rateplanid' => $su_rate_id,
                            'MealPlanID' => $this->map_meal_plan($rate_cell['meal_policy_id'] ?? 1)['su_id'],
                            'Description' => [
                                'Name' => $rate_name,
                                'Text' => $description,
                            ],
                        ],
                    ],
                ],
            ];
        }

        if ($this->debug) {
            print_r($rate);
        }

        $curl_data = [];
        $curl_data['api_url'] = $this->url.'OTA_HotelRatePlan';
        $curl_data['post_data'] = $rate;
        $curl_response = $this->dcm_su->request_api($curl_data);
        $return_data = [
            'curl_response' => $curl_response,
            'su_property_id' => $su_property_id,
        ];

        if ($this->debug) {
            print_r($curl_response);
        }

        return $return_data;
    }

    public function map_meal_plan(int $meal_id, bool $reverse = false): ?array
    {
        $meals = [
            1 => [
                'su_id' => 15,
                'name' => '{-(None)-}',
            ],
            2 => [
                'su_id' => 1,
                'name' => '{-All inclusive-}',
            ],
            3 => [
                'su_id' => 2,
                'name' => '{-Breakfast-}',
            ],
            4 => [
                'su_id' => 3,
                'name' => '{-Lunch-}',
            ],
            5 => [
                'su_id' => 4,
                'name' => '{-Dinner-}',
            ],
            6 => [
                'su_id' => 13,
                'name' => '{-Full board-}',
            ],
            7 => [
                'su_id' => 22,
                'name' => '{-Full breakfast-}',
            ],
            8 => [
                'su_id' => 14,
                'name' => '{-Half board-}',
            ],
            9 => [
                'su_id' => 18,
                'name' => '{-Dinner bed and breakfast-}',
            ],
            10 => [
                'su_id' => 19,
                'name' => '{-Family American-}',
            ],
            11 => [
                'su_id' => 21,
                'name' => '{-Breakfast & lunch-}',
            ],
        ];

        if ($reverse) {
            foreach ($meals as $k => $v) {
                if ($v['su_id'] == $meal_id) {
                    return $meals[$k];
                }
            }

            return null;
        }

        return $meals[$meal_id] ?? null;
    }

    public function map_room_type(string $type, bool $reverse = false): ?int
    {
        $type = preg_replace('~\s~', '', $type);
        $type = preg_replace('~,~', '', $type);

        $types = [
            'Apartment' => 1,
            'Apartment2Bedrooms' => 1,
            'Quadruple' => 4,
            'JuniorSuite' => 5,
            'Suite' => 5,
            'Suite1Bedroom' => 5,
            'Suite2Bedroom' => 5,
            'Triple' => 7,
            'Twin' => 8,
            'SuperiorTwinRoom' => 8,
            'DeluxeTwinRoom' => 8,
            'Double' => 9,
            'SuperiorDoubleRoom' => 9,
            'DeluxeDoubleRoom' => 9,
            'Single' => 10,
            'Studio' => 12,
            'Family' => 13,
            'Dormitory room' => 25,
            'BedinDormitory' => 26,
            'Bungalow' => 27,
            'Chalet' => 28,
            'Holidayhome' => 29,
            'Villa' => 31,
            'Mobilehome' => 32,
            'Tent' => 33,
            'Duplex' => 12,
            'ExecutiveRoom' => 35,
            'ExecutiveSuite' => 36,
        ];

        if ($reverse) {
            $name = array_search($type, $types);

            return $name ? $name : null;
        }

        return $types[$type] ?? null;
    }

    public function change_rate_status(string $hotel_id, string $rate_id, string $status): array
    {
        switch ($status) {
            case 'active':
                $status_type = 'Activate';
                break;
            case 'delete':
                $status_type = 'Delete';
                break;
            case 'inactive':
            default:
                $status_type = 'Remove';
                break;
        }

        $rate = [
            'RatePlans' => [
                'hotelid' => $hotel_id,
                'RatePlan' => [
                    [
                        'RatePlanNotifType' => $status_type,
                        'rateplanid' => $rate_id,
                        'MealPlanID' => '1',
                        'Description' => [
                            'Name' => '',
                            'Text' => '',
                        ],
                    ],
                ],
            ],
        ];

        $curl_data = [];
        $curl_data['api_url'] = $this->url.'OTA_HotelRatePlan';
        $curl_data['post_data'] = $rate;
        $response_data['curl_response'] = $this->dcm_su->request_api($curl_data);

        return $response_data;
    }

    public function clean_rooms_and_rates($hms_id, $property_id): void
    {
        $rooms = $this->db->like('dc_room_id', "$hms_id-$property_id")->get('dc_su_categories_strtoint')->result_array();
        $rates = $this->db->like('dc_rate_id', "$hms_id-$property_id")->get('dc_su_rates_strtoint')->result_array();

        $this->db->like('dc_room_id', "$hms_id-$property_id")->delete('dc_su_categories_strtoint');
        $this->db->like('dc_rate_id', "$hms_id-$property_id")->delete('dc_su_rates_strtoint');
        $this->db->where('dc_hotel_id', $property_id)->delete('dc_su_room_categories');
        $this->db->where('dc_hotel_id', $property_id)->delete('dc_su_rates');

        foreach ($rooms as $room) {
            $this->db->where('dc_category_id', $room['id'])->delete('dc_su_room_categories_link');
            $this->db->where('roomcategory', $room['id'])->delete('dc_su_occupancy');
            $this->db->where('dc_category_id', $room['id'])->delete('dc_su_category2occupancy');
        }

        foreach ($rates as $rate) {
            $this->db->where('dc_rate_id', $rate['id'])->delete('dc_su_rate2category_link');
            $this->db->where('dc_rate_id', $rate['id'])->delete('dc_su_restricts_link');
        }
    }

    public function save_sync_log($data)
    {
        $this->db->insert('dc_su_api_log', $data);
    }

    public function get_su_channels(): array
    {
        $table = 'global_hotelix.dc_su_channels';

        $connections = $this->get_connectors();
        $dev_channels = [];
        $active_channels = [];
        $pending_channels = [];

        foreach ($connections as $conn) {
            $main_channel = [];
            if ($conn['quantity'] == 1) {
                $main_channel = $this->db->where('channel_name', $conn['channel_name'])->get($table)->row_array();

                if ($main_channel['status'] != 'Active') {
                    $status = 'Development';
                    $dev_channels[$main_channel['id']] = [
                        'ch_id' => $main_channel['id'],
                        'channel_name' => $main_channel['channel_name'],
                        'sq' => 0,
                        'channel_code' => $main_channel['channel_code'],
                        'status' => $status,
                        'channel_url' => $main_channel['channel_url'],
                        'encrypted_channel_code' => $main_channel['encrypted_channel_code']
                    ];
                } else {
                    if ($main_channel['is_ota_switch'] == 'Yes') {
                        if (!$main_channel['channel_code']) {
                            continue;
                        }
                        $status = 'Online';
                        $active_channels[$main_channel['id']] = [
                            'ch_id' => $main_channel['id'],
                            'channel_name' => $main_channel['channel_name'],
                            'sq' => 0,
                            'channel_code' => $main_channel['channel_code'],
                            'channel_url' => $main_channel['channel_url'],
                            'encrypted_channel_code' => $main_channel['encrypted_channel_code'],
                            'status' => $status,
                        ];
                    } elseif ($main_channel['is_ota_switch'] == 'Pending') {
                        $status = 'Pending';
                        $pending_channels[$main_channel['id']] = [
                            'ch_id' => $main_channel['id'],
                            'channel_name' => $main_channel['channel_name'],
                            'sq' => 0,
                            'channel_code' => $main_channel['channel_code'],
                            'encrypted_channel_code' => $main_channel['encrypted_channel_code'],
                            'status' => $status,
                            'channel_url' => $main_channel['channel_url'],
                        ];
                    }
                }
            } else {
                $main_channel = $this->db->where('channel_name', $conn['connector'])->get($table)->row_array();

                if (!isset($main_channel['id'])) {
                    continue;
                } else {
                    $search_sql = "SELECT id FROM $table WHERE `display` = 1
                    AND ( connector = '{$conn['connector']}' OR connect_2 = '{$conn['connector']}' 
                    OR  connect_3 = '{$conn['connector']}' OR connect_4 = '{$conn['connector']}' OR connect_5 = '{$conn['connector']}')";
                    if (!null == $this->session->userdata('su_search_country') && $this->session->userdata('su_search_country') != 'All') {
                        $country = $this->session->userdata('su_search_country');
                        $search_sql .= " AND country = '$country'";
                    }
                    if (!null == $this->session->userdata('su_search_region') && $this->session->userdata('su_search_region') != 'ALL') {
                        $region = $this->session->userdata('su_search_region');
                        $search_sql .= " AND region = '$region'";
                    }
                    if (!null == $this->session->userdata('su_search_property_type') && $this->session->userdata('su_search_property_type') != 'ALL') {
                        $property_type = $this->session->userdata('su_search_property_type');
                        $search_sql .= " AND property_type = '$property_type'";
                    }

                    if (!null == $this->session->userdata('su_search_ota_name') && $this->session->userdata('su_search_ota_name') != '') {
                        $search_ota_name = $this->session->userdata('su_search_ota_name');
                        $search_sql .= " AND channel_name LIKE '%$search_ota_name%'";
                    }
                    if ($main_channel['status'] != 'Active') {
                        $status = 'Development';
                        $subchannels = $this->db->query($search_sql)->num_rows();
                        $dev_channels[$main_channel['id']] = [
                            'ch_id' => $main_channel['id'],
                            'channel_name' => $main_channel['channel_name'],
                            'channel_code' => $main_channel['channel_code'],
                            'sq' => $subchannels,
                            'status' => $status,
                            'channel_url' => $main_channel['channel_url'],
                            'encrypted_channel_code' => $main_channel['encrypted_channel_code']
                        ];
                    } else {
                        if ($main_channel['is_ota_switch'] == 'Yes') {
                            if (!$main_channel['channel_code']) {
                                continue;
                            }
                            $status = 'Online';
                            $subchannels = $this->db->query($search_sql)->num_rows();
                            $active_channels[$main_channel['id']] = [
                                'ch_id' => $main_channel['id'],
                                'channel_name' => $main_channel['channel_name'],
                                'channel_code' => $main_channel['channel_code'],
                                'channel_url' => $main_channel['channel_url'],
                                'sq' => $subchannels,
                                'status' => $status,
                                'encrypted_channel_code' => $main_channel['encrypted_channel_code']
                            ];
                        } elseif ($main_channel['is_ota_switch'] == 'Pending') {
                            $status = 'Pending';
                            $subchannels = $this->db->query($search_sql)->num_rows();
                            $pending_channels[$main_channel['id']] = [
                                'ch_id' => $main_channel['id'],
                                'channel_name' => $main_channel['channel_name'],
                                'sq' => $subchannels,
                                'channel_code' => $main_channel['channel_code'],
                                'status' => $status,
                                'channel_url' => $main_channel['channel_url'],
                                'encrypted_channel_code' => $main_channel['encrypted_channel_code']
                            ];
                        }
                    }
                }
            }
        }

        /*
            $sql = "SELECT * FROM global_hotelix.dc_su_channels WHERE display = 1";
            $query = $this->db->query( $sql );
            foreach($query->result() as $row) {
                $su_channels[$row->channel_code]['channel_code'] = $row->channel_code;
                $su_channels[$row->channel_code]['channel_name'] = $row->channel_name;
                $su_channels[$row->channel_code]['encrypted_channel_code'] = $row->encrypted_channel_code;
            }
        */
        return $active_channels + $pending_channels + $dev_channels;
    }

    /**
     * @param bool $debug
     *
     * @uses DB Class
     */
    private function get_connectors($debug = false): array
    {
        $table = 'global_hotelix.dc_su_channels';

        $sql = "SELECT COUNT(id) as quantity, `channel_code`, encrypted_channel_code, `channel_name`, `is_ota_switch`, `status`
            FROM $table WHERE connector = 'Direct' 
            AND `display` = 1";
        if (!null == $this->session->userdata('su_search_country') && $this->session->userdata('su_search_country') != 'All') {
            $country = $this->session->userdata('su_search_country');
            $sql .= " AND country = '$country'";
        }

        if (!null == $this->session->userdata('su_search_region') && $this->session->userdata('su_search_region') != 'ALL') {
            $region = $this->session->userdata('su_search_region');
            $sql .= " AND region = '$region'";
        }

        if (!null == $this->session->userdata('su_search_property_type') && $this->session->userdata('su_search_property_type') != 'ALL') {
            $property_type = $this->session->userdata('su_search_property_type');
            $sql .= " AND property_type = '$property_type'";
        }

        if (!null == $this->session->userdata('su_search_ota_name') && $this->session->userdata('su_search_ota_name') != '') {
            $search_ota_name = $this->session->userdata('su_search_ota_name');
            $sql .= " AND channel_name LIKE '%$search_ota_name%'";
        }

        $sql .= ' GROUP BY channel_name ORDER BY priority DESC, channel_name ASC';

        $direct = $this->db->query($sql)->result_array();

        $sql = 'SELECT COUNT(id) as quantity'
            .', `channel_code`, `connector`, `channel_name`, `is_ota_switch`, `status`'
            ." FROM $table WHERE connector <> 'Direct'"
            .' AND `display` = 1';

        if (!null == $this->session->userdata('su_search_country') && $this->session->userdata('su_search_country') != 'All') {
            $country = $this->session->userdata('su_search_country');
            $sql .= " AND country = '$country'";
        }

        if (!null == $this->session->userdata('su_search_region') && $this->session->userdata('su_search_region') != 'ALL') {
            $region = $this->session->userdata('su_search_region');
            $sql .= " AND region = '$region'";
        }

        if (!null == $this->session->userdata('su_search_property_type') && $this->session->userdata('su_search_property_type') != 'ALL') {
            $property_type = $this->session->userdata('su_search_property_type');
            $sql .= " AND property_type = '$property_type'";
        }

        if (!null == $this->session->userdata('su_search_ota_name') && $this->session->userdata('su_search_ota_name') != '') {
            $search_ota_name = $this->session->userdata('su_search_ota_name');
            $sql .= " AND channel_name LIKE '%$search_ota_name%'";
        }

        $sql .= ' GROUP BY connector ORDER BY priority DESC, channel_name ASC';

        $aggregators = $this->db->query($sql)->result_array();

        $connections = array_merge($direct, $aggregators);

        if ($debug) {
            echo '<pre>';
            print_r($connections);
            exit();
        }

        return $connections;
    }

    /**
     * @author Vit
     *
     * @param int $id
     *
     * @uses DB Class
     *
     * @return array
     *
     * Selects all data for connector and an array of subchannels' data
     */
    public function get_connector_data($id): array
    {
        $table = 'global_hotelix.dc_su_channels';

        $connector = $this->db->select('*, id as ch_id')->where('id', $id)->get($table)->row_array();

        $channel_name = addslashes($connector['channel_name']);

        $sql = "SELECT * FROM global_hotelix.dc_su_channels 
        WHERE (
            `connector` = '$channel_name'
            OR connect_2 = '$channel_name'
            OR connect_3 = '$channel_name'
            OR connect_4 = '$channel_name'
            OR connect_5 = '$channel_name'
        ) AND display = 1
        AND channel_url != ''";

        if (!null == $this->session->userdata('su_search_country') && $this->session->userdata('su_search_country') != 'All') {
            $country = $this->session->userdata('su_search_country');
            $sql .= " AND country = '$country'";
        }

        if (!null == $this->session->userdata('su_search_region') && $this->session->userdata('su_search_region') != 'ALL') {
            $region = $this->session->userdata('su_search_region');
            $sql .= " AND region = '$region'";
        }

        if (!null == $this->session->userdata('su_search_property_type') && $this->session->userdata('su_search_property_type') != 'ALL') {
            $property_type = $this->session->userdata('su_search_property_type');
            $sql .= " AND property_type = '$property_type'";
        }

        $connector['subchannels'] = $this->db->query($sql)->result_array();

        return $connector;
    }

    public function get_su_channels2()
    {
        $su_channels = [];
        $sql = 'SELECT * FROM global_hotelix.dc_su_channels WHERE display = 1';
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $su_channels[$row->channel_code]['channel_code'] = $row->channel_code;
            $su_channels[$row->channel_code]['channel_name'] = $row->channel_name;
            $su_channels[$row->channel_code]['encrypted_channel_code'] = $row->encrypted_channel_code;
        }

        return $su_channels;
    }

    public function get_su_dc_data($su_dc_id, $name, $valuename = 'str', $hms_property_id = '')
    {
        $result = null;
        $query = $this->db->query("SELECT * FROM `dc_su_data` WHERE su_dc_id = $su_dc_id AND name = '$name' AND hms_property_id LIKE $hms_property_id");
        if ($valuename == 'int') {
            $result = 0;
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $result = $row->int_value;
            }
        } elseif ($valuename == 'str') {
            $result = '';
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $result = $row->str_value;
            }
        }

        return $result;
    }

    public function get_mappings($hotel_id)
    {
        $url = $this->url.'mappings';

        $data = [
            'hotelid' => $hotel_id,
            //'channelid' => $channel
        ];

        $headers = [
            'Authorization: Basic '.$this->auth,
            'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
            'Content-Type: application/json',
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_USERAGENT, 'Otelms');

        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);

        curl_close($ch);

        $result = json_decode($buffer, true);

        return $result;
    }

    public function mapping($hotel_id)
    {
        $url = 'https://connect.su-api.com/SUAPI/jservice/widget/getWidgetAccessToken';

        $data = [
            'hotelid' => $hotel_id,
        ];

        $headers = [
            'Authorization: Basic '.$this->auth,
            'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
            'Content-Type: application/json',
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_USERAGENT, 'Otelms');

        $buffer = curl_exec($ch);
        //$information = curl_getinfo($ch);

        curl_close($ch);

        $result = json_decode($buffer, true);

        return $result;
    }

    public function get_distinct_countries()
    {
        $table = 'global_hotelix.dc_su_channels';

        $sql = "SELECT DISTINCT country FROM $table WHERE display = 1 ORDER BY country";

        return $this->db->query($sql)->result_array();
    }

    public function get_distinct_regions()
    {
        $table = 'global_hotelix.dc_su_channels';

        $sql = "SELECT DISTINCT region FROM $table WHERE display = 1 ORDER BY country";

        return $this->db->query($sql)->result_array();
    }

    public function get_distinct_property_types()
    {
        $table = 'global_hotelix.dc_su_channels';

        $sql = "SELECT DISTINCT property_type FROM $table WHERE display = 1";

        return $this->db->query($sql)->result_array();
    }

    public function get_services()
    {
        return $this->db->select('id, name')
            ->where('is_active', 1)->where('online_booking', 1)
            ->get('services_types')->result_array();
    }

    public function migrate(): bool
    {
        $is_migrated = $this->db->where('name', 'su_migrated')->get('hotelix_config')->row_array();
        if ($is_migrated != null && $is_migrated['value'] == 1) {
            return true;
         }

        $tables = [
            'dc_su_xml_cfg' => [
                'fields' => [
                    'dc_account_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'name' => [
                        'type' => 'VARCHAR',
                        'constraint' => 100
                    ],
                    'str_value' => [
                        'type' => 'VARCHAR',
                        'constraint' => 100
                    ],
                    'int_value' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ]
                ],
                'unique' => 'dc_account_id (`dc_account_id`, `name`) USING HASH',
                'engine' => 'InnoDB'
            ],
            'dc_su_addons' => [
                'fields' => [
                    'id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                        'auto_increment' => TRUE
                    ],
                    'dc_uuid' => [
                        'type' => 'VARCHAR',
                        'constraint' => 150
                    ],
                    'name' => [
                        'type' => 'VARCHAR',
                        'constraint' => 150
                    ],
                    'nights' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'persons' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'price_mode' => [
                        'type' => 'INT',
                        'constraint' => 11,
                    ],
                    'price_per_unit' => [
                        'type' => 'DECIMAL',
                        'constraint' => '10,2'
                    ],
                    'totalprice' => [
                        'type' => 'DECIMAL',
                        'constraint' => '10,2'
                    ],
                    'type' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'addons_date' => [
                        'type' => 'DATE'
                    ]
                ],
                'primary_key' => ['id'],
                'engine' => 'InnoDB',
                'unique' => '`dc_uuid` (`dc_uuid`,`addons_date`, `type`) USING HASH'
            ],
            'dc_su_api_categories_active' => [
                'fields' => [
                    'id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                        'auto_increment' => TRUE
                    ],
                    'hms_category_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'room_limit' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ]
                ],
                'primary_key' => ['id'],
                'engine' => 'InnoDB',
            ],
            'dc_su_api_contacts_active' => [
                'fields' => [
                    'id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                        'auto_increment' => TRUE
                    ],
                    'hms_contact_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'is_active' => [
                        'type' => 'TINYINT',
                        'constraint' => 1
                    ],
                ],
                'primary_key' => ['id'],
                'engine' => 'InnoDB',
            ],
            'dc_su_api_log' => [
                'fields' => [
                    'id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                        'auto_increment' => TRUE
                    ],
                    'user_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'date' => [
                        'type' => 'DATETIME'
                    ],
                    'status' => [
                        'type' => 'VARCHAR',
                        'constraint' => 10
                    ],
                    'details' => [
                        'type' => 'TEXT'
                    ]
                ],
                'primary_key' => ['id'],
                'engine' => 'MyISAM',
            ],
            'dc_su_api_properties_active' => [
                'fields' => [
                    'id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                        'auto_increment' => TRUE
                    ],
                    'hms_property_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                ],
                'primary_key' => ['id'],
                'engine' => 'InnoDB',
            ],
            'dc_su_api_rates_active' => [
                'fields' => [
                    'id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                        'auto_increment' => TRUE
                    ],
                    'hms_rate_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'restrictid' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'property_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                ],
                'primary_key' => ['id'],
                'engine' => 'InnoDB',
                'unique' => '`hms_rate_id` (`hms_rate_id`, `property_id`) USING HASH'
            ],
            'dc_su_categories_strtoint' => [
                'fields' => [
                    'id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                        'auto_increment' => TRUE
                    ],
                    'dc_room_id' => [
                        'type' => 'VARCHAR',
                        'constraint' => 50
                    ]
                ],
                'primary_key' => ['id'],
                'engine' => 'InnoDB',
                'unique' => '`dc_room_id` (`dc_room_id`)'
            ],
            'dc_su_category2occupancy' => [
                'fields' => [
                    'dc_category_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'occupancy_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'hms_occupancy_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'state' => [
                        'type' => 'TINYINT',
                        'constraint' => 1
                    ],
                ],
                'engine' => 'InnoDB',
                'unique' => '`dc_category_id` (`dc_category_id`,`hms_occupancy_id`) USING HASH'
            ],
            'dc_su_data' => [
                'fields' => [
                    'su_dc_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'hms_property_id' => [
                        'type' => 'VARCHAR',
                        'constraint' => 50
                    ],
                    'name' => [
                        'type' => 'VARCHAR',
                        'constraint' => 100
                    ],
                    'str_value' => [
                        'type' => 'VARCHAR',
                        'constraint' => 100
                    ],
                    'int_value' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ]
                ],
                'engine' => 'InnoDB',
                'unique' => '`su_dc_id` (`su_dc_id`, `name`, `hms_property_id`) USING HASH'
            ],
            'dc_su_log' => [
                'fields' => [
                    'id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                        'auto_increment' => TRUE,
                    ],
                    'time' => [
                        'type' => 'TIMESTAMP',
                    ],
                    'url' => [
                        'type' => 'VARCHAR',
                        'constraint' => 255
                    ],
                   'request' => [
                        'type' => 'TEXT'
                    ],
                    'response' => [
                        'type' => 'TEXT'
                    ],
                    'responseint' => [
                        'type' => 'TEXT'
                    ],
                    'stime' => [
                        'type' => 'DECIMAL',
                        'constraint' => '10,3'
                    ]
                ],
                'primary_key' => ['id'],
                'unique' => 'id (`id`)',
                'engine' => 'MyISAM',
            ],
            'dc_su_occupancy' => [
                'fields' => [
                    'id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                    ],
                    'name' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'roomcategory' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                ],
                'engine' => 'InnoDB',
                'unique' => '`name` (`name`, `roomcategory`) USING HASH'
            ],
            'dc_su_properties_link' => [
                'fields' => [
                    'su_property_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'hms_property_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                ],
                'engine' => 'InnoDB'
            ],
            'dc_su_rate2category_link' => [
                'fields' => [
                    'dc_rate_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'dc_category_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'hms_occupancy_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'hms_rate_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'hms_restrict_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'hms_price_func_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                ],
                'engine' => 'InnoDB',
                'unique' => '`dc_rate_id` (`dc_rate_id`, `dc_category_id`, `hms_occupancy_id`) USING HASH'
            ],
            'dc_su_rates' => [
                'fields' => [
                    'id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                        'auto_increment' => TRUE
                    ],
                    'dc_hotel_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'dc_rate_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'dc_rate_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'name' => [
                        'type' => 'VARCHAR',
                        'constraint' => 150
                    ],
                    'active' => [
                        'type' => 'TINYINT',
                        'constraint' => 1
                    ],
                ],
                'primary_key' => ['id'],
                'engine' => 'InnoDB',
                'unique' => '`dc_rate_id` (`dc_rate_id`, `dc_hotel_id`) USING HASH'
            ],
            'dc_su_rates_strtoint' => [
                'fields' => [
                    'id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                        'auto_increment' => TRUE
                    ],
                    'dc_rate_id' => [
                        'type' => 'VARCHAR',
                        'constraint' => 50
                    ]
                ],
                'primary_key' => ['id'],
                'engine' => 'InnoDB',
                'unique' => '`dc_rate_id` (`dc_rate_id`)'
            ],
            'dc_su_rate_intdate' => [
                'fields' => [
                    'dc_reservation_id' => [
                        'type' => 'VARCHAR',
                        'constraint' => 150,
                    ],
                    'dc_rate_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'intdate' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'price' => [
                        'type' => 'DECIMAL',
                        'constraint' => '10,2'
                    ],
                ],
                'engine' => 'InnoDB',
                'unique' => '`dc_rate_id` (`dc_reservation_id`,`dc_rate_id`,`intdate`) USING HASH'
            ],
            'dc_su_restricts_link' => [
                'fields' => [
                    'dc_rate_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'dc_category_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'restrict_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                ],
                'engine' => 'InnoDB',
                'unique' => '`dc_rate_id` (`dc_rate_id`, `dc_category_id`) USING HASH'
            ],
            'dc_su_room_categories' => [
                'fields' => [
                    'dc_hotel_id' => [
                        'type' => 'INT',
                        'constraint' => 11,
                    ],
                    'dc_room_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'name' => [
                        'type' => 'VARCHAR',
                        'constraint' => 150
                    ],
                    'active' => [
                        'type' => 'TINYINT',
                        'constraint' => 1
                    ],
                ],
                'engine' => 'InnoDB',
                'unique' => '`dc_uuid` (`dc_room_id`, `dc_hotel_id`) USING HASH'
            ],
            'dc_su_room_categories_link' => [
                'fields' => [
                    'dc_category_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'hms_category_id' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'min' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ],
                    'max' => [
                        'type' => 'INT',
                        'constraint' => 11
                    ]
                ],
                'engine' => 'InnoDB',
                'unique' => '`dc_category_id` (`dc_category_id`)'
            ],
        ];

        $this->load->dbforge();

        foreach ($tables as $table_name => $table_data) {
            if ($this->db->table_exists($table_name)) {
                $this->dbforge->drop_table($table_name, TRUE);
            }
            $this->dbforge->add_field($table_data['fields']);
        
            if (isset($table_data['primary_key'])) {
                $this->dbforge->add_key($table_data['primary_key'], TRUE);
            }
        
            $this->dbforge->create_table($table_name, TRUE);
            if (isset($table_data['engine'])) {
                $this->db->query("ALTER TABLE `$table_name` ENGINE={$table_data['engine']} DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci");
            }
            if (isset($table_data['unique'])) {
                $this->db->query("ALTER TABLE `$table_name` ADD UNIQUE KEY {$table_data['unique']}");
            }
        }
        
        $this->db->insert('hotelix_config', [
            'name' => 'su_migrated',
            'value' => 1,
        ]);
        return true;
    }
}
