<?php

class dcm_su extends dcm_abstract
{
    public function __construct()
    {
        parent::__construct();
        $this->test_mode = false;
        $this->url = $this->config->item('su_prod_url');
        $this->auth = $this->config->item('su_prod_auth');
        $this->load->model('Curl_model');
        $this->load->model('hotelix_config');

        $this->debug = $this->session->userdata('global_debug');

        $this->dc_id = 40;

        $this->table_name_r2c = 'dc_su_rate2category_link';
        $this->table_name_dc_category2occupancy = 'dc_su_category2occupancy';
        $this->table_name_dc2hms_category_link = 'dc_su_room_categories_link';

        $this->sql_dc_r2rlink = 'select dc_rate_id, restrict_id as hms_restrict_id from dc_su_rates';
        $this->sql_dc_rates = "select  CONCAT(dc_su_rates.dc_hotel_id, '_', dc_rate_id) as dc_hotel_rate_id, dc_su_rates.dc_hotel_id, dc_rate_id as dc_rate_id, name as dc_rate_name, active from dc_su_rates";
        $this->sql_dc_category_link = 'select dc_su_room_categories.dc_hotel_id, dc_su_room_categories.name as dc_category_name, categories.name as hms_category_name,
            dc_su_room_categories_link.dc_category_id as dc_category_id, dc_su_categories_strtoint.dc_room_id as dc_category_id_str,
            hms_category_id as hms_category_id
            from dc_su_room_categories_link
            inner join dc_su_room_categories on
            dc_su_room_categories_link.dc_category_id = dc_su_room_categories.dc_room_id
		    inner join dc_su_categories_strtoint on
            dc_su_room_categories_link.dc_category_id = dc_su_categories_strtoint.id
        	LEFT join categories on
            categories.id = dc_su_room_categories_link.hms_category_id';
        $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id,
        	CONCAT(dc_su_room_categories.dc_hotel_id, '_', dc_rate_id) as dc_hotel_rate_id
            from dc_su_rate2category_link
        	inner join dc_su_room_categories on
            dc_su_rate2category_link.dc_category_id = dc_su_room_categories.dc_room_id";

        $this->sql_get_occupancies = 'select id as hms_occupancy_id,
           name as hms_occupancy_name, roomcategory from dc_su_occupancy ORDER BY id ASC';
        $this->sql_build_hms_categories = 'select id as hms_category_id,
            name as hms_category_name from categories';

        $this->sql_dc_category_list = "select dc_su_xml_cfg.int_value as dc_hotel_id, dc_su_room_categories.name as dc_category_name,
            dc_room_id as dc_category_id, active from dc_su_room_categories
        	left join dc_su_xml_cfg on
            dc_su_room_categories.dc_hotel_id = dc_su_xml_cfg.int_value and dc_su_xml_cfg.name='hotel_id'";
        $this->sql_dc_category2occupancy_list = 'select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_su_category2occupancy';

        $this->form_action_c2o_post_c2 = '/dc_su/categories_edit_post';
        $this->form_action_r2c_post_c2 = '/dc_su/rates_edit_post';
    }

    public function options_save($data)
    {
        $data_1 = $this->Loger_admin->get_values_col('dc_su_xml_cfg');

        $sql = "INSERT INTO dc_su_xml_cfg (name, int_value) VALUES('dealer_id', '".$data['dealer']."') ON DUPLICATE KEY UPDATE int_value = ".$data['dealer'];
        $query = $this->db->query($sql);
        $sql = "INSERT INTO dc_su_xml_cfg (name, int_value) VALUES('overbooking_category_id', '".$data['overbooking_category']."') ON DUPLICATE KEY UPDATE int_value = ".$data['overbooking_category'];
        $query = $this->db->query($sql);
        $sql = "INSERT INTO dc_su_xml_cfg (name, int_value) VALUES('general_update', '".$data['general_update']."') ON DUPLICATE KEY UPDATE int_value = ".$data['general_update'];
        $query = $this->db->query($sql);
        $sql = "INSERT INTO dc_su_xml_cfg (name, int_value) VALUES('service_type_id', '".$data['service_type_id']."') ON DUPLICATE KEY UPDATE int_value = ".$data['service_type_id'];
        $query = $this->db->query($sql);

        $data_2 = $this->Loger_admin->get_values_col('dc_su_xml_cfg');
        $this->Loger_admin->SaveLog_col($data_1, $data_2, 'loger_admin', 'dc_su_xml_cfg', 'edit');
    }

    public function get_restrictions_link()
    {
        $sql = 'select * from dc_su_restricts_link';
        $query = $this->db->query($sql);
        $return_data = [];
        foreach ($query->result() as $row) {
            $return_data[$row->dc_rate_id][$row->dc_category_id][$row->restrict_id] = 1;
        }

        return $return_data;
    }

    public function build_rate2category($occupancy_bool = 0, $roomstorate = 0, $price_func = 0)
    {
        //$occupancy_bool = 0;
        $sql = $this->sql_dc_rates;
        //echo $sql."<br>";
        //die();
        $query = $this->db->query($sql);
        $rate2category = [];
        $hms_rates_list = $this->build_hms_rates();
        $hms_restrictions_list = $this->build_hms_restrictions();
        $restrictions_list = $this->get_restrictions_link();
        $hms_occupancies_list = $this->get_occupancies($occupancy_bool);

        $c2o = $this->get_category2occupancy();

        $r2c_link = $this->get_r2c_link();

        foreach ($query->result() as $rate_row) {
            $sql = $this->sql_dc_category_link;

            //echo $sql."<br>";
            $query2 = $this->db->query($sql);

            $rate2category[$rate_row->dc_hotel_rate_id] = [];
            $rate2category[$rate_row->dc_hotel_rate_id]['dc_rate_name'] = $rate_row->dc_rate_name;
            $rate2category[$rate_row->dc_hotel_rate_id]['dc_rate_id'] = $rate_row->dc_rate_id;
            if (isset($rate_row->dc_hotel_id)) {
                $rate2category[$rate_row->dc_hotel_rate_id]['dc_hotel_id'] = $rate_row->dc_hotel_id;
            } else {
                $rate2category[$rate_row->dc_hotel_rate_id]['dc_hotel_id'] = '';
            }
            if (isset($rate_row->dc_property_name)) {
                $rate2category[$rate_row->dc_hotel_rate_id]['dc_property_name'] = $rate_row->dc_property_name;
            } else {
                $rate2category[$rate_row->dc_hotel_rate_id]['dc_property_name'] = '';
            }

            if (isset($rate_row->active)) {
                $rate2category[$rate_row->dc_hotel_rate_id]['active'] = $rate_row->active;
            } else {
                $rate2category[$rate_row->dc_hotel_rate_id]['active'] = 'active';
            }
            // ================================================================================
            if (isset($rate_row->restrict_name)) {
                $rate2category[$rate_row->dc_hotel_rate_id]['restrict_name'] = $rate_row->restrict_name;
            } else {
                $rate2category[$rate_row->dc_hotel_rate_id]['restrict_name'] = '';
            }
            // ================================================================================
            foreach ($query2->result() as $category_row) {
                if ($category_row->dc_hotel_id == $rate_row->dc_hotel_id) {
                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_name'] = $category_row->dc_category_name;
                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_id'] = $category_row->dc_category_id;
                    if (isset($category_row->hms_category_name)) {
                        $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = $category_row->hms_category_name;
                    } else {
                        $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = '';
                    }
                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_id'] = $category_row->hms_category_id;
                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['dc_rate_id'] = $rate_row->dc_rate_id;
                    //$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['hms_restrictions_list'] = $hms_restrictions_list;
                    if ($occupancy_bool == 1) {
                        if (isset($hms_occupancies_list[$category_row->dc_category_id])) {
                            foreach ($hms_occupancies_list[$category_row->dc_category_id] as $occupancy_cell) {
                                if (isset($c2o[$category_row->dc_category_id][$occupancy_cell['hms_occupancy_id']])) {
                                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_id'] = $rate_row->dc_rate_id;
                                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_name'] = $rate_row->dc_rate_name;
                                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_name'] = $category_row->dc_category_name;
                                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_id'] = $category_row->dc_category_id;
                                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_rates_list'] = $hms_rates_list;
                                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_price_func_list'] = $this->build_price_func($price_func);
                                    //$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_restrictions_list'] = $hms_restrictions_list;

                                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_id'] = $occupancy_cell['hms_occupancy_id'];
                                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_name'] = $occupancy_cell['hms_occupancy_name'];
                                }
                            }
                        }
                    } else {
                        foreach ($hms_occupancies_list as $occupancy_cell) {
                            if (isset($c2o[$category_row->dc_category_id][$occupancy_cell['hms_occupancy_id']])) {
                                $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_id'] = $rate_row->dc_rate_id;
                                $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_rate_name'] = $rate_row->dc_rate_name;
                                $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_name'] = $category_row->dc_category_name;
                                $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['dc_category_id'] = $category_row->dc_category_id;
                                $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_rates_list'] = $hms_rates_list;
                                $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_price_func_list'] = $this->build_price_func($price_func);
                                //$rate2category [$rate_row->dc_hotel_rate_id] ['category_list'] [$category_row->dc_category_id] ['occupancy_list'] [$occupancy_cell ['hms_occupancy_id']] ['hms_restrictions_list'] = $hms_restrictions_list;

                                $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_id'] = $occupancy_cell['hms_occupancy_id'];
                                $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'][$occupancy_cell['hms_occupancy_id']]['hms_occupancy_name'] = $occupancy_cell['hms_occupancy_name'];
                            }
                        }
                    }
                    if (!isset($rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['occupancy_list'])) {
                        unset($rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]);
                    }
                    //$rate2category [$rate_row->dc_hotel_rate_id] ['hms_restrictions_list'] = $hms_restrictions_list;

                    $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['hms_restrictions_list'] = $hms_restrictions_list;

                    if (isset($restrictions_list[$rate_row->dc_rate_id][$category_row->dc_category_id])) {
                        foreach ($restrictions_list[$rate_row->dc_rate_id][$category_row->dc_category_id] as $restrict_id => $val) {
                            $rate2category[$rate_row->dc_hotel_rate_id]['category_list'][$category_row->dc_category_id]['hms_restrictions_list'][$restrict_id]['selected'] = 'selected';
                        }
                    }
                }
            }
        }
        //echo "<pre>";
        //print_r($rate2category);
        //die();
        //
        $sql = $this->sql_dc_r2c;
        $query = $this->db->query($sql);
        //echo $sql."<br>";
        foreach ($query->result() as $row) {
            if (isset($c2o[$row->dc_category_id][$row->hms_occupancy_id])) {
                $rate2category[$row->dc_hotel_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_rates_list'][$row->hms_rate_id]['selected'] = 'selected';
                //$rate2category[$row->dc_hotel_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
                $rate2category[$row->dc_hotel_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][0]['pf_selected'] = '';
                $rate2category[$row->dc_hotel_rate_id]['category_list'][$row->dc_category_id]['occupancy_list'][$row->hms_occupancy_id]['hms_price_func_list'][$row->hms_price_func_id]['pf_selected'] = 'selected';
            }
        }

        // 		if ($this->sql_dc_r2rlink !== "") {
        // 			$sql = $this->sql_dc_r2rlink;
        // 			$query = $this->db->query($sql);
        // 			// echo $sql;
        // 			foreach ($query->result() as $row) {
        // 				$rate2category[$row->dc_rate_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
        // 			}
        // 		}
        // 	    		echo "<pre>";
        // 	    		print_r($rate2category);
        // 	    		die();
        return $rate2category;
    }

    public function getauthparam($dc_account_id = 0)
    {
        $hotel_id = '';
        if ($dc_account_id != 0) {
            $sql = 'SELECT str_value FROM dc_su_xml_cfg WHERE dc_account_id = '.$dc_account_id." AND name LIKE 'hotel_id'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hotel_id = $row->str_value;
            }
        }

        $data = [];
        $data['url'] = $this->url;
        $data['auth'] = $this->auth;
        $data['hotel_id'] = $hotel_id;
        $data['hotel_id_int'] = $dc_account_id;

        return $data;
    }

    public function get_dc_room_id_by_str_value($dc_room_id)
    {
        $query_arr = $this->db->select('id')->get_where('dc_su_categories_strtoint', ['dc_room_id' => $dc_room_id])->row_array();

        return $query_arr['id'];
    }

    public function get_dc_rate_id_by_str_value($dc_rate_id)
    {
        $query_arr = $this->db->select('id')->get_where('dc_su_rates_strtoint', ['dc_rate_id' => $dc_rate_id])->row_array();

        return $query_arr['id'];
    }

    public function rate2category_save_su($r2c, $restricts)
    {
        if (sizeof($r2c)) {
        } else {
            return;
        }

        $this->db->query('delete from '.$this->table_name_r2c);

        foreach ($r2c as $dc_rate_id => $dc_category_list) {
            foreach ($dc_category_list as $dc_category_id => $occupancy) {
                foreach ($occupancy as $key => $cell) {
                    $sql = 'insert into '.$this->table_name_r2c."  (dc_rate_id, dc_category_id, hms_occupancy_id,  hms_rate_id, hms_price_func_id) values
	                ($dc_rate_id, $dc_category_id, ".$cell['hms_occupancy_id'].', '.$cell['hms_rate_id'].', '.$cell['hms_price_func_id'].') on duplicate key update
                hms_rate_id='.$cell['hms_rate_id'].', hms_price_func_id='.$cell['hms_price_func_id'].', hms_occupancy_id='.$cell['hms_occupancy_id'].'';
                    // echo $sql . "\n";
                    $this->db->query($sql);
                }

                // save restricts
                if (isset($restricts[$dc_rate_id][$dc_category_id])) {
                    $sql = "INSERT INTO dc_su_restricts_link (dc_rate_id, dc_category_id, restrict_id) values ($dc_rate_id, $dc_category_id, ".$restricts[$dc_rate_id][$dc_category_id]['hms_restrict_id'].')
			            on duplicate key update restrict_id = '.$restricts[$dc_rate_id][$dc_category_id]['hms_restrict_id'];
                    $this->db->query($sql);
                }
            }
        }
    }

    public function create_update_property($data)
    {
        $property_id = $data['property_id'];
        $hms_id = $this->config->item('hotel_id');
        $dc_hotel_id = "hms-$hms_id-$property_id";

        $property_data = $this->property_model->get_property_data($property_id);
        $gps_coordinates_data = $property_data[0]['gps_coordinates'];
        $lat = '';
        $long = '';
        if ($gps_coordinates_data != '') {
            list($lat, $long) = explode(',', $gps_coordinates_data);
        }

        $global_language = $this->hotelix_config->get_record('global_language', 'int');
        $language_data = $this->frontdesk_c2->get_global_languages_str($global_language);
        $language_2char = $language_data['language_2char'];
        $language_3char = $language_data['language_3char'];

        $return_type_ameneties = 2; // return only ameneties_list without types array
        $property_ameneties = $this->property_model->get_property_ameneties($property_id, $return_type_ameneties);
        $facilities = [];
        foreach ($property_ameneties as $amenity_data) {
            array_push($facilities, [
                'Group' => $this->mlanguages->getdictionaryword('setup_property_c2_description', $language_3char, $amenity_data['amenety_type_name']),
                'name' => $this->mlanguages->getdictionaryword('setup_property_c2_description', $language_3char, $amenity_data['amenety_name']),
            ]);
        }

        $property_fotos = $this->property_model->get_property_fotos($property_id);
        $fotos = [];
        foreach ($property_fotos as $foto_data) {
            array_push($fotos, [
                'name' => $foto_data['foto_name'],
                'url' => $foto_data['img_url'],
            ]);
        }

        $contacts = [];
        array_push($contacts, [
            'ContactProfileType' => 'PhysicalLocation',
            'Addresses' => ['Address' => [
                'AddressLine' => $property_data[0]['street_lat'],
                'CityName' => $property_data[0]['city_lat'],
                'PostalCode' => $property_data[0]['post_code'],
                'CountryName' => $property_data[0]['country'],
            ],
            ],
        ]);
        $sql = "SELECT contacts.* FROM contacts 
            INNER JOIN dc_su_api_contacts_active co ON co.hms_contact_id = contacts.id
            WHERE contacts.property_id = $property_id";
        //echo $sql;
        // die();
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                array_push($contacts, [
                    //'ContactProfileType' => $row->ContactProfileType,
                    'ContactProfileType' => 'availability',
                    'Names' => ['Name' => ['GivenName' => $row->GivenName, 'Surname' => $row->SurName]],
                    'Addresses' => ['Address' => [
                                                            'AddressLine' => $row->AddressLine,
                                                            'CityName' => $row->CityName,
                                                            'PostalCode' => $row->PostalCode,
                                                            'CountryName' => $row->CountryName,
                                                            ],
                                         ],
                    'NotificationEmail' => $row->Email,
                    'Emails' => ['Email' => [$row->Email]],
                    'Phones' => ['Phone' => [['PhoneNumber' => $row->PhoneNumber, 'PhoneTechType' => $row->PhoneTechType]]],
                ]);
            }
        }

        $currency_code = $this->hotelix_config->get_record('global_currency', 'int');
        $currency_data = $this->frontdesk_c2->get_currency_data_byid($currency_code);
        $currency_str = $currency_data['currency_3char_name'];

        $international_summary_array = $this->internationalfields->get_value('property_custom', $property_id, 'international_summary');
        $description = isset($international_summary_array[$global_language]) ? $international_summary_array[$global_language] : '';

        switch ($data['status']) {
            case 'create':
                $type = 'New';
                break;
            case 'update':
                $type = 'Overlay';
                break;
        }

        $HotelType = 1;
        switch ($property_data[0]['dwelling']) {
            case 1:
                $HotelType = 3;
                break;
            case 2:
                if ($property_data[0]['property_type'] == 19) {
                    $HotelType = 2;
                }
                break;
        }

        $hotel = [
            'HotelDescriptiveContents' => [
                'HotelDescriptiveContent' => [
                    'HotelName' => $property_data[0]['property_name'], //Required
                    'HotelType' => "$HotelType", // Accepts values: array(1, 2 or 3] 1-Hotel , 2-Motel , 3-Vacational Rental (Default value=1)
                    'TimeZone' => $property_data[0]['timezone'],
                    'hotelid' => $dc_hotel_id, //
                    //"ChainID" => "W1",
                    'LanguageCode' => $language_2char, //Required
                    'CurrencyCode' => $currency_str, //Required
                    'HotelDescriptiveContentNotifType' => $type,
                    //"PropertyLicenseNumber" => "AB-CD-1234",
                    'OfficialCheckinTime' => $property_data[0]['check_in_time'],
                    'OfficialCheckoutTime' => $property_data[0]['check_out_time'],
                    'ContactInfos' => [
                        'ContactInfo' => $contacts,
                    ],
                    'HotelInfo' => [
                        'Position' => [
                            'Latitude' => $lat,
                            'Longitude' => $long,
                        ],
                    ],
                    'Facilities' => [
                        'Facility' => $facilities,
                    ],
                    'HotelDescription' => $description,
                ],
            ],
        ];
        if ($this->debug) {
            echo '<pre>';
            print_r($hotel);
            //die();
        }

        // ==== CURL REQUEST IMAGES =======
        $images_data = [];
        $images_data['hotelid'] = $dc_hotel_id;
        $images_data['images'] = $fotos;
        $curl_data = [];
        $curl_data['api_url'] = $this->url.'imageCreate';
        $curl_data['post_data'] = $images_data;
        if ($this->debug) {
            echo '<pre>';
            print_r($curl_data);
            //die();
        }
        $curl_response = $this->request_api($curl_data);
        $return_images_data = [
            'curl_response' => $curl_response,
            'su_property_id' => $dc_hotel_id,
        ];

        // ==== CURL REQUEST property =======
        $curl_data = [];
        $curl_data['api_url'] = $this->url.'OTA_HotelDescriptiveContentNotif';
        $curl_data['post_data'] = $hotel;
        $curl_response = $this->request_api($curl_data);
        $return_data = ['curl_response' => $curl_response, 'su_property_id' => $dc_hotel_id];

        //return array('property' => $return_data, 'images' => $return_images_data);
        return $return_data;
    }

    public function save_reservations($data)
    {
        $dc_hotel_id = $data['dc_hotel_id'];

        $curl_data = [];
        $curl_data['api_url'] = $this->url.'Reservation';
        $curl_data['post_data'] = ['hotelid' => $dc_hotel_id];

        $curl_response = $this->request_api($curl_data);
        if ($this->debug) {
            echo '============ SU CURL REQUEST =========';
            echo '<br>';
            print_r($curl_data);
            echo '<br>';
            echo '============ SU CURL RESPONSE =========';
            echo '<br>';
            print_r($curl_response);
            echo '<br>';
        }

        $this->get_bookings($curl_response);
    }

    public function save_reservations_bydate($data)
    {
        $this->frontdesk->timezone_set();
        $dc_hotel_id = $data['dc_hotel_id'];
        $date_from = $data['date'];
        $date_to = date('m-d-Y');

        $curl_data = [];
        $curl_data['api_url'] = $this->url.'Bookings';
        $curl_data['post_data'] = ['Su_hotelid' => $dc_hotel_id, 'date_from' => $date_from, 'date_to' => $date_to];
        $curl_data['type'] = 10;
        $curl_response = $this->request_api($curl_data);

        if ($this->debug) {
            echo '============ SU CURL REQUEST ========= ';
            echo '<br>';
            print_r($curl_data);
            echo '<br>';
            echo '============ SU CURL RESPONSE ========= ';
            echo '<br>';
            print_r($curl_response);
            echo '<br>';
        }

        $reservations = [];

        if (isset($curl_response['BookingDetails'])) {
            foreach ($curl_response['BookingDetails'] as $reservation) {
                if (time() > strtotime("{$reservation['checkoutdate']}")) {
                    continue;
                }
                $reservations[$reservation['booking_id']] = $reservation;
            }

            if ($this->debug) {
                echo '============ UNIQUE RESERVATIONS ========= ';
                echo '<br>';
                print_r($reservations);
                echo '<br>';
            }

            foreach ($reservations as $k => $v) {
                $this->get_booking_by_id($k);
            }
        }
    }

    public function get_booking_by_id($dc_reservation_id = null)
    {
        if (!null == $this->input->post('dc_reservation_id')) {
            $dc_hotel_id = $this->input->post('dc_hotel_id');
            $dc_reservation_id = $this->input->post('dc_reservation_id').'_'.$dc_hotel_id;
        } else {
            $dc_hotel_id = explode('_', $dc_reservation_id)[1] ?? '';
        }

        $curl_data = [
            'post_data' => [
                'hotelid' => $dc_hotel_id,
                'bookingid' => $dc_reservation_id,
            ],
            'api_url' => $this->url.'getReservation',
            'type' => 10
        ];

        $curl_response = $this->request_api($curl_data);

        if ($this->debug) {
            echo '============ SU CURL SINGLE RES REQUEST ========= ';
            echo '<br>';
            print_r($curl_data['post_data']);
            echo '============ SU CURL SINGLE RES RESPONSE ========= ';
            echo '<br>';
            if( isset($curl_response['reservations']) ){
                foreach($curl_response['reservations'] as $res){
                    echo "{$res['id']} - processed {$res['processed_at']}";
                    echo '<br>';
                }
            } else {
                print_r($curl_response);
            }
            echo '<br>';
        }

        $this->get_bookings($curl_response);
    }

    public function confirm_booking($data)
    {
        $dc_hotel_id = $data['dc_hotel_id'];
        $curl_data = [];
        $curl_data['api_url'] = $this->url.'Reservation_notif';

        $curl_data['post_data'] = [
            'hotelid' => $dc_hotel_id,
            'reservation_notif' => [
                'reservation_notif_id' => [
                    $data['reservation_notif_id'],
                ],
            ],
        ];

        if ($this->debug) {
            print_r($curl_data);
        }

        $curl_response = $this->request_api($curl_data);
        $return_data = ['curl_response' => $curl_response];

        $this->Loger_admin->Save_SyncData('', '', 'confirm', 40, 10, 0);
        if ($data['debug'] == 1) {
            echo '<pre>';
            echo "\n\n --- XML ConfirmBookingsAction START --- \n\n";
            print_r($return_data);
            echo "\n\n --- XML ConfirmBookingsAction END --- \n\n";
        }
    }

    public function request_api($data)
    {
        $post_data = $data['post_data'];
        $url = $data['api_url'];
        $type = $data['type'] ?? 13;

        if ($this->test_mode == 1) {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'Content-Type: application/json',
            ];
        } else {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
                'Content-Type: application/json',
            ];
        }

        if ($this->config->item('loger_v2') == 0) {
            $data_log = [
                'request' => 'request: '.json_encode($post_data).' headers: '.json_encode($headers),
                'url' => $url,
            ];

            $this->db->insert('dc_su_log', $data_log);
            $id = $this->db->insert_id();
        }
        // 	    echo "<pre>".$url;
        // 	    print_r($headers);
        // 	    print_r($post_data);
        $ch = curl_init();
        //echo json_encode($post_data);
        $useragent = 'Otelms';
        curl_setopt($ch, CURLOPT_USERAGENT, $useragent);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));
        $timestart = microtime(true);
        $curl_response = curl_exec($ch);
        $information = curl_getinfo($ch);
        //print_r($information);
        curl_close($ch);

        // === log ====
        $data_log = [
            'response' => $curl_response,
            'responseint' => '',
            'stime' => (microtime(true) - $timestart),
        ];
        if ($this->config->item('loger_v2') == 0) {
            $this->db->update('dc_su_log', $data_log, [
                'id' => $id,
            ]);
        } else {
            $data_log['request'] = json_encode($post_data);
            $data_log['url'] = $url;
            $data_log['dc_id'] = 40;
            $id = $this->loger_dc->SaveLog_v2($data_log);
        }

        $this->Loger_admin->Save_SyncData('', '', $curl_response, 40, $type, $id, false, 'import', '-');

        $this->db->insert('global_hotelix_analitycs.su_api_log', [
            'request' => json_encode($post_data).' headers: '.json_encode($headers),
            'response' => $curl_response,
        ]);
        if (isset($_SESSION['dc_msg']['text'])) {
            $_SESSION['dc_msg']['text'] .= '<br>REQUEST:<br>'.json_encode($post_data).'<br>RESPONSE:<br>'.$curl_response;
        } else {
            $_SESSION['dc_msg']['text'] = '<br>REQUEST:<br>'.json_encode($post_data).'<br>RESPONSE:<br>'.$curl_response;
        }
        //echo $curl_response;
        $result = json_decode($curl_response, true);
        //print_r($result);
        return $result;
    }

    public function acknowledge()
    {
        $url = $this->url.'Reservation_notif';

        $data = [
            'hotelid' => 'hms-92-5',
            'reservation_notif' => [
                'reservation_notif_id' => [
                    '171931199533731937455',
                ],
            ],
        ];

        if ($this->test_mode == 1) {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'Content-Type: application/json',
            ];
        } else {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
                'Content-Type: application/json',
            ];
        }

        $ch = curl_init();

        $useragent = 'Otelms';
        curl_setopt($ch, CURLOPT_USERAGENT, $useragent);

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);

        curl_close($ch);

        $result = json_decode($buffer, true);
        echo '<pre>';
        print_r([json_encode($data), htmlentities($buffer), $result, $information]);
    }

    public function create_rate($data)
    {
        $su_property_id = $data['su_property_id'];
        $hms_rate_id = $data['hms_rate_id'];
        $hms_id = $this->config->item('hotel_id');
        $rates_data = $this->mrates->get_rates_data($hms_rate_id);
        print_r($rates_data);
        $hms_property_id = $this->get_hms_prop_id_by_su_prop_id($data['su_property_id']);
        foreach ($rates_data as $rate_cell) {
            $rate_id = $rate_cell['id'];
            $rate = [
                'RatePlans' => [
                    'hotelid' => $su_property_id,
                    'RatePlan' => [
                        [
                            'RatePlanNotifType' => 'New',
                            'rateplanid' => "$hms_id-$hms_property_id-$hms_rate_id",
                            'MealPlanID' => '1',
                            'Description' => [
                                'Name' => $rate_cell['rate_name'],
                                'Text' => '',
                            ],
                        ],
                    ],
                ],
            ];
            if ($this->debug) {
                print_r($rate);
            }
            $curl_data = [];
            $curl_data['api_url'] = $this->url.'OTA_HotelRatePlan';
            $curl_data['post_data'] = $rate;
            $curl_response = $this->request_api($curl_data);
            $return_data = ['curl_response' => $curl_response, 'su_property_id' => $su_property_id];
            if ($this->debug) {
                print_r($return_data);
            }

            return $return_data;
        }
    }

    public function create_rates()
    {
        $hms_id = $this->config->item('hotel_id');
        $rates_data = $this->mrates->get_rates_data();
        foreach ($rates_data as $rate_cell) {
            $rate_id = $rate_cell['id'];
            $rate = [
                'RatePlans' => [
                    'hotelid' => "$hms_id-$rate_id",
                    'RatePlan' => [
                        [
                            'RatePlanNotifType' => 'New',
                            'rateplanid' => '109-2',
                            'MealPlanID' => '1',
                            'Description' => [
                                'Name' => 'Non refundable',
                                'Text' => 'Р‘РµР·РїРѕРІРѕСЂРѕС‚РЅРёР№ С‚Р°СЂРёС„',
                            ],
                        ],
                    ],
                ],
            ];

            $curl_data = [];
            $curl_data['api_url'] = $this->url.'OTA_HotelRatePlan';
            $curl_data['post_data'] = $hotel;
            $this->request_api($curl_data);
        }
    }

    public function update_rate($data)
    {
        $su_property_id = $data['su_property_id'];
        $su_rate_id = $data['su_rate_id'];
        $hms_rate_id = $data['hms_rate_id'];

        $hms_id = $this->config->item('hotel_id');
        $rates_data = $this->mrates->get_rates_data($hms_rate_id);
        $dc_hotel_id = $this->get_dc_hotel_id_by_su_prop_id($data['su_property_id']);
        foreach ($rates_data as $rate_cell) {
            $rate_id = $rate_cell['id'];
            $rate = [
                'RatePlans' => [
                    'hotelid' => $su_property_id,
                    'RatePlan' => [
                        [
                            'RatePlanNotifType' => 'Overlay',
                            'rateplanid' => $su_rate_id,
                            'MealPlanID' => '1',
                            'Description' => [
                                'Name' => $rate_cell['rate_name'],
                                'Text' => '',
                            ],
                        ],
                    ],
                ],
            ];
        }

        $curl_data = [];
        $curl_data['api_url'] = $this->url.'OTA_HotelRatePlan';
        $curl_data['post_data'] = $rate;
        $curl_response = $this->request_api($curl_data);
        $return_data = [
            'curl_response' => $curl_response,
            'su_property_id' => $su_property_id,
        ];

        return $return_data;
    }

    public function change_room_status_OLD($hotel_id = '109-1', $room_id = '109-1-1', $status = 'inactive')
    {
        switch ($status) {
            case 'active':
                $status_type = 'Active';
                break;
            case 'delete':
                $status_type = 'Delete';
                break;
            case 'inactive':
            default:
                $status_type = 'Deactivated';
                break;
        }

        $room = [
            'SellableProducts' => [
                'HotelCode' => $hotel_id,
                'SellableProduct' => [
                    [
                        'InvNotifType' => 'Overlay',
                        'InvStatusType' => $status_type,
                        'roomid' => $room_id,
                    ],
                ],
            ],
        ];

        $url = $this->url.'OTA_HotelRoom';

        $headers = [
            'Authorization: Basic '.$this->auth,
            'Content-Type: application/json',
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($room));

        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);

        curl_close($ch);

        $result = json_decode($buffer, true);

        $this->dump($result);
    }

    public function create_rooms($data)
    {
        $property_id = $data['property_id'];
        $hms_id = $this->config->item('hotel_id');
        $dc_hotel_id = "hms-$hms_id-$property_id";
        $categories_fotos = $this->mcategory->get_photos();
        $categories_data = $this->frontdesk_c2->get_categories($property_id);

        foreach ($categories_data as $category_cell) {
            $hms_category_id = $category_cell['category_id'];
            $dc_room_id = "$hms_id-$property_id-$hms_category_id";

            $category_ameneties = $this->mcategory->get_category_ameneties($hms_category_id);
            $facilities = [];
            foreach ($category_ameneties as $amenity_data) {
                array_push($facilities, [
                    'Group' => $this->mlanguages->getdictionaryword('tbl_roomscategories_equipment', '', $amenity_data['amenety_type_name']),
                    'name' => $this->mlanguages->getdictionaryword('tbl_roomscategories_equipment', '', $amenity_data['amenety_name']),
                ]);
            }

            $fotos = [];
            if (isset($categories_fotos[$hms_category_id])) {
                foreach ($categories_fotos[$hms_category_id] as $foto_data) {
                    array_push($fotos, [
                        'name' => 'test_name',
                        'url' => $foto_data['img_url'],
                    ]);
                }
            }

            switch ($category_cell['category_size_type']) {
                case 1:
                    $size_type = 'sqm';
                    break;
                case 2:
                    $size_type = 'sqf';
                    break;
                default:
                    $size_type = 'sqm';
                    break;
            }
            $room = [
                'SellableProducts' => [
                    'HotelCode' => $dc_hotel_id,
                    'SellableProduct' => [
                        [
                            'InvStatusType' => 'Initial',
                            'GuestRoom' => [
                                'Occupancy' => [
                                    'MaxOccupancy' => '4',
                                    'MaxChildOccupancy' => 2,
                                ],
                                'Room' => [
                                    'RoomID' => $dc_room_id,
                                    'RoomRate' => $category_cell['category_base_price'],
                                    'Quantity' => $category_cell['category_add_places'],
                                    'RoomType' => 'Suite',
                                    'SizeMeasurement' => $category_cell['category_size'],
                                    'SizeMeasurementUnit' => $size_type,
                                ],
                                'Facilities' => [
                                    'Facility' => $facilities,
                                ],
                                'Images' => [
                                    'Image' => $fotos,
                                ],
                                'Description' => [
                                    'RoomDescription' => $category_cell['category_description'],
                                    'Text' => 'test',
                                ],
                            ],
                        ],
                    ],
                ],
            ];

            // echo "<pre>";
            // print_r($room);
            $curl_data = [];
            $curl_data['api_url'] = $this->url.'OTA_HotelRoom';
            $curl_data['post_data'] = $hotel;
            $this->request_api($curl_data);
        }
    }

    public function get_su_properties_link()
    {
        $su_properties_link = [];
        $sql = 'SELECT * FROM dc_su_properties_link';
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $su_properties_link[$row->hms_property_id] = $row->su_property_id;
        }

        return $su_properties_link;
    }

    public function get_hms_prop_id_by_su_prop_id($su_property_id)
    {
        return $this->db->select('hms_property_id')->get_where('dc_su_properties_link', ['su_property_id' => $su_property_id])->row()->hms_property_id;
    }

    public function get_dc_hotel_id_by_su_prop_id($su_property_id)
    {
        return $this->db->select('dc_account_id')->get_where('dc_su_xml_cfg', ['str_value' => $su_property_id, 'name' => 'hotel_id'])->row()->dc_account_id;
    }

    public function create_room($data)
    {
        $su_property_id = $data['su_property_id'];
        $hms_category_id = $data['hms_category_id'];
        $hms_id = $this->config->item('hotel_id');
        $categories_fotos = $this->mcategory->get_photos();

        $get_data = [];
        $get_data['category_ids'] = [$hms_category_id];
        $categories_data = $this->frontdesk_c2->get_categories_data($get_data);
        $hms_property_id = $this->get_hms_prop_id_by_su_prop_id($su_property_id);

        $global_language = $this->hotelix_config->get_record('global_language', 'int');
        $language_data = $this->frontdesk_c2->get_global_languages_str($global_language);
        $language_2char = $language_data['language_2char'];
        $language_3char = $language_data['language_3char'];

        foreach ($categories_data as $category_cell) {
            $hms_category_id = $category_cell['category_id'];
            $dc_room_id = "$hms_id-$hms_property_id-$hms_category_id";

            $category_ameneties = $this->mcategory->get_category_ameneties($hms_category_id);
            $facilities = [];
            foreach ($category_ameneties as $amenity_data) {
                array_push($facilities, [
                    'Group' => $this->mlanguages->getdictionaryword('tbl_roomscategories_equipment', $language_3char, $amenity_data['amenety_type_name']),
                    'name' => $this->mlanguages->getdictionaryword('tbl_roomscategories_equipment', $language_3char, $amenity_data['amenety_name']),
                ]);
            }

            $fotos = [];
            if (isset($categories_fotos[$hms_category_id])) {
                foreach ($categories_fotos[$hms_category_id] as $foto_data) {
                    array_push($fotos, [
                        'name' => 'test_name',
                        'url' => $foto_data['img_url'],
                    ]);
                }
            }

            switch ($category_cell['category_size_type']) {
                case 1:
                    $size_type = 'sqm';
                    break;
                case 2:
                    $size_type = 'sqft';
                    break;
                default:
                    $size_type = 'sqm';
                    break;
            }
            $room = [
                'SellableProducts' => [
                    'HotelCode' => $su_property_id,
                    'SellableProduct' => [
                        [
                            'InvStatusType' => 'Initial',
                            'GuestRoom' => [
                                'Occupancy' => [
                                    'MaxOccupancy' => $category_cell['category_add_places'],
                                    'MaxChildOccupancy' => $category_cell['category_baby_places'],
                                ],
                                'Room' => [
                                    'RoomID' => $dc_room_id,
                                    'RoomRate' => $category_cell['category_base_price'],
                                    //'Quantity' => $category_cell ['category_add_places'],
                                    'Quantity' => $category_cell['category_room_count'],
                                    'RoomType' => $category_cell['category_type_name'],
                                    'SizeMeasurement' => $category_cell['category_size'],
                                    'SizeMeasurementUnit' => $size_type,
                                ],
                                'Facilities' => [
                                    'Facility' => $facilities,
                                ],
                                'Description' => [
                                    'RoomDescription' => $category_cell['category_description'],
                                    'Text' => $category_cell['category_fullname'],
                                ],
                            ],
                        ],
                    ],
                ],
            ];
            if ($this->debug) {
                echo '<pre>';
                print_r($room);
            }
            $curl_data = [];
            $curl_data['api_url'] = $this->url.'OTA_HotelRoom';
            $curl_data['post_data'] = $room;
            $curl_response = $this->request_api($curl_data);
            $return_data = ['curl_response' => $curl_response, 'su_property_id' => $su_property_id];
            if ($this->debug) {
                print_r($return_data);
            }

            return $return_data;
        }
    }

    public function update_room($data)
    {
        $su_property_id = $data['su_property_id'];
        $su_room_id = $data['su_room_id'];
        $hms_category_id = $data['hms_category_id'];
        $hms_id = $this->config->item('hotel_id');
        $categories_fotos = $this->mcategory->get_photos();

        $get_data = [];
        $get_data['category_ids'] = [$hms_category_id];
        $categories_data = $this->frontdesk_c2->get_categories_data($get_data);
        $hms_property_id = $this->get_hms_prop_id_by_su_prop_id($su_property_id);
        foreach ($categories_data as $category_cell) {
            $hms_category_id = $category_cell['category_id'];
            $dc_room_id = "$hms_id-$hms_property_id-$hms_category_id";

            $category_ameneties = $this->mcategory->get_category_ameneties($hms_category_id);
            $facilities = [];
            foreach ($category_ameneties as $amenity_data) {
                array_push($facilities, [
                    'Group' => $this->mlanguages->getdictionaryword('tbl_roomscategories_equipment', '', $amenity_data['amenety_type_name']),
                    'name' => $this->mlanguages->getdictionaryword('tbl_roomscategories_equipment', '', $amenity_data['amenety_name']),
                ]);
            }

            $fotos = [];
            if (isset($categories_fotos[$hms_category_id])) {
                foreach ($categories_fotos[$hms_category_id] as $foto_data) {
                    array_push($fotos, [
                        'name' => 'test_name',
                        'url' => $foto_data['img_url'],
                    ]);
                }
            }

            switch ($category_cell['category_size_type']) {
                case 1:
                    $size_type = 'sqm';
                    break;
                case 2:
                    $size_type = 'sqft';
                    break;
                default:
                    $size_type = 'sqm';
                    break;
            }
            $room = [
                'SellableProducts' => [
                    'HotelCode' => $su_property_id,
                    'SellableProduct' => [
                        [
                            'InvNotifType' => 'Overlay',
                            'InvStatusType' => 'Modify',
                            'roomid' => $su_room_id,
                            'GuestRoom' => [
                                'Occupancy' => [
                                    'MaxOccupancy' => '4',
                                    'MaxChildOccupancy' => 2,
                                ],
                                'Room' => [
                                    'RoomID' => $dc_room_id,
                                    'RoomRate' => $category_cell['category_base_price'],
                                    'Quantity' => $category_cell['category_add_places'],
                                    'RoomType' => 'Suite',
                                    'SizeMeasurement' => $category_cell['category_size'],
                                    'SizeMeasurementUnit' => $size_type,
                                ],
                                'Facilities' => [
                                    'Facility' => $facilities,
                                ],
                                'Images' => [
                                    'Image' => $fotos,
                                ],
                                'Description' => [
                                    'RoomDescription' => $category_cell['category_description'],
                                    'Text' => 'test',
                                ],
                            ],
                        ],
                    ],
                ],
            ];

            //             echo "<pre>";
            //             print_r($room);
            //             die();
            $curl_data = [];
            $curl_data['api_url'] = $this->url.'OTA_HotelRoom';
            $curl_data['post_data'] = $room;
            $curl_response = $this->request_api($curl_data);
            $return_data = ['curl_response' => $curl_response, 'su_property_id' => $su_property_id];

            return $return_data;
        }
    }

    public function get_hotels()
    {
        $url = $this->url.'pmsproperty';
        //echo $url;
        // 	    $headers = array(
        // 	        'Authorization: Basic ' . $this->auth
        // 	    );

        if ($this->test_mode == 1) {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'Content-Type: application/json',
            ];
        } else {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
                'Content-Type: application/json',
            ];
        }

        // 	    $ch = curl_init();

        // 	    curl_setopt($ch, CURLOPT_URL, $url);
        // 	    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        // 	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // 	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        // 	    curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        // 	    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // 	    $buffer = curl_exec($ch);
        // 	    $information = curl_getinfo($ch);

        // 	    curl_close($ch);

        $ch = curl_init();
        //echo json_encode($post_data);
        $useragent = 'Otelms';
        curl_setopt($ch, CURLOPT_USERAGENT, $useragent);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $timestart = microtime(true);
        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);
        //print_r($information);
        curl_close($ch);

        //echo $buffer;
        $result = json_decode($buffer, true);

        return $result;
    }

    public function delete_property($hotel = '')
    {
        $url = $this->url.'RemoveProperty';
        //echo $url;
        if ($this->test_mode == 1) {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'Content-Type: application/json',
            ];
        } else {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
                'Content-Type: application/json',
            ];
        }

        $request = ['hotelid' => $hotel];
        $useragent = 'Otelms';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($request));
        curl_setopt($ch, CURLOPT_USERAGENT, $useragent);
        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);
        //echo $buffer;
        curl_close($ch);
        //die();
        $dc_msg = 'REQUEST:<br>'.json_encode($request).'<br>RESPONSE:<br>'.$buffer;

        $result = json_decode($buffer, true);

        return $result;
    }

    public function validate_su_property_id($p = ['su_property_id'])
    {
        $su_properties = $this->get_hotels();
        // 	    echo "<pre>".$p['su_property_id']."+++";
        // 	    print_r($su_properties);
        //die();
        $validate_status = false;
        if (isset($su_properties['properties'])) {
            foreach ($su_properties['properties'] as $su_data) {
                if ($su_data['propertyid'] == $p['su_property_id']) {
                    $validate_status = true;
                    break;
                }
            }
        }

        //echo "validate_status: ".(int)$validate_status."|||";
        //die();
        return $validate_status;
    }

    public function property_already_binded($p = ['su_property_id'])
    {
        $tbl = 'dc_su_properties_link';

        return (bool) $this->db->get_where($tbl, $p)->row();
    }

    public function bind_properties($p = ['hms_property_id', 'su_property_id'])
    {
        $tbl = 'dc_su_properties_link';
        $this->db->insert($tbl, $p);

        return;
    }

    public function unbind_properties($p = ['su_property_id'])
    {
        $tbl = 'dc_su_properties_link';
        $this->db->delete($tbl, $p);

        return;
    }

    public function get_properties_conections()
    {
        $query_properties_ids_in_xml_cfg = $this->db->select('str_value as id')->like(['name' => 'hotel_id'])->get('dc_su_xml_cfg')->result();
        $query_properties_conections = $this->db->get('dc_su_properties_link')->result();

        $result = [];
        $properties_conections = [];
        foreach ($query_properties_conections as $conections) {
            $properties_conections[$conections->su_property_id] = $conections;
        }
        foreach ($query_properties_ids_in_xml_cfg as $property) {
            if (!in_array($property->id, array_keys($properties_conections))) {
                $result[$property->id] = (object) [
                    'su_property_id' => $property->id,
                    'hms_property_id' => 0,
                ];
            } else {
                $result[$property->id] = $properties_conections[$property->id];
            }
        }
        if (count($properties_conections) > count($result)) {
            foreach ($properties_conections as $conection) {
                if (!isset($result[$conection->su_property_id])) {
                    $result[$conection->su_property_id] = $conection;
                }
            }
        }

        return json_decode(json_encode($result), true);
    }

    public function update_su_properties_cfg($p = ['su_property_id'])
    {
        $su_property_id = $p['su_property_id'];
        $dc_account_id = 0;
        $query_su_properties_ids_in_xml_cfg = $this->db->select('str_value as id, dc_account_id')->like(['name' => 'hotel_id'])->get('dc_su_xml_cfg')->result();
        $id_allready_in_tbl = false;
        foreach ($query_su_properties_ids_in_xml_cfg as $su_property) {
            if ($su_property->id == $su_property_id) {
                $id_allready_in_tbl = true;
            }
            $dc_account_id = ($dc_account_id < $su_property->dc_account_id) ? $su_property->dc_account_id : $dc_account_id;
        }
        if (!$id_allready_in_tbl) {
            $dc_account_id = $dc_account_id + 1;
            $ins_arr = [
                'dc_account_id' => $dc_account_id,
                'name' => 'hotel_id',
                'str_value' => $su_property_id,
            ];
            $this->db->insert('dc_su_xml_cfg', $ins_arr);
        }

        return;
    }

    public function delete_properties_conections($p = ['su_property_id'])
    {
        $su_property_id = $p['su_property_id'];

        $this->unbind_properties(['su_property_id' => $su_property_id]);

        $whr_arr = [
            'name' => 'hotel_id',
            'str_value' => $su_property_id,
        ];
        $this->db->delete('dc_su_xml_cfg', $whr_arr);

        $this->delete_property($su_property_id);

        return;
    }

    public function get_rooms($hotel = '')
    {
        $url = $this->url.'roomdetails';

        if ($this->test_mode == 1) {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'Content-Type: application/json',
            ];
        } else {
            $headers = [
                'Authorization: Basic '.$this->auth,
                'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
                'Content-Type: application/json',
            ];
        }

        $request = ['hotelid' => $hotel];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($request));

        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);

        curl_close($ch);

        $result = json_decode($buffer, true);

        return $result;
    }

    public function get_rooms_conections($su_property_id)
    {
        $conections = [];
        $sql = "SELECT dc_su_xml_cfg.str_value as dc_hotel_str, dc_su_room_categories.dc_room_id, dc_su_room_categories_link.hms_category_id 
	                   FROM dc_su_xml_cfg 
	                   INNER JOIN dc_su_room_categories ON dc_su_room_categories.dc_hotel_id = dc_su_xml_cfg.dc_account_id
	                   INNER JOIN dc_su_room_categories_link ON dc_su_room_categories_link.dc_category_id = dc_su_room_categories.dc_room_id
	        WHERE dc_su_xml_cfg.name LIKE 'hotel_id' AND dc_su_xml_cfg.str_value = '$su_property_id' AND dc_su_room_categories_link.hms_category_id <> 0";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $conections[$row->dc_room_id] = $row;
        }

        return $conections;
    }

    public function get_su_property_rates($hotel = '')
    {
        $curl_data = [];
        $curl_data['api_url'] = $this->url.'ratedetails';
        $curl_data['post_data'] = ['hotelid' => $hotel];

        return (object) $this->request_api($curl_data);
    }

    public function get_rates_conections($su_property_id)
    {
        $dc_hotel_id = $this->get_dc_hotel_id_by_su_prop_id($su_property_id);
        $conections = [];
        if ($dc_hotel_id > 0) {
            $tbl_rates = 'dc_su_rates';
            $tbl_rates_link = 'dc_su_rate2category_link';
            $tbl_rates_strtoint = 'dc_su_rates_strtoint';
            $where_arr = [
                "$tbl_rates.dc_hotel_id" => $dc_hotel_id,
                "$tbl_rates_link.hms_rate_id !=" => 0,
            ];
            // $query_rates = $this->db->select("$tbl_rates_link.*, $tbl_rates.dc_hotel_id, $tbl_rates_strtoint.dc_rate_id as su_rate_id")
            // ->join($tbl_rates_link, "$tbl_rates_link.dc_rate_id = $tbl_rates.dc_rate_id")
            // ->join($tbl_rates_strtoint, "$tbl_rates_strtoint.id = $tbl_rates.dc_rate_id")
            // ->where($where_arr)
            // ->get($tbl_rates)->result();
            $sql = "SELECT dc_su_rate2category_link.*, dc_su_rates.dc_hotel_id, dc_su_rates_strtoint.dc_rate_id as su_rate_id
            FROM dc_su_rates
            INNER JOIN dc_su_rates_strtoint ON dc_su_rates_strtoint.id = dc_su_rates.dc_rate_id
            INNER JOIN dc_su_rate2category_link ON dc_su_rate2category_link.dc_rate_id = dc_su_rates.dc_rate_id
            WHERE dc_su_rates.dc_hotel_id = $dc_hotel_id AND dc_su_rate2category_link.hms_rate_id != 0";

            $query = $this->db->query($sql);
            foreach ($query->result() as $rate) {
                $conections[$rate->su_rate_id] = $rate;
            }
        }

        return $conections;
    }

    public function room_already_binded($p = ['su_room_id'])
    {
        $dc_category_id = $this->get_dc_room_id_by_str_value($p['su_room_id']);
        $where_arr = [
            'dc_category_id' => $dc_category_id,
            'hms_category_id !=' => 0,
        ];

        return (bool) $this->db->get_where('dc_su_room_categories_link', $where_arr)->row();
    }

    public function bind_rooms($p = ['hms_room_id', 'su_room_id', 'su_property_id', 'dc_room_name'])
    {
        $dc_category_id = $this->get_dc_room_id_by_str_value($p['su_room_id']);
        $dc_hotel_id = $this->get_dc_hotel_id_by_su_prop_id($p['su_property_id']);
        $whr_arr = [
            'dc_hotel_id' => $dc_hotel_id,
            'dc_room_id' => $dc_category_id,
        ];
        $booking_room_id_exist = $this->db->get_where('dc_su_room_categories', $whr_arr)->row();
        if ($booking_room_id_exist) {
            $upd_arr = [
                'hms_category_id' => $p['hms_room_id'],
            ];
            $whr_arr = [
                'dc_category_id' => $dc_category_id,
            ];
            $this->db->update('dc_su_room_categories_link', $upd_arr, $whr_arr);
        } else {
            if (!isset($p['dc_room_name'])) {
                $prop_rooms = $this->get_rooms($p['su_property_id']);
                foreach ($prop_rooms['rooms'] as $su_room_data) {
                    if ($su_room_data['roomid'] == $p['su_room_id']) {
                        $p['dc_room_name'] = $su_room_data['roomname'];
                        break;
                    }
                }
            }
            $ins_arr = ['dc_hotel_id' => $dc_hotel_id, 'dc_room_id' => $dc_category_id, 'name' => $p['dc_room_name']];
            $this->db->insert('dc_su_room_categories', $ins_arr);
            $ins_arr = ['dc_category_id' => $dc_category_id, 'hms_category_id' => $p['hms_room_id']];
            $this->db->insert('dc_su_room_categories_link', $ins_arr);
        }

        return;
    }

    public function unbind_rooms($p = ['su_room_id'])
    {
        $dc_category_id = $this->get_dc_room_id_by_str_value($p['su_room_id']);
        $where_arr = [
            'dc_room_id' => $dc_category_id,
        ];
        $this->db->delete('dc_su_room_categories', $where_arr);

        $where_arr = [
            'dc_category_id' => $dc_category_id,
        ];
        $this->db->delete('dc_su_room_categories_link', $where_arr);

        return;
    }

    public function change_room_status($hotel_id, $room_id, $status)
    {
        switch ($status) {
            case 'active':
                $status_type = 'Active';
                break;
            case 'delete':
                $status_type = 'Delete';
                break;
            case 'inactive':
            default:
                $status_type = 'Deactivated';
                break;
        }

        $room = [
            'SellableProducts' => [
                'HotelCode' => $hotel_id,
                'SellableProduct' => [
                    [
                        'InvNotifType' => 'Overlay',
                        'InvStatusType' => $status_type,
                        'roomid' => $room_id,
                    ],
                ],
            ],
        ];

        $curl_data = [];
        $curl_data['api_url'] = $this->url.'OTA_HotelRoom';
        $curl_data['post_data'] = $room;
        $response = $this->request_api($curl_data);

        return ['curl_response' => $response];
    }

    public function change_rate_status($hotel_id, $rate_id, $status)
    {
        switch ($status) {
            case 'active':
                $status_type = 'Activate';
                break;
            case 'delete':
                $status_type = 'Delete';
                break;
            case 'inactive':
            default:
                $status_type = 'Remove';
                break;
        }

        $rate = [
            'RatePlans' => [
                'hotelid' => $hotel_id,
                'RatePlan' => [
                    [
                        'RatePlanNotifType' => $status_type,
                        'rateplanid' => $rate_id,
                        'MealPlanID' => '1',
                        'Description' => [
                            'Name' => '',
                            'Text' => '',
                        ],
                    ],
                ],
            ],
        ];

        $curl_data = [];
        $curl_data['api_url'] = $this->url.'OTA_HotelRatePlan';
        $curl_data['post_data'] = $rate;
        $response = $this->request_api($curl_data);

        return ['curl_response' => $response];
    }

    public function rate_already_binded($p = ['su_rate_id', 'su_property_id'])
    {
        $conections = $this->get_rates_conections($p['su_property_id']);

        return (bool) array_key_exists($p['su_rate_id'], $conections);
    }

    public function bind_rates($p = ['hms_rate_id', 'su_rate_id', 'su_property_id'])
    {
        $dc_rate_id = $this->get_dc_rate_id_by_str_value($p['su_rate_id']);
        $dc_hotel_id = $this->get_dc_hotel_id_by_su_prop_id($p['su_property_id']);
        $where_arr = [
            'dc_rate_id' => $dc_rate_id,
        ];
        $dc_rate_is_in_tbl = $this->db->get_where('dc_su_rate2category_link', $where_arr)->row();
        if ($dc_rate_is_in_tbl) {
            $upd_arr = [
                'hms_rate_id' => $p['hms_rate_id'],
            ];
            $this->db->update('dc_su_rate2category_link', $upd_arr, $where_arr);
        } else {
            $ins_arr = [
                'hms_rate_id' => $p['hms_rate_id'],
                'dc_rate_id' => $dc_rate_id,
            ];
            $this->db->insert('dc_su_rate2category_link', $ins_arr);
        }

        return;
    }

    public function unbind_rates($p = ['su_rate_id, su_prop_id'])
    {
        $dc_rate_id = $this->get_dc_rate_id_by_str_value($p['su_rate_id']);
        $dc_hotel_id = $this->get_dc_hotel_id_by_su_prop_id($p['su_prop_id']);
        $tbl = 'dc_su_rate2category_link';
        $where_arr = [
            'dc_rate_id' => $dc_rate_id,
        ];
        $this->db->delete($tbl, $where_arr);

        // 	    $tbl = 'dc_su_rates';
        // 	    $where_arr = array(
        // 	        'dc_hotel_id' => $dc_hotel_id,
        // 	        'dc_rate_id' => $dc_rate_id,
        // 	    );
        // 	    $this->db->delete($tbl, $where_arr);
        return;
    }

    public function get_su_test_mode()
    {
        $su_test_mode = 1;
        $sql = "SELECT value FROM hotelix_config WHERE name LIKE 'dc_su_test_mode'";
        $query = $this->db->query($sql);

        if ($query->num_rows() > 0) {
            $row = $query->row();
            $su_test_mode = $row->value;
        }

        return $su_test_mode;
    }

    public function import_room_rates()
    {
        $accounts = [];
        $sql = 'SELECT * FROM dc_su_xml_cfg WHERE dc_account_id > 0';
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $accounts[$row->dc_account_id][$row->name]['str_value'] = $row->str_value;
            $accounts[$row->dc_account_id][$row->name]['int_value'] = $row->int_value;
        }

        $curl_result = '';
        if (count($accounts) > 0) {
            foreach ($accounts as $dc_account_id => $account_data) {
                $authparam = $this->dcm_su->getauthparam($dc_account_id);

                $hotel_id_str = $authparam['hotel_id'];
                $hotel_id_int = $dc_account_id;

                $curl_data = [];
                $curl_data['url'] = $this->dcm_su->url.'roomdetails';
                $curl_data['auth'] = $this->dcm_su->auth;
                $curl_data['dc_id'] = $this->dcm_su->dc_id;
                $curl_data['returntype'] = 'full';
                $curl_data['request'] = ['hotelid' => $hotel_id_str];
                $curl_data['test_mode'] = $this->dcm_su->test_mode;
                $data_result = $this->Curl_model->curl_su($curl_data);

                $result_array = json_decode($data_result['result'], true);

                $curl_result .= print_r($result_array, true);
                $this->Loger_admin->Save_SyncData('', '', $data_result['result'], 40, 13, $data_result['dc_log_id'], false, 'import', '-');

                // === get rates =====
                $curl_data = [];
                $curl_data['url'] = $this->dcm_su->url.'ratedetails';
                $curl_data['auth'] = $this->dcm_su->auth;
                $curl_data['dc_id'] = $this->dcm_su->dc_id;
                $curl_data['test_mode'] = $this->dcm_su->test_mode;
                $curl_data['returntype'] = 'full';
                $curl_data['request'] = ['hotelid' => $hotel_id_str];
                //echo "<pre>";
                //print_r( $curl_data );
                $data_result = $this->Curl_model->curl_su($curl_data);

                $result_rates_array = json_decode($data_result['result'], true);
                //echo "<pre>";
                //print_r( $result_rates_array );

                $curl_result .= print_r($result_rates_array, true);
                $this->Loger_admin->Save_SyncData('', '', $data_result['result'], 40, 13, $data_result['dc_log_id'], false, 'import', '-');

                if (isset($result_array['rooms'])) {
                    $dc_rate_id = 1;

                    $sql = 'UPDATE dc_su_room_categories SET active = 0 WHERE 1 AND dc_hotel_id = '.$hotel_id_int;
                    $query = $this->db->query($sql);

                    foreach ($result_array['rooms'] as $room) {
                        // echo "<pre>";
                        // print_r($room);
                        $sql = "INSERT INTO dc_su_categories_strtoint (dc_room_id) VALUES('".$room['roomid']."')
                                ON DUPLICATE KEY UPDATE dc_room_id = dc_room_id";
                        $query = $this->db->query($sql);

                        $dc_room_id_int = $this->dcm_su->get_dc_room_id_by_str_value($room['roomid']);

                        $sql = "INSERT INTO dc_su_room_categories(dc_hotel_id, name, dc_room_id, active)
						        VALUES('".$hotel_id_int."', '".addslashes($room['roomname'])."','".$dc_room_id_int."',  1)
						        ON DUPLICATE KEY UPDATE name = '".addslashes($room['roomname'])."', active = 1";
                        $query = $this->db->query($sql);

                        $sql = "INSERT INTO  dc_su_room_categories_link(dc_category_id)
					            VALUES('".$dc_room_id_int."')
					            ON DUPLICATE KEY UPDATE hms_category_id = hms_category_id";
                        $query = $this->db->query($sql);

                        if (isset($room['maximumoccupancy'])) {
                            for ($oc = 1; $oc <= $room['maximumoccupancy']; ++$oc) {
                                $sql = "INSERT INTO dc_su_occupancy(id, name, roomcategory)
								        VALUES('".$oc."', '".$oc."', '".$dc_room_id_int."')
								        ON DUPLICATE KEY UPDATE name = '".$oc."', roomcategory = '".$dc_room_id_int."'";
                                $query = $this->db->query($sql);

                                $sql = "INSERT INTO dc_su_category2occupancy(dc_category_id, hms_occupancy_id)
								        VALUES('".$dc_room_id_int."', '".$oc."')
								        ON DUPLICATE KEY UPDATE state = state";
                                $query = $this->db->query($sql);
                            }
                        }

                        if (isset($result_rates_array['rateplans'])) {
                            $sql = 'UPDATE dc_su_rates SET active = 0 WHERE 1 AND dc_hotel_id = '.$hotel_id_int;
                            $query = $this->db->query($sql);
                            foreach ($result_rates_array['rateplans'] as $rate) {
                                $sql = "INSERT INTO dc_su_rates_strtoint (dc_rate_id) VALUES('".$rate['rateplanid']."')
                                ON DUPLICATE KEY UPDATE dc_rate_id = dc_rate_id";
                                $query = $this->db->query($sql);
                                $dc_rate_id_int = $this->dcm_su->get_dc_rate_id_by_str_value($rate['rateplanid']);

                                $sql = "INSERT INTO dc_su_rates(dc_hotel_id, dc_rate_id, name, active)
								            VALUES('".$hotel_id_int."', '".$dc_rate_id_int."', '".$rate['rateplanname']."', 1)
								            ON DUPLICATE KEY UPDATE name = '".$rate['rateplanname']."', active = 1";
                                // echo $sql;
                                $query = $this->db->query($sql);

                                for ($oc = 1; $oc <= $room['maximumoccupancy']; ++$oc) {
                                    $sql = "INSERT INTO dc_su_rate2category_link(dc_rate_id, dc_category_id, hms_occupancy_id)
	                                VALUES($dc_rate_id_int, $dc_room_id_int, '".$oc."')
																ON DUPLICATE KEY UPDATE hms_price_func_id = hms_price_func_id";
                                    $query = $this->db->query($sql);
                                }
                            }
                        }
                    }
                }
            }
            //die();
        }
    }

    public function get_bookings(array $data)
    {
        if ( !isset($data['reservations']) || empty($data['reservations']) ){
            return false;
        }

        $host = $this->releases->get_company_host(1);

        $overbooking_category_id = $this->hotelix_config->get_record('overbooking_category_id', 'int');

        /** DEDUPLICATION */
        foreach ($data['reservations'] as $reservation) {
            $reservations[$reservation['id']] = $reservation;
        }
        
        foreach ($reservations as $k => $reservation) {
            if ($this->debug) {
                echo "<h2 style='text-align: center'>{$reservation['id']}</h2>";
                echo "<br>";
            }
            $to_add = [];
            $to_update = [];
            $to_cancel = [];
            $not_found = [];
            $requests = []; /// Some OTA work per request -- TBD  ---- avoidtime, duetime
            $confirm = 0;
            $intgroupid = 0;

            $dc_hotel_id = $reservation['hotel_id'];
            $hms_property_id = explode('-', $dc_hotel_id)[2] ?? 0;
           
            if( $hms_property_id == 0 ){
                continue;
            }

            $default_service = $this->db
                ->where('name', 'service_type_id')
                ->where('dc_account_id', $hms_property_id)
                ->get('dc_su_xml_cfg')->row_array()['int_value'] ?? 1;

            $autocloseadjoined = $this->db
                ->where('dc_account_id', $hms_property_id)
                ->where('name', 'autoclose')
                ->get('dc_su_xml_cfg')->row_array()['int_value'] ?? 0;

            $existing_folios = $this->db
                            ->select('id, dc_uuid, dc_roomreservation_id, dc_updatetime, room_id, origin_categoryid')
                            ->where('deleted', 0)
                            ->where('dc_id', 40)
                            ->where('dc_uuid', $k)
                            ->get('deskofreservation')
                            ->result_array();

            if ($this->debug) {
                echo '============ EXISTING FOLIOS ========= ';
                echo '<br>';
                print_r($existing_folios);
                echo '<br>';
            }
            $checkin_checkout_arr = $this->frontdesk->get_check_in_out_time();
            $hotel_name_data = $this->internationalfields->get_value('property_custom', $hms_property_id, 'international_name');
            $hotel_name = $hotel_name_data[45] ?? stripslashes($this->db->get('logo')->row_array()['logo_title'] ?? '');
            $rooms_count = count($reservation['rooms']);      

            /** ROOMRESERVATIONS -> FOLIOS */
            foreach ($reservation['rooms'] as $room) {

                foreach ($existing_folios as $efk => $folio) {
                    if ($room['roomreservation_id'] == $folio['dc_roomreservation_id']) {
                        $room['hms_folio_id'] = $folio['id'];
                        $room['exist_key'] = $efk;
                    }
                }

                if (isset($room['hms_folio_id'])
                    && strtotime($existing_folios[$room['exist_key']]['dc_updatetime']) >= strtotime($reservation['processed_at'])
                ) {
                    $confirm = 1;
                    continue;
                } else {
                    $confirm = 0;
                }

                switch ($room['roomstaystatus']) {
                    case 'cancelled':
                        if (isset($room['hms_folio_id'])) {
                            $to_cancel[$room['roomreservation_id']] = $room;
                        } else {
                            $not_found[$room['roomreservation_id']] = $room;
                        }
                        break;
                    case 'modified':
                        if (isset($room['hms_folio_id'])) {
                            $to_update[$room['roomreservation_id']] = $room;
                        } else {
                            $to_add[$room['roomreservation_id']] = $room;
                        }
                        break;
                    case 'new':
                    default:
                        if (isset($room['hms_folio_id'])) {
                            $to_update[$room['roomreservation_id']] = $room;
                        } else {
                            $to_add[$room['roomreservation_id']] = $room;
                        }
                    break;
                }
            }

            /** GENERAL STATUS FOR EMAIL */
            if( empty($existing_folios) ){ 
                if( empty( $to_add ) && ! empty($to_cancel) ){
                    $general_status = 'cancel';
                } elseif( !empty( $to_add) && ! empty( $to_cancel) ) {
                    $general_status = 'modified';
                } else {
                    $general_status = 'new';
                }
            } else {
                if( ! empty( $to_update ) ){
                    $general_status = 'modified';
                } else {
                    $general_status = 'cancel';
                }
            }

            /** EMAIL GENERAL DATA */
            $logo_id = $this->db
                        ->where('channel_code', $reservation['affiliation']['OTA_Code'])
                        ->where_in('connection_type', ['Direct','Group Connection'])
                        ->get('global_hotelix.dc_su_channels')
                        ->row_array()['id'] ?? 0;
            
            $email_data = [
                'dcname' => $reservation['affiliation']['pos'],
                'status' => $general_status,
                'dc_reservationid' => $reservation['channel_booking_id'],
                'hotel_name' => $hotel_name,
                'host' => $host,
                'ota_code' => $logo_id,
                'room' => []
            ];

            if ($this->debug) {
                echo '============ TO ADD ========= ';
                echo '<br>';
                foreach($to_add as $fol){
                    echo "{$fol['roomreservation_id']}: {$fol['arrival_date']} - {$fol['departure_date']} - {$fol['id']}";
                    echo '<br>';
                };
                echo '<br>';
                echo '============ TO UPDATE ========= ';
                echo '<br>';
                foreach($to_update as $fol){
                    echo "{$fol['roomreservation_id']} ({$fol['hms_folio_id']}): {$fol['arrival_date']} - {$fol['departure_date']} - {$fol['id']}";
                    echo '<br>';
                };
                echo '<br>';
                echo '============ TO CANCEL ========= ';
                echo '<br>';
                foreach($to_cancel as $fol){
                    echo "{$fol['roomreservation_id']} ({$fol['hms_folio_id']}): {$fol['arrival_date']} - {$fol['departure_date']} - {$fol['id']}";
                    echo '<br>';
                };
                echo '<br>';
                echo '============ END HASHED ========= ';
                echo '<br>';
            }

            foreach ($to_cancel as $ck => $fol) {
                $confirm = 0;
                $su_cat = explode('-', $fol['id'])[2] ?? false;
                /** IF ROOM IS NOT CREATED WITH US -- PROBABLY WON'T ENTER HERE */
                if( ! $su_cat ){
                    $email_data['room'][$fol['roomreservation_id']] = [
                        'hms_reservation_id' => 0,
                        'url' => '#',
                        'host'  => $host,
                        'response' => 'error',
                        'text' => 'UNKNOWN CATEGORY',
                        'dcname' => $reservation['affiliation']['pos'],
                        'reservation_dc_reservationid' => $reservation['channel_booking_id'],
                        'reservation_dc_roomreservation_id' => $fol['roomreservation_id'],
                        'hotel_name' => $hotel_name,
                        'reservation_date' => $reservation['booked_at'],
                        'status'    => 'cancel',
                        'reservation_datein' => $fol['arrival_date'],
                        'reservation_dateout' => $fol['departure_date'], 
                        'reservation_type_name' => 'Unknown room type',
                        'reservation_category_id' => $su_cat,
                        'reservation_dc_totalprice' => $fol['totalprice'],
                        'reservation_dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),
                        'dc_rate_intdate_data' => [],
                        'guest_firstname' => $fol['first_name'],  
                        'guest_lastname' => $fol['last_name'],
                        'guest_phone'   => $reservation['customer']['telephone'],
                        'guest_email'   => $reservation['customer']['email']
                    ];
                    continue;
                }
                $category_data = $this->db->select('name')
                            ->where('id', $su_cat)
                            ->get('categories')
                            ->row_array();
                $penalty_data = $this->db->select('id')
                            ->where('reservation_id', $fol['hms_folio_id'])->where('type', 2)
                            ->get('services_main')->row();

                $hms_cat = $this->db
                                ->where('id', $existing_folios[$fol['exist_key']]['room_id'])
                                ->get('rooms')
                                ->row_array()['category_id'] ?? $overbooking_category_id;

                /** QUEUE FOR SU ROOM TYPE IF DIFFERS FROM LOCAL */
                if ($hms_cat != $su_cat && $existing_folios[$fol['exist_key']]['origin_categoryid'] != $su_cat) {
                    if( isset($category_data['name']) ){
                        $dc_log_data = [
                            'datein' => $fol['arrival_date'],
                            'dateout' => $fol['departure_date'],
                            'category_id' => $su_cat,
                        ];
                        $this->frontdesk->dc_log_update($dc_log_data);
                    }
                }

                $this->db->where('id', $fol['hms_folio_id'])->set('dc_updatetime', $reservation['processed_at'])->update('deskofreservation');

                /** IF ALREADY CANCELLED (IF CANCELLATION FEE APPLIED) */
                if ($penalty_data != null) {
                    /** QUEUE FOR SU ROOM TYPE */
                    if( isset($category_data['name']) ){
                        $dc_log_data = [
                            'datein' => $fol['arrival_date'],
                            'dateout' => $fol['departure_date'],
                            'category_id' => $su_cat,
                        ];
                        $this->frontdesk->dc_log_update($dc_log_data);
                    }
                    $email_data['room'][$fol['roomreservation_id']] = [
                        'hms_reservation_id' =>  $fol['hms_folio_id'],
                        'url' => 'https://' . $host . '/reservation_c2/folio/' . $fol['hms_folio_id'] . '/1',
                        'host'  => $host,
                        'response' => 'error',
                        'text' => 'Already cancelled',
                        'dcname' => $reservation['affiliation']['pos'],
                        'reservation_dc_reservationid' => $reservation['channel_booking_id'],
                        'reservation_dc_roomreservation_id' => $fol['roomreservation_id'],
                        'hotel_name' => $hotel_name,
                        'reservation_date' => $reservation['booked_at'],
                        'status'    => 'cancel',
                        'reservation_datein' => $fol['arrival_date'],
                        'reservation_dateout' => $fol['departure_date'], 
                        'reservation_type_name' => $category_data['name'],
                        'reservation_category_id' => $su_cat,
                        'reservation_dc_totalprice' => $fol['totalprice'],
                        'reservation_dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),
                        'dc_rate_intdate_data' => [],
                        'ota_code' => $reservation['affiliation']['OTA_Code'],
                        'guest_firstname' => $fol['first_name'],  
                        'guest_lastname' => $fol['last_name'],
                        'guest_phone'   => $reservation['customer']['telephone'],
                        'guest_email'   => $reservation['customer']['email']
                    ];
                    $confirm = 1;
                    continue;
                }
                /** ARRAY FOR CANCEL MODEL */
                $data_cancel = [
                    'res_id' => $fol['hms_folio_id'],
                    'charge' => 0,
                    'status' => 5,
                    'description' => 'Cancelled at '.$reservation['affiliation']['pos'],
                    'guestbe_request' => 0,
                    'user' => -1,
                ];
                $this->Cancel->Insert($data_cancel);

                $confirm = 1;
                $email_data['room'][$fol['roomreservation_id']] = [
                    'hms_reservation_id' =>  $fol['hms_folio_id'],
                    'url' => 'https://' . $host . '/reservation_c2/folio/' . $fol['hms_folio_id'] . '/1',
                    'host'  => $host,
                    'response' => 'ok',
                    'text' => '',
                    'dcname' => $reservation['affiliation']['pos'],
                    'reservation_dc_reservationid' => $reservation['channel_booking_id'],
                    'reservation_dc_roomreservation_id' => $fol['roomreservation_id'],
                    'hotel_name' => $hotel_name,
                    'reservation_date' => $reservation['booked_at'],
                    'status'    => 'cancel',
                    'reservation_datein' => $fol['arrival_date'],
                    'reservation_dateout' => $fol['departure_date'], 
                    'reservation_type_name' => $category_data['name'],
                    'reservation_category_id' => $su_cat,
                    'reservation_dc_totalprice' => $fol['totalprice'],
                    'reservation_dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),
                    'dc_rate_intdate_data' => [],
                    'guest_firstname' => $fol['first_name'],  
                    'guest_lastname' => $fol['last_name'],
                    'guest_phone'   => $reservation['customer']['telephone'],
                    'guest_email'   => $reservation['customer']['email']
                ];
            }

            foreach ($not_found as $fol) {
                $confirm = 0;
                $su_cat = explode('-', $fol['id'])[2] ?? false;
                /** IF ROOM IS NOT CREATED WITH US -- PROBABLY WON'T ENTER HERE */
                if( ! $su_cat ){
                    $email_data['room'][$fol['roomreservation_id']] = [
                        'hms_reservation_id' => 0,
                        'url' => '#',
                        'host'  => $host,
                        'response' => 'error',
                        'text' => 'UNKNOWN CATEGORY',
                        'dcname' => $reservation['affiliation']['pos'],
                        'reservation_dc_reservationid' => $reservation['channel_booking_id'],
                        'reservation_dc_roomreservation_id' => $fol['roomreservation_id'],
                        'hotel_name' => $hotel_name,
                        'reservation_date' => $reservation['booked_at'],
                        'status'    => 'cancel',
                        'reservation_datein' => $fol['arrival_date'],
                        'reservation_dateout' => $fol['departure_date'], 
                        'reservation_type_name' => 'Unknown room type',
                        'reservation_category_id' => $su_cat,
                        'reservation_dc_totalprice' => $fol['totalprice'],
                        'reservation_dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),
                        'dc_rate_intdate_data' => [],
                        'ota_code' => $reservation['affiliation']['OTA_Code'],
                        'guest_firstname' => $fol['first_name'],  
                        'guest_lastname' => $fol['last_name'],
                        'guest_phone'   => $reservation['customer']['telephone'],
                        'guest_email'   => $reservation['customer']['email']
                    ];
                }
                $category_data = $this->db->select('name')
                    ->where('id', $su_cat)
                    ->get('categories')
                    ->row_array();
                /** UPDATE SU CATEGORY INVENTORY IF CATEGORY EXIXTS  */
                if( isset($category_data['name']) ){
                    $dc_log_data = [
                        'datein' => $fol['arrival_date'],
                        'dateout' => $fol['departure_date'],
                        'category_id' => $su_cat,
                    ];
                    $this->frontdesk->dc_log_update($dc_log_data);
                }
                $email_data['room'][$fol['roomreservation_id']] = [
                    'hms_reservation_id' => 0,
                    'url' => '#',
                    'host'  => $host,
                    'response' => 'error',
                    'text' => 'Reservation not found',
                    'dcname' => $reservation['affiliation']['pos'],
                    'reservation_dc_reservationid' => $reservation['channel_booking_id'],
                    'reservation_dc_roomreservation_id' => $fol['roomreservation_id'],
                    'hotel_name' => $hotel_name,
                    'reservation_date' => $reservation['booked_at'],
                    'status'    => 'cancel',
                    'reservation_datein' => $fol['arrival_date'],
                    'reservation_dateout' => $fol['departure_date'], 
                    'reservation_type_name' => 'Unknown room type',
                    'reservation_category_id' => $su_cat,
                    'reservation_dc_totalprice' => $fol['totalprice'],
                    'reservation_dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),
                    'dc_rate_intdate_data' => [],
                    'ota_code' => $reservation['affiliation']['OTA_Code'],
                    'guest_firstname' => $fol['first_name'],  
                    'guest_lastname' => $fol['last_name'],
                    'guest_phone'   => $reservation['customer']['telephone'],
                    'guest_email'   => $reservation['customer']['email']
                ];
                $confirm = 1;
            }

            /** DIVIDE EXTRAFEES (RESERVATION LEVEL) TO FOLIOS */
            if (!empty($to_add) || !empty($to_update)) {
                $extrafees = [];
                if( !empty($reservation['extrafees']) ){                    
                    foreach ($reservation['extrafees'] as $ef) {
                        $extrafees[] = [
                            'name' => $ef['value'],
                            'price' => (float) $ef['amount'] / $rooms_count,
                        ];
                    }
                }
                /** GROUP ADDITION */
                $real_count = count($to_add) + count($to_update);
                if ( $real_count > 1) {
                    $group_name = $reservation['affiliation']['source'].'-'.$reservation['channel_booking_id'];
                    $intgroupid = $intgroupid == 0 ? $this->group_res_model->makenewid($group_name) : $intgroupid;
                    $group_id = $reservation['channel_booking_id'];
                }
            }

            foreach ($to_add as $fk => $fol) {
                $confirm = 0;
                $per_day_data = [];
                $su_cat = explode('-', $fol['id'])[2] ?? false;
                /** IF ROOM IS NOT CREATED WITH US -- PROBABLY WON'T ENTER HERE */
                if( ! $su_cat ){
                    $email_data['room'][$fol['roomreservation_id']] = [
                        'hms_reservation_id' => 0,
                        'url' => '#',
                        'host'  => $host,
                        'response' => 'error',
                        'text' => 'UNKNOWN CATEGORY',
                        'dcname' => $reservation['affiliation']['pos'],
                        'reservation_dc_reservationid' => $reservation['channel_booking_id'],
                        'reservation_dc_roomreservation_id' => $fol['roomreservation_id'],
                        'hotel_name' => $hotel_name,
                        'reservation_date' => $reservation['booked_at'],
                        'status'    => 'new',
                        'reservation_datein' => $fol['arrival_date'],
                        'reservation_dateout' => $fol['departure_date'], 
                        'reservation_type_name' => 'Unknown room type',
                        'reservation_category_id' => $su_cat,
                        'reservation_dc_totalprice' => $fol['totalprice'],
                        'reservation_dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),
                        'dc_rate_intdate_data' => [],
                        'ota_code' => $reservation['affiliation']['OTA_Code'],
                        'guest_firstname' => $fol['first_name'],  
                        'guest_lastname' => $fol['last_name'],
                        'guest_phone'   => $reservation['customer']['telephone'],
                        'guest_email'   => $reservation['customer']['email']
                    ];
                    continue;
                }
                $rates = [];
                $rate_names = [];
                $services = [];
                $su_cat = explode('-', $fol['id'])[2];

                $accomodation_price = 0;

                /** DAILY PRICING */
                foreach ($fol['price'] as $daily_price) {
                    $dc_rate_id = explode('-', $daily_price['rate_id'])[2] ?? '';

                    array_push($rates, $dc_rate_id);

                    $rate_name = $this->db
                                ->where('id', $dc_rate_id)
                                ->get('rate')
                                ->row_array()['caption'] ?? '';

                    $rate_names[$dc_rate_id] = $rate_name;

                    $accomodation_price += $daily_price['priceaftertax'];

                    $per_day_data[] = [
                        'dc_currencycode' => $reservation['currencycode'],
                        'dc_reservation_id' => $reservation['id'],
                        'price' => $daily_price['priceaftertax'],
                        'dc_rate_id' => $dc_rate_id,
                        'dc_rate_name' => $rate_name,
                        'intdate' => round(strtotime($daily_price['date']) / 86400),
                        'date_rate' => $daily_price['date'],
                    ];
                }
                $this->dc_rate_intdate_insert($per_day_data);

                /** DEFINE RATE FOR RESERVATION */
                $rates_quan = array_count_values($rates);
                if ($rates_quan > 1) {
                    $quan_rates = array_flip($rates_quan);
                    $dc_rate_id = $quan_rates[max($rates_quan)];
                }

                /** CALCULATE COMISSION FOR RESERVATION */
                if( ! empty($reservation['commissionamount']) ){
                    $comission =  ($reservation['commissionamount'] / $reservation['totalprice']) * $fol['totalprice'];
                } else {
                    $comission = 0;
                }

                /** EARLY CHECK-IN */
                $early_check_in_close = 0;
                if( $autocloseadjoined && ! empty($fol['eta']) ){
                    if( strtotime($fol['eta']) < strtotime($checkin_checkout_arr['checkintime'])){
                        $early_check_in_close = 1;
                    }
                }

                /** DEFINE ROOM OR CONTINUE */
                $category_data = $this->db->select('name, places')
                            ->where('id', $su_cat)
                            ->get('categories')
                            ->row_array();

                if( !isset($category_data['name']) ){
                    if( $overbooking_category_id > 0){
                        $category_id = $overbooking_category_id;
                        $room_id = $this->frontdesk->getfreeroomlist(
                            $fol['arrival_date'], 
                            $fol['departure_date'], 
                            $overbooking_category_id, 0, 0, $early_check_in_close, 0
                        );
                        if ($room_id == 0) {
                            $room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
                        }
                    } else {
                        $email_data['room'][$fol['roomreservation_id']] = [
                            'hms_reservation_id' => 0,
                            'url' => '#',
                            'host'  => $host,
                            'response' => 'error',
                            'text' => 'NO DEFINED OVERBOOKING CATEGORY!',
                            'dcname' => $reservation['affiliation']['pos'],
                            'reservation_dc_reservationid' => $reservation['channel_booking_id'],
                            'reservation_dc_roomreservation_id' => $fol['roomreservation_id'],
                            'hotel_name' => $hotel_name,
                            'reservation_date' => $reservation['booked_at'],
                            'status'    => 'new',
                            'reservation_datein' => $fol['arrival_date'],
                            'reservation_dateout' => $fol['departure_date'], 
                            'reservation_type_name' => 'Unknown room type',
                            'reservation_category_id' => $su_cat,
                            'reservation_dc_totalprice' => $fol['totalprice'],
                            'reservation_dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),
                            'dc_rate_intdate_data' => [],
                            'ota_code' => $reservation['affiliation']['OTA_Code'],
                            'guest_firstname' => $fol['first_name'],  
                            'guest_lastname' => $fol['last_name'],
                            'guest_phone'   => $reservation['customer']['telephone'],
                            'guest_email'   => $reservation['customer']['email']
                        ];
                        continue;
                    }
                } else {
                    $room_id = $this->frontdesk->getfreeroomlist(
                        $fol['arrival_date'], 
                        $fol['departure_date'], 
                        $su_cat, 0, 0, $early_check_in_close, 0
                    );
                    if( $room_id == 0 ){
                        if($overbooking_category_id > 0){
                            $category_id = $overbooking_category_id;
                            $room_id = $this->frontdesk->getfreeroomlist(
                                $fol['arrival_date'], 
                                $fol['departure_date'], 
                                $overbooking_category_id, 0, 0, $early_check_in_close, 0
                            );
                            if ($room_id == 0) {
                                $room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
                            }
                        } else {
                            $email_data['room'][$fol['roomreservation_id']] = [
                                'hms_reservation_id' => 0,
                                'url' => '#',
                                'host'  => $host,
                                'response' => 'error',
                                'text' => 'NO DEFINED OVERBOOKING CATEGORY!',
                                'dcname' => $reservation['affiliation']['pos'],
                                'reservation_dc_reservationid' => $reservation['channel_booking_id'],
                                'reservation_dc_roomreservation_id' => $fol['roomreservation_id'],
                                'hotel_name' => $hotel_name,
                                'reservation_date' => $reservation['booked_at'],
                                'status'    => 'new',
                                'reservation_datein' => $fol['arrival_date'],
                                'reservation_dateout' => $fol['departure_date'], 
                                'reservation_type_name' => 'Unknown room type',
                                'reservation_category_id' => $su_cat,
                                'reservation_dc_totalprice' => $fol['totalprice'],
                                'reservation_dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),
                                'dc_rate_intdate_data' => [],
                                'ota_code' => $reservation['affiliation']['OTA_Code'],
                                'guest_firstname' => $fol['first_name'],  
                                'guest_lastname' => $fol['last_name'],
                                'guest_phone'   => $reservation['customer']['telephone'],
                                'guest_email'   => $reservation['customer']['email']
                            ];
                            continue;
                        }
                    }   
                }

                $dealer = $this->dcm_su_api->get_su_dc_data($reservation['affiliation']['OTA_Code'], 'dealer_id', 'int', $hms_property_id);
                $add_places = $fol['numberofadults'] - $category_data['places'];
                
                /** PRICE, DISCOUNT */
                $calculate_data = [
                    'type_id' => $su_cat,
                    'datein'  => $fol['arrival_date'],
                    'dateout' => $fol['departure_date'],
                    'add_places' => $add_places,
                    'baby_places' => $fol['numberofchildren'],
                    'addbedplace' => 0,
                    'babyplace2' => 0,
                    'price_type' => $dc_rate_id,
                ];
                $temp_amount = $this->frontdesk->getpricecalculation($calculate_data);
                $otelms_amount = 0;
                for ($inc = 0; $inc < count($temp_amount); ++$inc) {
                    $otelms_amount += $temp_amount[$inc]['amount'];
                }
                if( ! $otelms_amount ){
                    $discount = $otelms_amount - $accomodation_price;
                }

                /** GUEST DATA */
                $guest_data = [
                    'firstname' => trim($fol['first_name']),
                    'lastname' => trim($fol['last_name']),
                ];
                if (
                    trim($fol['first_name']) == trim($reservation['customer']['first_name']) &&
                    trim($fol['last_name']) == trim($reservation['customer']['last_name'])
                ) {
                    $guest_data['email'] = $reservation['customer']['email'];
                    $guest_data['phone'] = $reservation['customer']['telephone'];
                    $guest_data['address'] = $reservation['customer']['address'];
                    $guest_data['country'] = $reservation['customer']['countrycode'];
                    $guest_data['city'] = $reservation['customer']['city'];
                } else {
                    $guest_data['email'] = '';
                    $guest_data['phone'] = '';
                    $guest_data['country'] = '';
                }
                $guest_id = $this->frontdesk->Guest_insert($guest_data);

                /** MAIN RESERVATION ARRAY */
                $folio_data = [
                    'dc_id' => 40,
                    'dc_uuid' => $reservation['id'],
                    'dc_roomreservation_id' => $fk,
                    'dc_reservation_id' => $reservation['channel_booking_id'],
                    'dc_date'   => $reservation['booked_at'] ?? '',
                    'dc_updatetime' => $reservation['processed_at'],
                    'dc_guestname' => $fol['guest_name'] ?? '',
                    'dc_numberofguest' => $fol['numberofguests'] ?? '',
                    'dc_currencycode' => $reservation['currencycode'] ?? '',
                    'dc_countrycode' => $reservation['customer']['countrycode'] ?? '',
                    'dc_city' => $reservation['customer']['city'] ?? '',
                    'dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),   
                    'dc_roomremarks' => $fol['booking_condition'],
                    'dc_source' => $reservation['affiliation']['pos'],
                    'dc_totalprice' => $accomodation_price,
                    'dc_rate_id' => $dc_rate_id,
                    'refferal_id' => $reservation['affiliation']['OTA_Code'],
                    'isNew' => 1,
                    'price_type' => $dc_rate_id,
                    'user' => $_SESSION['user']['id'] ?? -1,
                    'dealer' => $dealer,
                    'guest_id' => $guest_id,
                    'commission' => $comission,
                    'datein' => $fol['arrival_date'],
                    'dateout' => $fol['departure_date'],
                    'room_id' => $room_id,
                    'adults' => $fol['numberofadults'] > $category_data['places'] 
                        ? $category_data['places'] : $fol['numberofadults'],
                    'add_places' => $add_places,
                    'baby_places' => $fol['numberofchildren'],
                    'amount' => $accomodation_price,
                    'description' =>  $fol['specialrequest'],
                    'type_id' => $category_id ?? $su_cat,
                    'reservation_type_name' => $category_data['name'],
                    'checkintime' => ! empty( $fol['eta'] ) ? date('H:i', strtotime($fol['eta'])) : $checkin_checkout_arr['checkintime'],
                ];

                /** EARLY CHECK-IN */
                if($early_check_in_close){
                    $folio_data['early_check_in_close'] = 1;
                }

                if( isset($category_id) ){
                    $folio_data['origin_categoryid'] = isset( $category_data['name'] ) ? $su_cat : 0;
                    unset( $category_id );
                }

                /** GROUP */
                if( $intgroupid > 0 ){
                    $folio_data['intgroupid'] = $intgroupid;
                    $folio_data['group_id'] = $group_id;
                }

                /** PRICING TYPE, DISCOUNT */
                if( isset($discount) ){
                    $folio_data['discount'] = $discount;
                    $folio_data['service_main_amount_2'] = 2;
                }

                if ($this->debug) {
                    echo '<br>================= NEW FOLIO DATA ===================<br>';
                    print_r($folio_data);
                    echo '<br>================= NEW FOLIO DATA END ===================<br>';
                }

                $hms_reservation_id = $this->frontdesk->Reservation_insert($folio_data, $guest_id, 0, 1);

                /** FINAL UPDATES FOR RESERVATION IF EXISTS */
                if ($hms_reservation_id > 0) {
                    /** CREDIT CARD DATA */
                    if( !empty($reservation['customer']['cc_number'])){
                        $vcc_expiration_date = $reservation['customer']['vcc_expiration_date'];
                        $cc_expiration_date = $reservation['customer']['cc_expiration_date'];
                        $cc_exp_year = '';
                        $cc_exp_month = '';
                        if ($vcc_expiration_date != '') {
                            list($cc_exp_year, $cc_exp_month, $cc_exp_day) = explode('-', $vcc_expiration_date);
                        } elseif ($cc_expiration_date != '') {
                            $cc_exp_year = substr($cc_expiration_date, 2);
                            $cc_exp_month = substr($cc_expiration_date, 0, 2);
                        }
        
                        $card_data = [
                            'cc_cvc' => $reservation['customer']['cc_cvc'],
                            'ExpMonth' => $cc_exp_month,
                            'ExpYear' => $cc_exp_year,
                            'CardHolder' => $reservation['customer']['cc_name'],
                            'CardNumber' => $reservation['customer']['cc_number'],
                            'cc_type' => $reservation['customer']['cc_type'],
                        ];

                        $this->frontdesk->insert_tbl_CreditCards($card_data, $guest_id, $hms_reservation_id);
                    }
                    
                    /** ADDITIONAL SERVICES, EXCLUDED TAXES, FEES */
                    foreach ($fol['extracomponents'] as $tf) {
                        $hms_service = $this->db->like('name', $tf['name'])->get('services_types')->row_array()['id'] ?? $default_service;
                        $services[] = [
                            'dc_uuid' => "{$reservation['id']}_$fk",
                            'name' => $tf['name'],
                            'nights' => 1,
                            'persons' => 1,
                            'type' => $hms_service,
                            'price_per_unit' => $tf['value'],
                            'totalprice' => $tf['value'],
                            'addons_date' => $fol['arrival_date'],
                            'dealer'    => $dealer,
                        ];
                    }

                    foreach ($extrafees as $ef) {
                        $services[] = [
                            'dc_uuid' => "{$reservation['id']}_$fk",
                            'name' => $ef['name'],
                            'nights' => 1,
                            'persons' => 1,
                            'type' => $default_service,
                            'price_per_unit' => $ef['price'],
                            'totalprice' => $ef['price'],
                            'addons_date' => $fol['arrival_date'],
                            'dealer'    => $dealer,
                        ];
                    }

                    foreach ($fol['addons'] as $add) {
                        $hms_service = $this->db->like('name', $add['name'])->get('services_types')->row_array()['id'] ?? $default_service;

                        switch ($add['pricemode']) {
                            case 1:
                            case 5:
                                $services[] = [
                                    'dc_uuid' => "{$reservation['id']}_$fk",
                                    'name' => $add['value'],
                                    'nights' => 1,
                                    'persons' => 1,
                                    'type' => $hms_service,
                                    'price_per_unit' => $add['price'],
                                    'totalprice' => $add['value'],
                                    'addons_date' => $fol['arrival_date'],
                                    'dealer'    => $dealer,
                                ];
                                break;
                            case 2:
                                $services[] = [
                                    'dc_uuid' => "{$reservation['id']}_$fk",
                                    'name' => $add['value'],
                                    'nights' => 1,
                                    'persons' => $fol['numberofguests'],
                                    'type' => $hms_service,
                                    'price_per_unit' => $add['price'],
                                    'totalprice' => $add['value'],
                                    'addons_date' => $fol['arrival_date'],
                                    'dealer'    => $dealer,
                                ];
                                break;
                            case 3:
                            case 6:
                                $services[] = [
                                    'dc_uuid' => "{$reservation['id']}_$fk",
                                    'name' => $add['value'],
                                    'nights' => $add['nights'],
                                    'persons' => 1,
                                    'type' => $hms_service,
                                    'price_per_unit' => $add['price'],
                                    'totalprice' => $add['value'],
                                    'addons_date' => $fol['arrival_date'],
                                    'dealer'    => $dealer,
                                ];
                                break;
                            case 4:
                                foreach ($fol['price'] as $daily_price) {
                                    $services[] = [
                                        'dc_uuid' => "{$reservation['id']}_$fk",
                                        'name' => $add['value'],
                                        'nights' => 1,
                                        'persons' => $fol['numberofguests'],
                                        'type' => $hms_service,
                                        'price_per_unit' => $add['price'],
                                        'totalprice' => $add['value'],
                                        'addons_date' => $daily_price['date'],
                                        'dealer'    => $dealer,
                                    ];
                                }
                                break;
                        }
                    }

                    foreach( $fol['taxes'] as $tax){
                        if( $tax['type'] ?? '' == 'Inclusive') continue;
                        $services[] = [
                            'dc_uuid' => "{$reservation['id']}_$fk",
                            'name' => $tax['value'],
                            'nights' => 1,
                            'persons' => 1,
                            'type' => $default_service,
                            'price_per_unit' => $tax['price'],
                            'totalprice' => $tax['value'],
                            'addons_date' => $fol['arrival_date'],
                            'dealer'    => $dealer,
                        ];
                    }

                    $this->add_addons($services, $hms_reservation_id);

                    $email_data['room'][$fol['roomreservation_id']] = [
                        'hms_reservation_id' => $hms_reservation_id,
                        'url' => 'https://' . $host . '/reservation_c2/folio/' . $hms_reservation_id . '/1',
                        'host'  => $host,
                        'response' => '',
                        'text'  => '',
                        'dcname' => $reservation['affiliation']['pos'],
                        'reservation_dc_reservationid' => $reservation['channel_booking_id'],
                        'reservation_dc_roomreservation_id' => $fol['roomreservation_id'],
                        'hotel_name' => $hotel_name,
                        'reservation_date' => $reservation['booked_at'],
                        'status'    => 'new',
                        'reservation_datein' => $fol['arrival_date'],
                        'reservation_dateout' => $fol['departure_date'], 
                        'reservation_type_name' => $category_data['name'],
                        'reservation_category_id' => $su_cat,
                        'reservation_dc_totalprice' => $fol['totalprice'],
                        'reservation_dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),
                        'dc_rate_intdate_data' => $per_day_data,
                        'ota_code' => $reservation['affiliation']['OTA_Code'],
                        'guest_firstname' => $fol['first_name'],  
                        'guest_lastname' => $fol['last_name'],
                        'guest_phone'   => $reservation['customer']['telephone'],
                        'guest_email'   => $reservation['customer']['email']
                    ];
                    $confirm = 1;
                    
                } else {
                    $email_data['room'][$fol['roomreservation_id']] = [
                        'hms_reservation_id' => 0,
                        'url' => '#',
                        'host'  => $host,
                        'response' => 'error',
                        'text' => 'An error has occured. Please contact Support Team',
                        'dcname' => $reservation['affiliation']['pos'],
                        'reservation_dc_reservationid' => $reservation['channel_booking_id'],
                        'reservation_dc_roomreservation_id' => $fol['roomreservation_id'],
                        'hotel_name' => $hotel_name,
                        'reservation_date' => $reservation['booked_at'],
                        'status'    => 'new',
                        'reservation_datein' => $fol['arrival_date'],
                        'reservation_dateout' => $fol['departure_date'], 
                        'reservation_type_name' => 'Unknown room type',
                        'reservation_category_id' => $su_cat,
                        'reservation_dc_totalprice' => $fol['totalprice'],
                        'reservation_dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),
                        'dc_rate_intdate_data' => [],
                        'ota_code' => $reservation['affiliation']['OTA_Code'],
                        'guest_firstname' => $fol['first_name'],  
                        'guest_lastname' => $fol['last_name'],
                        'guest_phone'   => $reservation['customer']['telephone'],
                        'guest_email'   => $reservation['customer']['email']
                    ];
                    $confirm = 0;
                }
            }

            foreach ($to_update as $fk => $fol) {
                $confirm = 0;
                $per_day_data = [];
                $accomodation_price = 0;
                $su_cat = explode('-', $fol['id'])[2] ?? false;
                /** IF ROOM IS NOT CREATED WITH US -- PROBABLY WON'T ENTER HERE */
                if( ! $su_cat ){
                    $email_data['room'][$fol['roomreservation_id']] = [
                        'hms_reservation_id' => 0,
                        'url' => '#',
                        'host'  => $host,
                        'response' => 'error',
                        'text' => 'UNKNOWN CATEGORY',
                        'dcname' => $reservation['affiliation']['pos'],
                        'reservation_dc_reservationid' => $reservation['channel_booking_id'],
                        'reservation_dc_roomreservation_id' => $fol['roomreservation_id'],
                        'hotel_name' => $hotel_name,
                        'reservation_date' => $reservation['booked_at'],
                        'status'    => 'modified',
                        'reservation_datein' => $fol['arrival_date'],
                        'reservation_dateout' => $fol['departure_date'], 
                        'reservation_type_name' => 'Unknown room type',
                        'reservation_category_id' => $su_cat,
                        'reservation_dc_totalprice' => $fol['totalprice'],
                        'reservation_dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),
                        'dc_rate_intdate_data' => [],
                        'ota_code' => $reservation['affiliation']['OTA_Code'],
                        'guest_firstname' => $fol['first_name'],  
                        'guest_lastname' => $fol['last_name'],
                        'guest_phone'   => $reservation['customer']['telephone'],
                        'guest_email'   => $reservation['customer']['email']
                    ];
                    continue;
                }
                $need_update = false;
                $hms_data = $this->frontdesk->GetReservation($fol['hms_folio_id']);
                if( $this->debug && false){
                    ksort($hms_data);
                    echo '<table align="center"><tr><td> HMS </td><td> SU </td></tr><tr><td><pre>';
                    print_r( $hms_data );
                    echo '</td><td><pre>';
                    print_r($reservation['customer']);
                    echo '<br>';
                    print_r( $fol );
                    echo '</td></tr></table>';

                }

                $category_data = $this->db->select('name, places')
                    ->where('id', $su_cat)
                    ->get('categories')
                    ->row_array();

                /** IF DATES DIFFER */
                if( $fol['departure_date'] != $hms_data['dateout']
                    || $fol['arrival_date'] != $hms_data['datein']
                ){
                    $need_update = true;
                    $hms_data['datein'] = $fol['arrival_date'];
                    $hms_data['dateout'] = $fol['departure_date'];
                    if( $this->debug ){
                        echo '<br>';
                        echo "Dates changed";
                        echo '<br>';
                    }
                }

                /** IF CHECKIN TIME DIFFERS */
                if( ! empty($fol['eta']) && date('H:i', strtotime($fol['eta'])) != $hms_data['checkintime']){
                    $need_update = true;
                    $hms_data['checkintime'] = date('H:i', strtotime($fol['eta']));
                    if( $this->debug ){
                        echo '<br>';
                        echo "Time changed";
                        echo '<br>';
                    }
                }

                /** IF ROOM DIFFERS */
                $category_id = isset($category_data['name']) ? $su_cat : $overbooking_category_id;

                if( $su_cat != $hms_data['type_id'] && $su_cat != $hms_data['origin_categoryid']){
                    $need_update = true;
                    $hms_data['origin_categoryid'] = isset( $category_data['name'] ) ? $su_cat : 0;
                    $hms_data['reservation_type_name'] = $category_data['name'] ?? '';
                    if( $this->debug ){
                        echo '<br>';
                        echo "Category changed";
                        echo '<br>';
                    }
                }

                /** IF GUEST OR CUSTOMER DATA DIFFERS */
                if (
                    trim($fol['first_name']) == trim($reservation['customer']['first_name']) &&
                    trim($fol['last_name']) == trim($reservation['customer']['last_name'])
                ) {
                    if( $hms_data['dc_guestname'] != trim($fol['guest_name'])
                        || $hms_data['dc_city'] != $reservation['customer']['city']
                        || $hms_data['dc_countrycode'] != $reservation['customer']['countrycode']
                        || $hms_data['phone'] != $reservation['customer']['telephone']
                        || $hms_data['email'] != $reservation['customer']['email']
                    ) {
                        $need_update = true;
                        $hms_data['dc_guestname'] = $fol['guest_name'];
                        $hms_data['firstname'] = $fol['first_name'];
                        $hms_data['lastname'] = $fol['last_name'];
                        $hms_data['guest_id_new'] = 0;
                        $hms_data['dc_city'] = $reservation['customer']['city'];
                        $hms_data['dc_countrycode'] = $reservation['customer']['countrycode'];
                        $hms_data['phone'] = $reservation['customer']['telephone'];
                        $hms_data['email'] = $reservation['customer']['email'];
                        if( $this->debug ){
                            echo '<br>';
                            echo "Guest data changed";
                            echo '<br>';
                        }
                    }
                } else {
                    if( $hms_data['dc_guestname'] != trim($fol['guest_name']) ) {
                        $need_update = true;
                        $hms_data['dc_guestname'] = $fol['guest_name'];
                        $hms_data['firstname'] = $fol['first_name'];
                        $hms_data['lastname'] = $fol['last_name'];
                        $hms_data['guest_id_new'] = 0;
                        if( $this->debug ){
                            echo '<br>';
                            echo "Guest data changed";
                            echo '<br>';
                        }
                    }
                }

                /** IF NUMBER OF GUESTS CHANGE */
                $add_places = $fol['numberofadults'] - $category_data['places'];
                $adults = $fol['numberofadults'] > $category_data['places'] ? $category_data['places'] : $fol['numberofadults'];
                if( 
                    $hms_data['adults'] != $adults 
                    || $hms_data['baby_places'] != $fol['numberofchildren']
                    || $hms_data['add_places'] != $add_places
                ){
                    $need_update = 1;
                    $hms_data['adults'] = $fol['numberofadults'] > $category_data['places'] 
                        ? $category_data['places'] : $fol['numberofadults'];
                    $hms_data['add_places'] = $add_places;
                    $hms_data['baby_places'] = $fol['numberofchildren'];
                    if( $this->debug ){
                        echo '<br>';
                        echo "Number of guests changed";
                        echo '<br>';
                    }
                }

                /** IF RATE CHANGED */
                $rates = [];
                foreach ($fol['price'] as $daily_price) {
                    $dc_rate_id = explode('-', $daily_price['rate_id'])[2] ?? '';

                    array_push($rates, $dc_rate_id);

                    $rate_name = $this->db
                                ->where('id', $dc_rate_id)
                                ->get('rate')
                                ->row_array()['caption'] ?? '';

                    $rate_names[$dc_rate_id] = $rate_name;

                    $accomodation_price += $daily_price['priceaftertax'];

                    $per_day_data[] = [
                        'dc_currencycode' => $reservation['currencycode'],
                        'dc_reservation_id' => $reservation['id'],
                        'price' => $daily_price['priceaftertax'],
                        'dc_rate_id' => $dc_rate_id,
                        'dc_rate_name' => $rate_name,
                        'intdate' => round(strtotime($daily_price['date']) / 86400),
                        'date_rate' => $daily_price['date'],
                    ];
                }
                $rates_quan = array_count_values($rates);
                if (count($rates_quan) > 1) {
                    $quan_rates = array_flip($rates_quan);
                    $dc_rate_id = $quan_rates[max($rates_quan)];
                }
                if( $hms_data['price_type'] != $dc_rate_id ){
                    $need_update = 1;
                    $hms_data['price_type'] = $dc_rate_id;
                }

                /** IF AMOUNT CHANGED */
                if( $hms_data['dc_totalprice'] != $accomodation_price ){
                    $need_update = 1;
                    $hms_data['dc_totalprice'] = $accomodation_price;
                }

                /** IF DESCRIPTION CHANGED */
                if( $hms_data['dc_customerremarks'] != 
                    trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest'])
                    || $hms_data['description'] !=  $fol['specialrequest']
                ){
                    $hms_data['dc_customerremarks'] = trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']);
                    $hms_data['description'] =  $fol['specialrequest'];
                }

                /** IF ADDED TO THE GROUP */
                if( $intgroupid > 0 && $hms_data['intgroupid'] != $intgroupid){
                    $need_update = 1;
                    $hms_data['intgroupid'] = $intgroupid;
                    $hms_data['group_id'] = $group_id;
                }

                if( $need_update ){
                    $early_check_in_close = 0;
                    $hms_data['dc_updatetime'] = $reservation['processed_at'];
                    
                    if( $autocloseadjoined && ! empty($fol['eta']) ){
                        if( strtotime($fol['eta']) < strtotime($checkin_checkout_arr['checkintime'])){
                            $early_check_in_close = 1;
                        }
                    }
                    if( $hms_data['type_id'] == $category_id ){
                        $can_resize = $this->frontdesk->qd_canresize(
                            $hms_data['reservation_id'], 
                            $fol['arrival_date'],
                            $fol['departure_date'],
                            $early_check_in_close, 
                            0
                        );
                    } else {
                        $can_resize = 0;
                        $hms_data['type_id'] = $category_id;
                    }
                   
                    $email_data['room'][$fol['roomreservation_id']] = [
                        'hms_reservation_id' =>  $fol['hms_folio_id'],
                        'url' => 'https://' . $host . '/reservation_c2/folio/' . $fol['hms_folio_id'] . '/1',
                        'host'  => $host,
                        'response' => 'ok',
                        'text' => '',
                        'dcname' => $reservation['affiliation']['pos'],
                        'reservation_dc_reservationid' => $reservation['channel_booking_id'],
                        'reservation_dc_roomreservation_id' => $fol['roomreservation_id'],
                        'hotel_name' => $hotel_name,
                        'reservation_date' => $reservation['booked_at'],
                        'status'    => 'modified',
                        'reservation_datein' => $fol['arrival_date'],
                        'reservation_dateout' => $fol['departure_date'], 
                        'reservation_type_name' => $category_data['name'],
                        'reservation_category_id' => $su_cat,
                        'reservation_dc_totalprice' => $fol['totalprice'],
                        'reservation_dc_customerremarks' => trim(explode('|', $reservation['customer']['remarks'])[0] ?? $fol['specialrequest']),
                        'dc_rate_intdate_data' => [],
                        'ota_code' => $reservation['affiliation']['OTA_Code'],
                        'guest_firstname' => $fol['first_name'],  
                        'guest_lastname' => $fol['last_name'],
                        'guest_phone'   => $reservation['customer']['telephone'],
                        'guest_email'   => $reservation['customer']['email']
                    ];

                    if( $can_resize ){
                        $this->service_model->DeleteServicesDc($hms_data['reservation_id']);
                        $update_res = $this->frontdesk->UpdateReservation($hms_data, 0, 1);
                       
                        if ($update_res == 'FreeError') {
                            $email_data['room'][$fol['roomreservation_id']]['response'] =  'error';
                            $email_data['room'][$fol['roomreservation_id']]['text'] =  'An error has occured. Please contact Support Team';
                            $confirm = 0;
                            continue;
                        }
                    } else {
                        if( $hms_data['type_id'] == 0 ){
                            $email_data['room'][$fol['roomreservation_id']]['response'] =  'error';
                            $email_data['room'][$fol['roomreservation_id']]['text'] =  'Undefined room';
                            $confirm = 0;
                            continue;
                        }
                        $room_id = $this->frontdesk->getfreeroomlist(
                            $fol['arrival_date'], 
                            $fol['departure_date'], 
                            $su_cat, 0, 0, $early_check_in_close, 0
                        );
                        if( $room_id == 0 ){
                            $hms_data['origin_categoryid'] = isset( $category_data['name'] ) ? $su_cat : 0;
                            if($overbooking_category_id > 0){
                                $hms_data['type_id'] = $overbooking_category_id;
                                $room_id = $this->frontdesk->getfreeroomlist(
                                    $fol['arrival_date'], 
                                    $fol['departure_date'], 
                                    $overbooking_category_id, 0, 0, $early_check_in_close, 0
                                );
                                if ($room_id == 0) {
                                    $room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
                                }
                            } else {
                                $$email_data['room'][$fol['roomreservation_id']]['response'] =  'error';
                                $email_data['room'][$fol['roomreservation_id']]['text'] =  'NO OVERBOOKING CATEGORY DEFINED!';
                                continue;
                            }
                        }
                        $this->service_model->DeleteServicesDc($hms_data['reservation_id']);
                        $update_res = $this->frontdesk->UpdateReservation($hms_data, 0, 1);
                    }

                    if( $su_cat != $hms_data['type_id'] && isset($category_data['name']) ){
                        $dc_log_data = [
                            'datein' => $fol['arrival_date'],
                            'dateout' => $fol['departure_date'],
                            'category_id' => $su_cat,
                        ];
                        $this->frontdesk->dc_log_update($dc_log_data);
                    }
                    $confirm = 1;
                }

                if( $confirm ){
                    $dealer = $hms_data['dealer'];
                     /** ADDITIONAL SERVICES, EXCLUDED TAXES, FEES */
                     foreach ($fol['extracomponents'] as $tf) {
                        $hms_service = $this->db->like('name', $tf['name'])->get('services_types')->row_array()['id'] ?? $default_service;
                        $services[] = [
                            'dc_uuid' => "{$reservation['id']}_$fk",
                            'name' => $tf['name'],
                            'nights' => 1,
                            'persons' => 1,
                            'type' => $hms_service,
                            'price_per_unit' => $tf['value'],
                            'totalprice' => $tf['value'],
                            'addons_date' => $fol['arrival_date'],
                            'dealer'    => $dealer,
                        ];
                    }

                    foreach ($extrafees as $ef) {
                        $services[] = [
                            'dc_uuid' => "{$reservation['id']}_$fk",
                            'name' => $ef['name'],
                            'nights' => 1,
                            'persons' => 1,
                            'type' => $default_service,
                            'price_per_unit' => $ef['price'],
                            'totalprice' => $ef['price'],
                            'addons_date' => $fol['arrival_date'],
                            'dealer'    => $dealer,
                        ];
                    }

                    foreach ($fol['addons'] as $add) {
                        $hms_service = $this->db->like('name', $add['name'])->get('services_types')->row_array()['id'] ?? $default_service;

                        switch ($add['pricemode']) {
                            case 1:
                            case 5:
                                $services[] = [
                                    'dc_uuid' => "{$reservation['id']}_$fk",
                                    'name' => $add['value'],
                                    'nights' => 1,
                                    'persons' => 1,
                                    'type' => $hms_service,
                                    'price_per_unit' => $add['price'],
                                    'totalprice' => $add['value'],
                                    'addons_date' => $fol['arrival_date'],
                                    'dealer'    => $dealer,
                                ];
                                break;
                            case 2:
                                $services[] = [
                                    'dc_uuid' => "{$reservation['id']}_$fk",
                                    'name' => $add['value'],
                                    'nights' => 1,
                                    'persons' => $fol['numberofguests'],
                                    'type' => $hms_service,
                                    'price_per_unit' => $add['price'],
                                    'totalprice' => $add['value'],
                                    'addons_date' => $fol['arrival_date'],
                                    'dealer'    => $dealer,
                                ];
                                break;
                            case 3:
                            case 6:
                                $services[] = [
                                    'dc_uuid' => "{$reservation['id']}_$fk",
                                    'name' => $add['value'],
                                    'nights' => $add['nights'],
                                    'persons' => 1,
                                    'type' => $hms_service,
                                    'price_per_unit' => $add['price'],
                                    'totalprice' => $add['value'],
                                    'addons_date' => $fol['arrival_date'],
                                    'dealer'    => $dealer,
                                ];
                                break;
                            case 4:
                                foreach ($fol['price'] as $daily_price) {
                                    $services[] = [
                                        'dc_uuid' => "{$reservation['id']}_$fk",
                                        'name' => $add['value'],
                                        'nights' => 1,
                                        'persons' => $fol['numberofguests'],
                                        'type' => $hms_service,
                                        'price_per_unit' => $add['price'],
                                        'totalprice' => $add['value'],
                                        'addons_date' => $daily_price['date'],
                                        'dealer'    => $dealer,
                                    ];
                                }
                                break;
                        }
                    }

                    foreach( $fol['taxes'] as $tax){
                        if( $tax['type'] ?? '' == 'Inclusive') continue;
                        $services[] = [
                            'dc_uuid' => "{$reservation['id']}_$fk",
                            'name' => $tax['value'],
                            'nights' => 1,
                            'persons' => 1,
                            'type' => $default_service,
                            'price_per_unit' => $tax['price'],
                            'totalprice' => $tax['value'],
                            'addons_date' => $fol['arrival_date'],
                            'dealer'    => $dealer,
                        ];
                    }

                    $this->del_addons($fk);
                    $this->add_addons($services, $fol['hms_folio_id']);
                }
            }

            if ($confirm) {
                $confirm_data = [
                    'debug' => 1,
                    'dc_hotel_id' => $reservation['hotel_id'],
                    'reservation_notif_id' => $reservation['reservation_notif_id'],
                ];
                $this->confirm_booking($confirm_data);
            }

            if( ! empty($email_data['room']) ) {
                print_r( $email_data );
                $this->dc_model->send_notifyarray_new($email_data);
            }
        }
    }

    public function get_bookings_OLD($data, $account_data = [], $db_name = '')
    {
        if (!isset($data['reservations'])) {
            print_r('No reservations');

            return false;
        }

        $rates = [];
        $query = $this->db->query('SELECT hms_rate_id, dc_su_rates_strtoint.dc_rate_id, dc_su_categories_strtoint.dc_room_id as dc_category_id 
                    FROM dc_su_rate2category_link
                    INNER JOIN dc_su_categories_strtoint ON dc_su_categories_strtoint.id = dc_su_rate2category_link.dc_category_id
                    INNER JOIN dc_su_rates_strtoint ON dc_su_rates_strtoint.id = dc_su_rate2category_link.dc_rate_id');
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $rates[$row->dc_rate_id][$row->dc_category_id] = $row->hms_rate_id;
            }
        }

        $rates_names = [];
        $query = $this->db->query('SELECT name, dc_rate_id FROM  dc_su_rates');
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $rates_names[$row->dc_rate_id]['dc_rate_name'] = $row->name;
            }
        }

        $categories = [];
        $query = $this->db->query('SELECT dc_su_categories_strtoint.dc_room_id as dc_category_id, hms_category_id 
                        FROM dc_su_room_categories_link 
                        INNER JOIN dc_su_categories_strtoint ON dc_su_categories_strtoint.id = dc_su_room_categories_link.dc_category_id');

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $categories[$row->dc_category_id] = $row->hms_category_id;
            }
        }

        $categories_names = [];
        $query = $this->db->query('SELECT id, name FROM categories');

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $categories_names[$row->id] = $row->name;
            }
        }

        $query = $this->db->query('SELECT id FROM rate WHERE isdefault = 1');
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $price_type = $row->id;
        }

        /*
            $query = $this->db->query("SELECT su_dc_id,  int_value FROM dc_su_data WHERE name = 'dealer_id'");
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $dealer = $row->int_value;
            }
        */

        $query = $this->db->query("SELECT int_value FROM dc_su_xml_cfg WHERE name LIKE 'overbooking_category_id'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $overbooking_category_id = $row->int_value;
        }

        /*
            $autoclosedaychicho = 0;
            $query = $this->db->query("SELECT int_value FROM dc_su_xml_cfg WHERE name LIKE 'autoclosedaychicho'");
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $autoclosedaychicho = $row->int_value;
            }
        */
        //$timezone = '';
        $query = $this->db->query("SELECT str_value FROM hotelix_config WHERE name LIKE 'timezone'");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $timezone = $row->str_value;
        } else {
            $timezone = 'UTC';
        }

        $checkin_checkout_arr = $this->frontdesk->get_check_in_out_time();

        //$su_channels = $this->dcm_su_api->get_su_channels();

        $result_array = [];

        if (isset($data['reservations'])) {
            $reservations = [];
            if (isset($data['reservations'][0])) {
                if (!empty($data['reservations'])) {
                    $reservations = $data['reservations'];
                }
            } else {
                if (!empty($data['reservations'])) {
                    $reservations[0] = $data['reservations'];
                }
            }

            $counter = 0;
            $create_intgroup_bool = 0;

            if ($this->debug) {
                echo '============ RESERVATIONS ========= ';
                echo '<br>';
                print_r($reservations);
                echo '<br>';
            }
            $otelms_rooms = [];
            $dc_reservation = [];
            foreach ($reservations as $reservation) {
                $reservation['booking_id'] = $reservation['id'];
                $reservation_notif_id = $reservation['reservation_notif_id'];
                $dc_hotel_id = $reservation['hotel_id'];
                $hms_property_id = explode('-', $dc_hotel_id)[2] ?? '';

                $dc_reservation[$counter]['dc_hotel_id'] = $dc_hotel_id;
                $dc_reservation[$counter]['reservation_notif_id'] = $reservation_notif_id;
                $sql = "SELECT id, dc_uuid FROM deskofreservation WHERE deleted = 0 AND cancel = 0 AND dc_id = 40 AND dc_uuid LIKE '".$reservation['booking_id']."%'";
                $query = $this->db->query($sql);

                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $row) {
                        $otelms_rooms[$reservation['booking_id']][$row->dc_uuid]['otelms_reservation_id'] = $row->id;
                        $otelms_rooms[$reservation['booking_id']][$row->dc_uuid]['dc_uuid'] = $row->dc_uuid;
                        $otelms_rooms[$reservation['booking_id']][$row->dc_uuid]['status'] = 0;
                    }
                }
                if ($this->debug) {
                    echo '============ OTELMS ROOMS ========= ';
                    echo '<br>';
                    print_r($otelms_rooms);
                    echo '<br>';
                }

                $rooms_data = [];
                if (!isset($reservation['rooms'][0])) {
                    $rooms_data[0] = $reservation['rooms'];
                } else {
                    $rooms_data = $reservation['rooms'];
                }

                if ($this->debug) {
                    echo '============ ROOMS DATA ========= ';
                    echo '<br>';
                    print_r($rooms_data);
                    echo '<br>';
                }

                $qty = count($rooms_data);
                for ($j = 0; $j < $qty; ++$j) {
                    $dc_room_id = $rooms_data[$j]['id'];
                    $dc_roomreservation_id = $rooms_data[$j]['roomreservation_id'];
                    $dc_total_price = 0;
                    $k = 0;
                    $PerDay_data = [];
                    if (!isset($rooms_data[$j]['price'][0])) {
                        $PerDay_data[0] = $rooms_data[$j]['price'];
                    } else {
                        $PerDay_data = $rooms_data[$j]['price'];
                    }
                    $datein = $rooms_data[$j]['arrival_date'];
                    $dateout = $rooms_data[$j]['departure_date'];
                    foreach ($PerDay_data as $daily_price) {
                        $date = $daily_price['date'];
                        $dc_rate_id = $daily_price['rate_id'];
                        $result_array['reservations'][$counter][$j]['per_day'][$k]['dc_currencycode'] = $reservation['currencycode'];
                        $result_array['reservations'][$counter][$j]['per_day'][$k]['dc_reservation_id'] = $reservation['booking_id'];
                        $result_array['reservations'][$counter][$j]['per_day'][$k]['price'] = $daily_price['priceaftertax'];
                        $result_array['reservations'][$counter][$j]['per_day'][$k]['dc_rate_id'] = '';

                        $result_array['reservations'][$counter][$j]['per_day'][$k]['dc_rate_name'] = $rates_names[$dc_rate_id]['dc_rate_name'] ?? '';
                        if (trim($date) != '') {
                            list($year, $month, $day) = explode('-', $date);
                            $intdate = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                        } else {
                            $intdate = '';
                        }
                        $result_array['reservations'][$counter][$j]['per_day'][$k]['intdate'] = $intdate;
                        $result_array['reservations'][$counter][$j]['per_day'][$k]['date_rate'] = $date;
                        if (isset($rates[$dc_rate_id][$dc_room_id])) {
                            $price_type = $rates[$dc_rate_id][$dc_room_id];
                        }
                        $result_array['reservations'][$counter][$j]['reservation']['day_price'][$intdate] = (float) $daily_price['priceaftertax'];
                        //++$int_datein;

                        $dc_total_price += $daily_price['priceaftertax'];
                        ++$k;
                    }

                    $result_array['reservations'][$counter][$j]['guests'] = [];

                    $vcc_expiration_date = $reservation['customer']['vcc_expiration_date'];
                    $cc_expiration_date = $reservation['customer']['cc_expiration_date'];

                    $cc_exp_year = '';
                    $cc_exp_month = '';
                    //$cc_exp_day = '';

                    if ($vcc_expiration_date != '') {
                        list($cc_exp_year, $cc_exp_month, $cc_exp_day) = explode('-', $vcc_expiration_date);
                    } elseif ($cc_expiration_date != '') {
                        $cc_exp_year = substr($cc_expiration_date, 2);
                        $cc_exp_month = substr($cc_expiration_date, 0, 2);
                    }

                    $result_array['reservations'][$counter][$j]['dc_rate_id'] = $dc_rate_id;
                    $result_array['reservations'][$counter][$j]['reservation_notif_id'] = $reservation_notif_id;
                    $result_array['reservations'][$counter][$j]['currencycode'] = $reservation['currencycode'];

                    $result_array['reservations'][$counter][$j]['card']['cc_cvc'] = $reservation['customer']['cc_cvc'];

                    $result_array['reservations'][$counter][$j]['card']['ExpMonth'] = $cc_exp_month;
                    $result_array['reservations'][$counter][$j]['card']['ExpYear'] = $cc_exp_year;
                    $result_array['reservations'][$counter][$j]['card']['CardHolder'] = $reservation['customer']['cc_name'];
                    $result_array['reservations'][$counter][$j]['card']['CardNumber'] = $reservation['customer']['cc_number'];
                    $result_array['reservations'][$counter][$j]['card']['cc_type'] = $reservation['customer']['cc_type'];

                    $result_array['reservations'][$counter][$j]['guest']['address'] = $reservation['customer']['address'];
                    $result_array['reservations'][$counter][$j]['guest']['city'] = $reservation['customer']['city'];
                    if (($rooms_data[$j]['first_name'] == $reservation['customer']['first_name']) &&
                        ($rooms_data[$j]['last_name'] == $reservation['customer']['last_name'])) {
                        $result_array['reservations'][$counter][$j]['guest']['email'] = $reservation['customer']['email'];
                    } else {
                        $result_array['reservations'][$counter][$j]['guest']['email'] = '';
                    }
                    $result_array['reservations'][$counter][$j]['guest']['firstname'] = $rooms_data[$j]['first_name'];
                    $result_array['reservations'][$counter][$j]['guest']['lastname'] = $rooms_data[$j]['last_name'];
                    $result_array['reservations'][$counter][$j]['guest']['phone'] = $reservation['customer']['telephone'];
                    $result_array['reservations'][$counter][$j]['guest']['country'] = $reservation['customer']['countrycode'];
                    $result_array['reservations'][$counter][$j]['guest']['passportid'] = '';

                    $result_array['reservations'][$counter][$j]['status'] = $reservation['status'];
                    // $result_array ["reservations"] [$i] ["status"] = "cancelled";
                    $result_array['reservations'][$counter][$j]['dc_reservationid'] = $reservation['channel_booking_id'];

                    //$created_datetime = explode(" ", $reservation ["booked_at"]);
                    //$created_date = $created_datetime[0];
                    //$created_time = $created_datetime[1];

                    $result_array['reservations'][$counter][$j]['reservation']['dc_id'] = 40;

                    $result_array['reservations'][$counter][$j]['reservation']['commissionamount'] = $reservation['commissionamount'];
                    $result_array['reservations'][$counter][$j]['reservation']['date'] = $reservation['booked_at'];
                    $result_array['reservations'][$counter][$j]['reservation']['dc_reservationid'] = $reservation['channel_booking_id'];
                    $result_array['reservations'][$counter][$j]['reservation']['time'] = '';
                    $result_array['reservations'][$counter][$j]['reservation']['dc_date'] = $reservation['booked_at'];
                    $result_array['reservations'][$counter][$j]['reservation']['dc_time'] = '';

                    $result_array['reservations'][$counter][$j]['reservation']['dc_updatetime'] = $reservation['modified_at'];

                    $result_array['reservations'][$counter][$j]['reservation']['isNew'] = 1;

                    $result_array['reservations'][$counter][$j]['reservation']['datein'] = $datein;
                    $result_array['reservations'][$counter][$j]['reservation']['checkintime'] = '';

                    $result_array['reservations'][$counter][$j]['reservation']['dateout'] = $dateout;
                    $result_array['reservations'][$counter][$j]['reservation']['checkouttime'] = '';

                    $result_array['reservations'][$counter][$j]['reservation']['dc_roomreservation_id'] = $dc_roomreservation_id;
                    $result_array['reservations'][$counter][$j]['reservation']['dc_uuid'] = $reservation['booking_id'];
                    $result_array['reservations'][$counter][$j]['reservation']['category_id'] = $dc_room_id;
                    $result_array['reservations'][$counter][$j]['reservation']['reservation_type_name'] = '';
                    if (isset($categories[$dc_room_id])) {
                        if (isset($categories_names[$categories[$dc_room_id]])) {
                            $result_array['reservations'][$counter][$j]['reservation']['reservation_type_name'] = $categories_names[$categories[$dc_room_id]];
                        }
                    }

                    $result_array['reservations'][$counter][$j]['reservation']['placement_id'] = '';
                    $result_array['reservations'][$counter][$j]['reservation']['add_places'] = 0;
                    $result_array['reservations'][$counter][$j]['reservation']['baby_places'] = 0;
                    $result_array['reservations'][$counter][$j]['reservation']['amount'] = $dc_total_price;

                    $result_array['reservations'][$counter][$j]['reservation']['price_type'] = $price_type;

                    $result_array['reservations'][$counter][$j]['reservation']['description'] = '';
                    if (isset($_SESSION['user']['id'])) {
                        $result_array['reservations'][$counter][$j]['reservation']['user'] = $_SESSION['user']['id'];
                    } else {
                        $result_array['reservations'][$counter][$j]['reservation']['user'] = -1;
                    }

                    if (!isset($rates[$dc_rate_id][$dc_room_id])) {
                        $result_array['reservations'][$counter][$j]['reservation']['type_id'] = $overbooking_category_id;
                        $result_array['reservations'][$counter][$j]['reservation']['dc_type_id'] = $dc_room_id;
                    } else {
                        if (isset($categories[$dc_room_id])) {
                            $result_array['reservations'][$counter][$j]['reservation']['type_id'] = $categories[$dc_room_id];
                            $result_array['reservations'][$counter][$j]['reservation']['dc_type_id'] = $dc_room_id;
                        } else {
                            $result_array['reservations'][$counter][$j]['reservation']['type_id'] = 0;
                            $result_array['reservations'][$counter][$j]['reservation']['dc_type_id'] = 0;
                        }
                    }
                    $OTA_Code = $reservation['affiliation']['OTA_Code'];
                    $result_array['reservations'][$counter][$j]['reservation']['refferal_id'] = $OTA_Code;
                    $result_array['reservations'][$counter][$j]['reservation']['dc_source'] = $reservation['affiliation']['pos'];

                    $dealer = $this->dcm_su_api->get_su_dc_data($OTA_Code, 'dealer_id', 'int', $hms_property_id);

                    $result_array['reservations'][$counter][$j]['reservation']['dealer'] = $dealer;
                    $result_array['reservations'][$counter][$j]['reservation']['dc_guestname'] = $rooms_data[$j]['guest_name'];
                    $result_array['reservations'][$counter][$j]['reservation']['dc_numberofguest'] = $rooms_data[$j]['numberofguests'];
                    $result_array['reservations'][$counter][$j]['reservation']['adults'] = $rooms_data[$j]['numberofadults'];
                    $result_array['reservations'][$counter][$j]['reservation']['baby_places'] = $rooms_data[$j]['numberofchildren'];

                    $result_array['reservations'][$counter][$j]['reservation']['dc_countrycode'] = $reservation['customer']['countrycode'];
                    $result_array['reservations'][$counter][$j]['reservation']['dc_currencycode'] = $reservation['currencycode'];
                    $result_array['reservations'][$counter][$j]['reservation']['dc_city'] = $reservation['customer']['city'];
                    $result_array['reservations'][$counter][$j]['reservation']['dc_customerremarks'] = $rooms_data[$j]['specialrequest'];
                    $result_array['reservations'][$counter][$j]['reservation']['dc_roomremarks'] = '';
                    $result_array['reservations'][$counter][$j]['reservation']['description'] = $rooms_data[$j]['specialrequest'];

                    $result_array['reservations'][$counter][$j]['reservation']['dc_totalprice'] = $dc_total_price;

                    $result_array['reservations'][$counter][$j]['reservation']['smoking'] = '';

                    $result_array['reservations'][$counter][$j]['roomreservation_id'] = $dc_roomreservation_id;

                    //=============================================================================
                    $result_array['reservations'][$counter][$j]['reservation']['early_check_in_close'] = 0;
                    $result_array['reservations'][$counter][$j]['reservation']['late_check_out_close'] = 0;

                    if ($qty > 1) {
                        $result_array['reservations'][$counter][$j]['reservation']['groupid'] = $reservation['booking_id'];
                    }

                    /*
                     * ============ BOOKING SET INT GROUP ======================
                     *
                     */
                    if ($qty > 1) {
                        if ($create_intgroup_bool == 0) {
                            $group_name = 'PREMIUM-'.$reservation['booking_id'];
                            $intgroupid = $this->group_res_model->makenewid($group_name);
                            $create_intgroup_bool = 1;
                        }
                        $result_array['reservations'][$counter][$j]['reservation']['intgroupid'] = $intgroupid;
                    }

                    $addons_sum = 0;
                    $addon_inc = 0;
                    $services = [];
                    $result_array['reservations'][$counter][$j]['addons'] = [];
                    foreach ($rooms_data[$j]['addons'] as $addon) {
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['dc_uuid'] = $reservation['booking_id'].'_'.$dc_roomreservation_id;
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['name'] = $addon['name'];
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['nights'] = $addon['nights'];
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['persons'] = 0;
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['price_mode'] = $addon['pricemode'];
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['price_per_unit'] = $addon['priceperunit'];
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['totalprice'] = $addon['price'];
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['type'] = $addon_inc;
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['addons_date'] = '';
                        $addons_sum += $addon['price'];
                        ++$addon_inc;
                    }

                    foreach ($rooms_data[$j]['extracomponents'] as $addon) {
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['dc_uuid'] = $reservation['booking_id'].'_'.$dc_roomreservation_id;
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['name'] = $addon['name'];
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['nights'] = 1;
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['persons'] = 0;
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['price_mode'] = 1;
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['price_per_unit'] = $addon['value'];
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['totalprice'] = $addon['value'];
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['type'] = $addon_inc;
                        $result_array['reservations'][$counter][$j]['addons'][$addon_inc]['addons_date'] = '';
                        $addons_sum += $addon['value'];
                        ++$addon_inc;
                    }
                    $result_array['reservations'][$counter][$j]['reservation']['addons_sum'] = $addons_sum;
                    // =============================================================================
                }
                ++$counter;
            }
        }

        if ($this->debug) {
            echo '============ OTELMS ROOMS ========= ';
            echo '<br>';
            print_r($result_array);
            echo '<br>';
        }

        $host = '';
        if ($db_name != '') {
            $query = $this->db->query("SELECT host FROM visitka.config WHERE db_name LIKE '".$db_name."'");

            if ($query->num_rows() > 0) {
                $row = $query->row();
                $host = $row->host;
            }
        } else {
            if ($_SERVER['HTTP_HOST']) {
                $host = $_SERVER['HTTP_HOST'];
            }
        }

        $reservationpush = [];

        if (isset($result_array['reservations'])) {
            $k = 0;

            //$bool_cancel = 0;
            //$guest_array = [];
            //$guest_counter = 1;

            foreach ($result_array['reservations'] as $key => $reservations) {
                $dc_reservationid = $reservations[0]['reservation']['dc_reservationid'];
                //$dc_status = $reservations[0]['status'];
                $res_count = count($reservations);
                //$bool_guest = 0;
                $confirm_fail = 0;
                for ($i = 0; $i < $res_count; ++$i) {
                    $sql = "SELECT id, room_id FROM deskofreservation 
                        WHERE dc_updatetime = '{$reservations[$i]['reservation']['dc_updatetime']}' 
                        AND dc_id = 40 AND cancel=0 AND deleted = 0 
                        AND dc_uuid LIKE '{$reservations[$i]['reservation']['dc_uuid']}' 
                        AND dc_roomreservation_id = '{$reservations[$i]['reservation']['dc_roomreservation_id']}'
                        ORDER BY id DESC";

                    $query = $this->db->query($sql);
                    $hms_reservation_id = 0;
                    //$otelms_room_id = 0;
                    if ($query->num_rows() > 0) {
                        $row = $query->row();

                        if (isset($otelms_rooms[$dc_reservationid][$reservations[$i]['reservation']['dc_uuid']])) {
                            $otelms_rooms[$dc_reservationid][$reservations[$i]['reservation']['dc_uuid']]['status'] = 1;
                        }
                    }

                    if ($reservations[$i]['status'] == 'new') {
                        $sql = "SELECT id, room_id FROM deskofreservation 
                            WHERE dc_date = '{$reservations[$i]['reservation']['dc_date']}' 
                            AND dc_id = 40 AND dc_uuid LIKE '{$reservations[$i]['reservation']['dc_uuid']}' 
                            AND dc_roomreservation_id = '{$reservations[$i]['reservation']['dc_roomreservation_id']}' 
                            ORDER BY id DESC";

                        $query = $this->db->query($sql);
                        $hms_reservation_id = 0;
                        //$otelms_room_id = 0;
                        if ($query->num_rows() > 0) {
                            $row = $query->row();

                            if (isset($otelms_rooms[$dc_reservationid][$reservations[$i]['reservation']['dc_uuid']])) {
                                $otelms_rooms[$dc_reservationid][$reservations[$i]['reservation']['dc_uuid']]['status'] = 1;
                            }

                            $reservationpush[$k]['response'] = 'skip';
                            $reservationpush[$k]['status'] = 'skip';
                            $reservationpush[$k]['hms_reservation_id'] = $row->id;
                            $reservationpush[$k]['dc_reservationid'] = $dc_reservationid;
                            $reservationpush[$k]['dc_roomreservation_id'] = $reservations[$i]['reservation']['dc_roomreservation_id'];
                            $reservationpush[$k]['dc_source'] = $reservations[$i]['reservation']['dc_source'];
                            $result_array['reservations'][$key][$i]['status'] = 'skip';
                            ++$k;
                            // die();
                            continue;
                        }
                    }

                    //=========================================================================

                    $calculate_data = [];
                    $calculate_data['type_id'] = $reservations[$i]['reservation']['type_id'];
                    $calculate_data['datein'] = $reservations[$i]['reservation']['datein'];
                    $calculate_data['dateout'] = $reservations[$i]['reservation']['dateout'];
                    $calculate_data['add_places'] = $reservations[$i]['reservation']['add_places'];
                    $calculate_data['baby_places'] = $reservations[$i]['reservation']['baby_places'];
                    $calculate_data['addbedplace'] = 0;
                    $calculate_data['babyplace2'] = 0;
                    $calculate_data['price_type'] = $reservations[$i]['reservation']['price_type'];

                    $temp_amount = $this->frontdesk->getpricecalculation($calculate_data);
                    $otelms_amount = 0;
                    for ($p = 0; $p < count($temp_amount); ++$p) {
                        $otelms_amount += $temp_amount[$p]['amount'];
                    }
                    $booking_amount = $reservations[$i]['reservation']['amount'];
                    //$reservations [$i] ["reservation"] ["discount"] = 0;
                    if ($booking_amount != $otelms_amount) {
                        //if ($otelms_amount != 0) {
                        $reservations[$i]['reservation']['discount'] = $otelms_amount - $booking_amount;
                        //}
                    }

                    //=====================================================
                    //=====================================================
                    //=====================================================

                    $datein = $reservations[$i]['reservation']['datein'];
                    $dateout = $reservations[$i]['reservation']['dateout'];
                    $type_id = $reservations[$i]['reservation']['type_id'];
                    $sql = "SELECT id, room_id FROM deskofreservation 
                        WHERE dc_id = 40 AND cancel=0 AND deleted = 0 
                        AND dc_uuid LIKE '{$reservations[$i]['reservation']['dc_uuid']}' 
                        AND dc_roomreservation_id = {$reservations[$i]['reservation']['dc_roomreservation_id']} 
                        ORDER BY id DESC";
                    //echo $sql;
                    $query = $this->db->query($sql);
                    $hms_reservation_id = 0;
                    //$otelms_room_id = 0;
                    if ($query->num_rows() > 0) {
                        $row = $query->row();
                        $hms_reservation_id = $row->id;
                        //$otelms_room_id = $row->room_id;
                    }

                    if (isset($reservations[$i]['per_day'])) {
                        $this->dc_rate_intdate_insert($reservations[$i]['per_day']);
                    }

                    if ($reservations[$i]['status'] == 'cancelled') {
                        if (isset($otelms_rooms[$dc_reservationid][$reservations[$i]['reservation']['dc_uuid']])) {
                            $otelms_rooms[$dc_reservationid][$reservations[$i]['reservation']['dc_uuid']]['status'] = 1;
                        }
                        $query2 = $this->db->query("SELECT deskofreservation.datein, deskofreservation.dateout, rooms.category_id 
                            FROM deskofreservation 
                            INNER JOIN rooms ON rooms.id = deskofreservation.room_id 
                            WHERE dc_id = 40 AND deskofreservation.id = $hms_reservation_id");

                        if ($query2->num_rows() > 0) {
                            $row2 = $query2->row();
                            $datein = $row2->datein;
                            $dateout = $row2->dateout;
                            $type_id = $row2->category_id;
                        }

                        //$time2 = date('Y-m-d H:i:s');
                        $status = 5;
                        $query2 = $this->db->query('SELECT id FROM  services_main WHERE reservation_id = '.$hms_reservation_id.' AND type = 2');

                        if ($query2->num_rows() > 0) {
                            $reservationpush[$k]['response'] = 'failed';
                            $reservationpush[$k]['text'] = 'Already cancelled';
                            $reservationpush[$k]['dc_source'] = $reservations[$i]['dc_source'];
                            $reservationpush[$k]['status'] = 'cancel';

                            $reservationpush[$k]['hms_reservation_id'] = $hms_reservation_id;
                            $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['dc_reservationid'];
                            ++$k;

                            $dc_log_data = [];
                            $dc_log_data['datein'] = $datein;
                            $dc_log_data['dateout'] = $dateout;
                            $dc_log_data['category_id'] = $type_id;
                            $this->frontdesk->dc_log_update($dc_log_data);
                        } else {
                            $sql = 'SELECT id FROM deskofreservation WHERE id = '.$hms_reservation_id;
                            echo $sql;
                            $query2 = $this->db->query($sql);

                            if ($query2->num_rows() > 0) {
                                $data_cancel = [];

                                $data_cancel['res_id'] = $hms_reservation_id;
                                $data_cancel['charge'] = 0;
                                $data_cancel['status'] = 5;

                                $data_cancel['description'] = 'Cancelled at '.$reservations[$i]['reservation']['dc_source'];
                                $data_cancel['guestbe_request'] = 0;
                                $data_cancel['user'] = -1;
                                // ====================
                                $this->Cancel->Insert($data_cancel);
                                // ====================
                                $query2 = $this->db->query("UPDATE deskofreservation SET dc_updatetime = '".$reservations[$i]['reservation']['dc_updatetime']."' WHERE id = ".$hms_reservation_id);
                                $reservationpush[$k]['response'] = 'ok';
                                $reservationpush[$k]['text'] = '';
                                $reservationpush[$k]['status'] = 'cancel';
                                $reservationpush[$k]['hms_reservation_id'] = $hms_reservation_id;
                                $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['dc_reservationid'];
                                ++$k;
                            } else {
                                $confirm_fail = 0;
                                $reservationpush[$k]['response'] = 'failed';
                                $reservationpush[$k]['text'] = 'No reservation found';
                                $reservationpush[$k]['status'] = 'cancel';

                                $reservationpush[$k]['hms_reservation_id'] = 0;
                                $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['dc_reservationid'];
                                ++$k;
                            }
                        }
                    } else {
                        if ($hms_reservation_id == 0) {
                            /*
                             * NEW RESERVATION BLOCK
                             */

                            $room_id = 0;

                            if ($type_id == 0 or $type_id == '') {
                                $query2 = $this->db->query("SELECT int_value FROM  dc_su_xml_cfg WHERE name LIKE 'overbooking_category_id'");
                                if ($query->num_rows() > 0) {
                                    $row2 = $query2->row();
                                    $type_id = $row2->int_value;
                                }
                            }
                            if ($type_id == 0 or $type_id == '') {
                                $confirm_fail = 1;
                                $reservationpush[$k]['response'] = 'error';
                                $reservationpush[$k]['text'] = 'UNKNOWN CATEGORY';
                                $reservationpush[$k]['status'] = 'new';
                                $reservationpush[$k]['hms_reservation_id'] = 0;
                                $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['dc_reservationid'];
                                $result_array['reservations'][$key][$i]['status'] = 'new';
                                $result_array['reservations'][$key][$i]['reservation']['reservation_alert'] = $reservationpush[$k]['text'];
                                $result_array['reservations'][$key][$i]['reservation']['hms_reservation_id'] = $reservationpush[$k]['hms_reservation_id'];
                                $result_array['reservations'][$key][$i]['reservation']['url'] = 'https://'.$host.'/reservations/ReservationViewForm/'.$reservationpush[$k]['hms_reservation_id'];
                                ++$k;
                            } else {
                                $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $type_id, 0, 0, $reservations[$i]['reservation']['early_check_in_close'], $reservations[$i]['reservation']['late_check_out_close']);
                                if ($room_id == 0) {
                                    if (isset($overbooking_category_id)) {
                                        $reservations[$i]['reservation']['origin_categoryid'] = $type_id;
                                        $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $overbooking_category_id, 0, 0, $reservations[$i]['reservation']['early_check_in_close'], $reservations[$i]['reservation']['late_check_out_close']);

                                        //$insert_over_room_bool = 0;
                                        if ($room_id == 0) {
                                            $room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
                                            //$insert_over_room_bool = 1;
                                        }
                                    } else {
                                        $confirm_fail = 1;
                                        $reservationpush[$k]['response'] = 'failed';
                                        $reservationpush[$k]['text'] = 'no overbooking_category_id';
                                        $reservationpush[$k]['status'] = 'new';
                                        $reservationpush[$k]['hms_reservation_id'] = 0;
                                        $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['dc_reservationid'];
                                        $reservationpush[$k]['dc_room_id'] = $reservations[$i]['reservation']['category_id'];
                                        $result_array['reservations'][$key][$i]['status'] = 'new';
                                        $result_array['reservations'][$key][$i]['reservation']['reservation_alert'] = $reservationpush[$k]['text'];
                                        $result_array['reservations'][$key][$i]['reservation']['hms_reservation_id'] = $reservationpush[$k]['hms_reservation_id'];
                                        $result_array['reservations'][$key][$i]['reservation']['url'] = 'https://'.$host.'/reservations/ReservationViewForm/'.$reservationpush[$k]['hms_reservation_id'];
                                    }
                                }
                                $reservations[$i]['reservation']['room_id'] = $room_id;

                                //if ($bool_guest == 0) {
                                $guest_id = $this->frontdesk->Guest_insert($reservations[$i]['guest']);
                                //$bool_guest = 1;
                                //}

                                $calculate_data = [];
                                $calculate_data['type_id'] = $reservations[$i]['reservation']['type_id'];
                                $calculate_data['datein'] = $reservations[$i]['reservation']['datein'];
                                $calculate_data['dateout'] = $reservations[$i]['reservation']['dateout'];
                                $calculate_data['add_places'] = $reservations[$i]['reservation']['add_places'];
                                $calculate_data['baby_places'] = $reservations[$i]['reservation']['baby_places'];
                                if (isset($reservations[$i]['reservation']['adults'])) {
                                    $calculate_data['adults'] = $reservations[$i]['reservation']['adults'];
                                }

                                $calculate_data['addbedplace'] = 0;
                                $calculate_data['babyplace2'] = 0;
                                $calculate_data['price_type'] = $reservations[$i]['reservation']['price_type'];

                                $temp_amount = $this->frontdesk->getpricecalculation($calculate_data);
                                $otelms_amount = 0;
                                for ($inc = 0; $inc < count($temp_amount); ++$inc) {
                                    $otelms_amount += $temp_amount[$inc]['amount'];
                                }

                                $booking_amount = $reservations[$i]['reservation']['amount'];
                                $_sum = $reservations[$i]['reservation']['addons_sum']; // бути _sum

                                if ($otelms_amount != 0) {
                                    $reservations[$i]['reservation']['discount'] = $otelms_amount - ($booking_amount - $_sum);
                                    $reservations[$i]['reservation']['service_main_amount_2'] = 2;
                                }

                                //print_r($reservations [$i] ["reservation"]);
                                //die();
                                $hms_reservation_id = $this->frontdesk->Reservation_insert($reservations[$i]['reservation'], $guest_id, 0, 1);

                                if (isset($otelms_rooms[$dc_reservationid][$reservations[$i]['reservation']['dc_uuid']])) {
                                    $otelms_rooms[$dc_reservationid][$reservations[$i]['reservation']['dc_uuid']]['status'] = 1;
                                }

                                if (isset($reservations[$i]['card'])) {
                                    $this->frontdesk->insert_tbl_CreditCards($reservations[$i]['card'], $guest_id, $hms_reservation_id);
                                }

                                if ($hms_reservation_id > 0) {
                                    /*
                                     *  ==== ADD SERVICES ======
                                     */
                                    $this->del_addons($reservations[$i]['reservation']['dc_uuid']);
                                    $this->add_addons($reservations[$i]['addons'], $hms_reservation_id);
                                    /*
                                     * =========================
                                     */
                                    $reservationpush[$k]['response'] = 'ok';
                                    $reservationpush[$k]['text'] = '';
                                    $reservationpush[$k]['status'] = 'new';
                                    $reservationpush[$k]['hms_reservation_id'] = $hms_reservation_id;
                                    $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['dc_reservationid'];
                                    $reservationpush[$k]['dc_room_id'] = $reservations[$i]['reservation']['category_id'];
                                    $reservationpush[$k]['dc_source'] = $reservations[$i]['reservation']['dc_source'];
                                    $result_array['reservations'][$key][$i]['status'] = 'new';
                                    $result_array['reservations'][$key][$i]['reservation']['reservation_alert'] = $reservationpush[$k]['text'];
                                    $result_array['reservations'][$key][$i]['reservation']['hms_reservation_id'] = $reservationpush[$k]['hms_reservation_id'];
                                    $result_array['reservations'][$key][$i]['reservation']['url'] = 'https://'.$host.'/reservations/ReservationViewForm/'.$reservationpush[$k]['hms_reservation_id'];
                                    ++$k;
                                } else {
                                    $confirm_fail = 1;
                                    $reservationpush[$k]['response'] = 'failed';
                                    $reservationpush[$k]['text'] = 'undferror';
                                    $reservationpush[$k]['status'] = 'new';
                                    $reservationpush[$k]['hms_reservation_id'] = 0;
                                    $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['dc_reservationid'];
                                    $reservationpush[$k]['dc_room_id'] = $reservations[$i]['reservation']['category_id'];
                                    $reservationpush[$k]['dc_source'] = $reservations[$i]['reservation']['dc_source'];
                                    $result_array['reservations'][$key][$i]['status'] = 'new';
                                    $result_array['reservations'][$key][$i]['reservation']['reservation_alert'] = $reservationpush[$k]['text'];
                                    $result_array['reservations'][$key][$i]['reservation']['hms_reservation_id'] = $reservationpush[$k]['hms_reservation_id'];
                                    $result_array['reservations'][$key][$i]['reservation']['url'] = 'https://'.$host.'/reservations/ReservationViewForm/'.$reservationpush[$k]['hms_reservation_id'];
                                    ++$k;
                                }
                            }
                        } else {
                            /*
                             * UPDATE RESERVATION BLOCK
                             *
                             */

                            $reservation_data = $this->frontdesk->GetReservation($hms_reservation_id);

                            //$reservation_data ["user"] = $xml_array ["reservations"] [$dc_reservationid] ["room"] [$cell ["dc_roomreservation_id"]] ["reservation"] ["user"];
                            $reservation_data['firstname'] = $reservations[$i]['guest']['firstname'];
                            $reservation_data['lastname'] = $reservations[$i]['guest']['lastname'];
                            $reservation_data['phone'] = $reservations[$i]['guest']['phone'];
                            $reservation_data['email'] = $reservations[$i]['guest']['email'];

                            $reservation_data['amount'] = $reservations[$i]['reservation']['amount'];
                            $reservation_data['discount'] = $reservations[$i]['reservation']['discount'];
                            $reservation_data['date'] = $reservations[$i]['reservation']['date'];
                            $reservation_data['add_places'] = $reservations[$i]['reservation']['add_places'];
                            $reservation_data['baby_places'] = $reservations[$i]['reservation']['baby_places'];
                            $reservation_data['datein'] = $reservations[$i]['reservation']['datein'];
                            $reservation_data['dateout'] = $reservations[$i]['reservation']['dateout'];
                            $reservation_data['checkintime'] = $reservations[$i]['reservation']['checkintime'];
                            $reservation_data['checkouttime'] = $reservations[$i]['reservation']['checkouttime'];

                            //$reservation_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
                            $reservation_data['price_type'] = $reservations[$i]['reservation']['price_type'];
                            $reservation_data['guest_id_new'] = 0;
                            $reservation_data['free_places'] = 0;
                            $reservation_data['maid_description'] = '';
                            $reservation_data['isread'] = 0;
                            $reservation_data['dc_guestname'] = $reservations[$i]['reservation']['dc_guestname'];
                            $reservation_data['dc_currencycode'] = $reservations[$i]['reservation']['dc_currencycode'];
                            $reservation_data['dc_countrycode'] = $reservations[$i]['reservation']['dc_countrycode'];
                            $reservation_data['dc_city'] = $reservations[$i]['reservation']['dc_city'];
                            $reservation_data['dc_customerremarks'] = $reservations[$i]['reservation']['dc_customerremarks'];
                            $reservation_data['dc_roomremarks'] = $reservations[$i]['reservation']['dc_roomremarks'];
                            $reservation_data['dc_numberofguest'] = $reservations[$i]['reservation']['dc_numberofguest'];
                            $reservation_data['dc_totalprice'] = $reservations[$i]['reservation']['dc_totalprice'];
                            $reservation_data['smoking'] = $reservations[$i]['reservation']['smoking'];

                            $reservation_data['description'] = $reservations[$i]['reservation']['dc_customerremarks'];

                            $reservation_data['dc_date'] = $reservations[$i]['reservation']['dc_date'];
                            $reservation_data['dc_time'] = $reservations[$i]['reservation']['dc_time'];
                            $reservation_data['dc_updatetime'] = $reservations[$i]['reservation']['dc_updatetime'];

                            $reservation_data['early_check_in_close'] = $reservations[$i]['reservation']['early_check_in_close'];
                            $reservation_data['late_check_out_close'] = $reservations[$i]['reservation']['late_check_out_close'];

                            //=============================================================================
                            if ($autoclosedaychicho == 1) {
                                $str_checkintime = strtotime($reservations[$i]['reservation']['checkintime']);
                                $str_checkouttime = strtotime($reservations[$i]['reservation']['checkouttime']);

                                $system_checkouttime = strtotime($checkin_checkout_arr['checkouttime']);
                                $system_checkintime = strtotime($checkin_checkout_arr['checkintime']);

                                if ($str_checkintime < $system_checkouttime) {
                                    $reservation_data['early_check_in_close'] = 1;
                                }
                                if ($str_checkouttime > $system_checkouttime) {
                                    $reservation_data['late_check_out_close'] = 1;
                                }
                            }
                            //=============================================================================
                            // print_r($reservation_data);

                            if ($reservation_data['type_id'] == $type_id) {
                                $can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout, $reservation_data['early_check_in_close'], $reservation_data['late_check_out_close']);
                            } else {
                                $can_resize = 0;
                                $reservation_data['type_id'] = $type_id;
                            }

                            //$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );

                            if ($can_resize == 1) {
                                $this->service_model->DeleteServicesDc($hms_reservation_id);
                                $update_res = $this->frontdesk->UpdateReservation($reservation_data, 0, 1);

                                if (isset($otelms_rooms[$dc_reservationid][$reservations[$i]['reservation']['dc_uuid']])) {
                                    $otelms_rooms[$dc_reservationid][$reservations[$i]['reservation']['dc_uuid']]['status'] = 1;
                                }
                                if ($update_res == 'FreeError') {
                                    $confirm_fail = 1;
                                    $reservationpush[$k]['response'] = 'error';
                                    $reservationpush[$k]['text'] = '';
                                    $reservationpush[$k]['status'] = 'modified';
                                    $reservationpush[$k]['hms_reservation_id'] = $hms_reservation_id;
                                    $reservationpush[$k]['dc_source'] = $reservations[$i]['reservation']['dc_source'];
                                    $result_array['reservations'][$key][$i]['reservation']['reservation_alert'] = '';
                                    $result_array['reservations'][$key][$i]['status'] = 'modified';
                                    $result_array['reservations'][$key][$i]['reservation']['hms_reservation_id'] = $reservationpush[$k]['hms_reservation_id'];
                                    $result_array['reservations'][$key][$i]['reservation']['url'] = 'https://'.$host.'/reservations/ReservationViewForm/'.$reservationpush[$k]['hms_reservation_id'];
                                    $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['reservation']['dc_reservationid'];
                                    ++$k;
                                } else {
                                    /*
                                     *  ==== ADD SERVICES ======
                                     */
                                    $this->del_addons($dc_roomreservation_id);
                                    $this->add_addons($reservations[$i]['addons'], $hms_reservation_id, $services_types_dc);
                                    /*
                                     * =========================
                                     */
                                    $reservationpush[$k]['response'] = 'ok';
                                    $reservationpush[$k]['text'] = '';
                                    $reservationpush[$k]['alert'] = '';
                                    $reservationpush[$k]['status'] = 'modified';
                                    $reservationpush[$k]['hms_reservation_id'] = $hms_reservation_id;
                                    $reservationpush[$k]['dc_source'] = $reservations[$i]['reservation']['dc_source'];
                                    $result_array['reservations'][$key][$i]['reservation']['reservation_alert'] = '';
                                    $result_array['reservations'][$key][$i]['status'] = 'modified';
                                    $result_array['reservations'][$key][$i]['reservation']['hms_reservation_id'] = $reservationpush[$k]['hms_reservation_id'];
                                    $result_array['reservations'][$key][$i]['reservation']['url'] = 'https://'.$host.'/reservations/ReservationViewForm/'.$reservationpush[$k]['hms_reservation_id'];
                                    $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['reservation']['dc_reservationid'];
                                    ++$k;
                                }
                            } else {
                                if ($type_id == 0 or $type_id == '') {
                                    $query2 = $this->db->query("SELECT int_value FROM  dc_su_xml_cfg WHERE name LIKE 'overbooking_category_id'");
                                    if ($query->num_rows() > 0) {
                                        $row2 = $query2->row();
                                        $type_id = $row2->int_value;
                                    }
                                }
                                if ($type_id == 0 or $type_id == '') {
                                    $confirm_fail = 1;
                                    $reservationpush[$k]['response'] = 'error';
                                    $reservationpush[$k]['text'] = 'UNKNOWN CATEGORY';
                                    $reservationpush[$k]['status'] = 'modified';
                                    $reservationpush[$k]['hms_reservation_id'] = $row->id;
                                    $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['dc_reservationid'];
                                    $reservationpush[$k]['dc_source'] = $reservations[$i]['reservation']['dc_source'];
                                    $result_array['reservations'][$key][$i]['status'] = 'modified';
                                    $result_array['reservations'][$key][$i]['reservation']['reservation_alert'] = $reservationpush[$k]['text'];
                                    $result_array['reservations'][$key][$i]['reservation']['hms_reservation_id'] = $reservationpush[$k]['hms_reservation_id'];
                                    $result_array['reservations'][$key][$i]['reservation']['url'] = 'https://'.$host.'/reservations/ReservationViewForm/'.$reservationpush[$k]['hms_reservation_id'];
                                    ++$k;
                                } else {
                                    $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $type_id, 0, 0, $reservation_data['early_check_in_close'], $reservation_data['late_check_out_close']);
                                    if ($room_id == 0) {
                                        if (isset($overbooking_category_id)) {
                                            $reservations[$i]['reservation']['origin_categoryid'] = $type_id;
                                            $room_id = $this->frontdesk->getfreeroomlist($datein, $dateout, $overbooking_category_id, 0, 0, $reservation_data['early_check_in_close'], $reservation_data['late_check_out_close']);

                                            //$insert_over_room_bool = 0;
                                            if ($room_id == 0) {
                                                $room_id = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
                                                // $insert_over_room_bool = 1;
                                            }
                                        } else {
                                            $confirm_fail = 1;
                                            $reservationpush[$k]['response'] = 'failed';
                                            $reservationpush[$k]['text'] = 'no overbooking_category_id';
                                            $reservationpush[$k]['status'] = 'new';
                                            $reservationpush[$k]['hms_reservation_id'] = 0;
                                            $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['dc_reservationid'];
                                            $reservationpush[$k]['dc_room_id'] = $reservations[$i]['reservation']['category_id'];
                                            $reservationpush[$k]['dc_source'] = $reservations[$i]['reservation']['dc_source'];
                                            $result_array['reservations'][$key][$i]['status'] = 'new';
                                            $result_array['reservations'][$key][$i]['reservation']['reservation_alert'] = $reservationpush[$k]['text'];
                                            $result_array['reservations'][$key][$i]['reservation']['hms_reservation_id'] = $reservationpush[$k]['hms_reservation_id'];
                                            $result_array['reservations'][$key][$i]['reservation']['url'] = 'https://'.$host.'/reservations/ReservationViewForm/'.$reservationpush[$k]['hms_reservation_id'];
                                        }
                                    }
                                    $reservation_data['room_id'] = $room_id;

                                    $this->service_model->DeleteServicesDc($hms_reservation_id);
                                    $update_res = $this->frontdesk->UpdateReservation($reservation_data, 0, 1);

                                    if (isset($otelms_rooms[$dc_reservationid][$reservations[$i]['reservation']['dc_uuid']])) {
                                        $otelms_rooms[$dc_reservationid][$reservations[$i]['reservation']['dc_uuid']]['status'] = 1;
                                    }

                                    if ($update_res == 'FreeError') {
                                        $confirm_fail = 1;
                                        $reservationpush[$k]['response'] = 'error';
                                        $reservationpush[$k]['text'] = '';
                                        $reservationpush[$k]['status'] = 'modified';
                                        $reservationpush[$k]['hms_reservation_id'] = $hms_reservation_id;
                                        $reservationpush[$k]['dc_source'] = $reservations[$i]['reservation']['dc_source'];
                                        $result_array['reservations'][$key][$i]['status'] = 'modified';
                                        $result_array['reservations'][$key][$i]['reservation']['reservation_alert'] = '';
                                        $result_array['reservations'][$key][$i]['reservation']['hms_reservation_id'] = $reservationpush[$k]['hms_reservation_id'];
                                        $result_array['reservations'][$key][$i]['reservation']['url'] = 'https://'.$host.'/reservations/ReservationViewForm/'.$reservationpush[$k]['hms_reservation_id'];
                                        $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['reservation']['dc_reservationid'];
                                        ++$k;
                                    } else {
                                        $reservationpush[$k]['response'] = 'ok';
                                        $reservationpush[$k]['text'] = '';
                                        $reservationpush[$k]['alert'] = '';
                                        $reservationpush[$k]['status'] = 'modified';
                                        $reservationpush[$k]['hms_reservation_id'] = $hms_reservation_id;
                                        $reservationpush[$k]['dc_source'] = $reservations[$i]['reservation']['dc_source'];
                                        $result_array['reservations'][$key][$i]['status'] = 'modified';
                                        $result_array['reservations'][$key][$i]['reservation']['reservation_alert'] = '';
                                        $result_array['reservations'][$key][$i]['reservation']['hms_reservation_id'] = $reservationpush[$k]['hms_reservation_id'];
                                        $result_array['reservations'][$key][$i]['reservation']['url'] = 'https://'.$host.'/reservations/ReservationViewForm/'.$reservationpush[$k]['hms_reservation_id'];
                                        $reservationpush[$k]['dc_reservationid'] = $reservations[$i]['reservation']['dc_reservationid'];
                                        ++$k;
                                    }
                                }
                            }
                        }
                    }
                    // }
                }

                if ($this->debug) {
                    echo '============ OTELMS ROOMS ========= ';
                    echo '<br>';
                    print_r($otelms_rooms);
                    echo '<br>';
                }

                if (isset($otelms_rooms[$dc_reservationid])) {
                    foreach ($otelms_rooms[$dc_reservationid] as $cell) {
                        if ($cell['status'] == 0) {
                            // $this->frontdesk->DeleteReservation($cell["otelms_reservation_id"]);
                            $status = 5;
                            $data_cancel = [];
                            $data_cancel['res_id'] = $cell['otelms_reservation_id'];
                            $data_cancel['charge'] = 0;
                            $data_cancel['status'] = $status;
                            $data_cancel['description'] = 'cancel at '.$reservations[0]['reservation']['dc_source'];
                            $data_cancel['guestbe_request'] = 0;
                            $data_cancel['user'] = -1;
                            // ====================
                            $this->Cancel->Insert($data_cancel);
                        }
                    }
                }
                if ($confirm_fail == 0) {
                    $confirm_data = [
                        'debug' => 1,
                        'dc_hotel_id' => $dc_reservation[$key]['dc_hotel_id'],
                        'reservation_notif_id' => $dc_reservation[$key]['reservation_notif_id'],
                    ];
                    $this->confirm_booking($confirm_data);
                }
            }

            //print_r ( $result_array );
            //print_r ( $otelms_rooms );
            //die();

            $hotel_name = '';
            $query = $this->db->query('SELECT * FROM logo');
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hotel_name = stripslashes($row->logo_title);
            }
            //die();
            $counter_r = 0;
            $new_mass = [];
            foreach ($result_array['reservations'] as $cell) {
                //print_r($cell);
                $res_count = count($cell);
                //echo "+++++++++++++++++++++++".$res_count;
                for ($i = 0; $i < $res_count; ++$i) {
                    if ($cell[$i]['status'] == 'modified' or $cell[$i]['status'] == 'new') {
                        $new_mass['dcname'] = $cell[$i]['reservation']['dc_source'];
                        $new_mass['status'] = $cell[$i]['status'];
                        $new_mass['dc_reservationid'] = $cell[$i]['reservation']['dc_reservationid'];
                        $new_mass['dc_channel_name'] = $cell[$i]['reservation']['dc_source'];
                        $new_mass['hotel_name'] = $hotel_name;
                        $new_mass['guest_firstname'] = $cell[$i]['guest']['firstname'];
                        $new_mass['guest_lastname'] = $cell[$i]['guest']['lastname'];
                        $new_mass['guest_phone'] = $cell[$i]['guest']['phone'];
                        $new_mass['guest_email'] = $cell[$i]['guest']['email'];

                        $new_mass['room'][$counter_r]['reservation_current'] = $i;
                        $new_mass['room'][$counter_r]['reservation_alert'] = $cell[$i]['reservation']['reservation_alert'];
                        $new_mass['room'][$counter_r]['hms_reservation_id'] = $cell[$i]['reservation']['hms_reservation_id'];
                        $new_mass['room'][$counter_r]['url'] = $cell[$i]['reservation']['url'];
                        $new_mass['room'][$counter_r]['dc_channel_name'] = $cell[$i]['reservation']['dc_source'];

                        $new_mass['room'][$counter_r]['reservation_dc_reservationid'] = $cell[$i]['reservation']['dc_reservationid'];
                        $new_mass['room'][$counter_r]['reservation_dc_roomreservation_id'] = $cell[$i]['reservation']['dc_roomreservation_id'];
                        $new_mass['room'][$counter_r]['hotel_name'] = 'hotel_name';
                        $new_mass['room'][$counter_r]['reservation_date'] = $cell[$i]['reservation']['date'];
                        $new_mass['room'][$counter_r]['status'] = $cell[$i]['status'];
                        $new_mass['room'][$counter_r]['reservation_datein'] = $cell[$i]['reservation']['datein'];
                        $new_mass['room'][$counter_r]['reservation_dateout'] = $cell[$i]['reservation']['dateout'];
                        $new_mass['room'][$counter_r]['reservation_type_name'] = $cell[$i]['reservation']['reservation_type_name'];
                        $new_mass['room'][$counter_r]['reservation_category_id'] = $cell[$i]['reservation']['type_id'];
                        $new_mass['room'][$counter_r]['reservation_dc_totalprice'] = $cell[$i]['reservation']['dc_totalprice'];
                        $new_mass['room'][$counter_r]['reservation_dc_customerremarks'] = $cell[$i]['reservation']['dc_customerremarks'];

                        $new_mass['room'][$counter_r]['dc_rate_intdate_data'] = $cell[$i]['per_day'];
                        //$max_key = max(array_keys($new_mass['room'][$counter_r]['dc_rate_intdate_data']));
                        //$intdate_temp = $max_key;

                        ++$counter_r;
                    }
                }
            }
            if (count($new_mass) > 0) {
                if ($this->debug) {
                    print_r($new_mass);
                }

                $this->dc_model->send_notifyarray_new($new_mass);
            }
        }

        if ($this->debug) {
            echo '<pre>';
            echo "\n\n --- XML reservationpush START --- \n\n";
            print_r($reservationpush);
            echo "\n\n --- XML reservationpush END --- \n\n";
        }

        foreach ($reservationpush as $arg) {
            if ($arg['status'] == 'cancel') {
                $data = [];
                $data['hms_reservation_id'] = $arg['hms_reservation_id'];
                $data['response'] = $arg['response'];
                $data['resid'] = $arg['dc_reservationid'];
                $data['dcname'] = $reservations[$i]['reservation']['dc_source'];
                $data['status'] = $arg['status'];
                $data['text'] = $arg['text'];
                $data['dc_source'] = $reservations[$i]['reservation']['dc_source'];
                $this->dc_model->send_notifyarray($data);
            }
        }

        return json_encode($reservationpush, true);
    }

    public function dc_rate_intdate_insert($data)
    {
        $count = count($data);
        if ($count != 0) {
            foreach ($data as $cell) {
                $query = $this->db->query("DELETE FROM dc_su_rate_intdate WHERE dc_reservation_id LIKE '".$cell['dc_reservation_id']."'");
                break;
            }
            foreach ($data as $cell) {
                $sql = "INSERT INTO dc_su_rate_intdate (dc_reservation_id, dc_rate_id, intdate, price) VALUES('".$cell['dc_reservation_id']."',
		'".$cell['dc_rate_id']."', '".$cell['intdate']."', '".$cell['price']."')
		ON DUPLICATE KEY UPDATE price = '".$cell['price']."'";
                // echo $sql;
                $query = $this->db->query($sql);
            }
        }
    }

    public function add_addons($data, $reservation_id = 0)
    {
        if( empty($data) ){
            return false;
        }

        foreach ($data as $addons) {
            print_r($addons);
            $this->db->where('dc_uuid', $addons['dc_uuid']);
            $this->db->delete('dc_su_addons');
            break;
        }
        $dealer = $data[0]['dealer'];

        foreach ($data as $addons) {
            unset( $addons['dealer'] );
            $this->db->insert('dc_su_addons', $addons);
            if ($reservation_id != 0) {
                $data_services = [];
                $data_services['dc_addons'] = 1;
                $data_services['res_id'] = $reservation_id;
                $data_services['dealer'] = $dealer;

                $query = $this->db->query('SELECT id FROM partners WHERE isdefault = 1');

                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $data_services['partner'] = $row->id;
                }

                $data_services['price'] = $addons['price_per_unit'];
                $data_services['amount'] = $addons['totalprice'];
                $data_services['description'] = $addons['name'];
                $data_services['count'] = $addons['nights'];
                $data_services['addons_date'] = $addons['addons_date'];
                $data_services['type'] = $addons['type'];
                if ($data_services['type'] != 0 && $data_services['type'] != '') {
                    $this->service_model->Insert_Service($data_services, 1);
                }
            }
        }
    }

    public function del_addons($dc_roomreservation_id)
    {
        $this->db->where('dc_uuid', $dc_roomreservation_id);
        $this->db->delete('dc_su_addons');
    }

    public function property_update($data)
    {
        $return_data = [];
        $su_property_id = $data['su_property_id'];
        $property_id = $this->dcm_su->get_hms_prop_id_by_su_prop_id($su_property_id);
        $data_property = ['property_id' => $property_id, 'status' => 'update'];
        $update_result = $this->dcm_su->create_update_property($data_property);
        //echo "<pre>";
        //print_r($update_result);
        if (isset($data['get_result'])) {
            $return_data['create_property_result'] = $update_result;
        }

        if (isset($update_result['curl_response']['Status'])) {
            if (isset($data['get_result'])) {
                $return_data['create_status'] = $update_result['curl_response']['Status'];
            }
            if ($update_result['curl_response']['Status'] == 'Success') {
                $this->dcm_su->update_su_properties_cfg(['su_property_id' => $update_result['su_property_id']]);
            } else {
                if ($update_result['curl_response']['Status'] == 'Fail') {
                    if (isset($update_result['curl_response']['Errors']['ShortText'])) {
                        if ($update_result['curl_response']['Errors']['ShortText'] == 'Property already exists') {
                            $this->dcm_su->update_su_properties_cfg([
                                'su_property_id' => $update_result['su_property_id'],
                            ]);
                        }
                    }
                }
            }
        }

        return $return_data;
    }

    public function property_create($data)
    {
        $return_data = [];
        $property_id = $data['property_id'];
        $create_update_data = ['property_id' => $property_id, 'status' => 'create'];
        $create_result = $this->dcm_su->create_update_property($create_update_data);
        echo '<pre>';
        print_r($create_result);
        echo '<br>';
        //die();
        if (isset($data['get_result'])) {
            $return_data['create_property_result'] = $create_result;
        }
        if (isset($create_result['curl_response']['Status'])) {
            if (isset($data['get_result'])) {
                $return_data['create_status'] = $create_result['curl_response']['Status'];
            }
            if ($create_result['curl_response']['Status'] == 'Success') {
                $this->dcm_su->update_su_properties_cfg(['su_property_id' => $create_result['su_property_id']]);
                $su_prop_id = $create_result['su_property_id'];
                $property_validate_status = $this->dcm_su->validate_su_property_id(['su_property_id' => $su_prop_id]);

                if ($property_validate_status) {
                    if (!$this->dcm_su->property_already_binded(['su_property_id' => $su_prop_id])) {
                        $this->dcm_su->bind_properties(['hms_property_id' => $property_id, 'su_property_id' => $su_prop_id]);
                    } else {
                        if ($this->debug) {
                            echo '<pre>';
                            exit("Property $su_prop_id allready binded!<br>");
                        }
                    }
                }
            } else {
                if ($create_result['curl_response']['Status'] == 'Fail') {
                    if (isset($create_result['curl_response']['Errors']['ShortText'])) {
                        if ($create_result['curl_response']['Errors']['ShortText'] == 'Property already exists') {
                            $this->dcm_su->update_su_properties_cfg(['su_property_id' => $create_result['su_property_id']]);
                            $su_prop_id = $create_result['su_property_id'];
                            $property_validate_status = $this->dcm_su->validate_su_property_id(['su_property_id' => $su_prop_id]);
                            //                             echo "----$su_prop_id++".$property_validate_status."====";
                            //                             die();
                            if ($property_validate_status) {
                                if (!$this->dcm_su->property_already_binded(['su_property_id' => $su_prop_id])) {
                                    $this->dcm_su->bind_properties(['hms_property_id' => $property_id, 'su_property_id' => $su_prop_id]);
                                } else {
                                    if ($this->debug) {
                                        echo '<pre>';
                                        exit("Property $su_prop_id allready binded!<br>");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        return $return_data;
    }
}
