<?php 
class dcm_hostelworld_v2 extends dcm_abstract {
    public function __construct() {
        parent::__construct();
        
        $this->dc_id = 8;
        $this->overbooking_category_id = $this->get_dc_overbooking_category_id();
        
        $this->table_name_r2c = "dc_hostelworld_rate2category_link";
        $this->table_name_dc_category2occupancy = "dc_hostelworld_category2occupancy";
        $this->table_name_dc2hms_category_link = "dc_hostelworld_room_categories_link";
        
        $this->sql_category2rate = "SELECT dc_hostelworld_rate2category_link.*, dc_hostelworld_rates.name as dc_rate_name,
		dc_hostelworld_room_categories_link.displayname as dc_category_name, dc_hostelworld_occupancy.name as hms_occupancy_name,
    	dc_hostelworld_rates.active, categories.name as hms_category_name, categories.id as hms_category_id 
    	FROM  dc_hostelworld_rate2category_link
    	INNER JOIN dc_hostelworld_rates ON dc_hostelworld_rate2category_link.dc_rate_id = dc_hostelworld_rates.dc_rate_id
    	INNER JOIN dc_hostelworld_room_categories_link ON dc_hostelworld_room_categories_link.dc_category_id = dc_hostelworld_rate2category_link.dc_category_id
    	INNER JOIN dc_hostelworld_occupancy ON dc_hostelworld_occupancy.id = dc_hostelworld_rate2category_link.hms_occupancy_id
    	INNER JOIN categories ON categories.id = dc_hostelworld_room_categories_link.hms_category_id";
        
        $this->sql_dc_rates = "select  dc_rate_id as dc_rate_id, name as dc_rate_name, active from dc_hostelworld_rates";
        $this->sql_dc_category_link = "select dc_hostelworld_room_categories_link.displayname as dc_category_name, categories.name as hms_category_name,
            dc_hostelworld_room_categories_link.dc_category_id,
            hms_category_id as hms_category_id
            from dc_hostelworld_room_categories_link 
            LEFT join categories on categories.id = dc_hostelworld_room_categories_link.hms_category_id";
        $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id
            from dc_hostelworld_rate2category_link";
        
       /* $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name from dc_hostelworld_occupancy ORDER BY id ASC";
          */
        
        $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name from dc_hostelworld_occupancy ORDER BY id ASC";
        
        $this->sql_get_category_occupancies = "SELECT dc_hostelworld_category2occupancy.hms_occupancy_id,
        dc_hostelworld_category2occupancy.dc_category_id as roomcategory, dc_hostelworld_occupancy.name as hms_occupancy_name 
        FROM dc_hostelworld_category2occupancy
        INNER JOIN dc_hostelworld_occupancy ON dc_hostelworld_occupancy.id = dc_hostelworld_category2occupancy.hms_occupancy_id";
        
        $this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories";
        
        $this->sql_dc_category_list = "select displayname as dc_category_name,
            dc_category_id, active from dc_hostelworld_room_categories_link";
        $this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_hostelworld_category2occupancy";
        $this->form_action_c2o_post = "/dc_hostelworld/categories_edit_post_v2";
        $this->form_action_r2c_post = "/dc_hostelworld/rates_edit_post_v2";
        
        $this->form_action_c2o_post_c2 = "/dc_hostelworld_c2/categories_edit_post_v2";
        $this->form_action_r2c_post_c2 = "/dc_hostelworld_c2/rates_edit_post_v2";
    }
    
    function category2occupancy_save_hostelworld($c2o)
    {
    	$this->db->query("delete from " . $this->table_name_dc_category2occupancy);
    	foreach ($c2o as $dc_category_id => $cell) {
    		$sql = "insert into " . $this->table_name_dc2hms_category_link . "  (dc_category_id, hms_category_id) values
    		($dc_category_id, " . $cell['hms_category_id'] . ") on duplicate key update
                hms_category_id=" . $cell['hms_category_id'] . " ";
    		// echo $sql . "\n";
    		$this->db->query($sql);
    		if (isset($cell['occupancies'])) {
    			foreach ($cell['occupancies'] as $key => $state) {
    				$sql = "insert into " . $this->table_name_dc_category2occupancy . " (dc_category_id, hms_occupancy_id)
                    values (" . $dc_category_id . ", " . $key . ") on duplicate key update
                        dc_category_id = " . $dc_category_id . ", hms_occupancy_id = " . $key . "";
    				$this->db->query($sql);
    			}
    		}
    	}
    }
}
?>